/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.layout;

import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.ExchangeHandler;
import com.adventnet.sym.adsm.common.server.delegation.workflow.WFRequesterUtil;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.model.DirectoryObject;
import com.adventnet.sym.adsm.common.server.model.TreeObject;
import com.adventnet.sym.adsm.common.server.reports.GroupHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DomainUtil;
import com.adventnet.sym.adsm.common.server.util.HelpdeskUtil;
import com.adventnet.sym.adsm.common.server.util.OUUtil;
import com.adventnet.sym.adsm.common.server.util.UpdateObjectUtil;
import com.adventnet.sym.adsm.common.server.workflow.WorkFlowUserHandler;
import com.adventnet.sym.adsm.common.webclient.tree.DirectoryObjectTreeModel;
import com.adventnet.sym.adsm.common.webclient.tree.DirectoryObjectTreeNode;
import com.adventnet.sym.adsm.common.webclient.util.ClientAuthorizationUtil;
import com.adventnet.sym.adsm.common.webclient.util.DirectoryObjectUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;
import org.json.JSONArray;
import org.json.JSONObject;

public class FcPopupInputSelection
extends DispatchAction {
    public ActionForward selectContainer(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("selectContainerPopUp");
    }

    public ActionForward getADObjects(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = null;
        try {
            String nodeClickedClone;
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            String nodeClicked = request.getParameter("container");
            rb = ResourceBundleMgr.getInstance().getBundle(request.getLocale());
            String domainName = request.getParameter("domainName");
            Properties selectedDomain = null;
            if (domainName == null) {
                selectedDomain = HDTDomainHandler.getSelectedDomain((Long)loginId);
                domainName = selectedDomain.getProperty("DOMAIN_NAME");
            } else {
                selectedDomain = HDTDomainHandler.getConfiguredValues((String)domainName, (Long)loginId);
            }
            String domainPath = selectedDomain.getProperty("DEFAULT_NAMING_CONTEXT");
            boolean isWorkflow = false;
            if (request.getParameter("isWorkFlow") != null) {
                isWorkflow = new Boolean(request.getParameter("isWorkFlow"));
            }
            ArrayList ouList = null;
            if (!isWorkflow) {
                ouList = ClientAuthorizationUtil.getAuthorizedOUList(request, domainName);
            } else {
                ouList = WorkFlowUserHandler.isRequester((Long)loginId) != false ? WFRequesterUtil.getEscapedOUDNList((String)domainName, (Long)loginId) : HelpdeskUtil.getEscapedOUDNList((String)domainName, (Long)loginId);
                Criteria c = null;
                c = OUUtil.getOUCriteriaWithEndsWITH((String)"ADSMOUDetails", (ArrayList)ouList);
                if ((ouList = OUUtil.getOUList((String)domainName, (Criteria)c)).size() == 0) {
                    ouList.add("CN=Users," + domainPath);
                }
            }
            this.setDirectoryObject(selectedDomain, request, ouList);
            if (nodeClicked == null || "".equals(nodeClicked)) {
                nodeClicked = ouList.size() == 0 ? "CN=Users," + domainPath : (String)ouList.get(0);
            }
            if (!domainPath.equalsIgnoreCase(nodeClickedClone = nodeClicked)) {
                int domainNameIndex = nodeClicked.indexOf(domainPath);
                nodeClicked = nodeClicked.substring(0, domainNameIndex - 1);
                LdapName name = new LdapName(nodeClicked);
                List<Rdn> rdns = name.getRdns();
                String parentOUName = "";
                for (int index = 0; index < rdns.size(); ++index) {
                    Rdn rdn = rdns.get(index);
                    parentOUName = index == 0 ? rdn.toString() + "," + domainPath : rdn.toString() + "," + parentOUName;
                    if (!ouList.isEmpty() && !ouList.contains(parentOUName)) continue;
                    this.setDirectoryObject(selectedDomain, parentOUName, request);
                    request.setAttribute("selectedObject", (Object)parentOUName);
                }
            }
            request.setAttribute("container", (Object)nodeClickedClone);
            request.setAttribute("selectedDomainName", (Object)domainName);
        }
        catch (Exception e) {
            e.printStackTrace();
            request.setAttribute("errorMessage", (Object)rb.getString("admp.mgmt.common.statmsg.unable_fetch_check_connectivity_status"));
        }
        if (request.getParameter("forwardPage") != null) {
            return mapping.findForward(request.getParameter("forwardPage"));
        }
        return mapping.findForward("ado");
    }

    private void setDirectoryObject(Properties selectedDomain, HttpServletRequest request, ArrayList ouList) throws Exception {
        try {
            String domainName = selectedDomain.getProperty("DOMAIN_NAME");
            String rootPath = selectedDomain.getProperty("DEFAULT_NAMING_CONTEXT");
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            boolean isWorkflow = false;
            String nodeClicked = request.getParameter("container");
            if (nodeClicked == null || "".equals(nodeClicked)) {
                nodeClicked = ouList.size() == 0 ? "CN=Users," + rootPath : (String)ouList.get(0);
            }
            if (request.getParameter("isWorkFlow") != null) {
                isWorkflow = new Boolean(request.getParameter("isWorkFlow"));
            }
            if (nodeClicked != null && rootPath.equalsIgnoreCase(nodeClicked) && isWorkflow) {
                nodeClicked = "CN=Users," + rootPath;
            }
            if (nodeClicked != null && !ouList.isEmpty()) {
                ouList.add(nodeClicked);
            }
            DirectoryObject object = DirectoryObjectUtil.getDirectoryObject(domainName, loginId, rootPath, ouList);
            DirectoryObjectTreeModel model = new DirectoryObjectTreeModel((TreeObject)object);
            request.setAttribute("rootPath", (Object)rootPath);
            session.setAttribute("TreeModel", (Object)model);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(e.getMessage());
        }
    }

    private void setDirectoryObject(Properties selectedDomain, String nodeClicked, HttpServletRequest request) {
        this.setDirectoryObject(selectedDomain, nodeClicked, request, "TreeModel");
    }

    private void setDirectoryObject(Properties selectedDomain, String nodeClicked, HttpServletRequest request, String modelName) {
        block5: {
            try {
                String rootPath = selectedDomain.getProperty("DEFAULT_NAMING_CONTEXT");
                HttpSession session = request.getSession();
                Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
                DirectoryObjectTreeModel model = (DirectoryObjectTreeModel)session.getAttribute(modelName);
                DirectoryObject object = (DirectoryObject)((DirectoryObjectTreeNode)model.getRoot()).getUserObject();
                int index = nodeClicked.indexOf(rootPath);
                if (index <= 0) break block5;
                try {
                    ArrayList<String> filter = new ArrayList<String>();
                    filter.add("organizationalUnit");
                    filter.add("container");
                    DirectoryObjectUtil.getDirectoryObject(object, nodeClicked, selectedDomain, loginId, filter, true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                DirectoryObjectTreeModel newModel = new DirectoryObjectTreeModel((TreeObject)object);
                session.setAttribute(modelName, (Object)newModel);
                String bookMarks = request.getParameter("bookmark");
                ArrayList<String> pathToOpen = (ArrayList<String>)session.getAttribute("TreeModel_showLines_showRootNode_OPENED-NODES");
                if (pathToOpen == null) {
                    pathToOpen = new ArrayList<String>();
                }
                pathToOpen.add(nodeClicked);
                session.setAttribute("TreeModel_showLines_showRootNode_OPENED-NODES", pathToOpen);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public ActionForward getObjects(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String domainName = request.getParameter("domainName");
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        ArrayList ouList = ClientAuthorizationUtil.getAuthorizedOUList(request, domainName);
        Long popUpId = new Long(request.getParameter("popUpId"));
        if (popUpId == 1L) {
            request.setAttribute("type", (Object)"single");
            request.setAttribute("objectClass", (Object)"user");
            request.setAttribute("submitPageMethod", (Object)"setManager");
            request.setAttribute("cancelPageMethod", (Object)"closePopUp");
        } else if (popUpId == 2L) {
            String strJSON = request.getParameter("selectedGroups");
            this.setGroupDatas(request, domainName, loginId, null, ouList, 0, 1, strJSON);
            request.setAttribute("submitPageMethod", (Object)"setMemberOfObjects");
            request.setAttribute("cancelPageMethod", (Object)"closePopUp");
        } else if (popUpId == 3L) {
            request.setAttribute("type", (Object)"multiple");
            request.setAttribute("submitPageMethod", (Object)"setDeliveryRestrictedObjects");
            request.setAttribute("cancelPageMethod", (Object)"closePopUp");
        } else if (popUpId == 4L) {
            // empty if block
        }
        request.setAttribute("domainName", (Object)domainName);
        request.setAttribute("popUpId", (Object)popUpId);
        request.setAttribute("inputId", (Object)request.getParameter("inputId"));
        return mapping.findForward("selectObjects");
    }

    public void setUserDatas(HttpServletRequest request, String domainName, Long loginId, String searchPattern, ArrayList ouList, int range, int startIndex) {
        if (request.getParameter("update") != null && request.getParameter("update").equalsIgnoreCase("true")) {
            DomainUtil.addSIDs((String)domainName, (Long)loginId, (boolean)true);
        }
        String[] userClass = new String[]{"user"};
        Long count = new Long(CommonUtil.getUserCount((String)searchPattern, (String)domainName, (ArrayList)ouList, (String[])userClass).intValue());
        ArrayList objectList = CommonUtil.getUserList((String)searchPattern, (String)domainName, (int)startIndex, (int)range, null, (String)"DISPLAY_NAME", (String)"true", (ArrayList)ouList, (Long)loginId);
        request.setAttribute("objectList", (Object)objectList);
        request.setAttribute("count", (Object)count);
    }

    public void setGroupDatas(HttpServletRequest request, String domainName, Long loginId, String searchPattern, ArrayList ouList, int range, int startIndex, String selectedGroupsJSONString) {
        try {
            String defaultNamingContext = DomainUtil.getDefaultNamingContext((String)domainName);
            Long count = new Long(GroupHandler.getGroupsCount((String)defaultNamingContext, (String)searchPattern, null, null, (Long)loginId, (ArrayList)ouList, (String)request.getParameter("update"), null));
            DataObject dataObj = GroupHandler.getGroups((String)defaultNamingContext, (String)searchPattern, null, null, (int)startIndex, (int)count.intValue(), (Long)loginId, (ArrayList)ouList);
            ArrayList<Properties> availableGroupsList = new ArrayList<Properties>();
            ArrayList<Properties> selectedGroupsList = new ArrayList<Properties>();
            Iterator it = dataObj.getRows("ADSMGroupGeneralDetails");
            while (it.hasNext()) {
                Row r = (Row)it.next();
                Properties prop = new Properties();
                prop.setProperty("DISPLAY_NAME", (String)r.get("GROUP_NAME"));
                prop.setProperty("DN_STRING", (String)r.get("DISTINGUISHED_NAME"));
                availableGroupsList.add(prop);
            }
            JSONObject objJSON = new JSONObject(selectedGroupsJSONString);
            JSONArray selectedGroupsJSONArray = objJSON.getJSONArray("selectedGroups");
            for (int i = 0; i < selectedGroupsJSONArray.length(); ++i) {
                JSONObject obj = selectedGroupsJSONArray.getJSONObject(i);
                Properties prop = new Properties();
                prop.setProperty("DISPLAY_NAME", obj.get("label").toString());
                prop.setProperty("DN_STRING", obj.get("value").toString());
                selectedGroupsList.add(prop);
            }
            ArrayList<Properties> tobeDeletedProps = new ArrayList<Properties>();
            for (Properties properties : selectedGroupsList) {
                if (properties == null) continue;
                for (Properties properties2 : availableGroupsList) {
                    if (!properties2.equals(properties)) continue;
                    tobeDeletedProps.add(properties2);
                }
            }
            for (Properties properties : tobeDeletedProps) {
                availableGroupsList.remove(properties);
            }
            request.setAttribute("availableGroups", availableGroupsList);
            request.setAttribute("selectedGroups", selectedGroupsList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ActionForward navigatorPage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        try {
            Long popUpId;
            int range = 100;
            int startIndex = 0;
            String rangeStr = request.getParameter("RANGE");
            String startIndexStr = request.getParameter("FROM_INDEX");
            if (rangeStr != null) {
                range = Integer.parseInt(rangeStr);
            }
            if (startIndexStr != null) {
                startIndex = Integer.parseInt(startIndexStr);
            }
            String domainName = request.getParameter("domainName");
            ArrayList ouList = ClientAuthorizationUtil.getAuthorizedOUList(request, domainName);
            String searchPattern = null;
            String searchText = request.getParameter("searchText");
            if (searchText != null && !searchText.equalsIgnoreCase("")) {
                searchPattern = searchText.indexOf("*") == -1 ? "*" + searchText + "*" : searchText;
                request.setAttribute("searchText", (Object)searchText);
            }
            if ((popUpId = new Long(request.getParameter("popUpId"))) == 1L) {
                HttpSession session = request.getSession();
                Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
                String objectClass = "user";
                if (request.getParameter("objectClass") != null) {
                    objectClass = request.getParameter("objectClass");
                }
                ArrayList objectList = new ArrayList();
                Long count = 0L;
                if (objectClass.equals("user")) {
                    this.setUserDatas(request, domainName, loginId, searchPattern, ouList, range, startIndex);
                }
                request.setAttribute("objectClass", (Object)objectClass);
                request.setAttribute("firstColumnHeader", (Object)rb.getString("admp.common.attrib_disp_name.display_name"));
                request.setAttribute("secondColumnHeader", (Object)rb.getString("admp.common.attrib_disp_name.location"));
            } else if (popUpId == 3L) {
                HttpSession session = request.getSession();
                Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
                if (request.getParameter("update") != null && request.getParameter("update").equalsIgnoreCase("true")) {
                    ExchangeHandler.addMailBoxObjects((String)domainName, (Long)loginId, (boolean)true);
                    String[] group = new String[]{"group"};
                    UpdateObjectUtil.getNewCount((String[])group, (String)searchText, (String)domainName, null, (String)request.getParameter("update"), (ArrayList)ouList);
                }
                Long count = ExchangeHandler.getMailBoxObjectsCount((String)searchPattern, (String)domainName, (ArrayList)ouList);
                ArrayList objectList = ExchangeHandler.getMailBoxObjects((String)searchPattern, (String)domainName, (int)startIndex, (int)range, (ArrayList)ouList);
                request.setAttribute("objectList", (Object)objectList);
                request.setAttribute("count", (Object)count);
                request.setAttribute("firstColumnHeader", (Object)rb.getString("admp.common.attrib_disp_name.display_name"));
                request.setAttribute("secondColumnHeader", (Object)rb.getString("admp.common.attrib_disp_name.e_mail"));
            }
            request.setAttribute("popUpId", (Object)popUpId);
            request.setAttribute("type", (Object)request.getParameter("type"));
            request.setAttribute("domainName", (Object)domainName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward("listObjects");
    }
}

