/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.layout;

import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.ADHandlerForMgmt;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.NativeError;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.layout.FcAttributes;
import com.adventnet.sym.adsm.common.server.layout.FcExecuteActionConstants;
import com.adventnet.sym.adsm.common.server.layout.FcFormDataContainer;
import com.adventnet.sym.adsm.common.server.layout.FcIamApps;
import com.adventnet.sym.adsm.common.server.layout.FcLayout;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutField;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutUtil;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutViewHandler;
import com.adventnet.sym.adsm.common.server.layout.FcNativeProperties;
import com.adventnet.sym.adsm.common.server.layout.FcSharedMailboxModificationMgmtHandler;
import com.adventnet.sym.adsm.common.server.layout.component.FcManager;
import com.adventnet.sym.adsm.common.server.reports.GroupHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportsUtil;
import com.adventnet.sym.adsm.common.server.usermanagement.UserMgmtUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DirectoryObjectUtil;
import com.adventnet.sym.adsm.common.server.util.DomainUtil;
import com.adventnet.sym.adsm.common.server.util.ExchangeUtil;
import com.adventnet.sym.adsm.common.server.util.HDTAuditUtil;
import com.adventnet.sym.adsm.common.server.util.HelpdeskUtil;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import com.adventnet.sym.adsm.common.webclient.layout.FcADMgmtListener;
import com.adventnet.sym.adsm.common.webclient.layout.FcExecuteFormFlow;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONArray;

public class FcSharedMailboxModificationListener
extends FcADMgmtListener {
    String fullName = "";
    String samAccountName = "";
    String distinguishedName = "";
    String searchString = "";
    String guid = "";
    ArrayList authorizedOUList = null;
    ArrayList groupList = null;
    Properties nativeStatusProps = new Properties();
    Hashtable auditLogProps = new Hashtable();
    String legacyExchangeDN = "";
    String mailboxDatabase = null;
    boolean isMailBoxEnabledUser = false;
    boolean isMailEnabledUser = false;
    String mailBoxServer = null;
    String modifiedFullName = null;
    ArrayList extendedRightsGuidList = new ArrayList();
    Long msExchVersion = 0L;
    String oldDistinguishedName = null;
    ArrayList<Hashtable> customList;
    String mailNickname = null;
    ArrayList<String> sendAsSIDList = new ArrayList();
    boolean isSendAsListUpdated = false;
    FcLayout executeFormLayout = null;
    Properties fieldValueList = new Properties();
    String[] mandatoryFields = new String[]{"sAMAccountName", "name", "distinguishedName", "legacyExchangeDN", "homeMDB", "msExchHomeServerName", "msExchVersion", "proxyAddresses", "mailNickname"};
    String[] restrictedFields = new String[]{"msExchHomeServerName", "homeMDB"};
    public static int MAIL_BOX_ENABLED_USER = 1;

    public void doAction(Long creationId, String domainName, FcLayout executeLayout, FcFormDataContainer fromClientData, FcFormDataContainer userData, FcFormDataContainer adData, FcIamApps fcIamApps, Long loginId) {
        this.doAction(creationId, domainName, executeLayout, fromClientData, userData, adData, fcIamApps, loginId, null);
    }

    public void doAction(Long creationId, String domainName, FcLayout executeLayout, FcFormDataContainer fromClientData, FcFormDataContainer userData, FcFormDataContainer adData, FcIamApps fcIamApps, Long loginId, FcLayout executeLayoutForm) {
        this.creationId = creationId;
        this.executeLayout = executeLayout;
        this.fromClientData = fromClientData;
        this.userData = userData;
        this.adData = adData;
        this.fcIamApps = fcIamApps;
        this.loginId = loginId;
        this.executeFormLayout = executeLayoutForm;
        this.modifySharedMailbox();
    }

    @Override
    public void setGuid(String guid) {
        this.guid = guid;
    }

    @Override
    public String getGuid() {
        return this.guid;
    }

    @Override
    public ArrayList getMandatoryFields() {
        ArrayList ar = new ArrayList();
        Collections.addAll(ar, this.mandatoryFields);
        return ar;
    }

    @Override
    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    @Override
    public void setLoginId(Long loginId) {
        this.loginId = loginId;
    }

    @Override
    public void setAuthorizedOUList(ArrayList authorizedOUList) {
        this.authorizedOUList = authorizedOUList;
    }

    public void setFieldValueList(Properties fieldValue) {
        this.fieldValueList = fieldValue;
    }

    @Override
    public void restrictFieldsFromEditing(FcFormDataContainer fcLayoutTabFields) {
        Enumeration e = fcLayoutTabFields.elements();
        while (e.hasMoreElements()) {
            FcLayoutField fcLayoutField = (FcLayoutField)e.nextElement();
            ArrayList fcAttributesList = fcLayoutField.getFcAttributeList();
            String ldapName = ((FcAttributes)fcAttributesList.get(0)).getAttribLdapName();
            for (int i = 0; i < this.restrictedFields.length; ++i) {
                if (!this.restrictedFields[i].equalsIgnoreCase(ldapName)) continue;
                fcLayoutField.setIsRestricted(Boolean.valueOf(true));
                fcLayoutField.setIsAuthorized(Boolean.valueOf(false));
            }
        }
    }

    @Override
    public void getADValues(Long templateCategoryId, FcFormDataContainer fcLayoutTabFields, FcFormDataContainer adDataContainer, Long loginId) {
        try {
            ArrayList attribList = FcExecuteFormFlow.getLDAPNames(templateCategoryId, fcLayoutTabFields);
            Properties valuesList = FcExecuteFormFlow.getObjectProperties(this.guid, this.domainName, loginId, attribList);
            if (attribList.contains("fullPermission")) {
                valuesList.put("fullPermission", this.getFullPermissionDetails());
            }
            if (attribList.contains("sendAs")) {
                this.sendAsSIDList = this.getSendAsList(this.distinguishedName);
                valuesList.put("sendAs", this.sendAsSIDList);
                this.isSendAsListUpdated = true;
            }
            this.fillMandatoryFields(valuesList);
            this.fillADValues(fcLayoutTabFields, adDataContainer, valuesList, loginId, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void fillADValues(FcFormDataContainer fcFormDataContainer, FcFormDataContainer adDataContainer, Properties valuesList, Long loginId, boolean showADValue) {
        try {
            Enumeration e = fcFormDataContainer.elements();
            while (e.hasMoreElements()) {
                FcLayoutField fcLayoutField = (FcLayoutField)e.nextElement();
                Properties prop = new Properties();
                prop.put("domainName", this.domainName);
                prop.put("loginId", loginId);
                prop.put("legacyExchangeDN", this.legacyExchangeDN);
                prop.put("samAccountName", this.samAccountName);
                prop.put("cantChangePwdValue", (Object)this.cantChangePwdValue);
                prop.put("msExchVersion", this.msExchVersion);
                prop.put("groupDetailsTable", this.groupDetailsTable);
                if (valuesList.containsKey("primaryGroupID") && this.memberOfList != null && (fcLayoutField.getComponentId() == 42L || fcLayoutField.getComponentId() == 62L)) {
                    Properties tempProp = new Properties();
                    tempProp.put("memberOf", this.memberOfList);
                    tempProp.put("primaryGroupID", valuesList.get("primaryGroupID"));
                    fcLayoutField.getIComponent().setValuesFromAD(fcLayoutField, adDataContainer, tempProp, prop, showADValue);
                    continue;
                }
                fcLayoutField.getIComponent().setValuesFromAD(fcLayoutField, adDataContainer, valuesList, prop, showADValue);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void fillMandatoryFields(Properties valuesList) {
        try {
            ArrayList samAccountNameValueList;
            ArrayList fullNameValueList;
            ArrayList distinguishedNameValueList;
            ArrayList mailBoxServerVersionList;
            ArrayList mailBoxServerValueList;
            ArrayList mailBoxDatabaseValueList;
            ArrayList mailNicknameValueList;
            String legacyDN;
            int index;
            ArrayList legacyDNValueList = (ArrayList)valuesList.get("legacyExchangeDN");
            if (legacyDNValueList != null && (index = (legacyDN = (String)legacyDNValueList.get(0)).toLowerCase().lastIndexOf("/cn=recipients/cn=")) != -1) {
                this.legacyExchangeDN = legacyDN.substring(0, index);
            }
            if ((mailNicknameValueList = (ArrayList)valuesList.get("mailNickname")) != null) {
                this.mailNickname = (String)mailNicknameValueList.get(0);
            }
            if ((mailBoxDatabaseValueList = (ArrayList)valuesList.get("homeMDB")) != null) {
                this.mailboxDatabase = (String)mailBoxDatabaseValueList.get(0);
            }
            if ((mailBoxServerValueList = (ArrayList)valuesList.get("msExchHomeServerName")) != null) {
                this.mailBoxServer = (String)mailBoxServerValueList.get(0);
            }
            if ((mailBoxServerVersionList = (ArrayList)valuesList.get("msExchVersion")) != null) {
                this.msExchVersion = Long.parseLong((String)mailBoxServerVersionList.get(0));
            }
            if ((distinguishedNameValueList = (ArrayList)valuesList.get("distinguishedName")) != null) {
                this.distinguishedName = (String)distinguishedNameValueList.get(0);
                this.fcNativeProperties.setDN(this.distinguishedName);
            }
            if ((fullNameValueList = (ArrayList)valuesList.get("name")) != null) {
                this.fullName = (String)fullNameValueList.get(0);
            }
            ArrayList list = (ArrayList)valuesList.get("memberOf");
            ArrayList primaryGrpList = (ArrayList)valuesList.get("primaryGroupID");
            this.setMemberOfValues(list, primaryGrpList);
            ArrayList proxyAddressesValueList = (ArrayList)valuesList.get("proxyAddresses");
            if (proxyAddressesValueList != null) {
                this.existingProxyAddresses = proxyAddressesValueList;
            }
            if ((samAccountNameValueList = (ArrayList)valuesList.get("sAMAccountName")) != null) {
                this.samAccountName = (String)samAccountNameValueList.get(0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ArrayList getFullPermissionDetails() throws Exception {
        ArrayList dbValuesList = new ArrayList();
        Properties exchangeServerDetails = ExchangeUtil.getExchangeServerProperty((String)this.domainName, (String)this.mailBoxServer);
        String result = ADHandler.getMailBoxFullPermissionList((String)this.domainName, (long)this.loginId, (Properties)exchangeServerDetails, (String)this.samAccountName);
        if (!result.equals("")) {
            JSONArray domainDetailsArray = new JSONArray(result);
            String[] tableArray = new String[]{"ADSMUserGeneralDetails", "ADSMGroupGeneralDetails"};
            this.fullPermissionList = FcLayoutUtil.getFullPermissionDetails((String[])tableArray, (JSONArray)domainDetailsArray, (String)this.domainName, dbValuesList);
        }
        return dbValuesList;
    }

    public void setSendAsList(ArrayList clientDNList) {
        if (!this.isSendAsListUpdated) {
            this.sendAsSIDList = this.getSendAsList(this.distinguishedName);
            this.isSendAsListUpdated = true;
        }
        ArrayList addSIDList = new ArrayList();
        ArrayList removeSIDList = new ArrayList();
        ArrayList sIDListFromAD = (ArrayList)this.sendAsSIDList.clone();
        ArrayList clientDNListCopy = (ArrayList)clientDNList.clone();
        String sIDString = "";
        for (int i = 0; i < clientDNListCopy.size(); ++i) {
            sIDString = (String)clientDNListCopy.get(i);
            if (!sIDListFromAD.contains(sIDString)) continue;
            sIDListFromAD.remove(sIDString);
            clientDNListCopy.remove(sIDString);
            --i;
        }
        Hashtable resultPropAdd = new Hashtable();
        Hashtable resultPropDelete = new Hashtable();
        String errorMsg = "";
        if (!sIDListFromAD.isEmpty()) {
            resultPropDelete = this.updateSendAsAttribute(sIDListFromAD, this.distinguishedName, "delete");
            errorMsg = this.getErrorStringForSendAs(resultPropDelete, errorMsg);
        }
        if (!clientDNListCopy.isEmpty()) {
            resultPropAdd = this.updateSendAsAttribute(clientDNListCopy, this.distinguishedName, "add");
            errorMsg = this.getErrorStringForSendAs(resultPropAdd, errorMsg);
        }
        if (!errorMsg.equals("")) {
            this.setSendAsErrorMsg(errorMsg);
        }
    }

    public void setSendAsErrorMsg(String testString) {
        Hashtable<String, String> hash = new Hashtable<String, String>();
        hash.put("ERROR_MESSAGE", testString);
        if (this.nativeStatusProps.get("CREATION_MESSAGE") == null) {
            this.nativeStatusProps.put("CREATION_MESSAGE", new ArrayList());
        }
        ((ArrayList)this.nativeStatusProps.get("CREATION_MESSAGE")).add(hash);
        this.nativeStatusProps.setProperty("CREATION_STATUS", "WARNING");
        this.nativeStatusProps.setProperty("CREATION_IMAGE", "/images/alert.gif");
        this.nativeStatusProps.setProperty("CREATION_MESSAGE_STYLE", "greentxtbold");
    }

    public void setMemberOfValues(ArrayList MemberOfList, ArrayList PrimaryGroupList) {
        String primaryGroupRID;
        Properties defaultprops;
        String defaultNamingContext = DomainUtil.getDefaultNamingContext((String)this.domainName);
        Hashtable authorizedGroupList = new Hashtable();
        if (MemberOfList != null) {
            this.memberOfList = new ArrayList();
            String[] columns = new String[]{"DOMAIN_NAME", "OBJECT_GUID", "DISTINGUISHED_NAME", "SID_STRING", "GROUPTYPE", "GROUP_NAME"};
            authorizedGroupList = MemberOfList.size() > 40 ? this.loadMemberOfData(MemberOfList) : GroupHandler.getGroupsPropFromDN((String)this.domainName, (Long)this.loginId, (ArrayList)MemberOfList, (String)"domain", (String[])columns);
            for (String key : authorizedGroupList.keySet()) {
                Properties properties = (Properties)authorizedGroupList.get(key);
                this.memberOfList.add((String)properties.get("DISTINGUISHED_NAME"));
            }
            this.groupDetailsTable = authorizedGroupList;
        }
        if (PrimaryGroupList != null && !this.memberOfList.contains((String)(defaultprops = GroupHandler.getGroupDetailsFromRID((String)(primaryGroupRID = (String)PrimaryGroupList.get(0)), (String)this.domainName)).get("Distinguished_Name"))) {
            this.memberOfList.add((String)defaultprops.get("Distinguished_Name"));
        }
    }

    @Override
    public int getSelectedSubTab() {
        return MAIL_BOX_ENABLED_USER;
    }

    public void modifySharedMailbox() {
        try {
            Hashtable<String, String> hash;
            this.isChangesFound = true;
            mgmtLog.log(Level.INFO, " FcUser Modification Started ");
            FcFormDataContainer modifiedFieldsContainer = new FcFormDataContainer();
            FcExecuteFormFlow.fillModifiedFields(FcExecuteActionConstants.sharedMailboxModificationTemplateCategoryId, modifiedFieldsContainer, this.fromClientData, this.adData, this.rb, null, null);
            FcFormDataContainer customFieldsContainer = new FcFormDataContainer();
            customFieldsContainer.splitCustomFields(modifiedFieldsContainer);
            FcSharedMailboxModificationMgmtHandler.getInstance().updateFieldsAttributes(modifiedFieldsContainer);
            FcSharedMailboxModificationMgmtHandler.getInstance().updateFieldsAttributes(customFieldsContainer);
            if (this.isFieldModified("memberOf", modifiedFieldsContainer) && !this.isFieldModified("memberof", this.adData)) {
                FcFormDataContainer tempModFieldsContainer = new FcFormDataContainer();
                tempModFieldsContainer.put((Object)4106L, modifiedFieldsContainer.get((Object)4106L));
                this.getADValues(FcExecuteActionConstants.sharedMailboxModificationTemplateCategoryId, tempModFieldsContainer, this.adData, this.loginId);
            }
            FcSharedMailboxModificationMgmtHandler.getInstance().updateFieldValuesToAttributes(modifiedFieldsContainer);
            FcSharedMailboxModificationMgmtHandler.getInstance().updateFieldValuesToAttributes(customFieldsContainer);
            FcSharedMailboxModificationMgmtHandler.getInstance().updateFieldsAttributes(this.fromClientData);
            FcSharedMailboxModificationMgmtHandler.getInstance().updateFieldValuesToAttributes(this.fromClientData);
            Properties prop1 = new Properties();
            prop1.put("domainName", this.domainName);
            Properties ldapVsValueProps = FcSharedMailboxModificationMgmtHandler.getInstance().getLdapVsValues(this.fromClientData, prop1);
            ldapVsValueProps = FcSharedMailboxModificationMgmtHandler.getInstance().getLdapVsValuesFromAD(this.fieldValueList, ldapVsValueProps);
            this.customList = this.getCustomAttribsProperties(customFieldsContainer, true, ldapVsValueProps, "user");
            FcNativeProperties fcNativeProperties = this.fcNativeProperties;
            this.addAttributeToNativeProps(modifiedFieldsContainer, fcNativeProperties, ldapVsValueProps);
            Properties props = fcNativeProperties.getProps();
            this.groupList = fcNativeProperties.getGroupList();
            String archiveDB = null;
            String archiveDomain = null;
            if (props.get("msExchArchiveDatabaseLink") != null) {
                archiveDB = props.getProperty("msExchArchiveDatabaseLink");
            }
            if (props.get("msExchArchiveAddress") != null) {
                archiveDomain = props.getProperty("msExchArchiveAddress");
            }
            mgmtLog.log(Level.INFO, " User Modification : domainName " + this.domainName);
            mgmtLog.log(Level.INFO, " LoginId  " + this.loginId);
            mgmtLog.log(Level.INFO, " Full Name :" + this.fullName);
            mgmtLog.log(Level.INFO, " propsList " + fcNativeProperties.getPropList());
            mgmtLog.log(Level.INFO, " modifyList " + fcNativeProperties.getModifyList());
            mgmtLog.log(Level.INFO, " tsList " + fcNativeProperties.getTsList());
            mgmtLog.log(Level.INFO, " winNTAttributeList " + fcNativeProperties.getWinNTAttributeList());
            mgmtLog.log(Level.INFO, " GroupsList " + this.groupList);
            mgmtLog.log(Level.INFO, " To Be Removed from Group List " + this.toBeRemovedGroupList);
            mgmtLog.log(Level.INFO, " customList " + this.customList);
            mgmtLog.log(Level.INFO, " msExchArchiveDatabaseLink " + archiveDB);
            mgmtLog.log(Level.INFO, " msExchArchiveAddress " + archiveDomain);
            mgmtLog.log(Level.INFO, " toBeRemovedFullPermissionList " + this.toBeRemovedFullPermissionList);
            mgmtLog.log(Level.INFO, " addedFullPermissionList " + this.addedFullPermissionList);
            this.auditLogProps.put("domainName", this.domainName);
            this.auditLogProps.put("userName", this.fullName);
            this.auditLogProps.put("propList", fcNativeProperties.getPropList());
            this.auditLogProps.put("modifyList", fcNativeProperties.getModifyList());
            this.auditLogProps.put("winNTAttributeList", fcNativeProperties.getWinNTAttributeList());
            this.auditLogProps.put("groupList", this.groupList);
            this.auditLogProps.put("toBeRemovedGroupList", this.toBeRemovedGroupList);
            this.auditLogProps.put("customList", this.customList);
            if (props.get("OUName") != null) {
                String OUName = (String)props.get("OUName");
                if (!HelpdeskUtil.isAuthorizedOU((String)this.domainName, (Long)this.loginId, (String)OUName)) {
                    this.nativeStatusProps.setProperty("CREATION_STATUS", "SEVERE");
                    this.nativeStatusProps.setProperty("STATUS_MESSAGE", MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.message_OU_failure"), OUName));
                    return;
                }
                String newdistinguishedName = "CN=" + CommonUtil.escapeString((String)this.fullName, (String[])UserMgmtUtil.USERNAME_ESCAPE_CHARECTERS) + "," + OUName;
                if (!this.distinguishedName.equals(newdistinguishedName)) {
                    this.oldDistinguishedName = this.distinguishedName;
                    try {
                        ADHandlerForMgmt.moveObject((String)this.domainName, (Long)this.loginId, (String)this.oldDistinguishedName, (String)OUName);
                        this.distinguishedName = newdistinguishedName;
                        this.nativeStatusProps.setProperty("CREATION_STATUS", "SUCCESS");
                        this.nativeStatusProps.setProperty("STATUS_MESSAGE", this.rb.getString("admp.reports.common.status_msg.successfully_updated_sh_mailbox"));
                        this.nativeStatusProps.setProperty("CREATION_MESSAGE_STYLE", "greentxtbold");
                    }
                    catch (LocalizedException le) {
                        le.printStackTrace();
                        Hashtable<String, String> hash2 = new Hashtable<String, String>();
                        hash2.put("ERROR_MESSAGE", MessageFormat.format(this.rb.getString("usermanagement.messages.unable_modify_sh_mailbox"), le.getMessage(this.rb)));
                        hash2.put("NATIVE_ERROR_MESSAGE", MessageFormat.format(this.rb.getString("admp.mgmt.csv_imp.mod_contacts.statmsg.error_moving_sh_mailbox"), le.getMessage(this.rb)));
                        if (this.nativeStatusProps.get("CREATION_MESSAGE") == null) {
                            this.nativeStatusProps.put("CREATION_MESSAGE", new ArrayList());
                        }
                        ((ArrayList)this.nativeStatusProps.get("CREATION_MESSAGE")).add(hash2);
                        this.nativeStatusProps.setProperty("STATUS_MESSAGE", "");
                        this.nativeStatusProps.setProperty("CREATION_STATUS", "SEVERE");
                        this.nativeStatusProps.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                        this.nativeStatusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                        return;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            String searchDN = this.distinguishedName;
            String updateDN = CommonUtil.escapeSpecialCharacters((String)this.distinguishedName);
            this.searchString = "(&(objectClass=user)(objectCategory=user)(distinguishedName=" + updateDN + "))";
            String policyIncluded = (String)ldapVsValueProps.get("msExchPoliciesExcluded");
            String CREATION_STATUS = null;
            String mailServer = (String)props.get("msExchHomeServerName");
            if (mailServer == null || mailServer.equals("")) {
                mailServer = this.mailBoxServer;
            }
            Properties exchangeServerDetails = ExchangeUtil.getExchangeServerProperty((String)this.domainName, (String)mailServer);
            if (modifiedFieldsContainer.size() > 0 || customFieldsContainer.size() > 0) {
                Properties properties = HDTDomainHandler.getConfiguredValues((String)this.domainName, (Long)this.loginId);
                String defaultNamingContext = properties.getProperty("DEFAULT_NAMING_CONTEXT");
                Boolean updatePolicy = false;
                Integer exchType = 0;
                if (props.get("msExchPoliciesIncluded") != null && props.get("msExchPoliciesIncluded").equals("{26491CFC-9E50-4857-861B-0CB8DF22B5D7}")) {
                    updatePolicy = true;
                }
                String hideAddressBook = (String)props.get("msExchHideFromAddressLists");
                String recipientType = "mailBox";
                if (this.msExchVersion != 0L) {
                    String exchVersion = ExchangeUtil.getExchangeVersion((Long)this.msExchVersion);
                    exchType = ExchangeUtil.getExchType((String)exchVersion);
                }
                if (this.authorizedOUList == null || this.authorizedOUList.size() == 0) {
                    this.statusObject = ADHandler.searchAndModifyUser((String)this.domainName, (Long)this.loginId, (String)defaultNamingContext, (String)this.searchString, (String)StrUtil.getContainerDNFromDN((String)this.distinguishedName), null, (ArrayList)fcNativeProperties.getPropList(), (ArrayList)fcNativeProperties.getModifyList(), (ArrayList)fcNativeProperties.getTsList(), (ArrayList)fcNativeProperties.getWinNTAttributeList(), (ArrayList)this.groupList, (boolean)false);
                    this.nativeStatusProps = this.getSingleUserErrorMessage(this.statusObject);
                    CREATION_STATUS = this.nativeStatusProps.getProperty("CREATION_STATUS");
                    if (!CREATION_STATUS.equalsIgnoreCase("SEVERE") && !this.customList.isEmpty()) {
                        NativeError customError = ADHandler.searchAndModifyUser((String)this.domainName, (Long)this.loginId, (String)defaultNamingContext, (String)this.searchString, (String)StrUtil.getContainerDNFromDN((String)this.distinguishedName), null, this.customList, new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), (boolean)false);
                        this.setSingleUserErrorMessage(customError, "admp.ad_mgmt.create_user.error_in_setting_values_for_custom_attributes", this.searchString);
                    }
                    if (!(CREATION_STATUS == null || CREATION_STATUS.equalsIgnoreCase("SEVERE") || archiveDB == null || archiveDomain == null || archiveDB.equals("") && archiveDomain.equals(""))) {
                        if (exchType >= 2010) {
                            boolean isRemote = false;
                            if (!archiveDomain.equals("")) {
                                isRemote = true;
                            }
                            String msg = "";
                            msg = ADHandler.enableArchiveMailbox((String)this.domainName, (long)this.loginId, (String)this.distinguishedName, (String)archiveDB, (String)archiveDomain, (Properties)exchangeServerDetails, (boolean)isRemote);
                            if (msg.length() > 0) {
                                hash = new Hashtable<String, String>();
                                hash.put("ERROR_MESSAGE", MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.statmsg.archive_mail"), this.rb.getString(msg)));
                                if (this.nativeStatusProps.get("CREATION_MESSAGE") == null) {
                                    this.nativeStatusProps.put("CREATION_MESSAGE", new ArrayList());
                                }
                                ((ArrayList)this.nativeStatusProps.get("CREATION_MESSAGE")).add(hash);
                                this.nativeStatusProps.setProperty("CREATION_STATUS", "WARNING");
                                this.nativeStatusProps.setProperty("CREATION_IMAGE", "/images/alert.gif");
                                this.nativeStatusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                            }
                        } else {
                            Hashtable<String, String> hash3 = new Hashtable<String, String>();
                            hash3.put("ERROR_MESSAGE", MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.statmsg.error_archive_mail"), FcLayoutUtil.getDisplayNameFromDN((String)((String)ldapVsValueProps.get("homeMDB")))));
                            if (this.nativeStatusProps.get("CREATION_MESSAGE") == null) {
                                this.nativeStatusProps.put("CREATION_MESSAGE", new ArrayList());
                            }
                            ((ArrayList)this.nativeStatusProps.get("CREATION_MESSAGE")).add(hash3);
                            this.nativeStatusProps.setProperty("CREATION_STATUS", "WARNING");
                            this.nativeStatusProps.setProperty("CREATION_IMAGE", "/images/alert.gif");
                            this.nativeStatusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                        }
                    }
                    if (updatePolicy.booleanValue() && CREATION_STATUS != null && !CREATION_STATUS.equalsIgnoreCase("SEVERE")) {
                        ADHandler.updateEmailPolicy((String)this.domainName, (long)this.loginId, (String)this.distinguishedName, (Properties)exchangeServerDetails);
                    }
                    if ((hideAddressBook != null || props.get("msExchPoliciesIncluded") == null && props.get("mailAlias") != null && policyIncluded.equalsIgnoreCase("true")) && this.msExchVersion != 0L) {
                        ADHandler.setExchangeAttribute((String)this.domainName, (long)this.loginId, (String)this.distinguishedName, (String)recipientType, (String)hideAddressBook, (Properties)exchangeServerDetails, (String)((String)props.get("mailAlias")));
                    }
                } else {
                    for (int i = 0; i < this.authorizedOUList.size(); ++i) {
                        String dn = ((String)this.authorizedOUList.get(i)).toLowerCase();
                        String s = searchDN.toLowerCase();
                        if (!s.endsWith(dn)) continue;
                        this.statusObject = ADHandler.searchAndModifyUser((String)this.domainName, (Long)this.loginId, (String)((String)this.authorizedOUList.get(i)), (String)this.searchString, (String)StrUtil.getContainerDNFromDN((String)this.distinguishedName), null, (ArrayList)fcNativeProperties.getPropList(), (ArrayList)fcNativeProperties.getModifyList(), (ArrayList)fcNativeProperties.getTsList(), (ArrayList)fcNativeProperties.getWinNTAttributeList(), (ArrayList)this.groupList, (boolean)false);
                        this.nativeStatusProps = this.getSingleUserErrorMessage(this.statusObject);
                        CREATION_STATUS = this.nativeStatusProps.getProperty("CREATION_STATUS");
                        if (!CREATION_STATUS.equalsIgnoreCase("SEVERE") && !this.customList.isEmpty()) {
                            NativeError customError = ADHandler.searchAndModifyUser((String)this.domainName, (Long)this.loginId, (String)((String)this.authorizedOUList.get(i)), (String)this.searchString, (String)StrUtil.getContainerDNFromDN((String)this.distinguishedName), null, this.customList, new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), (boolean)false);
                            this.setSingleUserErrorMessage(customError, "admp.ad_mgmt.create_user.error_in_setting_values_for_custom_attributes", this.searchString);
                        }
                        if (CREATION_STATUS != null && !CREATION_STATUS.equalsIgnoreCase("SEVERE") && archiveDB != null && archiveDomain != null) {
                            if (exchType >= 2010) {
                                if (!archiveDB.equals("") || !archiveDomain.equals("")) {
                                    boolean isRemote = false;
                                    if (!archiveDomain.equals("")) {
                                        isRemote = true;
                                    }
                                    String msg = "";
                                    msg = ADHandler.enableArchiveMailbox((String)this.domainName, (long)this.loginId, (String)this.distinguishedName, (String)archiveDB, (String)archiveDomain, (Properties)exchangeServerDetails, (boolean)isRemote);
                                    if (msg.length() > 0) {
                                        Hashtable<String, String> hash4 = new Hashtable<String, String>();
                                        hash4.put("ERROR_MESSAGE", MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.statmsg.archive_mail"), this.rb.getString(msg)));
                                        if (this.nativeStatusProps.get("CREATION_MESSAGE") == null) {
                                            this.nativeStatusProps.put("CREATION_MESSAGE", new ArrayList());
                                        }
                                        ((ArrayList)this.nativeStatusProps.get("CREATION_MESSAGE")).add(hash4);
                                        this.nativeStatusProps.setProperty("CREATION_STATUS", "WARNING");
                                        this.nativeStatusProps.setProperty("CREATION_IMAGE", "/images/alert.gif");
                                        this.nativeStatusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                                    }
                                }
                            } else {
                                Hashtable<String, String> hash5 = new Hashtable<String, String>();
                                hash5.put("ERROR_MESSAGE", MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.statmsg.error_archive_mail"), FcLayoutUtil.getDisplayNameFromDN((String)((String)ldapVsValueProps.get("homeMDB")))));
                                if (this.nativeStatusProps.get("CREATION_MESSAGE") == null) {
                                    this.nativeStatusProps.put("CREATION_MESSAGE", new ArrayList());
                                }
                                ((ArrayList)this.nativeStatusProps.get("CREATION_MESSAGE")).add(hash5);
                                this.nativeStatusProps.setProperty("CREATION_STATUS", "WARNING");
                                this.nativeStatusProps.setProperty("CREATION_IMAGE", "/images/alert.gif");
                                this.nativeStatusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                            }
                        }
                        if (updatePolicy.booleanValue() && CREATION_STATUS != null && !CREATION_STATUS.equalsIgnoreCase("SEVERE")) {
                            ADHandler.updateEmailPolicy((String)this.domainName, (long)this.loginId, (String)this.distinguishedName, (Properties)exchangeServerDetails);
                        }
                        if ((hideAddressBook == null || !hideAddressBook.equalsIgnoreCase("false") && exchType != 2013) && (props.get("msExchPoliciesIncluded") != null || props.get("mailAlias") == null || !policyIncluded.equalsIgnoreCase("true")) || this.msExchVersion == 0L) continue;
                        ADHandler.setExchangeAttribute((String)this.domainName, (long)this.loginId, (String)this.distinguishedName, (String)recipientType, (String)hideAddressBook, (Properties)exchangeServerDetails, (String)((String)props.get("mailAlias")));
                    }
                }
                if (this.removedProxyAddresses.size() > 0) {
                    StringBuilder proxyError = new StringBuilder();
                    for (int index = 0; index < this.removedProxyAddresses.size(); ++index) {
                        hash = (Hashtable<String, String>)this.removedProxyAddresses.get(index);
                        if (index > 0) {
                            proxyError.append(", ");
                        }
                        String proxyAddress = (String)hash.get("PROXY_ADDRESS");
                        String assignedUserName = (String)hash.get("USER_NAME");
                        proxyError.append(MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.cre_bulk_user.msg_proxy_already_exist_for_the_user"), proxyAddress, assignedUserName));
                    }
                    String proxyErrorString = MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.cre_bulk_user.error_str.error_removed_proxy_addresses"), proxyError.toString());
                    Hashtable<String, String> errorHash = new Hashtable<String, String>();
                    errorHash.put("ERROR_MESSAGE", proxyErrorString);
                    errorHash.put("NATIVE_ERROR_MESSAGE", ".");
                    if (this.nativeStatusProps.get("CREATION_MESSAGE") == null) {
                        ArrayList<Hashtable<String, String>> errorList = new ArrayList<Hashtable<String, String>>();
                        errorList.add(errorHash);
                        this.nativeStatusProps.put("CREATION_MESSAGE", errorList);
                    } else {
                        ((ArrayList)this.nativeStatusProps.get("CREATION_MESSAGE")).add(errorHash);
                    }
                    this.nativeStatusProps.setProperty("CREATION_STATUS", "WARNING");
                    this.nativeStatusProps.setProperty("CREATION_IMAGE", "/images/alert.gif");
                    this.nativeStatusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                }
            } else {
                mgmtLog.log(Level.INFO, "No value is changed for the SharedMailbox : " + this.distinguishedName);
                this.nativeStatusProps.setProperty("CREATION_STATUS", "SUCCESS");
                this.nativeStatusProps.setProperty("STATUS_MESSAGE", this.rb.getString("admp.mgmt.fc_layout_title.text_no_changes_found"));
                this.nativeStatusProps.setProperty("CREATION_MESSAGE_STYLE", "greentxtbold");
                this.isChangesFound = false;
            }
            if (CREATION_STATUS != null && !CREATION_STATUS.equalsIgnoreCase("SEVERE") && !CREATION_STATUS.equalsIgnoreCase("WARNING") && this.distinguishedName != null) {
                if (!this.toBeRemovedGroupList.isEmpty()) {
                    String defaultNamingContext = DomainUtil.getDefaultNamingContext((String)this.domainName);
                    ArrayList groupList = UserMgmtUtil.getGroupList((Long)this.loginId, (String)defaultNamingContext);
                    ArrayList<Properties> list = new ArrayList<Properties>();
                    Properties p = new Properties();
                    p.put("ATTRIB_VALUE", this.distinguishedName);
                    p.put("ATTRIB_VALUE_COUNT", new Long(1L));
                    p.put("DATA_HANDLER_TYPE", new Long(3L));
                    p.put("ATTRIB_LDAP_NAME", "member");
                    p.put("DW_CONTROL_CODE", new Long(4L));
                    list.add(p);
                    for (int i = 0; i < this.toBeRemovedGroupList.size(); ++i) {
                        Properties prop = UserMgmtUtil.getPropertiesfromDN((String)((String)this.toBeRemovedGroupList.get(i)), (ArrayList)groupList);
                        String groupSid = null;
                        if (prop != null) {
                            groupSid = UserMgmtUtil.getGroupSIDfromRID((String)((String)prop.get("objectRID")), (ArrayList)groupList);
                        }
                        if (groupSid == null) continue;
                        try {
                            ADHandlerForMgmt.modifyGroup((String)this.domainName, (Long)this.loginId, (String)groupSid, (String)this.distinguishedName, list, null);
                            continue;
                        }
                        catch (LocalizedException le) {
                            le.printStackTrace();
                            hash = new Hashtable();
                            hash.put("ERROR_MESSAGE", MessageFormat.format(this.rb.getString("admp.mgmt.fc_layout.error_while_removing_group"), (String)prop.get("Display_Name")));
                            if (this.nativeStatusProps.get("CREATION_MESSAGE") == null) {
                                this.nativeStatusProps.put("CREATION_MESSAGE", new ArrayList());
                            }
                            ((ArrayList)this.nativeStatusProps.get("CREATION_MESSAGE")).add(hash);
                            this.nativeStatusProps.setProperty("CREATION_STATUS", "SEVERE");
                            this.nativeStatusProps.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                            this.nativeStatusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                            continue;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                if (!this.toBeRemovedFullPermissionList.isEmpty() || !this.addedFullPermissionList.isEmpty()) {
                    ArrayList fullPermissionToNative = this.setFullPermissionToNative(this.addedFullPermissionList, true);
                    fullPermissionToNative.addAll(this.setFullPermissionToNative(this.toBeRemovedFullPermissionList, false));
                    String msg = ADHandler.setMailBoxRights2007((String)this.domainName, (Long)this.loginId, (ArrayList)fullPermissionToNative, (String)this.distinguishedName, (Properties)exchangeServerDetails);
                    if (msg != null && msg.length() != 0) {
                        Hashtable<String, String> hash6 = new Hashtable<String, String>();
                        hash6.put("ERROR_MESSAGE", MessageFormat.format(this.rb.getString("admp.mgmt.csv_imp.mod_contacts.statmsg.error_modifying_fullpermission"), this.rb.getString(msg)));
                        if (this.nativeStatusProps.get("CREATION_MESSAGE") == null) {
                            this.nativeStatusProps.put("CREATION_MESSAGE", new ArrayList());
                        }
                        ((ArrayList)this.nativeStatusProps.get("CREATION_MESSAGE")).add(hash6);
                        this.nativeStatusProps.setProperty("CREATION_STATUS", "SEVERE");
                        this.nativeStatusProps.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                        this.nativeStatusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                    }
                }
            }
            if (props.get("sendAs") != null) {
                this.setSendAsList((ArrayList)props.get("sendAs"));
            }
            if (props.getProperty("userName") != null && !props.getProperty("userName").equals("")) {
                this.modifiedFullName = props.getProperty("userName");
                mgmtLog.log(Level.INFO, "Modifying Name Attribute :" + props.getProperty("userName") + " for the User : " + this.distinguishedName);
                try {
                    ADHandlerForMgmt.modifyUserFullName((String)this.domainName, (Long)this.loginId, (String)this.distinguishedName, (String)this.modifiedFullName, null);
                }
                catch (LocalizedException le) {
                    le.printStackTrace();
                    Hashtable<String, String> hash7 = new Hashtable<String, String>();
                    hash7.put("ERROR_MESSAGE", MessageFormat.format(this.rb.getString("admp.mgmt.csv_imp.mod_contacts.statmsg.error_modifying_fullname"), le.getMessage(this.rb)));
                    if (this.nativeStatusProps.get("CREATION_MESSAGE") == null) {
                        this.nativeStatusProps.put("CREATION_MESSAGE", new ArrayList());
                    }
                    ((ArrayList)this.nativeStatusProps.get("CREATION_MESSAGE")).add(hash7);
                    this.nativeStatusProps.setProperty("CREATION_STATUS", "SEVERE");
                    this.nativeStatusProps.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                    this.nativeStatusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            mgmtLog.log(Level.INFO, " Fc SharedMailbox Modification Listener finished ");
        }
        catch (Exception e) {
            mgmtLog.log(Level.SEVERE, "Native Exception : " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void addAttributeToNativeProps(FcFormDataContainer modifiedFieldsContainer, FcNativeProperties fcNativeProperties, Properties ldapVsValueProps) throws Exception {
        this.getProperties(true, modifiedFieldsContainer, fcNativeProperties, ldapVsValueProps, "user");
    }

    public void setIsCreationSuccess() {
        if (this.nativeStatusProps != null) {
            String creationStatus = this.nativeStatusProps.getProperty("CREATION_STATUS");
            if (!creationStatus.equalsIgnoreCase("SEVERE")) {
                this.setIsCreationSuccess(true);
            }
        } else {
            this.setIsCreationSuccess(false);
        }
    }

    public void setStatusMsgForResponse(HttpServletRequest request) {
        request.setAttribute("statusProps", (Object)this.nativeStatusProps);
        try {
            ArrayList creationMsg;
            Properties props;
            String value;
            if (!(this.isChangesFound || this.fcNativeProperties.getPropList() != null && this.fcNativeProperties.getPropList().size() != 0 || this.fcNativeProperties.getModifyList() != null && this.fcNativeProperties.getModifyList().size() != 0 || this.fcNativeProperties.getTsList() != null && this.fcNativeProperties.getTsList().size() != 0 || this.fcNativeProperties.getWinNTAttributeList() != null && this.fcNativeProperties.getWinNTAttributeList().size() != 0 || this.groupList != null && this.groupList.size() != 0 || this.customList != null && this.customList.size() != 0)) {
                return;
            }
            String hostId = request.getRemoteHost();
            DataObject auditDataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
            Long audit_id = HDTAuditUtil.fillAuditDetails((Long)this.loginId, (String)hostId, (Integer)10002, (DataObject)auditDataObj, (AdventNetResourceBundle)this.rb);
            Long object_id = HDTAuditUtil.fillAuditObjDetails((Long)audit_id, (String)this.samAccountName, (String)this.domainName, (DataObject)auditDataObj);
            Hashtable<String, Object> audit_info = new Hashtable<String, Object>();
            audit_info.put("object_id", object_id);
            ArrayList propList = this.fcNativeProperties.getPropList();
            ArrayList<String> modifiedMemberOfValues = new ArrayList<String>();
            if (this.groupList != null && !this.groupList.isEmpty()) {
                modifiedMemberOfValues.add("<B>" + this.rb.getString("admp.audit.display_text.added") + "</B><br/>");
                for (String addedGroup : this.groupList) {
                    modifiedMemberOfValues.add(addedGroup);
                }
            }
            if (this.toBeRemovedGroupList != null && !this.toBeRemovedGroupList.isEmpty()) {
                String removedHeading = (modifiedMemberOfValues.isEmpty() ? "" : "<BR/>") + "<B>" + this.rb.getString("admp.audit.display_text.removed") + "</B><br/>";
                modifiedMemberOfValues.add(removedHeading);
                for (String removedGroup : this.toBeRemovedGroupList) {
                    modifiedMemberOfValues.add(removedGroup);
                }
            }
            if (!modifiedMemberOfValues.isEmpty()) {
                Properties grpList = new Properties();
                grpList.put("ATTRIB_LDAP_NAME", "memberOf");
                grpList.put("ATTRIB_VALUE_COUNT", (Object)2L);
                grpList.put("ATTRIB_VALUE", modifiedMemberOfValues);
                propList.add(grpList);
            }
            ArrayList<String> moveUserAudit = new ArrayList<String>();
            if (this.oldDistinguishedName != null) {
                String ouname = DirectoryObjectUtil.getOUNameFromDN((String)this.oldDistinguishedName);
                String movedFrom = "<B>" + this.rb.getString("admp.mgmt.common.text.move_from") + "</B><br/>" + ouname;
                ouname = DirectoryObjectUtil.getOUNameFromDN((String)this.distinguishedName);
                String movedTo = "<br/><B>" + this.rb.getString("admp.mgmt.common.text.move_to") + "</B><br/>" + ouname;
                moveUserAudit.add(movedFrom);
                moveUserAudit.add(movedTo);
            }
            if (!moveUserAudit.isEmpty()) {
                Properties movedList = new Properties();
                movedList.put("ATTRIB_LDAP_NAME", "container");
                movedList.put("ATTRIB_VALUE_COUNT", (Object)2L);
                movedList.put("ATTRIB_VALUE", moveUserAudit);
                propList.add(movedList);
            }
            if (!this.customList.isEmpty()) {
                ArrayList<String> customAttributeList = new ArrayList<String>();
                for (Hashtable customAttribute : this.customList) {
                    String ldapVsValue = (String)customAttribute.get("ATTRIB_LDAP_NAME") + " : " + customAttribute.get("ATTRIB_VALUE").toString() + "<br/>";
                    customAttributeList.add(ldapVsValue);
                }
                Properties customAuditList = new Properties();
                customAuditList.put("ATTRIB_LDAP_NAME", "customAttributes");
                customAuditList.put("ATTRIB_VALUE_COUNT", (Object)customAttributeList.size());
                customAuditList.put("ATTRIB_VALUE", customAttributeList);
                propList.add(customAuditList);
            }
            if (this.modifiedFullName != null) {
                Properties nameList = new Properties();
                nameList.put("ATTRIB_LDAP_NAME", "name");
                nameList.put("ATTRIB_VALUE", this.modifiedFullName);
                propList.add(nameList);
            }
            if ((value = (props = this.fcNativeProperties.getProps()).getProperty("msExchArchiveDatabaseLink")) != null && !value.equals("")) {
                Properties localArcProps = new Properties();
                if (value.equals("0")) {
                    value = this.rb.getString("admp.mgmt.user_mgmt.cre_template.auto_select_mailbox");
                }
                localArcProps.put("ATTRIB_LDAP_NAME", "msExchArchiveDatabaseLink");
                localArcProps.put("ATTRIB_DISP_NAME", this.rb.getString("admp.mgmt.user_mgmt.create_archive_mailbox.text.archive_database"));
                localArcProps.put("ATTRIB_VALUE", value);
                propList.add(localArcProps);
            }
            if ((value = props.getProperty("msExchArchiveAddress")) != null && !value.equals("")) {
                Properties remoteArcProps = new Properties();
                remoteArcProps.put("ATTRIB_LDAP_NAME", "msExchArchiveAddress");
                remoteArcProps.put("ATTRIB_DISP_NAME", this.rb.getString("admp.mgmt.user_mgmt.create_archive_mailbox.text.archive_domain"));
                remoteArcProps.put("ATTRIB_VALUE", value);
                propList.add(remoteArcProps);
            }
            ArrayList<String> modifiedFullPermission = new ArrayList<String>();
            if (this.addedFullPermissionList != null && !this.addedFullPermissionList.isEmpty()) {
                modifiedFullPermission.add("<B>" + this.rb.getString("admp.audit.display_text.added") + "</B><br/>");
                for (String addedGroup : this.addedFullPermissionList) {
                    modifiedFullPermission.add(addedGroup);
                }
            }
            if (this.toBeRemovedFullPermissionList != null && !this.toBeRemovedFullPermissionList.isEmpty()) {
                String removedHeading = (modifiedFullPermission.isEmpty() ? "" : "<BR/>") + "<B>" + this.rb.getString("admp.audit.display_text.removed") + "</B><br/>";
                modifiedFullPermission.add(removedHeading);
                for (String removedGroup : this.toBeRemovedFullPermissionList) {
                    modifiedFullPermission.add(removedGroup);
                }
            }
            if (!modifiedFullPermission.isEmpty()) {
                Properties grpList = new Properties();
                grpList.put("ATTRIB_LDAP_NAME", "FullAccessRights");
                grpList.put("ATTRIB_VALUE_COUNT", (Object)2L);
                grpList.put("ATTRIB_VALUE", modifiedFullPermission);
                propList.add(grpList);
            }
            if (props.get("sendAs") != null) {
                ArrayList sIDList = (ArrayList)props.get("sendAs");
                ArrayList<String> dNList = new ArrayList<String>();
                ArrayList remainingSIDs = (ArrayList)sIDList.clone();
                String[] tableArray = new String[]{"ADSMUserGeneralDetails", "ADSMGroupGeneralDetails"};
                String[] requiredColumns = new String[]{"DISTINGUISHED_NAME", "SID_STRING"};
                String criteriaColumn = "SID_STRING";
                ArrayList dbValuesList = FcLayoutUtil.getValuesFromTable((String[])tableArray, (String[])requiredColumns, (String)criteriaColumn, (ArrayList)sIDList);
                for (int i = 0; i < dbValuesList.size(); ++i) {
                    Properties dbValueProp = (Properties)dbValuesList.get(i);
                    dNList.add(dbValueProp.getProperty("DISTINGUISHED_NAME"));
                    remainingSIDs.remove(dbValueProp.getProperty("SID_STRING"));
                }
                if (!remainingSIDs.isEmpty()) {
                    dNList.addAll(remainingSIDs);
                }
                Properties sendAsProps = new Properties();
                sendAsProps.put("ATTRIB_LDAP_NAME", "sendAs");
                sendAsProps.put("ATTRIB_DISP_NAME", this.rb.getString("admp.common.attrib_disp_name.send_as"));
                sendAsProps.put("ATTRIB_VALUE", dNList);
                propList.add(sendAsProps);
            }
            Long tid = new Long(request.getParameter("templateId"));
            Properties propToAudit = new Properties();
            propToAudit.put("ATTRIB_LDAP_NAME", this.rb.getString("admp.mgmt.user_mgmt.cre_template.text_template_name"));
            propToAudit.put("ATTRIB_VALUE", FcLayoutViewHandler.getLayoutName((Long)tid, (AdventNetResourceBundle)this.rb));
            propList.add(propToAudit);
            TechAuditAPI.getInstance().auditObjectModification(this.loginId, this.rb.getString("admp.deleg.hdt_deleg.cre_role.action_name.mailbox_mgmt"), this.rb.getString("jsp.UserManagement.UserAdmin.modify_single_sh_mailbox"), this.samAccountName, this.domainName, propList, this.fcNativeProperties.getModifyList(), this.fcNativeProperties.getWinNTAttributeList(), this.fcNativeProperties.getTsList(), null, this.nativeStatusProps.getProperty("STATUS_MESSAGE"), object_id, auditDataObj, this.rb);
            String status = this.nativeStatusProps.getProperty("STATUS_MESSAGE");
            if (status == null) {
                status = "";
            }
            if (this.nativeStatusProps.get("CREATION_MESSAGE") == null) {
                this.nativeStatusProps.put("CREATION_MESSAGE", new ArrayList());
            }
            if ((creationMsg = (ArrayList)this.nativeStatusProps.get("CREATION_MESSAGE")) != null && !creationMsg.isEmpty()) {
                for (int i = 0; i < creationMsg.size(); ++i) {
                    Hashtable creationMessage = (Hashtable)creationMsg.get(i);
                    String errorCode = (String)creationMessage.get("ERROR_CODE");
                    if (errorCode != null && !errorCode.equalsIgnoreCase("0")) {
                        status = status + this.rb.getString("admp.mgmt.user_mgmt.mod_single_user.text_error_code") + " - " + errorCode + " : ";
                    }
                    status = status + this.rb.getString((String)creationMessage.get("ERROR_MESSAGE"));
                    if (creationMessage.get("NATIVE_ERROR_MESSAGE") == null) continue;
                    status = status + creationMessage.get("NATIVE_ERROR_MESSAGE");
                }
            }
            audit_info.put("error_msg", status);
            HDTAuditUtil.fillAuditObjectStatus(audit_info, (DataObject)auditDataObj);
            if (!this.nativeStatusProps.getProperty("CREATION_STATUS").equalsIgnoreCase("SEVERE")) {
                DomainHandler.updateDomainDatas((String)this.domainName, (Long)this.loginId, (String[])new String[]{"User"});
            }
            CommonUtil.getPersistence((boolean[])new boolean[0]).update(auditDataObj);
            TechAuditAPI.getInstance().auditLogs(this.loginId, this.auditLogProps, status, "Single User Modification ", this.rb);
            if (!this.isBulkMgmt && this.nativeStatusProps.getProperty("CREATION_STATUS") != null && !this.nativeStatusProps.getProperty("CREATION_STATUS").equals("SEVERE")) {
                Integer userObjectId = 1;
                String manager = "";
                FcLayoutField field = this.userData.get((Object)FcExecuteActionConstants.SHARED_MAILBOX_MODIFICATION_MANAGER_FIELD_ID) != null ? (FcLayoutField)this.userData.get((Object)FcExecuteActionConstants.SHARED_MAILBOX_MODIFICATION_MANAGER_FIELD_ID) : (FcLayoutField)this.fromClientData.get((Object)FcExecuteActionConstants.SHARED_MAILBOX_MODIFICATION_MANAGER_FIELD_ID);
                if (field != null) {
                    FcManager fcManager = (FcManager)field.getIComponent();
                    manager = fcManager.getUserName() != null ? fcManager.getUserName() : "";
                }
                this.viewId = FcExecuteActionConstants.SMB_LAYOUT_VIEW_ID;
                String ouName = DirectoryObjectUtil.getOUNameFromDN((String)this.distinguishedName);
                ArrayList<String> objectOUList = new ArrayList<String>();
                objectOUList.add(ouName);
                this.triggerNotifiation(audit_id, object_id, this.fullName, manager, null, userObjectId, ReportsUtil.SINGLE_SMB_MODIFICATION_REPORT_ID, this.domainName, this.rb, objectOUList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Properties getSingleUserErrorMessage(NativeError statusObject) {
        String statusMessage = this.rb.getString("admp.reports.common.status_msg.successfully_updated_sh_mailbox");
        String errStatusMessage = this.rb.getString("admp.mgmt.common.statmsg.updated_with_errors");
        Properties statusProps = new Properties();
        ArrayList<Hashtable> messageList = new ArrayList<Hashtable>();
        ArrayList errorList = new ArrayList();
        String errorSeverity = null;
        if (statusObject.getErrorMessage((Object)this.domainName, this.rb) != null) {
            errorList = statusObject.getErrorList((Object)this.domainName);
            errorSeverity = statusObject.getSeverityLevel((Object)this.domainName);
            if (errorSeverity != null) {
                statusProps.setProperty("CREATION_STATUS", errorSeverity);
            }
            statusProps.put("CREATION_MESSAGE", errorList);
            statusProps.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
            statusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
            return statusProps;
        }
        if (statusObject.getErrorMessage((Object)this.distinguishedName, this.rb) != null) {
            errorList = statusObject.getErrorList((Object)this.distinguishedName);
            errorSeverity = statusObject.getSeverityLevel((Object)this.distinguishedName);
            if (errorSeverity != null) {
                statusProps.setProperty("CREATION_STATUS", errorSeverity);
            }
            statusProps.put("CREATION_MESSAGE", errorList);
            statusProps.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
            statusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
            return statusProps;
        }
        if (statusObject.getErrorMessage((Object)this.searchString, this.rb) != null) {
            errorList = statusObject.getErrorList((Object)this.searchString);
            errorSeverity = statusObject.getSeverityLevel((Object)this.searchString);
            if (errorSeverity != null && errorSeverity.equals("SEVERE")) {
                statusProps.setProperty("CREATION_STATUS", errorSeverity);
                statusProps.put("CREATION_MESSAGE", errorList);
                statusProps.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                statusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                return statusProps;
            }
            if (!errorList.isEmpty()) {
                for (Hashtable hashtable : errorList) {
                    messageList.add(hashtable);
                }
            }
        }
        if (!this.searchString.equals(this.samAccountName) && statusObject.getErrorMessage((Object)this.samAccountName, this.rb) != null) {
            errorList = statusObject.getErrorList((Object)this.samAccountName);
            errorSeverity = statusObject.getSeverityLevel((Object)this.samAccountName);
            if (errorSeverity != null && errorSeverity.equals("SEVERE")) {
                statusProps.setProperty("CREATION_STATUS", errorSeverity);
                statusProps.put("CREATION_MESSAGE", errorList);
                statusProps.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                statusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                return statusProps;
            }
            if (!errorList.isEmpty()) {
                for (Hashtable hashtable : errorList) {
                    messageList.add(hashtable);
                }
            }
        }
        for (Object object : this.groupList) {
            if (statusObject.getErrorMessage(object, this.rb) == null || (errorList = statusObject.getErrorList(object)).isEmpty()) continue;
            for (Hashtable hashtable : errorList) {
                messageList.add(hashtable);
            }
        }
        if (messageList.size() > 0) {
            statusProps.setProperty("CREATION_STATUS", "WARNING");
            statusProps.setProperty("STATUS_MESSAGE", errStatusMessage);
            statusProps.put("CREATION_MESSAGE", messageList);
            statusProps.setProperty("CREATION_IMAGE", "/images/alert.gif");
            statusProps.setProperty("CREATION_MESSAGE_STYLE", "greentxtbold");
            return statusProps;
        }
        statusProps.setProperty("CREATION_STATUS", "SUCCESS");
        statusProps.setProperty("STATUS_MESSAGE", statusMessage);
        statusProps.setProperty("CREATION_MESSAGE_STYLE", "greentxtbold");
        return statusProps;
    }

    public void setSingleUserErrorMessage(NativeError errHdlr, String errorKey, String searchKey) {
        ArrayList<Hashtable> messageList = new ArrayList<Hashtable>();
        ArrayList errorList = new ArrayList();
        if (errHdlr.getErrorMessage((Object)searchKey, this.rb) != null) {
            messageList = (ArrayList<Hashtable>)this.nativeStatusProps.get("CREATION_MESSAGE");
            if (messageList == null) {
                messageList = new ArrayList<Hashtable>();
            }
            errorList = errHdlr.getErrorList((Object)searchKey);
            for (Hashtable hashtable : errorList) {
                String message = this.rb.getString((String)hashtable.get("ERROR_MESSAGE"));
                message = MessageFormat.format(this.rb.getString(errorKey), message);
                hashtable.put("ERROR_MESSAGE", message);
                messageList.add(hashtable);
            }
            this.nativeStatusProps.put("CREATION_MESSAGE", messageList);
            this.nativeStatusProps.setProperty("CREATION_IMAGE", "/images/alert.gif");
        }
    }

    public boolean getIsBulkMgmt() {
        return false;
    }

    public Properties getNativeStatusProps() {
        return null;
    }

    public void setSingleUserErrorMessage(String appsResult) {
    }
}

