/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.layout.gapps;

import com.adventnet.sym.adsm.common.server.O365MgmtHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.iam.GAppsAdminConfiguration;
import com.adventnet.sym.adsm.common.server.layout.FcAttributes;
import com.adventnet.sym.adsm.common.server.layout.FcFields;
import com.adventnet.sym.adsm.common.server.layout.FcFormDataContainer;
import com.adventnet.sym.adsm.common.server.layout.FcIamApp;
import com.adventnet.sym.adsm.common.server.layout.FcIamApps;
import com.adventnet.sym.adsm.common.server.layout.FcLayout;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutConstants;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutField;
import com.adventnet.sym.adsm.common.server.layout.FcUserCreationMgmtHandler;
import com.adventnet.sym.adsm.common.webclient.layout.FcMgmtListener;
import com.adventnet.sym.adsm.common.webclient.layout.gapps.GappsMgmtUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;

public class GoogleAppsUserCreationListener
extends FcMgmtListener {
    String givenName = "";
    String familyName = "";
    String email = "";
    String password = "";
    String orgUnit = "";
    ArrayList<String> groupEmail = null;
    String groupEmailstring = "";
    boolean isValidUpn = true;
    boolean changePasswordAtNextLogin = false;
    Properties nativeStatusProperties = null;
    private Logger log = Logger.getLogger("FcLogger");

    public void doAction(Long creationId, String domainName, FcLayout executeLayout, FcFormDataContainer fromClientData, FcFormDataContainer userData, FcFormDataContainer adData, FcIamApps fcIamApps, Long loginId, FcLayout executeLayoutForm) {
        this.doAction(creationId, domainName, executeLayout, fromClientData, userData, adData, fcIamApps, loginId);
    }

    public void doAction(Long creationId, String domainName, FcLayout executeLayout, FcFormDataContainer fromClientData, FcFormDataContainer userData, FcFormDataContainer adData, FcIamApps fcIamApps, Long loginId) {
        this.setIsGApps(true);
        this.creationId = creationId;
        this.domainName = domainName;
        this.executeLayout = executeLayout;
        this.fromClientData = fromClientData;
        this.userData = userData;
        this.fcIamApps = fcIamApps;
        this.loginId = loginId;
        this.nativeStatusProperties = new Properties();
        this.createUser();
    }

    private void createUser() {
        this.initAttributeValues();
        this.nativeStatusProperties.put("isSuccess", (Object)false);
        Properties gAppsConfigProp = GAppsAdminConfiguration.getGAppsConfigData((String)this.domainName, (Long)this.loginId);
        if (gAppsConfigProp == null) {
            this.nativeStatusProperties.put("message", this.rb.getString("admp.mgmt.gapps.error_when_fetching_credentials"));
            return;
        }
        if (!this.isValidUpn) {
            this.nativeStatusProperties.put("message", this.rb.getString("admp.deleg.hdt_deleg.mod_hdt.text_gsuite_domain_not_authorized"));
            return;
        }
        boolean isSuccess = false;
        if (this.familyName.trim().equals("")) {
            this.familyName = this.givenName;
        }
        if (isSuccess = GappsMgmtUtil.addNewUser(gAppsConfigProp, this.nativeStatusProperties, this.givenName, this.familyName, this.email, this.password, this.changePasswordAtNextLogin, this.orgUnit, this.groupEmail)) {
            this.nativeStatusProperties.put("message", this.rb.getString("admp.mgmt.gapps.user_created_successfully"));
            this.nativeStatusProperties.put("isSuccess", (Object)true);
        } else {
            if (this.nativeStatusProperties.get("message") != null) {
                this.nativeStatusProperties.put("message", this.rb.getString(this.nativeStatusProperties.getProperty("message")));
            } else {
                this.nativeStatusProperties.put("message", this.rb.getString("admp.mgmt.gapps.user_not_created_successfully"));
            }
            this.nativeStatusProperties.put("isSuccess", (Object)false);
        }
    }

    private void initAttributeValues() {
        Properties prop = new Properties();
        prop.put("domainName", this.domainName);
        Properties ldapVsValueProps = FcUserCreationMgmtHandler.getInstance().getLdapVsValues(this.fromClientData, prop);
        Enumeration e = this.fromClientData.elements();
        while (e.hasMoreElements()) {
            FcLayoutField fcLayoutField = (FcLayoutField)e.nextElement();
            Integer iamAppId = fcLayoutField.getIamAppId();
            if (iamAppId.intValue() == FcLayoutConstants.GOOGLE_APPS_APPID.intValue()) {
                ArrayList fcAttributeList = fcLayoutField.getFcAttributeList();
                for (FcAttributes fcAttribute : fcAttributeList) {
                    String attributeName = fcAttribute.getAttribLdapName();
                    Object attribValue = fcAttribute.getAttribValue();
                    if ("gappsOrgUnitPath".equals(attributeName)) {
                        if (attribValue == null) continue;
                        this.orgUnit = attribValue.toString();
                        continue;
                    }
                    if (!"gappsGroupEmail".equals(attributeName) || attribValue == null) continue;
                    this.groupEmailstring = attribValue.toString();
                    ArrayList<String> groupNameAndEmail = new ArrayList<String>(Arrays.asList(this.groupEmailstring.split(",|;")));
                    this.groupEmail = new ArrayList();
                    for (String groupEmailTemp : groupNameAndEmail) {
                        this.groupEmail.add(groupEmailTemp.trim());
                    }
                }
                continue;
            }
            if (fcLayoutField.getChildFieldArr() == null || fcLayoutField.getChildFieldArr().size() <= 0) continue;
            FcIamApp fcIamApp = this.fcIamApps.getIamApp(iamAppId);
            ArrayList childFieldArr = fcLayoutField.getChildFieldArr();
            int length = fcLayoutField.getChildFieldArr().size();
            for (int i = 0; i < length; ++i) {
                FcFields fcFields = fcIamApp.getChildFieldObject((Long)childFieldArr.get(i));
                if (fcFields == null || fcFields.getIamAppId().intValue() != FcLayoutConstants.GOOGLE_APPS_APPID.intValue()) continue;
                ArrayList fcAttributeList = fcLayoutField.getFcAttributeList();
                for (FcAttributes fcAttribute : fcAttributeList) {
                    String attributeName = fcAttribute.getAttribLdapName();
                    Object attribValue = fcAttribute.getAttribValue();
                    if ("givenName".equals(attributeName)) {
                        if (attribValue == null) continue;
                        this.givenName = attribValue.toString();
                        continue;
                    }
                    if ("sn".equals(attributeName)) {
                        if (attribValue == null) continue;
                        this.familyName = attribValue.toString();
                        continue;
                    }
                    if ("mail".equals(attributeName)) {
                        Properties gAppsConfigProps;
                        if (attribValue == null) continue;
                        this.email = attribValue.toString();
                        String upnSuffix = this.email.substring(this.email.indexOf("@") + 1);
                        if (fcLayoutField.getIsReadOnly().booleanValue() || (gAppsConfigProps = O365MgmtHandler.getO365ConfigData((String)this.domainName, (Long)this.loginId, (int)FcLayoutConstants.GOOGLE_APPS_APPID)) == null) continue;
                        ArrayList authorizedDomains = (ArrayList)gAppsConfigProps.get("authorizedDomains");
                        ArrayList configuredDomains = (ArrayList)gAppsConfigProps.get("configuredDomains");
                        boolean isAuthorized = false;
                        boolean isConfigured = false;
                        for (String domain : authorizedDomains) {
                            if (!domain.equalsIgnoreCase(upnSuffix)) continue;
                            isAuthorized = true;
                            break;
                        }
                        for (String domain : configuredDomains) {
                            if (!domain.equalsIgnoreCase(upnSuffix)) continue;
                            isConfigured = true;
                            break;
                        }
                        if (!isConfigured || isAuthorized) continue;
                        this.isValidUpn = false;
                        continue;
                    }
                    if ("password".equalsIgnoreCase(attributeName)) {
                        this.password = (String)attribValue;
                        continue;
                    }
                    if (attributeName.equalsIgnoreCase("passwordType") || !attributeName.equalsIgnoreCase("pwdLastSet") || attribValue == null) continue;
                    this.changePasswordAtNextLogin = (Long)attribValue == 0L;
                }
            }
        }
        this.log.log(Level.INFO, this.toString());
    }

    @Override
    public HashMap getSAMAccVsGAppsId(String sAMAccName) {
        HashMap<String, Object> sAMAccVsGAppsId = new HashMap<String, Object>();
        sAMAccVsGAppsId.put(sAMAccName, this.nativeStatusProperties.get("objectId"));
        return sAMAccVsGAppsId;
    }

    public void setIsCreationSuccess() {
    }

    public void setStatusMsgForResponse(HttpServletRequest request) {
    }

    public boolean getIsCreationSuccess() {
        return false;
    }

    public void reInit() {
    }

    public boolean getIsBulkMgmt() {
        return false;
    }

    public Properties getNativeStatusProps() {
        return this.nativeStatusProperties;
    }

    public String getRusMessage() {
        return null;
    }

    public void setRusMessage(String string) {
    }

    public void setSingleUserErrorMessage(String appsResult) {
    }

    public String toString() {
        String groupMailTemp = "";
        if (this.groupEmail != null && this.groupEmail.size() != 0) {
            for (String temp : this.groupEmail) {
                groupMailTemp = groupMailTemp + temp + ",";
            }
        }
        String string = "Google Apps Attributes list:- givenName : " + this.givenName + ", familyName: " + this.familyName + ", email: " + this.email + ", changePwdAtNextLogon: " + this.changePasswordAtNextLogin + ",orgUnit: " + this.orgUnit + ",groupEmail:" + groupMailTemp;
        return string;
    }

    @Override
    public void doBulkAction(HttpServletRequest request, Object bean, Object fcIamApps, Long loginId) {
    }

    @Override
    public void setRb(AdventNetResourceBundle rb) {
        this.rb = rb;
    }

    public void setFieldValueList(Properties fieldValue) {
    }
}

