/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.layout.o365;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.O365InfoCache;
import com.adventnet.sym.adsm.common.server.O365MgmtHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.layout.FcAttributes;
import com.adventnet.sym.adsm.common.server.layout.FcFields;
import com.adventnet.sym.adsm.common.server.layout.FcFormDataContainer;
import com.adventnet.sym.adsm.common.server.layout.FcIamApp;
import com.adventnet.sym.adsm.common.server.layout.FcIamApps;
import com.adventnet.sym.adsm.common.server.layout.FcLayout;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutConstants;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutField;
import com.adventnet.sym.adsm.common.server.layout.FcUserCreationMgmtHandler;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.model.ObjectClass;
import com.adventnet.sym.adsm.common.server.multidc.MultiDCUtil;
import com.adventnet.sym.adsm.common.server.objects.DirectoryObjectAPI;
import com.adventnet.sym.adsm.common.server.queue.QueueHandler;
import com.adventnet.sym.adsm.common.server.reports.DBStringTransformerUtil;
import com.adventnet.sym.adsm.common.server.reports.O365GroupHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportAttributeHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.UserMgmtUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.webclient.layout.FcExecuteNamingFormat;
import com.adventnet.sym.adsm.common.webclient.layout.FcMgmtListener;
import com.adventnet.sym.adsm.common.webclient.layout.o365.O365MgmtUtil;
import com.manageengine.ads.fw.logforward.LogForwarderAPI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class O365AppsUserCreationListener
extends FcMgmtListener
implements NativeListener {
    ArrayList<Properties> attribListToNative = null;
    ArrayList<String> attributeList = null;
    ArrayList<Properties> exchangeAttribToNative = null;
    ArrayList<Properties> delegAttribToNative = null;
    ArrayList<String> securityGroupList = null;
    ArrayList<Properties> mailGroupList = null;
    ArrayList auditList = null;
    Integer o365UserCreationType = 0;
    ArrayList licenseList = null;
    Properties passwordList = null;
    String usageLocation = null;
    boolean isValidUpn = true;
    boolean forceChangePassword = false;
    boolean isDisplayNameAvailable = false;
    String userPrincipalName = null;
    Properties nativeStatusProperties = null;
    boolean isBulkMgmt = false;
    String upnSuffix = "";
    boolean isBulkUserMgmt = false;
    protected String objectClass = "o365user";
    protected ObjectClass objClass;
    protected ArrayList attributeProps;
    protected Long queueRegID = null;
    protected String baseTableName = "O365UserGeneralDetails";
    protected ArrayList attributeListToUpdate;
    protected Hashtable attributeListHash;
    protected boolean isCompleted = false;
    boolean isRandomPassword = false;
    String passwordStr = "";
    private static final int O365_USER_FROM_AD_USER_REPORT_ID = 8055;
    private static Logger logg = Logger.getLogger("ADMangLogger");

    public boolean isCompleted() {
        return this.isCompleted;
    }

    public boolean isExcludeChildOU() {
        return false;
    }

    public void setIsExcludeChildOU(Boolean isExcludeChildOU) {
    }

    public void setNativeError(String domainName, Hashtable errorHash) {
    }

    public void setNativeError(String domainName, String dCName, Hashtable errorHash) {
    }

    public void addRow(Properties prop) {
        Properties uiProps = new Properties();
        Hashtable tableStringMap = DBStringTransformerUtil.getReportRows((Properties)prop, (ArrayList)this.attributeProps, (String)"", (Properties)uiProps, (Hashtable)new Properties(), (AdventNetResourceBundle)this.rb);
        QueueHandler.getInstance().getQueue(this.objClass.getId()).updateData(this.queueRegID, tableStringMap);
    }

    protected ArrayList getObjIdList() {
        this.objClass = DirectoryObjectAPI.getInstance().getObjectClassFromBaseTableName(this.baseTableName);
        ArrayList<Integer> objectIds = new ArrayList<Integer>();
        objectIds.add(this.objClass.getId());
        return objectIds;
    }

    public void completedAction() {
        this.endQueue();
    }

    public void endQueue() {
        this.postNativeData();
        this.deRegister();
        this.queueRegID = null;
    }

    private void postNativeData() {
        QueueHandler.getInstance().postNativeData(this.queueRegID);
    }

    private void deRegister() {
        QueueHandler.getInstance().deRegister(this.queueRegID);
    }

    protected void initAttributeList(int reportId) {
        ArrayList<Object> attribIdList = new ArrayList<Object>();
        this.attributeListToUpdate = new ArrayList();
        this.attributeProps = new ArrayList();
        this.attributeListHash = new Hashtable();
        try {
            ArrayList tableNames = ReportAttributeHandler.getInstance().getTableNames(Integer.valueOf(reportId));
            for (int i = 0; i < tableNames.size(); ++i) {
                ArrayList l = ReportAttributeHandler.getInstance().getAttributes((String)tableNames.get(i), Integer.valueOf(reportId));
                for (int j = 0; j < l.size(); ++j) {
                    Properties p = (Properties)l.get(j);
                    if (this.attributeListToUpdate.contains(p.get("ATTRIB_LDAP_NAME"))) continue;
                    attribIdList.add(p.get("ATTRIB_ID"));
                    this.attributeListToUpdate.add(p.get("ATTRIB_LDAP_NAME"));
                    String tableName = (String)p.get("TABLE_NAME");
                    String columnName = (String)p.get("ATTRIB_COLUMN_NAME");
                    String ldapName = (String)p.get("ATTRIB_LDAP_NAME");
                    ArrayList<String> columns = (ArrayList<String>)this.attributeListHash.get(tableName);
                    if (columns == null) {
                        columns = new ArrayList<String>();
                        this.attributeListHash.put(tableName, columns);
                    }
                    columns.add(columnName);
                }
            }
            DataObject attributeDO = CommonUtil.getCachedPersistence().get("ADSMAttributeDetails", (Criteria)null);
            Iterator it = attributeDO.getRows("ADSMAttributeDetails", new Criteria(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_ID"), (Object)attribIdList.toArray(), 8));
            while (it.hasNext()) {
                Row r = (Row)it.next();
                this.attributeProps.add(MultiDCUtil.getProps((Row)r));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void doAction(Long creationId, String domainName, FcLayout executeLayout, FcFormDataContainer fromClientData, FcFormDataContainer userData, FcFormDataContainer adData, FcIamApps fcIamApps, Long loginId, FcLayout executeLayoutForm) {
        this.doAction(creationId, domainName, executeLayout, fromClientData, userData, adData, fcIamApps, loginId);
    }

    public void doAction(Long creationId, String domainName, FcLayout executeLayout, FcFormDataContainer fromClientData, FcFormDataContainer userData, FcFormDataContainer adData, FcIamApps fcIamApps, Long loginId) {
        this.creationId = creationId;
        this.domainName = domainName;
        this.executeLayout = executeLayout;
        this.fromClientData = fromClientData;
        this.userData = userData;
        this.fcIamApps = fcIamApps;
        this.loginId = loginId;
        this.nativeStatusProperties = new Properties();
        if (this.executeLayout == null) {
            this.isBulkMgmt = true;
        }
        this.createUser();
    }

    private void createUser() {
        this.delegAttribToNative = new ArrayList();
        this.exchangeAttribToNative = new ArrayList();
        this.attribListToNative = new ArrayList();
        this.attributeList = new ArrayList();
        this.licenseList = new ArrayList();
        this.passwordList = new Properties();
        this.securityGroupList = new ArrayList();
        this.mailGroupList = new ArrayList();
        this.nativeStatusProperties.put("isSuccess", (Object)false);
        this.nativeStatusProperties.put("message", "");
        Properties o365ConfigProp = O365MgmtHandler.getO365ConfigData((String)this.domainName, (Long)this.loginId);
        if (o365ConfigProp == null) {
            this.nativeStatusProperties.put("message", this.rb.getString("admp.mgmt.fc_layout.no_office365_credentials"));
            return;
        }
        String o365TenantId = o365ConfigProp.getProperty("username");
        String o365TenantPass = o365ConfigProp.getProperty("password");
        this.initAttributeIAMValues(o365ConfigProp, true);
        boolean canCreateO365User = true;
        if (!this.isValidUpn) {
            this.nativeStatusProperties.put("message", this.rb.getString("admp.deleg.hdt_deleg.mod_hdt.text_domain_not_authorized"));
            return;
        }
        if (this.licenseList.size() > 0 && (this.usageLocation == null || this.usageLocation.length() == 0)) {
            canCreateO365User = false;
            O365MgmtUtil.fillUsageLocationMandatoryError(this.nativeStatusProperties, this.rb);
        }
        if (canCreateO365User && this.o365UserCreationType.equals(1) && !this.attributeList.contains("ImmutableId")) {
            this.nativeStatusProperties.put("message", this.rb.getString("admp.mgmt.office365.error.unable_to_fetch_aduser_guid"));
            this.nativeStatusProperties.put("isSuccess", (Object)false);
        }
        if (canCreateO365User) {
            boolean isSuccess = false;
            boolean isDirSync = this.o365UserCreationType.equals(1);
            this.initAttributeList(8055);
            this.queueRegID = QueueHandler.getInstance().registerForUpdate(this.getObjIdList(), this.attributeListHash);
            isSuccess = O365MgmtUtil.addNewUser(this.nativeStatusProperties, o365TenantId, o365TenantPass, this.attribListToNative, this.licenseList, this.rb, isDirSync, this.securityGroupList, this.exchangeAttribToNative, this.mailGroupList, this.loginId, this, this.attributeListToUpdate, this.sourceAction, this.passwordList);
            if (isSuccess) {
                // empty if block
            }
            this.sendSysLogs(this.rb.getString("admp.mgmt.fc_layout.o365_user_creation"), this.nativeStatusProperties.getProperty("message"), o365TenantId);
        }
    }

    public void initAttributeIAMValues(Properties o365ConfigProp, boolean isUserObject) {
        Properties prop = new Properties();
        prop.put("domainName", this.domainName);
        O365InfoCache.getInstance();
        String moduleName = O365InfoCache.getInstalledModule();
        Properties ldapVsValueProps = FcUserCreationMgmtHandler.getInstance().getLdapVsValues(this.fromClientData, prop);
        String o365TenantId = o365ConfigProp.containsKey("WAAD_TENANT_ID") ? o365ConfigProp.getProperty("WAAD_TENANT_ID") : o365ConfigProp.getProperty("username");
        Enumeration e = this.fromClientData.elements();
        while (e.hasMoreElements()) {
            FcLayoutField fcLayoutField = (FcLayoutField)e.nextElement();
            Integer iamAppId = fcLayoutField.getIamAppId();
            if (iamAppId.intValue() == FcLayoutConstants.OFFICE_365_APPID.intValue()) {
                ArrayList fcAttributeList = fcLayoutField.getFcAttributeList();
                for (FcAttributes fcAttribute : fcAttributeList) {
                    String attributeName = fcAttribute.getAttribLdapName();
                    Object attribValue = fcAttribute.getAttribValue();
                    if ("waadLicenseInfo".equalsIgnoreCase(attributeName)) {
                        if (attribValue == null) continue;
                        this.licenseList = O365MgmtUtil.getLicenseOptions(o365TenantId, (JSONArray)attribValue, this.domainName);
                        if (!this.isBulkUserMgmt) continue;
                        this.auditList.add(this.getAuditProps(this.rb.getString(fcAttribute.getAttribDisplayName()), O365MgmtUtil.getLicenseForAudit(o365TenantId, (JSONArray)attribValue, this.rb)));
                        continue;
                    }
                    if ("waadEnabledType".equalsIgnoreCase(attributeName)) {
                        if (attribValue == null) continue;
                        this.o365UserCreationType = (Integer)attribValue;
                        continue;
                    }
                    if ("fullPermission".equalsIgnoreCase(attributeName) || "GrantSendOnBehalfTo".equalsIgnoreCase(attributeName) || "o365SendAs".equalsIgnoreCase(attributeName) || "sendAs".equalsIgnoreCase(attributeName)) {
                        if (attribValue == null) continue;
                        ArrayList permissionList = (ArrayList)attribValue;
                        String attribStr = new String();
                        for (int i = 0; i < permissionList.size(); ++i) {
                            if (i != 0) {
                                attribStr = attribStr + ",";
                            }
                            attribStr = attribStr + "\"" + (String)permissionList.get(i) + "\"";
                        }
                        this.addAttribValueToDelegList(attributeName, attribStr);
                        continue;
                    }
                    if ("e_mail_address".equalsIgnoreCase(attributeName)) {
                        if (attribValue == null) continue;
                        this.addAttribValueToExchangeList("PrimarySmtpAddress", "S:" + attribValue.toString());
                        continue;
                    }
                    if ("O365UserPrincipalName".equalsIgnoreCase(attributeName)) {
                        if (attribValue == null) continue;
                        String upnValue = (String)attribValue;
                        String upnSuffix = upnValue.substring(upnValue.indexOf("@") + 1);
                        boolean isAuthorizedDomain = false;
                        boolean isConfiguredDomain = false;
                        if (o365ConfigProp.get("authorizedDomains") != null && o365ConfigProp.get("configuredDomains") != null) {
                            ArrayList list = (ArrayList)((ArrayList)o365ConfigProp.get("authorizedDomains")).clone();
                            Collections.sort(list, String.CASE_INSENSITIVE_ORDER);
                            if (Collections.binarySearch(list, upnSuffix, String.CASE_INSENSITIVE_ORDER) >= 0) {
                                isAuthorizedDomain = true;
                            }
                            list = (ArrayList)((ArrayList)o365ConfigProp.get("configuredDomains")).clone();
                            Collections.sort(list, String.CASE_INSENSITIVE_ORDER);
                            if (Collections.binarySearch(list, upnSuffix, String.CASE_INSENSITIVE_ORDER) >= 0) {
                                isConfiguredDomain = true;
                            }
                            if (!fcLayoutField.getIsReadOnly().booleanValue() && isConfiguredDomain && !isAuthorizedDomain) {
                                this.isValidUpn = false;
                            }
                        }
                        this.userPrincipalName = upnValue;
                        if (this.userPrincipalName == null) continue;
                        this.attributeList.remove("UserPrincipalName");
                        for (int i = 0; i < this.attribListToNative.size(); ++i) {
                            Properties attribute = this.attribListToNative.get(i);
                            String parameter = attribute.get("PARAMETER").toString();
                            if (!parameter.equalsIgnoreCase("UserPrincipalName")) continue;
                            this.attribListToNative.remove(i);
                            break;
                        }
                        this.addAttribValueToList("UserPrincipalName", "S:" + this.userPrincipalName);
                        continue;
                    }
                    if ("GroupMemberObjectId".equalsIgnoreCase(attributeName)) {
                        if (attribValue == null) continue;
                        ArrayList groupList = (ArrayList)attribValue;
                        this.addAttribValueToGroupList(attributeName, groupList);
                        if (!this.isBulkUserMgmt) continue;
                        this.auditList.add(this.getAuditProps(this.rb.getString(fcAttribute.getAttribDisplayName()), O365MgmtHandler.getDisplayNameForAudit((ArrayList)groupList)));
                        continue;
                    }
                    if ("Alias".equalsIgnoreCase(attributeName) || "ArchiveName".equalsIgnoreCase(attributeName)) {
                        if (attribValue == null) continue;
                        String value = attribValue.toString();
                        if (!this.isBulkUserMgmt) {
                            value = FcExecuteNamingFormat.getFormatValue(attribValue.toString(), null, ldapVsValueProps);
                            fcAttribute.setAttributeValue((Object)value);
                        }
                        this.addAttribValueToExchangeList(attributeName, value);
                        continue;
                    }
                    if ("LitigationHoldEnabled".equalsIgnoreCase(attributeName) || "LitigationHoldDuration".equalsIgnoreCase(attributeName) || "InPlaceArchive".equalsIgnoreCase(attributeName) || "HiddenFromAddressListsEnabled".equalsIgnoreCase(attributeName) || "AuditEnabled".equalsIgnoreCase(attributeName)) {
                        if (attribValue == null) continue;
                        this.addAttribValueToExchangeList(attributeName, attribValue.toString());
                        if (!this.isBulkUserMgmt) continue;
                        this.auditList.add(this.getAuditProps(this.rb.getString(fcAttribute.getAttribDisplayName()), attribValue.toString()));
                        continue;
                    }
                    if (attributeName.equalsIgnoreCase("PasswordType")) {
                        try {
                            String attribVal = attribValue.toString();
                            if ("generatePwd".equals(attribVal)) {
                                this.isRandomPassword = true;
                                continue;
                            }
                            if (!"ownPwd".equals(attribVal)) continue;
                            this.passwordStr = (String)ldapVsValueProps.get("password");
                            this.addAttribValueToList("Password", "S:" + this.passwordStr);
                            this.auditList.add(this.getAuditProps(this.rb.getString("admp.common.attrib_disp_name.password"), this.passwordStr));
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                        continue;
                    }
                    if ("c".equalsIgnoreCase(attributeName)) {
                        if (attribValue == null) continue;
                        this.addAttribValueToList("UsageLocation", "S:" + attribValue.toString());
                        this.auditList.add(this.getAuditProps(this.rb.getString("admp.common.attrib_disp_name.usage_location"), attribValue));
                        continue;
                    }
                    if (!"WAADDomainName".equalsIgnoreCase(attributeName)) continue;
                    this.upnSuffix = attribValue.toString();
                    this.auditList.add(this.getAuditProps(this.rb.getString(fcAttribute.getAttribDisplayName()), attribValue));
                }
                continue;
            }
            if (fcLayoutField.getChildFieldArr() == null || fcLayoutField.getChildFieldArr().size() <= 0) continue;
            FcIamApp fcIamApp = this.fcIamApps.getIamApp(iamAppId);
            ArrayList childFieldArr = fcLayoutField.getChildFieldArr();
            int length = fcLayoutField.getChildFieldArr().size();
            for (int i = 0; i < length; ++i) {
                FcFields fcField = fcIamApp.getChildFieldObject((Long)childFieldArr.get(i));
                if (fcField == null || fcField.getIamAppId().intValue() != FcLayoutConstants.OFFICE_365_APPID.intValue()) continue;
                ArrayList fcAttributeList = fcLayoutField.getFcAttributeList();
                if (moduleName.equalsIgnoreCase("AzureAD")) {
                    this.getAzureADAttributeDetails(fcAttributeList, o365ConfigProp, isUserObject);
                    continue;
                }
                this.getMSOnlineAttributeDetails(fcAttributeList, o365ConfigProp, isUserObject);
            }
        }
        if (isUserObject) {
            if (moduleName.equalsIgnoreCase("MSOnline")) {
                this.addAttribValueToList("ForceChangePassword", "B:" + String.valueOf(this.forceChangePassword));
            } else {
                this.passwordList.put("ForceChangePassword", String.valueOf(this.forceChangePassword));
            }
            if (!this.isDisplayNameAvailable && this.userPrincipalName != null) {
                this.addAttribValueToList("DisplayName", "S:" + this.userPrincipalName.substring(0, this.userPrincipalName.indexOf("@")));
            }
        }
        if (this.o365UserCreationType == 1 && this.getisADSelected()) {
            String searchString = "(&(objectClass=user)(objectCategory=user))";
            String adUserName = ldapVsValueProps.getProperty("name");
            String adOUName = ldapVsValueProps.getProperty("OUName");
            if (this.isBulkMgmt && this.commonContainerName != null && !this.commonContainerName.equals("")) {
                adOUName = this.commonContainerName;
            }
            adUserName = CommonUtil.escapeString((String)adUserName, (String[])UserMgmtUtil.USERNAME_ESCAPE_CHARECTERS);
            String adDistinguishedName = "CN=" + adUserName + "," + adOUName;
            logg.log(Level.INFO, "Fetching guid with DN: " + adDistinguishedName);
            String objectGUID = O365MgmtUtil.getADUserObjectGUID(this.domainName, this.loginId, adDistinguishedName, searchString);
            logg.log(Level.INFO, "Setting ObjectGUID for O365 ImmutableId: " + objectGUID);
            if (objectGUID != null && objectGUID.length() > 0) {
                this.addAttribValueToList("ImmutableId", "I:" + objectGUID);
            }
        }
    }

    private void getMSOnlineAttributeDetails(ArrayList<FcAttributes> fcAttributeList, Properties o365ConfigProp, boolean isUserObject) {
        for (FcAttributes fcAttribute : fcAttributeList) {
            String attributeName = fcAttribute.getAttribLdapName();
            Object attribValue = fcAttribute.getAttribValue();
            if ("givenName".equalsIgnoreCase(attributeName)) {
                if (attribValue == null) continue;
                this.addAttribValueToList("FirstName", "S:" + attribValue.toString());
                continue;
            }
            if ("sn".equalsIgnoreCase(attributeName)) {
                if (attribValue == null) continue;
                this.addAttribValueToList("LastName", "S:" + attribValue.toString());
                continue;
            }
            if ("password".equalsIgnoreCase(attributeName)) {
                if (attribValue == null) continue;
                this.addAttribValueToList("Password", "S:" + attribValue.toString());
                continue;
            }
            if (attributeName.equalsIgnoreCase("passwordType")) continue;
            if ("userPrincipalName".equalsIgnoreCase(attributeName)) {
                if (attribValue == null) continue;
                String upnValue = (String)attribValue;
                String upnSuffix = upnValue.substring(upnValue.indexOf("@") + 1);
                if (o365ConfigProp.get("defaultDomain") != null && o365ConfigProp.get("configuredDomains") != null) {
                    ArrayList list = (ArrayList)((ArrayList)o365ConfigProp.get("configuredDomains")).clone();
                    Collections.sort(list, String.CASE_INSENSITIVE_ORDER);
                    if (Collections.binarySearch(list, upnSuffix, String.CASE_INSENSITIVE_ORDER) < 0) {
                        upnValue = upnValue.replace(upnSuffix, (String)o365ConfigProp.get("defaultDomain"));
                    }
                }
                this.addAttribValueToList("UserPrincipalName", "S:" + upnValue);
                this.userPrincipalName = upnValue;
                continue;
            }
            if ("displayName".equalsIgnoreCase(attributeName)) {
                if (attribValue == null) continue;
                this.addAttribValueToList("DisplayName", "S:" + attribValue.toString());
                this.isDisplayNameAvailable = true;
                continue;
            }
            if ("streetAddress".equalsIgnoreCase(attributeName)) {
                if (attribValue == null) continue;
                this.addAttribValueToList("StreetAddress", "S:" + attribValue.toString());
                continue;
            }
            if ("department".equalsIgnoreCase(attributeName)) {
                if (attribValue == null) continue;
                this.addAttribValueToList("Department", "S:" + attribValue.toString());
                continue;
            }
            if ("mobile".equalsIgnoreCase(attributeName)) {
                if (attribValue == null) continue;
                this.addAttribValueToList("MobilePhone", "S:" + attribValue.toString());
                continue;
            }
            if ("telephoneNumber".equalsIgnoreCase(attributeName)) {
                if (attribValue == null) continue;
                this.addAttribValueToList("PhoneNumber", "S:" + attribValue.toString());
                continue;
            }
            if ("physicalDeliveryOfficeName".equalsIgnoreCase(attributeName)) {
                if (attribValue == null) continue;
                this.addAttribValueToList("Office", "S:" + attribValue.toString());
                continue;
            }
            if ("facsimileTelephoneNumber".equalsIgnoreCase(attributeName)) {
                if (attribValue == null) continue;
                this.addAttribValueToList("Fax", "S:" + attribValue.toString());
                continue;
            }
            if ("co".equalsIgnoreCase(attributeName)) {
                if (attribValue == null) continue;
                this.addAttribValueToList("Country", "S:" + attribValue.toString());
                continue;
            }
            if ("c".equalsIgnoreCase(attributeName)) {
                if (attribValue == null) continue;
                this.usageLocation = attribValue.toString();
                this.addAttribValueToList("UsageLocation", "S:" + attribValue.toString());
                continue;
            }
            if ("st".equalsIgnoreCase(attributeName)) {
                if (attribValue == null) continue;
                this.addAttribValueToList("State", "S:" + attribValue.toString());
                continue;
            }
            if ("l".equalsIgnoreCase(attributeName)) {
                if (attribValue == null) continue;
                this.addAttribValueToList("City", "S:" + attribValue.toString());
                continue;
            }
            if ("postalCode".equalsIgnoreCase(attributeName)) {
                if (attribValue == null) continue;
                this.addAttribValueToList("PostalCode", "S:" + attribValue.toString());
                continue;
            }
            if ("title".equalsIgnoreCase(attributeName)) {
                if (attribValue == null) continue;
                this.addAttribValueToList("Title", "S:" + attribValue.toString());
                continue;
            }
            if ("pwdLastSet".equalsIgnoreCase(attributeName)) {
                if (attribValue == null || !((Long)attribValue).equals(0L)) continue;
                this.forceChangePassword = true;
                continue;
            }
            if ("userAccountControl".equalsIgnoreCase(attributeName)) {
                if (attribValue == null) continue;
                JSONObject useAccCtrlJson = (JSONObject)attribValue;
                try {
                    if (!useAccCtrlJson.has("value")) continue;
                    Long userAccCtrlFlag = (Long)useAccCtrlJson.get("value");
                    if (userAccCtrlFlag.equals(65536L)) {
                        this.addAttribValueToList("PasswordNeverExpires", "B:" + ((Boolean)useAccCtrlJson.get("isChecked")).toString());
                        continue;
                    }
                    if (!userAccCtrlFlag.equals(2L)) continue;
                    this.addAttribValueToList("BlockCredential", "B:" + ((Boolean)useAccCtrlJson.get("isChecked")).toString());
                }
                catch (JSONException ex) {
                    ex.printStackTrace();
                }
                continue;
            }
            if ("name".equalsIgnoreCase(attributeName) && !isUserObject) {
                if (attribValue == null) continue;
                this.addAttribValueToExchangeList("Name", "S:" + attribValue.toString());
                continue;
            }
            if (!"mailNickname".equalsIgnoreCase(attributeName) || isUserObject || attribValue == null) continue;
            this.addAttribValueToExchangeList("Alias", "S:" + attribValue.toString());
        }
    }

    private void getAzureADAttributeDetails(ArrayList<FcAttributes> fcAttributeList, Properties o365ConfigProp, boolean isUserObject) {
        for (FcAttributes fcAttribute : fcAttributeList) {
            String attributeName = fcAttribute.getAttribLdapName();
            Object attribValue = fcAttribute.getAttribValue();
            if ("givenName".equalsIgnoreCase(attributeName)) {
                if (attribValue == null) continue;
                this.addAttribValueToList("GivenName", "S:" + attribValue.toString());
                continue;
            }
            if ("sn".equalsIgnoreCase(attributeName)) {
                if (attribValue == null) continue;
                this.addAttribValueToList("Surname", "S:" + attribValue.toString());
                continue;
            }
            if ("password".equalsIgnoreCase(attributeName)) {
                if (attribValue == null) continue;
                this.passwordList.put("Password", attribValue.toString());
                continue;
            }
            if (attributeName.equalsIgnoreCase("passwordType")) continue;
            if ("userPrincipalName".equalsIgnoreCase(attributeName)) {
                if (attribValue == null) continue;
                String upnValue = (String)attribValue;
                String upnSuffix = upnValue.substring(upnValue.indexOf("@") + 1);
                if (o365ConfigProp.get("defaultDomain") != null && o365ConfigProp.get("configuredDomains") != null) {
                    ArrayList list = (ArrayList)((ArrayList)o365ConfigProp.get("configuredDomains")).clone();
                    Collections.sort(list, String.CASE_INSENSITIVE_ORDER);
                    if (Collections.binarySearch(list, upnSuffix, String.CASE_INSENSITIVE_ORDER) < 0) {
                        upnValue = upnValue.replace(upnSuffix, (String)o365ConfigProp.get("defaultDomain"));
                    }
                }
                this.addAttribValueToList("UserPrincipalName", "S:" + upnValue);
                this.userPrincipalName = upnValue;
                continue;
            }
            if ("displayName".equalsIgnoreCase(attributeName)) {
                if (attribValue == null) continue;
                this.addAttribValueToList("DisplayName", "S:" + attribValue.toString());
                this.addAttribValueToList("MailNickName", "S:" + attribValue.toString());
                this.isDisplayNameAvailable = true;
                continue;
            }
            if ("streetAddress".equalsIgnoreCase(attributeName)) {
                if (attribValue == null) continue;
                this.addAttribValueToList("StreetAddress", "S:" + attribValue.toString());
                continue;
            }
            if ("department".equalsIgnoreCase(attributeName)) {
                if (attribValue == null) continue;
                this.addAttribValueToList("Department", "S:" + attribValue.toString());
                continue;
            }
            if ("mobile".equalsIgnoreCase(attributeName)) {
                if (attribValue == null) continue;
                this.addAttribValueToList("Mobile", "S:" + attribValue.toString());
                continue;
            }
            if ("telephoneNumber".equalsIgnoreCase(attributeName)) {
                if (attribValue == null) continue;
                this.addAttribValueToList("TelephoneNumber", "S:" + attribValue.toString());
                continue;
            }
            if ("physicalDeliveryOfficeName".equalsIgnoreCase(attributeName)) {
                if (attribValue == null) continue;
                this.addAttribValueToList("PhysicalDeliveryOfficeName", "S:" + attribValue.toString());
                continue;
            }
            if ("facsimileTelephoneNumber".equalsIgnoreCase(attributeName)) {
                if (attribValue == null) continue;
                this.addAttribValueToList("FacsimileTelephoneNumber", "S:" + attribValue.toString());
                continue;
            }
            if ("co".equalsIgnoreCase(attributeName)) {
                if (attribValue == null) continue;
                this.addAttribValueToList("Country", "S:" + attribValue.toString());
                continue;
            }
            if ("c".equalsIgnoreCase(attributeName)) {
                if (attribValue == null) continue;
                this.usageLocation = attribValue.toString();
                this.addAttribValueToList("UsageLocation", "S:" + attribValue.toString());
                continue;
            }
            if ("st".equalsIgnoreCase(attributeName)) {
                if (attribValue == null) continue;
                this.addAttribValueToList("State", "S:" + attribValue.toString());
                continue;
            }
            if ("l".equalsIgnoreCase(attributeName)) {
                if (attribValue == null) continue;
                this.addAttribValueToList("City", "S:" + attribValue.toString());
                continue;
            }
            if ("postalCode".equalsIgnoreCase(attributeName)) {
                if (attribValue == null) continue;
                this.addAttribValueToList("PostalCode", "S:" + attribValue.toString());
                continue;
            }
            if ("title".equalsIgnoreCase(attributeName)) {
                if (attribValue == null) continue;
                this.addAttribValueToList("JobTitle", "S:" + attribValue.toString());
                continue;
            }
            if ("pwdLastSet".equalsIgnoreCase(attributeName)) {
                if (attribValue == null || !((Long)attribValue).equals(0L)) continue;
                this.forceChangePassword = true;
                continue;
            }
            if ("userAccountControl".equalsIgnoreCase(attributeName)) {
                if (attribValue == null) continue;
                JSONObject useAccCtrlJson = (JSONObject)attribValue;
                try {
                    Long userAccCtrlFlag;
                    if (!useAccCtrlJson.has("value") || !(userAccCtrlFlag = (Long)useAccCtrlJson.get("value")).equals(65536L)) continue;
                    this.addAttribValueToList("PasswordPolicies", "S: DisablePasswordExpiration");
                }
                catch (JSONException ex) {
                    ex.printStackTrace();
                }
                continue;
            }
            if ("name".equalsIgnoreCase(attributeName) && !isUserObject) {
                if (attribValue == null) continue;
                this.addAttribValueToExchangeList("Name", "S:" + attribValue.toString());
                continue;
            }
            if (!"mailNickname".equalsIgnoreCase(attributeName) || isUserObject || attribValue == null) continue;
            this.addAttribValueToExchangeList("Alias", "S:" + attribValue.toString());
        }
    }

    private void addAttribValueToList(String attribName, String value) {
        if (!this.attributeList.contains(attribName)) {
            Properties attribProp = new Properties();
            attribProp.put("PARAMETER", attribName);
            attribProp.put("VALUE", value);
            this.attribListToNative.add(attribProp);
            this.attributeList.add(attribName);
        }
    }

    private void addAttribValueToExchangeList(String attribName, String value) {
        if (!this.attributeList.contains(attribName)) {
            Properties attribProp = new Properties();
            attribProp.put("PARAMETER", attribName);
            attribProp.put("VALUE", value);
            this.exchangeAttribToNative.add(attribProp);
            this.attributeList.add(attribName);
        }
    }

    private void addAttribValueToDelegList(String attribName, String value) {
        if (!this.attributeList.contains(attribName)) {
            Properties attribProp = new Properties();
            attribProp.put("PARAMETER", attribName);
            attribProp.put("VALUE", value);
            this.delegAttribToNative.add(attribProp);
            this.attributeList.add(attribName);
        }
    }

    private void addAttribValueToGroupList(String attribName, ArrayList<String> groups) {
        if (!this.attributeList.contains(attribName)) {
            Properties groupProp;
            Hashtable groupHash = O365GroupHandler.getGroupHashFromObjectId(groups);
            ArrayList<String> grpList = new ArrayList<String>();
            ArrayList<String> o365GroupList = new ArrayList<String>();
            for (String group : groups) {
                String groupType;
                Properties groupProp2 = (Properties)groupHash.get(group);
                if (groupProp2 == null || groupProp2.size() <= 0 || (groupType = (String)groupProp2.get("GROUPTYPE")) == null || groupType.length() <= 0) continue;
                if (groupType.equalsIgnoreCase("Security")) {
                    this.securityGroupList.add(group);
                    continue;
                }
                if (groupType.equalsIgnoreCase("MailEnabledSecurity")) {
                    grpList.add(group);
                    continue;
                }
                if (O365GroupHandler.getIsDistributionGroup((String)group)) {
                    grpList.add(group);
                    continue;
                }
                o365GroupList.add(group);
            }
            if (grpList.size() > 0) {
                groupProp = new Properties();
                groupProp.put("PARAMETER", "DistributionGroupMember");
                groupProp.put("VALUE", grpList);
                this.mailGroupList.add(groupProp);
            }
            if (o365GroupList.size() > 0) {
                groupProp = new Properties();
                groupProp.put("PARAMETER", "O365GroupMember");
                groupProp.put("VALUE", o365GroupList);
                this.mailGroupList.add(groupProp);
            }
            this.attributeList.add(attribName);
        }
    }

    protected Properties getAuditProps(String displayName, Object value) {
        Properties auditProp = new Properties();
        auditProp.put("ATTRIB_LDAP_NAME", displayName);
        auditProp.put("ATTRIB_VALUE", value);
        return auditProp;
    }

    public void sendSysLogs(String taskName, String status, String o365TenantId) {
        try {
            String value;
            String parameter;
            Properties prop;
            int i;
            JSONObject syslogMessage = new JSONObject();
            syslogMessage.put("ACTION", (Object)this.rb.getString("admp.deleg.hdt_deleg.cre_role.action_name.o365_mgmt"));
            syslogMessage.put(this.rb.getString("admp.mgmt.common.text.task"), (Object)taskName);
            syslogMessage.put(this.rb.getString("admp.mgmt.fc_layout.o365_account"), (Object)o365TenantId);
            String userCreationMethod = "admp.mgmt.fc_layout.office365.text.office365_dirsync_user";
            if (this.o365UserCreationType.equals(2)) {
                userCreationMethod = "admp.mgmt.fc_layout.office365.text.office365_user_without_dirsync";
            }
            syslogMessage.put(this.rb.getString("admp.xml.componenttypes.waad_object_selection_type"), (Object)this.rb.getString(userCreationMethod));
            if (this.licenseList != null && this.licenseList.size() > 0) {
                syslogMessage.put(this.rb.getString("admp.reports.o365.lic_details"), (Object)this.licenseList.toString());
            }
            if (this.attribListToNative != null && this.attribListToNative.size() > 0) {
                for (i = 0; i < this.attribListToNative.size(); ++i) {
                    prop = this.attribListToNative.get(i);
                    parameter = prop.get("PARAMETER").toString();
                    value = prop.get("VALUE").toString();
                    value = parameter.equalsIgnoreCase("Password") ? "********" : value.substring(2);
                    syslogMessage.put(parameter, (Object)value);
                }
            }
            if (this.exchangeAttribToNative != null && this.exchangeAttribToNative.size() > 0) {
                for (i = 0; i < this.exchangeAttribToNative.size(); ++i) {
                    prop = this.exchangeAttribToNative.get(i);
                    parameter = prop.get("PARAMETER").toString();
                    value = prop.get("VALUE").toString();
                    if (value.startsWith("S:") || value.startsWith("B:") || value.startsWith("I:")) {
                        value = value.substring(2);
                    }
                    syslogMessage.put(parameter, (Object)value);
                }
            }
            if (this.delegAttribToNative != null && this.delegAttribToNative.size() > 0) {
                for (i = 0; i < this.delegAttribToNative.size(); ++i) {
                    prop = this.delegAttribToNative.get(i);
                    syslogMessage.put(prop.get("PARAMETER").toString(), (Object)prop.get("VALUE").toString());
                }
            }
            if (this.securityGroupList != null && this.securityGroupList.size() > 0) {
                syslogMessage.put(this.rb.getString("admp.deleg.hdt_deleg.cre_role.action_name.security_group"), (Object)this.securityGroupList.toString());
            }
            if (this.mailGroupList != null && this.mailGroupList.size() > 0) {
                for (i = 0; i < this.mailGroupList.size(); ++i) {
                    prop = this.mailGroupList.get(i);
                    syslogMessage.put(prop.get("PARAMETER").toString(), (Object)prop.get("VALUE").toString());
                }
            }
            if (status.contains(this.rb.getString("admp.mgmt.o365.exchange_online_later_click_to_view"))) {
                status = status.replace(this.rb.getString("admp.mgmt.o365.exchange_online_later_click_to_view"), "");
            }
            if (status.contains(this.rb.getString("admp.mgmt.common.statmsg.click_here_trobuleshoot"))) {
                status = status.replace(this.rb.getString("admp.mgmt.common.statmsg.click_here_trobuleshoot"), "");
            }
            syslogMessage.put(this.rb.getString("admp.common.text.status"), (Object)status);
            LogForwarderAPI.getInstance().sendMessage(syslogMessage);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setIsCreationSuccess() {
    }

    public void setStatusMsgForResponse(HttpServletRequest request) {
    }

    public boolean getIsCreationSuccess() {
        return false;
    }

    public void reInit() {
    }

    public boolean getIsBulkMgmt() {
        return false;
    }

    public Properties getNativeStatusProps() {
        return this.nativeStatusProperties;
    }

    public String getRusMessage() {
        return null;
    }

    public void setRusMessage(String string) {
    }

    public void setSingleUserErrorMessage(String appsResult) {
    }

    public String toString() {
        String string = "Attribute Details: " + this.attribListToNative + " -- LicenseDetails: " + this.licenseList;
        return string;
    }

    @Override
    public void doBulkAction(HttpServletRequest request, Object bean, Object fcIamApps, Long loginId) {
    }

    @Override
    public void setRb(AdventNetResourceBundle rb) {
        this.rb = rb;
    }

    public void setFieldValueList(Properties fieldValue) {
    }
}

