/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.reports;

import com.adventnet.db.persistence.metadata.ColumnDefinition;
import com.adventnet.db.persistence.metadata.TableDefinition;
import com.adventnet.db.persistence.metadata.util.MetaDataUtil;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.automation.ReportFilterConfig;
import com.adventnet.sym.adsm.common.server.reports.ReportAttributeHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportReqParams;
import com.adventnet.sym.adsm.common.webclient.reports.AbstractListener;
import com.adventnet.sym.adsm.common.webclient.reports.DBWriterUtil;
import com.adventnet.sym.adsm.common.webclient.reports.ListenerUtil;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.reports.ReportThread;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class AbstractNTFSReportsListener
extends AbstractListener {
    @Override
    public void addRow(Properties prop, String guid, Hashtable tableRowMap, Hashtable relationalTableRowMap, Properties uiValues) {
        this.addRow(prop, guid, tableRowMap, relationalTableRowMap, uiValues, null);
    }

    @Override
    public void addRow(Properties prop, String guid, Hashtable tableRowMap, Hashtable relationalTableRowMap, Properties uiValues, Hashtable stringRowMap) {
        try {
            Object values = null;
            ArrayList tableNames = ReportAttributeHandler.getInstance().getTableNames(this.reportId);
            int baseTableIndex = tableNames.indexOf(this.baseTableName);
            if (baseTableIndex > 0) {
                tableNames.remove(baseTableIndex);
                tableNames.add(0, this.baseTableName);
            }
            ArrayList writerTableList = ReportAttributeHandler.getInstance().getWriterTables();
            for (int i = 0; i < tableNames.size(); ++i) {
                String tableName = (String)tableNames.get(i);
                ArrayList attributeList = ReportAttributeHandler.getInstance().getAttributes(tableName, this.reportId);
                if (writerTableList != null && writerTableList.contains(tableName)) {
                    if (this.guidList.contains(guid)) continue;
                    DBWriterUtil.createStringRows(tableName, attributeList, stringRowMap, prop, uiValues, this, this.tableKey, guid);
                    continue;
                }
                this.createRows(tableName, attributeList, tableRowMap, relationalTableRowMap, prop, uiValues, this.tableKey, guid);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void createRows(String tableName, ArrayList attributeList, Hashtable tableRowMap, Hashtable relationalTableRowMap, Properties prop, Properties uiValues, String tableKey, String guid) throws Exception {
        ArrayList<Object> rowList = new ArrayList<Object>();
        ArrayList values = null;
        ArrayList<Row> multipleTableRowList = new ArrayList<Row>();
        Integer relationalType = null;
        Row r = null;
        TableDefinition tableDef = MetaDataUtil.getTableDefinitionByName((String)tableName);
        for (int j = 0; j < attributeList.size(); ++j) {
            Properties p = (Properties)attributeList.get(j);
            String ldapName = (String)p.get("ATTRIB_LDAP_NAME");
            String columnName = (String)p.get("ATTRIB_COLUMN_NAME");
            Integer attributeId = (Integer)p.get("ATTRIB_ID");
            relationalType = (Integer)p.get("RELATIONAL_TYPE");
            if (this.toBeExecutedAttributeList != null && !this.toBeExecutedAttributeList.contains(ldapName)) continue;
            values = (ArrayList)prop.get(ldapName);
            values = this.getDBCustomizedValues(columnName, ldapName, prop);
            if (tableName.endsWith("CustomDetails")) {
                ColumnDefinition colDef = tableDef.getColumnDefinitionByName(columnName);
                values = this.getCustomFieldValues(values, colDef, this.rb);
            }
            StringBuffer buf = new StringBuffer();
            if (relationalType.equals(new Integer(1))) {
                if (values != null && !values.isEmpty()) {
                    for (int k = 0; k < values.size(); ++k) {
                        String value = (String)values.get(k);
                        Row r1 = null;
                        if (multipleTableRowList.size() > k) {
                            r1 = (Row)multipleTableRowList.get(k);
                        } else {
                            r1 = new Row(tableName);
                            multipleTableRowList.add(k, r1);
                        }
                        r1.set(columnName, (Object)value);
                        r1.set(this.tempTableKey, (Object)guid);
                        buf.append(value);
                        if (k == values.size() - 1) continue;
                        buf.append(",");
                    }
                } else {
                    if (r == null) {
                        r = new Row(tableName);
                    }
                    r.set(columnName, (Object)"-");
                    buf.append("-");
                }
            } else if (values != null && !values.isEmpty()) {
                if (r == null) {
                    r = new Row(tableName);
                }
                r.set(columnName, values.get(0));
                buf.append(values.get(0));
            } else {
                if (r == null) {
                    r = new Row(tableName);
                }
                r.set(columnName, (Object)"-");
                buf.append("-");
            }
            if (!this.viewAttributeList.contains(attributeId)) continue;
            uiValues.put(attributeId, buf.toString());
        }
        if (r != null) {
            r.set(this.tempTableKey, (Object)guid);
            rowList.add(r);
        }
        if (multipleTableRowList.size() > 0) {
            rowList.addAll(multipleTableRowList);
        }
        if (relationalType.equals(new Integer(0))) {
            tableRowMap.put(tableName, rowList);
        } else if (rowList.size() > 0) {
            relationalTableRowMap.put(tableName, rowList);
        }
    }

    @Override
    public void addRow(Properties prop) {
        if (this.noOfObjects == null || this.reportId == null) {
            this.continueAction = false;
            System.out.println("Number Of Objects exceeded beyond the License Limit");
            return;
        }
        if (!this.noOfObjects.equalsIgnoreCase("unlimited")) {
            try {
                int licensedCount = Integer.parseInt(this.noOfObjects);
                if (this.reportId < 100 && this.totalCount >= licensedCount || this.totalCount >= licensedCount && licensedCount == 100) {
                    this.updateQueue();
                    this.continueAction = false;
                    System.out.println("Number Of Objects exceeded beyond the License Limit");
                    return;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            String guid = this.getGuid(prop);
            if (guid == null) {
                reportLogger.log(Level.INFO, "SID is NULL for the Properties : " + prop);
                return;
            }
            ++this.totalCount;
            if (this.updatedCount < 1) {
                this.viewAttributeList = ReportAttributeHandler.getInstance().getViewAttributesList(this.reportId, this.loginId);
            }
            Hashtable tableRowMap = new Hashtable();
            Hashtable relationalTableRowMap = new Hashtable();
            Properties uiValues = new Properties();
            Hashtable stringRowMap = new Hashtable();
            this.addRow(prop, guid, tableRowMap, relationalTableRowMap, uiValues, stringRowMap);
            this.queue.add(this.generationId, guid, tableRowMap, relationalTableRowMap, this.baseTableName, stringRowMap);
            if (!this.guidList.contains(guid)) {
                this.guidList.add(guid);
            }
            StringBuffer b = new StringBuffer();
            b.append("[");
            for (int i = 0; i < this.viewAttributeList.size(); ++i) {
                Integer attributeId = (Integer)this.viewAttributeList.get(i);
                b.append("'");
                String s = (String)uiValues.get(attributeId);
                if (s == null || s.trim().equalsIgnoreCase("")) {
                    b.append("-");
                } else {
                    s = ListenerUtil.getDynamicUpdateValues(attributeId, s);
                    b.append(s);
                }
                b.append("'");
                if (i == this.viewAttributeList.size() - 1) continue;
                b.append(",");
            }
            b.append("]");
            this.updateUI(uiValues, null, guid, b.toString());
            this.queue.checkForNextUpdate(this.generationId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void updateQueue() {
        while (!this.queue.isCompleted(this.generationId)) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void completedAction() {
        reportLogger.log(Level.INFO, "Receiving Completed Action");
        this.updateQueue();
        reportLogger.log(Level.INFO, "Updating Completed Action");
        ReportHandler.updateReportGenerationDetails((Long)this.generationId, (int)1, (String)this.desc, (Long)this.loginId);
        this.isCompleted = true;
        this.queue.deRegister(this.generationId);
        if (this.statusController != null) {
            this.statusController.setIsCompleted(this.isCompleted);
        }
        this.totalCount = 0;
        this.updatedCount = 0;
    }

    @Override
    public void start(ArrayList attributeList, HttpServletRequest request, ReportBean bean) {
        try {
            HttpSession session = request.getSession();
            this.loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            this.checkAttributeList(attributeList);
            HashMap<String, String> inputParams = new HashMap<String, String>();
            String[] domainList = request.getParameterValues("domains");
            inputParams.put("domain", ClientUtil.getString(domainList));
            ArrayList containerList = this.getContainerList(request, bean);
            Hashtable dnDomainNameMap = (Hashtable)bean.get("dnDomainNameMap");
            Hashtable domainVsExcludeChildOU = (Hashtable)bean.get("domainVsExcludeChildOU");
            Hashtable excludedOUList = (Hashtable)bean.get("excludedOUList");
            Hashtable excludeContainerHash = this.constructExcludeContainerHash(containerList, domainVsExcludeChildOU, excludedOUList, dnDomainNameMap);
            bean.set("inputParams", inputParams);
            String reportDomains = this.getReportDomains(domainList, dnDomainNameMap);
            this.getDescription(new Object[]{reportDomains});
            ReportThread action = new ReportThread(this.rb, this.loginId, containerList, attributeList, this, dnDomainNameMap, excludeContainerHash);
            action.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void executeTask(ArrayList containerList, Hashtable dnDomainNameMap, ReportFilterConfig reportFilterConfig) {
        this.executeTask(containerList, dnDomainNameMap, null, null, reportFilterConfig);
    }

    @Override
    public void executeTask(ArrayList containerList, Hashtable dnDomainNameMap, Hashtable excludedOUList, Hashtable domainVsExcludeChildOU, ReportFilterConfig reportFilterConfig) {
        try {
            reportLogger.log(Level.INFO, "Execute Task Started ");
            this.isCompleted = false;
            String schedulerDomains = this.getSchedulerDomains(containerList, dnDomainNameMap);
            this.getDescription(new Object[]{schedulerDomains});
            this.generationId = ReportHandler.addReportGenerationDetails((Integer)this.reportId, (String)this.desc, (Long)this.loginId);
            Hashtable excludeContainerHash = this.constructExcludeContainerHash(containerList, domainVsExcludeChildOU, excludedOUList, dnDomainNameMap);
            ReportThread action = new ReportThread(this.rb, 1L, containerList, this.getAttributeList(), this, dnDomainNameMap, excludeContainerHash);
            action.start();
            while (!this.isCompleted) {
                try {
                    Thread.sleep(200L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ReportHandler.updateReportGenerationDetails((Long)this.generationId, (int)1, (String)this.desc, (Long)this.loginId);
            reportLogger.log(Level.INFO, "Execute Task Completed ");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Criteria getReportResultFilterCriteria(HttpServletRequest request, ReportReqParams reqParams, Criteria crit) {
        JSONArray rvcFiltersArray = reqParams.getRvcFilters();
        try {
            String columnName = "INPUT_ID";
            if (rvcFiltersArray != null && rvcFiltersArray.length() > 0) {
                String[] inputFiltervalues = new String[rvcFiltersArray.length()];
                for (int index = 0; index < rvcFiltersArray.length(); ++index) {
                    JSONObject rvcFilterObject = (JSONObject)rvcFiltersArray.get(index);
                    Iterator iterator = rvcFilterObject.keys();
                    while (iterator.hasNext()) {
                        String inputId;
                        inputFiltervalues[index] = inputId = (String)iterator.next();
                    }
                }
                crit = crit == null ? new Criteria(Column.getColumn((String)this.resultTableName, (String)columnName), (Object)inputFiltervalues, 8) : crit.and(new Criteria(Column.getColumn((String)this.resultTableName, (String)columnName), (Object)inputFiltervalues, 8));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return crit;
    }

    public class UpdateAction
    extends Thread {
        private AbstractNTFSReportsListener listener;
        private boolean shutDown = false;

        public UpdateAction(AbstractNTFSReportsListener li) {
            this.listener = li;
        }

        @Override
        public void run() {
            try {
                while (!this.shutDown) {
                    this.checkAndProcess();
                }
                System.out.println("UpdateAction stops");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void checkAndProcess() {
            this.waitForUpdate(1000L);
            this.process();
        }

        public void waitForUpdate(long t) {
            try {
                Thread.sleep(t);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void shutDown() {
            this.shutDown = true;
        }

        public void process() {
            try {
                this.listener.addPermissions();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

