/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.reports;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.reports.ReportHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.webclient.reports.SingleContainerListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;

public class DisabledGPOListener
extends SingleContainerListener {
    public DisabledGPOListener() {
        this.mgmtIds = new int[]{6031, 6028, 6021, 6028};
    }

    @Override
    public void getDescription(Object[] args) {
        this.desc = MessageFormat.format(this.rb.getString("admp.reports.gpo_reports.disabled.reportdesc_disabled_gpos_of_the_domains"), args);
    }

    @Override
    protected void checkAttributeList(ArrayList attributeList) {
        attributeList.remove("objectSID");
        attributeList.add("objectGUID");
    }

    @Override
    public void doAction(String domainName, Long loginId, String distinguishedName, ArrayList attributeList, NativeListener listener) throws Exception {
        ADHandler.getDisabledGPOs((String)domainName, (Long)loginId, (ArrayList)attributeList, (NativeListener)listener);
    }

    @Override
    public void setGenerationId(HttpServletRequest request) {
        String generationIdStr = request.getParameter("generationId");
        reportLogger.log(Level.INFO, "Generation Id Str : " + generationIdStr);
        if (generationIdStr != null) {
            try {
                this.generationId = Long.parseLong(generationIdStr);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            ArrayList guids;
            this.generationId = ReportHandler.getRecentlyGeneratedReports((Integer)this.reportId, (Long)this.loginId);
            if (this.generationId == null && (guids = this.getReportsFromDB()).size() > 0) {
                this.generationId = ReportHandler.addReportGenerationDetails((Integer)this.reportId, (String)this.desc, (Long)this.loginId);
                ReportHandler.addSIDReportResult((Long)this.generationId, (String)this.resultTableName, (ArrayList)guids);
                ReportHandler.updateReportGenerationDetails((Long)this.generationId, (int)1, (String)this.desc, (Long)this.loginId);
            }
            reportLogger.log(Level.INFO, "Recently Generated Id : " + this.generationId);
        }
    }

    public ArrayList getReportsFromDB() {
        ArrayList<Object> list = new ArrayList<Object>();
        try {
            long l = 2592000000L;
            l = System.currentTimeMillis() - l;
            Criteria crit = new Criteria(new Column(this.baseTableName, "USER_CONFIG"), (Object)"admp.reports.user.customized_column_values.Disabled", 0);
            crit = crit.and(new Criteria(new Column(this.baseTableName, "COMP_CONFIG"), (Object)"admp.reports.user.customized_column_values.Disabled", 0));
            SelectQueryImpl sq = new SelectQueryImpl(new Table(this.baseTableName));
            sq.setCriteria(crit);
            sq.addSelectColumn(new Column(this.baseTableName, "OBJECT_GUID"));
            DataObject obj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)sq);
            Iterator it = obj.getRows(this.baseTableName);
            while (it.hasNext()) {
                Row r = (Row)it.next();
                list.add(r.get("OBJECT_GUID"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }
}

