/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.reports;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.AdmpInput;
import com.adventnet.sym.adsm.common.server.automation.ReportFilterConfig;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.queue.QueueHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportAttributeHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportHandler;
import com.adventnet.sym.adsm.common.server.reports.StatusUpdater;
import com.adventnet.sym.adsm.common.server.resultdata.ResultDataHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.webclient.reports.AbstractListener;
import com.adventnet.sym.adsm.common.webclient.reports.ListenerUtil;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.reports.ReportThread;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class DuplicateUsersListener
extends AbstractListener {
    private String attrbId = "";
    private String attrbName = "";
    private String tableName = "";
    private ArrayList ouList = null;

    @Override
    public void getDescription(Object[] args) {
        this.desc = MessageFormat.format(this.rb.getString("admp.reports.user_reports.dupl_attribs.reportdesc_users_with_duplicate_attrib_for_the_domain"), args);
    }

    @Override
    public Hashtable getQueueProps() {
        Hashtable<String, Object> tableProps = new Hashtable<String, Object>();
        tableProps.put("baseTableName", this.baseTableName);
        tableProps.put("resultTableName", this.resultTableName);
        tableProps.put("generationId", this.generationId);
        tableProps.put("resultHandling", "no-update");
        return tableProps;
    }

    @Override
    public void start(ArrayList attributeList, HttpServletRequest request, ReportBean bean) {
        try {
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            this.checkAttributeList(attributeList);
            HashMap<String, String> inputParams = new HashMap<String, String>();
            Hashtable dnDomainNameMap = (Hashtable)bean.get("dnDomainNameMap");
            ArrayList containerList = this.getContainerList(request, bean);
            Hashtable domainVsExcludeChildOU = (Hashtable)bean.get("domainVsExcludeChildOU");
            Hashtable excludedOUList = (Hashtable)bean.get("excludedOUList");
            this.attrbId = request.getParameter("attrId");
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"ADSMAttributeDetails"));
            query.addSelectColumn(Column.getColumn((String)"ADSMAttributeDetails", (String)"TABLE_NAME"));
            query.addSelectColumn(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_COLUMN_NAME"));
            query.addSelectColumn(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_ID"));
            query.setCriteria(new Criteria(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_ID"), (Object)this.attrbId, 0));
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
            Row row = dataObject.getRow("ADSMAttributeDetails");
            if (row != null) {
                this.tableName = (String)row.get("TABLE_NAME");
                this.attrbName = (String)row.get("ATTRIB_COLUMN_NAME");
            }
            this.ouList = containerList;
            String[] domainList = request.getParameterValues("domains");
            inputParams.put("domain", ClientUtil.getString(domainList));
            String reportDomains = this.getReportDomains(domainList, dnDomainNameMap);
            this.getDescription(new Object[]{request.getParameter("attrbDispName"), reportDomains});
            ArrayList objectIds = this.getObjIdList();
            this.queueRegID = QueueHandler.getInstance().registerForUpdate(objectIds, this.getTableColumns());
            this.resultRegID = ResultDataHandler.getInstance().getProcessor().registerForUpdate(this.resultTableName);
            Hashtable excludeContainerHash = this.constructExcludeContainerHash(containerList, domainVsExcludeChildOU, excludedOUList, dnDomainNameMap);
            this.statusController.setProgressTask(StatusUpdater.TASKCODE.FETCHING_DUPLICATE_ATTRIUTE.getValue());
            ReportThread action = new ReportThread(this.rb, loginId, containerList, attributeList, this, dnDomainNameMap, excludeContainerHash);
            action.start();
            bean.set("inputParams", inputParams);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void checkAttributeList(ArrayList attributeList) {
    }

    @Override
    protected void doAction(String domainName, Long loginId, String distinguishedName, ArrayList attributeList, NativeListener listener) throws Exception {
        reportLogger.log(Level.INFO, "Duplicate Users do action domainName :" + domainName);
        reportLogger.log(Level.INFO, "Duplicate Users do action attributeList :" + attributeList);
        ADHandler.getUsers((String)domainName, (Long)loginId, (String)distinguishedName, (ArrayList)attributeList, (NativeListener)listener);
    }

    @Override
    public void completedAction() {
        if (this.updateDetails) {
            reportLogger.log(Level.INFO, "Receiving Completed Action");
            this.updateQueue();
            reportLogger.log(Level.INFO, "Updating Completed Action");
            this.endQueue();
            ReportHandler.updateReportGenerationDetails((Long)this.generationId, (int)1, (String)this.desc, (Long)this.loginId);
            this.deriveData(this.domainName, this.attrbName, this.tableName);
            ReportHandler.updateReportGenerationDetails((Long)this.generationId, (int)1, (String)this.desc, (Long)this.loginId);
        }
        this.isCompleted = true;
        this.queue.deRegister(this.generationId);
        if (this.statusController != null) {
            this.statusController.setIsCompleted(this.isCompleted);
        }
    }

    @Override
    public void updateUI(Properties uiValues, String objectClass, String guid, String str) {
    }

    @Override
    public void executeTask(ArrayList containerList, Hashtable dnDomainNameMap, ReportFilterConfig reportFilterConfig) {
        this.executeTask(containerList, dnDomainNameMap, null, null, reportFilterConfig);
    }

    @Override
    public void executeTask(ArrayList containerList, Hashtable dnDomainNameMap, Hashtable excludedOUList, Hashtable domainVsExcludeChildOU, ReportFilterConfig reportFilterConfig) {
        try {
            reportLogger.log(Level.INFO, "Execute Task Started ");
            this.isCompleted = false;
            String attrbVal = null;
            Integer attrIdFromDB = 0;
            for (AdmpInput admpInput : reportFilterConfig.getInputList()) {
                if (admpInput.getIsMultiple().booleanValue()) continue;
                attrIdFromDB = Integer.valueOf(admpInput.getName());
                attrbVal = admpInput.getValue();
            }
            ArrayList columnList = ReportAttributeHandler.getInstance().getTotalColumn(new Integer(35), null, 0, 200);
            for (int i = 0; i < columnList.size(); ++i) {
                Properties cols = (Properties)columnList.get(i);
                Integer attrId = (Integer)cols.get("ATTRIB_ID");
                if (!attrId.equals(attrIdFromDB)) continue;
                this.attrbName = cols.getProperty("ATTRIB_COLUMN_NAME");
                this.tableName = (String)cols.get("TABLE_NAME");
                this.attrbId = attrId.toString();
                break;
            }
            String schedulerDomains = this.getSchedulerDomains(containerList, dnDomainNameMap);
            this.getDescription(new Object[]{attrbVal, schedulerDomains});
            this.generationId = ReportHandler.addReportGenerationDetails((Integer)this.reportId, (String)this.desc, (Long)this.loginId);
            ArrayList objectIds = this.getObjIdList();
            this.queueRegID = QueueHandler.getInstance().registerForUpdate(objectIds, this.getTableColumns());
            this.resultRegID = ResultDataHandler.getInstance().getProcessor().registerForUpdate(this.resultTableName);
            Hashtable excludeContainerHash = this.constructExcludeContainerHash(containerList, domainVsExcludeChildOU, excludedOUList, dnDomainNameMap);
            ReportThread action = new ReportThread(this.rb, this.loginId, containerList, this.getAttributeList(), this, dnDomainNameMap, excludeContainerHash);
            action.start();
            while (!this.isCompleted) {
                try {
                    Thread.sleep(200L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ReportHandler.updateReportGenerationDetails((Long)this.generationId, (int)1, (String)this.desc, (Long)this.loginId);
            reportLogger.log(Level.INFO, "Execute Task Completed ");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setDashboardInputParams(Long dashboardReportMapping, HttpServletRequest request, ReportBean bean) {
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"DashboardReportInputVals", (String)"DASHBOARD_REPORT_MAPPING"), (Object)dashboardReportMapping, 0);
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("DashboardReportInputVals", crit);
            String attrIdStr = (String)dataObj.getFirstRow("DashboardReportInputVals").get("PROPERTY");
            HashMap inputParams = (HashMap)bean.get("reportInputParams");
            inputParams.put("attrId", ListenerUtil.getInputValueAsList(attrIdStr));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

