/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.reports;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.AdmpInput;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.automation.ReportFilterConfig;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.layout.component.FcOption;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.queue.QueueHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportHandler;
import com.adventnet.sym.adsm.common.server.resultdata.ResultDataHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.ReportAttributesUtil;
import com.adventnet.sym.adsm.common.webclient.reports.AbstractListener;
import com.adventnet.sym.adsm.common.webclient.reports.ListenerUtil;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class EmptyAttributeUsersListener
extends AbstractListener {
    @Override
    protected void checkAttributeList(ArrayList attributeList) {
    }

    @Override
    public void doAction(String domainName, Long loginId, String distinguishedName, ArrayList attributeList, NativeListener listener) throws Exception {
    }

    protected void doAction(String domainName, Long loginId, String distinguishedName, ArrayList attributeList, NativeListener listener, String query) throws Exception {
        ADHandler.getUsersWithEmptyAttributes((String)domainName, (Long)loginId, (String)distinguishedName, (String)query, (ArrayList)attributeList, (NativeListener)listener);
    }

    @Override
    public void setInputParams(HttpServletRequest request, ReportBean bean) {
        request.setAttribute("emptyAttributeList", (Object)ReportHandler.getEmptyAttributeListString());
        this.getContainerList(request, bean);
    }

    @Override
    public void start(ArrayList attributeList, HttpServletRequest request, ReportBean bean) {
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        try {
            this.checkAttributeList(attributeList);
            HashMap<String, String> inputParams = new HashMap<String, String>();
            String matchingCriteria = "Any";
            if (request.getParameter("matchingCriteria") != null) {
                try {
                    matchingCriteria = request.getParameter("matchingCriteria");
                }
                catch (Exception e) {
                    matchingCriteria = "Any";
                    e.printStackTrace();
                }
            }
            reportLogger.log(Level.INFO, "Matching crit in empty listener : " + matchingCriteria);
            ArrayList containerList = this.getContainerList(request, bean);
            Hashtable dnDomainNameMap = (Hashtable)bean.get("dnDomainNameMap");
            Hashtable domainVsExcludeChildOU = (Hashtable)bean.get("domainVsExcludeChildOU");
            Hashtable excludedOUList = (Hashtable)bean.get("excludedOUList");
            String[] domainList = request.getParameterValues("domains");
            inputParams.put("domain", ClientUtil.getString(domainList));
            bean.set("inputParams", inputParams);
            String reportDomains = this.getReportDomains(domainList, dnDomainNameMap);
            this.getDescription(new Object[]{reportDomains});
            String query = "(&(objectCategory=person)(objectclass=user)(!(sAMAccountType=805306370))";
            String s = "";
            DataObject obj = ReportHandler.getEmptyAttributeList((String)"1");
            Iterator it = obj.getRows("ADSMEmptyAttributeList");
            if (matchingCriteria != null && matchingCriteria.equalsIgnoreCase("Any")) {
                s = "(|";
            }
            while (it.hasNext()) {
                Row r = (Row)it.next();
                String ldapName = (String)r.get("ATTRIB_LDAP_NAME");
                s = s + "(!" + ldapName + "=*)";
            }
            if (matchingCriteria != null && matchingCriteria.equalsIgnoreCase("Any")) {
                s = s + ")";
            }
            query = query + s + ")";
            reportLogger.log(Level.INFO, "Empty attribute users report query formed - " + query);
            Hashtable excludeContainerHash = this.constructExcludeContainerHash(containerList, domainVsExcludeChildOU, excludedOUList, dnDomainNameMap);
            Action action = new Action(loginId, containerList, attributeList, this, dnDomainNameMap, excludeContainerHash, query);
            action.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void executeTask(ArrayList containerList, Hashtable dnDomainNameMap, ReportFilterConfig reportFilterConfig) {
        this.executeTask(containerList, dnDomainNameMap, null, null, reportFilterConfig);
    }

    @Override
    public void executeTask(ArrayList containerList, Hashtable dnDomainNameMap, Hashtable excludedOUList, Hashtable domainVsExcludeChildOU, ReportFilterConfig reportFilterConfig) {
        try {
            reportLogger.log(Level.INFO, "Execute Task Started ");
            this.isCompleted = false;
            String attrId = "";
            String attrName = "";
            String ldapName = "";
            String isMatchAnyAttributes = "false";
            String attribIdString = "";
            ArrayList attrLdapNames = new ArrayList();
            for (AdmpInput admpInput : reportFilterConfig.getInputList()) {
                if (admpInput.getIsMultiple().booleanValue()) {
                    for (FcOption fcOption : admpInput.getMultipleInput()) {
                        if (fcOption.getLabel().equalsIgnoreCase("INPUT_PROPERTIES")) {
                            attrId = fcOption.getValue();
                            attribIdString = attribIdString + attrId + ";";
                            continue;
                        }
                        if (!fcOption.getLabel().equalsIgnoreCase("INPUT_VALUE")) continue;
                        attrName = fcOption.getValue();
                    }
                    continue;
                }
                if (!admpInput.getName().equalsIgnoreCase("isMatchAnyAttributes")) continue;
                isMatchAnyAttributes = admpInput.getValue();
            }
            String[] attribIdArray = attribIdString.split(";");
            attrLdapNames = ReportAttributesUtil.getAttributeNameList((String[])attribIdArray, (String)"ATTRIB_LDAP_NAME");
            String query = "(&(objectCategory=person)(objectclass=user)(!(sAMAccountType=805306370))";
            String s = "";
            if (isMatchAnyAttributes.equalsIgnoreCase("true")) {
                s = "(|";
            }
            for (int i = 0; i < attrLdapNames.size(); ++i) {
                ldapName = (String)attrLdapNames.get(i);
                s = s + "(!" + ldapName + "=*)";
            }
            if (isMatchAnyAttributes.equalsIgnoreCase("true")) {
                s = s + ")";
            }
            query = query + s + ")";
            System.out.println("EmptyAttributeUsersListener.java - executeTask - query :: " + query);
            String schedulerDomains = this.getSchedulerDomains(containerList, dnDomainNameMap);
            this.getDescription(new Object[]{schedulerDomains});
            this.generationId = ReportHandler.addReportGenerationDetails((Integer)this.reportId, (String)this.desc, (Long)this.loginId);
            ArrayList objectIds = this.getObjIdList();
            this.queueRegID = QueueHandler.getInstance().registerForUpdate(objectIds, this.getTableColumns());
            this.resultRegID = ResultDataHandler.getInstance().getProcessor().registerForUpdate(this.resultTableName);
            Hashtable excludeContainerHash = this.constructExcludeContainerHash(containerList, domainVsExcludeChildOU, excludedOUList, dnDomainNameMap);
            Action action = new Action(this.loginId, containerList, this.getAttributeList(), this, dnDomainNameMap, excludeContainerHash, query);
            action.start();
            while (!this.isCompleted) {
                try {
                    Thread.sleep(200L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ReportHandler.updateReportGenerationDetails((Long)this.generationId, (int)1, (String)this.desc, (Long)this.loginId);
            reportLogger.log(Level.INFO, "Execute Task Completed ");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setDashboardInputParams(Long dashboardReportMapping, HttpServletRequest request, ReportBean bean) {
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"DashboardReportInputVals", (String)"DASHBOARD_REPORT_MAPPING"), (Object)dashboardReportMapping, 0);
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("DashboardReportInputVals", crit);
            Iterator itr = dataObj.getRows("DashboardReportInputVals");
            while (itr.hasNext()) {
                Row row = (Row)itr.next();
                String inputPropertyName = (String)row.get("PROPERTY");
                if (inputPropertyName.equalsIgnoreCase("isMatchAnyAttributes")) {
                    String value = ((String)row.get("VALUE")).equals("true") ? "Any" : "All";
                    HashMap inputParams = (HashMap)bean.get("reportInputParams");
                    inputParams.put("matchingCriteria", ListenerUtil.getInputValueAsList(value));
                    continue;
                }
                if (!inputPropertyName.equalsIgnoreCase("emptyAttributeList")) continue;
                AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request.getLocale());
                StringBuilder attrNames = new StringBuilder();
                ArrayList<String> list = new ArrayList<String>();
                Criteria multiCri = new Criteria(Column.getColumn((String)"DashboardReportInputMultiVals", (String)"INPUT_ID"), row.get("INPUT_ID"), 0);
                DataObject multiValDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get("DashboardReportInputMultiVals", multiCri);
                Iterator multiItr = multiValDO.getRows("DashboardReportInputMultiVals");
                while (multiItr.hasNext()) {
                    Row mRow = (Row)multiItr.next();
                    list.add((String)mRow.get("SERVER_VALUE"));
                    attrNames.append(rb.getString((String)mRow.get("CLIENT_VALUE")));
                    attrNames.append(",");
                }
                DataObject obj = ReportHandler.getEmptyAttributeList(null);
                Iterator it = obj.getRows("ADSMEmptyAttributeList");
                while (it.hasNext()) {
                    Row r = (Row)it.next();
                    Integer id = (Integer)r.get("EMPTY_ATTRIB_ID");
                    if (list.contains(id.toString())) {
                        r.set("STATUS", (Object)new Integer(1));
                    } else {
                        r.set("STATUS", (Object)new Integer(0));
                    }
                    obj.updateRow(r);
                }
                CommonUtil.getPersistence((boolean[])new boolean[0]).update(obj);
                attrNames.deleteCharAt(attrNames.length() - 1);
                request.setAttribute("emptyAttributeList", (Object)attrNames.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public class Action
    extends Thread {
        private ArrayList containerList = null;
        private ArrayList attributeList = null;
        private NativeListener listener = null;
        private Hashtable dnDomainNameMap = null;
        private String query = null;
        private Long loginId = null;
        private Hashtable excludeChildOUHash = null;

        public Action(Long loginId, ArrayList list, ArrayList attributeList, NativeListener li, Hashtable map, Hashtable excludeChildOUHash, String query) {
            this.loginId = loginId;
            this.containerList = list;
            this.attributeList = attributeList;
            this.listener = li;
            this.dnDomainNameMap = map;
            this.excludeChildOUHash = excludeChildOUHash;
            this.query = query;
        }

        @Override
        public void run() {
            EmptyAttributeUsersListener.this.initializeActionVariables();
            Hashtable tableProps = EmptyAttributeUsersListener.this.getQueueProps();
            ArrayList objectIds = EmptyAttributeUsersListener.this.getObjIdList();
            EmptyAttributeUsersListener.this.queueRegID = QueueHandler.getInstance().registerForUpdate(objectIds, EmptyAttributeUsersListener.this.getTableColumns());
            EmptyAttributeUsersListener.this.resultRegID = ResultDataHandler.getInstance().getProcessor().registerForUpdate(EmptyAttributeUsersListener.this.resultTableName);
            for (int i = 0; i < this.containerList.size(); ++i) {
                try {
                    String dn = (String)this.containerList.get(i);
                    EmptyAttributeUsersListener.this.domainName = (String)this.dnDomainNameMap.get(dn);
                    Boolean isExcludeChildOU = Boolean.FALSE;
                    if (this.excludeChildOUHash != null && this.excludeChildOUHash.containsKey(dn)) {
                        isExcludeChildOU = (Boolean)this.excludeChildOUHash.get(dn);
                    }
                    this.listener.setIsExcludeChildOU(isExcludeChildOU);
                    if (EmptyAttributeUsersListener.this.domainName != null) {
                        EmptyAttributeUsersListener.this.setDomainName(EmptyAttributeUsersListener.this.domainName);
                        EmptyAttributeUsersListener.this.queue.registerForUpdation(EmptyAttributeUsersListener.this.baseTableName, EmptyAttributeUsersListener.this.generationId, tableProps);
                        EmptyAttributeUsersListener.this.doAction(EmptyAttributeUsersListener.this.domainName, this.loginId, dn, this.attributeList, this.listener, this.query);
                        EmptyAttributeUsersListener.this.updateQueue();
                        continue;
                    }
                    System.out.println("Error - Selected OU has been moved in Ad manually" + dn);
                    continue;
                }
                catch (LocalizedException e) {
                    e.printStackTrace();
                    EmptyAttributeUsersListener.this.errorMessage = e.getMessage(EmptyAttributeUsersListener.this.rb);
                    System.out.println("LocalizedException: - " + EmptyAttributeUsersListener.this.errorMessage);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    EmptyAttributeUsersListener.this.errorMessage = e.getMessage();
                }
            }
            EmptyAttributeUsersListener.this.completedAction();
        }
    }
}

