/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.reports;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.db.persistence.metadata.ColumnDefinition;
import com.adventnet.db.persistence.metadata.PrimaryKeyDefinition;
import com.adventnet.db.persistence.metadata.TableDefinition;
import com.adventnet.db.persistence.metadata.UniqueValueGeneration;
import com.adventnet.db.persistence.metadata.util.MetaDataUtil;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.Range;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.AdmpInput;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.DomainProcess;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.adsync.ADSyncUtil;
import com.adventnet.sym.adsm.common.server.automation.ReportFilterConfig;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.reports.ComputerHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportAttributeHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportReqParams;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBUtil;
import com.adventnet.sym.adsm.common.server.util.DynamicTableUtil;
import com.adventnet.sym.adsm.common.server.util.FileServerMgmtUtil;
import com.adventnet.sym.adsm.common.server.util.ReportAttributesUtil;
import com.adventnet.sym.adsm.common.webclient.reports.AbstractListener;
import com.adventnet.sym.adsm.common.webclient.reports.AbstractNTFSReportsListener;
import com.adventnet.sym.adsm.common.webclient.reports.DBWriterUtil;
import com.adventnet.sym.adsm.common.webclient.reports.ListenerUtil;
import com.adventnet.sym.adsm.common.webclient.reports.PermissionOverObjectsListener;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.reports.ReportExportUtil;
import com.adventnet.sym.adsm.common.webclient.reports.ReportResultUtil;
import com.adventnet.sym.adsm.common.webclient.reports.SIDCacheManager;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.sf.cache4j.CacheFactory;
import org.apache.struts.validator.DynaValidatorForm;

public class FolderPermissionListener
extends PermissionOverObjectsListener {
    protected static Logger reportLogger = Logger.getLogger("ReportLogger");
    protected static Hashtable genIdTableKeyMap = new Hashtable();
    protected String lookupServer;
    protected static int descLength = 300;
    protected static SIDCacheManager cacheMgr;
    protected ArrayList permissionsPropList = new ArrayList();
    AbstractNTFSReportsListener.UpdateAction updateAction;

    @Override
    public Long getCategoryId() {
        Long categoryId = new Long(-1L);
        return categoryId;
    }

    @Override
    public boolean isResultViewOutputFilterAvailable() {
        return true;
    }

    @Override
    public String getOutputFilterLabelText() {
        return "admp.reports.folder_report.text.showing_permissions_of";
    }

    @Override
    public ArrayList getReportInputParam(ArrayList<Hashtable<String, ArrayList<Hashtable<String, Object>>>> cvcInputList) {
        ArrayList<Object> list = new ArrayList();
        for (Hashtable<String, ArrayList<Hashtable<String, Object>>> hash : cvcInputList) {
            if (!hash.containsKey("pathList")) continue;
            list = hash.get("pathList");
        }
        return list;
    }

    @Override
    public void getDescription(Object[] args) {
        this.desc = MessageFormat.format(this.rb.getString("admp.reports.ntfs_reports.permission_for_folders.reportdesc_report_generated_for_the_share_path"), args[0]);
    }

    @Override
    protected void checkAttributeList(ArrayList attributeList) {
        if (!attributeList.contains("userAccountControl")) {
            attributeList.add("userAccountControl");
        }
    }

    public void doAction(String domainName, Long loginId, String path, ArrayList attributeList, int folderLevel, NativeListener listener) throws Exception {
        ADHandler.getFilesAndFolderPermissions((String)domainName, (Long)loginId, (String)path, (ArrayList)attributeList, (int)folderLevel, (NativeListener)listener);
    }

    @Override
    public void doAction(String domainName, Long loginId, String distinguishedName, String trustee, ArrayList attributeList, NativeListener listener) throws Exception {
    }

    public FolderPermissionListener() {
        this.tableKey = "ACLS_ID";
        this.tempTableKey = "ACLS_ID";
        this.attrKey = "sid";
        this.attrKey2 = "sid";
    }

    @Override
    public Hashtable getQueueProps() {
        Hashtable<String, Object> tableProps = new Hashtable<String, Object>();
        tableProps.put("baseTableName", this.baseTableName);
        tableProps.put("resultTableName", this.resultTableName);
        tableProps.put("generationId", this.generationId);
        tableProps.put("resultHandling", "add");
        tableProps.put("tableKey", "ACLS_ID");
        return tableProps;
    }

    @Override
    public void setSyncEnabled() {
        this.setSyncEnabled(true);
    }

    @Override
    public Criteria getReportResultFilterCriteria(HttpServletRequest request, DynaValidatorForm bean, Criteria crit, String inputId) {
        try {
            String columnName = "INPUT_ID";
            ArrayList inputObjects = (ArrayList)bean.get("inputObjects");
            String[] inputFiltervalues = request.getParameterValues("inputs");
            String permissionTableName = "ADSMFolderPermissionDetails_" + this.generationId;
            HashMap inputParams = (HashMap)bean.get("reportInputParams");
            ArrayList inputs = (ArrayList)inputParams.get("pathList");
            String inputName = "";
            String[] escapeChars = new String[]{"\\"};
            for (int i = 0; i < inputs.size(); ++i) {
                Hashtable hash = (Hashtable)inputs.get(i);
                Long input = (Long)hash.get("INPUT_ID");
                if (!input.equals(Long.valueOf(inputId))) continue;
                inputName = (String)hash.get("INPUT_NAME");
                break;
            }
            crit = !inputObjects.contains(inputId) && inputObjects.size() != 0 ? (crit == null ? new Criteria(new Column(this.resultTableName, columnName), (Object)0L, 0) : crit.and(new Criteria(new Column(this.resultTableName, columnName), (Object)0L, 0))) : (crit == null ? new Criteria(new Column(this.resultTableName, columnName), (Object)inputId, 0) : crit.and(new Criteria(new Column(this.resultTableName, columnName), (Object)inputId, 0)));
            if (FileServerMgmtUtil.getFolderType((String)inputName).equalsIgnoreCase("SERVER")) {
                String serverName = FileServerMgmtUtil.getServerForFolder((String)inputName);
                if (serverName.indexOf(".") != -1) {
                    serverName = serverName.substring(0, serverName.indexOf("."));
                }
                ArrayList list = ComputerHandler.getSharedFolders((String)"", (Long)this.loginId, (String)serverName, (String)this.domainName, null);
                Criteria inputCriteria = null;
                for (int j = 0; j < list.size(); ++j) {
                    Hashtable listProps = (Hashtable)list.get(j);
                    String shareName = (String)listProps.get("Name");
                    String path = (String)listProps.get("Location");
                    inputCriteria = inputCriteria == null ? new Criteria(Column.getColumn((String)permissionTableName, (String)"INPUT_DN"), (Object)CommonUtil.escapeString((String)path, (String[])escapeChars), 2) : inputCriteria.or(new Criteria(Column.getColumn((String)permissionTableName, (String)"INPUT_DN"), (Object)CommonUtil.escapeString((String)path, (String[])escapeChars), 2));
                }
                if (inputCriteria != null) {
                    crit = crit.and(inputCriteria);
                }
            } else {
                inputName = inputName + "*";
                crit = crit.and(new Criteria(Column.getColumn((String)permissionTableName, (String)"INPUT_DN"), (Object)CommonUtil.escapeString((String)inputName, (String[])escapeChars), 2));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return crit;
    }

    @Override
    public void fillInputDetails(String inputTable, HttpServletRequest request, ReportBean bean, String key) {
        HashMap inputParams = (HashMap)bean.get("reportInputParams");
        ArrayList valuesList = new ArrayList();
        if (key.equalsIgnoreCase("pathList")) {
            ArrayList pathList = (ArrayList)bean.get("pathList");
            for (int i = 0; i < pathList.size(); ++i) {
                Hashtable<String, Object> inputs = new Hashtable<String, Object>();
                String sid = request.getParameter("serverSid");
                inputs.put("SERVER_SID", sid);
                inputs.put("INPUT_NAME", (String)pathList.get(i));
                inputs.put("REPORT_GENERATION_ID", this.generationId);
                ListenerUtil.fillValues(inputTable, this.reportId, inputs, this.generationId);
                valuesList.add(inputs);
            }
        } else if (key.equalsIgnoreCase("folderLevel")) {
            Hashtable<String, Object> inputs = new Hashtable<String, Object>();
            String searchPath = request.getParameter("searchPath");
            String folderLevel = request.getParameter(key);
            if (!searchPath.equalsIgnoreCase("CustomLevel")) {
                folderLevel = searchPath;
            }
            inputs.put("INPUT_PROPERTY_NAME", key);
            inputs.put("INPUT_PROPERTY_VALUE", folderLevel);
            inputs.put("REPORT_GENERATION_ID", this.generationId);
            ListenerUtil.fillValues(inputTable, this.reportId, inputs, this.generationId);
            valuesList.add(inputs);
        }
        inputParams.put(key, valuesList);
    }

    @Override
    public Criteria getMultiValueCrit(HttpServletRequest request, String resultTableName, DynaValidatorForm bean, ReportReqParams reqParams) {
        Criteria crit = null;
        try {
            String columnName = "INPUT_DN";
            String permissionTableName = "ADSMFolderPermissionDetails_" + this.generationId;
            HashMap inputParams = (HashMap)bean.get("reportInputParams");
            ArrayList inputs = (ArrayList)inputParams.get("path");
            ArrayList searchPath = (ArrayList)inputParams.get("searchPath");
            Hashtable inputValues = (Hashtable)inputs.get(0);
            String[] critValues = new String[1];
            String[] escapeChars = new String[]{"\\"};
            critValues[0] = CommonUtil.escapeString((String)((String)inputValues.get("INPUT_NAME")), (String[])escapeChars);
            crit = new Criteria(new Column(permissionTableName, columnName), (Object)critValues[0], 2);
            bean.set("critValues", (Object)critValues);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return crit;
    }

    public void addRow(Properties prop, String guid, Hashtable tableRowMap, Hashtable relationalTableRowMap, Hashtable uiValues, Hashtable stringRowMap) {
        try {
            Object values = null;
            ArrayList tableNames = ReportAttributeHandler.getInstance().getTableNames(this.reportId);
            int baseTableIndex = tableNames.indexOf(this.baseTableName);
            if (baseTableIndex > 0) {
                tableNames.remove(baseTableIndex);
                tableNames.add(0, this.baseTableName);
            }
            ArrayList writerTableList = ReportAttributeHandler.getInstance().getWriterTables();
            for (int i = 0; i < tableNames.size(); ++i) {
                String tableName = (String)tableNames.get(i);
                ArrayList attributeList = ReportAttributeHandler.getInstance().getAttributes(tableName, this.reportId);
                if (writerTableList != null && tableName.equalsIgnoreCase("ADSMFolderPermissionDetails")) {
                    tableName = tableName + "_" + this.generationId;
                    Hashtable sidVsAclIdMap = (Hashtable)genIdTableKeyMap.get(this.generationId);
                    Hashtable sidVsAcl = (Hashtable)sidVsAclIdMap.get(guid);
                    DBWriterUtil.createStringRows(tableName, attributeList, stringRowMap, prop, uiValues, this, this.tableKey, ((Long)sidVsAcl.get(this.tableKey)).toString());
                    continue;
                }
                if (this.isSyncEnabled && ADSyncUtil.isSyncTable((String)tableName)) continue;
                this.createRows(tableName, attributeList, tableRowMap, relationalTableRowMap, prop, uiValues, this.tableKey, guid);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void createRows(String tableName, ArrayList attributeList, Hashtable tableRowMap, Hashtable relationalTableRowMap, Properties prop, Hashtable uiValues, String tableKey, String guid) throws Exception {
        ArrayList values = null;
        ArrayList<Object> rowList = new ArrayList<Object>();
        ArrayList<Row> multipleTableRowList = new ArrayList<Row>();
        Integer relationalType = null;
        Row r = null;
        for (int j = 0; j < attributeList.size(); ++j) {
            Properties p = (Properties)attributeList.get(j);
            String ldapName = (String)p.get("ATTRIB_LDAP_NAME");
            String columnName = (String)p.get("ATTRIB_COLUMN_NAME");
            Integer attributeId = (Integer)p.get("ATTRIB_ID");
            relationalType = (Integer)p.get("RELATIONAL_TYPE");
            if (this.toBeExecutedAttributeList != null && !this.toBeExecutedAttributeList.contains(ldapName)) continue;
            values = (ArrayList)prop.get(ldapName);
            values = this.getDBCustomizedValues(columnName, ldapName, prop);
            StringBuffer buf = new StringBuffer();
            if (relationalType.equals(new Integer(1))) {
                buf.append("-");
                if (values != null && !values.isEmpty()) {
                    for (int k = 0; k < values.size(); ++k) {
                        String value = (String)values.get(k);
                        Row r1 = null;
                        if (multipleTableRowList.size() > k) {
                            r1 = (Row)multipleTableRowList.get(k);
                        } else {
                            r1 = new Row(tableName);
                            if (tableRowMap.size() > 0) {
                                this.getUniqueId(this.generationId, r1, guid);
                            }
                            multipleTableRowList.add(k, r1);
                        }
                        r1.set(columnName, (Object)value);
                        buf.append(value);
                        if (k == values.size() - 1) continue;
                        buf.append(",");
                    }
                } else {
                    if (r == null) {
                        r = new Row(tableName);
                    }
                    r.set(columnName, (Object)"-");
                }
            } else if (values != null && !values.isEmpty()) {
                if (r == null) {
                    r = new Row(tableName);
                }
                r.set(columnName, values.get(0));
                buf.append(values.get(0));
            } else {
                if (r == null) {
                    r = new Row(tableName);
                }
                r.set(columnName, (Object)"-");
                buf.append("-");
            }
            uiValues.put(attributeId, buf.toString());
        }
        if (r != null) {
            Hashtable sidVsAclIdMap = (Hashtable)genIdTableKeyMap.get(this.generationId);
            if (sidVsAclIdMap == null) {
                sidVsAclIdMap = new Hashtable();
            }
            if (sidVsAclIdMap.get(guid) == null) {
                Hashtable<String, Object> securityprincipalMap = new Hashtable<String, Object>();
                DBUtil.fillGeneratedValues(r);
                sidVsAclIdMap.put(guid, securityprincipalMap);
                securityprincipalMap.put(tableKey, r.get(tableKey));
                rowList.add(r);
            }
            genIdTableKeyMap.put(this.generationId, sidVsAclIdMap);
        }
        if (multipleTableRowList.size() > 0) {
            rowList.addAll(multipleTableRowList);
        }
        if (relationalType.equals(new Integer(0))) {
            tableRowMap.put(tableName, rowList);
        } else if (rowList.size() > 0) {
            relationalTableRowMap.put(tableName, rowList);
        }
    }

    @Override
    public void getUniqueId(Long generationId, Row r, String guid) {
        try {
            Hashtable sidVsAclIdMap = (Hashtable)genIdTableKeyMap.get(generationId);
            Hashtable aclIdVsSecurityPrincipal = (Hashtable)sidVsAclIdMap.get(guid);
            r.set(this.tableKey, aclIdVsSecurityPrincipal.remove("ACLS_ID"));
            DBUtil.fillGeneratedValues((Row)r);
            aclIdVsSecurityPrincipal.put(this.tableKey, r.get(this.tableKey));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void updateAttributeList(ReportBean bean, ArrayList attributeList) {
        String generatedTableName = "ADSMFolderPermissionDetails_" + this.generationId;
        for (int i = 0; i < attributeList.size(); ++i) {
            Properties prop = (Properties)attributeList.get(i);
            String tableName = prop.getProperty("TABLE_NAME");
            if (!tableName.equalsIgnoreCase("ADSMFolderPermissionDetails")) continue;
            prop.put("TABLE_NAME", generatedTableName);
        }
    }

    @Override
    public synchronized void addRow(Properties prop) {
        String guid = this.getGuid(prop);
        Properties props = new Properties();
        try {
            if (guid == null) {
                return;
            }
            Properties sidProp = cacheMgr.get(this.domainName, this.loginId, guid, this.lookupServer);
            props.putAll((Map<?, ?>)prop);
            if (sidProp == null) {
                this.permissionsPropList.add(props);
                return;
            }
            props.putAll((Map<?, ?>)sidProp);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.noOfObjects == null || this.reportId == null) {
            this.continueAction = false;
            System.out.println("Number Of Objects exceeded beyond the License Limit");
            return;
        }
        if (!this.noOfObjects.equalsIgnoreCase("unlimited")) {
            try {
                int licensedCount = Integer.parseInt(this.noOfObjects);
                if (this.reportId < 100 && this.totalCount >= licensedCount || this.totalCount >= licensedCount && licensedCount == 100) {
                    this.updateQueue();
                    this.continueAction = false;
                    System.out.println("Number Of Objects exceeded beyond the License Limit");
                    return;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            ++this.totalCount;
            Hashtable tableRowMap = new Hashtable();
            Hashtable relationalTableRowMap = new Hashtable();
            Hashtable uiValues = new Hashtable();
            Hashtable stringRowMap = new Hashtable();
            if (this.updatedCount < 1) {
                this.viewAttributeList = ReportAttributeHandler.getInstance().getViewAttributesList(this.reportId, this.loginId);
            }
            this.addRow(props, guid, tableRowMap, relationalTableRowMap, uiValues, stringRowMap);
            Hashtable sidVsAclIdMap = (Hashtable)genIdTableKeyMap.get(this.generationId);
            Hashtable sidVsAclId = (Hashtable)sidVsAclIdMap.get(guid);
            String uniqueGuid = ((Long)sidVsAclId.get(this.tableKey)).toString();
            this.queue.add(this.generationId, uniqueGuid, tableRowMap, relationalTableRowMap, this.baseTableName, stringRowMap);
            if (!this.guidList.contains(uniqueGuid)) {
                this.guidList.add(uniqueGuid);
            }
            StringBuffer b = new StringBuffer();
            String s = (String)uiValues.get(11134);
            if (s == null || s.trim().equalsIgnoreCase("")) {
                b.append("-");
            } else {
                s = ClientUtil.scriptEscape(s.substring(1, s.length()));
                b.append(s);
            }
            this.updateStatus(b.toString());
            this.queue.checkForNextUpdate(this.generationId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateStatus(String folderPath) {
        String str = MessageFormat.format(this.rb.getString("admp.reports.ntfs_reports.permission_for_folders.info_getting_permissions_for_the_folders"), folderPath);
        if (this.out != null && this.totalCount % 10 == 0) {
            this.out.write("<script> updateStatusMsg('" + str + "')</script>");
            this.out.flush();
        }
    }

    public void dropAndCreateTable() {
        String generatedTableName = "ADSMFolderPermissionDetails_" + this.generationId;
        try {
            TableDefinition tableDef = MetaDataUtil.getTableDefinitionByName((String)generatedTableName);
            if (tableDef == null) {
                tableDef = new TableDefinition();
                tableDef.setTableName(generatedTableName);
                ColumnDefinition coldef = new ColumnDefinition();
                coldef.setColumnName("ACLS_ID");
                coldef.setDescription("Acls Id for the security principal");
                coldef.setDataType("BIGINT");
                coldef.setNullable(false);
                tableDef.addColumnDefinition(coldef);
                coldef = new ColumnDefinition();
                coldef.setColumnName("ACE_TYPE");
                coldef.setDescription("Type of the ACE in String Format. ie (Allow/Deny)");
                coldef.setDataType("CHAR");
                coldef.setMaxLength(100);
                coldef.setNullable(false);
                coldef.setUnique(false);
                tableDef.addColumnDefinition(coldef);
                coldef = new ColumnDefinition();
                coldef.setColumnName("PERMISSION");
                coldef.setDescription("Permission of the ACE in String Format");
                coldef.setDataType("CHAR");
                coldef.setMaxLength(1000);
                coldef.setNullable(false);
                coldef.setUnique(false);
                tableDef.addColumnDefinition(coldef);
                coldef = new ColumnDefinition();
                coldef.setColumnName("APPLIES_TO");
                coldef.setDescription("Applies-To of the ACE in String Format");
                coldef.setDataType("CHAR");
                coldef.setMaxLength(100);
                coldef.setNullable(false);
                coldef.setUnique(false);
                tableDef.addColumnDefinition(coldef);
                coldef = new ColumnDefinition();
                coldef.setColumnName("INPUT_DN");
                coldef.setDescription("Input Path");
                coldef.setDataType("CHAR");
                coldef.setMaxLength(1000);
                coldef.setNullable(false);
                coldef.setUnique(false);
                tableDef.addColumnDefinition(coldef);
                coldef = new ColumnDefinition();
                coldef.setColumnName("INHERITED_ACE");
                coldef.setDescription("Is this an inherited ace");
                coldef.setDataType("CHAR");
                coldef.setMaxLength(100);
                coldef.setNullable(false);
                coldef.setUnique(false);
                tableDef.addColumnDefinition(coldef);
                coldef = new ColumnDefinition();
                coldef.setColumnName("PERMISSION_ID");
                coldef.setDescription("Identifier for each Permission");
                coldef.setDataType("BIGINT");
                coldef.setNullable(false);
                UniqueValueGeneration generator = new UniqueValueGeneration();
                generator.setGeneratorName(generatedTableName + ".PERMISSION_ID");
                coldef.setUniqueValueGeneration(generator);
                tableDef.addColumnDefinition(coldef);
                PrimaryKeyDefinition pkDef = new PrimaryKeyDefinition();
                pkDef.setName(generatedTableName + "_PK");
                pkDef.addColumnName("PERMISSION_ID");
                pkDef.setTableName(generatedTableName);
                tableDef.setPrimaryKey(pkDef);
                DynamicTableUtil.createDynamicTable((TableDefinition)tableDef);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            String message = e.getMessage();
            System.out.println("Exception message :  " + message);
        }
    }

    @Override
    public ArrayList getDBCustomizedValues(String columnName, String ldapName, Properties prop) {
        ArrayList<String> ret = super.getDBCustomizedValues(columnName, ldapName, prop);
        ArrayList values = (ArrayList)prop.get(ldapName);
        if (ldapName.equalsIgnoreCase("permission")) {
            ret = new ArrayList<String>();
            for (int i = 0; i < values.size(); ++i) {
                ArrayList val;
                Properties p = (Properties)values.get(i);
                if (columnName.equalsIgnoreCase("ACE_TYPE")) {
                    val = (ArrayList)p.get("aceType");
                    ret.add(this.rb.getString((String)val.get(0)));
                    continue;
                }
                if (columnName.equalsIgnoreCase("APPLIES_TO")) {
                    val = (ArrayList)p.get("appliesTo");
                    ret.add(this.rb.getString((String)val.get(0)));
                    continue;
                }
                if (columnName.equalsIgnoreCase("INPUT_DN")) {
                    val = (ArrayList)p.get("inputName");
                    ret.add(this.rb.getString((String)val.get(0)));
                    continue;
                }
                if (columnName.equalsIgnoreCase("INHERITED_ACE")) {
                    val = (ArrayList)p.get("isInherited");
                    ret.add(this.rb.getString((String)val.get(0)));
                    continue;
                }
                if (!columnName.equalsIgnoreCase("PERMISSION")) continue;
                val = (ArrayList)p.get("permissionStr");
                Object object = val.get(0);
                if (object instanceof List) {
                    ArrayList permList = (ArrayList)object;
                    StringBuffer permissionsBuffer = new StringBuffer();
                    for (int j = 0; j < permList.size(); ++j) {
                        if (j == 0) {
                            permissionsBuffer.append(this.rb.getString((String)permList.get(j)));
                            continue;
                        }
                        permissionsBuffer.append(", ");
                        permissionsBuffer.append(this.rb.getString((String)permList.get(j)));
                    }
                    ret.add(permissionsBuffer.toString());
                    continue;
                }
                if (!(object instanceof String)) continue;
                String permString = (String)object;
                String[] permList = permString.split(",");
                StringBuffer permissionsBuffer = new StringBuffer();
                for (int j = 0; j < permList.length; ++j) {
                    if (j == 0) {
                        permissionsBuffer.append(this.rb.getString(permList[j]));
                        continue;
                    }
                    permissionsBuffer.append(", ");
                    permissionsBuffer.append(this.rb.getString(permList[j]));
                }
                ret.add(permissionsBuffer.toString());
            }
        }
        return ret;
    }

    @Override
    public void start(ArrayList attributeList, HttpServletRequest request, ReportBean bean) {
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        String searchPath = request.getParameter("searchPath");
        this.setSyncEnabled();
        try {
            this.dropAndCreateTable();
            ArrayList containerList = this.getContainerList(request, bean);
            String dn = request.getParameter("domains");
            String domainName = null;
            if (dn != null) {
                Hashtable dnDomainNameMap = (Hashtable)bean.get("dnDomainNameMap");
                domainName = (String)dnDomainNameMap.get(dn);
            } else {
                Properties domainProps = HDTDomainHandler.getSelectedDomain((Long)loginId);
                domainName = domainProps.getProperty("DOMAIN_NAME");
            }
            this.domainName = domainName;
            this.loginId = loginId;
            HashMap reportInputParams = (HashMap)bean.get("reportInputParams");
            ArrayList pathList = new ArrayList();
            pathList = (ArrayList)bean.get("pathList");
            String pathDesc = "";
            String path = request.getParameter("path");
            if (path.length() < descLength) {
                this.getDescription(new Object[]{path});
            } else {
                int level = 0;
                for (int i = 0; i < pathList.size() - 1 && pathDesc.length() + ((String)pathList.get(i)).length() < descLength; ++i) {
                    pathDesc = pathDesc + (String)pathList.get(i);
                    pathDesc = pathDesc + ", ";
                    ++level;
                }
                pathDesc = pathDesc + "...(" + (pathList.size() - level) + " " + this.rb.getString("admp.common.text.more_text") + ")";
                this.getDescription(new Object[]{pathDesc});
            }
            HashMap<String, String> inputParams = new HashMap<String, String>();
            String[] domainList = request.getParameterValues("domains");
            inputParams.put("domain", ClientUtil.getString(domainList));
            bean.set("inputParams", inputParams);
            Action action = new Action(loginId, reportInputParams, attributeList, this, domainName, this.isSyncEnabled());
            action.start();
            this.updateAction = new AbstractNTFSReportsListener.UpdateAction(this);
            this.updateAction.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public synchronized void addPermissions() {
        for (int i = 0; i < this.permissionsPropList.size(); ++i) {
            this.addRow((Properties)this.permissionsPropList.remove(i));
        }
    }

    @Override
    public void updateQueue() {
        try {
            while (!this.queue.isCompleted(this.generationId)) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void deRegisterMap(Long generationId) {
        genIdTableKeyMap.remove(generationId);
    }

    @Override
    public void setReportRows(HttpServletRequest request, ReportBean bean, Long generationId, ArrayList attributelist, ReportReqParams reqParams) {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        Integer reportId = (Integer)bean.get("reportId");
        ArrayList tableNames = new ArrayList();
        String[] inputFiltervalues = request.getParameterValues("inputs");
        String inputChange = request.getParameter("inputChange");
        if (inputFiltervalues != null && inputFiltervalues.length > 0) {
            this.updatedCount = 0;
            this.errorMessage = null;
            if (inputChange != null) {
                bean.set("FROM_INDEX", 1L);
                bean.set("PAGE_NUMBER", "1");
            }
        }
        Criteria crit = null;
        Criteria columnSearchCriteria = ReportResultUtil.getColumnSearchCriteria(attributelist, reqParams, tableNames);
        Criteria reportFilterCriteria = this.getReportResultFilterCriteria(request, reqParams, crit);
        if (columnSearchCriteria != null) {
            crit = columnSearchCriteria;
        }
        if (reportFilterCriteria != null) {
            crit = crit != null ? crit.and(reportFilterCriteria) : reportFilterCriteria;
        }
        SelectQuery sq = ReportResultUtil.getCountSQ(crit, generationId, this.getResultTableName(), tableNames, this.tableKey);
        Integer count = DBUtil.getCount((SelectQuery)sq);
        request.setAttribute("recordsCount", (Object)count);
        if (count != null && count != 0) {
            Integer attributeId;
            if (this.updatedCount == 0) {
                this.updatedCount = -1;
            }
            if ((attributeId = reqParams.getSortAttribId()) == null || attributeId.equals(new Integer(-1))) {
                attributeId = ReportAttributesUtil.getDefaultSortingProp((Integer)reportId, (ArrayList)attributelist);
            }
            String ascending = String.valueOf(reqParams.isSortOrder());
            Properties attributeProp = ListenerUtil.getAttributeProp(attributeId, attributelist);
            if (attributeProp == null) {
                attributeId = ReportAttributesUtil.getDefaultSortingProp((Integer)reportId, (ArrayList)attributelist);
                attributeProp = ListenerUtil.getAttributeProp(attributeId, attributelist);
            }
            Hashtable multipleValuesSids = new Hashtable();
            ArrayList list = ReportResultUtil.getRows(this, generationId, this.getResultTableName(), attributelist, attributeProp, new Boolean(reqParams.isSortOrder()), reqParams.getFromIndex(), reqParams.getRange(), multipleValuesSids, reportFilterCriteria, columnSearchCriteria, this.tableKey, new ArrayList<String>());
            FolderPermissionListener.fillObjectType(list);
            ReportHandler.getMultipleValues((ArrayList)attributelist, multipleValuesSids, (String)this.tableKey, null, (ArrayList)list);
            ReportResultUtil.getCustomizedMultipleValues(multipleValuesSids);
            request.setAttribute("multipleValuesSids", multipleValuesSids);
            request.setAttribute("result", (Object)list);
            request.setAttribute("tableKey", (Object)this.tableKey);
            bean.set("attributeId", attributeId);
            if (ascending.equals("true")) {
                request.setAttribute("sortImage", (Object)"images/sortdown.gif");
            } else {
                request.setAttribute("sortImage", (Object)"images/sortup.gif");
            }
            request.setAttribute("errorList", (Object)this.errorList);
        } else if (this.errorMessage != null) {
            request.setAttribute("errorMsg", (Object)this.errorMessage);
            this.errorMessage = null;
        } else if (this.updatedCount != -1) {
            request.setAttribute("errorMsg", (Object)rb.getString("client.admin.SearchListener.no_reports_available"));
        }
    }

    public static void fillObjectType(ArrayList list) {
        try {
            for (int i = 0; i < list.size(); ++i) {
                Hashtable prop = (Hashtable)list.get(i);
                String trustee = (String)prop.get(11111);
                Criteria crit = new Criteria(new Column("ADSMReportFolderACLsDetails", "SECURITY_PRINCIPAL"), (Object)trustee, 0);
                DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMReportFolderACLsDetails", crit);
                if (dataObj.isEmpty()) continue;
                Row r = dataObj.getFirstRow("ADSMReportFolderACLsDetails");
                prop.put("objectType", r.get("OBJECT_CLASS"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getACEQuery(Long generationId, String tableName, ArrayList attributeList, Properties attributeProp, boolean ascending, int startIndex, int numOfObjects, Hashtable multipleValuesSids, Criteria crit) {
        Object resultList = null;
        String sql = null;
        try {
            int i;
            String table;
            ArrayList<Column> selectColumnList = new ArrayList<Column>();
            ArrayList<String> tableNames = new ArrayList<String>();
            Table baseTable = new Table(tableName);
            SelectQueryImpl query = new SelectQueryImpl(baseTable);
            boolean relationalTypePresent = false;
            for (int i2 = 0; i2 < attributeList.size(); ++i2) {
                Column column;
                Properties attributeProperties = (Properties)attributeList.get(i2);
                Integer relationalType = (Integer)attributeProperties.get("RELATIONAL_TYPE");
                table = attributeProperties.getProperty("TABLE_NAME");
                if (table == null || relationalType.equals(new Integer(1))) {
                    attributeProperties.put("RELATIONAL_TYPE", new Integer(0));
                }
                if (!selectColumnList.contains(column = new Column(table, attributeProperties.getProperty("ATTRIB_COLUMN_NAME")))) {
                    selectColumnList.add(column);
                } else {
                    attributeList.remove(i2);
                    --i2;
                }
                if (tableNames.contains(table)) continue;
                tableNames.add(table);
            }
            ArrayList onClickTextAttributeList = ReportResultUtil.getOnClickTextAttributes(this.onClickText);
            for (i = 0; onClickTextAttributeList != null && i < onClickTextAttributeList.size(); ++i) {
                Properties p = (Properties)onClickTextAttributeList.get(i);
                table = p.getProperty("TABLE_NAME");
                if (table.equalsIgnoreCase("ADSMFolderDetails")) {
                    table = attributeProp.getProperty("TABLE_NAME");
                }
                String columnName = p.getProperty("ATTRIB_COLUMN_NAME");
                Column column = new Column(table, columnName);
                selectColumnList.add(column);
                if (tableNames.contains(table)) continue;
                tableNames.add(table);
            }
            for (i = 0; i < tableNames.size(); ++i) {
                String table2 = (String)tableNames.get(i);
                Join join = new Join(baseTable, new Table(table2), new String[]{this.tableKey}, new String[]{this.tableKey}, 1);
                query.addJoin(join);
            }
            query.addSelectColumns(selectColumnList);
            query.addSelectColumn(new Column(tableName, this.tableKey));
            Criteria generationCriteria = new Criteria(new Column(tableName, "REPORT_GENERATION_ID"), (Object)generationId, 0);
            if (crit != null) {
                generationCriteria = generationCriteria.and(crit);
            }
            query.setCriteria(generationCriteria);
            if (startIndex != -1) {
                query.setRange(new Range(startIndex, numOfObjects));
            }
            if (attributeProp != null && attributeProp.getProperty("TABLE_NAME") != null) {
                SortColumn sortcolumn = new SortColumn(new Column(attributeProp.getProperty("TABLE_NAME"), attributeProp.getProperty("ATTRIB_COLUMN_NAME")), ascending);
                query.addSortColumn(sortcolumn);
            }
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            sql = relationalAPI.getSelectSQL((Query)query);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sql;
    }

    @Override
    public void exportReport(Row reportDetails, String reportType, ArrayList attributelist, Map inputParams, HttpServletRequest request, HttpServletResponse response, String reportList, AbstractListener listener, ArrayList trusteesList, ReportReqParams reqParams) {
        ReportExportUtil.exportReportForHugeData(reportDetails, reportType, attributelist, inputParams, request, response, reportList, listener, trusteesList, reqParams);
    }

    @Override
    public void executeTask(ArrayList containerList, Hashtable dnDomainNameMap, ReportFilterConfig reportFilterConfig) {
        this.executeTask(containerList, dnDomainNameMap, null, null, reportFilterConfig);
    }

    @Override
    public void executeTask(ArrayList containerList, Hashtable dnDomainNameMap, Hashtable excludedOUList, Hashtable domainVsExcludeChildOU, ReportFilterConfig reportFilterConfig) {
        try {
            this.isCompleted = false;
            String path = "";
            String level = "";
            List<Object> pathValues = new ArrayList();
            for (AdmpInput admpInput : reportFilterConfig.getInputList()) {
                if (admpInput.getIsMultiple().booleanValue()) continue;
                if (admpInput.getName().equalsIgnoreCase("path")) {
                    path = admpInput.getValue();
                    String[] pathArray = path.split(",");
                    pathValues = Arrays.asList(pathArray);
                    continue;
                }
                if (!admpInput.getName().equalsIgnoreCase("level")) continue;
                level = admpInput.getValue();
            }
            this.setSyncEnabled();
            this.generationId = ReportHandler.addReportGenerationDetails((Integer)this.reportId, (String)this.desc, (Long)this.loginId);
            this.domainName = (String)dnDomainNameMap.get(containerList.get(0));
            if (this.domainName != null) {
                this.getDescription(new Object[]{path});
                String[] key = new String[]{"pathList", "folderLevel"};
                Hashtable inputhash = ListenerUtil.getInputTable(this.reportId, key);
                ArrayList pathList = new ArrayList();
                ArrayList levelList = new ArrayList();
                for (int i = 0; i < pathValues.size(); ++i) {
                    Hashtable<String, Object> reportInputs = new Hashtable<String, Object>();
                    reportInputs.put("SERVER_SID", "");
                    reportInputs.put("INPUT_NAME", (String)pathValues.get(i));
                    reportInputs.put("REPORT_GENERATION_ID", this.generationId);
                    ListenerUtil.fillValues((String)inputhash.get("pathList"), this.reportId, reportInputs, this.generationId);
                    pathList.add(reportInputs);
                }
                Hashtable<String, Object> reportInputs = new Hashtable<String, Object>();
                reportInputs.put("INPUT_PROPERTY_NAME", "folderLevel");
                reportInputs.put("INPUT_PROPERTY_VALUE", level);
                reportInputs.put("REPORT_GENERATION_ID", this.generationId);
                ListenerUtil.fillValues((String)inputhash.get("folderLevel"), this.reportId, reportInputs, this.generationId);
                levelList.add(reportInputs);
                HashMap reportInputParams = new HashMap();
                reportInputParams.put("pathList", pathList);
                reportInputParams.put("folderLevel", levelList);
                this.dropAndCreateTable();
                Action action = new Action(1L, reportInputParams, this.getAttributeList(), this, this.domainName, this.isSyncEnabled());
                action.start();
                this.updateAction = new AbstractNTFSReportsListener.UpdateAction(this);
                this.updateAction.start();
                while (!this.isCompleted) {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                ReportHandler.updateReportGenerationDetails((Long)this.generationId, (int)1, (String)this.desc, (Long)this.loginId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        try {
            cacheMgr = (SIDCacheManager)CacheFactory.getInstance().getCache((Object)"sidCache");
            if (!cacheMgr.isInitialized()) {
                cacheMgr.initializeDomainSids();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public class Action
    extends Thread {
        private ArrayList attributeList = null;
        private NativeListener listener = null;
        private String domainName = null;
        private Long loginId = null;
        private Map inputParams = null;
        private boolean isSyncEnabled = false;

        public Action(Long loginId, Map inputParams, ArrayList attributeList, NativeListener li, String domainName, boolean isSyncEnabled) {
            this.loginId = loginId;
            this.attributeList = attributeList;
            this.listener = li;
            this.domainName = domainName;
            this.inputParams = inputParams;
            this.isSyncEnabled = isSyncEnabled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            FolderPermissionListener.this.guidList = new ArrayList();
            ArrayList inputsList = (ArrayList)this.inputParams.get("pathList");
            HashMap serverVsShares = ComputerHandler.getSharesListForServers((ArrayList)inputsList, (Long)this.loginId, (String)this.domainName);
            ArrayList folderLevelList = (ArrayList)this.inputParams.get("folderLevel");
            Hashtable folderLevelValues = (Hashtable)folderLevelList.get(0);
            String folderLevelStr = (String)folderLevelValues.get("INPUT_PROPERTY_VALUE");
            int folderLevel = Integer.parseInt(folderLevelStr);
            Hashtable tableProps = FolderPermissionListener.this.getQueueProps();
            String key = "";
            Hashtable<String, String> domainKey = new Hashtable<String, String>();
            if (this.isSyncEnabled) {
                this.attributeList = ADSyncUtil.getNonSyncAttributes((ArrayList)this.attributeList);
                key = DomainHandler.doReportSync((String)this.domainName, (Long)CommonUtil.ADMIN_LOGIN_ID, (String[])new String[]{"user", "group", "computer", "contact", "groupMember", "primaryGroup"});
                domainKey.put(key, this.domainName);
            }
            for (int i = 0; i < inputsList.size(); ++i) {
                Hashtable inputValues = (Hashtable)inputsList.get(i);
                tableProps.put("inputId", (Long)inputValues.get("INPUT_ID"));
                String pathName = (String)inputValues.get("INPUT_NAME");
                FolderPermissionListener.this.lookupServer = pathName.indexOf("\\", 2) != -1 ? pathName.substring(2, pathName.indexOf("\\", 2)) : pathName.substring(2);
                ArrayList<String> sharesList = new ArrayList<String>();
                if (serverVsShares.containsKey(pathName)) {
                    sharesList.addAll((ArrayList)serverVsShares.get(pathName));
                } else {
                    sharesList.add(pathName);
                }
                for (int j = 0; j < sharesList.size(); ++j) {
                    try {
                        FolderPermissionListener.this.queue.registerForUpdation(FolderPermissionListener.this.baseTableName, FolderPermissionListener.this.generationId, tableProps);
                        FolderPermissionListener.this.doAction(this.domainName, this.loginId, (String)sharesList.get(j), this.attributeList, folderLevel, this.listener);
                        FolderPermissionListener.this.updateQueue();
                    }
                    catch (LocalizedException e) {
                        e.printStackTrace();
                        FolderPermissionListener.this.setErrorMessage(e.getMessage(FolderPermissionListener.this.rb));
                        System.out.println("LocalizedException: - " + FolderPermissionListener.this.errorMessage);
                    }
                    catch (Exception e) {
                        System.out.println("isCompleted is true " + FolderPermissionListener.this.isCompleted);
                        e.printStackTrace();
                        FolderPermissionListener.this.errorMessage = e.getMessage();
                    }
                    int size = 0;
                    do {
                        try {
                            NativeListener nativeListener = this.listener;
                            synchronized (nativeListener) {
                                size = FolderPermissionListener.this.permissionsPropList.size();
                            }
                            Thread.sleep(500L);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } while (size > 0);
                }
            }
            FolderPermissionListener.this.updateAction.shutDown();
            FolderPermissionListener.this.updatedCount = 0;
            FolderPermissionListener.this.totalCount = 0;
            FolderPermissionListener.this.deRegisterMap(FolderPermissionListener.this.generationId);
            if (!domainKey.isEmpty()) {
                String syncStatus = DomainProcess.getInstance().getProcessStatus(domainKey);
                while (FolderPermissionListener.this.continueAction && syncStatus.equalsIgnoreCase("false")) {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    syncStatus = DomainProcess.getInstance().getProcessStatus(domainKey);
                }
            }
            FolderPermissionListener.this.completedAction();
        }
    }
}

