/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.reports;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.AdmpInput;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.DomainInfoCache;
import com.adventnet.sym.adsm.common.server.DomainProcess;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.adsync.ADSyncUtil;
import com.adventnet.sym.adsm.common.server.automation.ReportFilterConfig;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.queue.QueueHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportHandler;
import com.adventnet.sym.adsm.common.server.resultdata.ResultDataHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.SchedulerUtil;
import com.adventnet.sym.adsm.common.webclient.reports.AbstractGroupListener;
import com.adventnet.sym.adsm.common.webclient.reports.ListenerUtil;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class GroupScopes
extends AbstractGroupListener {
    @Override
    protected void checkAttributeList(ArrayList attributeList) {
    }

    @Override
    public void getDescription(Object[] args) {
        this.desc = MessageFormat.format(this.rb.getString("admp.reports.grp_reports.types_scopes.reportdesc_grps_of_type_scope_of_the_domains"), args);
    }

    @Override
    public void setSyncEnabled() {
        this.setSyncEnabled(true);
    }

    @Override
    public void doAction(String domainName, Long loginId, String distinguishedName, ArrayList attributeList, NativeListener listener) throws Exception {
    }

    @Override
    public void start(ArrayList attributeList, HttpServletRequest request, ReportBean bean) {
        String type = request.getParameter("grouptype");
        String scope = request.getParameter("groupscope");
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        try {
            ArrayList containerList = this.getContainerList(request, bean);
            Hashtable dnDomainNameMap = (Hashtable)bean.get("dnDomainNameMap");
            Hashtable domainVsExcludeChildOU = (Hashtable)bean.get("domainVsExcludeChildOU");
            Hashtable excludedOUList = (Hashtable)bean.get("excludedOUList");
            Hashtable excludeContainerHash = this.constructExcludeContainerHash(containerList, domainVsExcludeChildOU, excludedOUList, dnDomainNameMap);
            HashMap<String, String> inputParams = new HashMap<String, String>();
            inputParams.put("type", type);
            inputParams.put("scope", scope);
            String[] domainList = request.getParameterValues("domains");
            ArrayList selectedDomains = new ArrayList();
            Hashtable defaultNamingContextVsDomainName = DomainInfoCache.getInstance().getDefaultNamingContextVsDomainName();
            for (int i = 0; i < domainList.length; ++i) {
                selectedDomains.add(defaultNamingContextVsDomainName.get(domainList[i]));
            }
            inputParams.put("domain", ClientUtil.getString(domainList));
            String reportDomains = this.getReportDomains(domainList, dnDomainNameMap);
            this.getDescription(new Object[]{type, scope, reportDomains});
            this.setSyncEnabled();
            Action action = new Action(loginId, selectedDomains, containerList, attributeList, this, type, scope, dnDomainNameMap, excludeContainerHash, this.isSyncEnabled());
            action.start();
            bean.set("inputParams", inputParams);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void executeTask(ArrayList containerList, Hashtable dnDomainNameMap, ReportFilterConfig reportFilterConfig) {
        this.executeTask(containerList, dnDomainNameMap, null, null, reportFilterConfig);
    }

    @Override
    public void executeTask(ArrayList containerList, Hashtable dnDomainNameMap, Hashtable excludedOUList, Hashtable domainVsExcludeChildOU, ReportFilterConfig reportFilterConfig) {
        try {
            String type = "Security";
            String scope = "Domain Local";
            System.out.println("Execute Task Started ");
            this.isCompleted = false;
            for (AdmpInput admpInput : reportFilterConfig.getInputList()) {
                if (admpInput.getIsMultiple().booleanValue()) continue;
                if (admpInput.getName().equalsIgnoreCase("scope")) {
                    scope = admpInput.getValue();
                    continue;
                }
                type = admpInput.getValue();
            }
            String schedulerDomains = this.getSchedulerDomains(containerList, dnDomainNameMap);
            this.getDescription(new Object[]{type, scope, schedulerDomains});
            this.generationId = ReportHandler.addReportGenerationDetails((Integer)this.reportId, (String)this.desc, (Long)this.loginId);
            this.setSyncEnabled();
            ArrayList scheduledDomains = SchedulerUtil.getSchedulerDomains((Long)reportFilterConfig.getScheduleId());
            Hashtable excludeContainerHash = this.constructExcludeContainerHash(containerList, domainVsExcludeChildOU, excludedOUList, dnDomainNameMap);
            Action action = new Action(this.loginId, scheduledDomains, containerList, this.getAttributeList(), this, type, scope, dnDomainNameMap, excludeContainerHash, this.isSyncEnabled());
            action.start();
            while (!this.isCompleted) {
                try {
                    Thread.sleep(200L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ReportHandler.updateReportGenerationDetails((Long)this.generationId, (int)1, (String)this.desc, (Long)this.loginId);
            System.out.println("Execute Task Completed");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setDashboardInputParams(Long dashboardReportMapping, HttpServletRequest request, ReportBean bean) {
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"DashboardReportInputVals", (String)"DASHBOARD_REPORT_MAPPING"), (Object)dashboardReportMapping, 0);
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("DashboardReportInputVals", crit);
            Iterator itr = dataObj.getRows("DashboardReportInputVals");
            HashMap inputParams = (HashMap)bean.get("reportInputParams");
            while (itr.hasNext()) {
                Row row = (Row)itr.next();
                inputParams.put(row.get("PROPERTY").toString(), ListenerUtil.getInputValueAsList(row.get("VALUE")));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class Action
    extends Thread {
        private ArrayList selectedDomains = null;
        private ArrayList containerList = null;
        private ArrayList attributeList = null;
        private String type = null;
        private String scope = null;
        private NativeListener listener = null;
        private Hashtable dnDomainNameMap = null;
        private Long loginId = null;
        private boolean isSyncEnabled = false;
        private Hashtable excludeChildOUHash = null;

        public Action(Long loginId, ArrayList selectedDomains, ArrayList list, ArrayList attributeList, NativeListener li, String type, String scope, Hashtable map, Hashtable excludeChildOUHash, boolean isSyncEnabled) {
            this.loginId = loginId;
            this.selectedDomains = selectedDomains;
            this.containerList = list;
            this.attributeList = attributeList;
            this.listener = li;
            this.type = type;
            this.scope = scope;
            this.dnDomainNameMap = map;
            this.isSyncEnabled = isSyncEnabled;
            this.excludeChildOUHash = excludeChildOUHash;
        }

        @Override
        public void run() {
            GroupScopes.this.guidList = new ArrayList();
            Hashtable tableProps = GroupScopes.this.getQueueProps();
            String key = "";
            Hashtable<String, String> domainKey = new Hashtable<String, String>();
            if (this.isSyncEnabled) {
                this.attributeList = ADSyncUtil.getNonSyncAttributes((ArrayList)this.attributeList);
                for (int i = 0; i < this.selectedDomains.size(); ++i) {
                    key = DomainHandler.doReportSync((String)((String)this.selectedDomains.get(i)), (Long)CommonUtil.ADMIN_LOGIN_ID, (String[])new String[]{"user", "group", "computer", "contact", "groupMember", "primaryGroup"});
                    domainKey.put(key, (String)this.selectedDomains.get(i));
                }
            }
            ArrayList objectIds = GroupScopes.this.getObjIdList();
            GroupScopes.this.queueRegID = QueueHandler.getInstance().registerForUpdate(objectIds, GroupScopes.this.getTableColumns());
            GroupScopes.this.resultRegID = ResultDataHandler.getInstance().getProcessor().registerForUpdate(GroupScopes.this.resultTableName);
            for (int i = 0; i < this.containerList.size(); ++i) {
                try {
                    String dn = (String)this.containerList.get(i);
                    GroupScopes.this.domainName = (String)this.dnDomainNameMap.get(dn);
                    tableProps.put("domainName", GroupScopes.this.domainName);
                    Boolean isExcludeChildOU = Boolean.FALSE;
                    if (this.excludeChildOUHash != null && this.excludeChildOUHash.containsKey(dn)) {
                        isExcludeChildOU = (Boolean)this.excludeChildOUHash.get(dn);
                    }
                    this.listener.setIsExcludeChildOU(isExcludeChildOU);
                    System.out.println("Getting the Groups scope " + this.scope);
                    ADHandler.getScopeBasedGroups((String)GroupScopes.this.domainName, (Long)this.loginId, (String)dn, (ArrayList)this.attributeList, (NativeListener)this.listener, (String)this.type, (String)this.scope);
                    GroupScopes.this.updateQueue();
                    continue;
                }
                catch (LocalizedException e) {
                    e.printStackTrace();
                    GroupScopes.this.errorMessage = e.getMessage(GroupScopes.this.rb);
                    System.out.println("LocalizedException: - " + GroupScopes.this.errorMessage);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    GroupScopes.this.errorMessage = e.getMessage();
                }
            }
            GroupScopes.this.updatedCount = 0;
            GroupScopes.this.totalCount = 0;
            if (!domainKey.isEmpty()) {
                String syncStatus = DomainProcess.getInstance().getProcessStatus(domainKey);
                while (GroupScopes.this.continueAction && syncStatus.equalsIgnoreCase("false")) {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    syncStatus = DomainProcess.getInstance().getProcessStatus(domainKey);
                }
            }
            GroupScopes.this.completedAction();
        }
    }
}

