/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.reports;

import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.AdmpInput;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.automation.ReportFilterConfig;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.layout.component.FcOption;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.queue.QueueHandler;
import com.adventnet.sym.adsm.common.server.reports.GroupHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportHandler;
import com.adventnet.sym.adsm.common.server.resultdata.ResultDataHandler;
import com.adventnet.sym.adsm.common.webclient.reports.AbstractListener;
import com.adventnet.sym.adsm.common.webclient.reports.ListenerUtil;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class GroupUsersListener
extends AbstractListener {
    public void updateUI(String str) {
    }

    public void updateStatus(String domainName) {
        String str = this.rb.getString("client.reports.GroupUsersListener.getting_the_values_from_the_domain") + domainName + "\"";
        if (this.out != null) {
            this.out.write("<script> updateStatus('" + str + "')</script>");
            this.out.flush();
        }
    }

    @Override
    public void init(Row r) {
        this.baseTableName = (String)r.get("BASE_TABLE_NAME");
        this.resultTableName = (String)r.get("RESULT_TABLE_NAME");
        this.reportId = (Integer)r.get("REPORT_ID");
        this.onClickText = (String)r.get("ONCLICK_TEXT");
        if (this.rb == null) {
            this.rb = ResourceBundleMgr.getInstance().getBundle();
        }
        this.title = (String)r.get("REPORT_NAME");
    }

    @Override
    public void init(HttpServletRequest request, Row r) {
        HttpSession session = request.getSession();
        Locale locale = request.getLocale();
        this.rb = ResourceBundleMgr.getInstance().getBundle(locale);
        this.baseTableName = (String)r.get("BASE_TABLE_NAME");
        this.resultTableName = (String)r.get("RESULT_TABLE_NAME");
        this.reportId = (Integer)r.get("REPORT_ID");
        this.onClickText = (String)r.get("ONCLICK_TEXT");
        this.title = (String)r.get("REPORT_NAME");
        this.setGenerationId(request);
    }

    @Override
    public Hashtable getQueueProps() {
        Hashtable<String, Object> tableProps = new Hashtable<String, Object>();
        tableProps.put("baseTableName", this.baseTableName);
        tableProps.put("resultTableName", this.resultTableName);
        tableProps.put("generationId", this.generationId);
        tableProps.put("resultHandling", "addOrUpdate");
        return tableProps;
    }

    @Override
    public void fillInputDetails(String inputTable, HttpServletRequest request, ReportBean bean, String key) {
        String trustee = request.getParameter("gname");
        HashMap inputParams = (HashMap)bean.get("reportInputParams");
        Hashtable dnDomainNameMap = (Hashtable)bean.get("dnDomainNameMap");
        String[] domainList = (String[])bean.get("domains");
        ArrayList valuesList = new ArrayList();
        Hashtable<String, Object> inputs = new Hashtable<String, Object>();
        String inputName = request.getParameter("gnameStr");
        inputs.put("INPUT_NAME", inputName);
        String dn = GroupHandler.getDN((String)trustee, (String)((String)dnDomainNameMap.get(domainList[0])));
        inputs.put("DISTINGUISHED_NAME", dn);
        inputs.put("INPUT_OBJECT_ID", trustee);
        inputs.put("REPORT_GENERATION_ID", this.generationId);
        ListenerUtil.fillValues(inputTable, this.reportId, inputs, this.generationId);
        valuesList.add(inputs);
        inputParams.put(key, valuesList);
    }

    @Override
    protected void checkAttributeList(ArrayList attributeList) {
    }

    @Override
    public void getDescription(Object[] args) {
        this.desc = MessageFormat.format(this.rb.getString("admp.reports.user_reports.users_in_group.reportdesc_users_in_grp"), args);
    }

    @Override
    public void doAction(String domainName, Long loginId, String distinguishedName, ArrayList attributeList, NativeListener listener) throws Exception {
    }

    public void doAction(String domainName, Long loginId, String dn, String group, ArrayList attributeList, NativeListener listener) throws Exception {
        ADHandler.getGroupBasedUsers((String)domainName, (Long)loginId, (String)dn, (String)group, (ArrayList)attributeList, (NativeListener)listener);
    }

    @Override
    public void setInputParams(HttpServletRequest request, ReportBean bean) {
        String[] domains;
        String domainName = request.getParameter("domainName");
        if (domainName == null && (domains = (String[])bean.get("domains")).length > 0) {
            Hashtable dnDomainNameMap = (Hashtable)bean.get("dnDomainNameMap");
            bean.set("domains", new String[]{domains[0]});
        }
    }

    protected String getDescription(String[] domainList, Hashtable dnDomainNameMap, String groupName) {
        this.desc = this.getDescription(domainList, dnDomainNameMap, groupName);
        String description = "";
        if (domainList == null) {
            return description;
        }
        for (int i = 0; i < domainList.length; ++i) {
            String val;
            if (i != 0) {
                this.desc = this.desc + ", ";
            }
            if ((val = domainList[i]).equalsIgnoreCase("")) continue;
            this.desc = this.desc + dnDomainNameMap.get(val);
        }
        return this.desc;
    }

    @Override
    public void start(ArrayList attributeList, HttpServletRequest request, ReportBean bean) {
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        String[] domainList = request.getParameterValues("domains");
        String groupSID = request.getParameter("gname");
        System.out.println("Group Users listener: domainList[0] " + domainList[0]);
        Hashtable dnDomainNameMap = (Hashtable)bean.get("dnDomainNameMap");
        String distinguishedName = GroupHandler.getDN((String)groupSID, (String)((String)dnDomainNameMap.get(domainList[0])));
        String groupName = request.getParameter("gnameStr");
        try {
            ArrayList containerList = this.getContainerList(request, bean);
            HashMap<String, String> inputParams = new HashMap<String, String>();
            inputParams.put("domain", ClientUtil.getString(domainList));
            bean.set("inputParams", inputParams);
            String reportDomains = this.getReportDomains(domainList, dnDomainNameMap);
            this.getDescription(new Object[]{groupName, reportDomains});
            Action action = new Action(loginId, containerList, distinguishedName, attributeList, this, dnDomainNameMap);
            System.out.println(" Action constructor defined : ");
            action.start();
            System.out.println(" Action started: ");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void executeTask(ArrayList containerList, Hashtable dnDomainNameMap, ReportFilterConfig reportFilterConfig) {
        this.executeTask(containerList, dnDomainNameMap, null, null, reportFilterConfig);
    }

    @Override
    public void executeTask(ArrayList containerList, Hashtable dnDomainNameMap, Hashtable excludedOUList, Hashtable domainVsExcludeChildOU, ReportFilterConfig reportFilterConfig) {
        try {
            this.isCompleted = false;
            String input_Params = "";
            String groupName = "";
            for (AdmpInput admpInput : reportFilterConfig.getInputList()) {
                if (!admpInput.getIsMultiple().booleanValue()) continue;
                for (FcOption fcOption : admpInput.getMultipleInput()) {
                    if (fcOption.getLabel().equalsIgnoreCase("NAME")) {
                        groupName = fcOption.getValue();
                        continue;
                    }
                    if (!fcOption.getLabel().equalsIgnoreCase("SID_STRING")) continue;
                    input_Params = fcOption.getValue();
                }
            }
            String distinguishedName = GroupHandler.getDN((String)input_Params, (String)((String)dnDomainNameMap.get(containerList.get(0))));
            String schedulerDomains = this.getSchedulerDomains(containerList, dnDomainNameMap);
            this.getDescription(new Object[]{groupName, schedulerDomains});
            this.generationId = ReportHandler.addReportGenerationDetails((Integer)this.reportId, (String)this.desc, (Long)this.loginId);
            Action action = new Action(1L, containerList, distinguishedName, this.getAttributeList(), this, dnDomainNameMap);
            action.start();
            while (!this.isCompleted) {
                try {
                    Thread.sleep(200L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ReportHandler.updateReportGenerationDetails((Long)this.generationId, (int)1, (String)this.desc, (Long)this.loginId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public class Action
    extends Thread {
        private ArrayList containerList = null;
        private String group = null;
        private ArrayList attributeList = null;
        private NativeListener listener = null;
        private Hashtable dnDomainNameMap = null;
        private Long loginId = null;

        public Action(Long loginId, ArrayList list, String group, ArrayList attributeList, NativeListener li, Hashtable map) {
            this.loginId = loginId;
            this.containerList = list;
            this.group = group;
            this.attributeList = attributeList;
            this.listener = li;
            this.dnDomainNameMap = map;
        }

        @Override
        public void run() {
            GroupUsersListener.this.guidList = new ArrayList();
            Hashtable tableProps = GroupUsersListener.this.getQueueProps();
            ArrayList objectIds = GroupUsersListener.this.getObjIdList();
            GroupUsersListener.this.queueRegID = QueueHandler.getInstance().registerForUpdate(objectIds, GroupUsersListener.this.getTableColumns());
            GroupUsersListener.this.resultRegID = ResultDataHandler.getInstance().getProcessor().registerForUpdate(GroupUsersListener.this.resultTableName);
            for (int i = 0; i < this.containerList.size(); ++i) {
                try {
                    String dn = (String)this.containerList.get(i);
                    GroupUsersListener.this.domainName = (String)this.dnDomainNameMap.get(dn);
                    GroupUsersListener.this.updateStatus(GroupUsersListener.this.domainName);
                    System.out.println("Getting the Group Based Users Reports from the domain " + GroupUsersListener.this.domainName + ": dn :" + dn + ": attributeList:" + this.attributeList + ": group : " + this.group);
                    if (this.group != null) {
                        GroupUsersListener.this.doAction(GroupUsersListener.this.domainName, this.loginId, dn, this.group, this.attributeList, this.listener);
                    }
                    GroupUsersListener.this.updateQueue();
                    continue;
                }
                catch (LocalizedException e) {
                    e.printStackTrace();
                    GroupUsersListener.this.errorMessage = e.getMessage(GroupUsersListener.this.rb);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    GroupUsersListener.this.errorMessage = e.getMessage();
                }
            }
            GroupUsersListener.this.updatedCount = 0;
            GroupUsersListener.this.totalCount = 0;
            GroupUsersListener.this.completedAction();
        }
    }
}

