/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.reports;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.AdmpInput;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.DomainProcess;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.adsync.ADSyncUtil;
import com.adventnet.sym.adsm.common.server.automation.ReportFilterConfig;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.layout.component.FcOption;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.queue.QueueHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportReqParams;
import com.adventnet.sym.adsm.common.server.reports.StatusUpdater;
import com.adventnet.sym.adsm.common.server.resultdata.ResultDataHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.UserHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.webclient.reports.AbstractListener;
import com.adventnet.sym.adsm.common.webclient.reports.ListenerUtil;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.struts.validator.DynaValidatorForm;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GroupsForUsersListener
extends AbstractListener {
    @Override
    public Long getCategoryId() {
        Long categoryId = new Long(1016L);
        return categoryId;
    }

    @Override
    public boolean isResultViewOutputFilterAvailable() {
        return true;
    }

    @Override
    public String getOutputFilterLabelText() {
        return "admp.reports.group_report.text.showing_group_of";
    }

    @Override
    public Hashtable getQueueProps() {
        Hashtable<String, Object> tableProps = new Hashtable<String, Object>();
        tableProps.put("baseTableName", this.baseTableName);
        tableProps.put("resultTableName", this.resultTableName);
        tableProps.put("generationId", this.generationId);
        tableProps.put("resultHandling", "addOrUpdate");
        return tableProps;
    }

    @Override
    protected void checkAttributeList(ArrayList attributeList) {
        if (!attributeList.contains("userAccountControl")) {
            attributeList.add("userAccountControl");
        }
    }

    @Override
    public void setSyncEnabled() {
        this.setSyncEnabled(true);
    }

    @Override
    public void doAction(String domainName, Long loginId, String distinguishedName, ArrayList attributeList, NativeListener listener) throws Exception {
    }

    public void doAction(String domainName, Long loginId, String distinguishedName, String trustee, ArrayList attributeList, NativeListener listener) throws Exception {
        ADHandler.getNestedGroups((String)domainName, (Long)loginId, (ArrayList)attributeList, (NativeListener)listener, (String)trustee);
    }

    @Override
    public Criteria getReportResultFilterCriteria(HttpServletRequest request, ReportReqParams reqParams, Criteria crit) {
        JSONArray rvcFiltersArray = reqParams.getRvcFilters();
        try {
            String columnName = "INPUT_ID";
            if (rvcFiltersArray != null && rvcFiltersArray.length() > 0) {
                String[] inputFiltervalues = new String[rvcFiltersArray.length()];
                for (int index = 0; index < rvcFiltersArray.length(); ++index) {
                    JSONObject rvcFilterObject = (JSONObject)rvcFiltersArray.get(index);
                    Iterator iterator = rvcFilterObject.keys();
                    while (iterator.hasNext()) {
                        String inputId;
                        inputFiltervalues[index] = inputId = (String)iterator.next();
                        Hashtable errorValues = (Hashtable)this.errorList.get(inputId);
                        if (errorValues == null) continue;
                        if (this.errorMessage == null) {
                            this.errorMessage = (String)errorValues.get("ERROR_MESSAGE");
                            continue;
                        }
                        if (this.errorMessage.contains((String)errorValues.get("ERROR_MESSAGE"))) continue;
                        this.errorMessage = this.errorMessage + "," + (String)errorValues.get("ERROR_MESSAGE");
                    }
                }
                crit = crit == null ? new Criteria(new Column(this.resultTableName, columnName), (Object)inputFiltervalues, 8) : crit.and(new Criteria(new Column(this.resultTableName, columnName), (Object)inputFiltervalues, 8));
            }
        }
        catch (JSONException jsonEx) {
            jsonEx.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return crit;
    }

    @Override
    public Criteria getReportResultFilterCriteria(HttpServletRequest request, DynaValidatorForm bean, Criteria crit, String inputId) {
        try {
            String columnName = "INPUT_ID";
            ArrayList inputObjects = (ArrayList)bean.get("inputObjects");
            crit = !inputObjects.contains(inputId) && inputObjects.size() != 0 ? (crit == null ? new Criteria(new Column(this.resultTableName, columnName), (Object)0L, 0) : crit.and(new Criteria(new Column(this.resultTableName, columnName), (Object)0L, 0))) : (crit == null ? new Criteria(new Column(this.resultTableName, columnName), (Object)inputId, 0) : crit.and(new Criteria(new Column(this.resultTableName, columnName), (Object)inputId, 0)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return crit;
    }

    @Override
    public void fillInputDetails(String inputTable, HttpServletRequest request, ReportBean bean, String key) {
        ArrayList trusteesList = (ArrayList)bean.get("trusteesList");
        HashMap inputParams = (HashMap)bean.get("reportInputParams");
        Hashtable dnDomainNameMap = (Hashtable)bean.get("dnDomainNameMap");
        String[] domainList = (String[])bean.get("domains");
        Long loginId = (Long)request.getSession().getAttribute("ADMP_SESSION_LOGIN_ID");
        ArrayList valuesList = new ArrayList();
        for (int i = 0; i < trusteesList.size(); ++i) {
            Hashtable<String, Object> inputs = new Hashtable<String, Object>();
            String inputName = CommonUtil.getDisplayName((String)((String)dnDomainNameMap.get(domainList[0])), (String)((String)trusteesList.get(i)));
            inputs.put("INPUT_NAME", inputName);
            String dn = UserHandler.getUserDN((String)((String)dnDomainNameMap.get(domainList[0])), (String)((String)trusteesList.get(i)), (Long)loginId);
            inputs.put("DISTINGUISHED_NAME", dn);
            inputs.put("INPUT_OBJECT_ID", (String)trusteesList.get(i));
            inputs.put("REPORT_GENERATION_ID", this.generationId);
            ListenerUtil.fillValues(inputTable, this.reportId, inputs, this.generationId);
            valuesList.add(inputs);
        }
        inputParams.put(key, valuesList);
    }

    @Override
    public void start(ArrayList attributeList, HttpServletRequest request, ReportBean bean) {
        try {
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            this.checkAttributeList(attributeList);
            this.setSyncEnabled();
            HashMap reportInputParams = (HashMap)bean.get("reportInputParams");
            String dn = request.getParameter("domains");
            String domainName = null;
            if (dn != null) {
                Hashtable dnDomainNameMap = (Hashtable)bean.get("dnDomainNameMap");
                domainName = (String)dnDomainNameMap.get(dn);
            } else {
                Properties domainProps = HDTDomainHandler.getSelectedDomain((Long)loginId);
                domainName = domainProps.getProperty("DOMAIN_NAME");
            }
            this.getDescription(new Object[]{domainName});
            this.statusController.setProgressTask(StatusUpdater.TASKCODE.FETCHING_USERS_MEMBEROF.getValue());
            Action action = new Action(loginId, domainName, reportInputParams, attributeList, this, dn, this.isSyncEnabled());
            action.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void executeTask(ArrayList containerList, Hashtable dnDomainNameMap, ReportFilterConfig reportFilterConfig) {
        this.executeTask(containerList, dnDomainNameMap, null, null, reportFilterConfig);
    }

    @Override
    public void executeTask(ArrayList containerList, Hashtable dnDomainNameMap, Hashtable excludedOUList, Hashtable domainVsExcludeChildOU, ReportFilterConfig reportFilterConfig) {
        try {
            this.isCompleted = false;
            String dnName = "";
            String sidStr = "";
            Long scheduleId = reportFilterConfig.getScheduleId();
            String inputTableName = "ADSMReportObjectDNDetails";
            DataObject dataObject = ListenerUtil.getInputIdForSchedulerReportResult(this.reportId, scheduleId, inputTableName);
            for (AdmpInput admpInput : reportFilterConfig.getInputList()) {
                if (!admpInput.getIsMultiple().booleanValue()) continue;
                for (FcOption fcOption : admpInput.getMultipleInput()) {
                    if (fcOption.getLabel().equalsIgnoreCase("DISTINGUISHED_NAME")) {
                        dnName = fcOption.getValue();
                        continue;
                    }
                    if (!fcOption.getLabel().equalsIgnoreCase("SID_STRING")) continue;
                    sidStr = fcOption.getValue();
                }
            }
            this.generationId = ReportHandler.addReportGenerationDetails((Integer)this.reportId, (String)this.desc, (Long)this.loginId);
            this.setSyncEnabled();
            this.domainName = (String)dnDomainNameMap.get(containerList.get(0));
            if (this.domainName != null) {
                String dn = UserHandler.getUserDN((String)this.domainName, (String)sidStr, (Long)this.loginId);
                String schedulerDomains = this.getSchedulerDomains(containerList, dnDomainNameMap);
                this.desc = MessageFormat.format(this.rb.getString("admp.reports.user_reports.groups_for_user.reportdesc_grps_for_user"), dn, schedulerDomains);
                Hashtable<String, Object> inputs = new Hashtable<String, Object>();
                inputs.put("INPUT_NAME", sidStr);
                inputs.put("DISTINGUISHED_NAME", dn);
                inputs.put("REPORT_GENERATION_ID", this.generationId);
                Row row = dataObject.getRow(inputTableName, new Criteria(Column.getColumn((String)inputTableName, (String)"SID_STRING"), (Object)sidStr, 0));
                if (row == null) {
                    inputs.put("INPUT_ID", 1L);
                } else {
                    inputs.put("INPUT_ID", row.get("UNIQUE_VALUE_MAPPING"));
                }
                ArrayList<Hashtable<String, Object>> inputList = new ArrayList<Hashtable<String, Object>>();
                inputList.add(inputs);
                HashMap<String, ArrayList<Hashtable<String, Object>>> reportInputParams = new HashMap<String, ArrayList<Hashtable<String, Object>>>();
                reportInputParams.put("trusteesList", inputList);
                Action action = new Action(1L, this.domainName, reportInputParams, this.getAttributeList(), this, dn, this.isSyncEnabled());
                action.start();
                while (!this.isCompleted) {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                ReportHandler.updateReportGenerationDetails((Long)this.generationId, (int)1, (String)this.desc, (Long)this.loginId);
            } else {
                System.out.println("Error - Selected OU has been moved in Ad manually");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public class Action
    extends Thread {
        private Map inputParams = null;
        private String domainName = null;
        private ArrayList attributeList = null;
        private NativeListener listener = null;
        private Long loginId = null;
        private String distinguishedName = null;
        private boolean isSyncEnabled = false;

        public Action(Long loginId, String domainName, Map inputParams, ArrayList attributeList, NativeListener li, String distinguishedName, boolean isSyncEnabled) {
            this.domainName = domainName;
            this.loginId = loginId;
            this.attributeList = attributeList;
            this.listener = li;
            this.inputParams = inputParams;
            this.distinguishedName = distinguishedName;
            this.isSyncEnabled = isSyncEnabled;
        }

        @Override
        public void run() {
            GroupsForUsersListener.this.errorMessage = null;
            GroupsForUsersListener.this.resultUseTempFlag = true;
            if (!GroupsForUsersListener.this.errorList.isEmpty()) {
                GroupsForUsersListener.this.errorList = new Hashtable();
            }
            ArrayList inputsList = (ArrayList)this.inputParams.get("trusteesList");
            Hashtable tableProps = GroupsForUsersListener.this.getQueueProps();
            String key = "";
            Hashtable<String, String> domainKey = new Hashtable<String, String>();
            if (this.isSyncEnabled) {
                this.attributeList = ADSyncUtil.getNonSyncAttributes((ArrayList)this.attributeList);
                key = DomainHandler.doReportSync((String)this.domainName, (Long)CommonUtil.ADMIN_LOGIN_ID, (String[])new String[]{"user", "group", "computer", "contact", "groupMember", "primaryGroup"});
                domainKey.put(key, this.domainName);
            }
            ArrayList objectIds = GroupsForUsersListener.this.getObjIdList();
            GroupsForUsersListener.this.queueRegID = QueueHandler.getInstance().registerForUpdate(objectIds, GroupsForUsersListener.this.getTableColumns());
            GroupsForUsersListener.this.resultRegID = ResultDataHandler.getInstance().getProcessor().registerForUpdate(GroupsForUsersListener.this.resultTableName);
            for (int i = 0; i < inputsList.size(); ++i) {
                Hashtable<String, String> errors;
                Hashtable inputValues = (Hashtable)inputsList.get(i);
                try {
                    GroupsForUsersListener.this.setDomainName(this.domainName);
                    if (GroupsForUsersListener.this.statusController != null) {
                        GroupsForUsersListener.this.statusController.setTaskObject((Object)((String)inputValues.get("INPUT_NAME")));
                    }
                    tableProps.put("inputId", (Long)inputValues.get("INPUT_ID"));
                    GroupsForUsersListener.this.addlResultIps.put("INPUT_ID", (Long)inputValues.get("INPUT_ID"));
                    GroupsForUsersListener.this.doAction(this.domainName, this.loginId, this.distinguishedName, (String)inputValues.get("DISTINGUISHED_NAME"), this.attributeList, this.listener);
                    GroupsForUsersListener.this.updateQueue();
                    continue;
                }
                catch (LocalizedException e) {
                    e.printStackTrace();
                    GroupsForUsersListener.this.errorMessage = e.getMessage(GroupsForUsersListener.this.rb);
                    errors = new Hashtable();
                    errors.put("INPUT_NAME", (String)inputValues.get("INPUT_NAME"));
                    errors.put("ERROR_MESSAGE", GroupsForUsersListener.this.errorMessage);
                    GroupsForUsersListener.this.errorList.put(inputValues.get("INPUT_ID").toString(), errors);
                    GroupsForUsersListener.this.updateErrorStatus(errors);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    GroupsForUsersListener.this.errorMessage = e.getMessage();
                    errors = new Hashtable<String, String>();
                    errors.put("INPUT_NAME", (String)inputValues.get("INPUT_NAME"));
                    errors.put("ERROR_MESSAGE", GroupsForUsersListener.this.errorMessage);
                    GroupsForUsersListener.this.errorList.put(inputValues.get("INPUT_ID").toString(), errors);
                    GroupsForUsersListener.this.updateErrorStatus(errors);
                }
            }
            GroupsForUsersListener.this.updatedCount = 0;
            GroupsForUsersListener.this.totalCount = 0;
            if (!domainKey.isEmpty()) {
                String syncStatus = DomainProcess.getInstance().getProcessStatus(domainKey);
                while (GroupsForUsersListener.this.continueAction && syncStatus.equalsIgnoreCase("false")) {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    syncStatus = DomainProcess.getInstance().getProcessStatus(domainKey);
                }
            }
            GroupsForUsersListener.this.completedAction();
        }
    }
}

