/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.reports;

import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.helpdesk.ADMPAuthObject;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.reports.StatusUpdater;
import com.adventnet.sym.adsm.common.server.util.DomainUtil;
import com.adventnet.sym.adsm.common.webclient.reports.InActiveListener;
import com.adventnet.sym.adsm.common.webclient.reports.ListenerUtil;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.util.ClientAuthorizationUtil;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import com.adventnet.sym.adsm.security.server.util.DateTimeUtil;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class InActiveComputersListener
extends InActiveListener {
    @Override
    public Long getCategoryId() {
        Long categoryId = new Long(1025L);
        return categoryId;
    }

    @Override
    public String getSearchString(String filterString) {
        return filterString;
    }

    @Override
    public ArrayList getDBCustomizedValues(String columnName, String ldapName, Properties prop) {
        ArrayList<Object> ret = super.getDBCustomizedValues(columnName, ldapName, prop);
        String guid = this.getGuid(prop);
        ArrayList values = (ArrayList)prop.get("lastLogon");
        String dc = this.dcName;
        if (columnName.equalsIgnoreCase("DOMAIN_CONTROLLER_NAME") || columnName.equalsIgnoreCase("LAST_LOGON_TIME") || columnName.equalsIgnoreCase("LAST_LOGON_TIMESTAMP")) {
            Hashtable llvals = (Hashtable)this.dbLLVals.get(guid);
            Long l = new Long(0L);
            try {
                Long llval;
                try {
                    l = Long.parseLong((String)values.get(0));
                }
                catch (NullPointerException e) {
                    l = new Long(0L);
                }
                ret = new ArrayList<Object>();
                if (llvals != null && (llval = (Long)llvals.get("LAST_LOGON_TIME")) < l) {
                    llval = l;
                    dc = (String)llvals.get("DOMAIN_CONTROLLER_NAME");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                l = new Long(0L);
            }
            if (columnName.equalsIgnoreCase("DOMAIN_CONTROLLER_NAME")) {
                ret.add(dc);
            } else {
                ret.add(l);
            }
        }
        return ret;
    }

    @Override
    public void updateUI(Properties uiValues, String objectClass, String guid, String str) {
        if (!this.multiDC) {
            if (this.statusController != null) {
                this.statusController.updateStatus(uiValues, objectClass, guid);
            }
            ++this.updatedCount;
            if (this.out != null) {
                this.updateOutList();
                if (this.updatedCount <= 25) {
                    this.out.write("<script>if(this.load) updateUI(" + str + ")</script>");
                }
                this.out.write("<script>updateCount(" + this.updatedCount + ")</script>");
                this.out.flush();
            } else {
                this.updateList.add("<script>updateUI(" + str + ")</script>");
            }
        } else {
            super.updateUI(uiValues, objectClass, guid, str);
        }
    }

    public InActiveComputersListener() {
        this.lastLogonTableName = "ADSMComputerGeneralDetails";
        this.dcVsGuidList = new Hashtable();
        this.notToBeUpdatedList = new Hashtable();
        this.notToBeUpdatedList.put("DOMAIN_CONTROLLER_NAME", "");
        this.mgmtIds[0] = 3020;
        this.mgmtIds[1] = 3018;
        this.mgmtIds[2] = 3016;
        this.mgmtIds[3] = 3032;
        this.mgmtIds[4] = 3017;
        this.noOfObjects = "unlimited";
        this.multiDC = true;
    }

    @Override
    public void getDescription(Object[] args) {
        this.desc = MessageFormat.format(this.rb.getString("admp.reports.comp_reports.inactive_comps.reportdesc_comp_inactive_since_days_of_the_domains"), args);
    }

    @Override
    public void getDescription(Object[] args, String dataLableText) {
        ArrayList<Object> objectList = new ArrayList<Object>(Arrays.asList(args));
        String daysInterval = "";
        try {
            SimpleDateFormat formatter1 = new SimpleDateFormat("dd-MMM-yyyy", Locale.US);
            SimpleDateFormat formatter2 = new SimpleDateFormat("MM/dd/yyyy", Locale.US);
            String startVal = (String)objectList.get(0);
            String endVal = (String)objectList.get(1);
            if (dataLableText.equalsIgnoreCase("admp.common.matching_criteria.last_N_days")) {
                daysInterval = Integer.toString(DateTimeUtil.daysBetween((Date)formatter1.parse(startVal), (Date)formatter1.parse(endVal)));
            }
            objectList.add(daysInterval);
            Date date = formatter1.parse(startVal);
            Date date1 = formatter1.parse(endVal);
            objectList.set(0, formatter2.format(date));
            objectList.set(1, formatter2.format(date1));
            args = objectList.toArray();
            this.setDescription(args, dataLableText);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setDescription(Object[] args, String dataLableText) {
        this.desc = dataLableText.equalsIgnoreCase("admp.common.matching_criteria.last_N_days") ? MessageFormat.format(this.rb.getString("admp.reports.computer_reports.inactive_computer.reportdesc_last_N_days"), args) : MessageFormat.format(this.rb.getString("admp.reports.computer_reports.inactive_computer.reportdesc_since_days"), args);
    }

    @Override
    public void doAction(Properties domainDetails, String distinguishedName, String dc, ArrayList attributeList, NativeListener listener, String filterString) throws Exception {
        ADHandler.getInActiveComputers((Properties)domainDetails, (String)distinguishedName, (String)dc, (ArrayList)attributeList, (NativeListener)listener, (String)filterString);
    }

    @Override
    public void doAction(String domainName, Long loginId, String distinguishedName, ArrayList attributeList, NativeListener listener, String filterString) throws Exception {
        ADHandler.getInActiveComputers((String)domainName, (Long)loginId, (String)distinguishedName, (ArrayList)attributeList, (NativeListener)listener, (String)filterString);
    }

    @Override
    public Long generateReportForAPI(Long loginId, ADMPAuthObject authObject, Integer reportId, String domain, Hashtable<String, String> requestParams) {
        try {
            String domainName = DomainUtil.getDomainName((String)domain);
            Hashtable domains = authObject.getDomainAndOUs();
            Hashtable dnDomainNameMap = (Hashtable)domains.get("dnDomainNameMap");
            ArrayList attributeList = this.getAttributeList();
            this.checkAttributeList(attributeList);
            ArrayList<String> containerList = new ArrayList<String>();
            ArrayList ous = ClientAuthorizationUtil.getAuthorizedOUList(authObject, domainName);
            if (ous != null && ous.size() > 0) {
                containerList.addAll(ous);
            } else {
                containerList.add(domain);
            }
            Hashtable reportDomains = this.getReportDomains(loginId, containerList, dnDomainNameMap);
            String startDateVal = requestParams.get("START_DATE");
            String endDateVal = requestParams.get("END_DATE");
            String dataLableText = requestParams.get("DATA_LABEL_TEXT");
            String filterString = "";
            String ldapcriteria = "lastlogontime";
            if (requestParams.get("ldapCriteria") != null && requestParams.get("ldapCriteria").equalsIgnoreCase("pwdlastset")) {
                filterString = this.getFilterStringForPwdSet(startDateVal, endDateVal, dataLableText);
                this.multiDC = false;
                ldapcriteria = "pwdlastset";
            }
            if (ldapcriteria.equalsIgnoreCase("lastlogontime")) {
                filterString = this.getFilterString(startDateVal, endDateVal, dataLableText);
            }
            this.statusController.init(reportDomains);
            this.statusController.setProgressTask(StatusUpdater.TASKCODE.FETCHING_DETAILS_FROM_DCS.getValue());
            InActiveListener.Action action = new InActiveListener.Action(this, loginId, reportDomains, attributeList, filterString, this, dnDomainNameMap, this.multiDC, null, null);
            action.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.generationId;
    }

    @Override
    public void start(ArrayList attributeList, HttpServletRequest request, ReportBean bean) {
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        try {
            this.checkAttributeList(attributeList);
            HashMap<String, Object> inputParams = new HashMap<String, Object>();
            Hashtable reportDomains = this.getReportDomains(request, bean, loginId);
            inputParams.put("reportDomains", reportDomains);
            inputParams.put("multiDC", "true");
            Hashtable dnDomainNameMap = (Hashtable)bean.get("dnDomainNameMap");
            Hashtable domainVsExcludeChildOU = (Hashtable)bean.get("domainVsExcludeChildOU");
            String startDateVal = request.getParameter("startDate");
            String endDateVal = request.getParameter("endDate");
            String dataLableText = request.getParameter("dateLable");
            String filterString = "";
            String ldapcriteria = "lastlogontime";
            if (request.getParameter("ldapcriteria") != null && request.getParameter("ldapcriteria").equalsIgnoreCase("pwdlastset")) {
                filterString = this.getFilterStringForPwdSet(startDateVal, endDateVal, dataLableText);
                this.multiDC = false;
                inputParams.put("multiDC", "false");
                ldapcriteria = "pwdlastset";
            }
            if (ldapcriteria.equalsIgnoreCase("lastlogontime")) {
                filterString = this.getFilterString(startDateVal, endDateVal, dataLableText);
            }
            String[] domainList = request.getParameterValues("domains");
            inputParams.put("domain", ClientUtil.getString(domainList));
            String reportDomain = this.getReportDomains(domainList, dnDomainNameMap);
            this.getDescription(new Object[]{startDateVal, endDateVal, this.rb.getString(dataLableText), reportDomain}, dataLableText);
            Hashtable excludedOUList = (Hashtable)bean.get("excludedOUList");
            this.statusController.init(reportDomains);
            this.statusController.setProgressTask(StatusUpdater.TASKCODE.FETCHING_DETAILS_FROM_DCS.getValue());
            InActiveListener.Action action = new InActiveListener.Action(this, loginId, reportDomains, attributeList, filterString, this, dnDomainNameMap, this.multiDC, excludedOUList, domainVsExcludeChildOU);
            action.start();
            bean.set("inputParams", inputParams);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getFilterString(String startDateVal, String endDateVal, String dataLableText) {
        String filterString = "";
        HashMap datesValueMap = this.getDateInterval(startDateVal, endDateVal, dataLableText);
        long startDate = (Long)datesValueMap.get("startDate");
        long endDate = (Long)datesValueMap.get("endDate");
        filterString = "(&(objectClass=computer)(objectCategory=computer)(&(|(!lastlogon=*)(lastlogon<=" + startDate + "))(|(!lastlogontimestamp=*)(lastlogontimestamp<=" + startDate + "))))";
        return filterString;
    }

    @Override
    public String getFilterStringForPwdSet(String startDateVal, String endDateVal, String dataLableText) {
        String filterString = "";
        HashMap datesValueMap = this.getDateIntervalForPwdSet(startDateVal, endDateVal, dataLableText);
        long startDate = (Long)datesValueMap.get("startDate");
        long endDate = (Long)datesValueMap.get("endDate");
        filterString = "(&(objectCategory=computer)(objectClass=computer)(pwdLastSet<=" + startDate + "))";
        return filterString;
    }

    public HashMap getDateInterval(String startDateVal, String endDateVal, String dataLableText) {
        HashMap<String, Long> datesValueMap = new HashMap<String, Long>();
        long startDate = 0L;
        long endDate = 0L;
        try {
            SimpleDateFormat formatter1 = new SimpleDateFormat("dd-MMM-yyyy", Locale.US);
            Date days = formatter1.parse(startDateVal);
            startDate = DateTimeUtil.getFileTime((Long)days.getTime());
            days = formatter1.parse(endDateVal);
            endDate = DateTimeUtil.getFileTime((Long)days.getTime());
            days = formatter1.parse(endDateVal);
            Calendar endoftheDay = Calendar.getInstance();
            endoftheDay.setTime(days);
            endoftheDay.set(endoftheDay.get(1), endoftheDay.get(2), endoftheDay.get(5), 23, 59, 59);
            endoftheDay.set(14, 0);
            endDate = DateTimeUtil.getFileTime((Long)endoftheDay.getTimeInMillis());
            if (dataLableText.equalsIgnoreCase("admp.common.matching_criteria.last_N_days")) {
                int lastNDays = DateTimeUtil.daysBetween((Date)formatter1.parse(startDateVal), (Date)formatter1.parse(endDateVal));
                long l = (long)(lastNDays * 24 * 60 * 60) * 1000L;
                startDate = DateTimeUtil.getFileTime((Long)(System.currentTimeMillis() - l));
                endDate = DateTimeUtil.getFileTime((Long)System.currentTimeMillis());
            }
            datesValueMap.put("startDate", startDate);
            datesValueMap.put("endDate", endDate);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return datesValueMap;
    }

    public HashMap getDateIntervalForPwdSet(String startDateVal, String endDateVal, String dataLableText) {
        HashMap<String, Long> datesValueMap = new HashMap<String, Long>();
        long startDate = 0L;
        long endDate = 0L;
        try {
            SimpleDateFormat formatter1 = new SimpleDateFormat("dd-MMM-yyyy", Locale.US);
            int daysInterval = DateTimeUtil.daysBetween((Date)formatter1.parse(startDateVal), (Date)Calendar.getInstance().getTime());
            long l = (long)((daysInterval += 30) * 24 * 60 * 60) * 1000L;
            startDate = DateTimeUtil.getFileTime((Long)(System.currentTimeMillis() - l));
            endDate = DateTimeUtil.getFileTime((Long)System.currentTimeMillis());
            datesValueMap.put("startDate", startDate);
            datesValueMap.put("endDate", endDate);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return datesValueMap;
    }

    public static void updateCount(Hashtable dcVsGuidAndBadPwdCount, String columnName, String tableName) {
    }

    @Override
    public void setDashboardInputParams(Long dashboardReportMapping, HttpServletRequest request, ReportBean bean) {
        ListenerUtil.setDashboardInputParams(dashboardReportMapping, request, bean, 1);
    }
}

