/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.reports;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.AdmpInput;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.automation.ReportFilterConfig;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.multidc.MultiDCHandler;
import com.adventnet.sym.adsm.common.server.queue.QueueHandler;
import com.adventnet.sym.adsm.common.server.reports.AdvReportsListener;
import com.adventnet.sym.adsm.common.server.reports.ReportHandler;
import com.adventnet.sym.adsm.common.server.resultdata.ResultDataHandler;
import com.adventnet.sym.adsm.common.server.resultdata.ResultDataUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.LicenseMgr;
import com.adventnet.sym.adsm.common.webclient.reports.AbstractListener;
import com.adventnet.sym.adsm.common.webclient.reports.ListenerUtil;
import com.adventnet.sym.adsm.common.webclient.reports.MultiDCListener;
import com.adventnet.sym.adsm.common.webclient.reports.ReportDomain;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class InActiveListener
extends MultiDCListener {
    protected String lastLogonTableName = null;
    protected Hashtable dcVsGuidList = null;
    protected Hashtable notToBeUpdatedList = null;
    protected Hashtable dbLLVals = null;
    protected Hashtable O365DomainDetails = null;

    public InActiveListener() {
        this.multiDC = true;
    }

    @Override
    public void init(Row r) {
        this.baseTableName = (String)r.get("BASE_TABLE_NAME");
        this.resultTableName = (String)r.get("RESULT_TABLE_NAME");
        this.reportId = (Integer)r.get("REPORT_ID");
        this.onClickText = (String)r.get("ONCLICK_TEXT");
        this.title = (String)r.get("REPORT_NAME");
        if (this.rb == null) {
            this.rb = ResourceBundleMgr.getInstance().getBundle();
        }
        this.title = this.rb.getString(this.title);
    }

    @Override
    public void init(HttpServletRequest request, Row r) {
        HttpSession session = request.getSession();
        Locale locale = request.getLocale();
        this.rb = ResourceBundleMgr.getInstance().getBundle(locale);
        this.baseTableName = (String)r.get("BASE_TABLE_NAME");
        this.resultTableName = (String)r.get("RESULT_TABLE_NAME");
        this.reportId = (Integer)r.get("REPORT_ID");
        this.onClickText = (String)r.get("ONCLICK_TEXT");
        this.title = (String)r.get("REPORT_NAME");
        this.setGenerationId(request);
    }

    @Override
    public Hashtable getQueueProps() {
        Hashtable<String, Object> tableProps = new Hashtable<String, Object>();
        tableProps.put("baseTableName", this.baseTableName);
        tableProps.put("resultTableName", this.resultTableName);
        tableProps.put("generationId", this.generationId);
        tableProps.put("resultHandling", "no-update");
        return tableProps;
    }

    @Override
    protected void checkAttributeList(ArrayList attributeList) {
    }

    @Override
    public void doAction(String domainName, Long loginId, String distinguishedName, ArrayList attributeList, NativeListener listener) throws Exception {
    }

    public void doAction(Properties domainDetails, String distinguishedName, String dc, ArrayList attributeList, NativeListener listener, String filterString) throws Exception {
    }

    public void doAction(String domainName, Long loginId, String distinguishedName, ArrayList attributeList, NativeListener listener, String filterString) throws Exception {
    }

    public String getSearchString(String filterString) {
        return "";
    }

    public String getFilterString(String startDateVal, String endDateVal, String dataLableText) {
        return "";
    }

    public String getFilterStringForPwdSet(String startDateVal, String endDateVal, String dataLableText) {
        return "";
    }

    public void getDescription(Object[] args, String dataLableText) {
        this.desc = "";
    }

    private Hashtable getGuidVsLLVals(String containerName) {
        Hashtable ret = new Hashtable();
        try {
            if (!this.multiDC) {
                Criteria crit = new Criteria(Column.getColumn((String)"ADSMComputerGeneralDetails", (String)"DISTINGUISHED_NAME"), (Object)containerName, 11);
                SelectQueryImpl sq = new SelectQueryImpl(new Table("ADSMComputerGeneralDetails"));
                sq.setCriteria(crit);
                sq.addSelectColumn(Column.getColumn((String)"ADSMComputerGeneralDetails", (String)"OBJECT_GUID"));
                sq.addSelectColumn(Column.getColumn((String)"ADSMComputerGeneralDetails", (String)"LAST_LOGON_TIME"));
                sq.addSelectColumn(Column.getColumn((String)"ADSMComputerGeneralDetails", (String)"DOMAIN_CONTROLLER_NAME"));
                DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)sq);
                Iterator it = dataObj.getRows("ADSMComputerGeneralDetails");
                while (it.hasNext()) {
                    Row r = (Row)it.next();
                    Hashtable<String, Object> h = new Hashtable<String, Object>();
                    String dc = (String)r.get("DOMAIN_CONTROLLER_NAME");
                    if (dc == null || dc == "") continue;
                    h.put("LAST_LOGON_TIME", r.get("LAST_LOGON_TIME"));
                    h.put("DOMAIN_CONTROLLER_NAME", dc);
                    ret.put(r.get("OBJECT_GUID"), h);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return ret;
    }

    @Override
    public void stop(HttpServletRequest request) {
        if (!this.continueAction) {
            System.out.println("Already stop initialized. Second stop call");
            return;
        }
        this.continueAction = false;
        if (this.multiDC) {
            MultiDCHandler.getInstance().stop(this.queueRegID);
        }
        super.stop(request);
    }

    @Override
    public void executeTask(ArrayList containerList, Hashtable dnDomainNameMap, ReportFilterConfig reportFilterConfig) {
        this.executeTask(containerList, dnDomainNameMap, null, null, reportFilterConfig);
    }

    @Override
    public void executeTask(ArrayList containerList, Hashtable dnDomainNameMap, Hashtable excludedOUList, Hashtable domainVsExcludeChildOU, ReportFilterConfig reportFilterConfig) {
        try {
            reportLogger.log(Level.INFO, "Execute Task Started ");
            this.isCompleted = false;
            this.multiDC = true;
            long value = 2592000000L;
            String ldapFilter = "lastlogontime";
            Long reportDays = 0L;
            for (AdmpInput admpInput : reportFilterConfig.getInputList()) {
                if (admpInput.getIsMultiple().booleanValue()) continue;
                if (admpInput.getName().equalsIgnoreCase("VAL") || admpInput.getName().equalsIgnoreCase("VALUE")) {
                    ListenerUtil.updateReportDaysForRegenerateReport(reportFilterConfig, admpInput, false);
                    reportDays = Long.valueOf(admpInput.getValue());
                    value = reportDays * 24L * 60L * 60L * 1000L;
                }
                if (!admpInput.getName().equalsIgnoreCase("filter")) continue;
                ldapFilter = admpInput.getValue();
            }
            HashMap dateValues = this.getScheduleDates(value);
            String startDateVal = (String)dateValues.get("startDate");
            String endDateVal = (String)dateValues.get("endDate");
            String filterString = "";
            if (ldapFilter.equalsIgnoreCase("lastlogontime")) {
                filterString = this.getFilterString(startDateVal, endDateVal, "admp.common.matching_criteria.last_N_days");
            } else if (ldapFilter.equalsIgnoreCase("pwdlastset")) {
                filterString = this.getFilterStringForPwdSet(startDateVal, endDateVal, "admp.common.matching_criteria.last_N_days");
            }
            String schedulerDomains = this.getSchedulerDomains(containerList, dnDomainNameMap);
            if (reportDays != 0L) {
                this.getDescription(new Object[]{startDateVal, endDateVal, this.rb.getString("admp.common.matching_criteria.last_N_days"), schedulerDomains}, "admp.common.matching_criteria.last_N_days");
            } else {
                this.getDescription(new Object[]{schedulerDomains});
            }
            this.generationId = ReportHandler.addReportGenerationDetails((Integer)this.reportId, (String)this.desc, (Long)this.loginId);
            Hashtable reportDomains1 = this.getReportDomains(1L, containerList, dnDomainNameMap);
            Hashtable reportDomains = this.getReportDomains(containerList, dnDomainNameMap, excludedOUList, domainVsExcludeChildOU);
            Action action = new Action(CommonUtil.ADMIN_LOGIN_ID, reportDomains, this.getAttributeList(), filterString, this, dnDomainNameMap, this.multiDC, excludedOUList, domainVsExcludeChildOU);
            action.start();
            while (!this.isCompleted) {
                try {
                    Thread.sleep(200L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ReportHandler.updateReportGenerationDetails((Long)this.generationId, (int)1, (String)this.desc, (Long)this.loginId);
            reportLogger.log(Level.INFO, "Execute Task Completed");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public HashMap getScheduleDates(long time) {
        HashMap<String, String> datesMap = new HashMap<String, String>();
        SimpleDateFormat formatter1 = new SimpleDateFormat("dd-MMM-yyyy", Locale.US);
        Date days = new Date(System.currentTimeMillis() - time);
        String startDateVal = formatter1.format(days);
        days = new Date(System.currentTimeMillis());
        String endDateVal = formatter1.format(days);
        datesMap.put("startDate", startDateVal);
        datesMap.put("endDate", endDateVal);
        return datesMap;
    }

    protected void updateResult() {
        try {
            boolean result = MultiDCHandler.getInstance().isCompleted(this.queueRegID);
            while (!result) {
                this.updateOtherDCCount();
                Thread.sleep(30L);
                result = MultiDCHandler.getInstance().isCompleted(this.queueRegID);
            }
            this.updateOtherDCStatus();
            this.updateDCErrorStatus();
            Hashtable mdcResultTable = MultiDCHandler.getInstance().getDCVsGuids(this.queueRegID.longValue());
            MultiDCHandler.getInstance().finishProcess(this.queueRegID);
            int totalObjectCountFromLicense = 0;
            String reportObjects = LicenseMgr.getInstance().getLicenseProperty("ADReports", "NumberOfObjects");
            if (reportObjects != null && !reportObjects.equalsIgnoreCase("unlimited")) {
                try {
                    totalObjectCountFromLicense = Integer.parseInt(reportObjects);
                    --totalObjectCountFromLicense;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            int resCount = 0;
            Integer resVal = 0;
            Enumeration e = mdcResultTable.keys();
            block5: while (e.hasMoreElements()) {
                String domain = (String)e.nextElement();
                Hashtable guidVsDCCount = (Hashtable)mdcResultTable.get(domain);
                Enumeration e1 = guidVsDCCount.keys();
                while (e1.hasMoreElements()) {
                    String guid = (String)e1.nextElement();
                    Integer guidDCCount = (Integer)guidVsDCCount.get(guid);
                    if (guidDCCount != 0) continue;
                    if (resCount > totalObjectCountFromLicense && totalObjectCountFromLicense != 0) continue block5;
                    ResultDataHandler.getInstance().getProcessor().updateData(this.resultRegID, ResultDataUtil.getDBString((String)this.resultTableName, (Long)this.generationId, (String)guid, (Hashtable)this.addlResultIps));
                    ++resCount;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected class Action
    extends Thread {
        private Hashtable reportDomains = null;
        private ArrayList attributeList = null;
        private String filterString = "";
        private NativeListener listener = null;
        private Hashtable dnDomainNameMap = null;
        private Long loginId = null;
        private Hashtable domainVsExcludeChildOU = null;
        private Hashtable excludedOUList = null;
        private ArrayList O365Domains = null;

        public Action(Long loginId, Hashtable hash, ArrayList attributeList, String filterString, NativeListener li, Hashtable map, boolean multiDC, Hashtable excludedOUList, Hashtable domainVsExcludeChildOU) {
            this.loginId = loginId;
            this.reportDomains = hash;
            this.attributeList = attributeList;
            this.filterString = filterString;
            this.listener = li;
            this.dnDomainNameMap = map;
            this.O365Domains = new ArrayList();
            this.excludedOUList = excludedOUList;
            this.domainVsExcludeChildOU = domainVsExcludeChildOU;
        }

        @Override
        public void run() {
            InActiveListener.this.errorMessage = null;
            InActiveListener.this.updateResult = false;
            InActiveListener.this.guidList = new ArrayList();
            Hashtable tableProps = InActiveListener.this.getQueueProps();
            ArrayList multiDCAttributes = InActiveListener.this.getMultiDCAttributes();
            ArrayList objectIds = InActiveListener.this.getObjIdList();
            InActiveListener.this.queueRegID = QueueHandler.getInstance().registerForUpdate(objectIds, InActiveListener.this.getTableColumns());
            InActiveListener.this.resultRegID = ResultDataHandler.getInstance().getProcessor().registerForUpdate(InActiveListener.this.resultTableName);
            ArrayList list = new ArrayList();
            Hashtable IAMAppsDetails = new Hashtable();
            Hashtable<String, ArrayList> domainprops = new Hashtable<String, ArrayList>();
            if (this.reportDomains.isEmpty()) {
                InActiveListener.this.domainName = null;
            }
            Enumeration e = this.reportDomains.keys();
            while (e.hasMoreElements()) {
                InActiveListener.this.domainName = (String)e.nextElement();
                ReportDomain reportDomain = (ReportDomain)this.reportDomains.get(InActiveListener.this.domainName);
                if (reportDomain.getIAMAppId() == 3) {
                    ArrayList<Properties> O365Domains = (ArrayList<Properties>)IAMAppsDetails.get(3);
                    if (O365Domains == null) {
                        O365Domains = new ArrayList<Properties>();
                        IAMAppsDetails.put(3, O365Domains);
                    }
                    Properties domainProps = new Properties();
                    Hashtable O365DomainProps = (Hashtable)InActiveListener.this.O365DomainDetails.get(InActiveListener.this.domainName);
                    domainProps.put("INACTIVE_DAYS", O365DomainProps.get("INACTIVE_DAYS"));
                    domainProps.put("WAAD_DOMAIN_PROPS", O365DomainProps.get("WAAD_DOMAIN_PROPS"));
                    AdvReportsListener advReportsListener = (AdvReportsListener)O365DomainProps.get("ADVANCED_REPORTS_LISTENER");
                    advReportsListener.setQueueRegID(InActiveListener.this.queueRegID);
                    domainProps.put("ADVANCED_REPORTS_LISTENER", advReportsListener);
                    ArrayList O365InactiveUsersAttributeList = InActiveListener.this.getAttributeList(53);
                    O365InactiveUsersAttributeList.remove("objectSID");
                    O365InactiveUsersAttributeList.remove("objectGUID");
                    domainProps.put("ATTRIBUTE_LIST", O365InactiveUsersAttributeList);
                    domainProps.put("WAAD_TENANT_ID", reportDomain.getDomainName());
                    O365Domains.add(domainProps);
                    this.reportDomains.remove(InActiveListener.this.domainName);
                    continue;
                }
                ArrayList containerList = reportDomain.getContainerList();
                list.addAll(containerList);
                ArrayList dclist = reportDomain.getDCList();
                domainprops.put(InActiveListener.this.domainName, dclist);
            }
            Hashtable excludeContainerHash = InActiveListener.this.constructExcludeContainerHash(list, this.domainVsExcludeChildOU, this.excludedOUList, this.dnDomainNameMap);
            if (multiDCAttributes.size() > 0 && InActiveListener.this.multiDC) {
                MultiDCHandler.getInstance().execute(InActiveListener.this.queueRegID, this.loginId, list, this.dnDomainNameMap, multiDCAttributes, InActiveListener.this.getSearchString(this.filterString), InActiveListener.this.objClass.getId(), excludeContainerHash, IAMAppsDetails);
            }
            Enumeration e2 = this.reportDomains.keys();
            block6: while (e2.hasMoreElements()) {
                try {
                    InActiveListener.this.domainName = (String)e2.nextElement();
                    Properties domainDetails = HDTDomainHandler.getConfiguredValues((String)InActiveListener.this.domainName, (Long)this.loginId);
                    ReportDomain reportDomain = (ReportDomain)this.reportDomains.get(InActiveListener.this.domainName);
                    ArrayList containerList = reportDomain.getContainerList();
                    Hashtable domains = InActiveListener.this.getDomainContainers(containerList, this.dnDomainNameMap);
                    for (int i = 0; i < containerList.size(); ++i) {
                        String dn = (String)containerList.get(i);
                        ArrayList dcList = reportDomain.getDCList();
                        Hashtable<String, ArrayList> domainProps = new Hashtable<String, ArrayList>();
                        domainProps.put(InActiveListener.this.domainName, dcList);
                        boolean error = true;
                        String errStr = MessageFormat.format(InActiveListener.this.rb.getString("admp.reports.comp_reports.inactive_computers.errstr"), InActiveListener.this.domainName);
                        boolean addAllViewAttributes = true;
                        if (!InActiveListener.this.multiDC) {
                            InActiveListener.this.dbLLVals = InActiveListener.this.getGuidVsLLVals(dn);
                            InActiveListener.this.updateResult = true;
                        }
                        for (int j = 0; j < dcList.size(); ++j) {
                            Hashtable hash = (Hashtable)dcList.get(j);
                            Integer status = (Integer)hash.get("status");
                            InActiveListener.this.dcName = (String)hash.get("dcName");
                            InActiveListener.this.dcIndex = j;
                            if (status == 0) {
                                Hashtable<String, String> errors;
                                try {
                                    InActiveListener.this.updateStatus(InActiveListener.this.dcName);
                                    Boolean isExcludeChildOU = Boolean.FALSE;
                                    if (excludeContainerHash != null && excludeContainerHash.containsKey(dn)) {
                                        isExcludeChildOU = (Boolean)excludeContainerHash.get(dn);
                                    }
                                    this.listener.setIsExcludeChildOU(isExcludeChildOU);
                                    InActiveListener.this.toBeExecutedAttributeList = this.attributeList;
                                    if (InActiveListener.this.multiDC) {
                                        InActiveListener.this.doAction(domainDetails, dn, InActiveListener.this.dcName, InActiveListener.this.toBeExecutedAttributeList, this.listener, this.filterString);
                                    } else {
                                        InActiveListener.this.doAction(InActiveListener.this.domainName, this.loginId, dn, InActiveListener.this.toBeExecutedAttributeList, this.listener, this.filterString);
                                    }
                                    InActiveListener.this.updateCompletionStatus();
                                    error = false;
                                }
                                catch (LocalizedException exc) {
                                    exc.printStackTrace();
                                    errStr = InActiveListener.this.rb.getString("client.reports.InactiveComputersListener.error_while_getting_the_reports_from_the_domain") + " " + InActiveListener.this.domainName + ". " + exc.getMessage(InActiveListener.this.rb);
                                    errors = new Hashtable();
                                    errors.put("INPUT_NAME", InActiveListener.this.dcName);
                                    errors.put("ERROR_MESSAGE", errStr);
                                    InActiveListener.this.errorList.put(InActiveListener.this.dcName, errors);
                                    InActiveListener.this.updateErrorStatus(errors);
                                    InActiveListener.this.updateMultiDCStatus(InActiveListener.this.domainName, InActiveListener.this.dcName, "domain_error.jpg", null);
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                    errStr = InActiveListener.this.rb.getString("client.reports.InactiveComputersListener.error_while_getting_the_reports_from_the_domain") + " " + InActiveListener.this.domainName + ". " + ex.getMessage();
                                    errors = new Hashtable<String, String>();
                                    errors.put("INPUT_NAME", InActiveListener.this.dcName);
                                    errors.put("ERROR_MESSAGE", errStr);
                                    InActiveListener.this.errorList.put(InActiveListener.this.dcName, errors);
                                    InActiveListener.this.updateErrorStatus(errors);
                                    InActiveListener.this.updateMultiDCStatus(InActiveListener.this.domainName, InActiveListener.this.dcName, "domain_error.jpg", null);
                                }
                                status = new Integer(1);
                                InActiveListener.this.updatedCount = 0;
                            } else {
                                AbstractListener.reportLogger.log(Level.INFO, "DC  " + InActiveListener.this.dcName + " is not reachable ");
                            }
                            if (!error || error && !errStr.contains("8007203a")) break;
                        }
                        if (error) {
                            InActiveListener.this.errorMessage = errStr;
                            continue block6;
                        }
                        InActiveListener.this.updateQueue();
                    }
                }
                catch (Exception exp) {
                    exp.printStackTrace();
                }
            }
            if (InActiveListener.this.updateDetails && InActiveListener.this.multiDC && InActiveListener.this.domainName != null) {
                InActiveListener.this.updateResult();
            }
            InActiveListener.this.completedAction();
            if (InActiveListener.this.updateDetails) {
                // empty if block
            }
            InActiveListener.this.totalCount = 0;
        }
    }
}

