/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.reports;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.AdmpInput;
import com.adventnet.sym.adsm.common.server.automation.ReportFilterConfig;
import com.adventnet.sym.adsm.common.server.helpdesk.ADMPAuthObject;
import com.adventnet.sym.adsm.common.server.layout.component.FcOption;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.reports.ReportReqParams;
import com.adventnet.sym.adsm.common.server.reports.StatusUpdater;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DomainUtil;
import com.adventnet.sym.adsm.common.webclient.reports.InActiveListener;
import com.adventnet.sym.adsm.common.webclient.reports.ListenerUtil;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.util.ClientAuthorizationUtil;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import com.adventnet.sym.adsm.security.server.util.DateTimeUtil;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class InActiveUsersListener
extends InActiveListener {
    @Override
    public Long getCategoryId() {
        Long categoryId = new Long(1003L);
        return categoryId;
    }

    public InActiveUsersListener() {
        this.lastLogonTableName = "ADSMUserGeneralDetails";
        this.mgmtIds = new int[]{1004, 1144, 1143, 1023, 1006, 1145};
        this.cks = new String[]{"nevLogon", "disUsers"};
        this.multiDC = true;
    }

    @Override
    public String getSearchString(String filterString) {
        return filterString;
    }

    @Override
    public void getDescription(Object[] args, String dataLableText) {
        ArrayList<Object> objectList = new ArrayList<Object>(Arrays.asList(args));
        String daysInterval = "";
        try {
            SimpleDateFormat formatter1 = new SimpleDateFormat("dd-MMM-yyyy", Locale.US);
            SimpleDateFormat formatter2 = new SimpleDateFormat("MM/dd/yyyy", Locale.US);
            String startVal = (String)objectList.get(0);
            String endVal = (String)objectList.get(1);
            if (dataLableText.equalsIgnoreCase("admp.common.matching_criteria.last_N_days")) {
                daysInterval = Integer.toString(DateTimeUtil.daysBetween((Date)formatter1.parse(startVal), (Date)formatter1.parse(endVal)));
            }
            objectList.add(daysInterval);
            Date date = formatter1.parse(startVal);
            Date date1 = formatter1.parse(endVal);
            objectList.set(0, formatter2.format(date));
            objectList.set(1, formatter2.format(date1));
            args = objectList.toArray();
            this.setDescription(args, dataLableText);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setDescription(Object[] args, String dataLableText) {
        this.desc = dataLableText.equalsIgnoreCase("admp.common.matching_criteria.last_N_days") ? MessageFormat.format(this.rb.getString("admp.reports.user_reports.inactive_users.reportdesc_last_N_days"), args) : MessageFormat.format(this.rb.getString("admp.reports.user_reports.inactive_users.reportdesc_since_days"), args);
    }

    @Override
    public Criteria getReportFilterCriteria(Criteria crit, ReportReqParams reqParams, ArrayList tableNames) {
        boolean excludeNevLog = false;
        boolean excludeDisabled = false;
        try {
            AdmpInput admpInput = reqParams.getCvcFilters();
            if (admpInput != null && admpInput.getIsMultiple().booleanValue()) {
                for (FcOption fcOption : admpInput.getMultipleInput()) {
                    if (fcOption.getLabel().equalsIgnoreCase("excludedisabled")) {
                        excludeDisabled = Boolean.valueOf(fcOption.getValue());
                        continue;
                    }
                    if (!fcOption.getLabel().equalsIgnoreCase("excludeneverlogon")) continue;
                    excludeNevLog = Boolean.valueOf(fcOption.getValue());
                }
            }
            crit = this.getCriteria(excludeNevLog, excludeDisabled, crit, tableNames);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return crit;
    }

    @Override
    public Criteria getScheduledReportFilterCriteria(Criteria crit, ReportFilterConfig reportFilterConfig, ArrayList tableNames) {
        boolean excludeNevLog = false;
        boolean excludeDisabled = false;
        try {
            for (AdmpInput admpInput : reportFilterConfig.getInputList()) {
                if (admpInput.getIsMultiple().booleanValue()) continue;
                if (admpInput.getName().equalsIgnoreCase("excludedisabled")) {
                    excludeDisabled = Boolean.valueOf(admpInput.getValue());
                    continue;
                }
                if (!admpInput.getName().equalsIgnoreCase("excludeneverlogon")) continue;
                excludeNevLog = Boolean.valueOf(admpInput.getValue());
            }
            crit = this.getCriteria(excludeNevLog, excludeDisabled, crit, tableNames);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return crit;
    }

    public Criteria getCriteria(boolean excludeNevLog, boolean excludeDisabled, Criteria crit, ArrayList tableNames) {
        try {
            String tableName = "ADSMUserGeneralDetails";
            String columnName = "LAST_LOGON_TIME";
            if (excludeNevLog) {
                crit = crit == null ? new Criteria(new Column(tableName, columnName), (Object)"0", 1) : crit.and(new Criteria(new Column(tableName, columnName), (Object)"0", 1));
            }
            if (excludeDisabled) {
                columnName = "ACCOUNT_STATUS";
                crit = crit == null ? new Criteria(new Column(tableName, columnName), (Object)this.rb.getString("admp.reports.user.customized_column_values.Disabled"), 1) : crit.and(new Criteria(new Column(tableName, columnName), (Object)this.rb.getString("admp.reports.user.customized_column_values.Disabled"), 1));
            }
            if (!tableNames.contains(tableName)) {
                tableNames.add(tableName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return crit;
    }

    @Override
    protected void setClientButtons(boolean flag) {
        if (this.out != null) {
            this.out.write("<script> window.parent.disableFilters(" + flag + ") </script>");
            this.out.write("<script> setClientButtons(" + flag + ") </script>");
            this.out.flush();
        }
    }

    @Override
    public Long generateReportForAPI(Long loginId, ADMPAuthObject authObject, Integer reportId, String domain, Hashtable<String, String> requestParams) {
        try {
            String domainName = DomainUtil.getDomainName((String)domain);
            Hashtable domains = authObject.getDomainAndOUs();
            Hashtable dnDomainNameMap = (Hashtable)domains.get("dnDomainNameMap");
            ArrayList attributeList = this.getAttributeList();
            this.checkAttributeList(attributeList);
            ArrayList<String> containerList = new ArrayList<String>();
            ArrayList ous = ClientAuthorizationUtil.getAuthorizedOUList(authObject, domainName);
            if (ous != null && ous.size() > 0) {
                containerList.addAll(ous);
            } else {
                containerList.add(domain);
            }
            Hashtable reportDomains = this.getReportDomains(loginId, containerList, dnDomainNameMap);
            String startDateVal = requestParams.get("START_DATE");
            String endDateVal = requestParams.get("END_DATE");
            String dataLableText = requestParams.get("DATA_LABEL_TEXT");
            String filterString = this.getFilterString(startDateVal, endDateVal, dataLableText);
            this.statusController.init(reportDomains);
            this.statusController.setProgressTask(StatusUpdater.TASKCODE.FETCHING_DETAILS_FROM_DCS.getValue());
            InActiveListener.Action action = new InActiveListener.Action(loginId, reportDomains, attributeList, filterString, this, dnDomainNameMap, this.multiDC, null, null);
            action.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.generationId;
    }

    @Override
    public void start(ArrayList attributeList, HttpServletRequest request, ReportBean bean) {
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        try {
            this.checkAttributeList(attributeList);
            HashMap<String, Object> inputParams = new HashMap<String, Object>();
            Hashtable reportDomains = this.getReportDomains(request, bean, loginId);
            inputParams.put("reportDomains", reportDomains);
            inputParams.put("multiDC", "true");
            Hashtable dnDomainNameMap = (Hashtable)bean.get("dnDomainNameMap");
            Hashtable domainVsExcludeChildOU = (Hashtable)bean.get("domainVsExcludeChildOU");
            String startDateVal = request.getParameter("startDate");
            String endDateVal = request.getParameter("endDate");
            String dataLableText = request.getParameter("dateLable");
            String filterString = this.getFilterString(startDateVal, endDateVal, dataLableText);
            String[] domainList = request.getParameterValues("domains");
            inputParams.put("domain", ClientUtil.getString(domainList));
            String reportDomain = this.getReportDomains(domainList, dnDomainNameMap);
            this.getDescription(new Object[]{startDateVal, endDateVal, this.rb.getString(dataLableText), reportDomain}, dataLableText);
            Hashtable excludedOUList = (Hashtable)bean.get("excludedOUList");
            this.statusController.init(reportDomains);
            this.statusController.setProgressTask(StatusUpdater.TASKCODE.FETCHING_DETAILS_FROM_DCS.getValue());
            InActiveListener.Action action = new InActiveListener.Action(loginId, reportDomains, attributeList, filterString, this, dnDomainNameMap, this.multiDC, excludedOUList, domainVsExcludeChildOU);
            action.start();
            bean.set("inputParams", inputParams);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getFilterString(String startDateVal, String endDateVal, String dataLableText) {
        String filterString = "";
        HashMap datesValueMap = this.getDateInterval(startDateVal, endDateVal, dataLableText);
        long startDate = (Long)datesValueMap.get("startDate");
        long endDate = (Long)datesValueMap.get("endDate");
        filterString = "(&(objectClass=user)(objectCategory=person)(!(sAMAccountType=805306370))(&(|(!lastlogon=*)(lastlogon<=" + startDate + "))(|(!lastlogontimestamp=*)(lastlogontimestamp<=" + startDate + "))))";
        return filterString;
    }

    public HashMap getDateInterval(String startDateVal, String endDateVal, String dataLableText) {
        HashMap<String, Long> datesValueMap = new HashMap<String, Long>();
        long startDate = 0L;
        long endDate = 0L;
        try {
            SimpleDateFormat formatter1 = new SimpleDateFormat("dd-MMM-yyyy", Locale.US);
            Date days = formatter1.parse(startDateVal);
            startDate = DateTimeUtil.getFileTime((Long)days.getTime());
            days = formatter1.parse(endDateVal);
            endDate = DateTimeUtil.getFileTime((Long)days.getTime());
            days = formatter1.parse(endDateVal);
            Calendar endoftheDay = Calendar.getInstance();
            endoftheDay.setTime(days);
            endoftheDay.set(endoftheDay.get(1), endoftheDay.get(2), endoftheDay.get(5), 23, 59, 59);
            endoftheDay.set(14, 0);
            endDate = DateTimeUtil.getFileTime((Long)endoftheDay.getTimeInMillis());
            if (dataLableText.equalsIgnoreCase("admp.common.matching_criteria.last_N_days")) {
                int lastNDays = DateTimeUtil.daysBetween((Date)formatter1.parse(startDateVal), (Date)formatter1.parse(endDateVal));
                long l = (long)(lastNDays * 24 * 60 * 60) * 1000L;
                startDate = DateTimeUtil.getFileTime((Long)(System.currentTimeMillis() - l));
                endDate = DateTimeUtil.getFileTime((Long)System.currentTimeMillis());
            }
            datesValueMap.put("startDate", startDate);
            datesValueMap.put("endDate", endDate);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return datesValueMap;
    }

    @Override
    public void doAction(Properties domainDetails, String distinguishedName, String dcName, ArrayList attributeList, NativeListener listener, String filterString) throws Exception {
        ADHandler.getInActiveUsers((Properties)domainDetails, (String)distinguishedName, (String)dcName, (ArrayList)attributeList, (NativeListener)listener, (String)filterString);
    }

    @Override
    public void setDashboardInputParams(Long dashboardReportMapping, HttpServletRequest request, ReportBean bean) {
        try {
            ArrayList<String> resultFilterCheck = new ArrayList<String>();
            HashMap inputParams = (HashMap)bean.get("reportInputParams");
            Criteria crit = new Criteria(new Column("DashboardReportInputVals", "DASHBOARD_REPORT_MAPPING"), (Object)dashboardReportMapping, 0);
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("DashboardReportInputVals", crit);
            Iterator itr = dataObj.getRows("DashboardReportInputVals");
            while (itr.hasNext()) {
                Row row = (Row)itr.next();
                String prop = (String)row.get("PROPERTY");
                if (prop.equals("VALUE")) {
                    Long reportDays = Long.parseLong((String)row.get("VALUE"));
                    Long value = reportDays * 24L * 60L * 60L * 1000L;
                    SimpleDateFormat formatter1 = new SimpleDateFormat("dd-MMM-yyyy", Locale.US);
                    Date days = new Date(System.currentTimeMillis() - value);
                    String startDateVal = formatter1.format(days);
                    days = new Date(System.currentTimeMillis());
                    String endDateVal = formatter1.format(days);
                    inputParams.put("dateLable", ListenerUtil.getInputValueAsList("admp.common.matching_criteria.last_N_days"));
                    inputParams.put("startDate", ListenerUtil.getInputValueAsList(startDateVal));
                    inputParams.put("endDate", ListenerUtil.getInputValueAsList(endDateVal));
                    continue;
                }
                if (!"true".equals((String)row.get("VALUE"))) continue;
                resultFilterCheck.add(prop.toLowerCase());
            }
            if (resultFilterCheck.size() > 0) {
                inputParams.put("resultFilterCheck", resultFilterCheck);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

