/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.reports;

import com.adventnet.sym.adsm.common.server.delegation.DelegationUtil;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.usermanagement.UserPhotoMgmtUtil;
import com.adventnet.sym.adsm.common.server.util.ReportAttributesUtil;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import com.adventnet.sym.adsm.common.webclient.export.JasperDesignUtil;
import com.adventnet.sym.adsm.common.webclient.reports.JRFieldDesignUtil;
import com.adventnet.sym.adsm.common.webclient.reports.ReportExportUtil;
import com.adventnet.sym.adsm.common.webclient.reports.SummaryReportJRDataSource;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import com.adventnet.sym.adsm.security.server.util.DateTimeUtil;
import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRBox;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.base.JRBaseBox;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.design.JRDesignFrame;
import net.sf.jasperreports.engine.design.JRDesignImage;
import net.sf.jasperreports.engine.design.JRDesignReportFont;
import net.sf.jasperreports.engine.design.JRDesignSection;
import net.sf.jasperreports.engine.design.JRDesignStaticText;
import net.sf.jasperreports.engine.design.JRDesignSubreport;
import net.sf.jasperreports.engine.design.JRDesignTextField;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.type.SplitTypeEnum;
import net.sf.jasperreports.engine.type.StretchTypeEnum;
import net.sf.jasperreports.engine.util.JRSaver;
import net.sf.jasperreports.engine.xml.JRXmlLoader;

public class JRDesignUtil {
    public static int pageWidth = 595;
    public static int pageHeight = 842;
    public static int columnWidth = 535;
    public static int columnSpacing = 0;
    public static int leftMargin = 30;
    public static int rightMargin = 30;
    public static int topMargin = 20;
    public static int bottomMargin = 20;
    public static int normalSize = 9;
    public static int groupPad = 10;

    public static void fillBand(JasperDesign jasperDesign, JRDesignBand columnHeaderBand, JRDesignBand detailBand, ArrayList attributeList, String reportType, AdventNetResourceBundle rb, Long loginId, Locale locale) {
        JRDesignUtil.fillBand(null, jasperDesign, columnHeaderBand, detailBand, attributeList, reportType, null, 0, rb, loginId, locale);
    }

    public static void fillNoDataBand(JasperDesign jasperDesign, JRDesignBand detailBand, String reportType, AdventNetResourceBundle rb, Locale locale) {
        try {
            detailBand.setHeight(40);
            JRFont reportPDFFont = JRFieldDesignUtil.getDefaultReportFont();
            JRDesignReportFont columnFont = JRFieldDesignUtil.getJRDesignReportFont("Arial_normal", reportPDFFont, normalSize, true, false);
            JRDesignReportFont normalFont = JRFieldDesignUtil.getJRDesignReportFont("Arial_normal", reportPDFFont, normalSize, false, false);
            JRDesignReportFont pageFooterFont = JRFieldDesignUtil.getJRDesignReportFont("pagefooter_reportname", reportPDFFont, normalSize + 1, true, false);
            JRDesignStaticText txt = JRFieldDesignUtil.getJRDesignStaticText(50, 0, 200, 35, columnFont, new Color(255, 255, 255), new Color(0, 0, 0), (byte)1, (byte)2);
            txt.setMode((byte)1);
            txt.setStretchType((byte)1);
            txt.setPositionType((byte)2);
            txt.setKey("NoData");
            txt.setPrintRepeatedValues(true);
            txt.setRemoveLineWhenBlank(false);
            txt.setPrintInFirstWholeBand(false);
            txt.setPrintWhenDetailOverflows(false);
            JRBaseBox box = new JRBaseBox();
            box.setTopBorder((byte)5);
            box.setTopBorderColor(new Color(155, 166, 109));
            box.setBottomBorder((byte)1);
            box.setBottomBorderColor(new Color(155, 166, 109));
            box.setLeftPadding(1);
            detailBand.setSplitAllowed(true);
            txt.setBox((JRBox)box);
            txt.setBackcolor(new Color(239, 239, 231));
            txt.setForecolor(Color.BLACK);
            txt.setText(rb.getString("admp.reports.common.text.no_data_found"));
            detailBand.addElement((JRDesignElement)txt);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void fillBand(Hashtable columnWidths, JasperDesign jasperDesign, JRDesignBand columnHeaderBand, JRDesignBand detailBand, ArrayList attributeList, String reportType, String baseTable, int index, AdventNetResourceBundle rb, Long loginId, Locale locale) {
        JRDesignUtil.fillBand(columnWidths, jasperDesign, columnHeaderBand, detailBand, attributeList, reportType, baseTable, index, rb, loginId, false, locale);
    }

    public static JasperPrint fillSummarySubreport(JasperDesign jasperDesign, String basePath, Map inputParams, ArrayList<ArrayList<Hashtable>> subReportColumns, String reportName, String tempJRReportFileName, ArrayList summaryDataList, String reportType, Long loginId, AdventNetResourceBundle rb, Locale locale) {
        int x = 0;
        boolean showSerialNo = JRFieldDesignUtil.getShowSerialNo();
        boolean noOfpages = false;
        JasperPrint jasperPrint = null;
        String reportSummary = rb.getString("admp.reports.common.export.report_summary");
        try {
            jasperDesign.setName(reportSummary);
            JRFieldDesignUtil.setPDFFontForPageHeaderTitleBand(reportType, jasperDesign, locale);
            if (loginId == null) {
                loginId = DelegationUtil.ADMIN_LOGIN_ID;
            }
            if (reportType.toLowerCase().indexOf("csv") == -1) {
                JRFieldDesignUtil.addLogo(jasperDesign, reportType);
            }
            String reportFilePath = basePath + "jasperreports" + File.separator + "jrxml" + File.separator + "SubReportDesign.xml";
            for (int j = 0; j < summaryDataList.size(); ++j) {
                x = 0;
                JasperDesign subJasperDesign = JRXmlLoader.load((String)reportFilePath);
                JRDesignReportFont columnFont = null;
                JRDesignReportFont normalFont = null;
                JRDesignReportFont titleFont = null;
                JRDesignReportFont pageFooterFont = null;
                JRFont reportPDFFont = JRFieldDesignUtil.getReportFont(reportType, locale);
                columnFont = JRFieldDesignUtil.getJRDesignReportFont("Arial_normal", reportPDFFont, normalSize, true, false);
                normalFont = JRFieldDesignUtil.getJRDesignReportFont("Arial_normal", reportPDFFont, normalSize, false, false);
                titleFont = JRFieldDesignUtil.getJRDesignReportFont("Arial_Column", reportPDFFont, 12, true, false);
                pageFooterFont = JRFieldDesignUtil.getJRDesignReportFont("pagefooter_reportname", reportPDFFont, normalSize + 1, true, false);
                JRDesignBand columnHeaderBand = (JRDesignBand)subJasperDesign.getColumnHeader();
                JRDesignBand detailBand = (JRDesignBand)subJasperDesign.getDetail();
                if (j == 0) {
                    JRDesignBand titlebBand = (JRDesignBand)subJasperDesign.getTitle();
                    titlebBand.setHeight(30);
                    JRDesignStaticText staticText = JasperDesignUtil.getStaticText(0, 0, 150, 30, reportSummary);
                    staticText.setFont((JRFont)titleFont);
                    titlebBand.addElement((JRDesignElement)staticText);
                }
                int width = 200;
                columnHeaderBand.setHeight(60);
                detailBand.setHeight(30);
                if (showSerialNo) {
                    String displayName = rb.getString("admp.reports.common.export.Serial_no");
                    JRFieldDesignUtil.addFieldToJasper(subJasperDesign, columnHeaderBand, detailBand, columnFont, normalFont, x, 0, 50, 30, 60, displayName, "serialNo", rb, 1L, reportType, locale);
                    x = 50;
                }
                ArrayList<Hashtable> summaryCols = subReportColumns.get(j);
                for (int i = 0; i < summaryCols.size(); ++i) {
                    Hashtable columnTable = summaryCols.get(i);
                    JRFieldDesignUtil.addFieldToJasper(subJasperDesign, columnHeaderBand, detailBand, columnFont, normalFont, x, 0, width, 30, 60, (String)columnTable.get("columnName"), (String)columnTable.get("fieldName"), rb, loginId, reportType, locale);
                    x += width;
                }
                JRDesignField field = new JRDesignField();
                field.setName(reportName + j);
                field.setValueClass(JRDataSource.class);
                jasperDesign.addField((JRField)field);
                JRDesignSubreport subJasperReport = new JRDesignSubreport((JRDefaultStyleProvider)subJasperDesign);
                String jasperDir = System.getProperty("server.home") + File.separator + "webapps" + File.separator + "adsm" + File.separator + "jasperreports" + File.separator + "jasper";
                String des = jasperDir + File.separator + reportName + j + ".jasper";
                JRDesignExpression dsExp = new JRDesignExpression();
                dsExp.setValueClass(JRDataSource.class);
                dsExp.setText("$F{" + reportName + j + "}");
                JRDesignExpression exp = new JRDesignExpression();
                exp.setValueClass(String.class);
                des = des.replace("\\", "\\\\");
                exp.setText("\"" + des + "\"");
                subJasperReport.setDataSourceExpression((JRExpression)dsExp);
                subJasperReport.setExpression((JRExpression)exp);
                JasperCompileManager.compileReportToFile((JasperDesign)subJasperDesign, (String)des);
                JRDesignBand newBand = new JRDesignBand();
                newBand.setHeight(60);
                newBand.addElement((JRDesignElement)subJasperReport);
                ((JRDesignSection)jasperDesign.getDetailSection()).addBand((JRBand)newBand);
            }
            JasperReport jasperReport = JasperCompileManager.compileReport((JasperDesign)jasperDesign);
            SummaryReportJRDataSource dataSource = new SummaryReportJRDataSource(summaryDataList, ReportExportUtil.STARTING_SERIAL_NUMBER, showSerialNo);
            inputParams.put("AddToPgNumber", 0);
            jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, (Map)inputParams, (JRDataSource)dataSource);
            JRSaver.saveObject((Object)jasperPrint, (String)tempJRReportFileName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return jasperPrint;
    }

    public static void fillBand(Hashtable columnWidths, JasperDesign jasperDesign, JRDesignBand columnHeaderBand, JRDesignBand detailBand, ArrayList attributeList, String reportType, String baseTable, int index, AdventNetResourceBundle rb, Long loginId, boolean showSerialNo, Locale locale) {
        JRDesignUtil.fillBand(columnWidths, jasperDesign, columnHeaderBand, detailBand, attributeList, reportType, baseTable, index, rb, loginId, showSerialNo, false, locale);
    }

    public static void fillBand(Hashtable columnWidths, JasperDesign jasperDesign, JRDesignBand columnHeaderBand, JRDesignBand detailBand, ArrayList attributeList, String reportType, String baseTable, int index, AdventNetResourceBundle rb, Long loginId, boolean showSerialNo, boolean isWorkflow, Locale locale) {
        boolean isSplitAllowed = false;
        pageWidth = 595;
        pageHeight = 842;
        columnWidth = 535;
        columnSpacing = 0;
        leftMargin = 30;
        rightMargin = 30;
        topMargin = 20;
        bottomMargin = 20;
        int x = 0;
        boolean y = false;
        int width = columnWidth / attributeList.size();
        int height = 30;
        normalSize = 9;
        groupPad = 10;
        try {
            Properties attributeProp;
            int i;
            columnHeaderBand.setHeight(60);
            if (loginId == null) {
                loginId = DelegationUtil.ADMIN_LOGIN_ID;
            }
            JRDesignReportFont columnFont = null;
            JRDesignReportFont normalFont = null;
            JRDesignReportFont pageFooterFont = null;
            JRFont reportPDFFont = JRFieldDesignUtil.getReportFont(reportType, locale);
            columnFont = JRFieldDesignUtil.getJRDesignReportFont("Arial_normal", reportPDFFont, normalSize, true, false);
            normalFont = JRFieldDesignUtil.getJRDesignReportFont("Arial_normal", reportPDFFont, normalSize, false, false);
            pageFooterFont = JRFieldDesignUtil.getJRDesignReportFont("pagefooter_reportname", reportPDFFont, normalSize + 1, true, false);
            boolean enableDescription = JRFieldDesignUtil.getEnableDescription();
            if (reportType.toLowerCase().indexOf("csv") == -1 && enableDescription) {
                JRFieldDesignUtil.addLogo(jasperDesign, reportType);
                for (i = 0; i < attributeList.size(); ++i) {
                    attributeProp = (Properties)attributeList.get(i);
                    if (!attributeProp.getProperty("ATTRIB_COLUMN_NAME").equals("PHOTO_FILE")) continue;
                    height = 63;
                    break;
                }
            }
            detailBand.setHeight(height);
            if (showSerialNo) {
                columnWidth = 485;
                String displayName = rb.getString("admp.reports.common.export.Serial_no");
                JRFieldDesignUtil.addFieldToJasper(jasperDesign, columnHeaderBand, detailBand, columnFont, normalFont, x, 0, 50, height, 60, displayName, "serialNo", rb, loginId, reportType, locale);
                x = 50;
            }
            for (i = 0; i < attributeList.size(); ++i) {
                attributeProp = (Properties)attributeList.get(i);
                Integer columnName1 = (Integer)attributeProp.get("ATTRIB_ID");
                if (columnName1.equals(new Integer(11150))) continue;
                String displayName = null;
                if (reportType.toLowerCase().equals("csvde")) {
                    displayName = attributeProp.getProperty("ATTRIB_LDAP_NAME");
                } else {
                    displayName = attributeProp.getProperty("ATTRIB_DISP_NAME");
                    displayName = rb.getString(displayName);
                }
                String tableName = attributeProp.getProperty("TABLE_NAME");
                String columnName = attributeProp.getProperty("ATTRIB_COLUMN_NAME");
                if ((displayName.equals("lockoutTime") || displayName.equals("lastLogon") || displayName.equals("badPasswordTime") || displayName.equals("badPwdCount") || displayName.equals("lastLogoff") || displayName.equals("pwdLastSet")) && reportType.toLowerCase().equals("csvde") || attributeProp.getProperty("ATTRIB_COLUMN_NAME").equals("PHOTO_FILE") && reportType.toLowerCase().indexOf("csvde") != -1) continue;
                if (columnWidths != null && columnWidths.get(columnName1) != null) {
                    width = (Integer)columnWidths.get(columnName1);
                }
                Class<String> classType = String.class;
                JRDesignField field = new JRDesignField();
                field.setName(columnName1.toString());
                field.setValueClass(String.class);
                jasperDesign.addField((JRField)field);
                JRDesignStaticText txt = JRFieldDesignUtil.getJRDesignStaticText(x, 0, width, 60, columnFont, new Color(255, 255, 255), new Color(0, 0, 0), (byte)1, (byte)2);
                txt.setMode((byte)1);
                txt.setStretchType((byte)1);
                txt.setPositionType((byte)2);
                txt.setKey(columnName1.toString());
                txt.setPrintRepeatedValues(true);
                txt.setRemoveLineWhenBlank(false);
                txt.setPrintInFirstWholeBand(false);
                txt.setPrintWhenDetailOverflows(false);
                JRBaseBox box = new JRBaseBox();
                box.setTopBorder((byte)5);
                box.setTopBorderColor(new Color(155, 166, 109));
                box.setLeftBorder((byte)5);
                box.setLeftBorderColor(new Color(155, 166, 109));
                box.setRightBorder((byte)5);
                box.setRightBorderColor(new Color(155, 166, 109));
                box.setBottomBorder((byte)1);
                box.setBottomBorderColor(new Color(155, 166, 109));
                box.setLeftPadding(1);
                txt.setBox((JRBox)box);
                txt.setBackcolor(new Color(239, 239, 231));
                txt.setForecolor(Color.BLACK);
                txt.setText(displayName);
                if (reportType.toLowerCase().indexOf("xls") != -1 || reportType.toLowerCase().indexOf("csv") != -1) {
                    JRDesignExpression express = new JRDesignExpression();
                    express.setValueClass(Boolean.class);
                    express.setText("$V{PAGE_NUMBER}.intValue() == 1 ? Boolean.TRUE : Boolean.FALSE");
                    columnHeaderBand.setPrintWhenExpression((JRExpression)express);
                }
                if (reportType.toLowerCase().indexOf("csv") == -1 || index <= 0) {
                    columnHeaderBand.addElement((JRDesignElement)txt);
                }
                if (attributeProp.getProperty("ATTRIB_COLUMN_NAME").equals("PHOTO_FILE") && reportType.toLowerCase().indexOf("csv") == -1) {
                    JRDesignImage image = new JRDesignImage(null);
                    image.setX(x);
                    image.setY(0);
                    image.setWidth(width);
                    image.setHeight(height);
                    image.setBox((JRBox)box);
                    JRDesignExpression imgexpression = new JRDesignExpression();
                    imgexpression.setValueClass(String.class);
                    if (reportType.equalsIgnoreCase("html")) {
                        image.setLazy(true);
                    }
                    imgexpression.setText("$F{" + columnName1 + "}");
                    image.setExpression((JRExpression)imgexpression);
                    detailBand.addElement((JRDesignElement)image);
                    x += width + 0;
                    continue;
                }
                JRDesignTextField txtField = JRFieldDesignUtil.getJRDesignTextField(x, 0, width, height, normalFont, new Color(255, 255, 255), new Color(0, 0, 0), (byte)1, (byte)2);
                txtField.setBox((JRBox)box);
                detailBand.setSplitAllowed(true);
                if (reportType.toLowerCase().indexOf("xls") != -1) {
                    txtField.setMaxCharsForOverflow(30000L);
                    txtField.setPrintWhenDetailOverflows(false);
                } else {
                    txtField.setPrintWhenDetailOverflows(true);
                }
                if (columnName1.equals(new Integer(1037))) {
                    txtField.setStyledText(true);
                    txtField.setMarkup("html");
                }
                txtField.setPrintRepeatedValues(true);
                txtField.setPrintInFirstWholeBand(true);
                JRFieldDesignUtil.setDesignExpression(detailBand, (Integer)attributeProp.get("ATTRIB_ID"), rb, box, txtField, width, x, loginId, reportPDFFont, isWorkflow);
                detailBand.addElement((JRDesignElement)txtField);
                x += width + 0;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void fillBand(Hashtable columnWidths, JasperDesign jasperDesign, JRDesignBand columnHeaderBand, JRDesignBand detailBand, ArrayList attributeList, String reportType, AdventNetResourceBundle rb, Long loginId, Locale locale) {
        JRDesignUtil.fillBand(columnWidths, jasperDesign, columnHeaderBand, detailBand, attributeList, reportType, rb, loginId, false, locale);
    }

    public static void fillBand(Hashtable columnWidths, JasperDesign jasperDesign, JRDesignBand columnHeaderBand, JRDesignBand detailBand, ArrayList attributeList, String reportType, AdventNetResourceBundle rb, Long loginId, boolean showSerialNo, Locale locale) {
        boolean isSplitAllowed = false;
        pageWidth = 595;
        pageHeight = 842;
        columnWidth = 535;
        columnSpacing = 0;
        leftMargin = 30;
        rightMargin = 30;
        topMargin = 20;
        bottomMargin = 20;
        int x = 0;
        boolean y = false;
        int width = columnWidth / attributeList.size();
        int height = 30;
        normalSize = 9;
        groupPad = 10;
        try {
            Properties attributeProp;
            int i;
            columnHeaderBand.setHeight(60);
            JRDesignReportFont columnFont = null;
            JRDesignReportFont normalFont = null;
            JRDesignReportFont pageFooterFont = null;
            JRFont reportPDFFont = JRFieldDesignUtil.getReportFont(reportType, locale);
            columnFont = JRFieldDesignUtil.getJRDesignReportFont("Arial_normal", reportPDFFont, normalSize, true, false);
            normalFont = JRFieldDesignUtil.getJRDesignReportFont("Arial_normal", reportPDFFont, normalSize, false, false);
            pageFooterFont = JRFieldDesignUtil.getJRDesignReportFont("pagefooter_reportname", reportPDFFont, normalSize + 1, true, false);
            if (reportType.toLowerCase().indexOf("csv") == -1) {
                JRFieldDesignUtil.addLogo(jasperDesign, reportType);
                for (i = 0; i < attributeList.size(); ++i) {
                    attributeProp = (Properties)attributeList.get(i);
                    if (!attributeProp.getProperty("ATTRIB_COLUMN_NAME").equals("PHOTO_FILE")) continue;
                    height = 63;
                    break;
                }
            }
            detailBand.setHeight(height);
            if (showSerialNo) {
                columnWidth = 485;
                String displayName = rb.getString("admp.reports.common.export.Serial_no");
                JRFieldDesignUtil.addFieldToJasper(jasperDesign, columnHeaderBand, detailBand, columnFont, normalFont, x, 0, 50, height, 60, displayName, "serialNo", rb, loginId, reportType, locale);
                x = 50;
            }
            for (i = 0; i < attributeList.size(); ++i) {
                attributeProp = (Properties)attributeList.get(i);
                Integer columnName1 = (Integer)attributeProp.get("ATTRIB_ID");
                String displayName = null;
                if (reportType.toLowerCase().equals("csvde")) {
                    displayName = attributeProp.getProperty("ATTRIB_LDAP_NAME");
                } else {
                    displayName = attributeProp.getProperty("ATTRIB_DISP_NAME");
                    displayName = rb.getString(displayName);
                }
                String tableName = attributeProp.getProperty("TABLE_NAME");
                String columnName = attributeProp.getProperty("ATTRIB_COLUMN_NAME");
                if ((displayName.equals("lockoutTime") || displayName.equals("lastLogon") || displayName.equals("badPasswordTime") || displayName.equals("badPwdCount") || displayName.equals("lastLogoff") || displayName.equals("pwdLastSet")) && reportType.toLowerCase().equals("csvde") || attributeProp.getProperty("ATTRIB_COLUMN_NAME").equals("PHOTO_FILE") && reportType.toLowerCase().indexOf("csvde") != -1) continue;
                if (columnWidths != null && columnWidths.get(columnName1) != null) {
                    width = (Integer)columnWidths.get(columnName1);
                }
                Class<String> classType = String.class;
                JRDesignField field = new JRDesignField();
                field.setName(columnName.toString());
                field.setValueClass(String.class);
                jasperDesign.addField((JRField)field);
                JRDesignStaticText txt = JRFieldDesignUtil.getJRDesignStaticText(x, 0, width, 60, columnFont, new Color(255, 255, 255), new Color(0, 0, 0), (byte)1, (byte)2);
                txt.setMode((byte)1);
                txt.setStretchType((byte)1);
                txt.setPositionType((byte)2);
                txt.setKey(columnName.toString());
                txt.setPrintRepeatedValues(true);
                txt.setRemoveLineWhenBlank(false);
                txt.setPrintInFirstWholeBand(false);
                txt.setPrintWhenDetailOverflows(false);
                JRBaseBox box = new JRBaseBox();
                box.setTopBorder((byte)5);
                box.setTopBorderColor(new Color(155, 166, 109));
                box.setLeftBorder((byte)5);
                box.setLeftBorderColor(new Color(155, 166, 109));
                box.setRightBorder((byte)5);
                box.setRightBorderColor(new Color(155, 166, 109));
                box.setBottomBorder((byte)1);
                box.setBottomBorderColor(new Color(155, 166, 109));
                box.setLeftPadding(1);
                txt.setBox((JRBox)box);
                txt.setBackcolor(new Color(239, 239, 231));
                txt.setForecolor(Color.BLACK);
                txt.setText(displayName);
                if (reportType.toLowerCase().indexOf("xls") != -1 || reportType.toLowerCase().indexOf("csv") != -1) {
                    JRDesignExpression express = new JRDesignExpression();
                    express.setValueClass(Boolean.class);
                    express.setText("$V{PAGE_NUMBER}.intValue() == 1 ? Boolean.TRUE : Boolean.FALSE");
                    columnHeaderBand.setPrintWhenExpression((JRExpression)express);
                }
                columnHeaderBand.addElement((JRDesignElement)txt);
                if (attributeProp.getProperty("ATTRIB_COLUMN_NAME").equals("PHOTO_FILE") && reportType.toLowerCase().indexOf("csv") == -1) {
                    JRDesignImage image = new JRDesignImage(null);
                    image.setX(x);
                    image.setY(0);
                    image.setWidth(width);
                    image.setHeight(height);
                    image.setBox((JRBox)box);
                    JRDesignExpression imgexpression = new JRDesignExpression();
                    imgexpression.setValueClass(String.class);
                    if (reportType.equalsIgnoreCase("html")) {
                        image.setLazy(true);
                    }
                    imgexpression.setText("$F{" + columnName1 + "}");
                    image.setExpression((JRExpression)imgexpression);
                    detailBand.addElement((JRDesignElement)image);
                    x += width + 0;
                    continue;
                }
                JRDesignTextField txtField = JRFieldDesignUtil.getJRDesignTextField(x, 0, width, height, normalFont, new Color(255, 255, 255), new Color(0, 0, 0), (byte)1, (byte)2);
                JRDesignExpression exp = new JRDesignExpression();
                exp.setValueClass(String.class);
                exp.setText("$F{" + columnName + "}");
                txtField.setBox((JRBox)box);
                txtField.setExpression((JRExpression)exp);
                detailBand.setSplitAllowed(true);
                txtField.setPrintWhenDetailOverflows(true);
                txtField.setPrintRepeatedValues(true);
                txtField.setPrintInFirstWholeBand(true);
                if (columnName1.equals(new Integer(1037))) {
                    txtField.setStyledText(true);
                    txtField.setMarkup("html");
                }
                detailBand.addElement((JRDesignElement)txtField);
                x += width + 0;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Hashtable calculateWidth(ArrayList attributeList, ArrayList results, Hashtable multipleValuesSids, String reportType, AdventNetResourceBundle rb) {
        return JRDesignUtil.calculateWidth(attributeList, results, multipleValuesSids, reportType, null, new Hashtable(), rb);
    }

    public static Hashtable calculateWidth(ArrayList attributeList, ArrayList results, Hashtable multipleValuesSids, String reportType, int maxColumnWidth, boolean hasFlexibleWidth, AdventNetResourceBundle rb) {
        return JRDesignUtil.calculateWidth(attributeList, results, multipleValuesSids, reportType, null, new Hashtable(), maxColumnWidth, hasFlexibleWidth, rb);
    }

    public static Hashtable calculateWidth(ArrayList attributeList, ArrayList results, Hashtable multipleValuesSids, String reportType, int maxColumnWidth, boolean hasFlexibleWidth, boolean showSerialNo, AdventNetResourceBundle rb) {
        return JRDesignUtil.calculateWidth(attributeList, results, multipleValuesSids, reportType, null, new Hashtable(), maxColumnWidth, hasFlexibleWidth, showSerialNo, rb);
    }

    public static Hashtable calculateWidth(ArrayList attributeList, ArrayList results, Hashtable multipleValuesSids, String reportType, HttpServletRequest request, AdventNetResourceBundle rb) {
        return JRDesignUtil.calculateWidth(attributeList, results, multipleValuesSids, reportType, request, new Hashtable(), rb);
    }

    public static Hashtable calculateWidth(ArrayList attributeList, ArrayList results, Hashtable multipleValuesSids, String reportType, HttpServletRequest request, boolean showSerialNo, AdventNetResourceBundle rb) {
        return JRDesignUtil.calculateWidth(attributeList, results, multipleValuesSids, reportType, request, new Hashtable(), columnWidth, false, showSerialNo, rb);
    }

    public static Hashtable calculateWidth(ArrayList attributeList, ArrayList results, Hashtable multipleValuesSids, String reportType, HttpServletRequest request, Hashtable previousColumnWidths, AdventNetResourceBundle rb) {
        return JRDesignUtil.calculateWidth(attributeList, results, multipleValuesSids, reportType, request, new Hashtable(), columnWidth, false, rb);
    }

    public static Hashtable calculateWidth(ArrayList attributeList, ArrayList results, Hashtable multipleValuesSids, String reportType, HttpServletRequest request, Hashtable previousColumnWidths, int maxColumnWidth, boolean hasFlexibleWidth, AdventNetResourceBundle rb) {
        return JRDesignUtil.calculateWidth(attributeList, results, multipleValuesSids, reportType, request, new Hashtable(), maxColumnWidth, false, false, rb);
    }

    public static Hashtable calculateWidth(ArrayList attributeList, ArrayList results, Hashtable multipleValuesSids, String reportType, HttpServletRequest request, Hashtable previousColumnWidths, int maxColumnWidth, boolean hasFlexibleWidth, boolean showSerialNo, AdventNetResourceBundle rb) {
        return JRDesignUtil.calculateWidth(attributeList, results, multipleValuesSids, reportType, request, previousColumnWidths, maxColumnWidth, hasFlexibleWidth, showSerialNo, false, rb);
    }

    public static Hashtable calculateWidth(ArrayList attributeList, ArrayList results, Hashtable multipleValuesSids, String reportType, HttpServletRequest request, Hashtable previousColumnWidths, int maxColumnWidth, boolean hasFlexibleWidth, boolean showSerialNo, boolean isWorkflow, AdventNetResourceBundle rb) {
        int w;
        Integer columnName;
        columnWidth = 535;
        if (showSerialNo) {
            columnWidth -= 50;
        }
        if (maxColumnWidth == -1) {
            maxColumnWidth = columnWidth;
        } else if (showSerialNo) {
            maxColumnWidth -= 50;
        }
        Long loginId = DelegationUtil.ADMIN_LOGIN_ID;
        if (request != null) {
            HttpSession session = request.getSession();
            loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        }
        Hashtable<Object, Integer> columnWidths = new Hashtable<Object, Integer>();
        for (int i = 0; i < results.size(); ++i) {
            Hashtable p = (Hashtable)results.get(i);
            for (int j = 0; j < attributeList.size(); ++j) {
                Integer len;
                Properties attributeProp = (Properties)attributeList.get(j);
                Integer fname = (Integer)attributeProp.get("ATTRIB_ID");
                String transformer = (String)attributeProp.get("TRANSFORMER_CLASS");
                String tableName = (String)attributeProp.get("TABLE_NAME");
                String displayName = null;
                int length = 0;
                displayName = reportType.toLowerCase().equals("csvde") ? attributeProp.getProperty("ATTRIB_LDAP_NAME") : rb.getString(attributeProp.getProperty("ATTRIB_DISP_NAME"));
                Object val = null;
                String objectId = (String)p.get("OBJECT_GUID");
                if ((displayName.equals("lockoutTime") || displayName.equals("lastLogon") || displayName.equals("badPasswordTime") || displayName.equals("badPwdCount") || displayName.equals("lastLogoff") || displayName.equals("pwdLastSet")) && reportType.toLowerCase().equals("csvde") || attributeProp.getProperty("ATTRIB_COLUMN_NAME").equals("PHOTO_FILE") && reportType.toLowerCase().indexOf("csvde") != -1) continue;
                if (isWorkflow) {
                    val = p.get(fname);
                    if (val != null) {
                        if (fname == 11021) {
                            String assignedTo = "";
                            for (int index = 0; index < ((ArrayList)val).size(); ++index) {
                                Properties assignedProp = (Properties)((ArrayList)val).get(index);
                                if (!assignedTo.equals("")) {
                                    assignedTo = assignedTo + ", ";
                                }
                                assignedTo = assignedTo + rb.getString(assignedProp.getProperty("fullName"));
                            }
                            val = assignedTo;
                        } else {
                            val = rb.getString((String)val);
                        }
                    }
                } else {
                    String value;
                    if (fname == 1040 || fname == 1039 || fname == 1029 || fname == 1035 || fname == 1030 || fname == 1044 || fname == 2008 || fname == 2009 || fname == 3011 || fname == 3012 || fname == 3019 || fname == 5039 || fname == 5040 || fname == 6023 || fname == 6024 || fname == 8005 || fname == 8006 || fname == 1022 || fname == 9054 || fname == 9056 || fname == 9057 || fname == 10013 || fname == 10014 || fname == 11013 || fname == 11014 || fname == 11014 || fname == 1192 || fname == 3033 || fname == 7036 || fname == 7037) {
                        length = 120;
                        value = (String)p.get(fname);
                        val = value != null && !value.equals("0") ? (Number)DateTimeUtil.getSystemTimeFromFileTimeForPwdLastSet((Long)Long.parseLong(value)) : (Number)0;
                    } else if (fname == 1033 || fname == 3025) {
                        length = 120;
                        value = (String)p.get(fname);
                        val = value != null && !value.equals("0") ? (Number)DateTimeUtil.getSystemTimeFromFileTimeForPwdLastSet((Long)Long.parseLong(value)) : (Number)0;
                    } else if (fname == 1150) {
                        value = (String)p.get(fname);
                        val = value != null ? (Number)Long.parseLong(value) : (Number)-2;
                    }
                    if (fname.equals(new Integer(1037)) && !reportType.toLowerCase().equals("csvde")) {
                        val = ReportAttributesUtil.getLogonHoursAsString((String)((String)p.get(fname)), (AdventNetResourceBundle)rb, (Long)loginId, (String)reportType);
                    } else if (fname == 1151) {
                        value = (String)p.get(fname);
                        val = DateTimeUtil.getDaysToExpire((String)value, (AdventNetResourceBundle)rb);
                        val = ClientUtil.getLocalizedString(rb, (String)val);
                    } else if (fname == 1152) {
                        value = (String)p.get(fname);
                        val = DateTimeUtil.getDaysSincePasswordSet((String)value);
                        val = ClientUtil.getLocalizedString(rb, (String)val);
                    } else if (fname == 1193) {
                        val = "admp.common.text.not_applicable";
                        Long longObj = new Long((String)p.get(fname));
                        if (longObj != 0L) {
                            val = new Long(DateTimeUtil.getNoOfDays((Long)longObj)).toString();
                        }
                        val = ClientUtil.getLocalizedString(rb, (String)val);
                    } else if (fname == 1031) {
                        length = 120;
                        value = (String)p.get(fname);
                        if (value != null && !value.equals("")) {
                            val = !value.equals("0") ? DateTimeUtil.getAccountExpiresDateFromFileTime((Long)Long.parseLong(value), (AdventNetResourceBundle)rb, (Long)loginId) : "admp.reports.user.account_exp_date.never_expires";
                            val = ClientUtil.getLocalizedString(rb, (String)val);
                        } else {
                            val = "-";
                        }
                    } else if (fname == 100000) {
                        value = (String)p.get("MESSAGE");
                        val = value == null ? "" : value;
                    } else if (fname == 11006) {
                        value = (String)p.get(fname);
                        val = value.equals("-1") ? "admp.reports.ntfs_reports.shares_in_servers.reportresulttxt.max_allowed" : value;
                        val = ClientUtil.getLocalizedString(rb, (String)val);
                    } else if (fname == 11146) {
                        value = (String)p.get(fname);
                        val = value != "0" ? (Number)Long.valueOf(value) : (Number)0;
                    } else if (attributeProp.getProperty("ATTRIB_COLUMN_NAME").equals("PHOTO_FILE")) {
                        value = (String)p.get(fname);
                        val = JRFieldDesignUtil.getImagePath(reportType, value, rb);
                    } else if (transformer != null && transformer.equalsIgnoreCase("com.adventnet.sym.adsm.common.webclient.transformers.CustomFieldsTransformers")) {
                        value = (String)p.get(fname);
                        if (value != null && !value.equals("0")) {
                            Long fileTime = Long.parseLong(value);
                            val = DateTimeUtil.getDateFromFileTime((Long)fileTime, (Long)loginId);
                        } else {
                            val = "-";
                        }
                    } else if (p.get(fname) != null) {
                        val = p.get(fname);
                        val = ClientUtil.getLocalizedString(rb, (String)val);
                    } else if (!multipleValuesSids.isEmpty()) {
                        Hashtable h = (Hashtable)multipleValuesSids.get(objectId);
                        ArrayList list = (ArrayList)h.get(fname);
                        StringBuffer sb = new StringBuffer();
                        if (list != null) {
                            for (int k = 0; list != null && k < list.size(); ++k) {
                                if (sb.length() != 0) {
                                    sb.append("; ");
                                }
                                sb.append(list.get(k));
                            }
                        } else {
                            sb.append("-");
                        }
                        val = sb.toString();
                    }
                }
                if (val == null || val.equals("")) {
                    val = "-";
                }
                String str = val.toString();
                if (reportType.toLowerCase().equals("csvde") && str.equals("-")) {
                    str = "";
                }
                p.put(fname, str);
                int strLength = 0;
                if (fname.equals(new Integer(1037))) {
                    String[] arr;
                    for (String string : arr = str.split("<br/>")) {
                        if (string.length() <= strLength) continue;
                        strLength = string.length();
                    }
                } else {
                    strLength = attributeProp.getProperty("ATTRIB_COLUMN_NAME").equals("PHOTO_FILE") ? 12 : str.length();
                }
                if (displayName.length() > strLength) {
                    strLength = displayName.length();
                }
                int previousLength = 0;
                if (!previousColumnWidths.isEmpty()) {
                    previousLength = (Integer)previousColumnWidths.get(fname);
                }
                if (!reportType.toLowerCase().equals("xlsx") || length == 0) {
                    length = strLength * 5;
                }
                if (length < previousLength) {
                    length = previousLength;
                }
                if ((len = (Integer)columnWidths.get(fname)) != null) {
                    if (length <= len) continue;
                    columnWidths.put(fname, new Integer(length));
                    continue;
                }
                columnWidths.put(fname, new Integer(length));
            }
        }
        int calculatedMaxWidth = 0;
        if (hasFlexibleWidth) {
            Enumeration keys = columnWidths.keys();
            while (keys.hasMoreElements()) {
                Integer key = (Integer)keys.nextElement();
                int columnSize = (Integer)columnWidths.get(key);
                columnSize += columnSize / 20 + 1;
                columnWidths.put(key, new Integer(columnSize));
                calculatedMaxWidth += columnSize;
            }
        }
        ArrayList<Integer> lengthyList = new ArrayList<Integer>();
        int remTotalWidth = 0;
        int maxPDFColWidth = 14200 - attributeList.size() * 2;
        if (!reportType.toLowerCase().equals("csvde") && hasFlexibleWidth) {
            if (!columnWidths.isEmpty() && calculatedMaxWidth < columnWidth) {
                int remainingWidth = columnWidth - calculatedMaxWidth;
                int widthToAddForEachColumn = remainingWidth / columnWidths.size();
                Enumeration keys = columnWidths.keys();
                while (keys.hasMoreElements()) {
                    Integer key = (Integer)keys.nextElement();
                    int columnSize = (Integer)columnWidths.get(key);
                    columnWidths.put(key, new Integer(columnSize += widthToAddForEachColumn));
                }
                calculatedMaxWidth = columnWidth;
            } else if (calculatedMaxWidth > maxPDFColWidth) {
                calculatedMaxWidth = maxPDFColWidth;
            }
        } else {
            calculatedMaxWidth = maxColumnWidth;
        }
        int width = calculatedMaxWidth / attributeList.size();
        if (!reportType.toLowerCase().equals("csvde")) {
            for (int i = 0; i < attributeList.size(); ++i) {
                Properties attributeProp = (Properties)attributeList.get(i);
                columnName = (Integer)attributeProp.get("ATTRIB_ID");
                if (columnWidths.isEmpty()) continue;
                w = (Integer)columnWidths.get(columnName);
                if (w > width) {
                    lengthyList.add(columnName);
                    continue;
                }
                remTotalWidth += width - w;
            }
        }
        int extraWidth = 0;
        if (lengthyList.size() > 0) {
            extraWidth = remTotalWidth / lengthyList.size();
        }
        for (int i = 0; i < lengthyList.size(); ++i) {
            columnName = (Integer)lengthyList.get(i);
            w = (Integer)columnWidths.get(columnName);
            columnWidths.put(columnName, new Integer(width + extraWidth));
        }
        int lengthyListSize = lengthyList.size();
        int indx2 = 0;
        int colWidth = 0;
        int tmpMaxRows = 0;
        if (lengthyListSize > 0) {
            int resultSize = results.size();
            for (int indx1 = 0; indx1 < resultSize; ++indx1) {
                Hashtable resultData = (Hashtable)results.get(indx1);
                int maxRows = 3;
                for (indx2 = 0; indx2 < lengthyListSize; ++indx2) {
                    Integer attribId = (Integer)lengthyList.get(indx2);
                    Object attribValue = resultData.get(attribId);
                    if (attribValue == null) continue;
                    colWidth = (Integer)columnWidths.get(attribId);
                    tmpMaxRows = StrUtil.getWrappedLineCount((String)attribValue.toString(), (int)(colWidth /= 5));
                    if (tmpMaxRows < maxRows) continue;
                    maxRows = tmpMaxRows > maxRows ? tmpMaxRows : maxRows;
                    resultData.put("maxRows", maxRows);
                }
            }
        }
        if (showSerialNo) {
            calculatedMaxWidth += 50;
        }
        if (!columnWidths.isEmpty() && hasFlexibleWidth) {
            columnWidths.put("maxColumnWidth", new Integer(calculatedMaxWidth));
        }
        return columnWidths;
    }

    public static void fillBandForAuditReport(Hashtable columnWidths, JasperDesign jasperDesign, JRDesignBand columnHeaderBand, JRDesignBand detailBand, ArrayList attributeList, String reportType, String baseTable, int index, AdventNetResourceBundle rb, Long loginId, String reportFormat, boolean showSerialNo, Locale locale) {
        JRDesignUtil.fillBandForAuditReport(columnWidths, jasperDesign, columnHeaderBand, detailBand, attributeList, reportType, baseTable, index, rb, loginId, reportFormat, showSerialNo, false, locale);
    }

    public static void fillBandForAuditReport(Hashtable columnWidths, JasperDesign jasperDesign, JRDesignBand columnHeaderBand, JRDesignBand detailBand, ArrayList attributeList, String reportType, String baseTable, int index, AdventNetResourceBundle rb, Long loginId, String reportFormat, boolean showSerialNo, boolean isPropsAvailabe, Locale locale) {
        boolean isSplitAllowed = false;
        if (reportFormat.equals("standard")) {
            pageWidth = 1595;
            columnWidth = 1535;
        } else {
            pageWidth = 595;
            columnWidth = 535;
        }
        pageHeight = 842;
        columnSpacing = 3;
        leftMargin = 30;
        rightMargin = 30;
        topMargin = 20;
        bottomMargin = 20;
        int x = 0;
        boolean y = false;
        int width = columnWidth / attributeList.size();
        normalSize = 9;
        groupPad = 10;
        try {
            columnHeaderBand.setHeight(60);
            detailBand.setHeight(30);
            if (loginId == null) {
                loginId = DelegationUtil.ADMIN_LOGIN_ID;
            }
            JRFont reportPDFFont = JRFieldDesignUtil.getReportFont(reportType, locale);
            JRDesignReportFont columnFont = JRFieldDesignUtil.getJRDesignReportFont("Arial_normal", reportPDFFont, normalSize, true, false);
            JRDesignReportFont normalFont = JRFieldDesignUtil.getJRDesignReportFont("Arial_normal", reportPDFFont, normalSize, false, false);
            JRDesignReportFont pageFooterFont = JRFieldDesignUtil.getJRDesignReportFont("pagefooter_reportname", reportPDFFont, normalSize + 1, true, false);
            if (reportType.toLowerCase().indexOf("csv") == -1) {
                JRFieldDesignUtil.addLogo(jasperDesign, reportType);
            }
            if (showSerialNo) {
                columnWidth -= 50;
                String displayName = rb.getString("admp.reports.common.export.Serial_no");
                JRFieldDesignUtil.addFieldToJasper(jasperDesign, columnHeaderBand, detailBand, columnFont, normalFont, x, 0, 50, 30, 60, displayName, "serialNo", rb, loginId, reportType, locale);
                x = 50;
            }
            for (int i = 0; i < attributeList.size(); ++i) {
                JRDesignExpression exp;
                Properties attributeProp = (Properties)attributeList.get(i);
                Integer columnName1 = (Integer)attributeProp.get("ATTRIB_ID");
                if (columnName1.equals(new Integer(1037))) continue;
                String displayName = null;
                if (reportType.toLowerCase().equals("csvde")) {
                    displayName = attributeProp.getProperty("ATTRIB_LDAP_NAME");
                } else {
                    displayName = attributeProp.getProperty("ATTRIB_DISP_NAME");
                    displayName = rb.getString(displayName);
                    if (columnName1.equals(new Integer(11150))) {
                        displayName = rb.getString("admp.deleg.hdt_deleg.hdt_reports.scheduler.details");
                    }
                }
                String tableName = attributeProp.getProperty("TABLE_NAME");
                String columnName = attributeProp.getProperty("ATTRIB_COLUMN_NAME");
                if ((displayName.equals("lockoutTime") || displayName.equals("lastLogon") || displayName.equals("badPasswordTime") || displayName.equals("badPwdCount") || displayName.equals("lastLogoff") || displayName.equals("pwdLastSet")) && reportType.toLowerCase().equals("csvde")) continue;
                if (columnWidths != null && columnWidths.get(columnName1) != null) {
                    width = (Integer)columnWidths.get(columnName1);
                }
                Class<String> classType = String.class;
                JRDesignField field = new JRDesignField();
                field.setName(columnName1.toString());
                field.setValueClass(String.class);
                jasperDesign.addField((JRField)field);
                JRDesignStaticText txt = JRFieldDesignUtil.getJRDesignStaticText(x, 0, width, 60, columnFont, new Color(255, 255, 255), new Color(0, 0, 0), (byte)1, (byte)2);
                txt.setMode((byte)1);
                txt.setStretchType((byte)1);
                txt.setPositionType((byte)2);
                txt.setKey(columnName1.toString());
                txt.setPrintRepeatedValues(true);
                txt.setRemoveLineWhenBlank(false);
                txt.setPrintInFirstWholeBand(false);
                txt.setPrintWhenDetailOverflows(false);
                JRBaseBox box = new JRBaseBox();
                box.setTopBorder((byte)5);
                if (reportFormat.equals("standard")) {
                    box.setTopBorderColor(new Color(155, 166, 109));
                    box.setLeftBorder((byte)1);
                    box.setLeftBorderColor(new Color(155, 166, 109));
                    box.setRightBorder((byte)1);
                    box.setRightBorderColor(new Color(155, 166, 109));
                    box.setBottomBorder((byte)1);
                    box.setBottomBorderColor(new Color(155, 166, 109));
                } else {
                    box.setTopBorderColor(new Color(155, 166, 109));
                    box.setLeftBorder((byte)1);
                    box.setLeftBorderColor(new Color(155, 166, 109));
                    box.setRightBorder((byte)1);
                    box.setRightBorderColor(new Color(155, 166, 109));
                    box.setBottomBorder((byte)1);
                    box.setBottomBorderColor(new Color(155, 166, 109));
                }
                box.setLeftPadding(1);
                txt.setBox((JRBox)box);
                txt.setBackcolor(new Color(239, 239, 231));
                txt.setForecolor(Color.BLACK);
                txt.setText(displayName);
                if (reportType.toLowerCase().indexOf("xls") != -1 || reportType.toLowerCase().indexOf("csv") != -1) {
                    JRDesignExpression express = new JRDesignExpression();
                    express.setValueClass(Boolean.class);
                    express.setText("$V{PAGE_NUMBER}.intValue() == 1 ? Boolean.TRUE : Boolean.FALSE");
                    columnHeaderBand.setPrintWhenExpression((JRExpression)express);
                }
                if (reportType.toLowerCase().indexOf("csv") == -1 || index <= 0) {
                    columnHeaderBand.addElement((JRDesignElement)txt);
                }
                Color detailsFieldColor = null;
                detailsFieldColor = columnName1.equals(new Integer(11150)) && !reportFormat.equals("standard") ? new Color(54, 91, 129) : new Color(0, 0, 0);
                JRDesignTextField txtField = JRFieldDesignUtil.getJRDesignTextField(x, 0, width, 30, normalFont, new Color(255, 255, 255), detailsFieldColor, (byte)1, (byte)2);
                txtField.setBox((JRBox)box);
                detailBand.setSplitAllowed(true);
                txtField.setPrintWhenDetailOverflows(true);
                txtField.setPrintRepeatedValues(true);
                txtField.setPrintInFirstWholeBand(true);
                if (columnName1.equals(new Integer(11150))) {
                    if (reportFormat.equals("standard")) {
                        txtField.setMode((byte)2);
                        exp = new JRDesignExpression();
                        exp.setValueClass(String.class);
                        if (reportType.toLowerCase().equals("csv")) {
                            exp.setText("$F{11150}");
                        } else {
                            exp.setText("\" \"");
                        }
                        txtField.setExpression((JRExpression)exp);
                    } else {
                        JRDesignExpression exp11 = new JRDesignExpression();
                        exp11.setValueClass(String.class);
                        String tmpval = "$F{11150}";
                        exp11.setText(tmpval);
                        txtField.setHyperlinkType((byte)3);
                        txtField.setHyperlinkAnchorExpression((JRExpression)exp11);
                        JRDesignExpression exp22 = new JRDesignExpression();
                        exp22.setValueClass(String.class);
                        exp22.setText("com.adventnet.sym.adsm.common.webclient.audit.HDTAuditReportListener.getDetailsString($F{11150})");
                        txtField.setExpression((JRExpression)exp22);
                        JRDesignExpression exp33 = new JRDesignExpression();
                        exp33.setValueClass(String.class);
                        exp33.setText("$F{11150}+\"_reverse\"");
                        txtField.setAnchorNameExpression((JRExpression)exp33);
                    }
                } else if (columnName1.equals(new Integer(19005))) {
                    txtField.setMode((byte)2);
                    exp = new JRDesignExpression();
                    exp.setValueClass(String.class);
                    exp.setText("$F{19005}");
                    txtField.setExpression((JRExpression)exp);
                } else {
                    JRFieldDesignUtil.setDesignExpression(detailBand, (Integer)attributeProp.get("ATTRIB_ID"), rb, box, txtField, width, x, loginId, reportPDFFont);
                }
                detailBand.addElement((JRDesignElement)txtField);
                x += width + 0;
            }
            if (isPropsAvailabe) {
                JRDesignField field = new JRDesignField();
                field.setName("-2");
                field.setValueClass(String.class);
                jasperDesign.addField((JRField)field);
                JRDesignStaticText txt = JRFieldDesignUtil.getJRDesignStaticText(x, 0, width, 60, columnFont, new Color(255, 255, 255), new Color(0, 0, 0), (byte)1, (byte)2);
                txt.setMode((byte)1);
                txt.setStretchType((byte)1);
                txt.setPositionType((byte)2);
                txt.setKey("-2");
                txt.setPrintRepeatedValues(true);
                txt.setRemoveLineWhenBlank(false);
                txt.setPrintInFirstWholeBand(false);
                txt.setPrintWhenDetailOverflows(false);
                JRBaseBox box = new JRBaseBox();
                box.setTopBorder((byte)5);
                if (reportFormat.equals("standard")) {
                    box.setTopBorderColor(new Color(155, 166, 109));
                    box.setLeftBorder((byte)1);
                    box.setLeftBorderColor(new Color(155, 166, 109));
                    box.setRightBorder((byte)1);
                    box.setRightBorderColor(new Color(155, 166, 109));
                    box.setBottomBorder((byte)1);
                    box.setBottomBorderColor(new Color(155, 166, 109));
                } else {
                    box.setTopBorderColor(new Color(155, 166, 109));
                    box.setLeftBorder((byte)1);
                    box.setLeftBorderColor(new Color(155, 166, 109));
                    box.setRightBorder((byte)1);
                    box.setRightBorderColor(new Color(155, 166, 109));
                    box.setBottomBorder((byte)1);
                    box.setBottomBorderColor(new Color(155, 166, 109));
                }
                box.setLeftPadding(1);
                txt.setBox((JRBox)box);
                txt.setBackcolor(new Color(239, 239, 231));
                txt.setForecolor(Color.BLACK);
                txt.setText(rb.getString("admp.deleg.hdt_deleg.hdt_reports.scheduler.details"));
                if (reportType.toLowerCase().indexOf("xls") != -1 || reportType.toLowerCase().indexOf("csv") != -1) {
                    JRDesignExpression express = new JRDesignExpression();
                    express.setValueClass(Boolean.class);
                    express.setText("$V{PAGE_NUMBER}.intValue() == 1 ? Boolean.TRUE : Boolean.FALSE");
                    columnHeaderBand.setPrintWhenExpression((JRExpression)express);
                }
                if (reportType.toLowerCase().indexOf("csv") == -1 || index <= 0) {
                    columnHeaderBand.addElement((JRDesignElement)txt);
                }
                Color detailsFieldColor = null;
                detailsFieldColor = !reportFormat.equals("standard") ? new Color(54, 91, 129) : new Color(0, 0, 0);
                JRDesignTextField txtField = JRFieldDesignUtil.getJRDesignTextField(x, 0, width, 30, normalFont, new Color(255, 255, 255), detailsFieldColor, (byte)1, (byte)2);
                txtField.setBox((JRBox)box);
                detailBand.setSplitAllowed(true);
                txtField.setPrintWhenDetailOverflows(true);
                txtField.setPrintRepeatedValues(true);
                txtField.setPrintInFirstWholeBand(true);
                if (reportFormat.equals("standard")) {
                    txtField.setMode((byte)2);
                    JRDesignExpression exp = new JRDesignExpression();
                    exp.setValueClass(String.class);
                    if (reportType.toLowerCase().equals("csv")) {
                        exp.setText("$F{-2}");
                    } else {
                        exp.setText("\" \"");
                    }
                    txtField.setExpression((JRExpression)exp);
                } else {
                    JRDesignExpression exp11 = new JRDesignExpression();
                    exp11.setValueClass(String.class);
                    String tmpval = "$F{-1}";
                    exp11.setText(tmpval);
                    txtField.setHyperlinkType((byte)3);
                    txtField.setHyperlinkAnchorExpression((JRExpression)exp11);
                    JRDesignExpression exp22 = new JRDesignExpression();
                    exp22.setValueClass(String.class);
                    exp22.setText("$F{-2}");
                    txtField.setExpression((JRExpression)exp22);
                    JRDesignExpression exp33 = new JRDesignExpression();
                    exp33.setValueClass(String.class);
                    exp33.setText("$F{-1}+\"_reverse\"");
                    txtField.setAnchorNameExpression((JRExpression)exp33);
                }
                detailBand.addElement((JRDesignElement)txtField);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void addUserPhotos(ArrayList detailsList, String reportType, AdventNetResourceBundle rb) {
        try {
            block2: for (Hashtable hashtable : detailsList) {
                String attribName = (String)hashtable.get("AttrName");
                for (String photoAttrib : UserPhotoMgmtUtil.photoAttribLdapNames) {
                    if (!photoAttrib.equalsIgnoreCase(attribName) && !attribName.equals("userPhoto") && !attribName.equals(rb.getString("admp.common.attrib_disp_name.user_photo"))) continue;
                    String attribValue = (String)hashtable.get("AttrValue");
                    if (attribValue == null || attribValue.equalsIgnoreCase("null") || attribValue.equals("")) {
                        attribValue = "-";
                    } else {
                        File file = new File(attribValue);
                        if (!file.exists()) {
                            String serverHome = System.getProperty("server.home");
                            attribValue = serverHome + "\\webapps\\adsm\\images\\trans.gif";
                            file = new File(attribValue);
                        }
                        if (reportType.toLowerCase().indexOf("csv") != -1) {
                            attribValue = UserPhotoMgmtUtil.encodeImageFileToBase64((File)file);
                        } else {
                            attribValue = UserPhotoMgmtUtil.getRelativeFilePath((File)file);
                            attribValue = JRFieldDesignUtil.getLogoPath(attribValue, reportType.toLowerCase().indexOf("html") != -1);
                        }
                    }
                    attribValue = attribValue.replaceAll("\"", "");
                    hashtable.put("AttrName", attribName);
                    hashtable.put("AttrValue", attribValue);
                    continue block2;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void fillBandForHDTReport(Hashtable columnWidths, JasperDesign jasperDesign, JRDesignBand columnHeaderBand, JRDesignBand detailBand, ArrayList attributeList, String reportType, String baseTable, int index, AdventNetResourceBundle rb, Long loginId, boolean showSerialNo, Locale locale) {
        boolean isSplitAllowed = false;
        pageWidth = 595;
        pageHeight = 842;
        columnWidth = 535;
        columnSpacing = 0;
        leftMargin = 30;
        rightMargin = 30;
        topMargin = 20;
        bottomMargin = 20;
        int x = 0;
        boolean y = false;
        int width = columnWidth / attributeList.size();
        normalSize = 9;
        groupPad = 10;
        try {
            columnHeaderBand.setHeight(60);
            detailBand.setHeight(30);
            if (loginId == null) {
                loginId = DelegationUtil.ADMIN_LOGIN_ID;
            }
            JRDesignReportFont columnFont = null;
            JRDesignReportFont normalFont = null;
            JRDesignReportFont pageFooterFont = null;
            JRFont reportPDFFont = JRFieldDesignUtil.getReportFont(reportType, locale);
            columnFont = JRFieldDesignUtil.getJRDesignReportFont("Arial_normal", reportPDFFont, normalSize, true, false);
            normalFont = JRFieldDesignUtil.getJRDesignReportFont("Arial_normal", reportPDFFont, normalSize, false, false);
            pageFooterFont = JRFieldDesignUtil.getJRDesignReportFont("pagefooter_reportname", reportPDFFont, normalSize + 1, true, false);
            if (reportType.toLowerCase().indexOf("csv") == -1) {
                JRFieldDesignUtil.addLogo(jasperDesign, reportType);
            }
            if (showSerialNo) {
                columnWidth -= 50;
                String displayName = rb.getString("admp.reports.common.export.Serial_no");
                JRFieldDesignUtil.addFieldToJasper(jasperDesign, columnHeaderBand, detailBand, columnFont, normalFont, x, 0, 50, 30, 60, displayName, "serialNo", rb, loginId, reportType, locale);
                x = 50;
            }
            for (int i = 0; i < attributeList.size(); ++i) {
                Properties attributeProp = (Properties)attributeList.get(i);
                Integer columnName1 = (Integer)attributeProp.get("ATTRIB_ID");
                String displayName = null;
                if (reportType.toLowerCase().equals("csvde")) {
                    displayName = attributeProp.getProperty("ATTRIB_LDAP_NAME");
                } else {
                    displayName = attributeProp.getProperty("ATTRIB_DISP_NAME");
                    displayName = rb.getString(displayName);
                }
                String tableName = attributeProp.getProperty("TABLE_NAME");
                String columnName = attributeProp.getProperty("ATTRIB_COLUMN_NAME");
                if (columnWidths != null && columnWidths.get(columnName1) != null) {
                    width = (Integer)columnWidths.get(columnName1);
                }
                Class<String> classType = String.class;
                JRDesignField field = new JRDesignField();
                field.setName(columnName1.toString());
                field.setValueClass(String.class);
                jasperDesign.addField((JRField)field);
                JRDesignStaticText txt = JRFieldDesignUtil.getJRDesignStaticText(x, 0, width, 60, columnFont, new Color(255, 255, 255), new Color(0, 0, 0), (byte)1, (byte)2);
                txt.setMode((byte)1);
                txt.setStretchType((byte)1);
                txt.setPositionType((byte)2);
                txt.setKey(columnName1.toString());
                txt.setPrintRepeatedValues(true);
                txt.setRemoveLineWhenBlank(false);
                txt.setPrintInFirstWholeBand(false);
                txt.setPrintWhenDetailOverflows(false);
                JRBaseBox box = new JRBaseBox();
                box.setTopBorder((byte)5);
                box.setTopBorderColor(new Color(155, 166, 109));
                box.setLeftBorder((byte)5);
                box.setLeftBorderColor(new Color(155, 166, 109));
                box.setRightBorder((byte)5);
                box.setRightBorderColor(new Color(155, 166, 109));
                box.setBottomBorder((byte)1);
                box.setBottomBorderColor(new Color(155, 166, 109));
                box.setLeftPadding(1);
                txt.setBox((JRBox)box);
                txt.setBackcolor(new Color(239, 239, 231));
                txt.setForecolor(Color.BLACK);
                txt.setText(displayName);
                if (reportType.toLowerCase().indexOf("xls") != -1 || reportType.toLowerCase().indexOf("csv") != -1) {
                    JRDesignExpression express = new JRDesignExpression();
                    express.setValueClass(Boolean.class);
                    express.setText("$V{PAGE_NUMBER}.intValue() == 1 ? Boolean.TRUE : Boolean.FALSE");
                    columnHeaderBand.setPrintWhenExpression((JRExpression)express);
                }
                if (reportType.toLowerCase().indexOf("csv") == -1 || index <= 0) {
                    columnHeaderBand.addElement((JRDesignElement)txt);
                }
                JRDesignTextField txtField = JRFieldDesignUtil.getJRDesignTextField(x, 0, width, 30, normalFont, new Color(255, 255, 255), new Color(0, 0, 0), (byte)1, (byte)2);
                txtField.setBox((JRBox)box);
                detailBand.setSplitAllowed(true);
                if (reportType.toLowerCase().indexOf("xls") != -1) {
                    txtField.setMaxCharsForOverflow(30000L);
                }
                txtField.setPrintWhenDetailOverflows(false);
                txtField.setPrintRepeatedValues(true);
                txtField.setPrintInFirstWholeBand(true);
                JRFieldDesignUtil.setDesignExpression(detailBand, (Integer)attributeProp.get("ATTRIB_ID"), rb, box, txtField, width, x, loginId, reportPDFFont);
                detailBand.addElement((JRDesignElement)txtField);
                x += width + 0;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void fillBandForHDTReport(Hashtable columnWidths, JasperDesign jasperDesign, JRDesignBand columnHeaderBand, JRDesignBand detailBand, ArrayList attributeList, String reportType, String baseTable, int index, AdventNetResourceBundle rb, Locale locale, boolean isHDT, boolean isFullNameSelected, boolean showSerialNo, boolean isDetailPage, boolean addLogo) {
        boolean isSplitAllowed = false;
        pageWidth = 595;
        columnWidth = 535;
        pageHeight = 842;
        columnSpacing = 3;
        leftMargin = 30;
        rightMargin = 30;
        topMargin = 20;
        bottomMargin = 20;
        int x = 0;
        boolean y = false;
        int width = columnWidth / attributeList.size();
        normalSize = 9;
        groupPad = 10;
        try {
            columnHeaderBand.setHeight(60);
            detailBand.setHeight(30);
            JRFont reportPDFFont = JRFieldDesignUtil.getReportFont(reportType, locale);
            JRDesignReportFont columnFont = JRFieldDesignUtil.getJRDesignReportFont("Arial_normal", reportPDFFont, normalSize, true, false);
            JRDesignReportFont normalFont = JRFieldDesignUtil.getJRDesignReportFont("Arial_normal", reportPDFFont, normalSize, false, false);
            JRDesignReportFont pageFooterFont = JRFieldDesignUtil.getJRDesignReportFont("pagefooter_reportname", reportPDFFont, normalSize + 1, true, false);
            if (addLogo && reportType.toLowerCase().indexOf("csv") == -1) {
                JRFieldDesignUtil.addLogo(jasperDesign, reportType);
            }
            if (showSerialNo) {
                columnWidth -= 50;
                String displayName = rb.getString("admp.reports.common.export.Serial_no");
                JRFieldDesignUtil.addFieldToJasper(jasperDesign, columnHeaderBand, detailBand, columnFont, normalFont, x, 0, 50, 30, 60, displayName, "serialNo", rb, 1L, reportType, locale);
                x = 50;
            }
            String anchorName = "$F{ADMP_ROLE_NAME}";
            if (isHDT) {
                anchorName = "$F{FULL_NAME}";
            }
            for (int i = 0; i < attributeList.size(); ++i) {
                HashMap attributeProp = (HashMap)attributeList.get(i);
                String columnName1 = (String)attributeProp.get("COL_NAME");
                String displayName = null;
                displayName = (String)attributeProp.get("COLUMN_NAME");
                displayName = rb.getString(displayName);
                if (columnWidths != null && columnWidths.get(columnName1) != null) {
                    width = (Integer)columnWidths.get(columnName1);
                }
                Class<String> classType = String.class;
                JRDesignField field = new JRDesignField();
                field.setName(columnName1);
                field.setValueClass(String.class);
                jasperDesign.addField((JRField)field);
                JRDesignStaticText txt = JRFieldDesignUtil.getJRDesignStaticText(x, 0, width, 60, columnFont, new Color(255, 255, 255), new Color(0, 0, 0), (byte)1, (byte)2);
                txt.setMode((byte)1);
                txt.setStretchType((byte)1);
                txt.setPositionType((byte)2);
                txt.setKey(columnName1);
                txt.setPrintRepeatedValues(true);
                txt.setRemoveLineWhenBlank(false);
                txt.setPrintInFirstWholeBand(false);
                txt.setPrintWhenDetailOverflows(false);
                JRBaseBox box = new JRBaseBox();
                box.setTopBorder((byte)5);
                box.setTopBorderColor(new Color(155, 166, 109));
                box.setLeftBorder((byte)5);
                box.setLeftBorderColor(new Color(155, 166, 109));
                box.setRightBorder((byte)5);
                box.setRightBorderColor(new Color(155, 166, 109));
                box.setBottomBorder((byte)1);
                box.setBottomBorderColor(new Color(155, 166, 109));
                box.setLeftPadding(5);
                box.setTopPadding(2);
                txt.setBox((JRBox)box);
                txt.setBackcolor(new Color(239, 239, 231));
                txt.setForecolor(Color.BLACK);
                txt.setText(displayName);
                if (reportType.toLowerCase().indexOf("xlsx") != -1 || reportType.toLowerCase().indexOf("csv") != -1) {
                    JRDesignExpression express = new JRDesignExpression();
                    express.setValueClass(Boolean.class);
                    express.setText("$V{PAGE_NUMBER}.intValue() == 1 ? Boolean.TRUE : Boolean.FALSE");
                    columnHeaderBand.setPrintWhenExpression((JRExpression)express);
                }
                columnHeaderBand.addElement((JRDesignElement)txt);
                Color detailsFieldColor = null;
                detailsFieldColor = new Color(0, 0, 0);
                if (columnName1.equalsIgnoreCase("FULL_NAME") || !isHDT && columnName1.equalsIgnoreCase("ADMP_ROLE_NAME")) {
                    detailsFieldColor = new Color(54, 91, 129);
                }
                JRDesignTextField txtField = JRFieldDesignUtil.getJRDesignTextField(x, 0, width, 30, normalFont, new Color(255, 255, 255), detailsFieldColor, (byte)1, (byte)1);
                txtField.setStyledText(true);
                txtField.setMarkup("html");
                txtField.setBox((JRBox)box);
                detailBand.setSplitAllowed(false);
                txtField.setPrintWhenDetailOverflows(false);
                txtField.setPrintRepeatedValues(true);
                txtField.setPrintInFirstWholeBand(false);
                if (!(reportType.equalsIgnoreCase("xlsx") || isDetailPage || isHDT && !isFullNameSelected)) {
                    JRDesignExpression exp11 = new JRDesignExpression();
                    exp11.setValueClass(String.class);
                    String tmpval = anchorName;
                    exp11.setText(tmpval);
                    txtField.setHyperlinkType((byte)3);
                    txtField.setHyperlinkAnchorExpression((JRExpression)exp11);
                    JRDesignExpression exp33 = new JRDesignExpression();
                    exp33.setValueClass(String.class);
                    exp33.setText(anchorName + "+\"_reverse\"");
                    txtField.setAnchorNameExpression((JRExpression)exp33);
                }
                JRFieldDesignUtil.setDesignExpression(detailBand, (String)attributeProp.get("COL_NAME"), rb, box, txtField, width, x, reportPDFFont);
                detailBand.addElement((JRDesignElement)txtField);
                x += width + 0;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void fillBand(Hashtable columnWidths, JasperDesign jasperDesign, JRDesignBand columnHeaderBand, JRDesignBand detailBand, ArrayList attributeList, String reportType, AdventNetResourceBundle rb, Long loginId, Locale locale, ArrayList subReportList) {
        boolean isSplitAllowed = false;
        columnWidth = jasperDesign.getColumnWidth();
        columnSpacing = 0;
        leftMargin = 30;
        rightMargin = 30;
        topMargin = 20;
        bottomMargin = 20;
        int x = 0;
        boolean y = false;
        int width = columnWidth / attributeList.size();
        normalSize = 9;
        groupPad = 10;
        try {
            int i;
            JRDesignBand headerBand = new JRDesignBand();
            JRDesignBand detailBand1 = new JRDesignBand();
            ((JRDesignSection)jasperDesign.getDetailSection()).addBand((JRBand)headerBand);
            ((JRDesignSection)jasperDesign.getDetailSection()).addBand((JRBand)detailBand1);
            headerBand.setHeight(30);
            detailBand1.setHeight(30);
            columnHeaderBand.setHeight(0);
            if (loginId == null) {
                loginId = DelegationUtil.ADMIN_LOGIN_ID;
            }
            if (reportType.toLowerCase().indexOf("csv") == -1) {
                JRFieldDesignUtil.addLogo(jasperDesign, reportType);
            }
            JRBaseBox frameBox = new JRBaseBox();
            frameBox.setLeftBorder((byte)5);
            frameBox.setLeftBorderColor(new Color(216, 224, 230));
            frameBox.setRightBorder((byte)5);
            frameBox.setRightBorderColor(new Color(216, 224, 230));
            JRDesignFrame frame = new JRDesignFrame();
            frame.setX(0);
            frame.setY(0);
            frame.setWidth(columnWidth);
            frame.setHeight(30);
            frame.setStretchType(StretchTypeEnum.RELATIVE_TO_BAND_HEIGHT);
            frame.setBackcolor(new Color(51, 51, 51));
            frame.setBox((JRBox)frameBox);
            headerBand.addElement((JRDesignElement)frame);
            JRDesignFrame frame1 = new JRDesignFrame();
            frame1.setX(0);
            frame1.setY(0);
            frame1.setWidth(columnWidth);
            frame1.setHeight(30);
            frame1.setStretchType(StretchTypeEnum.RELATIVE_TO_BAND_HEIGHT);
            frame1.setBox((JRBox)frameBox);
            detailBand1.addElement((JRDesignElement)frame1);
            JRDesignReportFont columnFont = null;
            JRDesignReportFont normalFont = null;
            JRDesignReportFont pageFooterFont = null;
            JRFont reportPDFFont = JRFieldDesignUtil.getReportFont(reportType, locale);
            columnFont = JRFieldDesignUtil.getJRDesignReportFont("Arial_normal", reportPDFFont, normalSize, true, false);
            normalFont = JRFieldDesignUtil.getJRDesignReportFont("Arial_normal", reportPDFFont, normalSize, false, false);
            pageFooterFont = JRFieldDesignUtil.getJRDesignReportFont("pagefooter_reportname", reportPDFFont, normalSize + 1, true, false);
            for (i = 0; i < attributeList.size(); ++i) {
                Properties attributeProp = (Properties)attributeList.get(i);
                Integer columnName1 = (Integer)attributeProp.get("ATTRIB_ID");
                if (columnName1.equals(new Integer(11150))) continue;
                String displayName = null;
                if (reportType.toLowerCase().equals("csvde")) {
                    displayName = attributeProp.getProperty("ATTRIB_LDAP_NAME");
                } else {
                    displayName = attributeProp.getProperty("ATTRIB_DISP_NAME");
                    displayName = rb.getString(displayName);
                }
                String tableName = attributeProp.getProperty("TABLE_NAME");
                String columnName = attributeProp.getProperty("ATTRIB_COLUMN_NAME");
                if ((displayName.equals("lockoutTime") || displayName.equals("memberOf") || displayName.equals("lastLogon") || displayName.equals("badPasswordTime") || displayName.equals("badPwdCount") || displayName.equals("lastLogoff") || displayName.equals("pwdLastSet")) && reportType.toLowerCase().equals("csvde")) continue;
                if (columnWidths != null && columnWidths.get(columnName1) != null) {
                    width = (Integer)columnWidths.get(columnName1);
                }
                JRDesignField field = new JRDesignField();
                field.setName(columnName1.toString());
                field.setValueClass(String.class);
                jasperDesign.addField((JRField)field);
                JRDesignStaticText txt = JRFieldDesignUtil.getJRDesignStaticText(x, 0, width, 30, columnFont, new Color(255, 255, 255), new Color(0, 0, 0), (byte)1, (byte)2);
                txt.setMode((byte)1);
                txt.setStretchType((byte)1);
                txt.setPositionType((byte)2);
                txt.setKey(columnName1.toString());
                txt.setPrintRepeatedValues(true);
                txt.setRemoveLineWhenBlank(false);
                txt.setPrintInFirstWholeBand(false);
                txt.setPrintWhenDetailOverflows(false);
                JRBaseBox box = new JRBaseBox();
                box.setTopBorder((byte)5);
                box.setTopBorderColor(new Color(216, 224, 230));
                box.setBottomBorder((byte)5);
                box.setBottomBorderColor(new Color(216, 224, 230));
                box.setLeftPadding(8);
                txt.setBox((JRBox)box);
                txt.setBackcolor(new Color(107, 119, 126));
                txt.setForecolor(Color.WHITE);
                txt.setText(displayName);
                if (reportType.toLowerCase().indexOf("xls") != -1 || reportType.toLowerCase().indexOf("csv") != -1) {
                    JRDesignExpression express = new JRDesignExpression();
                    express.setValueClass(Boolean.class);
                    express.setText("$V{PAGE_NUMBER}.intValue() == 1 ? Boolean.TRUE : Boolean.FALSE");
                    columnHeaderBand.setPrintWhenExpression((JRExpression)express);
                }
                frame.addElement((JRElement)txt);
                JRDesignTextField txtField = JRFieldDesignUtil.getJRDesignTextField(x, 0, width, 30, normalFont, new Color(255, 255, 255), new Color(0, 0, 0), (byte)1, (byte)2);
                txtField.setBox((JRBox)box);
                detailBand1.setSplitAllowed(true);
                if (reportType.toLowerCase().indexOf("xls") != -1) {
                    txtField.setMaxCharsForOverflow(30000L);
                    txtField.setPrintWhenDetailOverflows(false);
                } else {
                    txtField.setPrintWhenDetailOverflows(true);
                }
                txtField.setPrintRepeatedValues(true);
                txtField.setPrintInFirstWholeBand(true);
                if (columnName1.equals(new Integer(1037))) {
                    txtField.setStyledText(true);
                    txtField.setMarkup("html");
                }
                JRDesignExpression exp = new JRDesignExpression();
                exp.setValueClass(String.class);
                exp.setText("$F{" + columnName1 + "}");
                txtField.setExpression((JRExpression)exp);
                frame1.addElement((JRElement)txtField);
                x += width + 0;
            }
            for (i = 0; i < subReportList.size(); ++i) {
                Properties subReportProp = (Properties)subReportList.get(i);
                String name = (String)subReportProp.get("NAME");
                JRDesignField field = new JRDesignField();
                field.setName(name);
                field.setValueClass(JRDataSource.class);
                jasperDesign.addField((JRField)field);
                JasperDesign subJasperDesign = (JasperDesign)subReportProp.get("SUBREPORT_DESIGN");
                JRDesignSubreport jasperReport = new JRDesignSubreport((JRDefaultStyleProvider)subJasperDesign);
                String jasperDir = System.getProperty("server.home") + File.separator + "webapps" + File.separator + "adsm" + File.separator + "jasperreports" + File.separator + "jasper";
                String des = jasperDir + File.separator + name + ".jasper";
                JRDesignExpression exp = new JRDesignExpression();
                exp.setValueClass(JRDataSource.class);
                exp.setText("$F{" + name + "}");
                JRDesignExpression exp1 = new JRDesignExpression();
                exp1.setValueClass(String.class);
                des = des.replace("\\", "\\\\");
                exp1.setText("\"" + des + "\"");
                jasperReport.setDataSourceExpression((JRExpression)exp);
                jasperReport.setExpression((JRExpression)exp1);
                JRDesignFrame subFrame = new JRDesignFrame();
                subFrame.setX(0);
                subFrame.setY(0);
                subFrame.setWidth(columnWidth);
                subFrame.setHeight(60);
                subFrame.setStretchType(StretchTypeEnum.RELATIVE_TO_BAND_HEIGHT);
                if (i == subReportList.size() - 1) {
                    frameBox.setBottomBorder((byte)5);
                    frameBox.setBottomBorderColor(new Color(216, 224, 230));
                }
                subFrame.setBox((JRBox)frameBox);
                JRDesignBand subReportBand = new JRDesignBand();
                subReportBand.setHeight(60);
                subReportBand.addElement((JRDesignElement)subFrame);
                subFrame.addElement((JRElement)jasperReport);
                ((JRDesignSection)jasperDesign.getDetailSection()).addBand((JRBand)subReportBand);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void fillBandSubReport(Hashtable columnWidths, JasperDesign jasperDesign, JRDesignBand columnHeaderBand, JRDesignBand detailBand, ArrayList attributeList, String reportType, AdventNetResourceBundle rb, Long loginId, Locale locale, String subReportFile, String heading, boolean flexWidth) {
        boolean isSplitAllowed = false;
        pageWidth = 595;
        pageHeight = 842;
        columnWidth = jasperDesign.getColumnWidth();
        columnSpacing = 0;
        leftMargin = 30;
        rightMargin = 30;
        topMargin = 20;
        bottomMargin = 20;
        int x = 0;
        boolean y = false;
        int width = columnWidth / attributeList.size();
        normalSize = 9;
        groupPad = 10;
        try {
            columnHeaderBand.setHeight(30);
            detailBand.setHeight(30);
            detailBand.setSplitType(SplitTypeEnum.PREVENT);
            JRStyle[] styles = jasperDesign.getStyles();
            JRDesignReportFont columnFont = null;
            JRDesignReportFont normalFont = null;
            JRDesignReportFont pageFooterFont = null;
            JRFont reportPDFFont = JRFieldDesignUtil.getReportFont(reportType, locale);
            columnFont = JRFieldDesignUtil.getJRDesignReportFont("Arial_normal", reportPDFFont, normalSize, true, false);
            normalFont = JRFieldDesignUtil.getJRDesignReportFont("Arial_normal", reportPDFFont, normalSize, false, false);
            pageFooterFont = JRFieldDesignUtil.getJRDesignReportFont("pagefooter_reportname", reportPDFFont, normalSize + 1, true, false);
            JRDesignBand titleBand = (JRDesignBand)jasperDesign.getTitle();
            titleBand.setHeight(30);
            JRDesignStaticText headTxt = JRFieldDesignUtil.getJRDesignStaticText(x, 0, width, 30, columnFont, new Color(255, 255, 255), new Color(0, 0, 0), (byte)1, (byte)2);
            headTxt.setMode((byte)1);
            headTxt.setStretchType((byte)1);
            headTxt.setPositionType((byte)2);
            headTxt.setForecolor(Color.BLACK);
            headTxt.setText(heading);
            titleBand.addElement((JRDesignElement)headTxt);
            JasperDesign subJasperDesign = JRXmlLoader.load((String)subReportFile);
            subJasperDesign.setPageWidth(columnWidth - width);
            subJasperDesign.setPageHeight(30);
            subJasperDesign.setColumnWidth(columnWidth - width);
            subJasperDesign.setTopMargin(0);
            subJasperDesign.setBottomMargin(0);
            subJasperDesign.setLeftMargin(0);
            subJasperDesign.setRightMargin(0);
            JRDesignBand dBand = (JRDesignBand)subJasperDesign.getDetail();
            dBand.setHeight(30);
            if (loginId == null) {
                loginId = DelegationUtil.ADMIN_LOGIN_ID;
            }
            JRBaseBox box = new JRBaseBox();
            box.setTopBorder((byte)5);
            box.setTopBorderColor(new Color(216, 224, 230));
            box.setLeftBorder((byte)5);
            box.setLeftBorderColor(new Color(216, 224, 230));
            box.setBottomBorder((byte)5);
            box.setBottomBorderColor(new Color(216, 224, 230));
            JRDesignFrame frame = new JRDesignFrame();
            frame.setX(0);
            frame.setY(0);
            if (flexWidth) {
                frame.setWidth(columnWidth - 12);
            } else {
                frame.setWidth(columnWidth);
            }
            frame.setHeight(30);
            frame.setStretchType(StretchTypeEnum.RELATIVE_TO_BAND_HEIGHT);
            frame.setBox((JRBox)box);
            frame.setStyle(styles[0]);
            detailBand.addElement((JRDesignElement)frame);
            box = new JRBaseBox();
            box.setTopBorder((byte)5);
            box.setTopBorderColor(new Color(216, 224, 230));
            box.setLeftBorder((byte)5);
            box.setLeftBorderColor(new Color(216, 224, 230));
            box.setRightBorder((byte)5);
            box.setRightBorderColor(new Color(216, 224, 230));
            box.setBottomBorder((byte)5);
            box.setBottomBorderColor(new Color(216, 224, 230));
            box.setLeftPadding(5);
            box.setTopPadding(5);
            box.setBottomPadding(5);
            for (int i = 0; i < attributeList.size(); ++i) {
                Properties attributeProp = (Properties)attributeList.get(i);
                Integer columnName1 = (Integer)attributeProp.get("ATTRIB_ID");
                if (columnName1.equals(new Integer(11150))) continue;
                String displayName = null;
                if (reportType.toLowerCase().equals("csvde")) {
                    displayName = attributeProp.getProperty("ATTRIB_LDAP_NAME");
                } else {
                    displayName = attributeProp.getProperty("ATTRIB_DISP_NAME");
                    displayName = rb.getString(displayName);
                }
                String tableName = attributeProp.getProperty("TABLE_NAME");
                String columnName = attributeProp.getProperty("ATTRIB_COLUMN_NAME");
                if (!((displayName.equals("lockoutTime") || displayName.equals("memberOf") || displayName.equals("lastLogon") || displayName.equals("badPasswordTime") || displayName.equals("badPwdCount") || displayName.equals("lastLogoff") || displayName.equals("pwdLastSet")) && reportType.toLowerCase().equals("csvde"))) {
                    if (columnWidths != null && columnWidths.get(columnName1) != null) {
                        width = (Integer)columnWidths.get(columnName1);
                    }
                    JRDesignField field = new JRDesignField();
                    field.setName(columnName1.toString());
                    field.setValueClass(String.class);
                    if (i == 0) {
                        jasperDesign.addField((JRField)field);
                        JRDesignField field1 = new JRDesignField();
                        field1.setName("permission");
                        field1.setValueClass(JRRewindableDataSource.class);
                        jasperDesign.addField((JRField)field1);
                    } else {
                        subJasperDesign.addField((JRField)field);
                    }
                    JRDesignStaticText txt = JRFieldDesignUtil.getJRDesignStaticText(x, 0, width, 30, columnFont, new Color(255, 255, 255), new Color(0, 0, 0), (byte)1, (byte)2);
                    txt.setMode((byte)1);
                    txt.setStretchType((byte)1);
                    txt.setPositionType((byte)2);
                    txt.setKey(columnName1.toString());
                    txt.setPrintRepeatedValues(true);
                    txt.setRemoveLineWhenBlank(false);
                    txt.setPrintInFirstWholeBand(false);
                    txt.setPrintWhenDetailOverflows(false);
                    txt.setBox((JRBox)box);
                    txt.setBackcolor(new Color(218, 225, 231));
                    txt.setForecolor(Color.BLACK);
                    txt.setText(displayName);
                    if (reportType.toLowerCase().indexOf("xls") != -1 || reportType.toLowerCase().indexOf("csv") != -1) {
                        JRDesignExpression express = new JRDesignExpression();
                        express.setValueClass(Boolean.class);
                        express.setText("$V{PAGE_NUMBER}.intValue() == 1 ? Boolean.TRUE : Boolean.FALSE");
                        columnHeaderBand.setPrintWhenExpression((JRExpression)express);
                    }
                    columnHeaderBand.addElement((JRDesignElement)txt);
                    JRDesignTextField txtField = JRFieldDesignUtil.getJRDesignTextField(x, 0, width, 30, normalFont, new Color(255, 255, 255), new Color(0, 0, 0), (byte)1, (byte)1);
                    if (reportType.toLowerCase().indexOf("xls") != -1) {
                        txtField.setMaxCharsForOverflow(30000L);
                        txtField.setPrintWhenDetailOverflows(false);
                    } else {
                        txtField.setPrintWhenDetailOverflows(true);
                    }
                    if (columnName1.equals(new Integer(1037))) {
                        txtField.setStyledText(true);
                        txtField.setMarkup("html");
                    }
                    txtField.setPrintInFirstWholeBand(true);
                    txtField.setMode((byte)2);
                    if (i == 0) {
                        txtField.setPrintRepeatedValues(false);
                        txtField.setPrintWhenDetailOverflows(false);
                        txtField.setStretchType(StretchTypeEnum.RELATIVE_TO_TALLEST_OBJECT);
                        JRDesignExpression exp = new JRDesignExpression();
                        exp.setValueClass(String.class);
                        exp.setText("$F{" + columnName1 + "}");
                        txtField.setExpression((JRExpression)exp);
                        frame.addElement((JRElement)txtField);
                        txtField.setBox((JRBox)box);
                    } else {
                        txtField.setPrintRepeatedValues(true);
                        txtField.setStretchType(StretchTypeEnum.RELATIVE_TO_TALLEST_OBJECT);
                        txtField.setBox((JRBox)box);
                        JRFieldDesignUtil.setDesignExpression(detailBand, (Integer)attributeProp.get("ATTRIB_ID"), rb, box, txtField, width, x, loginId, reportPDFFont);
                        dBand.addElement((JRDesignElement)txtField);
                    }
                }
                x += width + 0;
            }
            JRDesignSubreport jasperReport = new JRDesignSubreport((JRDefaultStyleProvider)subJasperDesign);
            String jasperDir = System.getProperty("server.home") + File.separator + "webapps" + File.separator + "adsm" + File.separator + "jasperreports" + File.separator + "jasper";
            String des = jasperDir + File.separator + jasperDesign.getName() + "_sub" + ".jasper";
            JRDesignExpression exp = new JRDesignExpression();
            exp.setValueClass(JRDataSource.class);
            exp.setText("$F{permission}");
            JRDesignExpression exp1 = new JRDesignExpression();
            exp1.setValueClass(String.class);
            des = des.replace("\\", "\\\\");
            exp1.setText("\"" + des + "\"");
            jasperReport.setDataSourceExpression((JRExpression)exp);
            jasperReport.setExpression((JRExpression)exp1);
            jasperReport.setStretchType(StretchTypeEnum.RELATIVE_TO_BAND_HEIGHT);
            jasperReport.setX(0);
            jasperReport.setHeight(30);
            frame.addElement((JRElement)jasperReport);
            JasperCompileManager.compileReportToFile((JasperDesign)subJasperDesign, (String)des);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Hashtable calculateWidthForAuditReport(ArrayList attributeList, ArrayList results, Hashtable multipleValuesSids, String reportType, String reportFormat) {
        int averageWidth;
        Hashtable<Integer, Integer> columnWidths = new Hashtable<Integer, Integer>();
        int totalWidth = 535;
        int detailsWidth = 80;
        int statusWidth = 90;
        if (reportFormat.equals("standard")) {
            totalWidth = 1500;
            detailsWidth = 500;
            statusWidth = 300;
        }
        int balanceWidth = totalWidth;
        if (attributeList.size() > 2) {
            balanceWidth = totalWidth - detailsWidth - statusWidth - 50;
            averageWidth = balanceWidth / (attributeList.size() - 2);
        } else {
            statusWidth = averageWidth = (balanceWidth = totalWidth - detailsWidth - 50);
        }
        for (int i = 0; i < attributeList.size(); ++i) {
            Properties attributeProp = (Properties)attributeList.get(i);
            Integer fname = (Integer)attributeProp.get("ATTRIB_ID");
            columnWidths.put(fname, new Integer(averageWidth));
        }
        columnWidths.put(new Integer(11150), new Integer(detailsWidth));
        columnWidths.put(new Integer(11149), new Integer(statusWidth));
        return columnWidths;
    }

    public static Hashtable calculateWidthForHDTReport(ArrayList attributeList) {
        Hashtable<String, Integer> columnWidths = new Hashtable<String, Integer>();
        int totalWidth = 485;
        int averageWidth = totalWidth / attributeList.size();
        for (int i = 0; i < attributeList.size(); ++i) {
            HashMap attributeProp = (HashMap)attributeList.get(i);
            String fname = (String)attributeProp.get("COL_NAME");
            columnWidths.put(fname, new Integer(averageWidth));
        }
        return columnWidths;
    }

    public static Hashtable calculateWidthForHDTDetails(ArrayList attributeList) {
        Hashtable<String, Integer> columnWidths = new Hashtable<String, Integer>();
        for (int i = 0; i < 3; ++i) {
            HashMap attributeProp = (HashMap)attributeList.get(i);
            String fname = (String)attributeProp.get("COL_NAME");
            if (i != 2) {
                columnWidths.put(fname, 100);
                continue;
            }
            columnWidths.put(fname, 335);
        }
        return columnWidths;
    }

    public static Hashtable calculateWidthForDelegationAuditReport(ArrayList attributeList, ArrayList results, Hashtable multipleValuesSids, String reportType, String reportFormat, Boolean showSerialNo, Boolean isPropsAvailabe) {
        Hashtable<Integer, Integer> columnWidths = new Hashtable<Integer, Integer>();
        int totalWidth = 535;
        int noOfColumns = attributeList.size();
        if (showSerialNo.booleanValue()) {
            totalWidth = 485;
        }
        if (isPropsAvailabe.booleanValue()) {
            ++noOfColumns;
        }
        int averageWidth = totalWidth / noOfColumns;
        if (reportFormat.equals("standard")) {
            totalWidth = 1500;
            if (showSerialNo.booleanValue()) {
                totalWidth = 1450;
            }
            int detailsWidth = 600;
            averageWidth = (totalWidth - detailsWidth) / (noOfColumns - 1);
        }
        for (int i = 0; i < attributeList.size(); ++i) {
            Properties attributeProp = (Properties)attributeList.get(i);
            Integer fname = (Integer)attributeProp.get("ATTRIB_ID");
            if (fname == 19005 && reportFormat.equals("standard")) {
                columnWidths.put(fname, 600);
                continue;
            }
            columnWidths.put(fname, new Integer(averageWidth));
        }
        return columnWidths;
    }

    public static void hideBand(JRDesignBand designBand) {
        JRElement[] elements = designBand.getElements();
        for (int i = 0; i < elements.length; ++i) {
            designBand.removeElement((JRDesignElement)elements[i]);
        }
        designBand.setHeight(0);
    }
}

