/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.reports;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.framework.EscapeUtil;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import com.adventnet.sym.adsm.security.server.ADSMPersUtil;
import com.adventnet.sym.adsm.security.server.util.DateTimeUtil;
import com.manageengine.ads.fw.ha.HAHandler;
import java.awt.Color;
import java.io.File;
import java.net.InetAddress;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.sf.jasperreports.engine.JRBox;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.base.JRBaseBox;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.design.JRDesignImage;
import net.sf.jasperreports.engine.design.JRDesignReportFont;
import net.sf.jasperreports.engine.design.JRDesignStaticText;
import net.sf.jasperreports.engine.design.JRDesignTextField;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;

public class JRFieldDesignUtil {
    private static boolean showSerialNo = JRFieldDesignUtil.getDBValue("EXPORT_SHOW_SERIAL_NO");
    private static boolean showSummary = JRFieldDesignUtil.getDBValue("EXPORT_SHOW_SUMMARY");
    private static boolean enableDescription = JRFieldDesignUtil.getDBValue("EXPORT_ENABLE_DESCRIPTION");
    private static int XLSX_SHEETNAME_MAX_LENGTH = 31;

    public static boolean getDBValue(String columnName) {
        boolean value = true;
        String dbValue = ADSMPersUtil.getSyMParameter((String)columnName);
        if (dbValue != null) {
            value = Boolean.valueOf(dbValue);
        }
        return value;
    }

    public static JRDesignReportFont getJRDesignReportFont(String name, JRFont reportPDFFont, int size, boolean bold, boolean isDefault) {
        JRDesignReportFont font = new JRDesignReportFont();
        font.setName(name);
        font.setDefault(isDefault);
        String fontName = reportPDFFont.getPdfFontName();
        String fontEncoding = reportPDFFont.getPdfEncoding();
        font.setFontName(fontName);
        font.setSize(size);
        font.setBold(bold);
        font.setPdfFontName(fontName);
        font.setPdfEncoding(fontEncoding);
        font.setPdfEmbedded(false);
        return font;
    }

    public static JRFont getDefaultReportFont() {
        JRDesignReportFont reportPDFFont = new JRDesignReportFont();
        reportPDFFont.setPdfFontName("Helvetica");
        reportPDFFont.setPdfEncoding("Cp1252");
        return reportPDFFont;
    }

    public static JRFont getReportFont(String reportType, Locale locale) {
        JRDesignReportFont reportPDFFont = new JRDesignReportFont();
        reportPDFFont = reportType.toLowerCase().equals("pdf") ? JRFieldDesignUtil.getPDFExporterFont(locale) : JRFieldDesignUtil.getDefaultReportFont();
        return reportPDFFont;
    }

    public static JRFont getPDFExporterFont(Locale locale) {
        JRDesignReportFont font = new JRDesignReportFont();
        try {
            String pdfEncoding = "CP1252";
            String pdfFont = "Helvetica";
            String lang = locale.getLanguage();
            if ("ja".equals(lang)) {
                pdfFont = "KozMinPro-Regular";
                pdfEncoding = "UniJIS-UCS2-H";
            } else if ("zh".equals(lang)) {
                pdfFont = "STSong-Light";
                pdfEncoding = "UniGB-UCS2-H";
            } else if ("pl".equals(lang)) {
                pdfEncoding = "Cp1250";
            } else if ("ko".equals(lang)) {
                pdfFont = "HYGoThic-Medium";
                pdfEncoding = "UniKS-UCS2-H";
            } else if ("tr".equals(lang)) {
                pdfEncoding = "Cp1254";
            } else if ("ar".equals(lang)) {
                pdfFont = JRFieldDesignUtil.getLocalFontPath("arial.ttf");
                pdfEncoding = "Identity-H";
            }
            font.setPdfEncoding(pdfEncoding);
            font.setPdfFontName(pdfFont);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return font;
    }

    private static String getLocalFontPath(String fontName) {
        String fontPath = "";
        try {
            fontPath = System.getenv("WINDIR");
            fontPath = fontPath.replace("\\", "/");
            fontPath = fontPath.concat("/Fonts/" + fontName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return fontPath;
    }

    public static void setPDFFontForPageHeaderTitleBand(String reportType, JasperDesign jasperDesign, Locale locale) {
        if (reportType.toLowerCase().indexOf("pdf") != -1) {
            JRFont reportPDFFont = JRFieldDesignUtil.getPDFExporterFont(locale);
            JRDesignReportFont normalFont = JRFieldDesignUtil.getJRDesignReportFont("Arial_normal", reportPDFFont, 10, false, false);
            JRDesignBand titleBand = (JRDesignBand)jasperDesign.getTitle();
            JRElement[] elements = titleBand.getElements();
            for (int i = 0; i < elements.length; ++i) {
                if (!(elements[i] instanceof JRDesignTextField)) continue;
                ((JRDesignTextField)elements[i]).setFont((JRFont)normalFont);
            }
            JRDesignBand columnHeaderBand = (JRDesignBand)jasperDesign.getColumnHeader();
            JRElement[] columnHeaderelements = columnHeaderBand.getElements();
            for (int i = 0; i < columnHeaderelements.length; ++i) {
                if (!(columnHeaderelements[i] instanceof JRDesignTextField)) continue;
                ((JRDesignTextField)columnHeaderelements[i]).setFont((JRFont)normalFont);
            }
            JRDesignBand detailBand = (JRDesignBand)jasperDesign.getDetail();
            JRElement[] detailelements = detailBand.getElements();
            for (int i = 0; i < detailelements.length; ++i) {
                if (!(detailelements[i] instanceof JRDesignTextField)) continue;
                ((JRDesignTextField)detailelements[i]).setFont((JRFont)normalFont);
            }
            JRDesignBand pageHeaderBand = (JRDesignBand)jasperDesign.getPageHeader();
            JRElement[] elements1 = pageHeaderBand.getElements();
            for (int i = 0; i < elements1.length; ++i) {
                if (!(elements1[i] instanceof JRDesignTextField)) continue;
                ((JRDesignTextField)elements1[i]).setFont((JRFont)normalFont);
            }
            JRDesignBand pageFooterBand = (JRDesignBand)jasperDesign.getPageFooter();
            JRElement[] elements2 = pageFooterBand.getElements();
            for (int i = 0; i < elements2.length; ++i) {
                if (!(elements2[i] instanceof JRDesignTextField)) continue;
                ((JRDesignTextField)elements2[i]).setFont((JRFont)normalFont);
            }
        }
    }

    public static JRDesignStaticText getJRDesignStaticText(int x, int y, int width, int height, JRDesignReportFont font, Color backColor, Color foreColor, byte hAlign, byte vAlign) {
        JRDesignStaticText stxt = new JRDesignStaticText();
        stxt.setX(x);
        stxt.setY(y);
        stxt.setWidth(width);
        stxt.setHeight(height);
        stxt.setMode((byte)1);
        stxt.setPositionType((byte)2);
        JRPropertiesMap propMap = stxt.getPropertiesMap();
        propMap.setProperty("net.sf.jasperreports.print.keep.full.text", "true");
        if (font != null) {
            stxt.setFont((JRFont)font);
        }
        if (hAlign >= 0) {
            stxt.setTextAlignment(hAlign);
        }
        if (vAlign >= 0) {
            stxt.setVerticalAlignment(vAlign);
        }
        if (backColor != null) {
            stxt.setBackcolor(backColor);
        }
        if (foreColor != null) {
            stxt.setForecolor(foreColor);
        }
        return stxt;
    }

    public static JRDesignTextField getJRDesignTextField(int x, int y, int width, int height, JRDesignReportFont font, Color backColor, Color foreColor, byte hAlign, byte vAlign) {
        return JRFieldDesignUtil.getJRDesignTextField(x, y, width, height, font, backColor, foreColor, hAlign, vAlign, true);
    }

    public static JRDesignTextField getJRDesignTextField(int x, int y, int width, int height, JRDesignReportFont font, Color backColor, Color foreColor, byte hAlign, byte vAlign, boolean isStrech) {
        JRDesignTextField textField = new JRDesignTextField();
        textField.setBlankWhenNull(true);
        textField.setX(x);
        textField.setY(y);
        textField.setWidth(width);
        textField.setHeight(height);
        textField.setMode((byte)1);
        textField.setStretchWithOverflow(true);
        if (isStrech) {
            textField.setStretchType((byte)1);
        }
        textField.setPositionType((byte)2);
        if (font != null) {
            textField.setFont((JRFont)font);
        }
        if (hAlign >= 0) {
            textField.setTextAlignment(hAlign);
        }
        if (vAlign >= 0) {
            textField.setVerticalAlignment(vAlign);
        }
        if (backColor != null) {
            textField.setBackcolor(backColor);
        }
        if (foreColor != null) {
            textField.setForecolor(foreColor);
        }
        return textField;
    }

    public static void setDesignExpression(JRDesignBand detailBand, String columnName1, AdventNetResourceBundle rb, JRBaseBox box, JRDesignTextField txtField, int width, int x, JRFont reportPDFFont) {
        try {
            JRDesignExpression exp = new JRDesignExpression();
            exp.setValueClass(String.class);
            exp.setText("$F{" + columnName1 + "}");
            txtField.setExpression((JRExpression)exp);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setDesignExpression(JRDesignBand detailBand, Integer columnName1, AdventNetResourceBundle rb, JRBaseBox box, JRDesignTextField txtField, int width, int x, Long loginId, JRFont reportPDFFont) {
        JRFieldDesignUtil.setDesignExpression(detailBand, columnName1, rb, box, txtField, width, x, loginId, reportPDFFont, false);
    }

    public static void setDesignExpression(JRDesignBand detailBand, Integer columnName1, AdventNetResourceBundle rb, JRBaseBox box, JRDesignTextField txtField, int width, int x, Long loginId, JRFont reportPDFFont, boolean isWorkflow) {
        try {
            JRDesignReportFont normalFont = JRFieldDesignUtil.getJRDesignReportFont("Arial_normal", reportPDFFont, 9, false, false);
            JRDesignExpression exp = new JRDesignExpression();
            exp.setValueClass(String.class);
            exp.setText("$F{" + columnName1 + "}");
            txtField.setExpression((JRExpression)exp);
            if (isWorkflow) {
                Integer[] wfAttribIds = new Integer[]{11003, 11004, 11005};
                if (Arrays.asList(wfAttribIds).contains(columnName1)) {
                    exp.setValueClass(Date.class);
                    Hashtable props = DateTimeUtil.getDateTimeFormats((Long)loginId);
                    String format = props.get("dateFormat") + " " + props.get("timeFormat");
                    txtField.setPattern(format);
                    exp.setText("DateTimeUtil.getDateFromLong(new String(\"" + format + "\"),Long.parseLong($F{" + columnName1 + "}),Long.parseLong(String.valueOf(" + loginId + ")))");
                    JRDesignExpression dateHandlingExp = new JRDesignExpression();
                    dateHandlingExp.setValueClass(Boolean.class);
                    dateHandlingExp.setText("$F{" + columnName1 + "}.equals(\"0\") || $F{" + columnName1 + "}.equals(\"-\")? Boolean.FALSE : Boolean.TRUE");
                    txtField.setPrintWhenExpression((JRExpression)dateHandlingExp);
                    JRDesignTextField staticTxtField = JRFieldDesignUtil.getJRDesignTextField(x, 0, width, 30, normalFont, new Color(255, 255, 255), new Color(0, 0, 0), (byte)1, (byte)2);
                    staticTxtField.setBox((JRBox)box);
                    staticTxtField.setPrintWhenDetailOverflows(true);
                    staticTxtField.setPrintRepeatedValues(true);
                    staticTxtField.setPrintInFirstWholeBand(true);
                    detailBand.addElement((JRDesignElement)staticTxtField);
                    JRDesignExpression staticTxtExp = new JRDesignExpression();
                    staticTxtExp.setValueClass(String.class);
                    staticTxtExp.setText("$F{" + columnName1 + "}");
                    staticTxtField.setExpression((JRExpression)staticTxtExp);
                }
                return;
            }
            Integer[] attribIds = new Integer[]{1039, 1040, 1029, 1035, 1030, 1044, 2008, 2009, 3011, 3012, 3019, 5039, 5040, 6023, 6024, 8005, 8006, 1022, 9054, 9056, 9057, 10013, 10014, 11013, 11014, 1192, 3033, 1033, 3025, 1150, 11146, 7036, 7037, 1031, 17039, 17040};
            if (Arrays.asList(attribIds).contains(columnName1)) {
                exp.setValueClass(Date.class);
                Hashtable props = DateTimeUtil.getDateTimeFormats((Long)loginId);
                String format = props.get("dateFormat") + " " + props.get("timeFormat");
                txtField.setPattern(format);
                if (columnName1 == 1031 || columnName1 == 11146 || columnName1 == 1150) {
                    exp.setText("DateTimeUtil.getDateFromLong(new String(\"" + format + "\"),Long.parseLong($F{" + columnName1 + "}),Long.parseLong(String.valueOf(" + loginId + ")))");
                } else {
                    exp.setText("DateTimeUtil.getDateFromFileTime(new String(\"" + format + "\"),Long.parseLong($F{" + columnName1 + "}),Long.parseLong(String.valueOf(" + loginId + ")))");
                }
                JRDesignExpression dateHandlingExp = new JRDesignExpression();
                dateHandlingExp.setValueClass(Boolean.class);
                dateHandlingExp.setText("$F{" + columnName1 + "}.equals(\"0\") || $F{" + columnName1 + "}.equals(\"-\")? Boolean.FALSE : Boolean.TRUE");
                txtField.setPrintWhenExpression((JRExpression)dateHandlingExp);
                JRDesignTextField staticTxtField = JRFieldDesignUtil.getJRDesignTextField(x, 0, width, 30, normalFont, new Color(255, 255, 255), new Color(0, 0, 0), (byte)1, (byte)2);
                staticTxtField.setBox((JRBox)box);
                staticTxtField.setPrintWhenDetailOverflows(true);
                staticTxtField.setPrintRepeatedValues(true);
                staticTxtField.setPrintInFirstWholeBand(true);
                detailBand.addElement((JRDesignElement)staticTxtField);
                JRDesignExpression staticTxtExp = new JRDesignExpression();
                staticTxtExp.setValueClass(String.class);
                staticTxtExp.setText("$F{" + columnName1 + "}");
                staticTxtField.setExpression((JRExpression)staticTxtExp);
                if (columnName1.equals(new Integer(1033))) {
                    dateHandlingExp.setText("$F{" + columnName1 + "}.equals(\"0\") || $F{" + columnName1 + "}.equals(\"-\")? Boolean.FALSE : Boolean.TRUE");
                    String defaultValue = rb.getString("admp.reports.common.reportresulttxt.must_change_at_next_logon");
                    staticTxtExp.setText("\"" + defaultValue + "\"");
                } else if (columnName1.equals(new Integer(17039)) || columnName1.equals(new Integer(17040))) {
                    dateHandlingExp.setText("DateTimeUtil.isLong($F{" + columnName1 + "})?Boolean.TRUE :Boolean.FALSE");
                } else if (columnName1.equals(new Integer(1150))) {
                    dateHandlingExp.setText("$F{" + columnName1 + "}.equals(\"0\") || $F{" + columnName1 + "}.equals(\"-1\") || $F{" + columnName1 + "}.equals(\"-\")? Boolean.FALSE : Boolean.TRUE");
                    JRDesignExpression exp1 = new JRDesignExpression();
                    exp1.setValueClass(String.class);
                    exp1.setText("$F{" + columnName1 + "}.equals(\"0\")? \"" + rb.getString("admp.reports.common.reportresulttxt.must_change_at_next_logon") + "\": ($F{" + columnName1 + "}.equals(\"-1\")?\"" + rb.getString("admp.reports.user.pwd_exp_date.never_expires") + "\":\"-\")");
                    staticTxtField.setExpression((JRExpression)exp1);
                } else if (columnName1.equals(new Integer(1031))) {
                    exp.setText("DateTimeUtil.getDateFormat(new Long(" + loginId + ")).parse($F{" + columnName1 + "})");
                    dateHandlingExp.setText("$F{" + columnName1 + "}.equals(\"" + rb.getString("admp.reports.common.customized_column_values.end_of_yesterday") + "\") || $F{" + columnName1 + "}.equals(\"" + rb.getString("admp.reports.common.customized_column_values.end_of_today") + "\") || $F{" + columnName1 + "}.equals(\"" + rb.getString("admp.reports.user.account_exp_date.never_expires") + "\") || $F{" + columnName1 + "}.equals(\"-\")? Boolean.FALSE : Boolean.TRUE");
                    JRDesignExpression exp1 = new JRDesignExpression();
                    exp1.setValueClass(String.class);
                    exp1.setText("$F{" + columnName1 + "}.equals(\"-\")?\"-\":$F{" + columnName1 + "}");
                    staticTxtField.setExpression((JRExpression)exp1);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void addFieldToJasper(JasperDesign jasperDesign, JRDesignBand columnHeaderBand, JRDesignBand detailBand, JRDesignReportFont columnFont, JRDesignReportFont normalFont, int x, int y, int width, int height, int columnHeight, String displayName, String fieldName, AdventNetResourceBundle rb, Long loginId, String reportType, Locale locale) throws Exception {
        if (fieldName == null) {
            fieldName = displayName;
        }
        JRDesignStaticText txt = JRFieldDesignUtil.getJRDesignStaticText(x, 0, width, columnHeight, columnFont, new Color(255, 255, 255), new Color(0, 0, 0), (byte)1, (byte)2);
        txt.setMode((byte)1);
        txt.setStretchType((byte)1);
        txt.setPositionType((byte)2);
        txt.setKey(displayName.toString());
        txt.setPrintRepeatedValues(true);
        txt.setRemoveLineWhenBlank(false);
        txt.setPrintInFirstWholeBand(false);
        txt.setPrintWhenDetailOverflows(false);
        JRBaseBox box = new JRBaseBox();
        box.setTopBorder((byte)5);
        box.setTopBorderColor(new Color(155, 166, 109));
        box.setLeftBorder((byte)5);
        box.setLeftBorderColor(new Color(155, 166, 109));
        box.setRightBorder((byte)5);
        box.setRightBorderColor(new Color(155, 166, 109));
        box.setBottomBorder((byte)1);
        box.setBottomBorderColor(new Color(155, 166, 109));
        box.setLeftPadding(1);
        txt.setBox((JRBox)box);
        txt.setBackcolor(new Color(239, 239, 231));
        txt.setForecolor(Color.BLACK);
        txt.setText(displayName);
        columnHeaderBand.addElement((JRDesignElement)txt);
        JRDesignTextField txtField = JRFieldDesignUtil.getJRDesignTextField(x, 0, width, height, normalFont, new Color(255, 255, 255), new Color(0, 0, 0), (byte)1, (byte)2);
        JRDesignField field = new JRDesignField();
        field.setName(fieldName.toString());
        field.setValueClass(String.class);
        jasperDesign.addField((JRField)field);
        JRDesignExpression exp = new JRDesignExpression();
        exp.setValueClass(String.class);
        exp.setText("$F{" + fieldName + "}");
        txtField.setBox((JRBox)box);
        txtField.setExpression((JRExpression)exp);
        detailBand.setSplitAllowed(false);
        txtField.setPrintWhenDetailOverflows(true);
        txtField.setPrintRepeatedValues(true);
        txtField.setPrintInFirstWholeBand(true);
        detailBand.addElement((JRDesignElement)txtField);
    }

    public static String getLogoPath(String logoPath, boolean isHtml) {
        String hostName = null;
        String port = System.getProperty("http.port");
        try {
            if (isHtml) {
                String productName = com.manageengine.ads.fw.util.CommonUtil.getProductName();
                if (HAHandler.isHAEnabled((String)productName)) {
                    hostName = HAHandler.getVirtualHostName((String)productName);
                } else {
                    String url = CommonUtil.getLoadBalanceUrl();
                    if (url != null) {
                        URL aURL = new URL(url);
                        hostName = aURL.getHost();
                        port = Integer.toString(aURL.getPort());
                    } else {
                        InetAddress addr = InetAddress.getLocalHost();
                        hostName = addr.getHostName();
                    }
                }
                logoPath = "\"http://" + hostName + ":" + port + "/" + logoPath + "\"";
            } else {
                logoPath = "\"../webapps/adsm/" + logoPath + "\"";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return logoPath;
    }

    public static String getLogoPath(String reportType) {
        String logoPath = null;
        try {
            Hashtable logoDetails = ClientUtil.getPageProps(null);
            logoPath = (String)logoDetails.get("LOGO_PATH");
            logoPath = JRFieldDesignUtil.getLogoPath(logoPath, reportType.equalsIgnoreCase("html"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return logoPath;
    }

    public static void addLogo(JasperDesign jasperDesign, String reportType) {
        try {
            String logoPath;
            if (showSummary && (logoPath = JRFieldDesignUtil.getLogoPath(reportType)) != null) {
                File logoFile;
                if (!reportType.equalsIgnoreCase("html") && !(logoFile = new File(logoPath.replace("\"", ""))).exists()) {
                    return;
                }
                JRDesignBand titleBand = (JRDesignBand)jasperDesign.getTitle();
                if (titleBand.getHeight() == 0) {
                    titleBand.setHeight(45);
                }
                JRDesignImage image = new JRDesignImage(null);
                image.setX(0);
                image.setY(0);
                image.setWidth(200);
                image.setHeight(45);
                JRDesignExpression imgexpression = new JRDesignExpression();
                imgexpression.setValueClass(String.class);
                boolean isInline = false;
                if (reportType.equalsIgnoreCase("html")) {
                    image.setLazy(true);
                }
                List paramList = jasperDesign.getParametersList();
                for (JRParameter param : paramList) {
                    if (!param.getName().equalsIgnoreCase("logo")) continue;
                    isInline = true;
                    break;
                }
                if (isInline) {
                    imgexpression.setText("$P{logo}");
                } else {
                    imgexpression.setText(logoPath);
                }
                image.setExpression((JRExpression)imgexpression);
                titleBand.addElement((JRDesignElement)image);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getReportName(String reportName, AdventNetResourceBundle rb) {
        return JRFieldDesignUtil.getReportName(reportName, rb, false);
    }

    public static String getReportName(String reportName, AdventNetResourceBundle rb, boolean forFileName) {
        String repName = rb.getString(reportName);
        repName = forFileName ? CommonUtil.replaceInvalidCharsForFileName((String)repName) : JRFieldDesignUtil.getXlsxSheetName(repName);
        return repName;
    }

    public static void removeSplCharsFromSheetNames(String[] sheetNames) {
        for (int i = 0; i < sheetNames.length; ++i) {
            sheetNames[i] = JRFieldDesignUtil.getXlsxSheetName(sheetNames[i]);
        }
    }

    public static String getXlsxSheetName(String key) {
        int ind;
        if ((key = EscapeUtil.escSplCharsAsHTML((Object)CommonUtil.replaceInvalidCharsForXlsxSheetName((String)key))).length() > XLSX_SHEETNAME_MAX_LENGTH) {
            key = key.substring(0, XLSX_SHEETNAME_MAX_LENGTH);
        }
        if ((ind = key.lastIndexOf(38)) != -1 && ind > key.lastIndexOf(59)) {
            key = key.substring(0, ind);
        }
        return key;
    }

    public static void alignBands(String reportType, JasperDesign jasperDesign, Map inputParams) {
        if (!enableDescription || reportType.toLowerCase().indexOf("csv") != -1) {
            JRDesignBand titleBand = (JRDesignBand)jasperDesign.getTitle();
            JRElement[] elements = titleBand.getElements();
            for (int i = 0; i < elements.length; ++i) {
                titleBand.removeElement((JRDesignElement)elements[i]);
            }
            titleBand.setHeight(0);
            JRDesignBand pageHeaderBand = (JRDesignBand)jasperDesign.getPageHeader();
            JRElement[] elements1 = pageHeaderBand.getElements();
            for (int i = 0; i < elements1.length; ++i) {
                pageHeaderBand.removeElement((JRDesignElement)elements1[i]);
            }
            pageHeaderBand.setHeight(0);
        }
        if (reportType.toLowerCase().indexOf("xls") != -1 || reportType.toLowerCase().indexOf("csv") != -1) {
            JRDesignBand pageFooterBand = (JRDesignBand)jasperDesign.getPageFooter();
            JRElement[] elements2 = pageFooterBand.getElements();
            for (int i = 0; i < elements2.length; ++i) {
                pageFooterBand.removeElement((JRDesignElement)elements2[i]);
            }
            pageFooterBand.setHeight(0);
            inputParams.put("IS_IGNORE_PAGINATION", Boolean.TRUE);
        }
        if (!(reportType.toLowerCase().indexOf("html") == -1 && reportType.toLowerCase().indexOf("pdf") == -1 || inputParams.containsKey("IS_IGNORE_PAGINATION"))) {
            inputParams.put("IS_IGNORE_PAGINATION", Boolean.FALSE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Hashtable exportSettings() {
        Hashtable<String, Object> exportParams = new Hashtable<String, Object>();
        try {
            String[] params = new String[]{"EXPORT_PER_ROW_COUNT", "FIXED_EXPORT_WIDTH", "EXPORT_PAGE_SIZE"};
            Criteria crit = new Criteria(new Column("SystemParams", "PARAM_NAME"), (Object)params, 8);
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("SystemParams", crit);
            Iterator it = dataObj.getRows("SystemParams");
            while (it.hasNext()) {
                Row r = (Row)it.next();
                exportParams.put((String)r.get("PARAM_NAME"), r.get("PARAM_VALUE"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            return exportParams;
        }
    }

    public static boolean getShowSerialNo() {
        return showSerialNo;
    }

    public static boolean getShowSummary() {
        return showSummary;
    }

    public static boolean getEnableDescription() {
        return enableDescription;
    }

    public static String applyReportFileNamePatterns(Map inputParams, String reportFileName, String reportName) {
        HashMap<String, String> patternValuesMapping = new HashMap<String, String>();
        patternValuesMapping.put("%REPORTNAME%", reportName);
        String date = (String)inputParams.get("date");
        date = date.replace(":", ".");
        patternValuesMapping.put("%TIMESTAMP%", date);
        for (Map.Entry entry : patternValuesMapping.entrySet()) {
            reportFileName = reportFileName.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
        }
        return reportFileName;
    }

    public static int getPageColumnWidth(Hashtable exportParams, JasperDesign jasperDesign) {
        int pageWidth = 595;
        int pageHeight = 842;
        int columnWidth = 535;
        String exportPageSize = (String)exportParams.get("EXPORT_PAGE_SIZE");
        if (exportPageSize != null) {
            jasperDesign.setPageWidth(pageWidth);
            jasperDesign.setPageHeight(pageHeight);
            jasperDesign.setColumnWidth(columnWidth);
        }
        return jasperDesign.getColumnWidth();
    }

    public static String getImagePath(String reportType, String logo, AdventNetResourceBundle rb) {
        if (reportType.equalsIgnoreCase("csv")) {
            String rtn = "admp.mgmt.fc_layout_common.text_false";
            if (logo != null && !logo.equals("-")) {
                rtn = "admp.mgmt.fc_layout_common.text_true";
            }
            return rb.getString(rtn);
        }
        Object hostName = null;
        String logoPath = "../webapps/adsm/images/avatar.png";
        String port = System.getProperty("http.port");
        try {
            if (logo != null && !logo.equals("-")) {
                logoPath = logo.replaceAll("\\\\", "/");
            }
            if (reportType.equalsIgnoreCase("html")) {
                logoPath = logoPath.replaceAll("/", "\\\\");
                File file = new File(logoPath);
                return "data:" + Files.probeContentType(Paths.get(logoPath, new String[0])) + ";base64," + new String(Base64.encodeBase64((byte[])FileUtils.readFileToByteArray((File)file)), "UTF-8");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return logoPath;
    }
}

