/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.reports;

import com.adventnet.db.persistence.metadata.ColumnDefinition;
import com.adventnet.db.persistence.metadata.TableDefinition;
import com.adventnet.db.persistence.metadata.util.MetaDataUtil;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.AdmpInput;
import com.adventnet.sym.adsm.common.server.DomainInfoCache;
import com.adventnet.sym.adsm.common.server.ExchangePoliciesHandler;
import com.adventnet.sym.adsm.common.server.PolicyHandler;
import com.adventnet.sym.adsm.common.server.automation.ReportFilterConfig;
import com.adventnet.sym.adsm.common.server.helpdesk.ADMPAuthObject;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.reports.ReportAttributeHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportHandler;
import com.adventnet.sym.adsm.common.server.reports.UserAccountControl;
import com.adventnet.sym.adsm.common.server.usermanagement.UserMgmtUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DomainUtil;
import com.adventnet.sym.adsm.common.server.util.OUUtil;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import com.adventnet.sym.adsm.common.webclient.reports.AbstractListener;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.transformers.Transformers;
import com.adventnet.sym.adsm.common.webclient.util.ClientAuthorizationUtil;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import com.adventnet.sym.adsm.common.webclient.util.DirectoryObjectUtil;
import com.adventnet.sym.adsm.security.server.util.DateTimeUtil;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.struts.validator.DynaValidatorForm;
import org.json.JSONArray;
import org.json.JSONObject;

public class ListenerUtil {
    static Logger reportLogger = Logger.getLogger("ReportLogger");
    private static final ArrayList<String> dateTimeCols = new ArrayList<String>(Arrays.asList("WHEN_CREATED", "WHEN_CHANGED", "LAST_LOGON_TIME", "LAST_LOGON_TIMESTAMP", "LAST_LOGOFF_TIME", "BAD_PASSWORD_TIME", "ACCOUNT_LOCK_ON_TIME", "PASSWORD_LAST_SET", "CREATION_TIME", "LAST_ACCESS_TIME", "LAST_WRITE_TIME", "MODIFIED_TIME", "CREATED_ON", "CHANGED_ON", "LOCK_OUT_TIME"));

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ArrayList getDBCustomizedValues(String domainName, String columnName, String ldapName, Properties prop, AdventNetResourceBundle rb) {
        ArrayList values = (ArrayList)prop.get(ldapName);
        ArrayList ret = new ArrayList();
        if (values == null || values.size() == 0) {
            if (columnName.equalsIgnoreCase("WHEN_CREATED") || columnName.equalsIgnoreCase("WHEN_CHANGED") || columnName.equalsIgnoreCase("LAST_LOGON_TIME") || columnName.equalsIgnoreCase("LAST_LOGON_TIMESTAMP") || columnName.equalsIgnoreCase("DAYS_SINCE_LAST_LOGON") || columnName.equalsIgnoreCase("LAST_LOGOFF_TIME") || columnName.equalsIgnoreCase("BAD_PASSWORD_TIME") || columnName.equalsIgnoreCase("ACCOUNT_EXPIRY_DATE") || columnName.equalsIgnoreCase("ACCOUNT_LOCK_ON_TIME") || columnName.equalsIgnoreCase("CHANGED_ON") || columnName.equalsIgnoreCase("CREATED_ON") || columnName.equalsIgnoreCase("MESSAGE_SIZE") || columnName.equalsIgnoreCase("CREATION_TIME") || columnName.equalsIgnoreCase("MODIFIED_TIME") || columnName.equalsIgnoreCase("LOCK_OUT_TIME") || columnName.equalsIgnoreCase("LOGON_COUNT") || columnName.equalsIgnoreCase("PASSWORD_EXPIRY_DATE") || columnName.equalsIgnoreCase("DAYS_TO_EXPIRE_PASSWORD") || columnName.equalsIgnoreCase("DAYS_SINCE_PASSWORD_SET") || columnName.equalsIgnoreCase("PASSWORD_LAST_SET") || columnName.equalsIgnoreCase("EXCHANGE_SERVER_VERSION") || columnName.equalsIgnoreCase("MOBILE_SERVICE_FLAG")) {
                ret.add(new Long(0L));
                return ret;
            }
            if (columnName.equalsIgnoreCase("HIDDEN_TO_ADDRESSLISTS") || columnName.equalsIgnoreCase("DELIVER_AND_REDIRECT") || columnName.equalsIgnoreCase("REQUIRE_AUTH") || columnName.equalsIgnoreCase("PERMANENT_DELETION") || columnName.equalsIgnoreCase("ALLOW_DIALIN")) {
                ret.add(rb.getString("admp.reports.user.customized_column_values.no"));
                return ret;
            } else if (columnName.equalsIgnoreCase("HTTP_PROTOCOL") || columnName.equalsIgnoreCase("IMAP4_PROTOCOL") || columnName.equalsIgnoreCase("POP3_PROTOCOL") || columnName.equalsIgnoreCase("OMA") || columnName.equalsIgnoreCase("ACTIVESYNC") || columnName.equalsIgnoreCase("MAPI_PROTOCOL")) {
                ret.add(rb.getString("admp.reports.user.customized_column_values.Enabled"));
                return ret;
            } else if (columnName.equalsIgnoreCase("MS_EXCH_EXCLUDE_POLICIES")) {
                ret.add(rb.getString("admp.reports.user_reports.customized_column_values.false"));
                return ret;
            } else if (columnName.equalsIgnoreCase("DOMAIN_NAME")) {
                ret.add(domainName);
                return ret;
            } else {
                if (ldapName.equals("objectSID")) {
                    return (ArrayList)prop.get("objectSid");
                }
                if (columnName.equalsIgnoreCase("LOGON_TO")) {
                    ret.add(rb.getString("admp.reports.user.customized_column_values.logonto.all_workstations"));
                    return ret;
                } else if (columnName.equalsIgnoreCase("LCS_ENABLED")) {
                    ret.add("-");
                    return ret;
                } else {
                    if (!columnName.equalsIgnoreCase("IS_DELETED")) return null;
                    ret.add(new Integer(1));
                }
            }
            return ret;
        }
        if (columnName.equalsIgnoreCase("EXCH_SHARING_POLICY") || columnName.equalsIgnoreCase("EXCH_ROLE_ASSIGNMENT_POLICY") || columnName.equalsIgnoreCase("EXCH_RETENTION_POLICY") || columnName.equalsIgnoreCase("EXCH_UM_POLICY") || columnName.equalsIgnoreCase("EXCH_ACTIVESYNC_POLICY")) {
            String dnValue = (String)values.get(0);
            String policyName = "-";
            policyName = ExchangePoliciesHandler.getInstance().getPolicyName(dnValue);
            ret.add(policyName);
            return ret;
        }
        if (ldapName.equalsIgnoreCase("objectclass")) {
            ret.add(values.get(values.size() - 1));
            return ret;
        }
        if (ldapName.equalsIgnoreCase("directReports")) {
            int j = 0;
            while (j < values.size()) {
                String cn = (String)values.get(j);
                if (columnName.equalsIgnoreCase("DIRECT_REPORTS")) {
                    ret.add(cn);
                }
                ++j;
            }
            return ret;
        }
        if (columnName.equalsIgnoreCase("PASSWORD_STATUS")) {
            ArrayList controlValues = (ArrayList)prop.get("userAccountControl");
            Integer obj = new Integer((String)controlValues.get(0));
            int val = obj;
            Long longObj = new Long((String)values.get(0));
            String str = "report.user.password_status.active";
            if (longObj != 0L) {
                Properties policy = PolicyHandler.getPolicies((String)domainName, (Long)1L);
                String days = policy.getProperty("maxPwdAge");
                long maxPwdAgeTime = 0L;
                Boolean isPSOPropAvail = Boolean.TRUE;
                if (prop.get("msDS-ResultantPSO") != null) {
                    ArrayList psoList = (ArrayList)prop.get("msDS-ResultantPSO");
                    String resultantPSO = (String)psoList.get(0);
                    String psoProp = PolicyHandler.getPSOProp((String)domainName, (String)resultantPSO, (String)"MAX_PWD_AGE");
                    if (psoProp != null) {
                        long maxPwdAgeDays;
                        maxPwdAgeTime = Long.parseLong(psoProp);
                        if ((maxPwdAgeTime = -1L * maxPwdAgeTime) == Long.MIN_VALUE) {
                            maxPwdAgeDays = 0L;
                            maxPwdAgeTime = 0L;
                        } else {
                            maxPwdAgeDays = (long)((double)maxPwdAgeTime * 1.0E-7 / 86400.0);
                        }
                        days = String.valueOf(maxPwdAgeDays);
                    } else {
                        isPSOPropAvail = Boolean.FALSE;
                    }
                }
                if ((val & 0x10000) == 65536) {
                    str = "report.user.password_status.never_expires";
                } else if (!isPSOPropAvail.booleanValue()) {
                    str = "-";
                    reportLogger.log(Level.FINE, "Only members of the Domain Admins group have Read Property permissions on default security descriptor of the PSO object in the schema. So cannot fetch the " + columnName);
                } else if (days != null && !days.equals("0") || maxPwdAgeTime != 0L) {
                    long nDays = DateTimeUtil.getNoOfDays((Long)longObj);
                    long daysToExpire = Long.parseLong(days) - nDays;
                    if (daysToExpire < 0L) {
                        str = "report.user.password_status.expired";
                    }
                } else {
                    str = "report.user.password_status.never_expires";
                }
            } else {
                str = (val & 0x10000) == 65536 ? "report.user.password_status.never_expires" : "admp.reports.common.reportresulttxt.must_change_at_next_logon";
            }
            ret.add(rb.getString(str));
            return ret;
        }
        if (columnName.equalsIgnoreCase("ACCOUNT_STATUS") || columnName.equalsIgnoreCase("COMPUTER_STATUS")) {
            Integer obj = new Integer((String)values.get(0));
            int val = obj;
            ret.add(rb.getString(UserAccountControl.getAccountStatus((int)val)));
            return ret;
        }
        if (columnName.equalsIgnoreCase("TRUSTED_FOR_DELEGATION")) {
            Integer obj = new Integer((String)values.get(0));
            int val = obj;
            ret.add(rb.getString(UserAccountControl.delegationTrust((int)val)));
            return ret;
        }
        if (columnName.equalsIgnoreCase("PWD_NEV_EXP_FLAG")) {
            Integer obj = new Integer((String)values.get(0));
            int val = obj;
            if ((val & 0x10000) == 65536) {
                ret.add(rb.getString("admp.reports.user_reports.customized_column_values.true"));
                return ret;
            } else {
                ret.add(rb.getString("admp.reports.user_reports.customized_column_values.false"));
            }
            return ret;
        }
        if (columnName.equalsIgnoreCase("Role")) {
            Integer obj = new Integer((String)values.get(0));
            int val = obj;
            if ((val & 0x1000) == 4096) {
                ret.add(rb.getString("admp.reports.computer.customized_column_values.comp_role.workstation_or_server"));
                return ret;
            } else {
                ret.add(rb.getString("admp.reports.computer.customized_column_values.comp_role.domaincontroller"));
            }
            return ret;
        }
        if (columnName.equalsIgnoreCase("GROUP_TYPE")) {
            String bitwtype = (String)values.get(0);
            int bitopt = Integer.parseInt(bitwtype);
            if ((bitopt & Integer.MIN_VALUE) == Integer.MIN_VALUE) {
                ret.add(rb.getString("admp.reports.group_reports.group_scopes.security"));
                return ret;
            } else {
                ret.add(rb.getString("admp.reports.group_reports.group_scopes.distribution"));
            }
            return ret;
        }
        if (columnName.equalsIgnoreCase("GROUP_SCOPE")) {
            String bitws = (String)values.get(0);
            int bitops = Integer.parseInt(bitws);
            if ((bitops & 2) == 2) {
                ret.add(rb.getString("admp.reports.group_reports.group_scopes.global"));
                return ret;
            } else if ((bitops & 4) == 4) {
                ret.add(rb.getString("admp.reports.group_reports.group_scopes.domain_local"));
                return ret;
            } else {
                if ((bitops & 8) != 8) return ret;
                ret.add(rb.getString("admp.reports.group_reports.group_scopes.universal"));
            }
            return ret;
        }
        if (columnName.equalsIgnoreCase("TYPE")) {
            String fileType = (String)values.get(0);
            if (fileType.equalsIgnoreCase("Folder")) {
                ret.add(rb.getString("admp.reports.common.column_value.type_folder"));
                return ret;
            } else {
                ret.add(rb.getString("admp.reports.common.column_value.type_file"));
            }
            return ret;
        }
        if (columnName.equalsIgnoreCase("DOMAIN_NAME")) {
            ret.add(domainName);
            return ret;
        }
        if (columnName.equalsIgnoreCase("MS_EXCH_EXCLUDE_POLICIES")) {
            String valueString = (String)values.get(0);
            if (valueString.equalsIgnoreCase("{26491CFC-9E50-4857-861B-0CB8DF22B5D7}")) {
                ret.add(rb.getString("admp.reports.user_reports.customized_column_values.true"));
                return ret;
            } else {
                ret.add(rb.getString("admp.reports.user_reports.customized_column_values.false"));
            }
            return ret;
        }
        if (columnName.equalsIgnoreCase("OU_NAME")) {
            String ouName = ReportAttributeHandler.getInstance().getOUName(domainName, (String)values.get(0));
            if (ouName != null && !ouName.equals("")) {
                ret.add(ouName);
                return ret;
            } else {
                ret.add("-");
            }
            return ret;
        }
        if (columnName.equalsIgnoreCase("OU_DN_NAME")) {
            String ouName = StrUtil.getContainerDNFromDN((String)((String)values.get(0)));
            if (ouName != null && !ouName.equals("")) {
                ret.add(ouName);
                return ret;
            } else {
                ret.add("-");
            }
            return ret;
        }
        if (ldapName.equalsIgnoreCase("msExchHideFromAddressLists") || ldapName.equalsIgnoreCase("deliverAndReDirect") || ldapName.equalsIgnoreCase("msExchRequireAuthToSendTo") || ldapName.equalsIgnoreCase("printDuplexSupported") || ldapName.equalsIgnoreCase("printKeepPrintedJobs") || ldapName.equalsIgnoreCase("printColor") || ldapName.equalsIgnoreCase("printCollate") || ldapName.equalsIgnoreCase("printStaplingSupported") || ldapName.equalsIgnoreCase("msNPAllowDialin") || ldapName.equalsIgnoreCase("reportToOwner") || ldapName.equalsIgnoreCase("reportToOriginator") || ldapName.equalsIgnoreCase("oOFReplyToOriginator")) {
            if (values.get(0).equals("1")) {
                ret.add(rb.getString("admp.reports.user.customized_column_values.yes"));
                return ret;
            } else {
                ret.add(rb.getString("admp.reports.user.customized_column_values.no"));
            }
            return ret;
        }
        if (ldapName.equalsIgnoreCase("mDBuseDefaults")) {
            if (values.get(0).equals("1")) {
                ret.add(rb.getString("admp.reports.user.customized_column_values.yes"));
            } else {
                ret.add(rb.getString("admp.reports.user.customized_column_values.no"));
            }
            if (!values.get(0).equals("1")) return ret;
            if (prop.get("homeMDB") == null) return ret;
            ArrayList mailboxStore = (ArrayList)prop.get("homeMDB");
            String mailboxStoreDN = (String)mailboxStore.get(0);
            Hashtable storeQuotaHash = DomainInfoCache.getInstance().getExchangeStoreDefaultQuotaCache(mailboxStoreDN);
            if (storeQuotaHash.isEmpty()) return ret;
            String[] quotaAttributes = new String[]{"mDBStorageQuota", "mDBOverQuotaLimit", "mDBOverHardQuotaLimit"};
            String[] dbDefaultQuotaValues = new String[]{(String)storeQuotaHash.get("WarningQuota"), (String)storeQuotaHash.get("SendQuota"), (String)storeQuotaHash.get("SendReceiveQuota")};
            int i = 0;
            while (i < quotaAttributes.length) {
                ArrayList<String> dbQuotaValue = new ArrayList<String>();
                if (dbDefaultQuotaValues[i].equals("")) {
                    dbQuotaValue.add("-");
                } else {
                    dbQuotaValue.add(dbDefaultQuotaValues[i]);
                }
                prop.put(quotaAttributes[i], dbQuotaValue);
                ++i;
            }
            return ret;
        }
        if (ldapName.equalsIgnoreCase("deletedItemFlags")) {
            if (values.get(0).equals("3")) {
                ret.add(rb.getString("admp.reports.user.customized_column_values.no"));
                return ret;
            } else {
                ret.add(rb.getString("admp.reports.user.customized_column_values.yes"));
            }
            return ret;
        }
        if (ldapName.equalsIgnoreCase("garbageCollPeriod")) {
            long l = Long.parseLong((String)values.get(0));
            ret.add(new Long(l /= 86400L).toString());
            return ret;
        }
        if (columnName.equalsIgnoreCase("OMA")) {
            if (values.get(0).equals("0") || values.get(0).equals("1") || values.get(0).equals("4") || values.get(0).equals("5")) {
                ret.add(rb.getString("admp.reports.user.customized_column_values.Enabled"));
                return ret;
            } else {
                ret.add(rb.getString("admp.reports.user.customized_column_values.Disabled"));
            }
            return ret;
        }
        if (columnName.equalsIgnoreCase("ACTIVESYNC")) {
            if (values.get(0).equals("0") || values.get(0).equals("1") || values.get(0).equals("2") || values.get(0).equals("3")) {
                ret.add(rb.getString("admp.reports.user.customized_column_values.Enabled"));
                return ret;
            } else {
                ret.add(rb.getString("admp.reports.user.customized_column_values.Disabled"));
            }
            return ret;
        }
        if (columnName.equalsIgnoreCase("LCS_ENABLED")) {
            if (values.get(0).equals("1")) {
                ret.add("admp.reports.user.customized_column_values.Enabled");
                return ret;
            } else {
                if (!values.get(0).equals("0")) return ret;
                ret.add("admp.reports.user.customized_column_values.Disabled");
            }
            return ret;
        }
        if (columnName.equalsIgnoreCase("HTTP_PROTOCOL")) {
            if (values.contains(UserMgmtUtil.HTTP_DISABLE)) {
                ret.add(rb.getString("admp.reports.user.customized_column_values.Disabled"));
                return ret;
            } else if (values.contains(UserMgmtUtil.HTTP_DISABLE_X07)) {
                ret.add(rb.getString("admp.reports.user.customized_column_values.Disabled"));
                return ret;
            } else {
                ret.add(rb.getString("admp.reports.user.customized_column_values.Enabled"));
            }
            return ret;
        }
        if (columnName.equalsIgnoreCase("IMAP4_PROTOCOL")) {
            String status = rb.getString("admp.reports.user.customized_column_values.Enabled");
            for (int i = 0; i < values.size(); ++i) {
                String value = (String)values.get(i);
                if (!value.startsWith(UserMgmtUtil.IMAP4_DISABLE_Prefix)) continue;
                status = rb.getString("admp.reports.user.customized_column_values.Disabled");
                break;
            }
            ret.add(status);
            return ret;
        }
        if (columnName.equalsIgnoreCase("POP3_PROTOCOL")) {
            String status = rb.getString("admp.reports.user.customized_column_values.Enabled");
            for (int i = 0; i < values.size(); ++i) {
                String value = (String)values.get(i);
                if (!value.startsWith(UserMgmtUtil.POP3_DISABLE_Prefix)) continue;
                status = rb.getString("admp.reports.user.customized_column_values.Disabled");
                break;
            }
            ret.add(status);
            return ret;
        }
        if (columnName.equalsIgnoreCase("MAPI_PROTOCOL")) {
            String status = rb.getString("admp.reports.user.customized_column_values.Enabled");
            for (int i = 0; i < values.size(); ++i) {
                String value = (String)values.get(i);
                if (!value.startsWith(UserMgmtUtil.MAPI_DISABLE_Prefix)) continue;
                status = rb.getString("admp.reports.user.customized_column_values.Disabled");
                break;
            }
            ret.add(status);
            return ret;
        }
        if (columnName.equalsIgnoreCase("WHEN_CREATED") || columnName.equalsIgnoreCase("WHEN_CHANGED") || columnName.equalsIgnoreCase("LAST_LOGON_TIME") || columnName.equalsIgnoreCase("LAST_LOGON_TIMESTAMP") || columnName.equalsIgnoreCase("DAYS_SINCE_LAST_LOGON") || columnName.equalsIgnoreCase("LAST_LOGOFF_TIME") || columnName.equalsIgnoreCase("BAD_PASSWORD_TIME") || columnName.equalsIgnoreCase("ACCOUNT_EXPIRY_DATE") || columnName.equalsIgnoreCase("ACCOUNT_LOCK_ON_TIME") || columnName.equalsIgnoreCase("PASSWORD_LAST_SET") || columnName.equalsIgnoreCase("CHANGED_ON") || columnName.equalsIgnoreCase("CREATED_ON") || columnName.equalsIgnoreCase("MESSAGE_SIZE") || columnName.equalsIgnoreCase("CREATION_TIME") || columnName.equalsIgnoreCase("LAST_ACCESS_TIME") || columnName.equalsIgnoreCase("LAST_WRITE_TIME") || columnName.equalsIgnoreCase("MODIFIED_TIME") || columnName.equalsIgnoreCase("LOCK_OUT_TIME")) {
            long l = System.currentTimeMillis();
            try {
                ArrayList controlValues;
                Integer obj;
                int val;
                l = Long.parseLong((String)values.get(0));
                if (columnName.equalsIgnoreCase("PASSWORD_LAST_SET") && l == 0L && ((val = (obj = new Integer((String)(controlValues = (ArrayList)prop.get("userAccountControl")).get(0))).intValue()) & 0x10000) == 65536) {
                    l = -1L;
                }
                if (columnName.equalsIgnoreCase("ACCOUNT_EXPIRY_DATE") && l >= 5223372036854775807L) {
                    l = 0L;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                l = System.currentTimeMillis();
            }
            ret.add(new Long(l));
            return ret;
        }
        if (columnName.equalsIgnoreCase("SIZE")) {
            long l = Long.parseLong((String)values.get(0));
            ret.add(new Long(l));
            return ret;
        } else if (columnName.equalsIgnoreCase("PASSWORD_EXPIRY_DATE") || columnName.equalsIgnoreCase("DAYS_TO_EXPIRE_PASSWORD")) {
            ArrayList controlValues = (ArrayList)prop.get("userAccountControl");
            Integer obj = new Integer((String)controlValues.get(0));
            int val = obj;
            Long longObj = new Long((String)values.get(0));
            long l = 0L;
            if (longObj != 0L) {
                longObj = DateTimeUtil.getSystemTimeFromFileTimeForPwdLastSet((Long)longObj);
                Properties policy = PolicyHandler.getPolicies((String)domainName, (Long)1L);
                String days = policy.getProperty("maxPwdAge");
                long maxPwdAge = 0L;
                Boolean isPSOPropAvail = Boolean.TRUE;
                if (days != null) {
                    maxPwdAge = Long.parseLong(days) * 24L * 60L * 60L * 1000L;
                }
                if (prop.get("msDS-ResultantPSO") != null) {
                    ArrayList psoList = (ArrayList)prop.get("msDS-ResultantPSO");
                    String resultantPSO = (String)psoList.get(0);
                    String psoProp = PolicyHandler.getPSOProp((String)domainName, (String)resultantPSO, (String)"MAX_PWD_AGE");
                    if (psoProp != null) {
                        maxPwdAge = -1L * Long.parseLong(psoProp);
                        maxPwdAge = maxPwdAge == Long.MIN_VALUE ? 0L : (maxPwdAge /= 10000L);
                    } else {
                        isPSOPropAvail = Boolean.FALSE;
                    }
                }
                l = longObj;
                if (!isPSOPropAvail.booleanValue()) {
                    l = -2L;
                    reportLogger.log(Level.FINE, "Only members of the Domain Admins group have Read Property permissions on default security descriptor of the PSO object in the schema. So cannot fetch the " + columnName);
                } else {
                    l = maxPwdAge != 0L && (val & 0x10000) != 65536 ? (l += maxPwdAge) : -1L;
                }
            } else if ((val & 0x10000) == 65536) {
                l = -1L;
            }
            ret.add(new Long(l));
            return ret;
        } else if (columnName.equalsIgnoreCase("DAYS_SINCE_PASSWORD_SET")) {
            Long longObj = new Long((String)values.get(0));
            long noDays = -1L;
            if (longObj != 0L) {
                noDays = DateTimeUtil.getNoOfDays((Long)longObj);
            }
            ret.add(new Long(noDays));
            return ret;
        } else if (columnName.equalsIgnoreCase("LOCK_OUT_DURATION") || columnName.equalsIgnoreCase("LOCK_OUT_OBS_WINDOW")) {
            long l = Long.parseLong((String)values.get(0));
            ret.add(new Long(l /= 600000000L).toString());
            return ret;
        } else if (columnName.equalsIgnoreCase("PWD_PROPS")) {
            Integer integer = Integer.parseInt((String)values.get(0));
            if (integer.equals(0)) {
                ret.add(rb.getString("admp.reports.user.customized_column_values.Disabled"));
                return ret;
            } else {
                ret.add(rb.getString("admp.reports.user.customized_column_values.Enabled"));
            }
            return ret;
        } else if (columnName.equalsIgnoreCase("COMP_CONFIG")) {
            Integer integer = Integer.parseInt((String)values.get(0));
            if (integer.equals(0)) {
                ret.add("admp.reports.user.customized_column_values.Enabled");
                return ret;
            } else if (integer.equals(1)) {
                ret.add("admp.reports.user.customized_column_values.Enabled");
                return ret;
            } else if (integer.equals(2)) {
                ret.add("admp.reports.user.customized_column_values.Disabled");
                return ret;
            } else if (integer.equals(3)) {
                ret.add("admp.reports.user.customized_column_values.Disabled");
                return ret;
            } else {
                ret.add("admp.reports.user.customized_column_values.Enabled");
            }
            return ret;
        } else if (columnName.equalsIgnoreCase("USER_CONFIG")) {
            Integer integer = Integer.parseInt((String)values.get(0));
            if (integer.equals(0)) {
                ret.add("admp.reports.user.customized_column_values.Enabled");
                return ret;
            } else if (integer.equals(1)) {
                ret.add("admp.reports.user.customized_column_values.Disabled");
                return ret;
            } else if (integer.equals(2)) {
                ret.add("admp.reports.user.customized_column_values.Enabled");
                return ret;
            } else if (integer.equals(3)) {
                ret.add("admp.reports.user.customized_column_values.Disabled");
                return ret;
            } else {
                ret.add("admp.reports.user.customized_column_values.Enabled");
            }
            return ret;
        } else if (columnName.equalsIgnoreCase("USER_VERSION")) {
            Integer integer = Integer.parseInt((String)values.get(0));
            int ver = integer;
            ret.add(new Integer(ver / 65536));
            return ret;
        } else if (columnName.equalsIgnoreCase("COMPUTER_VERSION")) {
            Integer integer = Integer.parseInt((String)values.get(0));
            int ver = integer;
            ret.add(new Integer(ver % 65536));
            return ret;
        } else {
            if (ldapName.equalsIgnoreCase("member")) {
                int j = 0;
                while (j < values.size()) {
                    Properties p = (Properties)values.get(j);
                    String cn = p.getProperty("cn");
                    if (columnName.equalsIgnoreCase("MEMBERS")) {
                        ret.add(cn);
                    } else if (columnName.equalsIgnoreCase("DISPLAY_MEMBERS")) {
                        String dn = p.getProperty("distinguishedName");
                        String ouName = ReportAttributeHandler.getInstance().getLocation(domainName, dn);
                        if (ouName != null && !ouName.equals("")) {
                            if (cn != null) {
                                ret.add(cn + "[" + ouName + "]");
                            } else {
                                ret.add("-");
                            }
                        } else {
                            ret.add(cn + rb.getString("admp.reports.user.customized_column_values.users_container"));
                        }
                    } else if (columnName.equalsIgnoreCase("GROUP_MEMBER_OBJECTGUID") || columnName.equalsIgnoreCase("MR_MEMBER_OBJECTGUID")) {
                        String guid = p.getProperty("objectGUID");
                        ret.add(guid);
                    }
                    ++j;
                }
                return ret;
            }
            if (ldapName.equalsIgnoreCase("memberOf")) {
                int j = 0;
                while (j < values.size()) {
                    Properties p = (Properties)values.get(j);
                    String guid = p.getProperty("objectGUID");
                    String cn = p.getProperty("cn");
                    String dn = p.getProperty("distinguishedName");
                    if (columnName.equalsIgnoreCase("MEMBER_OF")) {
                        ret.add(cn);
                    }
                    if (columnName.equalsIgnoreCase("MEMBEROF_DN")) {
                        ret.add(dn);
                    }
                    if (columnName.equalsIgnoreCase("MEMBEROF_LOCATION")) {
                        String ouName = ReportAttributeHandler.getInstance().getLocation(domainName, dn);
                        if (ouName != null && !ouName.equals("")) {
                            if (cn != null) {
                                ret.add(cn + "[" + ouName + "]");
                            } else {
                                ret.add("-");
                            }
                        } else {
                            ret.add(cn + rb.getString("admp.reports.user.customized_column_values.users_container"));
                        }
                    } else if (columnName.equalsIgnoreCase("GROUP_OBJECT_GUID") || columnName.equalsIgnoreCase("COMPUTERS_GROUP_GUID") || columnName.equalsIgnoreCase("MAILRECIPIENTS_GROUP_GUID") || columnName.equalsIgnoreCase("GROUP_MEMBEROF_OBJECTGUID") || columnName.equalsIgnoreCase("CONTACTS_GROUP_GUID")) {
                        ret.add(guid);
                    }
                    ++j;
                }
                return ret;
            }
            if (ldapName.equalsIgnoreCase("managedBy") || ldapName.equalsIgnoreCase("authOrig") || ldapName.equalsIgnoreCase("unauthOrig")) {
                int j = 0;
                while (j < values.size()) {
                    Properties p = (Properties)values.get(j);
                    String cn = p.getProperty("cn");
                    ret.add(cn);
                    ++j;
                }
                return ret;
            }
            if (ldapName.equalsIgnoreCase("msRADIUSFramedIPAddress")) {
                Integer objValue = Integer.parseInt((String)values.get(0));
                int intVal = objValue;
                String[] res = new String[4];
                String binaryVal = Integer.toBinaryString(intVal);
                StringBuffer tempStr = new StringBuffer("00000000000000000000000000000000");
                tempStr.replace(tempStr.length() - binaryVal.length(), tempStr.length(), binaryVal);
                int j = 0;
                String result = "";
                int i = 0;
                while (i <= 3) {
                    res[i] = tempStr.substring(j, j + 8);
                    result = result + String.valueOf(Integer.parseInt(res[i], 2));
                    if (i < 3) {
                        result = result + ".";
                    }
                    ++i;
                    j += 8;
                }
                ret.add(result);
                return ret;
            } else if (columnName.equalsIgnoreCase("TS_INHERIT_INITIAL_PROGRAM")) {
                if (values.get(0).equals("0")) {
                    ret.add(rb.getString("admp.reports.user.customized_column_values.Enabled"));
                    return ret;
                } else {
                    ret.add(rb.getString("admp.reports.user.customized_column_values.Disabled"));
                }
                return ret;
            } else if (columnName.equalsIgnoreCase("TS_DC_DRIVES") || columnName.equalsIgnoreCase("TS_DC_PRINTERS") || columnName.equalsIgnoreCase("TS_DC_DEFAULT_PRINTER") || columnName.equalsIgnoreCase("TS_REMOTE_HOME_DIRECTORY") || columnName.equalsIgnoreCase("TS_ALLOW_LOGON")) {
                if (values.get(0).equals("0")) {
                    ret.add(rb.getString("admp.reports.user.customized_column_values.Disabled"));
                    return ret;
                } else {
                    ret.add(rb.getString("admp.reports.user.customized_column_values.Enabled"));
                }
                return ret;
            } else if (columnName.equalsIgnoreCase("TS_END_DISCONNECTION") || columnName.equalsIgnoreCase("TS_ACTIVE_SESSION") || columnName.equalsIgnoreCase("TS_IDLE_SESSION")) {
                if (values.get(0).equals("0")) {
                    ret.add(rb.getString("admp.reports.ts_reports.customized_column_values.never"));
                    return ret;
                } else {
                    int duration = Integer.parseInt((String)values.get(0));
                    String durationStr = new Integer(duration /= 60000).toString();
                    if (duration < 60) {
                        if (duration == 1) {
                            ret.add(MessageFormat.format(rb.getString("admp.reports.ts_reports.customized_column_values.session_minute"), durationStr));
                            return ret;
                        } else {
                            ret.add(MessageFormat.format(rb.getString("admp.reports.ts_reports.customized_column_values.session_minutes"), durationStr));
                        }
                        return ret;
                    } else if (duration >= 60 && duration < 1440) {
                        durationStr = new Integer(duration /= 60).toString();
                        if (duration == 1) {
                            ret.add(MessageFormat.format(rb.getString("admp.reports.ts_reports.customized_column_values.session_hour"), durationStr));
                        }
                        ret.add(MessageFormat.format(rb.getString("admp.reports.ts_reports.customized_column_values.session_hours"), durationStr));
                        return ret;
                    } else {
                        if (duration < 1440) return ret;
                        durationStr = new Integer(duration /= 1440).toString();
                        if (duration == 1) {
                            ret.add(MessageFormat.format(rb.getString("admp.reports.ts_reports.customized_column_values.session_day"), durationStr));
                        }
                        ret.add(MessageFormat.format(rb.getString("admp.reports.ts_reports.customized_column_values.session_days"), durationStr));
                    }
                }
                return ret;
            } else if (columnName.equalsIgnoreCase("TS_BROKEN_TIMEOUT")) {
                if (values.get(0).equals("0")) {
                    ret.add(rb.getString("admp.reports.ts_reports.broken_time_out.session_disconnected"));
                    return ret;
                } else {
                    ret.add(rb.getString("admp.reports.ts_reports.broken_time_out.session_terminated"));
                }
                return ret;
            } else if (columnName.equalsIgnoreCase("TS_RECONNECT")) {
                if (values.get(0).equals("0")) {
                    ret.add(rb.getString("admp.reports.ts_reports.reconnection_settings.any_client"));
                    return ret;
                } else {
                    ret.add(rb.getString("admp.reports.ts_reports.reconnection_settings.originating_client"));
                }
                return ret;
            } else if (columnName.equalsIgnoreCase("TS_SHADOWING")) {
                if (values.get(0).equals("0")) {
                    ret.add(rb.getString("admp.reports.user.customized_column_values.Disabled"));
                    return ret;
                } else if (values.get(0).equals("1")) {
                    ret.add(rb.getString("admp.reports.ts_reports.shadowing.enabled_req_user_perm_interact_sesn"));
                    return ret;
                } else if (values.get(0).equals("2")) {
                    ret.add(rb.getString("admp.reports.ts_reports.shadowing.enabled_not_req_user_perm_interact_sesn"));
                    return ret;
                } else if (values.get(0).equals("3")) {
                    ret.add(rb.getString("admp.reports.ts_reports.shadowing.enabled_req_user_perm_view_sesn"));
                    return ret;
                } else {
                    if (!values.get(0).equals("4")) return ret;
                    ret.add(rb.getString("admp.reports.ts_reports.shadowing.enabled_not_req_user_perm_view_sesn"));
                }
                return ret;
            } else if (columnName.equalsIgnoreCase("TS_HOME_DRIVE")) {
                ArrayList tsHomeDir = (ArrayList)prop.get("tsServerRemoteHomeDir");
                if (!tsHomeDir.get(0).equals("0")) return values;
                ret.add(rb.getString("admp.reports.user.customized_column_values.Disabled"));
                return ret;
            } else if (columnName.equalsIgnoreCase("TS_HOME_DIRECTORY") || columnName.equalsIgnoreCase("TS_PROFILE_PATH")) {
                if (!values.get(0).equals("")) return values;
                ret.add("-");
                return ret;
            } else if (columnName.equalsIgnoreCase("TS_INITIAL_PROGRAM") || columnName.equalsIgnoreCase("TS_WORKING_DIRECTORY")) {
                ArrayList tsInheritInitial = (ArrayList)prop.get("tsInheritInitialProgram");
                if (!tsInheritInitial.get(0).equals("1")) {
                    if (!values.get(0).equals("")) return values;
                }
                ret.add("-");
                return ret;
            } else if (ldapName.equalsIgnoreCase("distinguishedName") && columnName.equalsIgnoreCase("COMPUTER_NAME")) {
                String dn = (String)values.get(0);
                ret.add(StrUtil.getOUNameFromDN((String)dn));
                return ret;
            } else if (columnName.equalsIgnoreCase("IS_DELETED")) {
                String isDeleted = (String)values.get(0);
                if (isDeleted.equals("1")) {
                    ret.add(new Integer(0));
                    return ret;
                } else {
                    ret.add(new Integer(1));
                }
                return ret;
            } else if (columnName.equalsIgnoreCase("MAPI_RECIPIENT")) {
                ret.add(values.get(0).equals("1") ? "TRUE" : "-");
                return ret;
            } else {
                if ((Boolean)prop.get("isCMA") != null && ((Boolean)prop.get("isCMA")).booleanValue()) {
                    if (columnName.equalsIgnoreCase("OBJECT_GUID")) return ret;
                    if (columnName.equalsIgnoreCase("INDEX")) return ret;
                    return values;
                }
                if (!columnName.equalsIgnoreCase("PHOTO_FILE")) return values;
                ret.add(values.get(0));
            }
        }
        return ret;
    }

    public static String getDynamicUpdateValues(Integer attributeId, Object obj) {
        char[] spec = new char[]{'\\', '\'', '&'};
        String ret = ListenerUtil.getUICustomizedValues(attributeId, obj);
        if (attributeId == 1021 || attributeId == 2012 || attributeId == 3014 || attributeId == 2011 || attributeId == 1037 || attributeId == 1068) {
            ret = "-";
        } else {
            String s = obj.toString();
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                for (int j = 0; j < spec.length; ++j) {
                    if (c != spec[j]) continue;
                    return "-";
                }
            }
        }
        return ret;
    }

    public static String getUICustomizedValues(Integer attributeId, Object obj) {
        String ret = null;
        ret = obj.toString();
        return ret;
    }

    public static ArrayList getContainerList(HttpServletRequest request, DynaValidatorForm bean) {
        Hashtable hash = new Hashtable();
        return ListenerUtil.getContainerList(request, bean, hash);
    }

    public static ArrayList getContainerList(HttpServletRequest request, DynaValidatorForm bean, Hashtable hash) {
        ArrayList<String> list = new ArrayList<String>();
        String[] domains = (String[])bean.get("domains");
        Hashtable domainOUList = (Hashtable)bean.get("domainOUList");
        Hashtable excludeChildOUHash = (Hashtable)bean.get("domainVsExcludeChildOU");
        Hashtable excludedOUHash = (Hashtable)bean.get("excludedOUList");
        HttpSession session = request.getSession();
        for (int i = 0; domains != null && i < domains.length; ++i) {
            boolean flag = true;
            ArrayList ouList = (ArrayList)domainOUList.get(domains[i]);
            String domainName = DomainUtil.getDomainName((String)domains[i]);
            Boolean excludeChildOU = (Boolean)excludeChildOUHash.get(domainName);
            ArrayList excludedOUList = (ArrayList)excludedOUHash.get(domainName);
            if (ouList == null || ouList.size() == 0) {
                ArrayList ous = ClientAuthorizationUtil.getAuthorizedOUList(request, domainName);
                if (ous != null && ous.size() > 0) {
                    list.addAll(ous);
                } else {
                    flag = false;
                    list.add(domains[i]);
                }
            } else if (excludeChildOU != null && excludeChildOU.booleanValue()) {
                list.addAll(ouList);
            } else if (excludedOUList != null && !excludedOUList.isEmpty()) {
                list.addAll(DirectoryObjectUtil.getParentOUsWithExcluded(ouList, excludedOUList));
            } else {
                list.addAll(DirectoryObjectUtil.getParentOUs(ouList));
            }
            hash.put(DomainUtil.getDomainName((String)domains[i]), flag);
        }
        return list;
    }

    public static ArrayList getContainerList(HttpServletRequest request, ArrayList domainList, Hashtable domainOUList, Hashtable excludeChildOUHash, Hashtable excludedOUHash, Hashtable hash) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < domainList.size(); ++i) {
            boolean flag = true;
            String domainName = (String)domainList.get(i);
            String domainDNName = DomainUtil.getDefaultNamingContext((String)domainName);
            ArrayList ouList = (ArrayList)domainOUList.get(domainName);
            Boolean excludeChildOU = (Boolean)excludeChildOUHash.get(domainName);
            ArrayList excludedOUList = (ArrayList)excludedOUHash.get(domainName);
            ArrayList ous = ClientAuthorizationUtil.getAuthorizedOUList(request, domainName);
            if (ouList == null || ouList.size() == 0) {
                if (ous != null && ous.size() > 0) {
                    list.addAll(ous);
                } else {
                    flag = false;
                    list.add(domainDNName);
                }
            } else {
                ArrayList selectedOUs = new ArrayList();
                if (excludeChildOU != null && excludeChildOU.booleanValue()) {
                    selectedOUs.addAll(ouList);
                } else if (excludedOUList != null && !excludedOUList.isEmpty()) {
                    selectedOUs.addAll(DirectoryObjectUtil.getParentOUsWithExcluded(ouList, excludedOUList));
                } else {
                    selectedOUs.addAll(DirectoryObjectUtil.getParentOUs(ouList));
                }
                if (ous == null || ous.size() == 0) {
                    list.addAll(selectedOUs);
                } else {
                    for (int j = 0; j < selectedOUs.size(); ++j) {
                        String ou = (String)selectedOUs.get(j);
                        if (!ous.contains(ou)) continue;
                        list.add(ou);
                    }
                }
            }
            hash.put(domainName, flag);
        }
        return list;
    }

    public static ArrayList getContainerList(ArrayList containerList, Hashtable dnDomainNameMap, Hashtable excludedOUHash, Hashtable excludeChildOUHash) {
        ArrayList<String> list = new ArrayList<String>();
        Hashtable domainOUList = new Hashtable();
        String[] domains = ListenerUtil.getDomains(containerList, dnDomainNameMap, domainOUList);
        for (int i = 0; domains != null && i < domains.length; ++i) {
            ArrayList excludedOUList;
            ArrayList ouList = (ArrayList)domainOUList.get(domains[i]);
            String domainName = domains[i];
            Boolean excludeChildOU = excludeChildOUHash != null ? (Boolean)excludeChildOUHash.get(domainName) : null;
            ArrayList arrayList = excludedOUList = excludedOUHash != null ? (ArrayList)excludedOUHash.get(domainName) : null;
            if (ouList == null || ouList.size() == 0) {
                list.add(domains[i]);
                continue;
            }
            if (excludeChildOU != null && excludeChildOU.booleanValue()) {
                list.addAll(ouList);
                continue;
            }
            if (excludedOUList != null && !excludedOUList.isEmpty()) {
                list.addAll(DirectoryObjectUtil.getParentOUsWithExcluded(ouList, excludedOUList));
                continue;
            }
            list.addAll(DirectoryObjectUtil.getParentOUs(ouList));
        }
        return list;
    }

    public static String[] getDomains(ArrayList containerList, Hashtable dnDomainNameMap, Hashtable domainOUList) {
        String[] schedulerDomains = null;
        ArrayList<String> schedulerDomainsList = new ArrayList<String>();
        if (containerList == null) {
            return schedulerDomains;
        }
        for (int i = 0; i < containerList.size(); ++i) {
            String val = (String)dnDomainNameMap.get(containerList.get(i));
            if (val == null) continue;
            ArrayList ouList = (ArrayList)domainOUList.get(val);
            if (ouList == null) {
                ouList = new ArrayList();
                domainOUList.put(val, ouList);
            }
            if (!ouList.contains(containerList.get(i))) {
                ouList.add(containerList.get(i));
            }
            if (schedulerDomainsList.contains(val)) continue;
            schedulerDomainsList.add(val);
        }
        schedulerDomains = new String[schedulerDomainsList.size()];
        schedulerDomains = schedulerDomainsList.toArray(schedulerDomains);
        return schedulerDomains;
    }

    public static Hashtable constructExcludeContainerHash(ArrayList containerList, Hashtable domainVsExcludeChildOU, Hashtable excludedOUHash, Hashtable dnDomainNameMap) {
        Hashtable<String, Boolean> excludeContainerHash = new Hashtable<String, Boolean>();
        for (int i = 0; i < containerList.size(); ++i) {
            String dn = (String)containerList.get(i);
            String domainName = (String)dnDomainNameMap.get(dn);
            Boolean isExcludeChildOU = Boolean.FALSE;
            if (domainVsExcludeChildOU != null && domainName != null && domainVsExcludeChildOU.containsKey(domainName)) {
                isExcludeChildOU = (Boolean)domainVsExcludeChildOU.get(domainName);
            }
            if (isExcludeChildOU.booleanValue()) {
                excludeContainerHash.put(dn, isExcludeChildOU);
                continue;
            }
            Boolean isParentOfExcludedOU = Boolean.FALSE;
            ArrayList excludedOUList = new ArrayList();
            if (excludedOUHash != null && domainName != null && excludedOUHash.containsKey(domainName)) {
                excludedOUList = (ArrayList)excludedOUHash.get(domainName);
            }
            for (int counter = 0; counter < excludedOUList.size(); ++counter) {
                String excludedOUDN = (String)excludedOUList.get(counter);
                if (!excludedOUDN.endsWith(dn)) continue;
                isParentOfExcludedOU = Boolean.TRUE;
                break;
            }
            excludeContainerHash.put(dn, isParentOfExcludedOU);
        }
        return excludeContainerHash;
    }

    public static Properties getAttributeProp(Integer attributeId, ArrayList list) {
        Properties p = null;
        for (int i = 0; i < list.size(); ++i) {
            if (!((Properties)list.get(i)).get("ATTRIB_ID").equals(attributeId)) continue;
            p = (Properties)list.get(i);
        }
        return p;
    }

    public static JSONObject getAttributeProp(Integer attributeId, JSONArray list) {
        JSONObject p = null;
        try {
            for (int i = 0; i < list.length(); ++i) {
                if (!((JSONObject)list.get(i)).get("ATTRIB_ID").equals(attributeId)) continue;
                p = (JSONObject)list.get(i);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return p;
    }

    public static Hashtable getQueueProps(AbstractListener listener) {
        Hashtable tableProps = new Hashtable();
        Hashtable prop = listener.getProperties();
        tableProps.put("baseTableName", prop.get("baseTableName"));
        tableProps.put("resultTableName", prop.get("resultTableName"));
        tableProps.put("generationId", listener.getGenerationId());
        tableProps.put("resultHandling", "add");
        return tableProps;
    }

    public static void fillDomainDetails(Long generationId, HttpServletRequest request, ReportBean bean) {
        Integer reportId = (Integer)bean.get("reportId");
        String[] domainList = request.getParameterValues("domains");
        HashMap inputParams = (HashMap)bean.get("reportInputParams");
        Hashtable domainOUList = (Hashtable)bean.get("domainOUList");
        Hashtable dnDomainNameMap = (Hashtable)bean.get("dnDomainNameMap");
        Hashtable domainVsExcludeChildOU = (Hashtable)bean.get("domainVsExcludeChildOU");
        Hashtable excludedOUHash = (Hashtable)bean.get("excludedOUList");
        try {
            ArrayList domains = new ArrayList();
            Hashtable ouMap = new Hashtable();
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
            for (int i = 0; i < domainList.length; ++i) {
                Row r1;
                int j;
                ArrayList ouList = (ArrayList)domainOUList.get(domainList[i]);
                ArrayList excludedOUList = (ArrayList)excludedOUHash.get(dnDomainNameMap.get(domainList[i]));
                Boolean excludeChildOU = (Boolean)domainVsExcludeChildOU.get(dnDomainNameMap.get(domainList[i]));
                if (excludeChildOU == null) {
                    excludeChildOU = Boolean.FALSE;
                }
                Row r = new Row("ADSMReportDomainDetails");
                r.set("DOMAIN_DN_NAME", (Object)domainList[i]);
                r.set("DOMAIN_NAME", dnDomainNameMap.get(domainList[i]));
                r.set("REPORT_GENERATION_ID", (Object)generationId);
                r.set("EXCLUDE_CHILD_OU", (Object)excludeChildOU);
                dataObj.addRow(r);
                for (j = 0; ouList != null && j < ouList.size(); ++j) {
                    r1 = new Row("ADSMReportOUMappingDetails");
                    r1.set("OU_NAME", ouList.get(j));
                    r1.set("DOMAIN_NAME", dnDomainNameMap.get(domainList[i]));
                    r1.set("REPORT_GENERATION_ID", (Object)generationId);
                    dataObj.addRow(r1);
                }
                for (j = 0; excludedOUList != null && j < excludedOUList.size(); ++j) {
                    r1 = new Row("ADSMReportExcludedOUMapping");
                    r1.set("OU_NAME", excludedOUList.get(j));
                    r1.set("DOMAIN_NAME", dnDomainNameMap.get(domainList[i]));
                    r1.set("REPORT_GENERATION_ID", (Object)generationId);
                    dataObj.addRow(r1);
                }
            }
            CommonUtil.getPersistence((boolean[])new boolean[0]).add(dataObj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void fillDomainDetails(Long generationId, ArrayList domainList, Hashtable domainOUList, Hashtable excludeChildOUHash, Hashtable excludedOUHash) {
        try {
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
            for (int i = 0; i < domainList.size(); ++i) {
                Row r1;
                int j;
                String domainName = (String)domainList.get(i);
                ArrayList ouList = (ArrayList)domainOUList.get(domainName);
                ArrayList excludedOUList = (ArrayList)excludedOUHash.get(domainName);
                Boolean excludeChildOU = (Boolean)excludeChildOUHash.get(domainName);
                if (excludeChildOU == null) {
                    excludeChildOU = Boolean.FALSE;
                }
                Row r = new Row("ADSMReportDomainDetails");
                r.set("DOMAIN_DN_NAME", DomainInfoCache.getInstance().getDomainVsDefaultNamingContext().get(domainName));
                r.set("DOMAIN_NAME", (Object)domainName);
                r.set("REPORT_GENERATION_ID", (Object)generationId);
                r.set("EXCLUDE_CHILD_OU", (Object)excludeChildOU);
                dataObj.addRow(r);
                for (j = 0; ouList != null && j < ouList.size(); ++j) {
                    r1 = new Row("ADSMReportOUMappingDetails");
                    r1.set("OU_NAME", ouList.get(j));
                    r1.set("DOMAIN_NAME", (Object)domainName);
                    r1.set("REPORT_GENERATION_ID", (Object)generationId);
                    dataObj.addRow(r1);
                }
                for (j = 0; excludedOUList != null && j < excludedOUList.size(); ++j) {
                    r1 = new Row("ADSMReportExcludedOUMapping");
                    r1.set("OU_NAME", excludedOUList.get(j));
                    r1.set("DOMAIN_NAME", (Object)domainName);
                    r1.set("REPORT_GENERATION_ID", (Object)generationId);
                    dataObj.addRow(r1);
                }
            }
            CommonUtil.getPersistence((boolean[])new boolean[0]).add(dataObj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void fillValues(String inputTable, Integer reportId, Hashtable hash, Long generationId) {
        try {
            TableDefinition ta = MetaDataUtil.getTableDefinitionByName((String)inputTable);
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
            ArrayList columns = (ArrayList)ta.getColumnNames();
            Row r = new Row(inputTable);
            for (int j = 0; j < columns.size(); ++j) {
                String columnName = (String)columns.get(j);
                ColumnDefinition coldefn = ta.getColumnDefinitionByName(columnName);
                if (coldefn.getUniqueValueGeneration() != null) continue;
                Object columnValue = hash.get(columnName);
                r.set(columnName, columnValue);
            }
            dataObj.addRow(r);
            CommonUtil.getPersistence((boolean[])new boolean[0]).add(dataObj);
            hash.put("INPUT_ID", (Long)r.get("INPUT_ID"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ArrayList getInputValues(Long dashboardReportMapping, HttpServletRequest request, ReportBean bean) {
        ArrayList list = new ArrayList();
        try {
            Criteria crit = new Criteria(new Column("DashboardReportInputVals", "DASHBOARD_REPORT_MAPPING"), (Object)dashboardReportMapping, 0);
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("DashboardReportInputVals", crit);
            Iterator it = dataObj.getRows("DashboardReportInputVals");
            while (it.hasNext()) {
                Row r = (Row)it.next();
                Hashtable<String, Object> inputValues = new Hashtable<String, Object>();
                inputValues.put("INPUT_PROPERTY_VALUE", r.get("VALUE"));
                list.add(inputValues);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ArrayList getMultiInputValues(Long dashboardReportMapping, HttpServletRequest request, ReportBean bean) {
        ArrayList list = new ArrayList();
        try {
            Criteria crit = new Criteria(new Column("DashboardReportInputVals", "DASHBOARD_REPORT_MAPPING"), (Object)dashboardReportMapping, 0);
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("DashboardReportInputVals", crit);
            if (!dataObj.isEmpty()) {
                Long inputId = (Long)dataObj.getFirstRow("DashboardReportInputVals").get("INPUT_ID");
                crit = new Criteria(new Column("DashboardReportInputMultiVals", "INPUT_ID"), (Object)inputId, 0);
                dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("DashboardReportInputMultiVals", crit);
                Iterator it = dataObj.getRows("DashboardReportInputMultiVals");
                while (it.hasNext()) {
                    Row r = (Row)it.next();
                    Hashtable<String, Object> inputValues = new Hashtable<String, Object>();
                    inputValues.put("INPUT_PROPERTY_VALUE", r.get("SERVER_VALUE"));
                    inputValues.put("INPUT_ID", r.get("MULTI_VAL_ID"));
                    list.add(inputValues);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ArrayList getInputValueAsList(Object value) {
        ArrayList list = new ArrayList();
        Hashtable<String, Object> inputValues = new Hashtable<String, Object>();
        inputValues.put("INPUT_PROPERTY_VALUE", value);
        list.add(inputValues);
        return list;
    }

    public static void getInputValues(Long generationId, Integer reportId, HttpServletRequest request, ReportBean bean) {
        ListenerUtil.getDomainDetails(generationId, reportId, request, bean);
        HashMap inputParams = (HashMap)bean.get("reportInputParams");
        try {
            Criteria crit = new Criteria(new Column("ADSMInputMappingDetails", "REPORT_ID"), (Object)reportId, 0);
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMInputMappingDetails", crit);
            Iterator it = dataObj.getRows("ADSMInputMappingDetails");
            while (it.hasNext()) {
                Row r = (Row)it.next();
                String tableName = (String)r.get("INPUT_TABLE_NAME");
                String key = (String)r.get("KEY_VALUE");
                ArrayList list = ListenerUtil.getInputDetails(tableName, generationId, inputParams, key);
                inputParams.put(key, list);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ArrayList getInputDetails(String inputTable, Long generationId, Map inputParams, String key) {
        ArrayList list = new ArrayList();
        try {
            Criteria crit = new Criteria(new Column(inputTable, "REPORT_GENERATION_ID"), (Object)generationId, 0);
            if (inputTable.equalsIgnoreCase("ADSMReportOtherInputDetails")) {
                crit = crit.and(new Criteria(new Column(inputTable, "INPUT_PROPERTY_NAME"), (Object)key, 0));
            }
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get(inputTable, crit);
            Iterator it = dataObj.getRows(inputTable);
            while (it.hasNext()) {
                Hashtable<String, Object> inputValues = new Hashtable<String, Object>();
                Row r = (Row)it.next();
                TableDefinition ta = MetaDataUtil.getTableDefinitionByName((String)inputTable);
                ArrayList columns = (ArrayList)ta.getColumnNames();
                for (int j = 0; j < columns.size(); ++j) {
                    String columnName = (String)columns.get(j);
                    Object columnValue = r.get(columnName);
                    inputValues.put(columnName, columnValue);
                }
                list.add(inputValues);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ArrayList getInputDetails(String inputTable, Long generationId, String[] columns) {
        ArrayList<Object> list = new ArrayList<Object>();
        try {
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)inputTable));
            Criteria crit = new Criteria(new Column(inputTable, "REPORT_GENERATION_ID"), (Object)generationId, 0);
            sq.setCriteria(crit);
            sq.addSelectColumn(Column.getColumn((String)inputTable, (String)"INPUT_ID"));
            for (String column : columns) {
                sq.addSelectColumn(Column.getColumn((String)inputTable, (String)column));
            }
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)sq);
            Iterator it = dataObj.getRows(inputTable);
            while (it.hasNext()) {
                Row r = (Row)it.next();
                for (int j = 0; j < columns.length; ++j) {
                    String columnName = columns[j];
                    Object columnValue = r.get(columnName);
                    list.add(columnValue);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static void getDomainDetails(Long generationId, Integer reportId, HttpServletRequest request, ReportBean bean) {
        try {
            HttpSession session = request.getSession();
            ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
            Hashtable domainOUsMap = authObject.getDomainOUsMap();
            HashMap inputParams = (HashMap)bean.get("reportInputParams");
            ArrayList<String> domainList = new ArrayList<String>();
            ArrayList list = ListenerUtil.getInputDetails("ADSMReportDomainDetails", generationId, inputParams, "domains");
            Hashtable domainOUList = (Hashtable)bean.get("domainOUList");
            Hashtable excludeChildOUHash = (Hashtable)bean.get("domainVsExcludeChildOU");
            Hashtable excludedOUHash = (Hashtable)bean.get("excludedOUList");
            for (int i = 0; i < list.size(); ++i) {
                Hashtable values = (Hashtable)list.get(i);
                String domainName = (String)values.get("DOMAIN_NAME");
                Boolean isRootLevelAuthorized = true;
                ArrayList authorizedOUsList = (ArrayList)domainOUsMap.get(domainName);
                if (authorizedOUsList != null && !authorizedOUsList.isEmpty()) {
                    isRootLevelAuthorized = false;
                }
                Boolean isExcludeChildOU = (Boolean)values.get("EXCLUDE_CHILD_OU");
                Properties domainProp = ListenerUtil.getDomainProps(bean, domainName);
                if (domainProp == null) continue;
                String defaultNamingContext = domainProp.getProperty("DEFAULT_NAMING_CONTEXT");
                domainList.add(defaultNamingContext);
                ArrayList ouList = ListenerUtil.getOUdetails(generationId, (String)values.get("DOMAIN_NAME"), (ArrayList)domainProp.get("ouList"), isRootLevelAuthorized, defaultNamingContext);
                ArrayList excludedOUList = ListenerUtil.getOUdetails(generationId, (String)values.get("DOMAIN_NAME"), (ArrayList)domainProp.get("ouList"), isRootLevelAuthorized, defaultNamingContext, "ADSMReportExcludedOUMapping");
                ArrayList selectedOUList = (ArrayList)domainOUList.get(defaultNamingContext);
                if (selectedOUList == null) {
                    domainOUList.put(defaultNamingContext, ouList);
                    excludeChildOUHash.put(domainName, isExcludeChildOU);
                    excludedOUHash.put(domainName, excludedOUList);
                    continue;
                }
                for (int j = 0; j < ouList.size(); ++j) {
                    if (selectedOUList.contains(ouList.get(j)) || selectedOUList.size() >= 0) continue;
                    selectedOUList.add(ouList.get(j));
                }
            }
            bean.set("domains", domainList.toArray(new String[domainList.size()]));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ArrayList getOUdetails(Long generationId, String domainName, ArrayList authorizedOUList, Boolean isRootLevelAuthorized, String rootDefaultNamingContext) {
        return ListenerUtil.getOUdetails(generationId, domainName, authorizedOUList, isRootLevelAuthorized, rootDefaultNamingContext, "ADSMReportOUMappingDetails");
    }

    public static ArrayList getOUdetails(Long generationId, String domainName, ArrayList authorizedOUList, Boolean isRootLevelAuthorized, String rootDefaultNamingContext, String tableName) {
        ArrayList<String> ouList = new ArrayList<String>();
        try {
            Criteria crit = new Criteria(new Column(tableName, "REPORT_GENERATION_ID"), (Object)generationId, 0);
            crit = crit.and(new Criteria(new Column(tableName, "DOMAIN_NAME"), (Object)domainName, 0));
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get(tableName, crit);
            Iterator it = dataObj.getRows(tableName);
            while (it.hasNext()) {
                Row r = (Row)it.next();
                String ouName = (String)r.get("OU_NAME");
                if (isRootLevelAuthorized.booleanValue() && ouName.equals(rootDefaultNamingContext)) {
                    ouList.add((String)r.get("OU_NAME"));
                    continue;
                }
                if (!ListenerUtil.isAuthorizedOU(authorizedOUList, ouName)) continue;
                ouList.add((String)r.get("OU_NAME"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ouList;
    }

    public static ArrayList getDomainList(Long generationId) {
        ArrayList<String> domainList = new ArrayList<String>();
        try {
            Criteria c = new Criteria(Column.getColumn((String)"ADSMReportDomainDetails", (String)"REPORT_GENERATION_ID"), (Object)generationId, 0);
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMReportDomainDetails", c);
            if (!dataObj.isEmpty()) {
                Iterator it = dataObj.getRows("ADSMReportDomainDetails");
                while (it.hasNext()) {
                    Row r = (Row)it.next();
                    domainList.add((String)r.get("DOMAIN_NAME"));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return domainList;
    }

    public static HashMap getDomainDetails(Long generationId, Integer reportId, HttpServletRequest request) {
        HashMap<String, Cloneable> domainData = new HashMap<String, Cloneable>();
        try {
            Row reportRow = ReportHandler.getReportDetailsRow((Integer)reportId);
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            ADMPAuthObject authObject = new ADMPAuthObject(Long.valueOf(1L));
            if (loginId == null) {
                loginId = 1L;
            } else {
                authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
            }
            Hashtable domainOUsMap = authObject.getDomainOUsMap();
            Hashtable domainVsactions = authObject.getDomainActionMap();
            ArrayList delegatedDomainList = HDTDomainHandler.getDomainListForUser((Long)loginId, (Hashtable)domainVsactions, (Long)((Long)reportRow.get("ACTION_ID")));
            HashMap inputParams = new HashMap();
            ArrayList<String> domainList = new ArrayList<String>();
            Hashtable<String, ArrayList> domainOUList = new Hashtable<String, ArrayList>();
            Hashtable<String, Boolean> excludeChildOUHash = new Hashtable<String, Boolean>();
            Hashtable<String, ArrayList> excludedOUHash = new Hashtable<String, ArrayList>();
            ArrayList list = ListenerUtil.getInputDetails("ADSMReportDomainDetails", generationId, inputParams, "domains");
            for (int i = 0; i < list.size(); ++i) {
                Properties domainProp;
                Hashtable values = (Hashtable)list.get(i);
                String domainName = (String)values.get("DOMAIN_NAME");
                Boolean isExcludeChildOU = (Boolean)values.get("EXCLUDE_CHILD_OU");
                Boolean isRootLevelAuthorized = true;
                ArrayList authorizedOUsList = (ArrayList)domainOUsMap.get(domainName);
                if (authorizedOUsList != null && !authorizedOUsList.isEmpty()) {
                    isRootLevelAuthorized = false;
                }
                if ((domainProp = ListenerUtil.getDomainProps(delegatedDomainList, domainName)) == null) continue;
                String defaultNamingContext = domainProp.getProperty("DEFAULT_NAMING_CONTEXT");
                ArrayList ouList = ListenerUtil.getOUPropList(generationId, (String)values.get("DOMAIN_NAME"), (ArrayList)domainProp.get("ouList"), isRootLevelAuthorized, defaultNamingContext);
                ArrayList excludedOUList = ListenerUtil.getOUPropList(generationId, (String)values.get("DOMAIN_NAME"), (ArrayList)domainProp.get("ouList"), isRootLevelAuthorized, defaultNamingContext, "ADSMReportExcludedOUMapping");
                domainList.add(domainName);
                domainOUList.put(defaultNamingContext, ouList);
                excludeChildOUHash.put(defaultNamingContext, isExcludeChildOU);
                excludedOUHash.put(defaultNamingContext, excludedOUList);
            }
            domainData.put("selectedDomains", domainList);
            domainData.put("domainVsExcludeChildOU", excludeChildOUHash);
            domainData.put("domainVsOUList", domainOUList);
            domainData.put("domainVsExcludeOUList", excludedOUHash);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return domainData;
    }

    public static ArrayList getOUPropList(Long generationId, String domainName, ArrayList authorizedOUList, Boolean isRootLevelAuthorized, String rootDefaultNamingContext) {
        return ListenerUtil.getOUPropList(generationId, domainName, authorizedOUList, isRootLevelAuthorized, rootDefaultNamingContext, "ADSMReportOUMappingDetails");
    }

    public static ArrayList getOUPropList(Long generationId, String domainName, ArrayList authorizedOUList, Boolean isRootLevelAuthorized, String rootDefaultNamingContext, String tableName) {
        ArrayList ouList = new ArrayList();
        try {
            Criteria crit = new Criteria(new Column(tableName, "REPORT_GENERATION_ID"), (Object)generationId, 0);
            crit = crit.and(new Criteria(new Column(tableName, "DOMAIN_NAME"), (Object)domainName, 0));
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get(tableName, crit);
            Iterator it = dataObj.getRows(tableName);
            while (it.hasNext()) {
                Row r = (Row)it.next();
                String ouDN = (String)r.get("OU_NAME");
                Hashtable<String, String> ouProp = new Hashtable<String, String>();
                if (isRootLevelAuthorized.booleanValue() && ouDN.equals(rootDefaultNamingContext)) {
                    ouProp.put("ouDN", rootDefaultNamingContext);
                    ouProp.put("ouPath", domainName);
                    ouProp.put("ouName", domainName);
                    ouList.add(ouProp);
                    continue;
                }
                if (!ListenerUtil.isAuthorizedOU(authorizedOUList, ouDN)) continue;
                Properties prop = OUUtil.getOULocationProp((String)domainName, (String)ouDN, (String)rootDefaultNamingContext);
                ouProp.put("ouDN", ouDN);
                ouProp.put("ouPath", prop.getProperty("OU_PATH"));
                ouProp.put("ouName", prop.getProperty("OU_NAME"));
                ouList.add(ouProp);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ouList;
    }

    private static Properties getDomainProps(ArrayList domainList, String domainName) {
        for (int i = 0; i < domainList.size(); ++i) {
            Properties domainProp = (Properties)domainList.get(i);
            String domainStr = domainProp.getProperty("DOMAIN_NAME");
            if (!domainName.equalsIgnoreCase(domainStr)) continue;
            return domainProp;
        }
        return null;
    }

    private static Properties getDomainProps(ReportBean bean, String domainName) {
        ArrayList domainList = (ArrayList)bean.get("domainList");
        for (int i = 0; i < domainList.size(); ++i) {
            Properties domainProp = (Properties)domainList.get(i);
            String domainStr = domainProp.getProperty("DOMAIN_NAME");
            if (!domainName.equalsIgnoreCase(domainStr)) continue;
            return domainProp;
        }
        return null;
    }

    public static void fillDomainDetails(Long generationId, ArrayList domains) {
        try {
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
            for (int i = 0; i < domains.size(); ++i) {
                Row r = new Row("ADSMReportDomainDetails");
                r.set("DOMAIN_NAME", (Object)((String)domains.get(i)));
                r.set("REPORT_GENERATION_ID", (Object)generationId);
                dataObj.addRow(r);
            }
            CommonUtil.getPersistence((boolean[])new boolean[0]).add(dataObj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static JSONArray getDomainDetails(Long generationId, Integer reportId) {
        JSONArray domains = new JSONArray();
        try {
            Criteria crit = new Criteria(new Column("ADSMReportDomainDetails", "REPORT_GENERATION_ID"), (Object)generationId, 0);
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMReportDomainDetails", crit);
            if (!dataObj.isEmpty()) {
                Iterator it = dataObj.getRows("ADSMReportDomainDetails");
                while (it.hasNext()) {
                    Row r = (Row)it.next();
                    domains.put((Object)((String)r.get("DOMAIN_NAME")));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return domains;
    }

    private static boolean isAuthorizedOU(ArrayList authorizedOUList, String ouName) {
        for (int j = 0; j < authorizedOUList.size(); ++j) {
            Properties ouProp = (Properties)authorizedOUList.get(j);
            String ouDN = ouProp.getProperty("DISTINGUISHED_NAME");
            if (!ouName.equalsIgnoreCase(ouDN)) continue;
            return true;
        }
        return false;
    }

    public static String getSchedulerDomains(ArrayList containerList, Hashtable dnDomainNameMap) {
        String schedulerDomains = "";
        String previousDomain = "";
        if (containerList == null) {
            return schedulerDomains;
        }
        for (int i = 0; i < containerList.size(); ++i) {
            String val = (String)dnDomainNameMap.get(containerList.get(i));
            if (val == null || val.equals(previousDomain)) continue;
            if (i != 0) {
                schedulerDomains = schedulerDomains + ", ";
            }
            schedulerDomains = schedulerDomains + val;
            previousDomain = val;
        }
        return schedulerDomains;
    }

    public static void setObjects(HttpServletRequest request) {
        try {
            String beanName = request.getParameter("beanName");
            HttpSession session = request.getSession();
            DynaValidatorForm bean = (DynaValidatorForm)session.getAttribute(beanName);
            ArrayList<String> trusteesList = (ArrayList<String>)bean.get("trusteesList");
            String[] selectedObjects = request.getParameterValues("checkObjects");
            String domainName = request.getParameter("defaultNamingContext");
            if (trusteesList == null) {
                trusteesList = new ArrayList<String>();
            }
            for (int i = 0; selectedObjects != null && i < selectedObjects.length; ++i) {
                if (trusteesList.contains(selectedObjects[i]) || selectedObjects[i] == null) continue;
                trusteesList.add(selectedObjects[i]);
            }
            request.setAttribute("setObject", (Object)"Success");
            bean.set("trusteesList", trusteesList);
            bean.set("selectedDomain", (Object)domainName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void removeObjects(HttpServletRequest request) {
        try {
            String beanName = request.getParameter("beanName");
            HttpSession session = request.getSession();
            DynaValidatorForm bean = (DynaValidatorForm)session.getAttribute(beanName);
            ArrayList trusteesList = (ArrayList)bean.get("trusteesList");
            if (trusteesList != null && trusteesList.size() >= 0) {
                String indexValue = request.getParameter("index");
                if (indexValue.equalsIgnoreCase("all")) {
                    trusteesList.clear();
                } else {
                    int index = Integer.parseInt(indexValue);
                    if (--index >= trusteesList.size()) {
                        trusteesList.clear();
                    }
                    trusteesList.remove(index);
                }
                bean.set("trusteesList", (Object)trusteesList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static DataObject getInputTablesDO(Integer reportId) {
        DataObject dataObj = null;
        try {
            Criteria crit = new Criteria(new Column("ADSMInputMappingDetails", "REPORT_ID"), (Object)reportId, 0);
            dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMInputMappingDetails", crit);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dataObj;
    }

    public static void fillInputValues(AbstractListener listener, HttpServletRequest request, ReportBean bean) {
        Integer reportId = (Integer)bean.get("reportId");
        ListenerUtil.fillDomainDetails(listener.getGenerationId(), request, bean);
        try {
            DataObject dataObj = ListenerUtil.getInputTablesDO(reportId);
            if (dataObj != null) {
                Iterator it = dataObj.getRows("ADSMInputMappingDetails");
                while (it.hasNext()) {
                    Row r = (Row)it.next();
                    String tableName = (String)r.get("INPUT_TABLE_NAME");
                    String key = (String)r.get("KEY_VALUE");
                    Long isMultiInput = (Long)r.get("IS_MULTI_INPUT");
                    if (isMultiInput == 1L) {
                        listener.fillInputDetails(tableName, request, bean, key);
                        continue;
                    }
                    ListenerUtil.fillInputs(tableName, request, bean, key);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void fillInputs(String inputTable, HttpServletRequest request, ReportBean bean, String key) {
        HashMap inputParams = (HashMap)bean.get("reportInputParams");
        AbstractListener listener = bean.getListener();
        Integer reportId = (Integer)bean.get("reportId");
        try {
            ArrayList list = new ArrayList();
            Hashtable<String, Object> hash = new Hashtable<String, Object>();
            String value = request.getParameter(key);
            if (value != null) {
                hash.put("INPUT_PROPERTY_NAME", key);
                hash.put("INPUT_PROPERTY_VALUE", value);
                hash.put("REPORT_GENERATION_ID", listener.getGenerationId());
                ListenerUtil.fillValues(inputTable, reportId, hash, listener.getGenerationId());
                list.add(hash);
                inputParams.put(key, list);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Hashtable getInputTable(Integer reportId, String[] key) {
        Hashtable<String, String> inputTable = new Hashtable<String, String>();
        try {
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"ADSMInputMappingDetails"));
            Criteria criteria = new Criteria(Column.getColumn((String)"ADSMInputMappingDetails", (String)"REPORT_ID"), (Object)reportId, 0);
            if (key != null) {
                criteria = criteria.and(new Criteria(Column.getColumn((String)"ADSMInputMappingDetails", (String)"KEY_VALUE"), (Object)key, 8));
            }
            query.addSelectColumn(Column.getColumn((String)"ADSMInputMappingDetails", (String)"REPORT_ID"));
            query.addSelectColumn(Column.getColumn((String)"ADSMInputMappingDetails", (String)"KEY_VALUE"));
            query.addSelectColumn(Column.getColumn((String)"ADSMInputMappingDetails", (String)"INPUT_TABLE_NAME"));
            query.setCriteria(criteria);
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
            Iterator it = dataObj.getRows("ADSMInputMappingDetails");
            while (it.hasNext()) {
                Row r = (Row)it.next();
                String tableName = (String)r.get("INPUT_TABLE_NAME");
                String keyValue = (String)r.get("KEY_VALUE");
                inputTable.put(keyValue, tableName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return inputTable;
    }

    public static Long getInputId(Integer reportId, Long generationId, String key) {
        Long inputId = null;
        String[] keys = new String[]{key};
        Hashtable inputHashTable = ListenerUtil.getInputTable(reportId, keys);
        String inputTable = (String)inputHashTable.get(key);
        try {
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)inputTable));
            Criteria criteria = new Criteria(Column.getColumn((String)inputTable, (String)"REPORT_GENERATION_ID"), (Object)generationId, 0);
            query.addSelectColumn(Column.getColumn((String)inputTable, (String)"INPUT_ID"));
            query.setCriteria(criteria);
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
            Row row = dataObj.getFirstRow(inputTable);
            inputId = (Long)row.get("INPUT_ID");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return inputId;
    }

    public static DataObject getInputIdForSchedulerReportResult(Integer reportId, Long scheduleId, String inputsTable) {
        DataObject dataObject = null;
        try {
            Table baseTable = Table.getTable((String)"ADSMScheduleReportsMapping");
            Table joinTable = Table.getTable((String)inputsTable);
            SelectQueryImpl selectQuery = new SelectQueryImpl(baseTable);
            Join innerJoin = new Join(baseTable, joinTable, new String[]{"SCHEDULER_VALUES_MAPPING"}, new String[]{"REPORT_VALUE_ID"}, 2);
            selectQuery.addJoin(innerJoin);
            selectQuery.addSelectColumn(Column.getColumn((String)"ADSMScheduleReportsMapping", (String)"*"));
            selectQuery.addSelectColumn(Column.getColumn((String)inputsTable, (String)"*"));
            Criteria crit = new Criteria(Column.getColumn((String)"ADSMScheduleReportsMapping", (String)"SCHEDULE_ID"), (Object)scheduleId, 0);
            crit = crit.and(new Criteria(Column.getColumn((String)"ADSMScheduleReportsMapping", (String)"REPORT_ID"), (Object)reportId, 0));
            selectQuery.setCriteria(crit);
            dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)selectQuery);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return dataObject;
    }

    public static void updateReportDaysForRegenerateReport(ReportFilterConfig reportFilterConfig, AdmpInput admpInput, Boolean isSoonToExpireReport) {
        Long initialTime = reportFilterConfig.getInitialTimeForRegenerateReport();
        if (!initialTime.equals(-1L)) {
            String valueStr = admpInput.getValue();
            reportLogger.log(Level.INFO, "Initial Reportday value for reportId " + reportFilterConfig.getReportId() + " is::" + valueStr);
            Date initialDate = new Date(initialTime);
            Date currentDate = new Date();
            Integer daysPassed = DateTimeUtil.daysBetween((Date)initialDate, (Date)currentDate);
            if (daysPassed == 0 && initialDate.getDay() != currentDate.getDay()) {
                daysPassed = 1;
            }
            Integer intVal = Integer.valueOf(valueStr);
            if (isSoonToExpireReport.booleanValue()) {
                if ((intVal = Integer.valueOf(intVal - daysPassed)) < 0) {
                    intVal = 0;
                }
            } else {
                intVal = intVal + daysPassed;
            }
            valueStr = intVal.toString();
            admpInput.setValue(valueStr);
            reportLogger.log(Level.INFO, "DaysPassed since automation started ::" + daysPassed + ". Updated Reportday value::" + valueStr);
        }
    }

    public static void getCustomizedSingleValues(ArrayList attributeList, ArrayList resultList, Long loginId, AdventNetResourceBundle rb) {
        try {
            Integer[] attribIds = new Integer[]{1039, 1040, 1029, 1035, 1030, 1044, 2008, 2009, 3011, 3012, 3019, 5039, 5040, 6023, 6024, 8005, 8006, 1022, 9054, 9056, 9057, 10013, 10014, 11013, 11014, 1192, 3033, 1033, 3025, 1150, 11146, 7036, 7037};
            for (int j = 0; j < resultList.size(); ++j) {
                Hashtable resultTable = (Hashtable)resultList.get(j);
                for (int i = 0; i < attributeList.size(); ++i) {
                    Properties attributeProperties = (Properties)attributeList.get(i);
                    Integer relationalType = (Integer)attributeProperties.get("RELATIONAL_TYPE");
                    if (relationalType.equals(new Integer(1))) continue;
                    String columnName = attributeProperties.getProperty("ATTRIB_COLUMN_NAME");
                    Integer attributeId = (Integer)attributeProperties.get("ATTRIB_ID");
                    String transformerClassName = (String)attributeProperties.get("TRANSFORMER_CLASS");
                    if (resultTable.get(attributeId) == null) continue;
                    Transformers uiTransformer = (Transformers)Class.forName(transformerClassName.trim()).newInstance();
                    HashMap<String, Object> colDetails = new HashMap<String, Object>();
                    colDetails.put("TRIM_SIZE", attributeProperties.get("TRIM_SIZE"));
                    Object val = uiTransformer.renderCell(rb, columnName, resultTable.get(attributeId), colDetails, new HashMap(), true);
                    String value = (String)resultTable.get(attributeId);
                    value = String.valueOf(val);
                    if (Arrays.asList(attribIds).contains(attributeId)) {
                        String attrVal = null;
                        if (attributeId.equals(new Integer(1033))) {
                            if (value.equals("0")) {
                                attrVal = rb.getString("admp.reports.common.reportresulttxt.must_change_at_next_logon");
                            }
                        } else if (attributeId.equals(new Integer(1150))) {
                            if (value.equals("0")) {
                                attrVal = rb.getString("admp.reports.common.reportresulttxt.must_change_at_next_logon");
                            } else if (value.equals("-1")) {
                                attrVal = rb.getString("admp.reports.user.pwd_exp_date.never_expires");
                            }
                        }
                        if (attrVal == null) {
                            if (!value.equals("0") && !value.equals("-")) {
                                if (attributeId.equals(new Integer(1031)) || attributeId.equals(new Integer(1150))) {
                                    Hashtable props = DateTimeUtil.getDateTimeFormats((Long)loginId);
                                    String format = props.get("dateFormat") + " " + props.get("timeFormat");
                                    Date dateToformat = DateTimeUtil.getDateFromLong((String)format, (long)Long.parseLong(value), (long)loginId);
                                    attrVal = String.valueOf(new SimpleDateFormat(format).format(dateToformat));
                                } else {
                                    attrVal = String.valueOf(DateTimeUtil.getDateFromFileTime((Long)Long.parseLong(value), (Long)loginId));
                                }
                            } else {
                                attrVal = val.toString();
                            }
                        }
                        val = attrVal;
                    }
                    resultTable.put(attributeId, val);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void fillInputValues(AbstractListener listener, Integer reportId, HttpServletRequest request) {
        ListenerUtil.fillDomainDetails(listener.getGenerationId(), request);
        try {
            DataObject dataObj = ListenerUtil.getInputTablesDO(reportId);
            if (dataObj != null) {
                Iterator it = dataObj.getRows("ADSMInputMappingDetails");
                JSONObject params = new JSONObject(request.getParameter("params"));
                while (it.hasNext()) {
                    Row r = (Row)it.next();
                    String tableName = (String)r.get("INPUT_TABLE_NAME");
                    String key = (String)r.get("KEY_VALUE");
                    Long isMultiInput = (Long)r.get("IS_MULTI_INPUT");
                    if (isMultiInput == 1L) {
                        System.out.println("Error :: Multiple Input value '" + key + "' is skipped for reportId:" + reportId);
                        continue;
                    }
                    Hashtable<String, Object> hash = new Hashtable<String, Object>();
                    String value = params.has(key) ? params.get(key).toString() : null;
                    if (value == null) continue;
                    hash.put("INPUT_PROPERTY_NAME", key);
                    hash.put("INPUT_PROPERTY_VALUE", value);
                    hash.put("REPORT_GENERATION_ID", listener.getGenerationId());
                    ListenerUtil.fillValues(tableName, reportId, hash, listener.getGenerationId());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void fillDomainDetails(Long generationId, HttpServletRequest request) {
        HashMap<String, Cloneable> containerDetails = new HashMap<String, Cloneable>();
        try {
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            Hashtable domainsAndOUs = HDTDomainHandler.getDomainsAndOUs((Long)loginId);
            Hashtable dnDomainNameMap = (Hashtable)domainsAndOUs.get("dnDomainNameMap");
            containerDetails.put("dnDomainNameMap", dnDomainNameMap);
            JSONObject params = new JSONObject(request.getParameter("params"));
            JSONArray domainList = null;
            Hashtable domainVsExcludeChildOU = new Hashtable();
            if (params.has("selectedDomain")) {
                domainList = new JSONArray().put((Object)params.getString("selectedDomain"));
                containerDetails.put("domains", (Cloneable)domainList);
            } else if (params.has("selectedDomains")) {
                domainList = new JSONArray(params.getString("selectedDomains"));
                containerDetails.put("domains", (Cloneable)domainList);
            }
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
            for (int i = 0; i < domainList.length(); ++i) {
                String domainName = domainList.getString(i);
                Boolean excludeChildOU = null;
                if (excludeChildOU == null) {
                    excludeChildOU = Boolean.FALSE;
                }
                Row r = new Row("ADSMReportDomainDetails");
                r.set("DOMAIN_DN_NAME", (Object)DomainUtil.getDefaultNamingContext((String)domainName));
                r.set("DOMAIN_NAME", (Object)domainName);
                r.set("REPORT_GENERATION_ID", (Object)generationId);
                r.set("EXCLUDE_CHILD_OU", (Object)excludeChildOU);
                dataObj.addRow(r);
            }
            CommonUtil.getPersistence((boolean[])new boolean[0]).add(dataObj);
            ArrayList containerList = ListenerUtil.getContainerList(request, containerDetails);
            Object excludeContainerHash = null;
            containerDetails.put("excludeContainerHash", (Cloneable)excludeContainerHash);
            containerDetails.put("containerList", containerList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        request.setAttribute("containerDetails", containerDetails);
    }

    public static ArrayList getContainerList(HttpServletRequest request, HashMap hash) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            JSONArray domains = (JSONArray)hash.get("domains");
            Hashtable domainOUList = new Hashtable();
            Hashtable excludeChildOUHash = new Hashtable();
            Hashtable excludedOUHash = new Hashtable();
            if (domains != null) {
                for (int i = 0; i < domains.length(); ++i) {
                    String domainName = domains.getString(i);
                    String defaultNamingContext = DomainUtil.getDefaultNamingContext((String)domainName);
                    ArrayList ouList = (ArrayList)domainOUList.get(defaultNamingContext);
                    Boolean excludeChildOU = (Boolean)excludeChildOUHash.get(domainName);
                    ArrayList excludedOUList = (ArrayList)excludedOUHash.get(domainName);
                    if (ouList == null || ouList.size() == 0) {
                        ArrayList ous = ClientAuthorizationUtil.getAuthorizedOUList(request, domainName);
                        if (ous != null && ous.size() > 0) {
                            list.addAll(ous);
                            continue;
                        }
                        list.add(defaultNamingContext);
                        continue;
                    }
                    if (excludeChildOU != null && excludeChildOU.booleanValue()) {
                        list.addAll(ouList);
                        continue;
                    }
                    if (excludedOUList != null && !excludedOUList.isEmpty()) {
                        list.addAll(DirectoryObjectUtil.getParentOUsWithExcluded(ouList, excludedOUList));
                        continue;
                    }
                    list.addAll(DirectoryObjectUtil.getParentOUs(ouList));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static HashMap getInputValues(Long generationId, Integer reportId, HttpServletRequest request) {
        HashMap containerDetails = ListenerUtil.getDomainDetails(generationId, reportId, request);
        HashMap<String, Cloneable> inputParams = new HashMap<String, Cloneable>();
        inputParams.put("containerDetails", containerDetails);
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"ADSMInputMappingDetails", (String)"REPORT_ID"), (Object)reportId, 0);
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMInputMappingDetails", crit);
            Iterator it = dataObj.getRows("ADSMInputMappingDetails");
            while (it.hasNext()) {
                Row r = (Row)it.next();
                String tableName = (String)r.get("INPUT_TABLE_NAME");
                String key = (String)r.get("KEY_VALUE");
                ArrayList list = ListenerUtil.getInputDetails(tableName, generationId, inputParams, key);
                inputParams.put(key, list);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return inputParams;
    }

    private static Properties getDomainProps(Integer reportId, String domainName, HttpServletRequest request) {
        ArrayList domainList = ListenerUtil.getDomainList(reportId, request);
        for (int i = 0; i < domainList.size(); ++i) {
            Properties domainProp = (Properties)domainList.get(i);
            String domainStr = domainProp.getProperty("DOMAIN_NAME");
            if (!domainName.equalsIgnoreCase(domainStr)) continue;
            return domainProp;
        }
        return null;
    }

    private static ArrayList getDomainList(Integer reportId, HttpServletRequest request) {
        ArrayList domainList = new ArrayList();
        try {
            HttpSession session = request.getSession();
            Long actionId = 0L;
            Criteria criteria = new Criteria(Column.getColumn((String)"ADSMReports", (String)"REPORT_ID"), (Object)reportId, 0);
            DataObject dataobj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMReports", criteria);
            if (!dataobj.isEmpty()) {
                Row r = dataobj.getFirstRow("ADSMReports");
                actionId = (Long)r.get("ACTION_ID");
            }
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
            Hashtable domainVsactions = authObject.getDomainActionMap();
            domainList = HDTDomainHandler.getDomainListForUser((Long)loginId, (Hashtable)domainVsactions, (Long)actionId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return domainList;
    }

    public static void fillUIValueCases(JSONArray attributeList, Integer reportId, ArrayList<Integer> uIValueCases) {
        try {
            for (int i = 0; i < attributeList.length(); ++i) {
                JSONObject attributeProperties = attributeList.getJSONObject(i);
                Integer relationalType = (Integer)attributeProperties.get("RELATIONAL_TYPE");
                if (relationalType == 1) {
                    uIValueCases.add(-1);
                    continue;
                }
                String column = attributeProperties.getString("ATTRIB_COLUMN_NAME");
                Integer attributeId = (Integer)attributeProperties.get("ATTRIB_ID");
                if (column.equalsIgnoreCase("ACCOUNT_EXPIRY_DATE")) {
                    uIValueCases.add(4);
                    continue;
                }
                if (column.equalsIgnoreCase("PASSWORD_EXPIRY_DATE")) {
                    uIValueCases.add(5);
                    continue;
                }
                if (column.equalsIgnoreCase("DAYS_TO_EXPIRE_PASSWORD")) {
                    uIValueCases.add(6);
                    continue;
                }
                if (column.equalsIgnoreCase("DAYS_SINCE_LAST_LOGON")) {
                    uIValueCases.add(7);
                    continue;
                }
                if (column.equalsIgnoreCase("DAYS_SINCE_PASSWORD_SET")) {
                    uIValueCases.add(8);
                    continue;
                }
                if (dateTimeCols.contains(column)) {
                    if (column.equalsIgnoreCase("PASSWORD_LAST_SET") && (reportId > 300 || reportId < 200)) {
                        uIValueCases.add(9);
                        continue;
                    }
                    uIValueCases.add(3);
                    continue;
                }
                if (column.equalsIgnoreCase("MAX_USER_COUNT")) {
                    uIValueCases.add(10);
                    continue;
                }
                if (attributeProperties.getString("TRANSFORMER_CLASS").equalsIgnoreCase("com.adventnet.sym.adsm.common.webclient.transformers.CustomFieldsTransformers")) {
                    uIValueCases.add(11);
                    continue;
                }
                uIValueCases.add(1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getUICustomizedValues(Object obj, Integer valueCase, Long loginId, AdventNetResourceBundle rb) {
        String val = obj.toString();
        String dash = "-";
        switch (Integer.valueOf(valueCase)) {
            case 1: {
                return val;
            }
            case 2: {
                return dash;
            }
            case 3: {
                return val.equals("0") ? val : DateTimeUtil.getDateFromFileTime((Long)Long.parseLong(val), (Long)loginId);
            }
            case 4: {
                return val.equals("0") ? rb.getString("admp.reports.user.account_exp_date.never_expires") : DateTimeUtil.getAccountExpiresDateFromFileTime((Long)Long.parseLong(val), (AdventNetResourceBundle)rb, (Long)loginId);
            }
            case 5: {
                switch (val) {
                    case "0": {
                        return rb.getString("admp.reports.common.reportresulttxt.must_change_at_next_logon");
                    }
                    case "1": {
                        return rb.getString("admp.reports.user.pwd_exp_date.never_expires");
                    }
                    case "-2": {
                        return dash;
                    }
                }
                return DateTimeUtil.formatDate((Long)Long.parseLong(val), (Long)loginId);
            }
            case 6: {
                return ClientUtil.getLocalizedString(rb, DateTimeUtil.getDaysToExpire((String)val, (AdventNetResourceBundle)rb));
            }
            case 7: {
                return val.equals("0") ? rb.getString("admp.common.text.not_applicable") : String.valueOf(DateTimeUtil.getNoOfDays((Long)Long.parseLong(val)));
            }
            case 8: {
                return rb.getString(DateTimeUtil.getDaysSincePasswordSet((String)val));
            }
            case 9: {
                return val.equals("0") ? rb.getString("admp.reports.common.reportresulttxt.must_change_at_next_logon") : DateTimeUtil.getDateFromFileTime((Long)Long.parseLong(val), (Long)loginId);
            }
            case 10: {
                return val.equals("-1") ? rb.getString("admp.reports.ntfs_reports.shares_in_servers.reportresulttxt.max_allowed") : val;
            }
            case 11: {
                return val.equals("0") ? dash : DateTimeUtil.getDateFromFileTime((Long)Long.parseLong(val), (Long)loginId);
            }
        }
        return val;
    }

    public static String getUICustomizedValues(Integer attributeId, String columnName, Object obj, Integer reportId, Long loginId, String transformerClassName) {
        String ret = obj.toString();
        return ret;
    }

    public static void setDashboardInputParams(Long dashboardReportMapping, HttpServletRequest request, ReportBean bean, int caseId) {
        try {
            switch (caseId) {
                case 1: 
                case 2: {
                    Criteria crit = new Criteria(new Column("DashboardReportInputVals", "DASHBOARD_REPORT_MAPPING"), (Object)dashboardReportMapping, 0);
                    DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("DashboardReportInputVals", crit);
                    Long reportDays = Long.parseLong((String)dataObj.getFirstRow("DashboardReportInputVals").get("VALUE"));
                    Long value = reportDays * 24L * 60L * 60L * 1000L;
                    SimpleDateFormat formatter1 = new SimpleDateFormat("dd-MMM-yyyy", Locale.US);
                    String startDateVal = null;
                    String endDateVal = null;
                    String dateCritText = null;
                    if (caseId == 1) {
                        dateCritText = "admp.common.matching_criteria.last_N_days";
                        startDateVal = formatter1.format(new Date(System.currentTimeMillis() - value));
                        endDateVal = formatter1.format(new Date(System.currentTimeMillis()));
                    } else {
                        dateCritText = "admp.common.matching_criteria.next_N_days";
                        startDateVal = formatter1.format(new Date(System.currentTimeMillis()));
                        endDateVal = formatter1.format(new Date(System.currentTimeMillis() + value));
                    }
                    HashMap inputParams = (HashMap)bean.get("reportInputParams");
                    inputParams.put("dateLable", ListenerUtil.getInputValueAsList(dateCritText));
                    inputParams.put("startDate", ListenerUtil.getInputValueAsList(startDateVal));
                    inputParams.put("endDate", ListenerUtil.getInputValueAsList(endDateVal));
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

