/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.reports;

import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.AdmpInput;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.automation.ReportFilterConfig;
import com.adventnet.sym.adsm.common.server.layout.component.FcOption;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.queue.QueueHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportHandler;
import com.adventnet.sym.adsm.common.server.reports.StatusUpdater;
import com.adventnet.sym.adsm.common.server.resultdata.ResultDataHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.UserHandler;
import com.adventnet.sym.adsm.common.webclient.reports.GroupsForUsersListener;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class ManagerUsersListener
extends GroupsForUsersListener {
    @Override
    public Long getCategoryId() {
        Long categoryId = new Long(1003L);
        return categoryId;
    }

    @Override
    public void removeInputParams(ReportBean bean) {
        HashMap reportInputParams = (HashMap)bean.get("reportInputParams");
        if (reportInputParams != null && reportInputParams.containsKey("trusteesList")) {
            reportInputParams.put("trusteesList", new ArrayList());
        }
    }

    @Override
    public String getOutputFilterLabelText() {
        return "admp.reports.manager_report.text.showing_manager_of";
    }

    public void doAction(String domainName, String distinguishedName, ArrayList attributeList, NativeListener listener) throws Exception {
    }

    @Override
    public void doAction(String domainName, Long loginId, String distinguishedName, String trusteeSID, ArrayList attributeList, NativeListener listener) throws Exception {
        ADHandler.getManagerBasedUsers((String)domainName, (Long)loginId, (String)distinguishedName, (String)trusteeSID, (ArrayList)attributeList, (NativeListener)listener);
    }

    @Override
    public void start(ArrayList attributeList, HttpServletRequest request, ReportBean bean) {
        try {
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            this.checkAttributeList(attributeList);
            HashMap reportInputParams = (HashMap)bean.get("reportInputParams");
            String[] domainList = request.getParameterValues("domains");
            ArrayList containerList = this.getContainerList(request, bean);
            Hashtable domainVsExcludeChildOU = (Hashtable)bean.get("domainVsExcludeChildOU");
            Hashtable dnDomainNameMap = (Hashtable)bean.get("dnDomainNameMap");
            String reportDomains = this.getReportDomains(domainList, dnDomainNameMap);
            this.getDescription(new Object[]{reportDomains});
            Hashtable excludedOUList = (Hashtable)bean.get("excludedOUList");
            Hashtable excludeContainerHash = this.constructExcludeContainerHash(containerList, domainVsExcludeChildOU, excludedOUList, dnDomainNameMap);
            this.statusController.setProgressTask(StatusUpdater.TASKCODE.FETCTING_MANAGER_USERS.getValue());
            Action action = new Action(loginId, containerList, reportInputParams, dnDomainNameMap, attributeList, this, excludeContainerHash);
            action.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void executeTask(ArrayList containerList, Hashtable dnDomainNameMap, ReportFilterConfig reportFilterConfig) {
        this.executeTask(containerList, dnDomainNameMap, null, null, reportFilterConfig);
    }

    @Override
    public void executeTask(ArrayList containerList, Hashtable dnDomainNameMap, Hashtable excludedOUList, Hashtable domainVsExcludeChildOU, ReportFilterConfig reportFilterConfig) {
        try {
            String dnName = "";
            String sidStr = "";
            this.isCompleted = false;
            for (AdmpInput admpInput : reportFilterConfig.getInputList()) {
                if (!admpInput.getIsMultiple().booleanValue()) continue;
                for (FcOption fcOption : admpInput.getMultipleInput()) {
                    if (!fcOption.getLabel().equalsIgnoreCase("SID_STRING")) continue;
                    sidStr = fcOption.getValue();
                }
            }
            this.domainName = (String)dnDomainNameMap.get(containerList.get(0));
            String dn = UserHandler.getUserDN((String)this.domainName, (String)sidStr, (Long)this.loginId);
            String schedulerDomains = this.getSchedulerDomains(containerList, dnDomainNameMap);
            this.getDescription(new Object[]{schedulerDomains});
            this.generationId = ReportHandler.addReportGenerationDetails((Integer)this.reportId, (String)this.desc, (Long)this.loginId);
            Hashtable<String, Object> inputs = new Hashtable<String, Object>();
            inputs.put("INPUT_NAME", sidStr);
            inputs.put("DISTINGUISHED_NAME", dn);
            inputs.put("REPORT_GENERATION_ID", this.generationId);
            inputs.put("INPUT_ID", 1L);
            ArrayList<Hashtable<String, Object>> inputList = new ArrayList<Hashtable<String, Object>>();
            inputList.add(inputs);
            HashMap<String, ArrayList<Hashtable<String, Object>>> reportInputParams = new HashMap<String, ArrayList<Hashtable<String, Object>>>();
            reportInputParams.put("trusteesList", inputList);
            Hashtable excludeContainerHash = this.constructExcludeContainerHash(containerList, domainVsExcludeChildOU, excludedOUList, dnDomainNameMap);
            Action action = new Action(this.loginId, containerList, reportInputParams, dnDomainNameMap, this.getAttributeList(), this, excludeContainerHash);
            action.start();
            while (!this.isCompleted) {
                try {
                    Thread.sleep(200L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ReportHandler.updateReportGenerationDetails((Long)this.generationId, (int)1, (String)this.desc, (Long)this.loginId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public class Action
    extends Thread {
        private Long loginId = null;
        private ArrayList containerList = null;
        private Map inputParams = null;
        private Hashtable dnDomainNameMap = null;
        private ArrayList attributeList = null;
        private NativeListener listener = null;
        private Hashtable excludeChildOUHash = null;

        public Action(Long loginId, ArrayList containerList, Map inputParams, Hashtable dnDomainNameMap, ArrayList attributeList, NativeListener li, Hashtable excludeChildOUHash) {
            this.loginId = loginId;
            this.containerList = containerList;
            this.inputParams = inputParams;
            this.dnDomainNameMap = dnDomainNameMap;
            this.attributeList = attributeList;
            this.excludeChildOUHash = excludeChildOUHash;
            this.listener = li;
        }

        @Override
        public void run() {
            ManagerUsersListener.this.errorMessage = null;
            if (!ManagerUsersListener.this.errorList.isEmpty()) {
                ManagerUsersListener.this.errorList = new Hashtable();
            }
            ArrayList inputsList = (ArrayList)this.inputParams.get("trusteesList");
            Hashtable tableProps = ManagerUsersListener.this.getQueueProps();
            ArrayList objectIds = ManagerUsersListener.this.getObjIdList();
            ManagerUsersListener.this.queueRegID = QueueHandler.getInstance().registerForUpdate(objectIds, ManagerUsersListener.this.getTableColumns());
            ManagerUsersListener.this.resultRegID = ResultDataHandler.getInstance().getProcessor().registerForUpdate(ManagerUsersListener.this.resultTableName);
            for (int i = 0; i < inputsList.size(); ++i) {
                Hashtable inputValues = (Hashtable)inputsList.get(i);
                if (ManagerUsersListener.this.statusController != null) {
                    ManagerUsersListener.this.statusController.setTaskObject((Object)((String)inputValues.get("INPUT_NAME")));
                }
                for (int j = 0; j < this.containerList.size(); ++j) {
                    Hashtable<String, String> errors;
                    try {
                        String distinguishedName = (String)this.containerList.get(j);
                        ManagerUsersListener.this.domainName = (String)this.dnDomainNameMap.get(distinguishedName);
                        Boolean isExcludeChildOU = Boolean.FALSE;
                        if (this.excludeChildOUHash != null && this.excludeChildOUHash.containsKey(distinguishedName)) {
                            isExcludeChildOU = (Boolean)this.excludeChildOUHash.get(distinguishedName);
                        }
                        this.listener.setIsExcludeChildOU(isExcludeChildOU);
                        tableProps.put("inputId", (Long)inputValues.get("INPUT_ID"));
                        ManagerUsersListener.this.queue.registerForUpdation(ManagerUsersListener.this.baseTableName, ManagerUsersListener.this.generationId, tableProps);
                        ManagerUsersListener.this.addlResultIps.put("INPUT_ID", (Long)inputValues.get("INPUT_ID"));
                        ManagerUsersListener.this.doAction(ManagerUsersListener.this.domainName, this.loginId, distinguishedName, (String)inputValues.get("DISTINGUISHED_NAME"), this.attributeList, this.listener);
                        ManagerUsersListener.this.updateQueue();
                        continue;
                    }
                    catch (LocalizedException e) {
                        e.printStackTrace();
                        ManagerUsersListener.this.errorMessage = e.getMessage(ManagerUsersListener.this.rb);
                        errors = new Hashtable();
                        errors.put("INPUT_NAME", (String)inputValues.get("INPUT_NAME"));
                        errors.put("ERROR_MESSAGE", ManagerUsersListener.this.errorMessage);
                        ManagerUsersListener.this.errorList.put(inputValues.get("INPUT_ID").toString(), errors);
                        ManagerUsersListener.this.updateErrorStatus(errors);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        ManagerUsersListener.this.errorMessage = e.getMessage();
                        errors = new Hashtable<String, String>();
                        errors.put("INPUT_NAME", (String)inputValues.get("INPUT_NAME"));
                        errors.put("ERROR_MESSAGE", ManagerUsersListener.this.errorMessage);
                        ManagerUsersListener.this.errorList.put(inputValues.get("INPUT_ID").toString(), errors);
                        ManagerUsersListener.this.updateErrorStatus(errors);
                    }
                }
            }
            ManagerUsersListener.this.updatedCount = 0;
            ManagerUsersListener.this.totalCount = 0;
            ManagerUsersListener.this.completedAction();
        }
    }
}

