/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.reports;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.multidc.MultiDCHandler;
import com.adventnet.sym.adsm.common.server.multidc.MultiDCStatus;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.webclient.reports.AbstractListener;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.reports.ReportDomain;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class MultiDCListener
extends AbstractListener {
    protected String dcName = null;
    private Hashtable reportDomain = null;

    public Hashtable getReportDomains(HttpServletRequest request, ReportBean bean, Long loginId) {
        ArrayList containerList = super.getContainerList(request, bean);
        Hashtable dnDomainNameMap = (Hashtable)bean.get("dnDomainNameMap");
        return this.getReportDomains(loginId, containerList, dnDomainNameMap);
    }

    public Hashtable getReportDomains(ArrayList containerList, Hashtable dnDomainNameMap, Hashtable excludedOUList, Hashtable domainVsExcludeChildOU) {
        ArrayList resultContainerList = super.getContainerList(containerList, dnDomainNameMap, excludedOUList, domainVsExcludeChildOU);
        return this.getReportDomains(this.loginId, resultContainerList, dnDomainNameMap);
    }

    public Hashtable getReportDomains(Long loginId, ArrayList containerList, Hashtable dnDomainNameMap) {
        this.reportDomain = new Hashtable();
        for (int i = 0; i < containerList.size(); ++i) {
            String container = (String)containerList.get(i);
            String domName = (String)dnDomainNameMap.get(container);
            if (domName != null) {
                ReportDomain domain;
                if (this.reportDomain.get(domName) == null) {
                    domain = new ReportDomain();
                    domain.setDomainDetails(domName, loginId, 1);
                    domain.addContainer(container);
                    this.reportDomain.put(domName, domain);
                    continue;
                }
                domain = (ReportDomain)this.reportDomain.get(domName);
                domain.addContainer(container);
                continue;
            }
            System.out.println(" The - " + container + " - might have been moved manually");
        }
        return this.reportDomain;
    }

    @Override
    public ArrayList getDBCustomizedValues(String columnName, String ldapName, Properties prop) {
        ArrayList<String> ret = super.getDBCustomizedValues(columnName, ldapName, prop);
        if (columnName.equalsIgnoreCase("DOMAIN_CONTROLLER_NAME")) {
            ret = new ArrayList<String>();
            ret.add(this.dcName);
        }
        return ret;
    }

    public static void updateCount(Hashtable dcVsGuidAndBadPwdCount, String columnName, String tableName) {
        Hashtable result = new Hashtable();
        Enumeration dcNames = dcVsGuidAndBadPwdCount.keys();
        while (dcNames.hasMoreElements()) {
            String dcName = (String)dcNames.nextElement();
            Hashtable guidVsbadPwdCount = (Hashtable)dcVsGuidAndBadPwdCount.get(dcName);
            Enumeration guids = guidVsbadPwdCount.keys();
            while (guids.hasMoreElements()) {
                String guid = (String)guids.nextElement();
                Long badPwdCount = (Long)guidVsbadPwdCount.get(guid);
                MultiDCListener.addtoResult(result, guid, badPwdCount);
            }
        }
        MultiDCListener.updateGuidVsCount(result, columnName, tableName);
    }

    public static void addtoResult(Hashtable result, String guid, Long badPwdCount) {
        Long countStr = (Long)result.get(guid);
        if (countStr != null) {
            countStr = countStr + badPwdCount;
            result.put(guid, countStr);
        } else {
            result.put(guid, badPwdCount);
        }
    }

    public static void updateGuidVsCount(Hashtable result, String columnName, String tableName) {
        String keyColumnName = "OBJECT_GUID";
        try {
            Criteria crit = new Criteria(new Column(tableName, keyColumnName), null, 1);
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get(tableName, crit);
            if (!dataObj.isEmpty()) {
                Iterator it = dataObj.getRows(tableName);
                while (it.hasNext()) {
                    Row r = (Row)it.next();
                    String guid = (String)r.get(keyColumnName);
                    if (result.get(guid) == null) continue;
                    r.set(columnName, result.get(guid));
                    dataObj.updateRow(r);
                }
            }
            CommonUtil.getPersistence((boolean[])new boolean[0]).update(dataObj);
        }
        catch (Exception e) {
            System.out.println("Exception while updating badpwdcount to table");
            e.printStackTrace();
        }
    }

    public void disableDC(String domName, String dcName) {
        ReportDomain domain = (ReportDomain)this.reportDomain.get(domName);
        domain.setDCStatus(dcName, 1);
    }

    public void enableDC(String domName, String dcName) {
        ReportDomain domain = (ReportDomain)this.reportDomain.get(domName);
        domain.setDCStatus(dcName, 0);
    }

    public void updateStatus(String dcName) {
        if (this.statusController != null) {
            this.statusController.setTaskObject((Object)dcName);
        }
        this.updateMultiDCStatus(this.domainName, dcName, "domain_animated.gif", null);
        this.updateOtherDCStatus();
    }

    public void updateDCErrorStatus() {
        if (this.multiDC && this.resultObject == null) {
            Hashtable dcStatusMap = MultiDCHandler.getInstance().getDCStatus(this.queueRegID, this.domainName);
            System.out.println(" dcStatusMap :: " + dcStatusMap);
            Enumeration e = dcStatusMap.keys();
            while (e.hasMoreElements()) {
                Hashtable dcStatus;
                Integer statusCode;
                String dc = (String)e.nextElement();
                if (this.dcName.equalsIgnoreCase(dc) || MultiDCStatus.ERROR != (statusCode = (Integer)(dcStatus = (Hashtable)dcStatusMap.get(dc)).get("status"))) continue;
                Hashtable<String, String> errors = new Hashtable<String, String>();
                errors.put("INPUT_NAME", dc);
                errors.put("ERROR_MESSAGE", (String)dcStatus.get("errStr"));
                this.updateErrorStatus(errors);
            }
        }
    }

    public void updateOtherDCStatus() {
        if (this.multiDC && this.resultObject == null) {
            Hashtable dcStatus = MultiDCHandler.getInstance().getStatus(this.queueRegID, this.domainName);
            Enumeration e = dcStatus.keys();
            while (e.hasMoreElements()) {
                String dc = (String)e.nextElement();
                if (this.dcName.equalsIgnoreCase(dc)) continue;
                Integer statusCode = (Integer)dcStatus.get(dc);
                if (MultiDCStatus.FINISHED == statusCode) {
                    this.updateMultiDCStatus(this.domainName, dc, "domain_check.gif", null);
                    continue;
                }
                if (MultiDCStatus.ERROR == statusCode) {
                    this.updateMultiDCStatus(this.domainName, dc, "domain_error.jpg", null);
                    continue;
                }
                this.updateMultiDCStatus(this.domainName, dc, "domain_animated.gif", null);
            }
        }
    }

    public void updateMultiDCStatus(String domainName, String dcName, String imageName, Integer count) {
        if (this.statusController != null) {
            JSONObject multiDCDetails = this.statusController.getMultiDCDetails();
            try {
                JSONObject domainNameVsDCProps = multiDCDetails.getJSONObject(domainName);
                JSONObject dcProperies = domainNameVsDCProps.getJSONObject(dcName);
                if (imageName != null) {
                    dcProperies.put("image", (Object)imageName);
                }
                if (count != null) {
                    dcProperies.put("count", (Object)count);
                }
            }
            catch (JSONException jsonEx) {
                System.out.println("JSONException multiDCDetails " + multiDCDetails + " dcName " + dcName + " domainName :: " + domainName);
                jsonEx.printStackTrace();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void updateCompletionStatus() {
        this.updateMultiDCStatus(this.domainName, this.dcName, "domain_check.gif", this.updatedCount);
        this.updateOtherDCCount();
        this.updateOtherDCStatus();
    }

    @Override
    public void updateUI(Properties uiValues, String objectClass, String guid, String str) {
        ++this.updatedCount;
        this.updateMultiDCStatus(this.domainName, this.dcName, null, this.updatedCount);
        this.updateOtherDCCount();
    }

    public void updateOtherDCCount() {
        if (this.multiDC && this.resultObject == null) {
            Hashtable dcCount = MultiDCHandler.getInstance().getCount(this.queueRegID, this.domainName);
            Enumeration e = dcCount.keys();
            while (e.hasMoreElements()) {
                String dc = (String)e.nextElement();
                if (this.dcName.equalsIgnoreCase(dc)) continue;
                Long count = (Long)dcCount.get(dc);
                this.updateMultiDCStatus(this.domainName, dc, null, count.intValue());
            }
        }
        this.updateOtherDCStatus();
    }

    public Hashtable getReportDomains() {
        return this.reportDomain;
    }

    protected Hashtable getDomainContainers(ArrayList containerList, Hashtable dnDomainNameMap) {
        Hashtable<String, ArrayList<String>> hash = new Hashtable<String, ArrayList<String>>();
        for (int i = 0; i < containerList.size(); ++i) {
            String dn = (String)containerList.get(i);
            String domain = (String)dnDomainNameMap.get(dn);
            ArrayList<String> containers = (ArrayList<String>)hash.get(domain);
            if (containers == null) {
                containers = new ArrayList<String>();
                hash.put(domain, containers);
            }
            containers.add(dn);
        }
        return hash;
    }

    protected long getWindowsFileTime(long time) {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        cal.set(1601, 0, 1, 0, 0, 0);
        cal.set(14, 0);
        long t = cal.getTime().getTime();
        return (time - t) * 10000L;
    }

    protected Hashtable getReportDomainVsDCDetails(Hashtable reportDomains) {
        Hashtable reportDomainVsDCMap = new Hashtable();
        Enumeration e = reportDomains.keys();
        while (e.hasMoreElements()) {
            String domainName = (String)e.nextElement();
            ReportDomain reportDomain = (ReportDomain)reportDomains.get(domainName);
            ArrayList dclist = reportDomain.getDCList();
            Hashtable<String, String> dcMap = new Hashtable<String, String>();
            for (int index = 0; index < dclist.size(); ++index) {
                Hashtable hash = (Hashtable)dclist.get(index);
                String dcName = (String)hash.get("dcName");
                dcMap.put(dcName, "0");
            }
            reportDomainVsDCMap.put(domainName, dcMap);
        }
        return reportDomainVsDCMap;
    }
}

