/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.reports;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.reports.ComputerHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportAttributeHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportReqParams;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.webclient.reports.AbstractListener;
import com.adventnet.sym.adsm.common.webclient.reports.AbstractNTFSReportsListener;
import com.adventnet.sym.adsm.common.webclient.reports.DBWriterUtil;
import com.adventnet.sym.adsm.common.webclient.reports.ListenerUtil;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.reports.ReportExportUtil;
import com.adventnet.sym.adsm.common.webclient.reports.TableUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.validator.DynaValidatorForm;

public class NTFSReportsListener
extends AbstractNTFSReportsListener {
    @Override
    public Long getCategoryId() {
        Long categoryId = new Long(-1L);
        return categoryId;
    }

    @Override
    public boolean isResultViewOutputFilterAvailable() {
        return true;
    }

    @Override
    public boolean isPermissionColumnIncluded() {
        return true;
    }

    @Override
    public String getOutputFilterLabelText() {
        return "admp.reports.folder_report.text.showing_folder_of";
    }

    @Override
    protected void checkAttributeList(ArrayList attributeList) {
    }

    @Override
    protected void doAction(String domainName, Long loginId, String dn, ArrayList attributeList, NativeListener listener) throws Exception {
    }

    protected void doAction(String domainName, String directoryPath, String userDn, Long loginId, ArrayList attributeList, NativeListener listener) throws Exception {
    }

    protected void doAction(String domainName, String directoryPath, String userDn, Long loginId, ArrayList attributeList, String permValue, NativeListener listener) throws Exception {
        ADHandler.getFilesOverAnyControl((String)domainName, (String)directoryPath, (String)userDn, (Long)loginId, (ArrayList)attributeList, (String)permValue, (NativeListener)listener);
    }

    public Criteria getReportResultFilterCriteria(HttpServletRequest request, DynaValidatorForm bean, Criteria crit) {
        try {
            String columnName = "INPUT_ID";
            ArrayList<String> inputObjects = (ArrayList<String>)bean.get("inputObjects");
            String[] inputFiltervalues = request.getParameterValues("inputs");
            if (inputFiltervalues != null) {
                inputObjects = new ArrayList<String>();
                crit = crit == null ? new Criteria(new Column(this.resultTableName, columnName), (Object)inputFiltervalues, 8) : crit.and(new Criteria(new Column(this.resultTableName, columnName), (Object)inputFiltervalues, 8));
                for (int i = 0; i < inputFiltervalues.length; ++i) {
                    inputObjects.add(inputFiltervalues[i]);
                    Hashtable errorValues = (Hashtable)this.errorList.get(inputFiltervalues[i]);
                    if (errorValues == null) continue;
                    if (this.errorMessage == null) {
                        this.errorMessage = (String)errorValues.get("ERROR_MESSAGE");
                        continue;
                    }
                    if (this.errorMessage.contains((String)errorValues.get("ERROR_MESSAGE"))) continue;
                    this.errorMessage = this.errorMessage + "," + (String)errorValues.get("ERROR_MESSAGE");
                }
                bean.set("inputObjects", inputObjects);
            } else if (!inputObjects.isEmpty()) {
                String[] inputValues = new String[inputObjects.size()];
                for (int i = 0; i < inputObjects.size(); ++i) {
                    inputValues[i] = (String)inputObjects.get(i);
                }
                crit = crit == null ? new Criteria(new Column(this.resultTableName, columnName), (Object)inputValues, 8) : crit.and(new Criteria(new Column(this.resultTableName, columnName), (Object)inputValues, 8));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return crit;
    }

    @Override
    public Criteria getReportResultFilterCriteria(HttpServletRequest request, DynaValidatorForm bean, Criteria crit, String inputId) {
        try {
            String columnName = "INPUT_ID";
            ArrayList inputObjects = (ArrayList)bean.get("inputObjects");
            crit = !inputObjects.contains(inputId) && inputObjects.size() != 0 ? (crit == null ? new Criteria(new Column(this.resultTableName, columnName), (Object)0L, 0) : crit.and(new Criteria(new Column(this.resultTableName, columnName), (Object)0L, 0))) : (crit == null ? new Criteria(new Column(this.resultTableName, columnName), (Object)inputId, 0) : crit.and(new Criteria(new Column(this.resultTableName, columnName), (Object)inputId, 0)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return crit;
    }

    @Override
    public void fillInputDetails(String inputTable, HttpServletRequest request, ReportBean bean, String key) {
        HashMap inputParams = (HashMap)bean.get("reportInputParams");
        Hashtable dnDomainNameMap = (Hashtable)bean.get("dnDomainNameMap");
        String[] domainList = (String[])bean.get("domains");
        ArrayList valuesList = new ArrayList();
        if (inputTable.equalsIgnoreCase("ADSMReportSIDInputDetails")) {
            ArrayList trusteesList = (ArrayList)bean.get("trusteesList");
            for (int i = 0; i < trusteesList.size(); ++i) {
                Hashtable<String, Object> inputs = new Hashtable<String, Object>();
                String inputName = CommonUtil.getDisplayName((String)((String)dnDomainNameMap.get(domainList[0])), (String)((String)trusteesList.get(i)));
                inputs.put("INPUT_NAME", inputName);
                String dn = CommonUtil.getDistinguishedName((String)((String)dnDomainNameMap.get(domainList[0])), (String)((String)trusteesList.get(i)));
                inputs.put("DISTINGUISHED_NAME", dn);
                inputs.put("INPUT_OBJECT_ID", (String)trusteesList.get(i));
                inputs.put("REPORT_GENERATION_ID", this.generationId);
                ListenerUtil.fillValues(inputTable, this.reportId, inputs, this.generationId);
                valuesList.add(inputs);
            }
        } else if (inputTable.equalsIgnoreCase("ADSMReportShareInputDetails")) {
            Hashtable<String, Object> inputs = new Hashtable<String, Object>();
            String sharePath = request.getParameter(key);
            String sid = request.getParameter("serverSid");
            inputs.put("SERVER_SID", sid);
            inputs.put("INPUT_NAME", sharePath);
            inputs.put("REPORT_GENERATION_ID", this.generationId);
            ListenerUtil.fillValues(inputTable, this.reportId, inputs, this.generationId);
            valuesList.add(inputs);
        }
        inputParams.put(key, valuesList);
    }

    public NTFSReportsListener() {
        this.tableKey = "SHARE_ID";
        this.tempTableKey = "LOCATION";
        this.attrKey = "Location";
        this.attrKey2 = "Location";
    }

    @Override
    public void init(Row r) {
        this.baseTableName = (String)r.get("BASE_TABLE_NAME");
        this.resultTableName = (String)r.get("RESULT_TABLE_NAME");
        this.reportId = (Integer)r.get("REPORT_ID");
        this.onClickText = (String)r.get("ONCLICK_TEXT");
        if (this.rb == null) {
            this.rb = ResourceBundleMgr.getInstance().getBundle();
        }
        this.title = (String)r.get("REPORT_NAME");
    }

    @Override
    public void updateAttributeList(ReportBean bean, ArrayList attributeList) {
        HashMap reportInputParams = (HashMap)bean.get("reportInputParams");
        ArrayList pathList = (ArrayList)reportInputParams.get("path");
        String[] domains = (String[])bean.get("domains");
        Hashtable dnDomainNameMap = (Hashtable)bean.get("dnDomainNameMap");
        if (pathList != null && !pathList.isEmpty()) {
            Hashtable searchPathValues = (Hashtable)pathList.get(0);
            String sid = (String)searchPathValues.get("SERVER_SID");
            String generatedTableName = ComputerHandler.getName((String)sid, (String)((String)searchPathValues.get("INPUT_NAME")), (String)((String)dnDomainNameMap.get(domains[0])));
            for (int i = 0; i < attributeList.size(); ++i) {
                Properties prop = (Properties)attributeList.get(i);
                String tableName = prop.getProperty("TABLE_NAME");
                if (!tableName.equalsIgnoreCase("ADSMFolderDetails")) continue;
                prop.put("TABLE_NAME", generatedTableName);
            }
            this.baseTableName = generatedTableName;
        }
    }

    @Override
    public void init(HttpServletRequest request, Row r) {
        HttpSession session = request.getSession();
        Locale locale = request.getLocale();
        this.rb = ResourceBundleMgr.getInstance().getBundle(locale);
        this.baseTableName = (String)r.get("BASE_TABLE_NAME");
        this.resultTableName = (String)r.get("RESULT_TABLE_NAME");
        this.reportId = (Integer)r.get("REPORT_ID");
        this.onClickText = (String)r.get("ONCLICK_TEXT");
        this.title = (String)r.get("REPORT_NAME");
        this.setGenerationId(request);
    }

    @Override
    public void addRow(Properties prop, String guid, Hashtable tableRowMap, Hashtable relationalTableRowMap, Properties uiValues, Hashtable stringRowMap) {
        try {
            Object values = null;
            ArrayList tableNames = ReportAttributeHandler.getInstance().getTableNames(this.reportId);
            int baseTableIndex = tableNames.indexOf(this.baseTableName);
            if (baseTableIndex > 0) {
                tableNames.remove(baseTableIndex);
                tableNames.add(0, this.baseTableName);
            }
            for (int i = 0; i < tableNames.size(); ++i) {
                ArrayList writerTableList;
                String tableName = (String)tableNames.get(i);
                ArrayList attributeList = ReportAttributeHandler.getInstance().getAttributes(tableName, this.reportId);
                if (tableName.equalsIgnoreCase("ADSMFolderDetails")) {
                    tableName = this.baseTableName;
                }
                if ((writerTableList = ReportAttributeHandler.getInstance().getWriterTables()) != null && writerTableList.contains(tableName)) {
                    DBWriterUtil.createStringRows(tableName, attributeList, stringRowMap, prop, uiValues, this, this.tableKey, guid);
                    continue;
                }
                this.createRows(tableName, attributeList, tableRowMap, relationalTableRowMap, prop, uiValues, this.tableKey, guid);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Hashtable getQueueProps() {
        Hashtable<String, Object> tableProps = new Hashtable<String, Object>();
        tableProps.put("baseTableName", this.baseTableName);
        tableProps.put("resultTableName", this.resultTableName);
        tableProps.put("generationId", this.generationId);
        tableProps.put("resultHandling", "updateMultiValues");
        tableProps.put("tableKey", "LOCATION");
        return tableProps;
    }

    @Override
    public void start(ArrayList attributeList, HttpServletRequest request, ReportBean bean) {
        try {
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            this.checkAttributeList(attributeList);
            String directoryPath = request.getParameter("path");
            String sid = request.getParameter("serverSid");
            HashMap reportInputParams = (HashMap)bean.get("reportInputParams");
            ArrayList permValue = (ArrayList)reportInputParams.get("permValue");
            if (permValue != null) {
                Hashtable permValueList = (Hashtable)permValue.get(0);
                this.desc = MessageFormat.format(this.rb.getString("admp.reports.ntfs_reports.full_control.reportdesc_report_generated_for_server_with_perm"), directoryPath, this.rb.getString((String)permValueList.get("INPUT_PROPERTY_VALUE")));
            } else {
                this.desc = MessageFormat.format(this.rb.getString("admp.reports.ntfs_reports.full_control.reportdesc_report_generated_for_server"), directoryPath);
            }
            String dn = request.getParameter("domains");
            String domainName = null;
            if (dn != null) {
                Hashtable dnDomainNameMap = (Hashtable)bean.get("dnDomainNameMap");
                domainName = (String)dnDomainNameMap.get(dn);
            } else {
                Properties domainProps = HDTDomainHandler.getSelectedDomain((Long)loginId);
                domainName = domainProps.getProperty("DOMAIN_NAME");
            }
            Action action = new Action(loginId, domainName, reportInputParams, attributeList, sid, this);
            action.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void updateQueue() {
        try {
            while (!this.queue.isCompleted(this.generationId)) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void exportReport(Row reportDetails, String reportType, ArrayList attributelist, Map inputParams, HttpServletRequest request, HttpServletResponse response, String reportList, AbstractListener listener, ArrayList trusteesList, ReportReqParams reqParams) {
        ReportExportUtil.exportReportForHugeData(reportDetails, reportType, attributelist, inputParams, request, response, reportList, listener, trusteesList, reqParams);
    }

    public class Action
    extends Thread {
        private String domainName = null;
        private ArrayList attributeList = null;
        private NativeListener listener = null;
        private Map inputParams = null;
        private Long loginId = null;
        private String serverSid = null;

        public Action(Long loginId, String domainName, Map inputParams, ArrayList attributeList, String serverSid, NativeListener li) {
            this.domainName = domainName;
            this.loginId = loginId;
            this.attributeList = attributeList;
            this.listener = li;
            this.serverSid = serverSid;
            this.inputParams = inputParams;
        }

        @Override
        public void run() {
            NTFSReportsListener.this.errorMessage = null;
            if (!NTFSReportsListener.this.errorList.isEmpty()) {
                NTFSReportsListener.this.errorList = new Hashtable();
            }
            ArrayList searchPath = (ArrayList)this.inputParams.get("path");
            HashMap serverVsShares = ComputerHandler.getSharesListForServers((ArrayList)searchPath, (Long)this.loginId, (String)this.domainName);
            Hashtable searchPathValues = (Hashtable)searchPath.get(0);
            NTFSReportsListener.this.baseTableName = ComputerHandler.getName((String)this.serverSid, (String)((String)searchPathValues.get("INPUT_NAME")), (String)this.domainName);
            TableUtil.createServerTable(NTFSReportsListener.this.baseTableName, "ADSMFolderDetails");
            Hashtable tableProps = NTFSReportsListener.this.getQueueProps();
            if (this.inputParams.containsKey("trusteesList")) {
                String pathName = (String)searchPathValues.get("INPUT_NAME");
                ArrayList<String> sharesList = new ArrayList<String>();
                if (serverVsShares.containsKey(pathName)) {
                    sharesList.addAll((ArrayList)serverVsShares.get(pathName));
                } else {
                    sharesList.add(pathName);
                }
                ArrayList inputsList = (ArrayList)this.inputParams.get("trusteesList");
                ArrayList permValue = (ArrayList)this.inputParams.get("permValue");
                Hashtable permValueList = (Hashtable)permValue.get(0);
                for (int i = 0; i < sharesList.size(); ++i) {
                    for (int j = 0; j < inputsList.size(); ++j) {
                        Hashtable<String, String> errors;
                        Hashtable inputValues = (Hashtable)inputsList.get(j);
                        try {
                            NTFSReportsListener.this.setDomainName(this.domainName);
                            tableProps.put("domainName", this.domainName);
                            tableProps.put("inputId", (Long)inputValues.get("INPUT_ID"));
                            NTFSReportsListener.this.queue.registerForUpdation(NTFSReportsListener.this.baseTableName, NTFSReportsListener.this.generationId, tableProps);
                            NTFSReportsListener.this.doAction(this.domainName, (String)sharesList.get(i), (String)inputValues.get("DISTINGUISHED_NAME"), this.loginId, this.attributeList, (String)permValueList.get("INPUT_PROPERTY_VALUE"), this.listener);
                            NTFSReportsListener.this.updateQueue();
                            continue;
                        }
                        catch (LocalizedException e) {
                            e.printStackTrace();
                            NTFSReportsListener.this.errorMessage = e.getMessage(NTFSReportsListener.this.rb);
                            errors = new Hashtable<String, String>();
                            errors.put("INPUT_NAME", (String)inputValues.get("INPUT_NAME"));
                            errors.put("ERROR_MESSAGE", NTFSReportsListener.this.errorMessage);
                            NTFSReportsListener.this.errorList.put(inputValues.get("INPUT_ID").toString(), errors);
                            NTFSReportsListener.this.updateErrorStatus(errors);
                            continue;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            NTFSReportsListener.this.errorMessage = NTFSReportsListener.this.rb.getString(e.getMessage());
                            errors = new Hashtable();
                            errors.put("INPUT_NAME", (String)inputValues.get("INPUT_NAME"));
                            errors.put("ERROR_MESSAGE", NTFSReportsListener.this.errorMessage);
                            NTFSReportsListener.this.errorList.put(inputValues.get("INPUT_ID").toString(), errors);
                            NTFSReportsListener.this.updateErrorStatus(errors);
                        }
                    }
                }
            } else {
                try {
                    NTFSReportsListener.this.queue.registerForUpdation(NTFSReportsListener.this.baseTableName, NTFSReportsListener.this.generationId, tableProps);
                    NTFSReportsListener.this.doAction(this.domainName, (String)searchPathValues.get("INPUT_NAME"), null, this.loginId, this.attributeList, this.listener);
                    NTFSReportsListener.this.updateQueue();
                }
                catch (LocalizedException e) {
                    e.printStackTrace();
                    NTFSReportsListener.this.errorMessage = e.getMessage(NTFSReportsListener.this.rb);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    NTFSReportsListener.this.errorMessage = e.getMessage();
                }
            }
            NTFSReportsListener.this.updatedCount = 0;
            NTFSReportsListener.this.totalCount = 0;
            NTFSReportsListener.this.completedAction();
        }
    }
}

