/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.reports;

import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.reports.ReportHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.UserHandler;
import com.adventnet.sym.adsm.common.webclient.reports.AbstractListener;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class NestedGroupsListener
extends AbstractListener {
    @Override
    protected void checkAttributeList(ArrayList attributeList) {
        if (!attributeList.contains("userAccountControl")) {
            attributeList.add("userAccountControl");
        }
    }

    @Override
    public void doAction(String domainName, Long loginId, String distinguishedName, ArrayList attributeList, NativeListener listener) throws Exception {
    }

    @Override
    public Hashtable getQueueProps() {
        Hashtable<String, Object> tableProps = new Hashtable<String, Object>();
        tableProps.put("baseTableName", this.baseTableName);
        tableProps.put("resultTableName", this.resultTableName);
        tableProps.put("generationId", this.generationId);
        tableProps.put("resultHandling", "addOrUpdate");
        return tableProps;
    }

    @Override
    public void getDescription(Object[] args) {
        this.desc = MessageFormat.format(this.rb.getString("admp.reports.user_reports.users_in_group.reportdesc_users_in_grp"), args);
    }

    public void doAction(String domainName, Long loginId, ArrayList attributeList, NativeListener listener, String trustee) throws Exception {
        if (trustee == null || trustee.equals("")) {
            throw new Exception("User can't be NULL.");
        }
        ADHandler.getNestedGroups((String)domainName, (Long)loginId, (ArrayList)attributeList, (NativeListener)listener, (String)trustee);
    }

    @Override
    public void setInputParams(HttpServletRequest request, ReportBean bean) {
        String[] domains;
        String domainName = request.getParameter("domainName");
        if (domainName == null && (domains = (String[])bean.get("domains")).length > 0) {
            Hashtable dnDomainNameMap = (Hashtable)bean.get("dnDomainNameMap");
            bean.set("domains", new String[]{domains[0]});
        }
    }

    public void executeTask(ArrayList containerList, Hashtable dnDomainNameMap, ArrayList inputParams) {
        try {
            String dnName = "";
            String input_Params = "";
            if (inputParams != null) {
                for (int i = 0; i < inputParams.size(); ++i) {
                    Hashtable inputs = (Hashtable)inputParams.get(i);
                    if (((ArrayList)inputs.get(this.reportId)).size() > 0) {
                        ArrayList input = (ArrayList)inputs.get(this.reportId);
                        for (int j = 0; j < input.size(); ++j) {
                            Hashtable hash = (Hashtable)input.get(i);
                            input_Params = (String)hash.get("DISTINGUISHED_NAME");
                        }
                    }
                    if (input_Params.contains("/")) {
                        dnName = input_Params.substring(input_Params.indexOf("/") + 1, input_Params.length());
                        input_Params = input_Params.substring(0, input_Params.indexOf("/"));
                        continue;
                    }
                    dnName = input_Params;
                }
            }
            String schedulerDomains = this.getSchedulerDomains(containerList, dnDomainNameMap);
            this.getDescription(new Object[]{input_Params, schedulerDomains});
            this.generationId = ReportHandler.addReportGenerationDetails((Integer)this.reportId, (String)this.desc, (Long)this.loginId);
            Action action = new Action(1L, containerList, this.getAttributeList(), this, dnDomainNameMap, input_Params);
            action.start();
            while (!this.isCompleted) {
                try {
                    Thread.sleep(200L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ReportHandler.updateReportGenerationDetails((Long)this.generationId, (int)1, (String)this.desc, (Long)this.loginId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void start(ArrayList attributeList, HttpServletRequest request, ReportBean bean) {
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        try {
            this.checkAttributeList(attributeList);
            HashMap<String, String> inputParams = new HashMap<String, String>();
            String sid = request.getParameter("trustee");
            String dn = UserHandler.getUserDN((String)sid);
            ArrayList containerList = this.getContainerList(request, bean);
            Hashtable dnDomainNameMap = (Hashtable)bean.get("dnDomainNameMap");
            String[] domainList = request.getParameterValues("domains");
            inputParams.put("domain", ClientUtil.getString(domainList));
            bean.set("inputParams", inputParams);
            String reportDomains = this.getReportDomains(domainList, dnDomainNameMap);
            this.getDescription(new Object[]{dn, reportDomains});
            Action action = new Action(loginId, containerList, attributeList, this, dnDomainNameMap, dn);
            action.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public class Action
    extends Thread {
        private ArrayList containerList = null;
        private ArrayList attributeList = null;
        private NativeListener listener = null;
        private Hashtable dnDomainNameMap = null;
        private String trustee = null;
        private Long loginId = null;

        public Action(Long loginId, ArrayList list, ArrayList attributeList, NativeListener li, Hashtable map, String s) {
            this.loginId = loginId;
            this.containerList = list;
            this.attributeList = attributeList;
            this.listener = li;
            this.dnDomainNameMap = map;
            this.trustee = s;
        }

        @Override
        public void run() {
            NestedGroupsListener.this.guidList = new ArrayList();
            Hashtable tableProps = NestedGroupsListener.this.getQueueProps();
            for (int i = 0; i < this.containerList.size(); ++i) {
                try {
                    String dn = (String)this.containerList.get(i);
                    NestedGroupsListener.this.domainName = (String)this.dnDomainNameMap.get(dn);
                    NestedGroupsListener.this.queue.registerForUpdation(NestedGroupsListener.this.baseTableName, NestedGroupsListener.this.generationId, tableProps);
                    System.out.println("Datas for the Report ID " + NestedGroupsListener.this.reportId + ", Attribute List : " + this.attributeList + ", Trustee : " + this.trustee + " Distinguished Name : " + dn);
                    NestedGroupsListener.this.doAction(NestedGroupsListener.this.domainName, this.loginId, this.attributeList, this.listener, this.trustee);
                    NestedGroupsListener.this.updateQueue();
                    continue;
                }
                catch (LocalizedException exc) {
                    exc.printStackTrace();
                    NestedGroupsListener.this.errorMessage = exc.getMessage(NestedGroupsListener.this.rb);
                    System.out.println("LocalizedException: - " + NestedGroupsListener.this.errorMessage);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    NestedGroupsListener.this.errorMessage = e.getMessage();
                }
            }
            NestedGroupsListener.this.updatedCount = 0;
            NestedGroupsListener.this.totalCount = 0;
            NestedGroupsListener.this.completedAction();
        }
    }
}

