/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.reports;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.webclient.reports.AbstractNTFSReportsListener;
import com.adventnet.sym.adsm.common.webclient.reports.ListenerUtil;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.struts.validator.DynaValidatorForm;

public class ObjectsAccessListener
extends AbstractNTFSReportsListener {
    @Override
    public Long getCategoryId() {
        Long categoryId = new Long(-1L);
        return categoryId;
    }

    @Override
    public boolean isResultViewOutputFilterAvailable() {
        return true;
    }

    @Override
    public String getOutputFilterLabelText() {
        return "admp.reports.object_report.text.showing_object_of";
    }

    @Override
    public boolean isPermissionColumnIncluded() {
        return true;
    }

    @Override
    protected void checkAttributeList(ArrayList attributeList) {
        if (!attributeList.contains("userAccountControl")) {
            attributeList.add("userAccountControl");
        }
    }

    @Override
    public void doAction(String domainName, Long loginId, String distinguishedName, ArrayList attributeList, NativeListener listener) throws Exception {
    }

    public void doAction(String domainName, Long loginId, String distinguishedName, String trustee, ArrayList attributeList, NativeListener listener) throws Exception {
    }

    public Criteria getReportResultFilterCriteria(HttpServletRequest request, DynaValidatorForm bean, Criteria crit) {
        try {
            String columnName = "INPUT_ID";
            ArrayList<String> inputObjects = (ArrayList<String>)bean.get("inputObjects");
            String[] inputFiltervalues = request.getParameterValues("inputs");
            if (inputFiltervalues != null) {
                inputObjects = new ArrayList<String>();
                crit = crit == null ? new Criteria(new Column(this.resultTableName, columnName), (Object)inputFiltervalues, 8) : crit.and(new Criteria(new Column(this.resultTableName, columnName), (Object)inputFiltervalues, 8));
                for (int i = 0; i < inputFiltervalues.length; ++i) {
                    inputObjects.add(inputFiltervalues[i]);
                    Hashtable errorValues = (Hashtable)this.errorList.get(inputFiltervalues[i]);
                    if (errorValues == null) continue;
                    if (this.errorMessage == null) {
                        this.errorMessage = (String)errorValues.get("ERROR_MESSAGE");
                        continue;
                    }
                    if (this.errorMessage.contains((String)errorValues.get("ERROR_MESSAGE"))) continue;
                    this.errorMessage = this.errorMessage + "," + (String)errorValues.get("ERROR_MESSAGE");
                }
                bean.set("inputObjects", inputObjects);
            } else if (!inputObjects.isEmpty()) {
                String[] inputValues = new String[inputObjects.size()];
                for (int i = 0; i < inputObjects.size(); ++i) {
                    inputValues[i] = (String)inputObjects.get(i);
                }
                crit = crit == null ? new Criteria(new Column(this.resultTableName, columnName), (Object)inputValues, 8) : crit.and(new Criteria(new Column(this.resultTableName, columnName), (Object)inputValues, 8));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return crit;
    }

    @Override
    public Criteria getReportResultFilterCriteria(HttpServletRequest request, DynaValidatorForm bean, Criteria crit, String inputId) {
        try {
            String columnName = "INPUT_ID";
            ArrayList inputObjects = (ArrayList)bean.get("inputObjects");
            String[] inputFiltervalues = request.getParameterValues("inputs");
            crit = !inputObjects.contains(inputId) && inputObjects.size() != 0 ? (crit == null ? new Criteria(new Column(this.resultTableName, columnName), (Object)0L, 0) : crit.and(new Criteria(new Column(this.resultTableName, columnName), (Object)0L, 0))) : (crit == null ? new Criteria(new Column(this.resultTableName, columnName), (Object)inputId, 0) : crit.and(new Criteria(new Column(this.resultTableName, columnName), (Object)inputId, 0)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return crit;
    }

    @Override
    public void fillInputDetails(String inputTable, HttpServletRequest request, ReportBean bean, String key) {
        ArrayList trusteesList = (ArrayList)bean.get("trusteesList");
        HashMap inputParams = (HashMap)bean.get("reportInputParams");
        Hashtable dnDomainNameMap = (Hashtable)bean.get("dnDomainNameMap");
        String[] domainList = (String[])bean.get("domains");
        ArrayList valuesList = new ArrayList();
        for (int i = 0; i < trusteesList.size(); ++i) {
            Hashtable<String, Object> inputs = new Hashtable<String, Object>();
            String inputName = CommonUtil.getDisplayName((String)((String)dnDomainNameMap.get(domainList[0])), (String)((String)trusteesList.get(i)));
            inputs.put("INPUT_NAME", inputName);
            String dn = CommonUtil.getDistinguishedName((String)((String)dnDomainNameMap.get(domainList[0])), (String)((String)trusteesList.get(i)));
            inputs.put("DISTINGUISHED_NAME", dn);
            inputs.put("INPUT_OBJECT_ID", (String)trusteesList.get(i));
            inputs.put("REPORT_GENERATION_ID", this.generationId);
            ListenerUtil.fillValues(inputTable, this.reportId, inputs, this.generationId);
            valuesList.add(inputs);
        }
        inputParams.put(key, valuesList);
    }

    @Override
    public void start(ArrayList attributeList, HttpServletRequest request, ReportBean bean) {
        try {
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            this.checkAttributeList(attributeList);
            HashMap reportInputParams = (HashMap)bean.get("reportInputParams");
            String dn = request.getParameter("domains");
            String domainName = null;
            if (dn != null) {
                Hashtable dnDomainNameMap = (Hashtable)bean.get("dnDomainNameMap");
                domainName = (String)dnDomainNameMap.get(dn);
            } else {
                Properties domainProps = HDTDomainHandler.getSelectedDomain((Long)loginId);
                domainName = domainProps.getProperty("DOMAIN_NAME");
            }
            this.getDescription(new Object[]{domainName});
            Action action = new Action(loginId, domainName, reportInputParams, attributeList, this, dn);
            action.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public class Action
    extends Thread {
        private Map inputParams = null;
        private String domainName = null;
        private ArrayList attributeList = null;
        private NativeListener listener = null;
        private Long loginId = null;
        private String distinguishedName = null;

        public Action(Long loginId, String domainName, Map inputParams, ArrayList attributeList, NativeListener li, String distinguishedName) {
            this.domainName = domainName;
            this.loginId = loginId;
            this.attributeList = attributeList;
            this.listener = li;
            this.inputParams = inputParams;
            this.distinguishedName = distinguishedName;
        }

        @Override
        public void run() {
            ObjectsAccessListener.this.errorMessage = null;
            if (!ObjectsAccessListener.this.errorList.isEmpty()) {
                ObjectsAccessListener.this.errorList = new Hashtable();
            }
            Hashtable tableProps = ObjectsAccessListener.this.getQueueProps();
            ArrayList inputsList = (ArrayList)this.inputParams.get("trusteesList");
            for (int i = 0; i < inputsList.size(); ++i) {
                Hashtable<String, String> errors;
                Hashtable inputValues = (Hashtable)inputsList.get(i);
                try {
                    ObjectsAccessListener.this.setDomainName(this.domainName);
                    tableProps.put("inputId", (Long)inputValues.get("INPUT_ID"));
                    ObjectsAccessListener.this.queue.registerForUpdation(ObjectsAccessListener.this.baseTableName, ObjectsAccessListener.this.generationId, tableProps);
                    ObjectsAccessListener.this.doAction(this.domainName, this.loginId, this.distinguishedName, (String)inputValues.get("INPUT_OBJECT_ID"), this.attributeList, this.listener);
                    ObjectsAccessListener.this.updateQueue();
                    continue;
                }
                catch (LocalizedException e) {
                    e.printStackTrace();
                    ObjectsAccessListener.this.errorMessage = e.getMessage(ObjectsAccessListener.this.rb);
                    errors = new Hashtable();
                    errors.put("INPUT_NAME", (String)inputValues.get("INPUT_NAME"));
                    errors.put("ERROR_MESSAGE", ObjectsAccessListener.this.errorMessage);
                    ObjectsAccessListener.this.errorList.put(inputValues.get("INPUT_ID").toString(), errors);
                    ObjectsAccessListener.this.updateErrorStatus(errors);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    ObjectsAccessListener.this.errorMessage = e.getMessage();
                    errors = new Hashtable<String, String>();
                    errors.put("INPUT_NAME", (String)inputValues.get("INPUT_NAME"));
                    errors.put("ERROR_MESSAGE", ObjectsAccessListener.this.errorMessage);
                    ObjectsAccessListener.this.errorList.put(inputValues.get("INPUT_ID").toString(), errors);
                    ObjectsAccessListener.this.updateErrorStatus(errors);
                }
            }
            ObjectsAccessListener.this.updatedCount = 0;
            ObjectsAccessListener.this.totalCount = 0;
            ObjectsAccessListener.this.completedAction();
        }
    }
}

