/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.reports;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.persistence.internal.UniqueValueHolder;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.reports.ComputerHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportAttributeHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportReqParams;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBUtil;
import com.adventnet.sym.adsm.common.server.util.ReportAttributesUtil;
import com.adventnet.sym.adsm.common.webclient.reports.AbstractNTFSReportsListener;
import com.adventnet.sym.adsm.common.webclient.reports.ListenerUtil;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.reports.ReportResultUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.struts.validator.DynaValidatorForm;
import org.json.JSONArray;
import org.json.JSONObject;

public class PermissionOverObjectsListener
extends AbstractNTFSReportsListener {
    protected static Logger reportLogger = Logger.getLogger("ReportLogger");
    protected static Hashtable genIdTableKeyMap = new Hashtable();

    @Override
    public Long getCategoryId() {
        Long categoryId = new Long(-1L);
        return categoryId;
    }

    @Override
    public boolean isResultViewOutputFilterAvailable() {
        return true;
    }

    @Override
    public String getOutputFilterLabelText() {
        return "admp.reports.shares_report.text.showing_shares_of";
    }

    @Override
    protected void checkAttributeList(ArrayList attributeList) {
        if (!attributeList.contains("userAccountControl")) {
            attributeList.add("userAccountControl");
        }
    }

    @Override
    public void doAction(String domainName, Long loginId, String distinguishedName, ArrayList attributeList, NativeListener listener) throws Exception {
        Properties prop = ADHandler.getTrusteeForObjects((String)domainName, (Long)loginId, (String)distinguishedName, (ArrayList)attributeList, (NativeListener)listener);
        if (prop != null) {
            ArrayList propList = (ArrayList)prop.get("acls");
            ArrayList<String> trustees = new ArrayList<String>();
            for (int i = 0; i < propList.size(); ++i) {
                Properties finalProp = new Properties();
                Properties values = (Properties)propList.get(i);
                ArrayList val = (ArrayList)values.get("sid");
                ArrayList<Properties> finalList = new ArrayList<Properties>();
                for (int j = 0; j < propList.size(); ++j) {
                    Properties values1 = (Properties)propList.get(j);
                    Properties permissionProp = new Properties();
                    if (!values1.contains(val)) continue;
                    permissionProp.put("permissionStr", (ArrayList)values1.get("permissionStr"));
                    permissionProp.put("inputName", (ArrayList)values1.get("inputName"));
                    permissionProp.put("appliesTo", (ArrayList)values1.get("appliesTo"));
                    permissionProp.put("aceType", (ArrayList)values1.get("aceType"));
                    finalList.add(permissionProp);
                }
                if (!trustees.contains((String)val.get(0))) {
                    finalProp.put("permission", finalList);
                    finalProp.put("trustee", values.get("trustee"));
                    finalProp.put("objectType", values.get("objectType"));
                    finalProp.put("sid", val);
                    if (values.get("domain") != null) {
                        finalProp.put("domain", values.get("domain"));
                    } else {
                        finalProp.put("domain", new ArrayList());
                    }
                    trustees.add((String)val.get(0));
                }
                if (finalProp.size() <= 0) continue;
                this.addRow(finalProp);
            }
        }
    }

    public void doAction(String domainName, Long loginId, String distinguishedName, String trustee, ArrayList attributeList, NativeListener listener) throws Exception {
    }

    public PermissionOverObjectsListener() {
        this.tableKey = "ACLS_ID";
        this.tempTableKey = "TRUSTEE_SID";
        this.attrKey = "sid";
        this.attrKey2 = "sid";
    }

    @Override
    public Hashtable getQueueProps() {
        Hashtable<String, Object> tableProps = new Hashtable<String, Object>();
        tableProps.put("baseTableName", this.baseTableName);
        tableProps.put("resultTableName", this.resultTableName);
        tableProps.put("generationId", this.generationId);
        tableProps.put("resultHandling", "addUniqueValues");
        tableProps.put("tableKey", "ACLS_ID");
        return tableProps;
    }

    @Override
    public void updateNativeErrorMessage(ReportReqParams reqParams) {
        JSONArray rvcFiltersArray = reqParams.getRvcFilters();
        try {
            if (rvcFiltersArray != null && rvcFiltersArray.length() > 0) {
                String[] inputFiltervalues = new String[rvcFiltersArray.length()];
                for (int index = 0; index < rvcFiltersArray.length(); ++index) {
                    JSONObject rvcFilterObject = (JSONObject)rvcFiltersArray.get(index);
                    Iterator iterator = rvcFilterObject.keys();
                    while (iterator.hasNext()) {
                        String inputId = (String)iterator.next();
                        Hashtable errorValues = (Hashtable)this.errorList.get((String)rvcFilterObject.get(inputId));
                        if (errorValues == null) continue;
                        if (this.errorMessage == null) {
                            this.errorMessage = (String)errorValues.get("ERROR_MESSAGE");
                            continue;
                        }
                        this.errorMessage = this.errorMessage + "," + (String)errorValues.get("ERROR_MESSAGE");
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Criteria getReportResultFilterCriteria(HttpServletRequest request, DynaValidatorForm bean, Criteria crit, String inputId) {
        try {
            String columnName = "INPUT_ID";
            ArrayList inputObjects = (ArrayList)bean.get("inputObjects");
            ArrayList tableNames = ReportAttributeHandler.getInstance().getTableNames(this.reportId);
            String permissionTableName = "ADSMPermissionDetails";
            permissionTableName = this.reportId == 958 || this.reportId == 307 ? "ADSMSubnetPermissionDetails" : permissionTableName;
            HashMap inputParams = (HashMap)bean.get("reportInputParams");
            Hashtable<String, String> inputs = new Hashtable<String, String>();
            ArrayList inputList = (ArrayList)inputParams.get("trusteesList");
            for (int i = 0; i < inputList.size(); ++i) {
                Hashtable hash = (Hashtable)inputList.get(i);
                Long input = (Long)hash.get("INPUT_ID");
                inputs.put(input.toString(), (String)hash.get("DISTINGUISHED_NAME"));
            }
            String inputName = (String)inputs.get(inputId);
            crit = !inputObjects.contains(inputId) && inputObjects.size() != 0 ? (crit == null ? new Criteria(new Column(this.resultTableName, columnName), (Object)0L, 0) : crit.and(new Criteria(new Column(this.resultTableName, columnName), (Object)0L, 0))) : (crit == null ? new Criteria(new Column(this.resultTableName, columnName), (Object)inputId, 0) : crit.and(new Criteria(new Column(this.resultTableName, columnName), (Object)inputId, 0)));
            crit = crit.and(new Criteria(new Column(permissionTableName, "INPUT_DN"), (Object)inputName, 0));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return crit;
    }

    @Override
    public void fillInputDetails(String inputTable, HttpServletRequest request, ReportBean bean, String key) {
        ArrayList trusteesList = (ArrayList)bean.get("trusteesList");
        HashMap inputParams = (HashMap)bean.get("reportInputParams");
        Hashtable dnDomainNameMap = (Hashtable)bean.get("dnDomainNameMap");
        String[] domainList = (String[])bean.get("domains");
        ArrayList valuesList = new ArrayList();
        for (int i = 0; i < trusteesList.size(); ++i) {
            Hashtable<String, Object> inputs = new Hashtable<String, Object>();
            String inputName = ComputerHandler.getDN((String)((String)trusteesList.get(i)), (String)((String)dnDomainNameMap.get(domainList[0])));
            String dn = ComputerHandler.getDistinguishedName((String)((String)trusteesList.get(i)), (String)((String)dnDomainNameMap.get(domainList[0])));
            if (inputTable.equalsIgnoreCase("ADSMReportGUIDInputDetails")) {
                inputName = ComputerHandler.getSubnetName((String)((String)trusteesList.get(i)));
                dn = ComputerHandler.getSubnetDistinguishedName((String)((String)trusteesList.get(i)));
            }
            inputs.put("INPUT_NAME", inputName);
            inputs.put("DISTINGUISHED_NAME", dn);
            inputs.put("INPUT_OBJECT_ID", (String)trusteesList.get(i));
            inputs.put("REPORT_GENERATION_ID", this.generationId);
            ListenerUtil.fillValues(inputTable, this.reportId, inputs, this.generationId);
            valuesList.add(inputs);
        }
        inputParams.put(key, valuesList);
    }

    @Override
    public Criteria getMultiValueCrit(HttpServletRequest request, String resultTableName, DynaValidatorForm bean, ReportReqParams reqParams) {
        Criteria crit = null;
        JSONArray rvcFiltersArray = reqParams.getRvcFilters();
        try {
            String columnName = "INPUT_DN";
            String permissionTableName = "ADSMPermissionDetails";
            if (rvcFiltersArray != null && rvcFiltersArray.length() > 0) {
                String[] inputFiltervalues = new String[rvcFiltersArray.length()];
                for (int index = 0; index < rvcFiltersArray.length(); ++index) {
                    JSONObject rvcFilterObject = (JSONObject)rvcFiltersArray.get(index);
                    Iterator iterator = rvcFilterObject.keys();
                    while (iterator.hasNext()) {
                        String inputId = (String)iterator.next();
                        inputFiltervalues[index] = (String)rvcFilterObject.get(inputId);
                    }
                }
                crit = new Criteria(new Column(permissionTableName, columnName), (Object)inputFiltervalues, 8);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return crit;
    }

    @Override
    public void addRow(Properties prop, String guid, Hashtable tableRowMap, Hashtable relationalTableRowMap, Properties uiValues) {
        try {
            ArrayList values = null;
            ArrayList tableNames = ReportAttributeHandler.getInstance().getTableNames(this.reportId);
            int baseTableIndex = tableNames.indexOf(this.baseTableName);
            if (baseTableIndex > 0) {
                tableNames.remove(baseTableIndex);
                tableNames.add(0, this.baseTableName);
            }
            ArrayList writerTableList = ReportAttributeHandler.getInstance().getWriterTables();
            for (int i = 0; i < tableNames.size(); ++i) {
                String tableName = (String)tableNames.get(i);
                ArrayList attributeList = ReportAttributeHandler.getInstance().getAttributes(tableName, this.reportId);
                ArrayList<Object> rowList = new ArrayList<Object>();
                Row r = null;
                Integer relationalType = null;
                ArrayList<Row> multipleTableRowList = new ArrayList<Row>();
                for (int j = 0; j < attributeList.size(); ++j) {
                    Properties p = (Properties)attributeList.get(j);
                    String ldapName = (String)p.get("ATTRIB_LDAP_NAME");
                    String columnName = (String)p.get("ATTRIB_COLUMN_NAME");
                    Integer attributeId = (Integer)p.get("ATTRIB_ID");
                    relationalType = (Integer)p.get("RELATIONAL_TYPE");
                    if (this.toBeExecutedAttributeList != null && !this.toBeExecutedAttributeList.contains(ldapName)) continue;
                    values = (ArrayList)prop.get(ldapName);
                    values = this.getDBCustomizedValues(columnName, ldapName, prop);
                    StringBuffer buf = new StringBuffer();
                    if (relationalType.equals(new Integer(1))) {
                        buf.append("-");
                        if (values != null && !values.isEmpty()) {
                            for (int k = 0; k < values.size(); ++k) {
                                String value = (String)values.get(k);
                                Row r1 = null;
                                if (multipleTableRowList.size() > k) {
                                    r1 = (Row)multipleTableRowList.get(k);
                                } else {
                                    r1 = new Row(tableName);
                                    multipleTableRowList.add(k, r1);
                                }
                                r1.set(columnName, (Object)value);
                                if (tableRowMap.size() > 0) {
                                    this.getUniqueId(this.generationId, r1, guid);
                                    r1.set(this.tempTableKey, (Object)guid);
                                }
                                buf.append(value);
                                if (k == values.size() - 1) continue;
                                buf.append(",");
                            }
                        } else {
                            if (r == null) {
                                r = new Row(tableName);
                            }
                            r.set(columnName, (Object)"-");
                        }
                    } else if (values != null && !values.isEmpty()) {
                        if (r == null) {
                            r = new Row(tableName);
                        }
                        r.set(columnName, values.get(0));
                        buf.append(values.get(0));
                    } else {
                        if (r == null) {
                            r = new Row(tableName);
                        }
                        r.set(columnName, (Object)"-");
                        buf.append("-");
                    }
                    if (!this.viewAttributeList.contains(attributeId)) continue;
                    uiValues.put(attributeId, buf.toString());
                }
                if (r != null) {
                    Hashtable sidVsAclIdMap = (Hashtable)genIdTableKeyMap.get(this.generationId);
                    if (sidVsAclIdMap == null) {
                        sidVsAclIdMap = new Hashtable();
                    }
                    if (sidVsAclIdMap.get(guid) == null) {
                        Hashtable<String, Object> securityprincipalMap = new Hashtable<String, Object>();
                        PermissionOverObjectsListener.fillGeneratedValues(r);
                        sidVsAclIdMap.put(guid, securityprincipalMap);
                        securityprincipalMap.put(this.tableKey, r.get(this.tableKey));
                        securityprincipalMap.put("SECURITY_PRINCIPAL", r.get("SECURITY_PRINCIPAL"));
                        rowList.add(r);
                    }
                    genIdTableKeyMap.put(this.generationId, sidVsAclIdMap);
                }
                if (multipleTableRowList.size() > 0) {
                    rowList.addAll(multipleTableRowList);
                }
                if (relationalType.equals(new Integer(0))) {
                    tableRowMap.put(tableName, rowList);
                    continue;
                }
                if (rowList.size() <= 0) continue;
                relationalTableRowMap.put(tableName, rowList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void fillGeneratedValues(Row rowToFill) throws DataAccessException {
        DataAccess.generateValues((Row)rowToFill);
        int size = rowToFill.getColumns().size();
        for (int i = 1; i <= size; ++i) {
            Object value = rowToFill.get(i);
            if (!(value instanceof UniqueValueHolder)) continue;
            rowToFill.set(i, ((UniqueValueHolder)value).getValue());
        }
    }

    public void getUniqueId(Long generationId, Row r, String guid) {
        try {
            Hashtable sidVsAclIdMap = (Hashtable)genIdTableKeyMap.get(generationId);
            Hashtable aclIdVsSecurityPrincipal = (Hashtable)sidVsAclIdMap.get(guid);
            r.set(this.tableKey, aclIdVsSecurityPrincipal.remove("ACLS_ID"));
            r.set("SECURITY_PRINCIPAL", aclIdVsSecurityPrincipal.get("SECURITY_PRINCIPAL"));
            PermissionOverObjectsListener.fillGeneratedValues(r);
            aclIdVsSecurityPrincipal.put(this.tableKey, r.get(this.tableKey));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void addRow(Properties prop) {
        if (this.noOfObjects == null || this.reportId == null) {
            this.continueAction = false;
            System.out.println("Number Of Objects exceeded beyond the License Limit");
            return;
        }
        if (!this.noOfObjects.equalsIgnoreCase("unlimited")) {
            try {
                int licensedCount = Integer.parseInt(this.noOfObjects);
                if (this.reportId < 100 && this.totalCount >= licensedCount || this.totalCount >= licensedCount && licensedCount == 100) {
                    this.updateQueue();
                    this.continueAction = false;
                    System.out.println("Number Of Objects exceeded beyond the License Limit");
                    return;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            String guid = this.getGuid(prop);
            if (guid == null) {
                reportLogger.log(Level.INFO, "SID is NULL for the Properties : " + prop);
                return;
            }
            ++this.totalCount;
            Hashtable tableRowMap = new Hashtable();
            Hashtable relationalTableRowMap = new Hashtable();
            Properties uiValues = new Properties();
            if (this.updatedCount < 1) {
                this.viewAttributeList = ReportAttributeHandler.getInstance().getViewAttributesList(this.reportId, this.loginId);
            }
            this.addRow(prop, guid, tableRowMap, relationalTableRowMap, uiValues);
            Hashtable sidVsAclIdMap = (Hashtable)genIdTableKeyMap.get(this.generationId);
            Hashtable sidVsAclId = (Hashtable)sidVsAclIdMap.get(guid);
            String uniqueGuid = ((Long)sidVsAclId.get(this.tableKey)).toString();
            this.queue.add(this.generationId, uniqueGuid, tableRowMap, relationalTableRowMap, this.baseTableName);
            if (!this.guidList.contains(uniqueGuid)) {
                this.guidList.add(uniqueGuid);
            }
            StringBuffer b = new StringBuffer();
            b.append("[");
            for (int i = 0; i < this.viewAttributeList.size(); ++i) {
                Integer attributeId = (Integer)this.viewAttributeList.get(i);
                b.append("'");
                String s = (String)uiValues.get(attributeId);
                if (s == null || s.trim().equalsIgnoreCase("")) {
                    b.append("-");
                } else {
                    s = ListenerUtil.getDynamicUpdateValues(attributeId, s);
                    b.append(s);
                }
                b.append("'");
                if (i == this.viewAttributeList.size() - 1) continue;
                b.append(",");
            }
            b.append("]");
            this.updateUI(uiValues, null, guid, b.toString());
            this.queue.checkForNextUpdate(this.generationId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public ArrayList getDBCustomizedValues(String columnName, String ldapName, Properties prop) {
        ArrayList<String> ret = super.getDBCustomizedValues(columnName, ldapName, prop);
        ArrayList values = (ArrayList)prop.get(ldapName);
        if (ldapName.equalsIgnoreCase("permission")) {
            ret = new ArrayList<String>();
            for (int i = 0; i < values.size(); ++i) {
                ArrayList val;
                Properties p = (Properties)values.get(i);
                if (columnName.equalsIgnoreCase("ACE_TYPE")) {
                    val = (ArrayList)p.get("aceType");
                    ret.add(this.rb.getString((String)val.get(0)));
                    continue;
                }
                if (columnName.equalsIgnoreCase("APPLIES_TO")) {
                    val = (ArrayList)p.get("appliesTo");
                    ret.add(this.rb.getString((String)val.get(0)));
                    continue;
                }
                if (columnName.equalsIgnoreCase("INPUT_DN")) {
                    val = (ArrayList)p.get("inputName");
                    ret.add(this.rb.getString((String)val.get(0)));
                    continue;
                }
                if (columnName.equalsIgnoreCase("INHERITED_ACE")) {
                    val = (ArrayList)p.get("isInherited");
                    ret.add(this.rb.getString((String)val.get(0)));
                    continue;
                }
                if (!columnName.equalsIgnoreCase("PERMISSION")) continue;
                val = (ArrayList)p.get("permissionStr");
                Object object = val.get(0);
                if (object instanceof List) {
                    ArrayList permList = (ArrayList)object;
                    StringBuffer permissionsBuffer = new StringBuffer();
                    for (int j = 0; j < permList.size(); ++j) {
                        String[] permListKeys = ((String)permList.get(j)).split(" ");
                        if (j != 0) {
                            permissionsBuffer.append(", ");
                        }
                        for (int k = 0; k < permListKeys.length; ++k) {
                            permissionsBuffer.append(this.rb.getString(permListKeys[k]));
                        }
                    }
                    ret.add(permissionsBuffer.toString());
                    continue;
                }
                if (!(object instanceof String)) continue;
                String permString = (String)object;
                String[] permList = permString.split(",");
                StringBuffer permissionsBuffer = new StringBuffer();
                for (int j = 0; j < permList.length; ++j) {
                    String[] permListKeys = permList[j].split(" ");
                    if (j != 0) {
                        permissionsBuffer.append(", ");
                    }
                    for (int k = 0; k < permListKeys.length; ++k) {
                        if (k != 0) {
                            permissionsBuffer.append(" ");
                        }
                        permissionsBuffer.append(this.rb.getString(permListKeys[k]));
                    }
                }
                ret.add(permissionsBuffer.toString());
            }
        }
        return ret;
    }

    @Override
    public void start(ArrayList attributeList, HttpServletRequest request, ReportBean bean) {
        try {
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            this.checkAttributeList(attributeList);
            HashMap reportInputParams = (HashMap)bean.get("reportInputParams");
            ArrayList sidsList = (ArrayList)bean.get("trusteesList");
            String dn = request.getParameter("domains");
            String domainName = null;
            if (dn != null) {
                Hashtable dnDomainNameMap = (Hashtable)bean.get("dnDomainNameMap");
                domainName = (String)dnDomainNameMap.get(dn);
            } else {
                Properties domainProps = HDTDomainHandler.getSelectedDomain((Long)loginId);
                domainName = domainProps.getProperty("DOMAIN_NAME");
            }
            this.getDescription(new Object[]{domainName});
            Action action = new Action(loginId, domainName, reportInputParams, attributeList, this, dn);
            action.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setReportRows(HttpServletRequest request, ReportBean bean, Long generationId, ArrayList attributelist, ReportReqParams reqParams) {
        Integer reportId = (Integer)bean.get("reportId");
        ArrayList tableNames = new ArrayList();
        String[] inputFiltervalues = request.getParameterValues("inputs");
        String inputChange = request.getParameter("inputChange");
        if (inputFiltervalues != null && inputFiltervalues.length > 0) {
            this.updatedCount = 0;
            this.errorMessage = null;
            if (inputChange != null) {
                bean.set("FROM_INDEX", 1L);
                bean.set("PAGE_NUMBER", "1");
            }
        }
        Criteria crit = null;
        Criteria columnSearchCriteria = ReportResultUtil.getColumnSearchCriteria(attributelist, reqParams, tableNames);
        Criteria reportFiltercriteria = this.getReportResultFilterCriteria(request, reqParams, crit);
        if (columnSearchCriteria != null) {
            crit = columnSearchCriteria;
        }
        if (reportFiltercriteria != null) {
            crit = crit != null ? crit.and(reportFiltercriteria) : reportFiltercriteria;
        }
        SelectQuery sq = ReportResultUtil.getCountSQ(crit, generationId, this.getResultTableName(), tableNames, this.tableKey);
        Integer count = DBUtil.getCount((SelectQuery)sq);
        request.setAttribute("recordsCount", (Object)count);
        reportLogger.log(Level.INFO, "REPORT COUNT : " + count);
        if (count != null && count != 0) {
            Integer attributeId;
            if (this.updatedCount == 0) {
                this.updatedCount = -1;
            }
            if ((attributeId = reqParams.getSortAttribId()) == null || attributeId.equals(new Integer(-1))) {
                attributeId = ReportAttributesUtil.getDefaultSortingProp((Integer)reportId, (ArrayList)attributelist);
            }
            String ascending = String.valueOf(reqParams.isSortOrder());
            Properties attributeProp = ListenerUtil.getAttributeProp(attributeId, attributelist);
            if (attributeProp == null) {
                attributeId = ReportAttributesUtil.getDefaultSortingProp((Integer)reportId, (ArrayList)attributelist);
                attributeProp = ListenerUtil.getAttributeProp(attributeId, attributelist);
            }
            Hashtable multipleValuesSids = new Hashtable();
            ArrayList list = ReportResultUtil.getRows(this, generationId, this.getResultTableName(), attributelist, attributeProp, new Boolean(reqParams.isSortOrder()), reqParams.getFromIndex(), reqParams.getRange(), multipleValuesSids, reportFiltercriteria, columnSearchCriteria, this.tableKey, new ArrayList<String>());
            PermissionOverObjectsListener.fillObjectType(list);
            Criteria criteria = this.getMultiValueCrit(request, this.getResultTableName(), bean, reqParams);
            ReportHandler.getMultipleValues((ArrayList)attributelist, multipleValuesSids, (String)this.tableKey, (Criteria)criteria);
            ReportResultUtil.getCustomizedMultipleValues(multipleValuesSids);
            request.setAttribute("multipleValuesSids", multipleValuesSids);
            request.setAttribute("result", (Object)list);
            request.setAttribute("tableKey", (Object)this.tableKey);
            if (ascending.equals("true")) {
                request.setAttribute("sortImage", (Object)"images/sortdown.gif");
            } else {
                request.setAttribute("sortImage", (Object)"images/sortup.gif");
            }
            request.setAttribute("errorList", (Object)this.errorList);
        } else if (this.errorMessage != null) {
            request.setAttribute("errorMsg", (Object)this.errorMessage);
        } else if (this.updatedCount != -1) {
            request.setAttribute("errorMsg", (Object)"No Reports Available");
        }
    }

    public static void fillObjectType(ArrayList list) {
        try {
            for (int i = 0; i < list.size(); ++i) {
                Hashtable prop = (Hashtable)list.get(i);
                String trustee = (String)prop.get(11101);
                Criteria crit = new Criteria(new Column("ADSMReportACLsDetails", "SECURITY_PRINCIPAL"), (Object)trustee, 0);
                DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMReportACLsDetails", crit);
                if (dataObj == null) continue;
                Row r = dataObj.getFirstRow("ADSMReportACLsDetails");
                prop.put("objectType", r.get("OBJECT_CLASS"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public class Action
    extends Thread {
        private String directoryPath = null;
        private Map inputParams = null;
        private String domainName = null;
        private ArrayList attributeList = null;
        private NativeListener listener = null;
        private Long loginId = null;
        private String distinguishedName = null;

        public Action(Long loginId, String domainName, Map inputParams, ArrayList attributeList, NativeListener li, String distinguishedName) {
            this.domainName = domainName;
            this.loginId = loginId;
            this.attributeList = attributeList;
            this.listener = li;
            this.inputParams = inputParams;
            this.distinguishedName = distinguishedName;
        }

        @Override
        public void run() {
            PermissionOverObjectsListener.this.errorMessage = null;
            if (!PermissionOverObjectsListener.this.errorList.isEmpty()) {
                PermissionOverObjectsListener.this.errorList = new Hashtable();
            }
            Hashtable tableProps = PermissionOverObjectsListener.this.getQueueProps();
            ArrayList inputsList = (ArrayList)this.inputParams.get("trusteesList");
            for (int i = 0; i < inputsList.size(); ++i) {
                Hashtable<String, String> errors;
                Hashtable inputValues = (Hashtable)inputsList.get(i);
                try {
                    PermissionOverObjectsListener.this.setDomainName(this.domainName);
                    tableProps.put("inputId", (Long)inputValues.get("INPUT_ID"));
                    PermissionOverObjectsListener.this.queue.registerForUpdation(PermissionOverObjectsListener.this.baseTableName, PermissionOverObjectsListener.this.generationId, tableProps);
                    PermissionOverObjectsListener.this.doAction(this.domainName, this.loginId, (String)inputValues.get("DISTINGUISHED_NAME"), this.attributeList, this.listener);
                    PermissionOverObjectsListener.this.updateQueue();
                    continue;
                }
                catch (LocalizedException e) {
                    e.printStackTrace();
                    PermissionOverObjectsListener.this.errorMessage = e.getMessage(PermissionOverObjectsListener.this.rb);
                    errors = new Hashtable();
                    errors.put("INPUT_NAME", (String)inputValues.get("INPUT_NAME"));
                    errors.put("ERROR_MESSAGE", PermissionOverObjectsListener.this.errorMessage);
                    PermissionOverObjectsListener.this.errorList.put(inputValues.get("INPUT_ID").toString(), errors);
                    PermissionOverObjectsListener.this.updateErrorStatus(errors);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    PermissionOverObjectsListener.this.errorMessage = e.getMessage();
                    errors = new Hashtable<String, String>();
                    errors.put("INPUT_NAME", (String)inputValues.get("INPUT_NAME"));
                    errors.put("ERROR_MESSAGE", PermissionOverObjectsListener.this.errorMessage);
                    PermissionOverObjectsListener.this.errorList.put(inputValues.get("INPUT_ID").toString(), errors);
                    PermissionOverObjectsListener.this.updateErrorStatus(errors);
                }
            }
            PermissionOverObjectsListener.this.updatedCount = 0;
            PermissionOverObjectsListener.this.totalCount = 0;
            PermissionOverObjectsListener.this.completedAction();
        }
    }
}

