/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.reports;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.DerivedTable;
import com.adventnet.ds.query.GroupByClause;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.Range;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.DBQueue;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.queue.QueueHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportAttributeHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportReqParams;
import com.adventnet.sym.adsm.common.server.resultdata.ResultDataHandler;
import com.adventnet.sym.adsm.common.server.util.DBUtil;
import com.adventnet.sym.adsm.common.webclient.reports.AbstractListener;
import com.adventnet.sym.adsm.common.webclient.reports.ListenerUtil;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.reports.ReportResultUtil;
import com.adventnet.sym.adsm.common.webclient.usermanagement.ModifyPhotoListener;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class PhotoReportsListener
extends AbstractListener {
    public static final int THUMBNAILPHOTO_ATTR = 1;
    public static final int THUMBNAILLOGO_ATTR = 2;
    public static final int JPEGPHOTO_ATTR = 3;
    public static final int PHOTO_ATTR = 4;
    public static final int USERS_WITH_PHOTO = 1;
    public static final int USERS_WITHOUT_PHOTO = 0;

    @Override
    protected void doAction(String domainName, Long loginId, String distinguishedName, ArrayList attributeList, NativeListener listener) throws Exception {
    }

    protected void doAction(String domainName, Long loginId, String distinguishedName, ArrayList attributeList, String searchString, NativeListener listener) throws Exception {
        ADHandler.getUsersWithPhoto((String)domainName, (Long)loginId, (String)distinguishedName, (ArrayList)attributeList, (String)searchString, (NativeListener)listener);
    }

    @Override
    protected void checkAttributeList(ArrayList attributeList) {
    }

    @Override
    public void start(ArrayList attributeList, HttpServletRequest request, ReportBean bean) {
        try {
            HttpSession session = request.getSession();
            this.loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            HashMap<String, String> inputParams = new HashMap<String, String>();
            String[] domainList = request.getParameterValues("domains");
            inputParams.put("domain", ClientUtil.getString(domainList));
            ArrayList containerList = this.getContainerList(request, bean);
            Hashtable dnDomainNameMap = (Hashtable)bean.get("dnDomainNameMap");
            Hashtable domainVsExcludeChildOU = (Hashtable)bean.get("domainVsExcludeChildOU");
            Hashtable excludedOUList = (Hashtable)bean.get("excludedOUList");
            String query = "(&(sAMAccountType=805306368)";
            int attrType = Integer.parseInt(request.getParameter("attrType"));
            if (1 == Integer.parseInt(request.getParameter("reportType"))) {
                query = query + "(";
            } else if (0 == Integer.parseInt(request.getParameter("reportType"))) {
                query = query + "(!";
            }
            if (attrType == 1) {
                query = query + "thumbnailPhoto=*))";
            } else if (attrType == 2) {
                query = query + "thumbnailLogo=*))";
            } else if (attrType == 3) {
                query = query + "jpegPhoto=*))";
            } else if (attrType == 4) {
                query = query + "photo=*))";
            }
            bean.set("inputParams", inputParams);
            String reportDomains = this.getReportDomains(domainList, dnDomainNameMap);
            this.getDescription(new Object[]{reportDomains});
            ArrayList objectIds = this.getObjIdList();
            this.queueRegID = QueueHandler.getInstance().registerForUpdate(objectIds, this.getTableColumns());
            this.resultRegID = ResultDataHandler.getInstance().getProcessor().registerForUpdate(this.resultTableName);
            Hashtable excludeContainerHash = this.constructExcludeContainerHash(containerList, domainVsExcludeChildOU, excludedOUList, dnDomainNameMap);
            Action action = new Action(this.rb, this.loginId, containerList, attributeList, this, dnDomainNameMap, query, excludeContainerHash);
            action.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public ArrayList getRows(ArrayList attributeList, Properties attributeProp, boolean ascending, int startIndex, int numOfObjects, Hashtable multipleValuesSids, Criteria reportFilterCriteria, Criteria columnSearchCriteria, ArrayList reportFilterTableNames) {
        return PhotoReportsListener.getRows(this, this.generationId, this.resultTableName, attributeList, attributeProp, ascending, startIndex, numOfObjects, multipleValuesSids, reportFilterCriteria, columnSearchCriteria, this.tableKey, reportFilterTableNames, null, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList getRows(AbstractListener listener, Long generationId, String resultTableName, ArrayList attributeList, Properties attributeProp, boolean ascending, int startIndex, int numOfObjects, Hashtable multipleValuesSids, Criteria reportFiltercriteria, Criteria columnSearchCriteria, String tableKey, ArrayList<String> reportFilterTableNames, ReportReqParams reqParams, String interSect, boolean isScheduledReport) {
        Connection connection = null;
        ArrayList resultList = null;
        DataSet dataSet = null;
        try {
            String table;
            ArrayList<Column> selectColumnList = new ArrayList<Column>();
            String baseTableName = null;
            ArrayList<String> tableNames = new ArrayList<String>();
            boolean relationalTypePresent = false;
            ReportAttributeHandler.getInstance().removeAttribsWithoutColDef(attributeList);
            for (int i = 0; i < attributeList.size(); ++i) {
                Properties attributeProperties = (Properties)attributeList.get(i);
                Integer relationalType = (Integer)attributeProperties.get("RELATIONAL_TYPE");
                if (relationalType.equals(new Integer(1))) {
                    relationalTypePresent = true;
                    continue;
                }
                table = attributeProperties.getProperty("TABLE_NAME");
                if (baseTableName == null) {
                    baseTableName = table;
                }
                Column column = new Column(table, attributeProperties.getProperty("ATTRIB_COLUMN_NAME"));
                selectColumnList.add(column);
                if (tableNames.contains(table) || table.equalsIgnoreCase(baseTableName)) continue;
                tableNames.add(table);
            }
            ArrayList onClickTextAttributeList = ReportResultUtil.getOnClickTextAttributes(listener.onClickText);
            for (int i = 0; onClickTextAttributeList != null && i < onClickTextAttributeList.size(); ++i) {
                String columnName;
                Column column;
                Properties p = (Properties)onClickTextAttributeList.get(i);
                table = p.getProperty("TABLE_NAME");
                if (table.equalsIgnoreCase("ADSMFolderDetails")) {
                    table = attributeProp.getProperty("TABLE_NAME");
                }
                if (!selectColumnList.contains(column = new Column(table, columnName = p.getProperty("ATTRIB_COLUMN_NAME")))) {
                    selectColumnList.add(column);
                }
                if (tableNames.contains(table) || table.equalsIgnoreCase(baseTableName)) continue;
                tableNames.add(table);
            }
            for (String reportFilterTableName : reportFilterTableNames) {
                if (tableNames.contains(reportFilterTableName) || reportFilterTableName.equalsIgnoreCase(baseTableName)) continue;
                tableNames.add(reportFilterTableName);
            }
            Table baseTable = Table.getTable(baseTableName);
            SelectQueryImpl query = new SelectQueryImpl(baseTable);
            String listenerBaseTable = listener.baseTableName;
            if (!tableNames.contains(listenerBaseTable) && !listenerBaseTable.equalsIgnoreCase(baseTableName)) {
                tableNames.add(listenerBaseTable);
            }
            for (int i = 0; i < tableNames.size(); ++i) {
                String table2 = (String)tableNames.get(i);
                Join join = new Join(baseTable, new Table(table2), new String[]{tableKey}, new String[]{tableKey}, 1);
                query.addJoin(join);
            }
            Column keyColumn = Column.getColumn((String)listener.baseTableName, (String)tableKey);
            if (!selectColumnList.contains(keyColumn)) {
                selectColumnList.add(keyColumn);
            }
            Column keyColumn1 = Column.getColumn((String)listener.baseTableName, (String)"OBJECT_GUID");
            if (listener.reportId == 957) {
                selectColumnList.add(keyColumn1);
            }
            query.addSelectColumns(selectColumnList);
            if (columnSearchCriteria != null) {
                query.setCriteria(columnSearchCriteria);
            }
            SelectQueryImpl subInnerQuery = null;
            if (interSect != null && interSect.equalsIgnoreCase("true")) {
                subInnerQuery = ReportResultUtil.getIntersectSubquery(reqParams, resultTableName, generationId, tableKey);
            } else {
                subInnerQuery = new SelectQueryImpl(Table.getTable((String)resultTableName));
                subInnerQuery.addSelectColumn(Column.getColumn((String)resultTableName, (String)tableKey));
                Criteria resultTableCriteria = new Criteria(Column.getColumn((String)resultTableName, (String)"REPORT_GENERATION_ID"), (Object)generationId, 0);
                if (reportFiltercriteria != null) {
                    resultTableCriteria = resultTableCriteria.and(reportFiltercriteria);
                }
                subInnerQuery.setCriteria(resultTableCriteria);
                ArrayList<Column> groupByColumnsList = new ArrayList<Column>();
                groupByColumnsList.add(Column.getColumn((String)resultTableName, (String)tableKey));
                GroupByClause groupByClause = new GroupByClause(groupByColumnsList);
                subInnerQuery.setGroupByClause(groupByClause);
            }
            if (startIndex != -1) {
                query.setRange(new Range(startIndex, numOfObjects));
            }
            if (attributeProp != null && attributeProp.getProperty("TABLE_NAME") != null) {
                SortColumn sortcolumn = new SortColumn(new Column(attributeProp.getProperty("TABLE_NAME"), attributeProp.getProperty("ATTRIB_COLUMN_NAME")), ascending);
                query.addSortColumn(sortcolumn);
            }
            DerivedTable derivedTable = new DerivedTable(resultTableName, (Query)subInnerQuery);
            query.addJoin(new Join(Table.getTable((String)baseTableName), (Table)derivedTable, new String[]{tableKey}, new String[]{tableKey}, 2));
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            dataSet = relationalAPI.executeQuery((Query)query, connection);
            resultList = new ArrayList();
            String tempTableKeyValue = "";
            while (dataSet.next()) {
                Object guid = dataSet.getValue(selectColumnList.indexOf(keyColumn) + 1);
                if (isScheduledReport && guid != null) {
                    if (tempTableKeyValue.equals(guid)) continue;
                    tempTableKeyValue = guid.toString();
                }
                Hashtable<String, Object> resultTable = new Hashtable<String, Object>();
                PhotoReportsListener.fillResult(dataSet, resultTable, attributeList);
                ReportResultUtil.fillResult(dataSet, resultTable, onClickTextAttributeList);
                if (guid != null) {
                    resultTable.put(tableKey, guid);
                }
                if (relationalTypePresent) {
                    multipleValuesSids.put(guid, new Hashtable());
                }
                ReportResultUtil.fillOnClickText(listener.onClickText, resultTable);
                resultList.add(resultTable);
            }
            DBUtil.closeDataSetAndConnection((DataSet)dataSet, (Connection)connection);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            DBUtil.closeDataSetAndConnection(dataSet, connection);
        }
        return resultList;
    }

    public static void fillResult(DataSet dataSet, Hashtable result, ArrayList attributeList) {
        for (int i = 0; attributeList != null && i < attributeList.size(); ++i) {
            try {
                Properties attributeProperties = (Properties)attributeList.get(i);
                Integer relationalType = (Integer)attributeProperties.get("RELATIONAL_TYPE");
                if (relationalType.equals(new Integer(1))) continue;
                String columnName = attributeProperties.getProperty("ATTRIB_COLUMN_NAME");
                Integer attributeId = (Integer)attributeProperties.get("ATTRIB_ID");
                if (dataSet.getValue(columnName) == null) continue;
                Object obj = dataSet.getValue(columnName);
                if (attributeId != 1203) {
                    result.put(attributeId, ListenerUtil.getUICustomizedValues(attributeId, obj));
                    continue;
                }
                String fileName = obj.toString();
                String hexValOfImage = "";
                if (fileName != null) {
                    String photo = System.getProperty("user.dir") + "\\" + fileName;
                    hexValOfImage = ModifyPhotoListener.getPhotoFileAsHexForReport(photo);
                }
                if (hexValOfImage == null || hexValOfImage.equals("")) {
                    fileName = "../webapps/adsm/images/avatar.png";
                }
                result.put(attributeId, ListenerUtil.getUICustomizedValues(attributeId, fileName));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private class Action
    extends Thread {
        private ArrayList containerList = null;
        private ArrayList attributeList = null;
        private AbstractListener listener = null;
        private Hashtable dnDomainNameMap = null;
        private Long loginId = null;
        private AdventNetResourceBundle rb = null;
        private String searchString = null;
        private Hashtable excludeChildOUHash = null;

        public Action(AdventNetResourceBundle rb, Long loginId, ArrayList list, ArrayList attributeList, AbstractListener li, Hashtable map, String query, Hashtable excludeChildOUHash) {
            this.loginId = loginId;
            this.containerList = list;
            this.excludeChildOUHash = excludeChildOUHash;
            this.attributeList = attributeList;
            this.listener = li;
            if (query != null && !query.equals("")) {
                this.searchString = query;
            } else {
                System.out.println("Error in Getting searchString");
            }
            this.dnDomainNameMap = map;
            this.rb = rb;
        }

        @Override
        public void run() {
            this.listener.initializeActionVariables();
            Hashtable tableProps = ListenerUtil.getQueueProps(this.listener);
            for (int i = 0; i < this.containerList.size(); ++i) {
                try {
                    String dn = (String)this.containerList.get(i);
                    String domainName = (String)this.dnDomainNameMap.get(dn);
                    if (domainName != null) {
                        Boolean isExcludeChildOU = Boolean.FALSE;
                        if (this.excludeChildOUHash != null && this.excludeChildOUHash.containsKey(dn)) {
                            isExcludeChildOU = (Boolean)this.excludeChildOUHash.get(dn);
                        }
                        this.listener.setIsExcludeChildOU(isExcludeChildOU);
                        this.listener.setDomainName(domainName);
                        DBQueue.getInstance().registerForUpdation(this.listener.baseTableName, this.listener.getGenerationId(), tableProps);
                        AbstractListener.reportLogger.log(Level.INFO, "Getting the Empty Groups from the domain " + domainName);
                        PhotoReportsListener.this.doAction(domainName, this.loginId, dn, this.attributeList, this.searchString, this.listener);
                        this.listener.updateQueue();
                        continue;
                    }
                    System.out.println("Error - Selected OU has been moved in Ad manually" + dn);
                    continue;
                }
                catch (LocalizedException e) {
                    e.printStackTrace();
                    this.listener.setErrorMessage(e.getMessage(this.rb));
                    System.out.println("LocalizedException: - " + this.listener.errorMessage);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.listener.setErrorMessage(e.getMessage());
                }
            }
            AbstractListener.reportLogger.log(Level.INFO, "Completed the Reports Count : " + this.listener.totalCount);
            this.listener.completedAction();
        }
    }
}

