/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.reports;

import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.AdmpInput;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.automation.ReportFilterConfig;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.queue.QueueHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportHandler;
import com.adventnet.sym.adsm.common.server.resultdata.ResultDataHandler;
import com.adventnet.sym.adsm.common.webclient.reports.AbstractListener;
import com.adventnet.sym.adsm.common.webclient.reports.ListenerUtil;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import com.adventnet.sym.adsm.security.server.util.DateTimeUtil;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class RecentlyCreatedOUsListener
extends AbstractListener {
    @Override
    public Long getCategoryId() {
        Long categoryId = new Long(1068L);
        return categoryId;
    }

    @Override
    public void getDescription(Object[] args) {
        this.desc = MessageFormat.format(this.rb.getString("admp.reports.ou_reports.rec_created.reportdesc_ous_created_in_recent_days_of_the_domains"), args);
    }

    public void getDescription(Object[] args, String dataLableText) {
        ArrayList<Object> objectList = new ArrayList<Object>(Arrays.asList(args));
        String daysInterval = "";
        try {
            SimpleDateFormat formatter1 = new SimpleDateFormat("dd-MMM-yyyy", Locale.US);
            SimpleDateFormat formatter2 = new SimpleDateFormat("MM/dd/yyyy", Locale.US);
            String startVal = (String)objectList.get(0);
            String endVal = (String)objectList.get(1);
            if (dataLableText.equalsIgnoreCase("admp.common.matching_criteria.before_N_days")) {
                daysInterval = Integer.toString(DateTimeUtil.daysBetween((Date)formatter1.parse(startVal), (Date)Calendar.getInstance().getTime()));
            } else if (dataLableText.equalsIgnoreCase("admp.common.matching_criteria.last_N_days")) {
                daysInterval = Integer.toString(DateTimeUtil.daysBetween((Date)formatter1.parse(startVal), (Date)formatter1.parse(endVal)));
            }
            objectList.add(daysInterval);
            Date date = formatter1.parse(startVal);
            Date date1 = formatter1.parse(endVal);
            objectList.set(0, formatter2.format(date));
            objectList.set(1, formatter2.format(date1));
            args = objectList.toArray();
            this.setDescription(args, dataLableText);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setDescription(Object[] args, String dataLableText) {
        this.desc = dataLableText.equalsIgnoreCase("admp.common.matching_criteria.before_N_days") ? MessageFormat.format(this.rb.getString("admp.reports.ou_reports.rec_created_ou.reportdesc_before_N_days"), args) : (dataLableText.equalsIgnoreCase("admp.common.matching_criteria.last_N_days") ? MessageFormat.format(this.rb.getString("admp.reports.ou_reports.rec_created_ou.reportdesc_last_N_days"), args) : (dataLableText.equalsIgnoreCase("admp.common.matching_criteria.before_a_date") ? MessageFormat.format(this.rb.getString("admp.reports.ou_reports.rec_created_ou.reportdesc_before_date"), args) : (dataLableText.equalsIgnoreCase("admp.common.matching_criteria.after_a_date") ? MessageFormat.format(this.rb.getString("admp.reports.ou_reports.rec_created_ou.reportdesc_after_date"), args) : MessageFormat.format(this.rb.getString("admp.reports.ou_reports.rec_created_ou.reportdesc_between_dates"), args))));
    }

    @Override
    public void doAction(String domainName, Long loginId, String distinguishedName, ArrayList attributeList, NativeListener listener) throws Exception {
    }

    @Override
    protected void checkAttributeList(ArrayList attributeList) {
    }

    public void doAction(String domainName, Long loginId, String distinguishedName, ArrayList attributeList, NativeListener listener, String filterString) throws Exception {
        ADHandler.getRecentlyCreatedOUs((String)domainName, (Long)loginId, (String)distinguishedName, (ArrayList)attributeList, (NativeListener)listener, (String)filterString);
    }

    @Override
    public void start(ArrayList attributeList, HttpServletRequest request, ReportBean bean) {
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        try {
            this.checkAttributeList(attributeList);
            HashMap<String, String> inputParams = new HashMap<String, String>();
            String startDateVal = request.getParameter("startDate");
            String endDateVal = request.getParameter("endDate");
            String dataLableText = request.getParameter("dateLable");
            String filterString = this.getFilterString(startDateVal, endDateVal, dataLableText);
            ArrayList containerList = this.getContainerList(request, bean);
            Hashtable dnDomainNameMap = (Hashtable)bean.get("dnDomainNameMap");
            String[] domainList = request.getParameterValues("domains");
            inputParams.put("domain", ClientUtil.getString(domainList));
            bean.set("inputParams", inputParams);
            String reportDomains = this.getReportDomains(domainList, dnDomainNameMap);
            this.getDescription(new Object[]{startDateVal, endDateVal, this.rb.getString(dataLableText), reportDomains}, dataLableText);
            ArrayList objectIds = this.getObjIdList();
            this.queueRegID = QueueHandler.getInstance().registerForUpdate(objectIds, this.getTableColumns());
            this.resultRegID = ResultDataHandler.getInstance().getProcessor().registerForUpdate(this.resultTableName);
            Action action = new Action(loginId, containerList, attributeList, filterString, this, dnDomainNameMap);
            action.start();
            System.out.println("Bean for topCount : " + inputParams);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getFilterString(String startDateVal, String endDateVal, String dataLableText) {
        String filterString = "";
        HashMap datesValueMap = this.getDateInterval(startDateVal, endDateVal, dataLableText);
        String startDate = (String)datesValueMap.get("startDate");
        String endDate = (String)datesValueMap.get("endDate");
        filterString = dataLableText.equalsIgnoreCase("admp.common.matching_criteria.before_a_date") || dataLableText.equalsIgnoreCase("admp.common.matching_criteria.before_N_days") ? "(&(objectCategory=OrganizationalUnit)(objectClass=OrganizationalUnit)(whenCreated<=" + startDate + "))" : (dataLableText.equalsIgnoreCase("admp.common.matching_criteria.after_a_date") ? "(&(objectCategory=OrganizationalUnit)(objectClass=OrganizationalUnit)(whenCreated>=" + endDate + "))" : "(&(objectCategory=OrganizationalUnit)(objectClass=OrganizationalUnit)(whenCreated>=" + startDate + ")(whenCreated<=" + endDate + "))");
        return filterString;
    }

    public HashMap getDateInterval(String startDateVal, String endDateVal, String dataLableText) {
        Calendar calendar = Calendar.getInstance();
        HashMap<String, String> datesValueMap = new HashMap<String, String>();
        String startDate = "0";
        String endDate = "0";
        try {
            SimpleDateFormat formatter1 = new SimpleDateFormat("dd-MMM-yyyy", Locale.US);
            SimpleDateFormat formatter2 = new SimpleDateFormat("yyyyMMddHHmmss", Locale.US);
            Date days = formatter1.parse(startDateVal);
            long milliseconds = days.getTime();
            Date d = new Date(milliseconds);
            startDate = formatter2.format(d) + ".0Z";
            days = formatter1.parse(endDateVal);
            Calendar endoftheDay = (Calendar)calendar.clone();
            endoftheDay.setTime(days);
            endoftheDay.set(endoftheDay.get(1), endoftheDay.get(2), endoftheDay.get(5), 23, 59, 59);
            endoftheDay.set(14, 0);
            d = new Date(endoftheDay.getTimeInMillis());
            endDate = formatter2.format(d) + ".0Z";
            if (dataLableText.equalsIgnoreCase("admp.common.matching_criteria.last_N_days")) {
                int lastNDays = DateTimeUtil.daysBetween((Date)formatter1.parse(startDateVal), (Date)formatter1.parse(endDateVal));
                long l = (long)(lastNDays * 24 * 60 * 60) * 1000L;
                d = new Date(System.currentTimeMillis() - l);
                startDate = formatter2.format(d) + ".0Z";
            }
            datesValueMap.put("startDate", startDate);
            datesValueMap.put("endDate", endDate);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return datesValueMap;
    }

    @Override
    public void executeTask(ArrayList containerList, Hashtable dnDomainNameMap, ReportFilterConfig reportFilterConfig) {
        this.executeTask(containerList, dnDomainNameMap, null, null, reportFilterConfig);
    }

    @Override
    public void executeTask(ArrayList containerList, Hashtable dnDomainNameMap, Hashtable excludedOUList, Hashtable domainVsExcludeChildOU, ReportFilterConfig reportFilterConfig) {
        try {
            this.isCompleted = false;
            long value = 2592000000L;
            long reportDays = 0L;
            for (AdmpInput admpInput : reportFilterConfig.getInputList()) {
                if (admpInput.getIsMultiple().booleanValue()) continue;
                reportDays = Long.parseLong(admpInput.getValue());
                value = reportDays * 24L * 60L * 60L * 1000L;
            }
            SimpleDateFormat formatter1 = new SimpleDateFormat("dd-MMM-yyyy", Locale.US);
            Date days = new Date(System.currentTimeMillis() - value);
            String startDateVal = formatter1.format(days);
            days = new Date(System.currentTimeMillis());
            String endDateVal = formatter1.format(days);
            String filterString = this.getFilterString(startDateVal, endDateVal, "admp.common.matching_criteria.last_N_days");
            String schedulerDomains = this.getSchedulerDomains(containerList, dnDomainNameMap);
            this.getDescription(new Object[]{startDateVal, endDateVal, this.rb.getString("admp.common.matching_criteria.last_N_days"), schedulerDomains}, "admp.common.matching_criteria.last_N_days");
            ArrayList objectIds = this.getObjIdList();
            this.queueRegID = QueueHandler.getInstance().registerForUpdate(objectIds, this.getTableColumns());
            this.resultRegID = ResultDataHandler.getInstance().getProcessor().registerForUpdate(this.resultTableName);
            this.generationId = ReportHandler.addReportGenerationDetails((Integer)this.reportId, (String)this.desc, (Long)this.loginId);
            Action action = new Action(1L, containerList, this.getAttributeList(), filterString, this, dnDomainNameMap);
            action.start();
            while (!this.isCompleted) {
                try {
                    Thread.sleep(200L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ReportHandler.updateReportGenerationDetails((Long)this.generationId, (int)1, (String)this.desc, (Long)this.loginId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setDashboardInputParams(Long dashboardReportMapping, HttpServletRequest request, ReportBean bean) {
        ListenerUtil.setDashboardInputParams(dashboardReportMapping, request, bean, 1);
    }

    private class Action
    extends Thread {
        private ArrayList containerList = null;
        private ArrayList attributeList = null;
        private NativeListener listener = null;
        private String filterString = "";
        private Hashtable dnDomainNameMap = null;
        private Long loginId = null;

        public Action(Long loginId, ArrayList list, ArrayList attributeList, String filterString, NativeListener li, Hashtable map) {
            this.loginId = loginId;
            this.containerList = list;
            this.attributeList = attributeList;
            this.listener = li;
            this.filterString = filterString;
            this.dnDomainNameMap = map;
        }

        @Override
        public void run() {
            RecentlyCreatedOUsListener.this.guidList = new ArrayList();
            Hashtable tableProps = RecentlyCreatedOUsListener.this.getQueueProps();
            for (int i = 0; i < this.containerList.size(); ++i) {
                try {
                    String dn = (String)this.containerList.get(i);
                    RecentlyCreatedOUsListener.this.domainName = (String)this.dnDomainNameMap.get(dn);
                    if (RecentlyCreatedOUsListener.this.domainName != null) {
                        RecentlyCreatedOUsListener.this.queue.registerForUpdation(RecentlyCreatedOUsListener.this.baseTableName, RecentlyCreatedOUsListener.this.generationId, tableProps);
                        System.out.println("Getting Recently Modified/Created Item for the Report " + RecentlyCreatedOUsListener.this.reportId + ", with the filterString : " + this.filterString + ", DN :" + dn + ", Domain : " + RecentlyCreatedOUsListener.this.domainName);
                        RecentlyCreatedOUsListener.this.doAction(RecentlyCreatedOUsListener.this.domainName, this.loginId, dn, this.attributeList, this.listener, this.filterString);
                        RecentlyCreatedOUsListener.this.updateQueue();
                        continue;
                    }
                    System.out.println("Error - Selected OU has been moved in Ad manually" + dn);
                    continue;
                }
                catch (LocalizedException e) {
                    e.printStackTrace();
                    RecentlyCreatedOUsListener.this.errorMessage = e.getMessage(RecentlyCreatedOUsListener.this.rb);
                    System.out.println("LocalizedException: - " + RecentlyCreatedOUsListener.this.errorMessage);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    RecentlyCreatedOUsListener.this.errorMessage = e.getMessage();
                }
            }
            RecentlyCreatedOUsListener.this.updatedCount = 0;
            RecentlyCreatedOUsListener.this.totalCount = 0;
            RecentlyCreatedOUsListener.this.completedAction();
        }
    }
}

