/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.reports;

import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.AdmpInput;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.automation.ReportFilterConfig;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.multidc.ResultProcessor;
import com.adventnet.sym.adsm.common.server.queue.QueueHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportHandler;
import com.adventnet.sym.adsm.common.server.reports.StatusUpdater;
import com.adventnet.sym.adsm.common.server.resultdata.ResultDataHandler;
import com.adventnet.sym.adsm.common.webclient.reports.ListenerUtil;
import com.adventnet.sym.adsm.common.webclient.reports.MultiDCListener;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.reports.ReportDomain;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import com.adventnet.sym.adsm.security.server.util.DateTimeUtil;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class RecentlyLoggedOnListener
extends MultiDCListener {
    protected String lastLogonTableName = "ADSMUserGeneralDetails";
    private Hashtable notToBeUpdatedList = new Hashtable();

    public RecentlyLoggedOnListener() {
        this.notToBeUpdatedList.put("DOMAIN_CONTROLLER_NAME", "");
        this.multiDC = true;
    }

    public void doAction(Properties domainDetails, String distinguishedName, String dcName, ArrayList attributeList, NativeListener listener, String filterString) throws Exception {
        ADHandler.getRecentlyLoggedOnUsers((Properties)domainDetails, (String)distinguishedName, (String)dcName, (ArrayList)attributeList, (NativeListener)listener, (String)filterString);
    }

    public void getDescription(Object[] args, String dataLableText) {
        ArrayList<Object> objectList = new ArrayList<Object>(Arrays.asList(args));
        String startVal = (String)objectList.get(0);
        String endVal = (String)objectList.get(1);
        SimpleDateFormat formatter1 = new SimpleDateFormat("dd-MMM-yyyy", Locale.US);
        SimpleDateFormat formatter2 = new SimpleDateFormat("MM/dd/yyyy", Locale.US);
        String daysHoursInterval = "";
        try {
            if (dataLableText.equalsIgnoreCase("admp.common.matching_criteria.last_N_days")) {
                daysHoursInterval = Integer.toString(DateTimeUtil.daysBetween((Date)formatter1.parse(startVal), (Date)formatter1.parse(endVal)));
            } else if (dataLableText.equalsIgnoreCase("admp.common.matching_criteria.last_N_hours")) {
                daysHoursInterval = Integer.toString(DateTimeUtil.hoursBetween((Date)new Date(Long.parseLong(startVal)), (Date)new Date(Long.parseLong(endVal))));
            }
            objectList.add(daysHoursInterval);
            if (!dataLableText.equalsIgnoreCase("admp.common.matching_criteria.last_N_hours")) {
                Date date = formatter1.parse(startVal);
                Date date1 = formatter1.parse(endVal);
                objectList.set(0, formatter2.format(date));
                objectList.set(1, formatter2.format(date1));
            }
            args = objectList.toArray();
            this.setDescription(args, dataLableText);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setDescription(Object[] args, String dataLableText) {
        this.desc = dataLableText.equalsIgnoreCase("admp.common.matching_criteria.last_N_hours") ? MessageFormat.format(this.rb.getString("admp.reports.user_reports.rec_logged_on_users.reportdesc_last_N_hours"), args) : (dataLableText.equalsIgnoreCase("admp.common.matching_criteria.last_N_days") ? MessageFormat.format(this.rb.getString("admp.reports.user_reports.rec_logged_on_users.reportdesc_last_N_days"), args) : (dataLableText.equalsIgnoreCase("admp.common.matching_criteria.after_a_date") ? MessageFormat.format(this.rb.getString("admp.reports.user_reports.rec_logged_on_users.reportdesc_after_date"), args) : MessageFormat.format(this.rb.getString("admp.reports.user_reports.rec_logged_on_users.reportdesc_between_dates"), args)));
    }

    @Override
    public void init(Row r) {
        this.baseTableName = (String)r.get("BASE_TABLE_NAME");
        this.resultTableName = (String)r.get("RESULT_TABLE_NAME");
        this.reportId = (Integer)r.get("REPORT_ID");
        this.onClickText = (String)r.get("ONCLICK_TEXT");
        if (this.rb == null) {
            this.rb = ResourceBundleMgr.getInstance().getBundle();
        }
        this.title = (String)r.get("REPORT_NAME");
    }

    @Override
    public void init(HttpServletRequest request, Row r) {
        HttpSession session = request.getSession();
        Locale locale = request.getLocale();
        this.rb = ResourceBundleMgr.getInstance().getBundle(locale);
        this.baseTableName = (String)r.get("BASE_TABLE_NAME");
        this.resultTableName = (String)r.get("RESULT_TABLE_NAME");
        this.reportId = (Integer)r.get("REPORT_ID");
        this.onClickText = (String)r.get("ONCLICK_TEXT");
        this.title = (String)r.get("REPORT_NAME");
        this.setGenerationId(request);
    }

    @Override
    public Hashtable getQueueProps() {
        Hashtable<String, Object> tableProps = new Hashtable<String, Object>();
        tableProps.put("baseTableName", this.baseTableName);
        tableProps.put("resultTableName", this.resultTableName);
        tableProps.put("generationId", this.generationId);
        tableProps.put("resultHandling", "addOrUpdate");
        return tableProps;
    }

    @Override
    protected void checkAttributeList(ArrayList attributeList) {
    }

    @Override
    public void doAction(String domainName, Long loginId, String distinguishedName, ArrayList attributeList, NativeListener listener) throws Exception {
    }

    @Override
    public void start(ArrayList attributeList, HttpServletRequest request, ReportBean bean) {
        try {
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            this.checkAttributeList(attributeList);
            HashMap<String, Object> inputParams = new HashMap<String, Object>();
            inputParams.put("multiDC", "true");
            Hashtable reportDomains = this.getReportDomains(request, bean, loginId);
            inputParams.put("reportDomains", reportDomains);
            Hashtable dnDomainNameMap = (Hashtable)bean.get("dnDomainNameMap");
            String[] domainList = request.getParameterValues("domains");
            String reportDomain = this.getReportDomains(domainList, dnDomainNameMap);
            inputParams.put("domain", ClientUtil.getString(domainList));
            Hashtable domainVsExcludeChildOU = (Hashtable)bean.get("domainVsExcludeChildOU");
            Hashtable excludedOUList = (Hashtable)bean.get("excludedOUList");
            String startDateVal = request.getParameter("startDate");
            String endDateVal = request.getParameter("endDate");
            String dataLableText = request.getParameter("dateLable");
            String filterString = this.getFilterString(startDateVal, endDateVal, dataLableText);
            this.getDescription(new Object[]{startDateVal, endDateVal, this.rb.getString(dataLableText), reportDomain}, dataLableText);
            this.statusController.init(reportDomains);
            this.statusController.setProgressTask(StatusUpdater.TASKCODE.FETCHING_DETAILS_FROM_DCS.getValue());
            Action action = new Action(loginId, reportDomains, attributeList, filterString, this, dnDomainNameMap, excludedOUList, domainVsExcludeChildOU);
            action.start();
            bean.set("inputParams", inputParams);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getFilterString(String startDateVal, String endDateVal, String dataLableText) {
        String filterString = "";
        HashMap datesValueMap = this.getDateInterval(startDateVal, endDateVal, dataLableText);
        long startDate = (Long)datesValueMap.get("startDate");
        long endDate = (Long)datesValueMap.get("endDate");
        filterString = dataLableText.equalsIgnoreCase("admp.common.matching_criteria.after_a_date") ? "(&(objectCategory=person)(objectClass=user)(!(sAMAccountType=805306370))(|(lastLogon>=" + endDate + ")(&(lastlogontimestamp=*)(lastlogontimestamp>=" + endDate + "))))" : (dataLableText.equalsIgnoreCase("admp.common.matching_criteria.last_N_days") || dataLableText.equalsIgnoreCase("admp.common.matching_criteria.last_N_hours") ? "(&(objectCategory=person)(objectClass=user)(!(sAMAccountType=805306370))(|(lastLogon>=" + startDate + ")(&(lastlogontimestamp=*)(lastlogontimestamp>=" + startDate + "))))" : "(&(objectCategory=person)(objectClass=user)(!(sAMAccountType=805306370))(|(&(lastLogon>=" + startDate + ")(lastLogon<=" + endDate + "))(&(lastlogontimestamp=*)(&(lastlogontimestamp>=" + startDate + ")(lastlogontimestamp<=" + endDate + ")))))");
        return filterString;
    }

    public HashMap getDateInterval(String startDateVal, String endDateVal, String dataLableText) {
        HashMap<String, Long> datesValueMap = new HashMap<String, Long>();
        long startDate = 0L;
        long endDate = 0L;
        try {
            SimpleDateFormat formatter1 = new SimpleDateFormat("dd-MMM-yyyy", Locale.US);
            if (dataLableText.equalsIgnoreCase("admp.common.matching_criteria.last_N_days")) {
                int lastNDays = DateTimeUtil.daysBetween((Date)formatter1.parse(startDateVal), (Date)formatter1.parse(endDateVal));
                long l = (long)(lastNDays * 24 * 60 * 60) * 1000L;
                startDate = DateTimeUtil.getFileTime((Long)(System.currentTimeMillis() - l));
                endDate = DateTimeUtil.getFileTime((Long)System.currentTimeMillis());
            } else if (dataLableText.equalsIgnoreCase("admp.common.matching_criteria.last_N_hours")) {
                int lastNHours = DateTimeUtil.hoursBetween((Date)new Date(Long.parseLong(startDateVal)), (Date)new Date(Long.parseLong(endDateVal)));
                long l = (long)(lastNHours * 60 * 60) * 1000L;
                startDate = DateTimeUtil.getFileTime((Long)(System.currentTimeMillis() - l));
                endDate = DateTimeUtil.getFileTime((Long)System.currentTimeMillis());
            } else {
                Date days = formatter1.parse(startDateVal);
                startDate = DateTimeUtil.getFileTime((Long)days.getTime());
                days = formatter1.parse(endDateVal);
                endDate = DateTimeUtil.getFileTime((Long)days.getTime());
                days = formatter1.parse(endDateVal);
                Calendar endoftheDay = Calendar.getInstance();
                endoftheDay.setTime(days);
                endoftheDay.set(endoftheDay.get(1), endoftheDay.get(2), endoftheDay.get(5), 23, 59, 59);
                endoftheDay.set(14, 0);
                endDate = DateTimeUtil.getFileTime((Long)endoftheDay.getTimeInMillis());
            }
            datesValueMap.put("startDate", startDate);
            datesValueMap.put("endDate", endDate);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return datesValueMap;
    }

    @Override
    public void executeTask(ArrayList containerList, Hashtable dnDomainNameMap, ReportFilterConfig reportFilterConfig) {
        this.executeTask(containerList, dnDomainNameMap, null, null, reportFilterConfig);
    }

    @Override
    public void executeTask(ArrayList containerList, Hashtable dnDomainNameMap, Hashtable excludedOUList, Hashtable domainVsExcludeChildOU, ReportFilterConfig reportFilterConfig) {
        try {
            System.out.println("Execute Task Started ");
            this.isCompleted = false;
            this.multiDC = true;
            Long reportDays = 0L;
            long value = 604800000L;
            for (AdmpInput admpInput : reportFilterConfig.getInputList()) {
                if (admpInput.getIsMultiple().booleanValue()) continue;
                ListenerUtil.updateReportDaysForRegenerateReport(reportFilterConfig, admpInput, false);
                reportDays = Long.parseLong(admpInput.getValue());
                value = reportDays * 24L * 60L * 60L * 1000L;
            }
            HashMap dateValues = this.getScheduleDates(value);
            String startDateVal = (String)dateValues.get("startDate");
            String endDateVal = (String)dateValues.get("endDate");
            String filterString = this.getFilterString(startDateVal, endDateVal, "admp.common.matching_criteria.last_N_days");
            String schedulerDomains = this.getSchedulerDomains(containerList, dnDomainNameMap);
            this.getDescription(new Object[]{startDateVal, endDateVal, this.rb.getString("admp.common.matching_criteria.last_N_days"), schedulerDomains}, "admp.common.matching_criteria.last_N_days");
            this.generationId = ReportHandler.addReportGenerationDetails((Integer)this.reportId, (String)this.desc, (Long)this.loginId);
            Hashtable reportDomains = this.getReportDomains(containerList, dnDomainNameMap, excludedOUList, domainVsExcludeChildOU);
            Action action = new Action(1L, reportDomains, this.getAttributeList(), filterString, this, dnDomainNameMap, excludedOUList, domainVsExcludeChildOU);
            action.start();
            while (!this.isCompleted) {
                try {
                    Thread.sleep(200L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ReportHandler.updateReportGenerationDetails((Long)this.generationId, (int)1, (String)this.desc, (Long)this.loginId);
            System.out.println("Execute Task Completed");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public HashMap getScheduleDates(long time) {
        HashMap<String, String> datesMap = new HashMap<String, String>();
        SimpleDateFormat formatter1 = new SimpleDateFormat("dd-MMM-yyyy", Locale.US);
        Date days = new Date(System.currentTimeMillis() - time);
        String startDateVal = formatter1.format(days);
        days = new Date(System.currentTimeMillis());
        String endDateVal = formatter1.format(days);
        datesMap.put("startDate", startDateVal);
        datesMap.put("endDate", endDateVal);
        return datesMap;
    }

    @Override
    public void setDashboardInputParams(Long dashboardReportMapping, HttpServletRequest request, ReportBean bean) {
        ListenerUtil.setDashboardInputParams(dashboardReportMapping, request, bean, 1);
    }

    private class Action
    extends Thread {
        private Hashtable reportDomains = null;
        private ArrayList attributeList = null;
        private String filterString = "";
        private NativeListener listener = null;
        private Hashtable dnDomainNameMap = null;
        private Long loginId = null;
        private Boolean excludeChildOU = null;
        private Hashtable domainVsExcludeChildOU = null;
        private Hashtable excludedOUList = null;

        public Action(Long loginId, Hashtable hash, ArrayList attributeList, String filterString, NativeListener li, Hashtable map, Hashtable excludedOUList, Hashtable domainVsExcludeChildOU) {
            this.loginId = loginId;
            this.reportDomains = hash;
            this.attributeList = attributeList;
            this.filterString = filterString;
            this.listener = li;
            this.dnDomainNameMap = map;
            this.excludedOUList = excludedOUList;
            this.domainVsExcludeChildOU = domainVsExcludeChildOU;
        }

        @Override
        public void run() {
            RecentlyLoggedOnListener.this.guidList = new ArrayList();
            Hashtable tableProps = RecentlyLoggedOnListener.this.getQueueProps();
            RecentlyLoggedOnListener.this.resultUseTempFlag = true;
            ArrayList multiDCAttributes = RecentlyLoggedOnListener.this.getMultiDCAttributes();
            ArrayList objectIds = RecentlyLoggedOnListener.this.getObjIdList();
            RecentlyLoggedOnListener.this.queueRegID = QueueHandler.getInstance().registerForUpdate(objectIds, RecentlyLoggedOnListener.this.getTableColumns());
            RecentlyLoggedOnListener.this.resultRegID = ResultDataHandler.getInstance().getProcessor().registerForUpdate(RecentlyLoggedOnListener.this.resultTableName);
            Enumeration e = this.reportDomains.keys();
            block5: while (e.hasMoreElements()) {
                try {
                    RecentlyLoggedOnListener.this.domainName = (String)e.nextElement();
                    Properties domainDetails = HDTDomainHandler.getConfiguredValues((String)RecentlyLoggedOnListener.this.domainName, (Long)this.loginId);
                    ReportDomain reportDomain = (ReportDomain)this.reportDomains.get(RecentlyLoggedOnListener.this.domainName);
                    ArrayList containerList = reportDomain.getContainerList();
                    Hashtable excludeContainerHash = RecentlyLoggedOnListener.this.constructExcludeContainerHash(containerList, this.domainVsExcludeChildOU, this.excludedOUList, this.dnDomainNameMap);
                    for (int i = 0; i < containerList.size(); ++i) {
                        String dn = (String)containerList.get(i);
                        Boolean isExcludeChildOU = Boolean.FALSE;
                        if (excludeContainerHash != null && excludeContainerHash.containsKey(dn)) {
                            isExcludeChildOU = (Boolean)excludeContainerHash.get(dn);
                        }
                        this.listener.setIsExcludeChildOU(isExcludeChildOU);
                        System.out.println("Getting the InActive Computer Reports for the period filterString " + this.filterString + " from the domain " + RecentlyLoggedOnListener.this.domainName);
                        RecentlyLoggedOnListener.this.resultObject = new ResultProcessor(RecentlyLoggedOnListener.this.queueRegID.longValue(), multiDCAttributes, RecentlyLoggedOnListener.this.objClass.getId());
                        RecentlyLoggedOnListener.this.resultObject.setRemoveGuids(false);
                        ArrayList dcList = reportDomain.getDCList();
                        ArrayList dcList1 = new ArrayList();
                        for (int k = 0; k < dcList.size(); ++k) {
                            Hashtable hash = (Hashtable)dcList.get(k);
                            dcList1.add(hash.get("dcName"));
                        }
                        Hashtable domainProps = new Hashtable();
                        domainProps.put(RecentlyLoggedOnListener.this.domainName, dcList1);
                        RecentlyLoggedOnListener.this.resultObject.setDomainProps(dcList.size(), domainProps);
                        boolean error = true;
                        String errStr = null;
                        for (int j = 0; j < dcList.size(); ++j) {
                            Hashtable hash = (Hashtable)dcList.get(j);
                            Integer status = (Integer)hash.get("status");
                            RecentlyLoggedOnListener.this.dcIndex = j;
                            if (status == 0) {
                                Hashtable<String, String> errors;
                                RecentlyLoggedOnListener.this.dcName = (String)hash.get("dcName");
                                try {
                                    RecentlyLoggedOnListener.this.updateStatus(RecentlyLoggedOnListener.this.dcName);
                                    ArrayList list = new ArrayList();
                                    RecentlyLoggedOnListener.this.toBeExecutedAttributeList = list = this.attributeList;
                                    RecentlyLoggedOnListener.this.doAction(domainDetails, dn, RecentlyLoggedOnListener.this.dcName, list, this.listener, this.filterString);
                                    RecentlyLoggedOnListener.this.updateCompletionStatus();
                                    error = false;
                                }
                                catch (LocalizedException exc) {
                                    exc.printStackTrace();
                                    errStr = RecentlyLoggedOnListener.this.rb.getString("client.reports.RealLastLogonListener.error_while_getting_the_reports_from_the_domain") + " " + RecentlyLoggedOnListener.this.domainName + ". " + exc.getMessage(RecentlyLoggedOnListener.this.rb);
                                    System.out.println("LocalizedException: - " + exc.getMessage(RecentlyLoggedOnListener.this.rb));
                                    errors = new Hashtable();
                                    errors.put("INPUT_NAME", RecentlyLoggedOnListener.this.dcName);
                                    errors.put("ERROR_MESSAGE", errStr);
                                    RecentlyLoggedOnListener.this.errorList.put(RecentlyLoggedOnListener.this.dcName, errors);
                                    RecentlyLoggedOnListener.this.updateErrorStatus(errors);
                                    RecentlyLoggedOnListener.this.updateMultiDCStatus(RecentlyLoggedOnListener.this.domainName, RecentlyLoggedOnListener.this.dcName, "domain_error.jpg", null);
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                    errStr = "Error while getting the Reports from the Domain " + RecentlyLoggedOnListener.this.domainName + ". " + ex.getMessage();
                                    errors = new Hashtable<String, String>();
                                    errors.put("INPUT_NAME", RecentlyLoggedOnListener.this.dcName);
                                    errors.put("ERROR_MESSAGE", errStr);
                                    RecentlyLoggedOnListener.this.errorList.put(RecentlyLoggedOnListener.this.dcName, errors);
                                    RecentlyLoggedOnListener.this.updateErrorStatus(errors);
                                    RecentlyLoggedOnListener.this.updateMultiDCStatus(RecentlyLoggedOnListener.this.domainName, RecentlyLoggedOnListener.this.dcName, "domain_error.jpg", null);
                                }
                                status = new Integer(1);
                                RecentlyLoggedOnListener.this.updatedCount = 0;
                            }
                            RecentlyLoggedOnListener.this.resultObject.updateFinishedCount();
                        }
                        if (error) {
                            RecentlyLoggedOnListener.this.errorMessage = errStr;
                            RecentlyLoggedOnListener.this.resultObject.dropTempTable();
                            continue block5;
                        }
                        RecentlyLoggedOnListener.this.updateQueue();
                        RecentlyLoggedOnListener.this.resultObject.dropTempTable();
                    }
                }
                catch (Exception exp) {
                    exp.printStackTrace();
                }
            }
            RecentlyLoggedOnListener.this.completedAction();
            RecentlyLoggedOnListener.this.totalCount = 0;
            RecentlyLoggedOnListener.this.updatedCount = 0;
        }
    }
}

