/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.reports;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.AdmpInput;
import com.adventnet.sym.adsm.common.server.CategoryHandler;
import com.adventnet.sym.adsm.common.server.DomainInfoCache;
import com.adventnet.sym.adsm.common.server.audit.DataImportExportAudit;
import com.adventnet.sym.adsm.common.server.computermanagement.ComputerMgmtHandler;
import com.adventnet.sym.adsm.common.server.customview.NavigateRangeUtil;
import com.adventnet.sym.adsm.common.server.delegation.DelegationUtil;
import com.adventnet.sym.adsm.common.server.helpdesk.ADMPAuthObject;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.layout.FcJSONUtility;
import com.adventnet.sym.adsm.common.server.reports.DashboardReportUtil;
import com.adventnet.sym.adsm.common.server.reports.DateRangePickerHandler;
import com.adventnet.sym.adsm.common.server.reports.GroupHandler;
import com.adventnet.sym.adsm.common.server.reports.InputHandler;
import com.adventnet.sym.adsm.common.server.reports.OUHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportAttributeHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportReqParams;
import com.adventnet.sym.adsm.common.server.reports.ReportsUtil;
import com.adventnet.sym.adsm.common.server.reports.StatusUpdater;
import com.adventnet.sym.adsm.common.server.reports.customreport.CustomReportHandler;
import com.adventnet.sym.adsm.common.server.reports.customreport.CustomReportUtil;
import com.adventnet.sym.adsm.common.server.resultview.RVCConstants;
import com.adventnet.sym.adsm.common.server.usermanagement.UserHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.UserPhotoMgmtUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DomainUtil;
import com.adventnet.sym.adsm.common.server.util.HelpdeskUtil;
import com.adventnet.sym.adsm.common.server.util.I18NUtil;
import com.adventnet.sym.adsm.common.server.util.OUUtil;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import com.adventnet.sym.adsm.common.server.workflow.WorkFlowUtil;
import com.adventnet.sym.adsm.common.webclient.dashboard.DashboardUtil;
import com.adventnet.sym.adsm.common.webclient.export.ReportPdfExporter;
import com.adventnet.sym.adsm.common.webclient.reports.AbstractListener;
import com.adventnet.sym.adsm.common.webclient.reports.ListenerUtil;
import com.adventnet.sym.adsm.common.webclient.reports.MultiDCListener;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.reports.ReportController;
import com.adventnet.sym.adsm.common.webclient.reports.ReportDomain;
import com.adventnet.sym.adsm.common.webclient.reports.ReportExportUtil;
import com.adventnet.sym.adsm.common.webclient.reports.ReportResultInputUtil;
import com.adventnet.sym.adsm.common.webclient.reports.ReportResultUtil;
import com.adventnet.sym.adsm.common.webclient.reports.advanced.AdvancedReportsUtil;
import com.adventnet.sym.adsm.common.webclient.reports.customreport.CustomReportResultUtil;
import com.adventnet.sym.adsm.common.webclient.usermanagement.BulkModificationAPI;
import com.adventnet.sym.adsm.common.webclient.usermanagement.ModifyPhotoListener;
import com.adventnet.sym.adsm.common.webclient.util.ClientAuthorizationUtil;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import com.adventnet.sym.adsm.common.webclient.util.ReportClientUtil;
import com.adventnet.sym.adsm.common.webclient.workflow.WorkFlowClientUtil;
import com.adventnet.sym.adsm.security.server.util.DateTimeUtil;
import com.manageengine.ads.fw.privacy.PrivacyHandler;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;
import org.apache.struts.validator.DynaValidatorForm;
import org.json.JSONArray;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ReportAction
extends DispatchAction {
    private static volatile ReportAction instance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ReportAction getInstance() {
        if (instance != null) return instance;
        Class<ReportAction> clazz = ReportAction.class;
        synchronized (ReportAction.class) {
            if (instance != null) return instance;
            instance = new ReportAction();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public ActionForward initBeanSIDs(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            HttpSession session = request.getSession();
            ReportBean bean = (ReportBean)((Object)session.getAttribute("ReportBean"));
            String checkAllUsers = request.getParameter("checkAllUsers");
            bean.set("selectedSIDs", new ArrayList());
            bean.set("deSelectedSIDs", new ArrayList());
            bean.set("checkAllUsers", checkAllUsers);
            String checkAllUsers1 = (String)bean.get("checkAllUsers");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward saveTable(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            ReportBean bean = (ReportBean)form;
            Integer reportId = (Integer)bean.get("reportId");
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            String substring = request.getParameter("substring");
            StringTokenizer substringTokenizer = new StringTokenizer(substring, ",");
            ArrayList<Properties> subList = new ArrayList<Properties>();
            int i = 0;
            while (substringTokenizer.hasMoreTokens()) {
                Properties properties = new Properties();
                Integer attributeId = new Integer(substringTokenizer.nextToken());
                properties.put("ATTRIB_ID", attributeId);
                properties.put("PRIORITY_ID", new Integer(++i));
                subList.add(properties);
            }
            ReportAttributeHandler.getInstance().saveColumns(reportId, subList, loginId);
            ClientUtil.setStatusXMLElement(response, "Success", "");
        }
        catch (Exception e) {
            e.printStackTrace();
            ClientUtil.setStatusXMLElement(response, "Error", "");
        }
        return null;
    }

    public ActionForward report(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String tile = "mainPage";
        try {
            HttpSession session = request.getSession();
            ReportBean bean = (ReportBean)form;
            Integer reportId = (Integer)bean.get("reportId");
            Integer previousReportId = (Integer)bean.get("previousReportId");
            Long actionId = ClientUtil.getActionId(reportId);
            String menuId = request.getParameter("menuId");
            if (menuId != null && menuId.equalsIgnoreCase("" + WorkFlowUtil.CREATE_REQUEST_MENUID)) {
                tile = "createRequestResultDiv";
                if (WorkFlowClientUtil.createRequest(request, bean)) {
                    System.out.println("report() in createRequest finished Sucess");
                } else {
                    System.out.println("report() in createRequest finished Failure");
                }
                return mapping.findForward(tile);
            }
            if (!ClientAuthorizationUtil.isAuthorized(request, DelegationUtil.REPORT_TAB_ACTION_ID).booleanValue()) {
                return mapping.findForward("accessDenied");
            }
            AbstractListener listener = null;
            ArrayList domainList = (ArrayList)bean.get("domainList");
            if (domainList == null || domainList.size() == 0) {
                bean.set("domains", new String[0]);
            }
            ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
            Hashtable domains = authObject.getDomainAndOUs();
            bean.set("dnDomainNameMap", domains.get("dnDomainNameMap"));
            bean.set("selectedSIDs", new ArrayList());
            bean.set("deSelectedSIDs", new ArrayList());
            if (bean.get("reportId") != null) {
                this.setDomainList(request, form);
            }
            String selectedDomainName = "";
            ArrayList domainNamelist = (ArrayList)bean.get("domainList");
            if (domainNamelist.size() > 0) {
                Properties domainNameProp = (Properties)domainNamelist.get(0);
                selectedDomainName = domainNameProp.getProperty("DOMAIN_NAME");
            }
            if (request.getParameter("init") != null) {
                bean.set("reportId", new Integer(-1));
                bean.set("previousReportId", new Integer(0));
                bean.set("trusteesList", new ArrayList());
                bean.set("critValues", null);
                bean.set("reportInputParams", new HashMap());
                bean.set("reqParams", new ReportReqParams());
            } else if (reportId != null && !reportId.equals(previousReportId)) {
                if (!ClientAuthorizationUtil.isAuthorized(request, selectedDomainName, actionId).booleanValue()) {
                    tile = "accessDenied";
                } else {
                    this.initialize(request, bean);
                    listener = bean.getListener();
                    tile = (String)bean.get("tile");
                }
                bean.set("trusteesList", new ArrayList());
                bean.set("reportInputParams", new HashMap());
                bean.set("domains", new String[0]);
                bean.set("reqParams", new ReportReqParams());
                ListenerUtil.getInputValues(listener.getGenerationId(), reportId, request, bean);
            } else if (bean.getListener() != null) {
                if (reportId != null && !reportId.equals(previousReportId) && !ClientAuthorizationUtil.isAuthorized(request, selectedDomainName, actionId).booleanValue()) {
                    tile = "accessDenied";
                } else {
                    listener = bean.getListener();
                    tile = (String)bean.get("tile");
                    listener.removeInputParams(bean);
                }
            }
            if (listener != null) {
                listener.setInputParams(request, bean);
            }
            if (request.getParameter("init") == null) {
                bean.set("previousReportId", reportId);
            }
            if (request.getParameter("resetValues") != null) {
                listener.checkBoxes(request, bean);
            }
            request.setAttribute("exportOptions", (Object)this.getExpOptions(reportId));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward(tile);
    }

    private ArrayList getExpOptions(Integer reportId) {
        ArrayList expList = new ArrayList();
        if (reportId != null && reportId == 951) {
            HashMap<String, String> expMap = new HashMap<String, String>();
            expMap.put("id", "html");
            expMap.put("img", "images/html_icon.gif");
            expMap.put("text", "admp.common.export_type.html");
            expList.add(expMap);
            expMap = new HashMap();
            expMap.put("id", "pdf");
            expMap.put("img", "images/pdf_icon.gif");
            expMap.put("text", "admp.common.export_type.pdf");
            expList.add(expMap);
            expMap = new HashMap();
            expMap.put("id", "xlsx");
            expMap.put("img", "images/xls_icon1.gif");
            expMap.put("text", "admp.common.export_type.xlsx");
            expList.add(expMap);
        }
        return expList;
    }

    private void setDomainList(HttpServletRequest request, ActionForm form) {
        try {
            HttpSession session = request.getSession();
            Long actionId = 0L;
            ReportBean bean = (ReportBean)form;
            Integer reportId = (Integer)bean.get("reportId");
            Criteria criteria = new Criteria(new Column("ADSMReports", "REPORT_ID"), (Object)reportId, 0);
            DataObject dataobj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMReports", criteria);
            if (!dataobj.isEmpty()) {
                Row r = dataobj.getFirstRow("ADSMReports");
                actionId = (Long)r.get("ACTION_ID");
            }
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
            Hashtable domainVsactions = authObject.getDomainActionMap();
            ArrayList domainList = HDTDomainHandler.getDomainListForUser((Long)loginId, (Hashtable)domainVsactions, (Long)actionId);
            bean.set("domainList", domainList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward exportBitlockerKey(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        OutputStream out = null;
        try {
            ByteArrayOutputStream bObj = new ByteArrayOutputStream();
            bObj.reset();
            String keyPackage = request.getParameter("keyPackage");
            String recoveryGuid = request.getParameter("RecoveryGUID");
            if (recoveryGuid == null || recoveryGuid.equalsIgnoreCase("null") || recoveryGuid.equalsIgnoreCase("")) {
                recoveryGuid = "Bitlocker";
            }
            int[] result = new int[keyPackage.length() / 3];
            for (int i = 0; i < keyPackage.length() / 3; ++i) {
                result[i] = Integer.parseInt(keyPackage.substring(i * 3, i * 3 + 3));
            }
            for (int x : result) {
                bObj.write(x);
            }
            byte[] buf = bObj.toByteArray();
            response.setContentType("application/octet-stream");
            response.setContentLength(buf.length);
            response.setHeader("content-disposition", "attachment; filename=" + recoveryGuid + "_keyPackage");
            out = response.getOutputStream();
            out.write(buf, 0, buf.length);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public ActionForward exportReport(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String tile = "printPage";
        try {
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            ReportBean bean = (ReportBean)form;
            ReportReqParams reqParams = (ReportReqParams)bean.get("reqParams");
            Integer reportId = (Integer)bean.get("reportId");
            HashMap inputParams = (HashMap)bean.get("inputParams");
            AbstractListener listener = bean.getListener();
            ReportBean reportBean = (ReportBean)((Object)session.getAttribute("ReportBean"));
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            Long generationId = listener.getGenerationId();
            Row row = ReportHandler.getGeneratedReportDetails((Long)generationId, (Long)loginId);
            Long time = (Long)row.get("CREATION_TIME");
            String genTime = DateTimeUtil.getDateFormat((Long)loginId).format(new Date(time));
            inputParams.put("desc", (String)row.get("DESCRIPTION"));
            inputParams.put("date", genTime);
            inputParams.put("Description", rb.getString("admp.reports_export.pageheader.description"));
            ArrayList attributelist = null;
            String reportList = request.getParameter("reportList");
            if (reportList.equals("true")) {
                attributelist = ReportAttributeHandler.getInstance().getViewColumn(reportId, loginId);
            } else {
                attributelist = ReportAttributeHandler.getInstance().getModifiedColumns(reportId);
                Integer mgmtReportId = (Integer)bean.get("mgmtReportId");
                DataObject mgmtActionDataObject = ReportHandler.getReportDetails((Integer)mgmtReportId);
                Row mgmtActionRow = mgmtActionDataObject.getFirstRow("ADSMReports");
                inputParams.put("desc", rb.getString((String)mgmtActionRow.get("REPORT_NAME")));
                inputParams.put("Description", rb.getString("Action"));
            }
            listener.updateAttributeList(bean, attributelist);
            String reportType = request.getParameter("reportType");
            if (reportType == null) {
                reportType = "";
            }
            DataObject obj = ReportHandler.getReportDetails((Integer)reportId);
            Row r = obj.getFirstRow("ADSMReports");
            HashMap reportInputParams = (HashMap)bean.get("reportInputParams");
            ArrayList trusteesList = null;
            if (reportInputParams.containsKey("trusteesList")) {
                trusteesList = (ArrayList)reportInputParams.get("trusteesList");
            } else if (reportInputParams.containsKey("operatingSystem")) {
                trusteesList = (ArrayList)reportInputParams.get("operatingSystem");
            }
            ArrayList sharesList = (ArrayList)reportInputParams.get("pathList");
            JSONArray jsonArray = reqParams.getRvcFilters();
            String[] domains = (String[])bean.get("domains");
            if (domains.length > 0) {
                String domainName = DomainUtil.getDomainName((String)domains[0]);
                listener.setDomainName(domainName);
            }
            if (trusteesList != null && trusteesList.size() != 0) {
                listener.exportReport(r, reportType, attributelist, inputParams, request, response, reportList, listener, trusteesList, reqParams);
            } else if (sharesList != null && sharesList.size() != 0 && reportInputParams.containsKey("searchPath")) {
                listener.exportReport(r, reportType, attributelist, inputParams, request, response, reportList, listener, sharesList, reqParams);
            } else {
                listener.exportReport(r, reportType, attributelist, inputParams, request, response, reportList, listener, reqParams);
            }
            if (PrivacyHandler.getInstance().isExportAuditEnabled().booleanValue()) {
                DataImportExportAudit.auditDataFlow((Long)System.currentTimeMillis(), (Long)loginId, (String)HelpdeskUtil.getLoginUserName((Long)loginId), (String)request.getRemoteAddr(), (String)"admp.deleg.hdt_deleg.cre_role.action_name.ad_reports", (String)((String)r.get("REPORT_NAME")), (Integer)reportId, (String)"-", (Boolean)Boolean.FALSE, (String)listener.getExportFileName(), (String)reportType.toLowerCase(), (String)"-", (Integer)listener.getExportRowCount());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String type = request.getParameter("type");
        if (type != null && type.equals("print")) {
            return mapping.findForward(tile);
        }
        return null;
    }

    public ActionForward stopReport(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            ReportBean bean = (ReportBean)form;
            Long generationId = Long.parseLong(request.getParameter("generationId"));
            StatusUpdater dynamicUpdator = ReportController.getInstance().getStatusUpdater(generationId);
            dynamicUpdator.setProgressTask(StatusUpdater.TASKCODE.PROCESS_INTERRUPTED.getValue());
            ReportController.getInstance().stopReport(generationId, bean, request);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward generateReport(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String forwardPage = "result";
        ReportBean bean = (ReportBean)form;
        Integer reportId = (Integer)bean.get("reportId");
        Integer previousReportId = (Integer)bean.get("previousReportId");
        Long generationId = 0L;
        Long time = 0L;
        boolean resetBeanFlag = false;
        if (reportId != null && !reportId.equals(previousReportId)) {
            this.initializeListener(request, bean);
            resetBeanFlag = true;
        }
        AbstractListener listener = bean.getListener();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        ArrayList attributelist = ReportAttributeHandler.getInstance().getViewColumn(reportId, loginId);
        String action = request.getParameter("action");
        if (action == null) {
            action = "";
        }
        if (action.equalsIgnoreCase("generatedReports")) {
            if (resetBeanFlag) {
                this.initializeBean(request, bean);
            }
            forwardPage = "generatedReports";
        }
        if (request.getParameter("generationId") != null) {
            listener.setGenerationId(request);
        }
        try {
            StatusUpdater dynamicUpdator;
            JSONObject jsonObject = new JSONObject();
            boolean isReportRunning = false;
            if (action.equalsIgnoreCase("Generate")) {
                isReportRunning = true;
                String dynamicHandlerClassName = "com.adventnet.sym.adsm.common.webclient.statusupdater.ReportStatusUpdater";
                StatusUpdater statusUpdater = (StatusUpdater)Class.forName(dynamicHandlerClassName.trim()).newInstance();
                listener.errorMessage = null;
                listener.setStatusController(statusUpdater);
                ReportController.getInstance().generateReport(reportId, request, bean, statusUpdater);
                jsonObject.put("generationId", (Object)listener.getGenerationId());
                request.setAttribute("listener", (Object)listener);
                this.initializeBean(request, bean);
            }
            if (listener.getGenerationId() != null) {
                generationId = listener.getGenerationId();
                JSONArray outputFilterArray = ReportResultUtil.getOutputFiltersList(reportId, generationId, -1);
                jsonObject.put("generationId", (Object)listener.getGenerationId());
                jsonObject.put("domainList", (Object)"");
                jsonObject.put("attributeId", (Object)"-1");
                jsonObject.put("sortingOrder", true);
                jsonObject.put("navigationConfig", (Object)ReportClientUtil.getDefaultNavigationConfig(loginId));
                jsonObject.put("outputFilters", (Object)outputFilterArray);
            }
            jsonObject.put("reportId", (Object)reportId);
            jsonObject.put("viewType", 1);
            boolean isAddCustomAttributeLinkAuthorized = false;
            Row r = ReportHandler.getReportDetailsRow((Integer)reportId);
            String baseTableName = (String)r.get("BASE_TABLE_NAME");
            String[] customAttributTables = new String[]{"ADSMUserGeneralDetails", "ADSMGroupGeneralDetails", "ADSMComputerGeneralDetails", "ADSMMRGeneralDetails"};
            if (ClientUtil.checkAuthorization(request, DelegationUtil.ADMINTAB.LDAP_ATTRIBUTES.getValue()) && Arrays.asList(customAttributTables).contains(baseTableName)) {
                isAddCustomAttributeLinkAuthorized = true;
            }
            if (listener.isMultiDC()) {
                jsonObject.put("viewType", 2);
            }
            if ((reportId == 951 || reportId == 957) && (dynamicUpdator = ReportController.getInstance().getStatusUpdater(generationId)) != null) {
                isReportRunning = true;
            }
            jsonObject.put("isReportRunning", isReportRunning);
            String outPutFilterDisplayName = "";
            jsonObject.put("isAddCustomAttributeLinkAuthorized", isAddCustomAttributeLinkAuthorized);
            response.setContentType("application/json");
            PrintWriter writer = response.getWriter();
            writer.print(jsonObject.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public ActionForward getReportResultLayout(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String forwardPage = "reportResultLayout";
        ReportBean bean = (ReportBean)form;
        Integer reportId = (Integer)bean.get("reportId");
        try {
            HttpSession session = request.getSession();
            AbstractListener listener = bean.getListener();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            DataObject dataObj = ReportHandler.getReportDetails((Integer)reportId);
            Long reportActId = (Long)dataObj.getFirstRow("ADSMReports").get("ACTION_ID");
            String action = request.getParameter("action");
            String domainName = request.getParameter("domainName");
            boolean isAuthorized = true;
            if (request.getParameter("isAuthorized") != null && !request.getParameter("isAuthorized").equalsIgnoreCase("")) {
                isAuthorized = Boolean.getBoolean(request.getParameter("isAuthorized"));
            }
            if (action == null) {
                action = "";
            }
            Long generationId = listener.getGenerationId();
            ArrayList attributelist = ReportAttributeHandler.getInstance().getViewColumn(reportId, loginId);
            ArrayList<Hashtable<String, ArrayList<Hashtable<String, Object>>>> cvcInputList = ReportResultInputUtil.getCVCSelectedInputList(reportId, generationId, -1, null);
            ArrayList list = listener.getReportInputParam(cvcInputList);
            String outPutFilterDisplayName = StrUtil.getOutputFiltersDisplayValue((ArrayList)list, (int)RVCConstants.RVC_OP_FILTERS_LIST_TRIM_SIZE, (String)"objectName");
            Row r = ReportHandler.getGeneratedReportDetails((Long)generationId, (Long)loginId);
            Long time = (Long)r.get("CREATION_TIME");
            String genTime = DateTimeUtil.getDateFormat((Long)loginId).format(new Date(time));
            request.setAttribute("genTime", (Object)genTime);
            request.setAttribute("opFilterDisplayName", (Object)outPutFilterDisplayName);
            request.setAttribute("ColumnList", (Object)attributelist);
            request.setAttribute("action", (Object)action);
            request.setAttribute("isAuthorized", (Object)isAuthorized);
            bean.set("previousReportId", reportId);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return mapping.findForward(forwardPage);
    }

    public ActionForward getDynamicUpdateDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        JSONObject jsonObject = null;
        try {
            JSONObject reqJSONObject = new JSONObject(request.getParameter("params"));
            Long generationId = reqJSONObject.getInt("generationId");
            StatusUpdater dynamicUpdator = ReportController.getInstance().getStatusUpdater(generationId);
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            if (dynamicUpdator == null) {
                jsonObject = new JSONObject();
                jsonObject.put("isCompleted", true);
            } else {
                jsonObject = dynamicUpdator.getJSONObject(reqJSONObject, rb);
            }
            response.setContentType("application/json");
            PrintWriter writer = response.getWriter();
            writer.print(jsonObject.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward getReportRunStatus(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean isResultAvailable = false;
        JSONObject jsonObject = null;
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        String statusErrorMessage = rb.getString("admp.reports.common.stat_msg.no_matching_data_for_input");
        try {
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            Integer reportId = Integer.parseInt(request.getParameter("reportId"));
            Long generationId = Long.parseLong(request.getParameter("generationId"));
            isResultAvailable = AdvancedReportsUtil.isResultAvailableForGenerationId(generationId, reportId);
            jsonObject = new JSONObject();
            ReportBean bean = (ReportBean)form;
            String[] domains = (String[])bean.get("domains");
            ArrayList domainList = (ArrayList)bean.get("domainList");
            if (domains == null || domains.length == 0) {
                for (int i = 0; i < domainList.size(); ++i) {
                    Properties domainProp = (Properties)domainList.get(i);
                    String defaultDomain = domainProp.getProperty("IS_DEFAULT_DOMAIN");
                    String defaultNamingContext = domainProp.getProperty("DEFAULT_NAMING_CONTEXT");
                    if (!defaultDomain.equals("true")) continue;
                    domains = new String[]{defaultNamingContext};
                }
            }
            jsonObject.put("isResultAvailable", true);
            if (!isResultAvailable) {
                StatusUpdater dynamicUpdator = ReportController.getInstance().getStatusUpdater(generationId);
                jsonObject.put("isResultAvailable", false);
                if (dynamicUpdator != null) {
                    AbstractListener listener = bean.getListener();
                    statusErrorMessage = listener != null && listener.errorMessage != null && !listener.errorMessage.isEmpty() ? listener.errorMessage : rb.getString(ReportsUtil.getEmptyReportResultMessage((Integer)reportId));
                }
            }
            Row r = ReportHandler.getGeneratedReportDetails((Long)generationId, (Long)loginId);
            Long time = (Long)r.get("CREATION_TIME");
            String genTime = DateTimeUtil.getDateFormat((Long)loginId).format(new Date(time));
            String description = (String)r.get("DESCRIPTION");
            jsonObject.put("errorMessage", (Object)statusErrorMessage);
            jsonObject.put("reportGeneratedDomains", (Object)FcJSONUtility.getJsonArray((String[])domains));
            jsonObject.put("description", (Object)description);
            jsonObject.put("generationTime", (Object)genTime);
            response.setContentType("application/json");
            PrintWriter writer = response.getWriter();
            writer.print(jsonObject.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward getReportResultColumnHeader(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String forwardName = "reportResultColumnHeader";
        try {
            HttpSession session = request.getSession();
            String action = request.getParameter("action");
            if (action == null) {
                action = "";
            }
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            Integer reportId = Integer.parseInt(request.getParameter("reportId"));
            ArrayList attributelist = ReportAttributeHandler.getInstance().getViewColumn(reportId, loginId);
            request.setAttribute("ColumnList", (Object)attributelist);
            request.setAttribute("action", (Object)action);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward(forwardName);
    }

    public ActionForward generate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String forwardPage = "result";
        ReportBean bean = (ReportBean)form;
        Integer reportId = (Integer)bean.get("reportId");
        Integer previousReportId = (Integer)bean.get("previousReportId");
        Long generationId = 0L;
        Long time = 0L;
        boolean resetBeanFlag = false;
        if (reportId != null && !reportId.equals(previousReportId)) {
            this.initializeListener(request, bean);
            resetBeanFlag = true;
        }
        AbstractListener listener = bean.getListener();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        ArrayList attributelist = ReportAttributeHandler.getInstance().getViewColumn(reportId, loginId);
        String action = request.getParameter("action");
        if (action == null) {
            action = "";
        }
        if (action.equalsIgnoreCase("generatedReports")) {
            if (resetBeanFlag) {
                this.initializeBean(request, bean);
                this.setDomainList(request, form);
            }
            forwardPage = "generatedReports";
        }
        if (request.getParameter("generationId") != null) {
            listener.setGenerationId(request);
        }
        try {
            if (action.equalsIgnoreCase("Generate")) {
                listener.start(reportId, request, bean);
                request.setAttribute("listener", (Object)listener);
                this.initializeBean(request, bean);
            } else if (listener.getGenerationId() != null) {
                generationId = listener.getGenerationId();
                ReportClientUtil.checkAndSetSelectAllObjectGUIDs(request, bean);
                if (action.equalsIgnoreCase("Stop")) {
                    listener.stop(request);
                    listener.setWriter(response.getWriter());
                } else if (action.equalsIgnoreCase("showList") || action.equalsIgnoreCase("showListPermissions")) {
                    forwardPage = action;
                } else if (action.equalsIgnoreCase("fullScreenList")) {
                    forwardPage = "fullScreenList";
                    bean.set("searchString", "");
                } else if (action.equalsIgnoreCase("generatedReports")) {
                    generationId = listener.getGenerationId();
                    bean.set("searchString", "");
                }
                if (request.getParameter("clearCheckAll") != null && request.getParameter("clearCheckAll").equals("true")) {
                    bean.set("checkAllUsers", "false");
                }
                Row r = ReportHandler.getGeneratedReportDetails((Long)generationId, (Long)loginId);
                time = (Long)r.get("CREATION_TIME");
                String genTime = DateTimeUtil.getDateFormat((Long)loginId).format(new Date(time));
                request.setAttribute("details", (Object)r);
                bean.setRange(request, false);
                this.setInputParams(request, bean, genTime);
                Integer range = (Integer)bean.get("RANGE");
                Long startIndex = (Long)bean.get("FROM_INDEX");
                listener.updateAttributeList(bean, attributelist);
                ListenerUtil.getInputValues(generationId, reportId, request, bean);
                ArrayList<Hashtable<String, ArrayList<Hashtable<String, Object>>>> cvcInputList = ReportResultInputUtil.getCVCSelectedInputList(reportId, generationId, -1, null);
                ReportReqParams reqParams = new ReportReqParams();
                reqParams.setRvcFilters(ReportResultUtil.getOutputFiltersList(cvcInputList));
                listener.updateNativeErrorMessage(reqParams);
                ReportResultUtil.setRecordsCount(request, bean, listener.getGenerationId(), reqParams);
                String outPutFilterDisplayName = "";
                ArrayList list = listener.getReportInputParam(cvcInputList);
                if (!list.isEmpty()) {
                    outPutFilterDisplayName = StrUtil.getOutputFiltersDisplayValue((ArrayList)list, (int)RVCConstants.RVC_OP_FILTERS_LIST_TRIM_SIZE, (String)"objectName");
                }
                request.setAttribute("opFilterDisplayName", (Object)outPutFilterDisplayName);
            }
            request.setAttribute("ColumnList", (Object)attributelist);
            request.setAttribute("action", (Object)action);
            bean.set("previousReportId", reportId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward(forwardPage);
    }

    public ActionForward showReportResult(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String tile = "mainPage";
        try {
            HttpSession session = request.getSession();
            ReportBean bean = (ReportBean)form;
            Integer reportId = (Integer)bean.get("reportId");
            Integer previousReportId = (Integer)bean.get("previousReportId");
            Long actionId = ClientUtil.getActionId(reportId);
            boolean beanInitialized = false;
            String action = request.getParameter("action");
            if (action == null) {
                action = "";
            }
            if (action.equalsIgnoreCase("generatedReports")) {
                if (reportId != null) {
                    this.initialize(request, bean);
                    beanInitialized = true;
                }
                if (request.getParameter("generationId") == null || "null".equals(request.getParameter("generationId"))) {
                    bean.getListener().setGenerationId((Long)null);
                    request.setAttribute("showGenerateReportMessage", (Object)true);
                }
            }
            AbstractListener listener = null;
            ArrayList domainList = (ArrayList)bean.get("domainList");
            if (domainList == null || domainList.size() == 0) {
                bean.set("domains", new String[0]);
            }
            ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
            Hashtable domains = authObject.getDomainAndOUs();
            bean.set("dnDomainNameMap", domains.get("dnDomainNameMap"));
            bean.set("selectedSIDs", new ArrayList());
            bean.set("deSelectedSIDs", new ArrayList());
            if (bean.get("reportId") != null) {
                this.setDomainList(request, form);
            }
            String selectedDomainName = "";
            ArrayList domainNamelist = (ArrayList)bean.get("domainList");
            if (domainNamelist.size() > 0) {
                Properties domainNameProp = (Properties)domainNamelist.get(0);
                selectedDomainName = domainNameProp.getProperty("DOMAIN_NAME");
            }
            if (!ClientAuthorizationUtil.isAuthorized(request, selectedDomainName, actionId).booleanValue()) {
                tile = "accessDenied";
            } else {
                if (!beanInitialized) {
                    this.initialize(request, bean);
                }
                listener = bean.getListener();
                tile = (String)bean.get("tile");
            }
            bean.set("trusteesList", new ArrayList());
            bean.set("reportInputParams", new HashMap());
            bean.set("domains", new String[0]);
            bean.set("reqParams", new ReportReqParams());
            if (listener != null) {
                ListenerUtil.getInputValues(listener.getGenerationId(), reportId, request, bean);
            }
            if (request.getParameter("domainName") != null) {
                String[] givenDomain = new String[]{DomainUtil.getDefaultNamingContext((String)request.getParameter("domainName"))};
                bean.set("domains", givenDomain);
            } else {
                Long drm = Long.parseLong(request.getParameter("dashboardReportMapping"));
                ArrayList schDomains = DashboardReportUtil.getReportDomains((Long)drm);
                String[] givenDomain = new String[schDomains.size()];
                Hashtable<String, ArrayList> dashDomainOUList = new Hashtable<String, ArrayList>();
                Hashtable<String, ArrayList> dashExcludedOUList = new Hashtable<String, ArrayList>();
                Hashtable<String, Boolean> dashDomainVsExcludeChildOU = new Hashtable<String, Boolean>();
                for (int k = 0; k < schDomains.size(); ++k) {
                    String domainName = (String)schDomains.get(k);
                    givenDomain[k] = DomainUtil.getDefaultNamingContext((String)domainName);
                    dashDomainOUList.put(givenDomain[k], DashboardReportUtil.getReportContainers((Long)drm, (String)domainName));
                    dashExcludedOUList.put(domainName, DashboardReportUtil.getReportExcludedContainers((Long)drm, (String)domainName));
                    dashDomainVsExcludeChildOU.put(domainName, DashboardReportUtil.getReportExcludeChildContainers((Long)drm, (String)domainName));
                }
                bean.set("domains", givenDomain);
                bean.set("domainOUList", dashDomainOUList);
                bean.set("excludedOUList", dashExcludedOUList);
                bean.set("domainVsExcludeChildOU", dashDomainVsExcludeChildOU);
            }
            if (listener != null) {
                listener.setDashboardInputParams(Long.parseLong(request.getParameter("dashboardReportMapping")), request, bean);
            }
            bean.set("previousReportId", reportId);
            request.setAttribute("exportOptions", (Object)this.getExpOptions(reportId));
            System.out.println("reportInputParams is ---- " + bean.get("reportInputParams"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward(tile);
    }

    public ActionForward getReportResultRows(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String tile = "";
        ArrayList attributelist = null;
        JSONObject jsonObject = null;
        try {
            HttpSession session = request.getSession();
            ReportBean bean = (ReportBean)((Object)session.getAttribute("ReportBean"));
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            AbstractListener listener = bean.getListener();
            Long generationId = listener.getGenerationId();
            Integer reportId = (Integer)bean.get("reportId");
            jsonObject = new JSONObject(request.getParameter("params"));
            ReportReqParams reqParams = (ReportReqParams)bean.get("reqParams");
            reqParams = new ReportReqParams(jsonObject);
            reqParams.setLoginId(loginId);
            reqParams.setGenerationId(generationId);
            reqParams.setReportId(reportId.intValue());
            reqParams.setRb(rb);
            bean.set("reqParams", reqParams);
            if (!reqParams.isNavigate()) {
                NavigateRangeUtil.setDefaultRange((String)"ReportResult", (int)reqParams.getRange(), (Long)loginId);
            }
            attributelist = ReportAttributeHandler.getInstance().getViewColumn(reportId, loginId);
            listener.updateAttributeList(bean, attributelist);
            listener.setReportRows(request, bean, generationId, attributelist, reqParams);
            listener.updateNativeErrorMessage(reqParams);
            tile = "showList";
            request.setAttribute("ColumnList", (Object)attributelist);
            request.setAttribute("action", (Object)reqParams.getAction());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward(tile);
    }

    public ActionForward getOutputFiltersList(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String forwardPage = "outputFilters";
        try {
            HttpSession session = request.getSession();
            Integer reportId = Integer.parseInt(request.getParameter("reportId"));
            ReportBean bean = (ReportBean)((Object)session.getAttribute("ReportBean"));
            AbstractListener listener = bean.getListener();
            Long generationId = listener.getGenerationId();
            Integer fromIndex = 1;
            boolean isFirstTime = true;
            if (request.getParameter("fromIndex") != null) {
                fromIndex = Integer.parseInt(request.getParameter("fromIndex"));
                isFirstTime = false;
            }
            String searchText = null;
            if (request.getParameter("searchText") != null) {
                searchText = request.getParameter("searchText");
                searchText = "*" + searchText + "*";
            }
            Integer totalFiltersCount = ReportResultInputUtil.getCVCSelectedInputsCount(reportId, generationId, searchText);
            ArrayList<Hashtable<String, ArrayList<Hashtable<String, Object>>>> cvcInputList = ReportResultInputUtil.getCVCSelectedInputList(reportId, generationId, fromIndex, searchText);
            ArrayList outputFiltersList = listener.getReportInputParam(cvcInputList);
            if (isFirstTime) {
                request.setAttribute("cvcDataId", (Object)reportId);
                request.setAttribute("filtersCount", (Object)totalFiltersCount);
                request.setAttribute("filtersList", (Object)outputFiltersList);
                request.setAttribute("scriptConfigId", (Object)ReportsUtil.REPORT_RESULTVIEW_NORMALFLOW_OUTPUTFILTERS_SCRIPTCONFIG_ID);
                return mapping.findForward(forwardPage);
            }
            ByteArrayOutputStream outNode = ClientUtil.seteXMLElement(outputFiltersList, totalFiltersCount);
            response.setContentType("text/xml; charset=UTF-8");
            PrintWriter writer = response.getWriter();
            writer.print(outNode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward copyUserResult(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            ReportBean bean = (ReportBean)((Object)session.getAttribute("ReportBean"));
            AbstractListener listener = bean.getListener();
            if (request.getParameter("actionInput") != null) {
                AdmpInput admpInput = new AdmpInput(new JSONObject(request.getParameter("actionInput")));
                bean.set("mgmtActionInput", admpInput);
            }
            Integer mgmtReportId = Integer.parseInt(request.getParameter("mgmtReportId"));
            DataObject obj = ReportHandler.getReportDetails((Integer)mgmtReportId);
            Row r = obj.getFirstRow("ADSMReports");
            listener.mgmtResultTableName = (String)r.get("RESULT_TABLE_NAME");
            ArrayList selectedSidList = ReportResultInputUtil.getSelectedSids(request, bean);
            String description = "Reports to On the fly management from report : " + bean.get("reportId") + " to mgmtAction : " + mgmtReportId;
            listener.mgmtGenerationId = ReportClientUtil.copyUserResult(selectedSidList, mgmtReportId, listener.mgmtResultTableName, loginId, description);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public ActionForward mgmtAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String tile = "";
        try {
            ReportBean bean = (ReportBean)form;
            Integer reportId = (Integer)bean.get("mgmtReportId");
            AbstractListener listener = bean.getListener();
            String action = request.getParameter("action");
            if (request.getParameter("menuId") != null) {
                Long menuId = Long.parseLong(request.getParameter("menuId"));
                bean.set("menuId", menuId);
            }
            if (request.getParameter("mgmtReportId") != null) {
                Integer mgmtReportId = Integer.parseInt(request.getParameter("mgmtReportId"));
                bean.set("mgmtReportId", mgmtReportId);
            }
            ArrayList modifiedList = ReportAttributeHandler.getInstance().getModifiedColumns(reportId);
            if (action.equalsIgnoreCase("Apply")) {
                bean.set("modifyResultColumn", "");
                bean.set("FROM_INDEX", new Long(1L));
                bean.set("PAGE_NUMBER", "1");
                bean.set("ascending", "true");
                listener.mgmtAction(request, bean);
                request.setAttribute("listener", (Object)listener);
            } else if (action.equalsIgnoreCase("Stop Modification")) {
                listener.stop(request);
                listener.setWriter(response.getWriter());
                ReportResultUtil.setModifyResult(request, bean, reportId, listener.mgmtGenerationId, listener.mgmtResultTableName);
            } else if (action.equalsIgnoreCase("showModifyUserResult")) {
                bean.setRange(request, false);
                ReportResultUtil.setModifyResult(request, bean, reportId, listener.mgmtGenerationId, listener.mgmtResultTableName);
            }
            tile = (String)bean.get("tile");
            request.setAttribute("ColumnList", (Object)modifiedList);
            request.setAttribute("action", (Object)action);
            if (listener != null) {
                listener.setInputParams(request, bean);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward(tile);
    }

    public ActionForward enableDC(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            String domainName = request.getParameter("domainName");
            String dcName = request.getParameter("dcName");
            ReportBean bean = (ReportBean)form;
            MultiDCListener listener = (MultiDCListener)bean.getListener();
            listener.enableDC(domainName, dcName);
            ByteArrayOutputStream outNode = this.getMultiDCElements(listener);
            response.setContentType("text/xml");
            response.setHeader("Pragma", "no-cache");
            response.setHeader("Expires", "0");
            response.setHeader("Cache-Control", "no-store");
            PrintWriter writer = response.getWriter();
            writer.print(outNode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward disableDC(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            String domainName = request.getParameter("domainName");
            String dcName = request.getParameter("dcName");
            ReportBean bean = (ReportBean)form;
            MultiDCListener listener = (MultiDCListener)bean.getListener();
            listener.disableDC(domainName, dcName);
            ByteArrayOutputStream outNode = this.getMultiDCElements(listener);
            response.setContentType("text/xml");
            response.setHeader("Pragma", "no-cache");
            response.setHeader("Expires", "0");
            response.setHeader("Cache-Control", "no-store");
            PrintWriter writer = response.getWriter();
            writer.print(outNode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private ByteArrayOutputStream getMultiDCElements(MultiDCListener listener) {
        ByteArrayOutputStream outNode = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element data = document.createElement("data");
            document.appendChild(data);
            Hashtable reportDomains = listener.getReportDomains();
            Enumeration e = reportDomains.keys();
            while (e.hasMoreElements()) {
                String domainName = (String)e.nextElement();
                ReportDomain domain = (ReportDomain)reportDomains.get(domainName);
                ArrayList dcList = domain.getDCList();
                for (int i = 0; i < dcList.size(); ++i) {
                    Hashtable hash = (Hashtable)dcList.get(i);
                    String dcName = (String)hash.get("dcName");
                    Integer status = (Integer)hash.get("status");
                    Element child = document.createElement("child");
                    child.setAttribute("dcId", domainName + "-" + dcName);
                    child.setAttribute("status", status.toString());
                    data.appendChild(child);
                }
            }
            DOMSource source = new DOMSource(data);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            outNode = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(outNode);
            transformer.transform(source, result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return outNode;
    }

    public ActionForward getGroups(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            String domainName = request.getParameter("domainName");
            ArrayList groups = InputHandler.getGroups((String)domainName);
            ByteArrayOutputStream outNode = null;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element data = document.createElement("data");
            document.appendChild(data);
            for (int i = 0; i < groups.size(); ++i) {
                Properties p = (Properties)groups.get(i);
                Element child = document.createElement("child");
                child.setAttribute("Distinguished_Name", p.getProperty("Distinguished_Name"));
                child.setAttribute("Display_Name", p.getProperty("Display_Name"));
                data.appendChild(child);
            }
            DOMSource source = new DOMSource(data);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            outNode = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(outNode);
            transformer.transform(source, result);
            response.setContentType("text/xml");
            response.setHeader("Pragma", "no-cache");
            response.setHeader("Expires", "0");
            response.setHeader("Cache-Control", "no-store");
            PrintWriter writer = response.getWriter();
            writer.print(outNode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private void initialize(HttpServletRequest request, ReportBean bean) {
        this.initializeListener(request, bean);
        this.initializeBean(request, bean);
        this.initializeKeyValues(bean);
    }

    private void initializeListener(HttpServletRequest request, ReportBean bean) {
        try {
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
            Long[] actionIds = authObject.getActionArray();
            Integer reportId = (Integer)bean.get("reportId");
            DataObject obj = ReportHandler.getReportDetails((Integer)reportId);
            Row r = obj.getFirstRow("ADSMReports");
            String className = (String)r.get("CLASS_NAME");
            Class<?> classToInvoke = Class.forName(className.trim());
            AbstractListener listener = (AbstractListener)classToInvoke.newInstance();
            listener.init(request, r);
            bean.set("tile", (String)r.get("TILE_NAME"));
            bean.setListener(listener);
            bean.set("reportActions", CategoryHandler.getReportActions((Long)listener.getCategoryId(), (Long[])actionIds, (Boolean)true));
            bean.set("menus", CategoryHandler.getReportMenus((Integer)((Integer)bean.get("reportId")), (Long[])actionIds));
            bean.set("workFlowMenus", CategoryHandler.getWorkFlowMenus((Integer)reportId, (Long)loginId));
            bean.set("selectedSIDs", new ArrayList());
            bean.set("deSelectedSIDs", new ArrayList());
            Hashtable hash = new Hashtable();
            bean.set("domainOUList", hash);
            bean.set("excludedOUList", new Hashtable());
            bean.set("domainVsExcludeChildOU", new Hashtable());
            bean.set("USERSDN", new ArrayList());
            bean.set("CHECKEDDN", new ArrayList());
            bean.set("USERSLIST", new ArrayList());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initializeBean(HttpServletRequest request, ReportBean bean) {
        try {
            bean.set("attributeId", new Integer(-1));
            bean.setRange(request, true);
            bean.set("PAGE_NUMBER", "1");
            bean.set("FROM_INDEX", new Long(1L));
            bean.set("ascending", "true");
            bean.set("searchString", "");
            bean.set("inputObjects", new ArrayList());
            bean.set("checkAllUsers", "false");
            bean.set("selectAllUsers", "false");
            bean.set("message", "");
            bean.set("requestId", new Long(0L));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initializeKeyValues(ReportBean bean) {
        try {
            Criteria crit = new Criteria(new Column("ADSMInputMappingDetails", "REPORT_ID"), (Object)((Integer)bean.get("reportId")), 0);
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMInputMappingDetails", crit);
            HashMap inputParams = new HashMap();
            if (!dataObj.isEmpty()) {
                Iterator it = dataObj.getRows("ADSMInputMappingDetails");
                while (it.hasNext()) {
                    Row r = (Row)it.next();
                    String keyValue = (String)r.get("KEY_VALUE");
                    inputParams.put(keyValue, new ArrayList());
                }
                bean.set("reportInputParams", inputParams);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setInputParams(HttpServletRequest request, ReportBean bean, String date) {
        HashMap<String, String> inputParams = (HashMap<String, String>)bean.get("inputParams");
        if (inputParams == null) {
            inputParams = new HashMap<String, String>();
        }
        if (date != null) {
            inputParams.put("date", date);
        }
        bean.set("inputParams", inputParams);
    }

    public ActionForward setOusToBean(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            HttpSession session = request.getSession();
            String beanName = request.getParameter("beanName");
            DynaValidatorForm bean = (DynaValidatorForm)session.getAttribute(beanName);
            Hashtable domainOUList = new Hashtable();
            Hashtable domainVsExcludeChildOU = new Hashtable();
            Hashtable excludeOUList = new Hashtable();
            if (bean != null) {
                domainOUList = (Hashtable)bean.get("domainOUList");
                domainVsExcludeChildOU = (Hashtable)bean.get("domainVsExcludeChildOU");
                excludeOUList = (Hashtable)bean.get("excludedOUList");
            }
            String distinguishedName = request.getParameter("distinguishedName");
            String domainName = request.getParameter("domainName");
            String selectedOUsStr = request.getParameter("selectedOus");
            String excludedOusStr = request.getParameter("excludedOus");
            Boolean isExcludeChildOU = new Boolean(request.getParameter("isExcludeChildOU"));
            JSONObject selectedOUsJson = new JSONObject(selectedOUsStr);
            ArrayList<String> list = new ArrayList<String>();
            Hashtable<String, String> objectGuid = new Hashtable<String, String>();
            Iterator itr = selectedOUsJson.keys();
            while (itr.hasNext()) {
                String selectedOUDN = (String)itr.next();
                if (list.contains(selectedOUDN)) continue;
                list.add(selectedOUDN);
                String val = OUUtil.getOUGUIDFromDN((String)selectedOUDN, (String)domainName);
                if (val == null) {
                    val = selectedOUDN;
                }
                objectGuid.put(selectedOUDN, val);
            }
            domainOUList.put(distinguishedName, list);
            if (list.isEmpty()) {
                isExcludeChildOU = Boolean.FALSE;
            }
            JSONObject excludedOusJson = new JSONObject(excludedOusStr);
            ArrayList<String> excludedOUList = new ArrayList<String>();
            itr = excludedOusJson.keys();
            while (itr.hasNext()) {
                String selectedOUDN = (String)itr.next();
                if (excludedOUList.contains(selectedOUDN)) continue;
                excludedOUList.add(selectedOUDN);
            }
            ArrayList<String> excludedDNList = new ArrayList<String>();
            for (String excludedOUDN : excludedOUList) {
                Boolean isParentSelected = Boolean.FALSE;
                for (int i = 0; i < list.size(); ++i) {
                    String selectedOUDN = (String)list.get(i);
                    if (!excludedOUDN.endsWith(selectedOUDN)) continue;
                    isParentSelected = Boolean.TRUE;
                    break;
                }
                if (!isParentSelected.booleanValue()) continue;
                excludedDNList.add(excludedOUDN);
            }
            excludeOUList.put(domainName, excludedDNList);
            domainVsExcludeChildOU.put(domainName, isExcludeChildOU);
            if (beanName.equals("ReportBean") || beanName.equals("ModifyUserBean") || beanName.equals("SchedulerMgmtBean") || beanName.equals("SchedulerBean")) {
                Long sessionloginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
                ReportClientUtil.updateBeanWithOU(bean, sessionloginId, distinguishedName, list.toArray(new String[list.size()]));
            }
            request.setAttribute("selectedOUList", list);
            request.setAttribute("excludedOUList", excludedDNList);
            request.setAttribute("domainName", (Object)domainName);
            request.setAttribute("isExcludeChildOU", (Object)isExcludeChildOU);
            request.setAttribute("defaultNamingContext", (Object)distinguishedName);
            request.setAttribute("beanName", (Object)beanName);
            request.setAttribute("selectedOUObjectGuid", objectGuid);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward("selectedOUsDiv");
    }

    public ActionForward setOus(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            String beanName = request.getParameter("beanName");
            HttpSession session = request.getSession();
            DynaValidatorForm bean = (DynaValidatorForm)session.getAttribute(beanName);
            Hashtable domainOUList = (Hashtable)bean.get("domainOUList");
            String distinguishedName = request.getParameter("distinguishedName");
            String[] selectedOus = request.getParameterValues("selectedOus");
            ArrayList<String> list = (ArrayList<String>)domainOUList.get(distinguishedName);
            if (list == null) {
                list = new ArrayList<String>();
            }
            for (int i = 0; selectedOus != null && i < selectedOus.length; ++i) {
                if (list.contains(selectedOus[i]) || distinguishedName.equalsIgnoreCase(selectedOus[i])) continue;
                list.add(selectedOus[i]);
            }
            domainOUList.put(distinguishedName, list);
            if (selectedOus != null && (beanName.equals("ReportBean") || beanName.equals("ModifyUserBean"))) {
                Long sessionloginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
                ReportClientUtil.updateBeanWithOU(bean, sessionloginId, distinguishedName, selectedOus);
            }
            if (selectedOus != null && beanName.equals("SchedulerBean")) {
                Long sessionloginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
                ArrayList domainList = (ArrayList)bean.get("domainList");
                ReportClientUtil.checkOUWithBeanUpdateOUBaseTable(bean, sessionloginId, distinguishedName, selectedOus);
                System.out.println("Report action ou sync completes ");
            }
            request.setAttribute("setOU", (Object)"Success");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward("viewOUPage");
    }

    public ActionForward addOus(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            String beanName = request.getParameter("beanName");
            HttpSession session = request.getSession();
            DynaValidatorForm bean = (DynaValidatorForm)session.getAttribute(beanName);
            Hashtable domainOUList = (Hashtable)bean.get("domainOUList");
            String distinguishedName = request.getParameter("distinguishedName");
            String selectedOus = request.getParameter("selectedOus");
            String[] OUobjectsArray = selectedOus.split(";;;");
            ArrayList<String> list = (ArrayList<String>)domainOUList.get(distinguishedName);
            if (list == null) {
                list = new ArrayList<String>();
            }
            for (int i = 0; OUobjectsArray != null && i < OUobjectsArray.length; ++i) {
                if (list.contains(OUobjectsArray[i]) || distinguishedName.equalsIgnoreCase(OUobjectsArray[i])) continue;
                list.add(OUobjectsArray[i]);
            }
            domainOUList.put(distinguishedName, list);
            if (OUobjectsArray != null && (beanName.equals("ReportBean") || beanName.equals("ModifyUserBean"))) {
                Long sessionloginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
                ReportClientUtil.updateBeanWithOU(bean, sessionloginId, distinguishedName, OUobjectsArray);
            }
            bean.set("domainOUList", (Object)domainOUList);
            ClientUtil.setStatusXMLElement(response, "Success", "OU Added");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward removeOusFromBean(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            String beanName = request.getParameter("beanName");
            HttpSession session = request.getSession();
            DynaValidatorForm bean = (DynaValidatorForm)session.getAttribute(beanName);
            Hashtable domainOUList = new Hashtable();
            Hashtable domainVsExcludeChildOU = new Hashtable();
            Hashtable excludeOUList = new Hashtable();
            if (bean != null) {
                domainOUList = (Hashtable)bean.get("domainOUList");
                domainVsExcludeChildOU = (Hashtable)bean.get("domainVsExcludeChildOU");
                excludeOUList = (Hashtable)bean.get("excludedOUList");
            }
            String distinguishedName = request.getParameter("distinguishedName");
            String toBeRemovedOu = request.getParameter("toBeRemovedOu");
            String isExcludeChildOU = request.getParameter("isExcludeChildOU");
            String domainName = DomainUtil.getDomainName((String)distinguishedName);
            if (isExcludeChildOU != null) {
                domainVsExcludeChildOU.put(DomainUtil.getDomainName((String)distinguishedName), new Boolean(isExcludeChildOU));
            }
            if (toBeRemovedOu != null) {
                ArrayList list = (ArrayList)domainOUList.get(distinguishedName);
                ArrayList<String> excludedList = (ArrayList<String>)excludeOUList.get(domainName);
                if (list == null) {
                    list = new ArrayList();
                }
                if (excludedList == null) {
                    excludedList = new ArrayList<String>();
                }
                for (int j = 0; j < list.size(); ++j) {
                    String s = (String)list.get(j);
                    if (!s.equalsIgnoreCase(toBeRemovedOu)) continue;
                    list.remove(s);
                    excludedList.add(s);
                }
                if (list.isEmpty()) {
                    domainVsExcludeChildOU.put(DomainUtil.getDomainName((String)distinguishedName), Boolean.FALSE);
                    excludeOUList.put(DomainUtil.getDomainName((String)distinguishedName), new ArrayList());
                }
                domainOUList.put(distinguishedName, list);
                if (bean != null) {
                    bean.set("domainOUList", (Object)domainOUList);
                    bean.set("excludedOUList", (Object)excludeOUList);
                }
                ClientUtil.setStatusXMLElement(response, "Success", "Removed OU");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward removeOus(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            String beanName = request.getParameter("beanName");
            HttpSession session = request.getSession();
            DynaValidatorForm bean = (DynaValidatorForm)session.getAttribute(beanName);
            Hashtable domainOUList = (Hashtable)bean.get("domainOUList");
            String distinguishedName = request.getParameter("distinguishedName");
            String toBeRemovedOu = request.getParameter("toBeRemovedOu");
            ArrayList list = (ArrayList)domainOUList.get(distinguishedName);
            if (list == null) {
                list = new ArrayList();
            }
            for (int j = 0; j < list.size(); ++j) {
                String s = (String)list.get(j);
                if (!s.equalsIgnoreCase(toBeRemovedOu)) continue;
                list.remove(s);
            }
            domainOUList.put(distinguishedName, list);
            bean.set("domainOUList", (Object)domainOUList);
            ClientUtil.setStatusXMLElement(response, "Success", "Removed OU");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward setObjects(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String forwardPage = request.getParameter("page");
        ListenerUtil.setObjects(request);
        return mapping.findForward(forwardPage);
    }

    public ActionForward setObjectsFromPopup(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        block4: {
            PrintWriter writer = null;
            try {
                String params = request.getParameter("params");
                JSONObject json = new JSONObject(params);
                String beanName = json.getString("beanName");
                String varInBean = json.getString("varInBean");
                JSONArray values = json.getJSONArray("values");
                HttpSession session = request.getSession();
                DynaValidatorForm bean = (DynaValidatorForm)session.getAttribute(beanName);
                ArrayList<String> valOfVarInBean = (ArrayList<String>)bean.get(varInBean);
                valOfVarInBean = new ArrayList<String>();
                for (int i = 0; i < values.length(); ++i) {
                    if (valOfVarInBean.contains(values.getString(i)) || values.getString(i) == null) continue;
                    valOfVarInBean.add(values.getString(i));
                }
                bean.set(varInBean, valOfVarInBean);
                if (json.has("selectedDomain")) {
                    String domainName = json.getString("selectedDomain");
                    bean.set("selectedDomain", (Object)domainName);
                }
                JSONArray jsonArray = new JSONArray(valOfVarInBean);
                JSONObject jsonObj = new JSONObject();
                jsonObj.put("result", (Object)"success");
                jsonObj.put("values", (Object)jsonArray);
                response.setContentType("application/json");
                writer = response.getWriter();
                writer.print(jsonObj.toString());
            }
            catch (Exception e) {
                System.out.println("Error Occured in setObjectsFromPopup!");
                e.printStackTrace();
                if (writer == null) break block4;
                writer.close();
            }
        }
        return null;
    }

    public ActionForward removeObjects(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ListenerUtil.removeObjects(request);
        return null;
    }

    public ActionForward removeObjectsFromPopup(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        block5: {
            PrintWriter writer = null;
            try {
                String params = request.getParameter("params");
                JSONObject json = new JSONObject(params);
                String beanName = json.getString("beanName");
                String varInBean = json.getString("varInBean");
                String groupSid = json.getString("objectSid");
                boolean isRemoveAll = json.getBoolean("isRemoveAll");
                HttpSession session = request.getSession();
                DynaValidatorForm bean = (DynaValidatorForm)session.getAttribute(beanName);
                ArrayList valOfVarInBean = (ArrayList)bean.get(varInBean);
                if (valOfVarInBean == null) {
                    valOfVarInBean = new ArrayList();
                }
                if (isRemoveAll) {
                    valOfVarInBean.clear();
                } else {
                    valOfVarInBean.remove(groupSid);
                }
                JSONObject jsonObj = new JSONObject();
                jsonObj.put("result", (Object)"success");
                response.setContentType("application/json");
                writer = response.getWriter();
                writer.print(jsonObj.toString());
            }
            catch (Exception e) {
                System.out.println("Error Occured in setObjectsFromPopup!");
                e.printStackTrace();
                if (writer == null) break block5;
                writer.close();
            }
        }
        return null;
    }

    public ActionForward AdvancedFilter(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        block25: {
            ArrayList usersList = new ArrayList();
            ArrayList usersDN = new ArrayList();
            ArrayList<String> checkedDN = new ArrayList<String>();
            Hashtable dnToFullName = new Hashtable();
            PrintWriter writer = null;
            DynaValidatorForm bean = (DynaValidatorForm)form;
            String dnValueJson = request.getParameter("dnValueJson");
            String popupId = null;
            if (request.getParameter("popupId") != null) {
                popupId = request.getParameter("popupId");
            }
            try {
                if (dnValueJson != null) {
                    JSONObject dnAndNameJson = new JSONObject(dnValueJson);
                    String domainName = request.getParameter("domainName");
                    String defaultNamingContext = request.getParameter("defaultNamingContext");
                    String objectClasses = request.getParameter("objectClasses");
                    String chNames = request.getParameter("chNames");
                    if (objectClasses != null && chNames != null) {
                        StringTokenizer objClassSt = new StringTokenizer(objectClasses, ",");
                        StringTokenizer chNamesSt = new StringTokenizer(chNames, ",");
                        while (objClassSt.hasMoreTokens()) {
                            String objectClass = objClassSt.nextToken();
                            String chName = chNamesSt.nextToken();
                            JSONObject dnList = (JSONObject)dnAndNameJson.get(chName + "_selectedObjects");
                            if (popupId != null) {
                                ArrayList<String> objectList = new ArrayList<String>();
                                Hashtable objectDetailsList = new Hashtable();
                                ArrayList objectDN = new ArrayList();
                                ArrayList objectName = new ArrayList();
                                Iterator it = dnList.keys();
                                while (it.hasNext()) {
                                    String guid = (String)it.next();
                                    String fullName = (String)dnList.get(guid);
                                    checkedDN.add(guid);
                                    if (objectClass.equalsIgnoreCase("organizationalUnit")) {
                                        guid = OUUtil.getOUDNFromGUID((String)guid);
                                    }
                                    if (guid != null && !guid.equalsIgnoreCase("null")) {
                                        objectList.add(guid);
                                        continue;
                                    }
                                    if (!DomainUtil.getDomainNamefromDN((String)fullName).equalsIgnoreCase(domainName)) continue;
                                    objectList.add(fullName);
                                }
                                if (objectClass.equalsIgnoreCase("User")) {
                                    objectDetailsList = UserHandler.getUserDNFromGuid(objectList);
                                } else if (objectClass.equalsIgnoreCase("organizationalUnit")) {
                                    Boolean isExcludeChildOU = Boolean.valueOf(request.getParameter("isExcludeChildOU"));
                                    objectDetailsList = OUHandler.getChildObjects((String)"User", objectList, (Boolean)isExcludeChildOU);
                                } else if (objectClass.equalsIgnoreCase("group")) {
                                    objectDetailsList = GroupHandler.getChildObjects((String)"User", objectList);
                                }
                                if (objectDetailsList.isEmpty()) continue;
                                objectDN = (ArrayList)objectDetailsList.get("DISTINGUISHED_NAME");
                                objectName = (ArrayList)objectDetailsList.get("FULL_NAME");
                                for (int i = 0; i < objectDN.size(); ++i) {
                                    if (usersDN.contains(objectDN.get(i))) continue;
                                    usersDN.add(objectDN.get(i));
                                    usersList.add(objectName.get(i));
                                    dnToFullName.put(objectDN.get(i), objectName.get(i));
                                }
                                continue;
                            }
                            Iterator iterator = dnList.keys();
                            while (iterator.hasNext()) {
                                String distinguishedName = (String)iterator.next();
                                String fullUserName = (String)dnList.get(distinguishedName);
                                checkedDN.add(distinguishedName);
                                if (objectClass.equalsIgnoreCase("User")) {
                                    usersList.add(fullUserName);
                                    usersDN.add(distinguishedName);
                                    continue;
                                }
                                Hashtable objectsList = new Hashtable();
                                ArrayList objectDN = new ArrayList();
                                ArrayList objectName = new ArrayList();
                                if (objectClass.equalsIgnoreCase("Group")) {
                                    objectsList = GroupHandler.getChildObjects((String)"User", (String)distinguishedName);
                                } else if (objectClass.equalsIgnoreCase("organizationalUnit")) {
                                    objectsList = OUHandler.getChildObjects((String)"User", (String)distinguishedName);
                                }
                                objectDN = (ArrayList)objectsList.get("DISTINGUISHED_NAME");
                                objectName = (ArrayList)objectsList.get("FULL_NAME");
                                for (int i = 0; i < objectDN.size(); ++i) {
                                    if (usersDN.contains(objectDN.get(i))) continue;
                                    usersDN.add(objectDN.get(i));
                                    usersList.add(objectName.get(i));
                                }
                            }
                        }
                    }
                }
                bean.set("USERSLIST", usersList);
                bean.set("USERSDN", usersDN);
                bean.set("CHECKEDDN", checkedDN);
                bean.set("VIEWLIST", (Object)"true");
                response.setContentType("text/html");
                writer = response.getWriter();
                if (popupId != null) {
                    JSONObject json = new JSONObject();
                    if (dnToFullName.size() > 0) {
                        json = new JSONObject(dnToFullName);
                    }
                    writer.print(usersList.size());
                    request.setAttribute("selectedObjects", (Object)json);
                    request.setAttribute("popupIdAvailable", (Object)true);
                    return mapping.findForward("summaryView");
                }
                String forward = "AdvancedFilter";
                for (int index = 0; index < usersList.size(); ++index) {
                    String objName = (String)usersList.get(index);
                    writer.print("<tr class=\"" + (index % 2 == 0 ? "rowtable1" : "rowtable2") + "\" height=\"20\"><td width=\"5%\"><img src=\"images/user_ad.gif\" align=\"absmiddle\" height=\"18\" width=\"18\" /></td><td width=\"45%\" class=\"blacktxt\" id=\"name_" + index + "\">" + ClientUtil.htmlEscape(objName) + "</td></tr>");
                }
                writer.close();
            }
            catch (Exception e) {
                System.out.println("Error Occured !");
                e.printStackTrace();
                if (writer == null) break block25;
                writer.close();
            }
        }
        return null;
    }

    public ActionForward updateInputDetailsPreference(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            Integer reportId = Integer.parseInt(request.getParameter("reportId"));
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            boolean showInputDetails = Boolean.parseBoolean(request.getParameter("isPinned"));
            BulkModificationAPI.updateConfigForHDT(loginId, "REPORT_SHOW_INPUT_DETAIL", showInputDetails);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward validateServerPath(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            PrintWriter writer = null;
            String domainName = request.getParameter("domainName");
            String dN = DomainUtil.getDomainName((String)domainName);
            String path = request.getParameter("path");
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            JSONObject jsonObj = new JSONObject();
            ArrayList authOUList = HelpdeskUtil.getOUList((String)dN, (Long)loginId);
            if (!authOUList.isEmpty()) {
                DataObject dataObj;
                String computer = path.substring(path.indexOf("\\\\") + 2);
                if (computer.contains("\\")) {
                    computer = computer.substring(0, computer.indexOf("\\"));
                }
                if (computer.contains(".")) {
                    computer = computer.substring(0, computer.indexOf("."));
                }
                Criteria ouCrit = null;
                for (int i = 0; i < authOUList.size(); ++i) {
                    String ouDN = (String)authOUList.get(i);
                    Criteria crite = new Criteria(Column.getColumn((String)"ADSMComputerGeneralDetails", (String)"DISTINGUISHED_NAME"), (Object)ouDN, 11);
                    ouCrit = ouCrit == null ? crite : ouCrit.or(crite);
                }
                Criteria crit = new Criteria(Column.getColumn((String)"ADSMComputerGeneralDetails", (String)"COMPUTER_NAME"), (Object)computer, 0, false);
                if (ouCrit != null) {
                    crit = crit.and(ouCrit.negate());
                }
                if ((dataObj = ComputerMgmtHandler.getComputerListDO((String)domainName, (int)-1, (int)0, (Criteria)crit)).isEmpty()) {
                    jsonObj.put("result", true);
                } else {
                    jsonObj.put("result", false);
                }
            } else {
                jsonObj.put("result", true);
            }
            response.setContentType("application/json");
            writer = response.getWriter();
            writer.print(jsonObj.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward isValidServerPath(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            PrintWriter writer = null;
            JSONObject jsonObj = new JSONObject();
            String path = request.getParameter("path");
            String isForManagement = request.getParameter("isForManagement");
            String isWorkFlowMode = request.getParameter("isWorkFlowMode");
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            String computer = path.substring(path.indexOf("\\\\") + 2);
            if (computer.indexOf("\\") != -1) {
                computer = computer.substring(0, computer.indexOf("\\"));
            }
            if (computer.contains(".")) {
                computer = computer.substring(0, computer.indexOf("."));
            }
            if (loginId.compareTo(CommonUtil.ADMIN_LOGIN_ID) != 0 && isForManagement.equalsIgnoreCase("true")) {
                Hashtable fileServerListHash = null;
                fileServerListHash = isWorkFlowMode.equalsIgnoreCase("true") ? HelpdeskUtil.getFileServersList((Long)loginId, (String)"ADMPRequesterAllfileserverMap", (String)"ADMPRequestersFileServerMap", (String)"LOGIN_ID", (String)"Requester") : HelpdeskUtil.getFileServersList((Long)loginId, (String)"ADMPUserAllfileserverMap", (String)"ADMPUsersFileServerMap", (String)"LOGIN_ID");
                Boolean isAllSelected = (Boolean)fileServerListHash.get("isAllSelected");
                if (isAllSelected.booleanValue()) {
                    jsonObj.put("result", true);
                } else {
                    Boolean isValidFileServer = false;
                    ArrayList fileServerList = (ArrayList)fileServerListHash.get("fileServerList");
                    for (Properties fsProp : fileServerList) {
                        String fsName = (String)fsProp.get("NAME");
                        if (!computer.equalsIgnoreCase(fsName)) continue;
                        isValidFileServer = true;
                        break;
                    }
                    jsonObj.put("result", (Object)isValidFileServer);
                }
            } else if (loginId != CommonUtil.ADMIN_LOGIN_ID && ComputerMgmtHandler.isComputer((String)computer).booleanValue()) {
                ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
                ArrayList configuredDomains = authObject.getDomainNameList();
                Hashtable domainOUsMap = authObject.getDomainOUsMap();
                Hashtable domainVsDefaultNamingContext = DomainInfoCache.getInstance().getDomainVsDefaultNamingContext();
                for (int j = 0; j < configuredDomains.size(); ++j) {
                    String defaultNamingContext;
                    DataObject dataObj;
                    String domainName = (String)configuredDomains.get(j);
                    ArrayList authOUList = (ArrayList)domainOUsMap.get(domainName);
                    Criteria ouCrit = null;
                    if (!authOUList.isEmpty()) {
                        for (int i = 0; i < authOUList.size(); ++i) {
                            String ouDN = (String)authOUList.get(i);
                            Criteria crite = new Criteria(Column.getColumn((String)"ADSMComputerGeneralDetails", (String)"DISTINGUISHED_NAME"), (Object)ouDN, 11);
                            ouCrit = ouCrit == null ? crite : ouCrit.or(crite);
                        }
                    }
                    Criteria crit = new Criteria(Column.getColumn((String)"ADSMComputerGeneralDetails", (String)"COMPUTER_NAME"), (Object)computer, 0);
                    crit = crit.and(new Criteria(Column.getColumn((String)"ADSMComputerGeneralDetails", (String)"DOMAIN_NAME"), (Object)domainName, 0));
                    if (ouCrit != null) {
                        crit = crit.and(ouCrit);
                    }
                    if (!(dataObj = ComputerMgmtHandler.getComputerListDO((String)(defaultNamingContext = (String)domainVsDefaultNamingContext.get(domainName)), (int)-1, (int)0, (Criteria)crit)).isEmpty()) {
                        jsonObj.put("result", true);
                        break;
                    }
                    jsonObj.put("result", false);
                }
            } else {
                jsonObj.put("result", true);
            }
            response.setContentType("application/json");
            writer = response.getWriter();
            writer.print(jsonObj.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward getReportDateRangeMap(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        try {
            Integer reportId = Integer.parseInt(request.getParameter("reportId"));
            JSONObject criteriaJsonArray = DateRangePickerHandler.getInstance().getReportCriteriaMap(reportId, rb);
            PrintWriter writer = response.getWriter();
            writer.print(criteriaJsonArray);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward isCustomReportDelegated(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        try {
            JSONObject jsonObj = new JSONObject();
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
            String reportId = request.getParameter("reportId") != null ? request.getParameter("reportId") : "0";
            Row reportRow = ReportHandler.getReportDetailsRow((Integer)Integer.parseInt(reportId));
            jsonObj.put("statusType", (Object)"success");
            jsonObj.put("reportId", (Object)reportId);
            if (!reportId.equalsIgnoreCase("0") && !loginId.equals(1L)) {
                String reportName = rb.getString((String)reportRow.get("REPORT_NAME"));
                Long createdBy = CustomReportUtil.getCreatedBy((Integer)Integer.parseInt(reportId), (AdventNetResourceBundle)rb);
                if (!loginId.equals(createdBy)) {
                    jsonObj.put("status", (Object)MessageFormat.format(rb.getString("admp.reports.custom_reports.custom_report_mgmt_status.permission_not_delegated_to_this_action"), reportName));
                    jsonObj.put("statusType", (Object)"error");
                    jsonObj.put("reportId", (Object)reportId);
                }
            }
            response.setContentType("application/json");
            PrintWriter writer = response.getWriter();
            writer.print(jsonObj.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward customReport(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        try {
            if (!ClientAuthorizationUtil.isAuthorized(request, 32101L).booleanValue()) {
                return mapping.findForward("accessDenied");
            }
            JSONObject jsonObj = new JSONObject();
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
            String reportId = request.getParameter("reportId") != null ? request.getParameter("reportId") : "0";
            Row reportRow = ReportHandler.getReportDetailsRow((Integer)Integer.parseInt(reportId));
            request.setAttribute("reportId", (Object)reportId);
            String action = request.getParameter("action");
            if (action != null && action.equalsIgnoreCase("delete")) {
                String reportName = ClientUtil.htmlEscape(rb.getString((String)reportRow.get("REPORT_NAME")));
                Long createdBy = CustomReportUtil.getCreatedBy((Integer)Integer.parseInt(reportId), (AdventNetResourceBundle)rb);
                if (!loginId.equals(1L) && !loginId.equals(createdBy)) {
                    jsonObj.put("status", (Object)MessageFormat.format(rb.getString("admp.reports.custom_reports.custom_report_mgmt_status.permission_not_delegated_to_this_action"), reportName));
                    jsonObj.put("statusType", (Object)"error");
                    jsonObj.put("reportId", (Object)reportId);
                } else {
                    String status = CustomReportHandler.deleteCustomReportDetails((Integer)Integer.parseInt(reportId));
                    jsonObj.put("status", (Object)MessageFormat.format(rb.getString(status), reportName));
                    jsonObj.put("statusType", (Object)"success");
                    jsonObj.put("reportId", (Object)reportId);
                }
                response.setContentType("application/json");
                PrintWriter writer = response.getWriter();
                writer.print(jsonObj.toString());
                return null;
            }
            request.setAttribute("action", (Object)action);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward("customReport");
    }

    public ActionForward runReport(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        if (!ClientAuthorizationUtil.isAuthorized(request, 32101L).booleanValue()) {
            return mapping.findForward("accessDenied");
        }
        String reportId = request.getParameter("reportId");
        request.setAttribute("reportId", (Object)reportId);
        request.setAttribute("categoryId", (Object)request.getParameter("categoryId"));
        request.setAttribute("action", (Object)"generate");
        String isGenerate = "false";
        String isFullScreenView = "false";
        String forwardPage = "customReport";
        if (request.getParameter("isGenerate") != null) {
            isGenerate = request.getParameter("isGenerate");
            if (isGenerate.equalsIgnoreCase("true")) {
                request.setAttribute("isGenerate", (Object)true);
            } else {
                request.setAttribute("isGenerate", (Object)false);
            }
        } else {
            request.setAttribute("isGenerate", (Object)false);
        }
        if (request.getParameter("isFullScreenView") != null) {
            isFullScreenView = request.getParameter("isFullScreenView");
            if (isFullScreenView.equalsIgnoreCase("true")) {
                request.setAttribute("isFullScreenView", (Object)true);
                forwardPage = "customReportFullScreenView";
            } else {
                request.setAttribute("isFullScreenView", (Object)false);
            }
        } else {
            request.setAttribute("isFullScreenView", (Object)false);
        }
        return mapping.findForward(forwardPage);
    }

    public void saveViewColumns(HttpServletRequest request, HttpServletResponse response) {
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            String reportIdStr = request.getParameter("reportId");
            Integer reportId = Integer.parseInt(reportIdStr);
            Integer objectId = 0;
            if (request.getParameter("objectId") != null) {
                objectId = Integer.parseInt(request.getParameter("objectId"));
            }
            JSONArray cols = new JSONArray(request.getParameter("cols"));
            ArrayList<Properties> subList = new ArrayList<Properties>();
            int i = 0;
            while (i < cols.length()) {
                Properties properties = new Properties();
                Integer attributeId = new Integer(cols.getInt(i));
                properties.put("ATTRIB_ID", attributeId);
                properties.put("PRIORITY_ID", new Integer(++i));
                subList.add(properties);
            }
            ReportAttributeHandler.getInstance().saveColumns(reportId, subList, loginId, objectId);
            JSONObject jsonObj = new JSONObject();
            response.setContentType("application/json");
            PrintWriter out = response.getWriter();
            out.println(jsonObj.toString());
            out.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ActionForward exportCustomReport(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            Integer reportId = Integer.parseInt(request.getParameter("reportId"));
            Long generationId = Long.parseLong(request.getParameter("generationId"));
            String exportType = request.getParameter("exportType");
            JSONObject params = new JSONObject(request.getParameter("params"));
            Locale locale = I18NUtil.getDefaultLocale((HttpServletRequest)request);
            ArrayList tabList = CustomReportResultUtil.getTabList(reportId, rb);
            ArrayList domainList = ListenerUtil.getDomainList(generationId);
            String domainStr = "";
            for (int i = 0; i < domainList.size(); ++i) {
                domainStr = i == 0 ? (String)domainList.get(i) : domainStr + "," + (String)domainList.get(i);
            }
            HashMap<String, String> jrParameterMap = new HashMap<String, String>();
            DataObject reportDO = ReportHandler.getReportDetails((Integer)reportId);
            Row row = reportDO.getFirstRow("ADSMReports");
            jrParameterMap.put("REPORT_NAME", rb.getString((String)row.get("REPORT_NAME")));
            String description = rb.getString((String)row.get("DESCRIPTION"));
            jrParameterMap.put("DESCRIPTION", description);
            jrParameterMap.put("DOMAIN_NAME", domainStr);
            jrParameterMap.put("DOMAIN_NAME_TEXT", rb.getString("admp.common.attrib_disp_name.dn_domain_name"));
            jrParameterMap.put("DESCRIPTION_TEXT", rb.getString("admp.common.attrib_disp_name.desc"));
            jrParameterMap.put("CREATION_TIME_TEXT", rb.getString("admp.reports.common.reportresult.generated_date_time"));
            Row r = ReportHandler.getGeneratedReportDetails((Long)generationId, (Long)loginId);
            Long time = (Long)r.get("CREATION_TIME");
            jrParameterMap.put("CREATION_TIME", DateTimeUtil.getDateFormat((Long)loginId).format(new Date(time)));
            String defDesc = MessageFormat.format(rb.getString("admp.reports.common.text.report_generated_for_the_domains"), domainStr);
            String exportDesc = (String)r.get("DESCRIPTION");
            if (description.equalsIgnoreCase("") || !defDesc.equalsIgnoreCase(exportDesc)) {
                jrParameterMap.put("DESCRIPTION", (String)r.get("DESCRIPTION"));
            }
            Hashtable<String, Object> reqParams = new Hashtable<String, Object>();
            reqParams.put("reportId", reportId);
            reqParams.put("generationId", generationId);
            reqParams.put("loginId", loginId);
            reqParams.put("rb", rb);
            reqParams.put("locale", locale);
            reqParams.put("reportFileName", (String)row.get("REPORT_FILE_NAME"));
            reqParams.put("REPORT_NAME", rb.getString((String)row.get("REPORT_NAME")));
            String storageDir = System.getProperty("server.home") + File.separator + "temp" + File.separator + "export" + File.separator + loginId;
            File dir = new File(storageDir);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            HashMap<String, Integer> exportResult = new HashMap<String, Integer>();
            exportResult.put("exportCount", 0);
            String exportFileName = "ADMPReport.pdf";
            response.setHeader("Cache-Control", "public");
            if (tabList.size() > 1) {
                if (exportType.equalsIgnoreCase("pdf")) {
                    ReportPdfExporter pdfExporter = new ReportPdfExporter();
                    pdfExporter.init(jrParameterMap, rb);
                    pdfExporter.setLocale(locale);
                    pdfExporter.exportReport(response, tabList, reqParams, params, storageDir);
                    exportResult.put("exportCount", pdfExporter.getExportRowCount());
                } else {
                    exportFileName = "ADMPReport." + exportType;
                    ReportExportUtil.exportAllConfig(tabList, reqParams, params, jrParameterMap, request, response, storageDir, exportType, rb, false, exportResult);
                }
            } else if (exportType.equalsIgnoreCase("pdf")) {
                ReportPdfExporter pdfExporter = new ReportPdfExporter();
                pdfExporter.init(jrParameterMap, rb);
                pdfExporter.setLocale(locale);
                pdfExporter.exportReport(response, tabList, reqParams, params, storageDir);
                exportResult.put("exportCount", pdfExporter.getExportRowCount());
            } else {
                exportFileName = "ADMPReport." + exportType;
                ReportExportUtil.exportConfig((Hashtable)tabList.get(0), reqParams, params, jrParameterMap, request, response, exportType, storageDir, rb, false, exportResult);
            }
            if (PrivacyHandler.getInstance().isExportAuditEnabled().booleanValue()) {
                DataImportExportAudit.auditDataFlow((Long)System.currentTimeMillis(), (Long)loginId, (String)HelpdeskUtil.getLoginUserName((Long)loginId), (String)request.getRemoteAddr(), (String)"admp.deleg.hdt_deleg.cre_role.action_name.ad_reports", (String)((String)row.get("REPORT_NAME")), (Integer)reportId, (String)"-", (Boolean)Boolean.FALSE, (String)exportFileName, (String)exportType.toLowerCase(), (String)"-", (Integer)((Integer)exportResult.get("exportCount")));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward getUserPhotoForReports(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            String photo;
            String fileName = request.getParameter("fileName");
            String hexValOfImage = "";
            if (fileName != null && (hexValOfImage = ModifyPhotoListener.getPhotoFileAsHexForReport(photo = System.getProperty("user.dir") + "\\" + fileName)) != null && !hexValOfImage.equals("")) {
                byte[] byteArrOfImg = UserPhotoMgmtUtil.convertHexToByteArray((String)hexValOfImage);
                String contentType = ModifyPhotoListener.getContentType(hexValOfImage);
                response.setContentType(contentType);
                response.getOutputStream().write(byteArrOfImg);
            }
            if (hexValOfImage == null || hexValOfImage.equals("")) {
                response.sendRedirect("images/avatar.png");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public ActionForward runTestScheduler(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DashboardReportUtil.runDailyReport();
        response.getWriter().write("Started");
        return null;
    }

    public ActionForward addReportToDashboard(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
            ArrayList configuredDomains = authObject.getDomainNameList();
            ReportBean bean = (ReportBean)form;
            Hashtable<String, Object> hash = new Hashtable<String, Object>();
            hash.put("LOGIN_ID", loginId);
            hash.put("rb", rb);
            hash.put("session", session);
            hash.put("DEFAULT_DOMAIN", configuredDomains.get(0));
            hash.put("REPORT_ID", bean.get("reportId"));
            hash.put("domainNames", request.getParameterValues("domains"));
            hash.put("domainOUList", bean.get("domainOUList"));
            hash.put("excludedOUList", bean.get("excludedOUList"));
            hash.put("domainVsExcludeChildOU", bean.get("domainVsExcludeChildOU"));
            hash.put("containerParams", new JSONObject(request.getParameter("containerParams")));
            hash.put("reportInputs", new JSONArray(request.getParameter("reportInputs")));
            String result = DashboardUtil.addReportToDashboard(hash);
            response.getWriter().write(result);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }
}

