/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.reports;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.AdmpInput;
import com.adventnet.sym.adsm.common.server.audit.DataImportExportAudit;
import com.adventnet.sym.adsm.common.server.automation.ReportFilterConfig;
import com.adventnet.sym.adsm.common.server.cvc.CVCDataUtil;
import com.adventnet.sym.adsm.common.server.cvc.CVCUtil;
import com.adventnet.sym.adsm.common.server.delegation.DelegationUtil;
import com.adventnet.sym.adsm.common.server.delegation.O365DelegationUtil;
import com.adventnet.sym.adsm.common.server.framework.EscapeUtil;
import com.adventnet.sym.adsm.common.server.helpdesk.ADMPAuthObject;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.reports.ReportAttributeHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportReqParams;
import com.adventnet.sym.adsm.common.server.reports.ReportTask;
import com.adventnet.sym.adsm.common.server.resultview.RVHandler;
import com.adventnet.sym.adsm.common.server.resultview.RVReqParams;
import com.adventnet.sym.adsm.common.server.resultview.SelectionTableModel;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.HelpdeskUtil;
import com.adventnet.sym.adsm.common.server.util.I18NUtil;
import com.adventnet.sym.adsm.common.server.util.PasswordUtil;
import com.adventnet.sym.adsm.common.server.util.ReportAttributesUtil;
import com.adventnet.sym.adsm.common.server.util.SchedulerUtil;
import com.adventnet.sym.adsm.common.webclient.export.JRCustomTableDataSource;
import com.adventnet.sym.adsm.common.webclient.export.JasperDesignUtil;
import com.adventnet.sym.adsm.common.webclient.reports.AbstractListener;
import com.adventnet.sym.adsm.common.webclient.reports.JRArrayList;
import com.adventnet.sym.adsm.common.webclient.reports.JRDesignUtil;
import com.adventnet.sym.adsm.common.webclient.reports.JRFieldDesignUtil;
import com.adventnet.sym.adsm.common.webclient.reports.ListenerUtil;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.reports.ReportExportInputUtil;
import com.adventnet.sym.adsm.common.webclient.reports.ReportJRDataSource;
import com.adventnet.sym.adsm.common.webclient.reports.ReportResultUtil;
import com.adventnet.sym.adsm.common.webclient.reports.SubReportJRDataSource;
import com.adventnet.sym.adsm.common.webclient.reports.ZipUtility;
import com.adventnet.sym.adsm.common.webclient.reports.customreport.CustomReportResultUtil;
import com.adventnet.sym.adsm.common.webclient.usermanagement.ListUserDataProvider;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import com.adventnet.sym.adsm.common.webclient.util.ReportClientUtil;
import com.adventnet.sym.adsm.security.server.util.DateTimeUtil;
import com.adventnet.sym.adsm.security.webclient.jreport.ReportExporter;
import com.manageengine.ads.fw.privacy.PrivacyHandler;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.TreeMap;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRReportFont;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignParameter;
import net.sf.jasperreports.engine.design.JRDesignReportFont;
import net.sf.jasperreports.engine.design.JRDesignSection;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.fill.JRSwapFileVirtualizer;
import net.sf.jasperreports.engine.util.JRSaver;
import net.sf.jasperreports.engine.util.JRSwapFile;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import org.apache.commons.codec.binary.Base64;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ReportExportUtil {
    static Logger reportLogger = Logger.getLogger("ReportLogger");
    public static int STARTING_SERIAL_NUMBER = 1;
    private static int XLSX_SHEETNAME_MAX_LENGTH = 31;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean exportReport(Row reportDetails, String reportType, Map inputParams, String reportList, Long schedule_id, String dir, AbstractListener listener, int reportId, ReportFilterConfig rfConfig, Long loginId) {
        JRDesignExpression express;
        Hashtable columnWidths;
        Integer widthValue;
        int noOfObjToFetch;
        int exportPerRowCount;
        Locale locale = listener.getLocale();
        if (locale == null) {
            locale = I18NUtil.getDefaultLocale((Long)loginId);
        }
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getResourceBundle(locale);
        String reportFileName = (String)reportDetails.get("REPORT_FILE_NAME");
        String reportName = (String)reportDetails.get("REPORT_NAME");
        String productHome = System.getProperty("product.home");
        String tempJRReportFileName = null;
        int addPageCount = 0;
        boolean isInline = ReportExportUtil.checkIsInline(schedule_id);
        int exportCount = 0;
        if (productHome == null) {
            productHome = System.getProperty("server.home");
        }
        String basepath = productHome + File.separator + "bin" + File.separator + ".." + File.separator + "webapps" + File.separator + "adsm" + File.separator;
        String reportFilePath = basepath + "jasperreports" + File.separator + "jrxml" + File.separator + reportFileName;
        reportFileName = basepath + "jasperreports" + File.separator + "jrxml" + File.separator + reportFileName;
        String tmpJRReportFilePrefix = productHome + File.separator + "temp" + File.separator + "jaspertemp" + File.separator + schedule_id + "_" + new Random().nextInt(1000) + "_";
        File file = new File(productHome + File.separator + "temp" + File.separator + "jaspertemp");
        file.mkdirs();
        ArrayList attributelist = rfConfig.getSelectedColumnsPropList();
        Properties sortColumnProp = rfConfig.getSortColumnProp();
        Integer attributeId = -1;
        String ascending = "true";
        if (!sortColumnProp.isEmpty()) {
            attributeId = (Integer)sortColumnProp.get("columnID");
            if (((String)sortColumnProp.get("sortBy")).equalsIgnoreCase("dsc")) {
                ascending = "false";
            }
        }
        Properties attributeProp = ListenerUtil.getAttributeProp(attributeId, attributelist);
        Hashtable multipleValuesSids = new Hashtable();
        ArrayList reportFilterTableNames = new ArrayList();
        Object reportFilterCrit = null;
        Criteria reportColumnCrit = null;
        Criteria reportResultCrit = null;
        reportFilterCrit = listener.getScheduledReportFilterCriteria((Criteria)reportFilterCrit, rfConfig, reportFilterTableNames);
        reportColumnCrit = rfConfig.getColumnFilterCriteria(reportFilterTableNames, "", loginId, Integer.valueOf(reportId), reportDetails, listener.generationId, rb);
        reportFilterCrit = reportFilterCrit == null ? (reportColumnCrit != null ? reportColumnCrit : null) : (reportColumnCrit != null ? reportFilterCrit.and(reportColumnCrit) : reportFilterCrit);
        ArrayList list = new ArrayList();
        JasperDesign jasperDesign = JRXmlLoader.load((String)reportFileName);
        jasperDesign.setName(JRFieldDesignUtil.getReportName(reportName, rb));
        if (reportList.equals("true")) {
            inputParams.put("title", rb.getString(listener.title));
        } else {
            inputParams.put("title", " ");
        }
        inputParams.put("Description", rb.getString("admp.reports_export.pageheader.description"));
        inputParams.put("Generated at", rb.getString("admp.reports_export.pageheader.generated_at"));
        inputParams.put("Page", rb.getString("admp.reports_export.pagefooter.page"));
        inputParams.put("isInline", isInline);
        reportFileName = rfConfig.getReportFileName();
        reportFileName = reportFileName == null || reportFileName.equals("") ? JRFieldDesignUtil.getReportName(reportName, rb, true) : JRFieldDesignUtil.applyReportFileNamePatterns(inputParams, reportFileName, JRFieldDesignUtil.getReportName(reportName, rb, true));
        if (reportFileName != null) {
            String reportFileName1 = reportFileName;
            Vector<String> v = new Vector<String>();
            String str1 = new String();
            for (int i = 0; i < reportFileName1.length(); ++i) {
                char c = '/';
                if (reportFileName1.charAt(i) == c) {
                    v.add(str1);
                    str1 = new String();
                    continue;
                }
                str1 = str1 + reportFileName1.charAt(i);
            }
            v.add(str1);
            String newreportFileName = "";
            for (int j = 0; j < v.size(); ++j) {
                String name = (String)v.elementAt(j);
                newreportFileName = newreportFileName + name;
            }
            reportFileName = newreportFileName;
        }
        JRFieldDesignUtil.alignBands(reportType, jasperDesign, inputParams);
        JRFieldDesignUtil.setPDFFontForPageHeaderTitleBand(reportType, jasperDesign, locale);
        JRDesignBand headerBand = (JRDesignBand)jasperDesign.getColumnHeader();
        JRDesignBand defaultHeaderBand = (JRDesignBand)headerBand.clone();
        JRDesignBand detailBand = (JRDesignBand)jasperDesign.getDetail();
        if (isInline) {
            ReportExportUtil.addEncodedLogoToInputParams(jasperDesign, inputParams);
            inputParams.put("IS_IGNORE_PAGINATION", true);
        }
        int startIndex = 1;
        Hashtable exportParams = JRFieldDesignUtil.exportSettings();
        boolean isSingleSheet = false;
        int n = exportPerRowCount = exportParams.get("EXPORT_PER_ROW_COUNT") != null ? Integer.parseInt((String)exportParams.get("EXPORT_PER_ROW_COUNT")) : 0;
        int n2 = exportPerRowCount != 0 && exportPerRowCount != -1 ? exportPerRowCount : (noOfObjToFetch = reportType.toLowerCase().indexOf("xls") != -1 ? 20000 : 3000);
        if (reportType.toLowerCase().indexOf("xls") != -1 && exportPerRowCount == -1) {
            isSingleSheet = true;
        }
        if (reportId == 957) {
            attributelist = ReportAttributeHandler.getInstance().getExportColumns(attributelist, Integer.valueOf(reportId));
            listener.updateAttributeList(null, attributelist);
            list = listener.getACERows(attributelist, attributeProp, new Boolean(ascending), startIndex, noOfObjToFetch, multipleValuesSids, (Criteria)reportFilterCrit);
        } else {
            list = listener.getRows(attributelist, attributeProp, new Boolean(ascending), startIndex, noOfObjToFetch, multipleValuesSids, reportResultCrit, (Criteria)reportFilterCrit, reportFilterTableNames, true);
        }
        exportCount += list.size();
        ReportHandler.getMultipleValues((ArrayList)attributelist, multipleValuesSids, (String)listener.tableKey);
        ReportResultUtil.getCustomizedMultipleValues(multipleValuesSids);
        ReportJRDataSource dataSource = new ReportJRDataSource(list, multipleValuesSids, JRFieldDesignUtil.getShowSerialNo(), STARTING_SERIAL_NUMBER, reportType);
        int pageColumnWidth = jasperDesign.getColumnWidth();
        boolean flexWidth = true;
        String fixedExportWidth = (String)exportParams.get("FIXED_EXPORT_WIDTH");
        if (fixedExportWidth != null && fixedExportWidth.equalsIgnoreCase("TRUE")) {
            flexWidth = false;
            pageColumnWidth = JRFieldDesignUtil.getPageColumnWidth(exportParams, jasperDesign);
        }
        if ((widthValue = (Integer)(columnWidths = JRDesignUtil.calculateWidth(attributelist, list, multipleValuesSids, reportType, pageColumnWidth, flexWidth, JRFieldDesignUtil.getShowSerialNo(), rb)).remove("maxColumnWidth")) != null) {
            pageColumnWidth = widthValue + (columnWidths.size() + 1) * 2;
            jasperDesign.setColumnWidth(pageColumnWidth);
            jasperDesign.setPageWidth(pageColumnWidth + 60);
        }
        if (reportType.toLowerCase().indexOf("csv") == -1 && reportId != 957) {
            tempJRReportFileName = productHome + File.separator + "temp" + File.separator + "jaspertemp" + File.separator + "SummaryReport_" + System.currentTimeMillis() + ".jrprint";
            JasperPrint jPrint = ReportExportInputUtil.insertSummaryReport(reportFilePath, basepath, tempJRReportFileName, rfConfig.getScheduleId(), widthValue, inputParams, listener, reportType, loginId, null, rfConfig, reportFilterCrit, null, reportFilterTableNames, rb, locale, isInline);
            int n3 = addPageCount = jPrint == null ? 0 : jPrint.getPages().size();
        }
        if (!columnWidths.isEmpty()) {
            JRDesignUtil.fillBand(columnWidths, jasperDesign, headerBand, detailBand, attributelist, reportType, null, 0, rb, null, JRFieldDesignUtil.getShowSerialNo(), locale);
        } else {
            JRDesignUtil.fillNoDataBand(jasperDesign, detailBand, reportType, rb, locale);
        }
        if (addPageCount != 0) {
            JRDesignBand titleBand = new JRDesignBand();
            titleBand.setHeight(0);
            jasperDesign.setTitle((JRBand)titleBand);
        }
        if (reportType.toLowerCase().indexOf("xls") != -1 || reportType.toLowerCase().indexOf("csv") != -1) {
            JRDesignBand pageHeader = (JRDesignBand)jasperDesign.getPageHeader();
            express = new JRDesignExpression();
            express.setValueClass(Boolean.class);
            express.setText("$V{PAGE_NUMBER}.intValue() == 1 ? Boolean.TRUE : Boolean.FALSE");
            pageHeader.setPrintWhenExpression((JRExpression)express);
        }
        if (isInline) {
            JRDesignBand pageFooter = (JRDesignBand)jasperDesign.getPageFooter();
            express = new JRDesignExpression();
            express.setValueClass(Boolean.class);
            express.setText("Boolean.FALSE");
            pageFooter.setPrintWhenExpression((JRExpression)express);
            JRDesignBand pageHeader = (JRDesignBand)jasperDesign.getPageHeader();
            JRDesignExpression headerExpress = new JRDesignExpression();
            headerExpress.setValueClass(Boolean.class);
            headerExpress.setText("Boolean.FALSE");
            pageHeader.setPrintWhenExpression((JRExpression)headerExpress);
        }
        JasperReport jasperReport = JasperCompileManager.compileReport((JasperDesign)jasperDesign);
        boolean isCSVExport = reportType.toLowerCase().indexOf("csv") != -1;
        JasperReport jasperReportBasedOnType = null;
        if (isCSVExport) {
            jasperDesign.setColumnHeader((JRBand)defaultHeaderBand);
            jasperReportBasedOnType = JasperCompileManager.compileReport((JasperDesign)jasperDesign);
        } else {
            JRDesignBand titleBand = new JRDesignBand();
            titleBand.setHeight(0);
            jasperDesign.setTitle((JRBand)titleBand);
            if (isSingleSheet) {
                jasperDesign.setColumnHeader((JRBand)defaultHeaderBand);
                JRDesignBand pageHeaderBand = new JRDesignBand();
                pageHeaderBand.setHeight(0);
                jasperDesign.setPageHeader((JRBand)pageHeaderBand);
            }
            jasperReportBasedOnType = JasperCompileManager.compileReport((JasperDesign)jasperDesign);
        }
        JRArrayList tempJRReportList = new JRArrayList();
        try {
            ArrayList toBePrintedList = new ArrayList();
            boolean tmpTotalLines = false;
            boolean currentLineCount = false;
            if (!columnWidths.isEmpty()) {
                boolean tempFileIndex = false;
                int AddToPgNumber = 0;
                AddToPgNumber = addPageCount;
                while (!list.isEmpty()) {
                    AddToPgNumber = ReportExportUtil.writeDataToJasperPrintFile(tempJRReportList, tmpJRReportFilePrefix, inputParams, list, multipleValuesSids, AddToPgNumber, jasperReportBasedOnType, jasperReport, dataSource, defaultHeaderBand, reportType, locale, isSingleSheet, JRFieldDesignUtil.getShowSerialNo(), startIndex, noOfObjToFetch);
                    multipleValuesSids = new Hashtable();
                    list = reportId == 957 ? listener.getACERows(attributelist, attributeProp, new Boolean(ascending), startIndex, noOfObjToFetch, multipleValuesSids, (Criteria)reportFilterCrit) : listener.getRows(attributelist, attributeProp, new Boolean(ascending), startIndex += noOfObjToFetch, noOfObjToFetch, multipleValuesSids, reportResultCrit, (Criteria)reportFilterCrit, reportFilterTableNames);
                    if (list.isEmpty()) continue;
                    exportCount += list.size();
                    ReportHandler.getMultipleValues((ArrayList)attributelist, multipleValuesSids, (String)listener.tableKey);
                    ReportResultUtil.getCustomizedMultipleValues(multipleValuesSids);
                    dataSource = new ReportJRDataSource(list, multipleValuesSids, JRFieldDesignUtil.getShowSerialNo(), startIndex, reportType);
                    columnWidths = JRDesignUtil.calculateWidth(attributelist, list, multipleValuesSids, reportType, null, columnWidths, pageColumnWidth, false, JRFieldDesignUtil.getShowSerialNo(), rb);
                }
            } else {
                JasperFillManager.fillReportToFile((JasperReport)jasperReport, (String)(tmpJRReportFilePrefix + ".jrprint"), (Map)inputParams);
                tempJRReportList.add(tmpJRReportFilePrefix);
            }
            listener.setExportRowCount(exportCount);
        }
        catch (Exception e) {
            e.printStackTrace();
            tempJRReportList.deleteJRFiles();
            return false;
        }
        if (addPageCount != 0) {
            tempJRReportList.add(0, tempJRReportFileName);
        }
        try {
            ReportExportUtil.exportReport(reportType, tempJRReportList, reportFileName, loginId, locale, listener, schedule_id, dir, isInline);
            tempJRReportList.deleteJRFiles();
        }
        catch (Exception ex) {
            try {
                ex.printStackTrace();
                boolean bl = false;
                tempJRReportList.deleteJRFiles();
                return bl;
            }
            catch (Throwable throwable) {
                try {
                    tempJRReportList.deleteJRFiles();
                    throw throwable;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }
            }
        }
        return true;
    }

    private static boolean checkIsInline(Long schedule_id) {
        boolean isInline = false;
        try {
            if (schedule_id != null) {
                Criteria crit = new Criteria(Column.getColumn((String)"ADSMScheduler", (String)"SCHEDULE_ID"), (Object)schedule_id, 0);
                DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMScheduler", crit);
                Row row = dataObj.getRow("ADSMScheduler");
                isInline = ((String)row.get("ATTACHMENT_TYPE")).equalsIgnoreCase("inlinehtml");
                if (isInline) {
                    reportLogger.log(Level.INFO, "report being generated for inline mail ");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isInline;
    }

    public static void addEncodedLogoToInputParams(JasperDesign jasperDesign, Map inputParams) {
        try {
            JRDesignParameter param = new JRDesignParameter();
            param.setValueClass(String.class);
            param.setName("logo");
            jasperDesign.addParameter((JRParameter)param);
            if (!inputParams.containsKey("logo")) {
                inputParams.put("logo", ReportExportUtil.getEncodedLogoString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String getEncodedLogoString() {
        String encodedLogo = null;
        try {
            Hashtable logoDetails = ClientUtil.getPageProps(null);
            String logoPath = (String)logoDetails.get("LOGO_PATH");
            logoPath = System.getProperty("server.dir") + "/" + "webapps" + "/" + "adsm" + "/" + logoPath;
            File file = new File(logoPath);
            FileInputStream fileInputStreamReader = new FileInputStream(file);
            byte[] bytes = new byte[(int)file.length()];
            fileInputStreamReader.read(bytes);
            encodedLogo = new String(Base64.encodeBase64((byte[])bytes), "UTF-8");
            encodedLogo = "data:image/gif;base64," + encodedLogo;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return encodedLogo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean exportReportWithSubReport(Row reportDetails, String reportType, Map inputParams, String reportList, Long schedule_id, String dir, AbstractListener listener, int reportId, ReportFilterConfig rfConfig, Long loginId) {
        Locale locale = listener.getLocale();
        if (locale == null) {
            locale = I18NUtil.getDefaultLocale((Long)loginId);
        }
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getResourceBundle(locale);
        String productHome = System.getProperty("product.home");
        if (productHome == null) {
            productHome = System.getProperty("server.home");
        }
        String basepath = productHome + File.separator + "bin" + File.separator + ".." + File.separator + "webapps" + File.separator + "adsm" + File.separator;
        JRSwapFileVirtualizer virtualizer = null;
        JRArrayList printNameList = new JRArrayList();
        try {
            String jasperDir = basepath + "jasperreports" + File.separator + "jasper" + File.separator;
            JRSwapFile swapFile = new JRSwapFile(jasperDir, 1024, 100);
            virtualizer = new JRSwapFileVirtualizer(50, swapFile, true);
            ArrayList attributelist = new ArrayList();
            String reportFileName = (String)reportDetails.get("REPORT_FILE_NAME");
            reportFileName = basepath + "jasperreports" + File.separator + "jrxml" + File.separator + reportFileName;
            String reportName = (String)reportDetails.get("REPORT_NAME");
            String fileName = rfConfig.getReportFileName();
            fileName = fileName == null || fileName.equals("") ? JRFieldDesignUtil.getReportName(reportName, rb, true) : JRFieldDesignUtil.applyReportFileNamePatterns(inputParams, fileName, JRFieldDesignUtil.getReportName(reportName, rb, true));
            if (fileName != null && !fileName.equals("")) {
                reportName = fileName;
            }
            String tmpJRReportFilePrefix = productHome + File.separator + "temp" + File.separator + "jaspertemp" + File.separator + schedule_id + "_" + new Random().nextInt(1000) + "_";
            File file = new File(productHome + File.separator + "temp" + File.separator + "jaspertemp");
            file.mkdirs();
            attributelist = rfConfig.getSelectedColumnsPropList();
            Properties sortColumnProp = rfConfig.getSortColumnProp();
            Integer attributeId = -1;
            String ascending = "true";
            if (!sortColumnProp.isEmpty()) {
                attributeId = (Integer)sortColumnProp.get("columnID");
                if (((String)sortColumnProp.get("sortBy")).equalsIgnoreCase("dsc")) {
                    ascending = "false";
                }
            }
            Properties attributeProp = ListenerUtil.getAttributeProp(attributeId, attributelist);
            Hashtable multipleValuesSids = new Hashtable();
            ArrayList reportFilterTableNames = new ArrayList();
            Object reportFilterCrit = null;
            Criteria reportColumnCrit = null;
            Object reportResultCrit = null;
            reportFilterCrit = listener.getScheduledReportFilterCriteria((Criteria)reportFilterCrit, rfConfig, reportFilterTableNames);
            reportColumnCrit = rfConfig.getColumnFilterCriteria(reportFilterTableNames, "", loginId, Integer.valueOf(reportId), reportDetails, listener.generationId, rb);
            reportFilterCrit = reportFilterCrit == null ? (reportColumnCrit != null ? reportColumnCrit : null) : (reportColumnCrit != null ? reportFilterCrit.and(reportColumnCrit) : reportFilterCrit);
            ArrayList list = new ArrayList();
            Hashtable columnWidths = new Hashtable();
            int currentJrPrintNo = 0;
            SubReportJRDataSource dataSource = null;
            int exportCount = 0;
            JasperDesign jasperDesign = JRXmlLoader.load((String)reportFileName);
            reportName = JRFieldDesignUtil.getReportName(reportName, rb);
            jasperDesign.setName(EscapeUtil.escSplCharsAsHTML((Object)reportName));
            reportFileName = reportName;
            if (reportFileName != null) {
                String reportFileName1 = reportFileName;
                Vector<String> v = new Vector<String>();
                String str1 = new String();
                for (int i = 0; i < reportFileName1.length(); ++i) {
                    char c = '/';
                    if (reportFileName1.charAt(i) == c) {
                        v.add(str1);
                        str1 = new String();
                        continue;
                    }
                    str1 = str1 + reportFileName1.charAt(i);
                }
                v.add(str1);
                String newreportFileName = "";
                for (int j = 0; j < v.size(); ++j) {
                    String name = (String)v.elementAt(j);
                    newreportFileName = newreportFileName + name;
                }
                reportFileName = newreportFileName;
            }
            JasperPrint print = new JasperPrint();
            JRFieldDesignUtil.alignBands(reportType, jasperDesign, inputParams);
            JRFieldDesignUtil.setPDFFontForPageHeaderTitleBand(reportType, jasperDesign, locale);
            JRDesignBand headerBand = (JRDesignBand)jasperDesign.getColumnHeader();
            JRDesignBand detailBand = (JRDesignBand)jasperDesign.getDetail();
            JasperReport jasperReport = null;
            boolean isInline = ReportExportUtil.checkIsInline(schedule_id);
            if (isInline) {
                ReportExportUtil.addEncodedLogoToInputParams(jasperDesign, inputParams);
            }
            if (reportList.equals("true")) {
                attributelist = listener.getExportAttributesList();
            }
            inputParams.put("Description", rb.getString("admp.reports_export.pageheader.description"));
            inputParams.put("Generated at", rb.getString("admp.reports_export.pageheader.generated_at"));
            inputParams.put("Page", rb.getString("admp.reports_export.pagefooter.page"));
            inputParams.put("REPORT_VIRTUALIZER", virtualizer);
            ArrayList subReportsList = listener.getSubreportDetails();
            boolean flexWidth = true;
            int pageColumnWidth = 0;
            if (reportList.equals("true")) {
                for (int i = 0; i < subReportsList.size(); ++i) {
                    Integer widthValue;
                    Properties prop = (Properties)subReportsList.get(i);
                    String subReportId = String.valueOf(prop.get("SUBREPORT_ID"));
                    String name = (String)prop.get("NAME");
                    String subreportFileName = (String)prop.get("FILE_NAME");
                    String heading = rb.getString((String)prop.get("HEADING"));
                    String subReportFile = basepath + "jasperreports" + File.separator + "jrxml" + File.separator + subreportFileName;
                    String jasperFile = basepath + "jasperreports" + File.separator + "jasper" + File.separator + name + ".jasper";
                    JasperDesign subJasperDesign = JRXmlLoader.load((String)subReportFile);
                    int columnWidth = subJasperDesign.getColumnWidth();
                    JRDesignBand hBand = (JRDesignBand)subJasperDesign.getColumnHeader();
                    JRDesignBand dBand = (JRDesignBand)subJasperDesign.getDetail();
                    subJasperDesign.setName(name);
                    ArrayList subAttributeList = listener.getSubReportAttributes(subReportId);
                    listener.updateAttributeList(null, subAttributeList);
                    ArrayList rowList = ReportResultUtil.getSharesRows(subAttributeList, listener, rb);
                    Hashtable exportParams = JRFieldDesignUtil.exportSettings();
                    pageColumnWidth = subJasperDesign.getColumnWidth();
                    String fixedExportWidth = (String)exportParams.get("FIXED_EXPORT_WIDTH");
                    if (fixedExportWidth != null && fixedExportWidth.equalsIgnoreCase("TRUE")) {
                        flexWidth = false;
                        pageColumnWidth = JRFieldDesignUtil.getPageColumnWidth(exportParams, subJasperDesign);
                    }
                    if ((widthValue = (Integer)(columnWidths = JRDesignUtil.calculateWidth(subAttributeList, rowList, null, reportType, null, columnWidths, pageColumnWidth, flexWidth, rb)).remove("maxColumnWidth")) != null) {
                        pageColumnWidth = widthValue + (columnWidths.size() + 1) * 2;
                        subJasperDesign.setColumnWidth(pageColumnWidth);
                        subJasperDesign.setPageWidth(pageColumnWidth + 60);
                    }
                    JRDesignUtil.fillBandSubReport(columnWidths, subJasperDesign, hBand, dBand, subAttributeList, reportType, rb, loginId, locale, subReportFile, heading, flexWidth);
                    prop.put("ATTRIBUTE_LIST", subAttributeList);
                    prop.put("SUBREPORT_DESIGN", subJasperDesign);
                    JasperCompileManager.compileReportToFile((JasperDesign)subJasperDesign, (String)jasperFile);
                }
                if (flexWidth) {
                    jasperDesign.setColumnWidth(pageColumnWidth + 30);
                    jasperDesign.setPageWidth(pageColumnWidth + 125);
                }
                JRDesignUtil.fillBand(columnWidths, jasperDesign, headerBand, detailBand, attributelist, reportType, rb, loginId, locale, subReportsList);
                String serverName = "";
                for (AdmpInput admpInput : rfConfig.getInputList()) {
                    if (admpInput.getIsMultiple().booleanValue() || !admpInput.getName().equalsIgnoreCase("serverName")) continue;
                    serverName = admpInput.getValue();
                }
                Long genId = listener.generationId;
                Long value = ListenerUtil.getInputId(reportId, genId, "trusteesList");
                String inputName = serverName;
                if (reportList.equals("true")) {
                    inputParams.put("title", rb.getString(listener.title) + " : " + inputName);
                } else {
                    inputParams.put("title", " ");
                }
                ArrayList reportAttributelist = new ArrayList();
                reportAttributelist = ReportAttributeHandler.getInstance().getViewColumn(Integer.valueOf(reportId), loginId);
                listener.updateAttributeList(null, reportAttributelist);
                ArrayList sharesList = ReportResultUtil.getShares(value, genId, reportFilterCrit, attributeProp, Boolean.valueOf(ascending));
                if (sharesList.size() != 0) {
                    list = listener.getExportData(sharesList, attributelist, subReportsList);
                    exportCount += list.size();
                    dataSource = new SubReportJRDataSource(list, rb);
                    jasperReport = JasperCompileManager.compileReport((JasperDesign)jasperDesign);
                    JasperFillManager.fillReportToFile((JasperReport)jasperReport, (String)(basepath + "NTFSJrPrint-" + currentJrPrintNo + ".jrprint"), (Map)inputParams, (JRDataSource)dataSource);
                    printNameList.add(basepath + "NTFSJrPrint-" + currentJrPrintNo + ".jrprint");
                    ++currentJrPrintNo;
                    if (dataSource != null) {
                        dataSource = null;
                    }
                }
            }
            listener.setExportRowCount(exportCount);
            ReportExportUtil.exportReport(reportType, printNameList, reportFileName, loginId, locale, listener, schedule_id, dir, isInline);
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            printNameList.deleteJRFiles();
            if (virtualizer != null) {
                virtualizer.cleanup();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportReport(Row reportDetails, String reportType, ArrayList attributelist, Map inputParams, HttpServletRequest request, HttpServletResponse response, String reportList, AbstractListener listener, ReportReqParams reqParams) {
        JRArrayList tempJRReportList = new JRArrayList();
        String reportFileName = null;
        Long loginId = null;
        Locale locale = I18NUtil.getDefaultLocale((HttpServletRequest)request);
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        Object summaryPrint = null;
        int addPageCount = 0;
        String tempJRReportFileName = null;
        int exportCount = 0;
        try {
            Hashtable columnWidths;
            Integer widthValue;
            int exportPerRowCount;
            reportFileName = (String)reportDetails.get("REPORT_FILE_NAME");
            String basepath = request.getSession().getServletContext().getRealPath("/");
            String reportFilePath = basepath + "jasperreports" + File.separator + "jrxml" + File.separator + reportFileName;
            String reportName = (String)reportDetails.get("REPORT_NAME");
            String productHome = System.getProperty("product.home");
            if (productHome == null) {
                productHome = System.getProperty("server.home");
            }
            String tmpJRReportFilePrefix = productHome + File.separator + "temp" + File.separator + "jaspertemp" + File.separator + "ExportReport_" + new Random().nextInt(1000) + "_";
            File file = new File(productHome + File.separator + "temp" + File.separator + "jaspertemp");
            file.mkdirs();
            HttpSession session = request.getSession();
            ReportBean bean = (ReportBean)((Object)session.getAttribute("ReportBean"));
            Integer attributeId = reqParams.getSortAttribId();
            Integer reportId = reqParams.getReportId();
            Properties attributeProp = null;
            if (reportList.equals("true")) {
                if (attributeId == null || attributeId.equals(new Integer(-1))) {
                    attributeId = ReportAttributesUtil.getDefaultSortingProp((Integer)reportId, (ArrayList)attributelist);
                }
                if ((attributeProp = ListenerUtil.getAttributeProp(attributeId, attributelist)) == null) {
                    attributeId = ReportAttributesUtil.getDefaultSortingProp((Integer)reportId, (ArrayList)attributelist);
                    attributeProp = ListenerUtil.getAttributeProp(attributeId, attributelist);
                }
            }
            Hashtable multipleValuesSids = new Hashtable();
            ArrayList tableNames = new ArrayList();
            Criteria crit = null;
            int startIndex = 1;
            Hashtable exportParams = JRFieldDesignUtil.exportSettings();
            boolean isSingleSheet = false;
            int n = exportPerRowCount = exportParams.get("EXPORT_PER_ROW_COUNT") != null ? Integer.parseInt((String)exportParams.get("EXPORT_PER_ROW_COUNT")) : 0;
            int noOfObjToFetch = exportPerRowCount != 0 && exportPerRowCount != -1 ? exportPerRowCount : (reportType.toLowerCase().indexOf("xls") != -1 ? 20000 : 5000);
            String modifyResultColumn = (String)bean.get("modifyResultColumn");
            if (modifyResultColumn == null || modifyResultColumn.equals("")) {
                modifyResultColumn = "MESSAGE";
            }
            Column sortColumn = ReportClientUtil.getSortColumn(listener.mgmtResultTableName, modifyResultColumn, attributelist);
            if (reportType.toLowerCase().indexOf("xls") != -1 && exportPerRowCount == -1) {
                isSingleSheet = true;
            }
            ArrayList list = new ArrayList();
            Criteria columnSearchCriteria = null;
            Criteria reportFilterCriteria = null;
            if (reportList.equals("true")) {
                columnSearchCriteria = ReportResultUtil.getColumnSearchCriteria(attributelist, reqParams, tableNames);
                columnSearchCriteria = listener.getReportFilterCriteria(columnSearchCriteria, reqParams, tableNames);
                reportFilterCriteria = listener.getReportResultFilterCriteria(request, reqParams, null);
                list = listener.getRows(attributelist, attributeProp, new Boolean(reqParams.isSortOrder()), startIndex, noOfObjToFetch, multipleValuesSids, reportFilterCriteria, columnSearchCriteria, new ArrayList());
            } else {
                list = ReportResultUtil.getModifyRows(listener.mgmtGenerationId, listener.baseTableName, listener.mgmtResultTableName, attributelist, sortColumn, new Boolean(reqParams.isSortOrder()), startIndex, noOfObjToFetch, multipleValuesSids, crit);
                Properties props = new Properties();
                props.put("ATTRIB_COLUMN_NAME", "STATUS");
                props.put("ATTRIB_DISP_NAME", rb.getString("admp.mgmt.user_mgmt.naming_attribs.statmsg.status"));
                props.put("ATTRIB_LDAP_NAME", "status");
                props.put("ATTRIB_ID", (Object)100000);
                props.put("RELATIONAL_TYPE", (Object)0);
                attributelist.add(props);
            }
            exportCount = list.size();
            ReportHandler.getMultipleValues((ArrayList)attributelist, multipleValuesSids, (String)listener.tableKey);
            ReportResultUtil.getCustomizedMultipleValues(multipleValuesSids);
            ReportJRDataSource dataSource = new ReportJRDataSource(list, multipleValuesSids, true, STARTING_SERIAL_NUMBER, reportType);
            JasperDesign jasperDesign = JRXmlLoader.load((String)reportFilePath);
            jasperDesign.setName(JRFieldDesignUtil.getReportName(reportName, rb));
            reportFileName = "ADMPReport";
            request.setAttribute("reportFileName", (Object)reportFileName);
            JRFieldDesignUtil.alignBands(reportType, jasperDesign, inputParams);
            JRFieldDesignUtil.setPDFFontForPageHeaderTitleBand(reportType, jasperDesign, locale);
            loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            if (reportList.equals("true")) {
                inputParams.put("title", rb.getString(listener.title));
            } else {
                inputParams.put("title", " ");
            }
            inputParams.put("Generated at", rb.getString("admp.reports_export.pageheader.generated_at"));
            inputParams.put("Page", rb.getString("admp.reports_export.pagefooter.page"));
            JRDesignBand headerBand = (JRDesignBand)jasperDesign.getColumnHeader();
            JRDesignBand defaultHeaderBand = (JRDesignBand)headerBand.clone();
            JRBand[] detailBands = ((JRDesignSection)jasperDesign.getDetailSection()).getBands();
            JRDesignBand detailBand = (JRDesignBand)detailBands[detailBands.length - 1];
            int pageColumnWidth = jasperDesign.getColumnWidth();
            boolean flexWidth = true;
            String fixedExportWidth = (String)exportParams.get("FIXED_EXPORT_WIDTH");
            if (fixedExportWidth != null && fixedExportWidth.equalsIgnoreCase("TRUE")) {
                flexWidth = false;
                pageColumnWidth = JRFieldDesignUtil.getPageColumnWidth(exportParams, jasperDesign);
            }
            if ((widthValue = (Integer)(columnWidths = JRDesignUtil.calculateWidth(attributelist, list, multipleValuesSids, reportType, request, new Hashtable(), pageColumnWidth, flexWidth, JRFieldDesignUtil.getShowSerialNo(), rb)).remove("maxColumnWidth")) != null) {
                pageColumnWidth = widthValue + (columnWidths.size() + 1) * 2;
                jasperDesign.setColumnWidth(pageColumnWidth);
                jasperDesign.setPageWidth(pageColumnWidth + 60);
            }
            if (reportList.equals("true") && reportType.toLowerCase().indexOf("csv") == -1) {
                tempJRReportFileName = productHome + File.separator + "temp" + File.separator + "jaspertemp" + File.separator + "SummaryReport_" + System.currentTimeMillis() + ".jrprint";
                JasperPrint jPrint = ReportExportInputUtil.insertSummaryReport(reportFilePath, basepath, tempJRReportFileName, null, widthValue, inputParams, listener, reportType, loginId, reqParams, null, reportFilterCriteria, columnSearchCriteria, tableNames, rb, locale, false);
                addPageCount = jPrint == null ? 0 : jPrint.getPages().size();
            }
            JRDesignUtil.fillBand(columnWidths, jasperDesign, headerBand, detailBand, attributelist, reportType, null, 0, rb, loginId, JRFieldDesignUtil.getShowSerialNo(), locale);
            if (addPageCount != 0) {
                JRDesignBand titleBand = new JRDesignBand();
                titleBand.setHeight(0);
                jasperDesign.setTitle((JRBand)titleBand);
            }
            if (reportType.toLowerCase().indexOf("xls") != -1 || reportType.toLowerCase().indexOf("csv") != -1) {
                JRDesignBand pageHeader = (JRDesignBand)jasperDesign.getPageHeader();
                JRDesignExpression express = new JRDesignExpression();
                express.setValueClass(Boolean.class);
                express.setText("$V{PAGE_NUMBER}.intValue() == 1 ? Boolean.TRUE : Boolean.FALSE");
                pageHeader.setPrintWhenExpression((JRExpression)express);
            }
            JasperReport jasperReport = JasperCompileManager.compileReport((JasperDesign)jasperDesign);
            boolean isCSVExport = reportType.toLowerCase().indexOf("csv") != -1;
            JasperReport jasperReportBasedOnType = null;
            if (isCSVExport) {
                jasperDesign.setColumnHeader((JRBand)defaultHeaderBand);
                jasperReportBasedOnType = JasperCompileManager.compileReport((JasperDesign)jasperDesign);
            } else {
                JRDesignBand titleBand = new JRDesignBand();
                titleBand.setHeight(0);
                jasperDesign.setTitle((JRBand)titleBand);
                if (isSingleSheet) {
                    jasperDesign.setColumnHeader((JRBand)defaultHeaderBand);
                    JRDesignBand pageHeaderBand = new JRDesignBand();
                    pageHeaderBand.setHeight(0);
                    jasperDesign.setPageHeader((JRBand)pageHeaderBand);
                }
                jasperReportBasedOnType = JasperCompileManager.compileReport((JasperDesign)jasperDesign);
            }
            if (reportList.equals("true")) {
                inputParams.put("title", rb.getString(listener.title));
            } else {
                inputParams.put("title", " ");
            }
            inputParams.put("Generated at", rb.getString("admp.reports_export.pageheader.generated_at"));
            inputParams.put("Page", rb.getString("admp.reports_export.pagefooter.page"));
            int AddToPgNumber = 0;
            AddToPgNumber = addPageCount;
            while (!list.isEmpty()) {
                AddToPgNumber = ReportExportUtil.writeDataToJasperPrintFile(tempJRReportList, tmpJRReportFilePrefix, inputParams, list, multipleValuesSids, AddToPgNumber, jasperReportBasedOnType, jasperReport, dataSource, defaultHeaderBand, reportType, locale, isSingleSheet, JRFieldDesignUtil.getShowSerialNo(), startIndex, noOfObjToFetch);
                multipleValuesSids = new Hashtable();
                list = reportList.equals("true") ? listener.getRows(attributelist, attributeProp, new Boolean(reqParams.isSortOrder()), startIndex, noOfObjToFetch, multipleValuesSids, reportFilterCriteria, columnSearchCriteria, new ArrayList()) : ReportResultUtil.getModifyRows(listener.mgmtGenerationId, listener.baseTableName, listener.mgmtResultTableName, attributelist, sortColumn, new Boolean(reqParams.isSortOrder()), startIndex += noOfObjToFetch, noOfObjToFetch, multipleValuesSids, crit);
                if (list.isEmpty()) continue;
                exportCount += list.size();
                ReportHandler.getMultipleValues((ArrayList)attributelist, multipleValuesSids, (String)listener.tableKey);
                ReportResultUtil.getCustomizedMultipleValues(multipleValuesSids);
                dataSource = new ReportJRDataSource(list, multipleValuesSids, true, startIndex, reportType);
                columnWidths = JRDesignUtil.calculateWidth(attributelist, list, multipleValuesSids, reportType, request, columnWidths, pageColumnWidth, false, rb);
            }
            listener.setExportRowCount(exportCount);
        }
        catch (Exception e) {
            e.printStackTrace();
            tempJRReportList.deleteJRFiles();
            return;
        }
        try {
            if (addPageCount != 0) {
                tempJRReportList.add(0, tempJRReportFileName);
            }
            ReportExportUtil.exportReport(reportType, request, response, tempJRReportList, reportFileName, loginId, locale, listener);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            tempJRReportList.deleteJRFiles();
        }
    }

    public static int writeDataToJasperPrintFile(JRArrayList tempJRReportList, String tmpJRReportFilePrefix, Map inputParams, ArrayList list, Hashtable multipleValuesSids, int AddToPgNumber, JasperReport jasperReportBasedOnType, JasperReport jasperReport, JRDataSource dataSource, JRDesignBand defaultHeaderBand, String reportType, Locale locale, boolean isSingleSheet, int noOfObjToFetch) throws Exception {
        return ReportExportUtil.writeDataToJasperPrintFile(tempJRReportList, tmpJRReportFilePrefix, inputParams, list, multipleValuesSids, AddToPgNumber, jasperReportBasedOnType, jasperReport, dataSource, defaultHeaderBand, reportType, locale, isSingleSheet, false, 0, noOfObjToFetch);
    }

    public static int writeDataToJasperPrintFile(JRArrayList tempJRReportList, String tmpJRReportFilePrefix, Map inputParams, ArrayList list, Hashtable multipleValuesSids, int AddToPgNumber, JasperReport jasperReportBasedOnType, JasperReport jasperReport, JRDataSource dataSource, JRDesignBand defaultHeaderBand, String reportType, Locale locale, boolean isSingleSheet, boolean showSerialNo, int startIndex, int noOfObjToFetch) throws Exception {
        int tempJRReportListSize = 0;
        JRDesignReportFont font = (JRDesignReportFont)JRFieldDesignUtil.getPDFExporterFont(locale);
        boolean isCSVExport = reportType.toLowerCase().indexOf("csv") != -1;
        ArrayList toBePrintedList = new ArrayList();
        while (!list.isEmpty()) {
            tempJRReportListSize = tempJRReportList.size();
            if (tempJRReportListSize >= 1) {
                jasperReport = jasperReportBasedOnType;
            }
            int tmpTotalLines = 0;
            int currentLineCount = 0;
            int maxLinesCapable = 450;
            if (reportType.toLowerCase().indexOf("xls") != -1) {
                maxLinesCapable = 20000;
            }
            int listCount = list.size();
            for (int indx1 = 0; indx1 < listCount; ++indx1) {
                int n = currentLineCount = ((Hashtable)list.get(0)).get("maxRows") != null ? (Integer)((Hashtable)list.get(0)).get("maxRows") : 1;
                if ((tmpTotalLines += currentLineCount) > maxLinesCapable) {
                    if (tmpTotalLines != currentLineCount) break;
                    toBePrintedList.add(list.remove(0));
                    break;
                }
                toBePrintedList.add(list.remove(0));
            }
            if (dataSource instanceof ReportJRDataSource) {
                dataSource = showSerialNo ? new ReportJRDataSource(toBePrintedList, multipleValuesSids, showSerialNo, startIndex, reportType) : new ReportJRDataSource(toBePrintedList, multipleValuesSids, reportType);
            } else if (dataSource instanceof ListUserDataProvider) {
                dataSource = showSerialNo ? new ListUserDataProvider(toBePrintedList, showSerialNo, STARTING_SERIAL_NUMBER) : new ListUserDataProvider(toBePrintedList);
            }
            String tempJRReportFileName = tmpJRReportFilePrefix + tempJRReportListSize + ".jrprint";
            inputParams.put("AddToPgNumber", AddToPgNumber);
            JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, (Map)inputParams, (JRDataSource)dataSource);
            jasperPrint.setDefaultFont((JRReportFont)font);
            AddToPgNumber += jasperPrint.getPages().size();
            if (reportType.toLowerCase().indexOf("xls") != -1 && isSingleSheet) {
                List pageList = jasperPrint.getPages();
                JasperPrint jasperPrintSingle = tempJRReportListSize == 0 ? jasperPrint : (JasperPrint)tempJRReportList.get(0);
                if (tempJRReportListSize >= 1) {
                    for (int pageNo = 0; pageNo < pageList.size(); ++pageNo) {
                        jasperPrintSingle.addPage((JRPrintPage)pageList.get(pageNo));
                    }
                }
                tempJRReportList.clear();
                JRSaver.saveObject((Object)jasperPrintSingle, (String)tempJRReportFileName);
            } else {
                JRSaver.saveObject((Object)jasperPrint, (String)tempJRReportFileName);
            }
            tempJRReportList.add(tempJRReportFileName);
            startIndex += toBePrintedList.size();
            toBePrintedList.clear();
        }
        return AddToPgNumber;
    }

    public static void exportReport(int reportId, Long loginId, Long generationId, ReportTask listener, boolean zip, Long schedule_id, String storagePath, Integer count, ReportFilterConfig rfConfig) throws Exception {
        String reportType = SchedulerUtil.getReportType((Long)schedule_id);
        if (count > 0) {
            ReportExportUtil.exportReport(reportId, loginId, generationId, listener, schedule_id, storagePath, reportType, rfConfig);
        }
        if (zip) {
            String password = PasswordUtil.getExportFilePassword((Long)loginId);
            ZipUtility.makeZip(storagePath, password);
        }
    }

    public static void exportReport(int reportId, Long loginId, Long generationId, ReportTask listenerRT, Long schedule_id, String storagePath, String reportType, ReportFilterConfig rfConfig) {
        ArrayList trusteesList = new ArrayList();
        trusteesList = listenerRT.getTrusteesList();
        String tile = "printPage";
        try {
            boolean isExportSuccess = false;
            HashMap<String, String> inputParams = new HashMap<String, String>();
            AbstractListener listener = (AbstractListener)listenerRT;
            Row row = ReportHandler.getGeneratedReportDetails((Long)generationId, (Long)loginId);
            inputParams.put("date", DateTimeUtil.getDateFormat((Long)loginId).format(new Date((Long)row.get("CREATION_TIME"))));
            inputParams.put("desc", (String)row.get("DESCRIPTION"));
            if (reportType == null) {
                reportType = "pdf";
            }
            DataObject obj = ReportHandler.getReportDetails((Integer)reportId);
            Row r = obj.getFirstRow("ADSMReports");
            isExportSuccess = reportId == 951 ? ReportExportUtil.exportReportWithSubReport(r, reportType, inputParams, "true", schedule_id, storagePath, listener, reportId, rfConfig, loginId) : (trusteesList != null && trusteesList.size() > 0 ? ReportExportUtil.exportReport(r, reportType, inputParams, "true", schedule_id, storagePath, listener, reportId, rfConfig, loginId, trusteesList) : ReportExportUtil.exportReport(r, reportType, inputParams, "true", schedule_id, storagePath, listener, reportId, rfConfig, loginId));
            if (isExportSuccess && PrivacyHandler.getInstance().isExportAuditEnabled().booleanValue()) {
                Long auditId = DataImportExportAudit.auditDataFlow((Long)System.currentTimeMillis(), (Long)loginId, (String)HelpdeskUtil.getLoginUserName((Long)loginId), (String)"-", (String)"admp.deleg.hdt_deleg.cre_role.action_name.ad_reports", (String)((String)r.get("REPORT_NAME")), (Integer)reportId, (String)"-", (Boolean)Boolean.FALSE, (String)listener.getExportFileName(), (String)reportType.toLowerCase(), (String)storagePath, (Integer)listener.getExportRowCount());
                listener.setExportAuditID(auditId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportReport(Row reportDetails, String reportType, ArrayList attributelist, Map inputParams, HttpServletRequest request, HttpServletResponse response, String reportList, AbstractListener listener, ArrayList trusteesList, ReportReqParams reqParams) {
        JRArrayList tempJRReportList = new JRArrayList();
        try {
            JasperPrint jPrint;
            String reportFileName = (String)reportDetails.get("REPORT_FILE_NAME");
            String tempJRReportFileName = null;
            String basepath = request.getSession().getServletContext().getRealPath("/");
            reportFileName = basepath + "jasperreports" + File.separator + "jrxml" + File.separator + reportFileName;
            String reportName = (String)reportDetails.get("REPORT_NAME");
            Locale locale = I18NUtil.getDefaultLocale((HttpServletRequest)request);
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            HttpSession session = request.getSession();
            ReportBean bean = (ReportBean)((Object)session.getAttribute("ReportBean"));
            Integer reportId = (Integer)bean.get("reportId");
            Properties attributeProp = null;
            Hashtable multipleValuesSids = null;
            ArrayList tableNames = new ArrayList();
            Criteria crit = null;
            Criteria criteria = null;
            ArrayList list = new ArrayList();
            ArrayList baseTables = null;
            TreeMap<String, ArrayList> tableLists = new TreeMap<String, ArrayList>();
            Hashtable<String, Hashtable> multiValuesList = new Hashtable<String, Hashtable>();
            Hashtable columnWidths = new Hashtable();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            int pageColumnWidth = -1;
            Hashtable exportParams = JRFieldDesignUtil.exportSettings();
            int AddToPgNumber = 0;
            int exportCount = 0;
            String productHome = System.getProperty("product.home");
            if (productHome == null) {
                productHome = System.getProperty("server.home");
            }
            if (reportList.equals("true")) {
                Integer attributeId = reqParams.getSortAttribId();
                if (attributeId == null || attributeId.equals(new Integer(-1))) {
                    attributeId = ReportAttributesUtil.getDefaultSortingProp((Integer)((Integer)bean.get("reportId")), (ArrayList)attributelist);
                }
                if ((attributeProp = ListenerUtil.getAttributeProp(attributeId, attributelist)) == null) {
                    attributeId = ReportAttributesUtil.getDefaultSortingProp((Integer)((Integer)bean.get("reportId")), (ArrayList)attributelist);
                    attributeProp = ListenerUtil.getAttributeProp(attributeId, attributelist);
                }
                for (int i = 0; i < trusteesList.size(); ++i) {
                    Criteria columnSearchCriteria;
                    Hashtable inputs = (Hashtable)trusteesList.get(i);
                    Long value = (Long)inputs.get("INPUT_ID");
                    String key = value.toString();
                    String INPUT_NAME_KEY = inputs.containsKey("INPUT_NAME") ? "INPUT_NAME" : "INPUT_PROPERTY_VALUE";
                    String inputName = (String)inputs.get(INPUT_NAME_KEY);
                    if (listener.getResultTableName().equalsIgnoreCase("ADSMACLsReportResult")) {
                        attributelist = ReportAttributeHandler.getInstance().getExportColumns(attributelist, (Integer)bean.get("reportId"));
                        listener.updateAttributeList(bean, attributelist);
                        attributeProp = ListenerUtil.getAttributeProp(attributeId, attributelist);
                        criteria = crit = ReportResultUtil.getColumnSearchCriteria(attributelist, reqParams, tableNames);
                        crit = listener.getReportResultFilterCriteria(request, bean, crit, key);
                        list = listener.getACERows(attributelist, attributeProp, new Boolean(reqParams.isSortOrder()), -1, -1, multipleValuesSids, crit);
                        if (list.size() == 0) continue;
                        exportCount += list.size();
                        tableLists.put(inputName, list);
                        if (multipleValuesSids != null) {
                            multiValuesList.put(inputName, multipleValuesSids);
                            continue;
                        }
                        multiValuesList.put(inputName, new Hashtable());
                        continue;
                    }
                    multipleValuesSids = new Hashtable();
                    attributeProp = ListenerUtil.getAttributeProp(attributeId, attributelist);
                    criteria = columnSearchCriteria = ReportResultUtil.getColumnSearchCriteria(attributelist, reqParams, tableNames);
                    JSONArray rvcFilters = new JSONArray();
                    JSONObject json = new JSONObject();
                    json.put("inputId", (Object)key);
                    json.put("objectGUID", (Object)inputName);
                    rvcFilters.put((Object)json);
                    reqParams.setRvcFilters(rvcFilters);
                    Criteria resultTableCriteria = listener.getReportResultFilterCriteria(request, reqParams, crit);
                    list = listener.getRows(attributelist, attributeProp, new Boolean(reqParams.isSortOrder()), -1, -1, multipleValuesSids, resultTableCriteria, columnSearchCriteria, new ArrayList());
                    ReportHandler.getMultipleValues((ArrayList)attributelist, (Hashtable)multipleValuesSids, (String)listener.tableKey, null, (Integer)reqParams.getReportId());
                    ReportResultUtil.getCustomizedMultipleValues(multipleValuesSids);
                    if (list.size() == 0) continue;
                    exportCount += list.size();
                    tableLists.put(inputName, list);
                    multiValuesList.put(inputName, multipleValuesSids);
                }
            } else {
                multipleValuesSids = new Hashtable();
                list = ReportResultUtil.getModifyRows(listener.mgmtGenerationId, listener.baseTableName, listener.mgmtResultTableName, attributelist, null, new Boolean(reqParams.isSortOrder()), -1, -1, multipleValuesSids, crit);
                Properties props = new Properties();
                props.put("ATTRIB_COLUMN_NAME", "STATUS");
                props.put("ATTRIB_DISP_NAME", rb.getString("admp.mgmt.user_mgmt.naming_attribs.statmsg.status"));
                props.put("ATTRIB_LDAP_NAME", "status");
                props.put("ATTRIB_ID", (Object)100000);
                props.put("RELATIONAL_TYPE", (Object)0);
                attributelist.add(props);
                tableLists.put(reportName, list);
                multiValuesList.put(reportName, multipleValuesSids);
                exportCount += list.size();
            }
            listener.setExportRowCount(exportCount);
            ReportJRDataSource dataSource = null;
            ArrayList<JasperPrint> printList = new ArrayList<JasperPrint>();
            int k = 0;
            int continueSerialNo = 1;
            HashMap formatPatternMap = DateTimeUtil.getFormatPatternsMap((Long)loginId);
            if (reportList.equals("true")) {
                inputParams.put("title", rb.getString(listener.title));
            } else {
                inputParams.put("title", " ");
            }
            inputParams.put("Description", rb.getString("admp.reports_export.pageheader.description"));
            inputParams.put("Generated at", rb.getString("admp.reports_export.pageheader.generated_at"));
            inputParams.put("Page", rb.getString("admp.reports_export.pagefooter.page"));
            if (reportType.toLowerCase().indexOf("xls") != -1) {
                inputParams.put("IS_IGNORE_PAGINATION", Boolean.TRUE);
            }
            if (reportList.equals("true") && reportType.toLowerCase().indexOf("csv") == -1 && (jPrint = ReportExportInputUtil.insertSummaryReport(reportFileName, basepath, tempJRReportFileName = productHome + File.separator + "temp" + File.separator + "jaspertemp" + File.separator + "SummaryReport_" + System.currentTimeMillis() + ".jrprint", null, 535, inputParams, listener, reportType, loginId, reqParams, null, null, criteria, tableNames, rb, locale, false)) != null) {
                printList.add(jPrint);
                AddToPgNumber = jPrint.getPages().size();
                tempJRReportList.add(tempJRReportFileName);
            }
            for (Map.Entry e : tableLists.entrySet()) {
                Integer widthValue;
                String key = (String)e.getKey();
                list = (ArrayList)tableLists.get(key);
                if (!multiValuesList.isEmpty()) {
                    multipleValuesSids = (Hashtable)multiValuesList.get(key);
                }
                JasperDesign jasperDesign = JRXmlLoader.load((String)reportFileName);
                jasperDesign.setName(JRFieldDesignUtil.getReportName(reportName, rb));
                JasperPrint print = new JasperPrint();
                JRFieldDesignUtil.alignBands(reportType, jasperDesign, inputParams);
                JRFieldDesignUtil.setPDFFontForPageHeaderTitleBand(reportType, jasperDesign, locale);
                JRDesignBand headerBand = (JRDesignBand)jasperDesign.getColumnHeader();
                JRDesignBand detailBand = (JRDesignBand)jasperDesign.getDetail();
                pageColumnWidth = jasperDesign.getColumnWidth();
                boolean flexWidth = true;
                String fixedExportWidth = (String)exportParams.get("FIXED_EXPORT_WIDTH");
                if (fixedExportWidth != null && fixedExportWidth.equalsIgnoreCase("TRUE")) {
                    flexWidth = false;
                    pageColumnWidth = JRFieldDesignUtil.getPageColumnWidth(exportParams, jasperDesign);
                }
                if ((widthValue = (Integer)(columnWidths = JRDesignUtil.calculateWidth(attributelist, list, multipleValuesSids, reportType, pageColumnWidth, flexWidth, JRFieldDesignUtil.getShowSerialNo(), rb)).remove("maxColumnWidth")) != null) {
                    pageColumnWidth = widthValue + (columnWidths.size() + 1) * 2;
                    jasperDesign.setColumnWidth(pageColumnWidth);
                    jasperDesign.setPageWidth(pageColumnWidth + 60);
                }
                if (reportType.toLowerCase().indexOf("xls") != -1 || reportType.toLowerCase().indexOf("csv") != -1) {
                    JRDesignBand pageHeader = (JRDesignBand)jasperDesign.getPageHeader();
                    JRDesignExpression express = new JRDesignExpression();
                    express.setValueClass(Boolean.class);
                    express.setText("$V{PAGE_NUMBER}.intValue() == 1 ? Boolean.TRUE : Boolean.FALSE");
                    pageHeader.setPrintWhenExpression((JRExpression)express);
                    if (reportType.toLowerCase().indexOf("csv") != -1 && k > 0) {
                        JRDesignBand columnHeader = new JRDesignBand();
                        columnHeader.setHeight(0);
                        jasperDesign.setColumnHeader((JRBand)columnHeader);
                    }
                }
                JasperReport jasperReport = null;
                try {
                    if (baseTables != null) {
                        JRDesignUtil.fillBand(columnWidths, jasperDesign, headerBand, detailBand, attributelist, reportType, (String)baseTables.get(k), 0, rb, loginId, JRFieldDesignUtil.getShowSerialNo(), locale);
                    } else {
                        JRDesignUtil.fillBand(columnWidths, jasperDesign, headerBand, detailBand, attributelist, reportType, null, 0, rb, loginId, JRFieldDesignUtil.getShowSerialNo(), locale);
                    }
                    jasperReport = JasperCompileManager.compileReport((JasperDesign)jasperDesign);
                    dataSource = reportType.toLowerCase().indexOf("csv") != -1 ? new ReportJRDataSource(list, multipleValuesSids, JRFieldDesignUtil.getShowSerialNo(), continueSerialNo, reportType) : new ReportJRDataSource(list, multipleValuesSids, JRFieldDesignUtil.getShowSerialNo(), STARTING_SERIAL_NUMBER, reportType);
                    if (reportList.equals("true")) {
                        inputParams.put("title", rb.getString(listener.title) + " : " + key);
                    } else {
                        inputParams.put("title", " ");
                    }
                    inputParams.put("Description", rb.getString("admp.reports_export.pageheader.description"));
                    inputParams.put("Generated at", rb.getString("admp.reports_export.pageheader.generated_at"));
                    inputParams.put("Page", rb.getString("admp.reports_export.pagefooter.page"));
                    inputParams.put("AddToPgNumber", AddToPgNumber);
                    print = JasperFillManager.fillReport((JasperReport)jasperReport, (Map)inputParams, (JRDataSource)dataSource);
                    continueSerialNo = dataSource.getSerialNo();
                    if (dataSource != null) {
                        dataSource = null;
                    }
                    key = reportList.equals("true") ? key : (String)inputParams.get("desc");
                    key = JRFieldDesignUtil.getXlsxSheetName(rb.getString(key));
                    print.setName(key);
                    AddToPgNumber += print.getPages().size();
                    printList.add(print);
                    print = null;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    System.out.println("Input Params After Filling " + inputParams);
                    tempJRReportList.deleteJRFiles();
                    return;
                }
                ++k;
            }
            reportFileName = "ADMPReport";
            request.setAttribute("reportFileName", (Object)reportFileName);
            String password = PasswordUtil.getExportFilePassword((Long)loginId);
            ReportExporter exporter = new ReportExporter(reportType, password);
            if (reportType.toLowerCase().indexOf("pdf") != -1) {
                response.reset();
                exporter.exportAsPdf(printList, reportFileName, response, locale);
            } else if (reportType.toLowerCase().indexOf("jpg") != -1) {
                exporter.exportAsJpeg(printList, reportFileName, response);
            } else if (reportType.toLowerCase().indexOf("html") != -1) {
                reportLogger.log(Level.INFO, "The reportFileName in abs exportreport is : " + reportFileName);
                exporter.exportAsHtml(printList, reportFileName, response, request.getSession());
            } else if (reportType.toLowerCase().indexOf("xlsx") != -1) {
                exporter.exportAsXlsx(printList, reportFileName, response, formatPatternMap);
            } else if (reportType.toLowerCase().indexOf("xls") != -1) {
                exporter.exportAsXls(printList, reportFileName, response);
                System.out.println("inside xls report");
            } else if (reportType.toLowerCase().indexOf("csv") != -1) {
                exporter.exportAsCsv(printList, reportFileName, response, loginId);
            } else {
                reportLogger.log(Level.INFO, "Invalid Report Type");
            }
            listener.setExportFileName(exporter.getExportFile());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            tempJRReportList.deleteJRFiles();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean exportReport(Row reportDetails, String reportType, Map inputParams, String reportList, Long schedule_id, String dir, AbstractListener listener, int reportId, ReportFilterConfig rfConfig, Long loginId, ArrayList trusteesList) {
        JRArrayList tempJRFileList = new JRArrayList();
        try {
            Locale locale = listener.getLocale();
            if (locale == null) {
                locale = I18NUtil.getDefaultLocale((Long)loginId);
            }
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getResourceBundle(locale);
            String reportFileName = (String)reportDetails.get("REPORT_FILE_NAME");
            String reportName = (String)reportDetails.get("REPORT_NAME");
            String productHome = System.getProperty("product.home");
            String tempJRReportFileName = null;
            if (productHome == null) {
                productHome = System.getProperty("server.home");
            }
            String basepath = productHome + File.separator + "bin" + File.separator + ".." + File.separator + "webapps" + File.separator + "adsm" + File.separator;
            reportFileName = basepath + "jasperreports" + File.separator + "jrxml" + File.separator + reportFileName;
            reportName = JRFieldDesignUtil.getReportName(reportName, rb);
            String tmpJRReportFilePrefix = productHome + File.separator + "temp" + File.separator + "jaspertemp" + File.separator + schedule_id + "_" + new Random().nextInt(1000) + "_";
            File file = new File(productHome + File.separator + "temp" + File.separator + "jaspertemp");
            file.mkdirs();
            ArrayList attributelist = rfConfig.getSelectedColumnsPropList();
            Properties sortColumnProp = rfConfig.getSortColumnProp();
            Integer attributeId = -1;
            String ascending = "true";
            int AddToPgNumber = 0;
            boolean isInline = ReportExportUtil.checkIsInline(schedule_id);
            if (!sortColumnProp.isEmpty()) {
                attributeId = (Integer)sortColumnProp.get("columnID");
                if (((String)sortColumnProp.get("sortBy")).equalsIgnoreCase("dsc")) {
                    ascending = "false";
                }
            }
            Properties attributeProp = ListenerUtil.getAttributeProp(attributeId, attributelist);
            Hashtable multipleValuesSids = null;
            ArrayList reportFilterTableNames = new ArrayList();
            ArrayList list = new ArrayList();
            Hashtable<String, ArrayList> tableLists = new Hashtable<String, ArrayList>();
            Hashtable<String, Hashtable> multiValuesList = new Hashtable<String, Hashtable>();
            Criteria reportColumnCrit = null;
            int exportCount = 0;
            for (int i = 0; i < trusteesList.size(); ++i) {
                Hashtable inputs = (Hashtable)trusteesList.get(i);
                Long value = (Long)inputs.get("INPUT_ID");
                String key = value.toString();
                String INPUT_NAME_KEY = inputs.containsKey("INPUT_NAME") ? "INPUT_NAME" : "INPUT_PROPERTY_VALUE";
                String inputName = (String)inputs.get(INPUT_NAME_KEY);
                multipleValuesSids = new Hashtable();
                attributeProp = ListenerUtil.getAttributeProp(attributeId, attributelist);
                Criteria reportFilterCrit = null;
                reportColumnCrit = null;
                Object reportResultCrit = null;
                reportFilterCrit = listener.getScheduledReportFilterCriteria(reportFilterCrit, rfConfig, reportFilterTableNames, key);
                reportColumnCrit = rfConfig.getColumnFilterCriteria(reportFilterTableNames, "", loginId, Integer.valueOf(reportId), reportDetails, listener.generationId, rb);
                list = listener.getRows(attributelist, attributeProp, new Boolean(ascending), -1, -1, multipleValuesSids, reportFilterCrit, reportColumnCrit, reportFilterTableNames);
                exportCount += list.size();
                ReportHandler.getMultipleValues((ArrayList)attributelist, multipleValuesSids, (String)listener.tableKey);
                ReportResultUtil.getCustomizedMultipleValues(multipleValuesSids);
                if (list.size() == 0) continue;
                tableLists.put(inputName, list);
                multiValuesList.put(inputName, multipleValuesSids);
            }
            listener.setExportRowCount(exportCount);
            if (reportList.equals("true")) {
                inputParams.put("title", rb.getString(listener.title));
            } else {
                inputParams.put("title", " ");
            }
            inputParams.put("Description", rb.getString("admp.reports_export.pageheader.description"));
            inputParams.put("Generated at", rb.getString("admp.reports_export.pageheader.generated_at"));
            inputParams.put("Page", rb.getString("admp.reports_export.pagefooter.page"));
            inputParams.put("isInline", isInline);
            if (reportType.toLowerCase().indexOf("xls") != -1) {
                inputParams.put("IS_IGNORE_PAGINATION", Boolean.TRUE);
            }
            JRArrayList tempJRReportList = new JRArrayList();
            if (reportType.toLowerCase().indexOf("csv") == -1) {
                tempJRReportFileName = productHome + File.separator + "temp" + File.separator + "jaspertemp" + File.separator + "SummaryReport_" + System.currentTimeMillis() + ".jrprint";
                tempJRFileList.add(tempJRReportFileName);
                JasperPrint jPrint = ReportExportInputUtil.insertSummaryReport(reportFileName, basepath, tempJRReportFileName, rfConfig.getScheduleId(), 535, inputParams, listener, reportType, loginId, null, rfConfig, null, reportColumnCrit, reportFilterTableNames, rb, locale, isInline);
                if (jPrint != null) {
                    tempJRReportList.add(jPrint);
                    AddToPgNumber = jPrint.getPages().size();
                }
            }
            ReportJRDataSource dataSource = null;
            Hashtable columnWidths = new Hashtable();
            ArrayList baseTables = null;
            int pageColumnWidth = -1;
            Hashtable exportParams = JRFieldDesignUtil.exportSettings();
            int k = 0;
            int continueSerialNo = 1;
            Enumeration e = tableLists.keys();
            while (e.hasMoreElements()) {
                JRDesignExpression express;
                Integer widthValue;
                String key = (String)e.nextElement();
                list = (ArrayList)tableLists.get(key);
                if (!multiValuesList.isEmpty()) {
                    multipleValuesSids = (Hashtable)multiValuesList.get(key);
                }
                JasperDesign jasperDesign = JRXmlLoader.load((String)reportFileName);
                jasperDesign.setName(EscapeUtil.escSplCharsAsHTML((Object)JRFieldDesignUtil.getReportName(reportName, rb)));
                if (isInline) {
                    ReportExportUtil.addEncodedLogoToInputParams(jasperDesign, inputParams);
                    inputParams.put("IS_IGNORE_PAGINATION", true);
                }
                JasperPrint print = new JasperPrint();
                JRFieldDesignUtil.alignBands(reportType, jasperDesign, inputParams);
                JRFieldDesignUtil.setPDFFontForPageHeaderTitleBand(reportType, jasperDesign, locale);
                JRDesignBand headerBand = (JRDesignBand)jasperDesign.getColumnHeader();
                JRDesignBand detailBand = (JRDesignBand)jasperDesign.getDetail();
                pageColumnWidth = jasperDesign.getColumnWidth();
                boolean flexWidth = true;
                String fixedExportWidth = (String)exportParams.get("FIXED_EXPORT_WIDTH");
                if (fixedExportWidth != null && fixedExportWidth.equalsIgnoreCase("TRUE")) {
                    flexWidth = false;
                    pageColumnWidth = JRFieldDesignUtil.getPageColumnWidth(exportParams, jasperDesign);
                }
                if ((widthValue = (Integer)(columnWidths = JRDesignUtil.calculateWidth(attributelist, list, multipleValuesSids, reportType, pageColumnWidth, flexWidth, JRFieldDesignUtil.getShowSerialNo(), rb)).remove("maxColumnWidth")) != null) {
                    pageColumnWidth = widthValue + (columnWidths.size() + 1) * 2;
                    jasperDesign.setColumnWidth(pageColumnWidth);
                    jasperDesign.setPageWidth(pageColumnWidth + 60);
                }
                if (reportType.toLowerCase().indexOf("xls") != -1 || reportType.toLowerCase().indexOf("csv") != -1) {
                    JRDesignBand pageHeader = (JRDesignBand)jasperDesign.getPageHeader();
                    express = new JRDesignExpression();
                    express.setValueClass(Boolean.class);
                    express.setText("$V{PAGE_NUMBER}.intValue() == 1 ? Boolean.TRUE : Boolean.FALSE");
                    pageHeader.setPrintWhenExpression((JRExpression)express);
                    if (reportType.toLowerCase().indexOf("csv") != -1 && k > 0) {
                        JRDesignBand columnHeader = new JRDesignBand();
                        columnHeader.setHeight(0);
                        jasperDesign.setColumnHeader((JRBand)columnHeader);
                    }
                }
                if (isInline) {
                    JRDesignBand pageFooter = (JRDesignBand)jasperDesign.getPageFooter();
                    express = new JRDesignExpression();
                    express.setValueClass(Boolean.class);
                    express.setText("Boolean.FALSE");
                    pageFooter.setPrintWhenExpression((JRExpression)express);
                    JRDesignBand pageHeader = (JRDesignBand)jasperDesign.getPageHeader();
                    JRDesignExpression headerExpress = new JRDesignExpression();
                    headerExpress.setValueClass(Boolean.class);
                    headerExpress.setText("Boolean.FALSE");
                    pageHeader.setPrintWhenExpression((JRExpression)headerExpress);
                }
                JasperReport jasperReport = null;
                try {
                    if (baseTables != null) {
                        JRDesignUtil.fillBand(columnWidths, jasperDesign, headerBand, detailBand, attributelist, reportType, (String)baseTables.get(k), 0, rb, loginId, JRFieldDesignUtil.getShowSerialNo(), locale);
                    } else {
                        JRDesignUtil.fillBand(columnWidths, jasperDesign, headerBand, detailBand, attributelist, reportType, null, 0, rb, loginId, JRFieldDesignUtil.getShowSerialNo(), locale);
                    }
                    jasperReport = JasperCompileManager.compileReport((JasperDesign)jasperDesign);
                    dataSource = reportType.toLowerCase().indexOf("csv") != -1 ? new ReportJRDataSource(list, multipleValuesSids, JRFieldDesignUtil.getShowSerialNo(), continueSerialNo, reportType) : new ReportJRDataSource(list, multipleValuesSids, JRFieldDesignUtil.getShowSerialNo(), STARTING_SERIAL_NUMBER, reportType);
                    if (reportList.equals("true")) {
                        inputParams.put("title", rb.getString(listener.title) + " : " + key);
                    } else {
                        inputParams.put("title", " ");
                    }
                    inputParams.put("Description", rb.getString("admp.reports_export.pageheader.description"));
                    inputParams.put("Generated at", rb.getString("admp.reports_export.pageheader.generated_at"));
                    inputParams.put("Page", rb.getString("admp.reports_export.pagefooter.page"));
                    inputParams.put("AddToPgNumber", AddToPgNumber);
                    print = JasperFillManager.fillReport((JasperReport)jasperReport, (Map)inputParams, (JRDataSource)dataSource);
                    continueSerialNo = dataSource.getSerialNo();
                    if (dataSource != null) {
                        dataSource = null;
                    }
                    key = JRFieldDesignUtil.getXlsxSheetName(key);
                    print.setName(key);
                    AddToPgNumber += print.getPages().size();
                    tempJRReportList.add(print);
                    print = null;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    System.out.println("Input Params After Filling " + inputParams);
                    boolean bl = false;
                    tempJRFileList.deleteJRFiles();
                    return bl;
                }
                ++k;
            }
            reportFileName = rfConfig.getReportFileName();
            reportFileName = reportFileName == null || reportFileName.equals("") ? reportName : JRFieldDesignUtil.applyReportFileNamePatterns(inputParams, reportFileName, reportName);
            if (reportFileName != null) {
                String reportFileName1 = reportFileName;
                Vector<String> v = new Vector<String>();
                String str1 = new String();
                for (int i = 0; i < reportFileName1.length(); ++i) {
                    char c = '/';
                    if (reportFileName1.charAt(i) == c) {
                        v.add(str1);
                        str1 = new String();
                        continue;
                    }
                    str1 = str1 + reportFileName1.charAt(i);
                }
                v.add(str1);
                String newreportFileName = "";
                for (int j = 0; j < v.size(); ++j) {
                    String name = (String)v.elementAt(j);
                    newreportFileName = newreportFileName + name;
                }
                reportFileName = newreportFileName;
            }
            try {
                ReportExportUtil.exportReport(reportType, tempJRReportList, reportFileName, loginId, locale, listener, schedule_id, dir, isInline);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                boolean bl = false;
                tempJRFileList.deleteJRFiles();
                return bl;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            tempJRFileList.deleteJRFiles();
        }
        return true;
    }

    public static void exportAllConfig(ArrayList exportViewsList, RVReqParams reqParams, ArrayList outputFilter, HttpServletResponse response, String storageDir, String exportType, DataObject rvcDataObject, AdventNetResourceBundle rb, boolean isForScheduler, boolean isIntersect, Map exportResult) throws Exception {
        ArrayList toBeZippedFiles = null;
        toBeZippedFiles = isIntersect ? ReportExportUtil.exportAllConfigForIntersect(exportViewsList, reqParams, outputFilter, exportType, rvcDataObject, storageDir, rb, isForScheduler) : ReportExportUtil.exportAllConfig(exportViewsList, reqParams, outputFilter, exportType, rvcDataObject, storageDir, rb, isForScheduler, exportResult);
        DataObject reportDO = ReportHandler.getReportDetails((Integer)reqParams.getReportId());
        Row row = reportDO.getFirstRow("ADSMReports");
        String resultFileName = rb.getString((String)row.get("REPORT_NAME"));
        String password = PasswordUtil.getExportFilePassword((Long)reqParams.getLoginId());
        ZipUtility.makeZip(storageDir, password, toBeZippedFiles, response);
    }

    public static ArrayList exportAllConfigForIntersect(ArrayList exportViewsList, RVReqParams reqParams, ArrayList outputFilter, String exportType, DataObject rvcDataObject, String storageDir, AdventNetResourceBundle rb, boolean isForScheduler) throws Exception {
        ArrayList<JSONObject> reqOutputFiltersList = new ArrayList<JSONObject>();
        ArrayList<String> toBeZippedFiles = new ArrayList<String>();
        ArrayList<JasperPrint> printList = new ArrayList<JasperPrint>();
        String rvFilterHeading = "admp.reports.common.common_export_page_heading_in";
        JSONObject obj = CVCDataUtil.getCheckBoxData((Long)reqParams.getCvcDataId());
        if (obj.has("IsExcludeNestedGroups")) {
            boolean isExcludeNestedGroups = (Boolean)obj.get("IsExcludeNestedGroups");
            rvFilterHeading = isExcludeNestedGroups ? "admp.reports.common.common_members_of_groups_with_exclude_nested_groups" : "admp.reports.common.common_members_of_groups_withOut_exclude_nested_groups";
        }
        for (int opFilterIndex = 0; opFilterIndex < outputFilter.size(); ++opFilterIndex) {
            Hashtable filterDetails = (Hashtable)outputFilter.get(opFilterIndex);
            long groupId = (Long)filterDetails.get("inputId");
            String filterObjectName = (String)filterDetails.get("objectName");
            JSONObject json = new JSONObject().put(String.valueOf(groupId), (Object)filterObjectName);
            reqOutputFiltersList.add(json);
        }
        for (int viewIndex = 0; viewIndex < exportViewsList.size(); ++viewIndex) {
            Hashtable viewConfig = (Hashtable)exportViewsList.get(viewIndex);
            ReportExportUtil.exportView(viewConfig, printList, "All", exportType, reqParams, rb, reqOutputFiltersList, rvcDataObject, rvFilterHeading, isForScheduler, new HashMap());
        }
        if (printList.size() > 0) {
            String fileName = ReportExportUtil.exportFile(printList, storageDir, exportType, "All", reqParams.getLoginId());
            toBeZippedFiles.add(fileName);
        }
        return toBeZippedFiles;
    }

    public static void exportView(Hashtable viewConfig, ArrayList<JasperPrint> printList, String filterObjectName, String exportType, RVReqParams reqParams, AdventNetResourceBundle rb, ArrayList reqOutputFiltersList, DataObject rvcDataObject, String rvFilterHeading, boolean isForScheduler, Map exportResult) throws Exception {
        String viewName = (String)viewConfig.get("filterName");
        reqParams.setFilterId(((Integer)viewConfig.get("filterId")).intValue());
        reqParams.setRvId(((Integer)viewConfig.get("rvId")).intValue());
        reqParams.setViewModelId(((Integer)viewConfig.get("viewModelId")).intValue());
        reqParams.setObjectIdList((JSONArray)viewConfig.get("objectIdList"));
        reqParams.setFilterFlagId(((Long)viewConfig.get("filterFlagId")).longValue());
        reqParams.setOutputFilters(reqOutputFiltersList);
        SelectionTableModel dataModel = (SelectionTableModel)RVHandler.getDataModel((AdventNetResourceBundle)rb, (RVReqParams)reqParams, (DataObject)rvcDataObject, (boolean)true, (boolean)isForScheduler);
        int exportCount = exportResult.get("exportCount") != null ? (Integer)exportResult.get("exportCount") : 0;
        int rowCount = dataModel.getRowCount();
        exportResult.put("exportCount", exportCount + rowCount);
        if (rowCount > 0) {
            String heading = MessageFormat.format(rb.getString(rvFilterHeading), viewName, filterObjectName);
            JasperPrint objectJRPrint = JasperDesignUtil.createJRPrintForView(dataModel, heading, rb, exportType, viewName, reqParams.getLoginId(), reqParams.getLocale());
            if (exportType.toLowerCase().indexOf("xls") != -1 || exportType.toLowerCase().indexOf("csv") != -1 || exportType.toLowerCase().indexOf("html") != -1) {
                printList.add(objectJRPrint);
            }
        }
    }

    public static String exportFile(ArrayList<JasperPrint> printList, String storageDir, String exportType, String filterObjectName, Long loginId) throws Exception {
        HashMap formatPatternMap = DateTimeUtil.getFormatPatternsMap((Long)loginId);
        String fileName = "";
        filterObjectName = CommonUtil.replaceFolderSplChars((String)filterObjectName);
        if (exportType.toLowerCase().indexOf("html") != -1) {
            fileName = storageDir + File.separator + filterObjectName + ".html";
            ReportExporter.getInstance().exportAsHtml(printList, fileName, (Map)null);
        } else if (exportType.toLowerCase().indexOf("xlsx") != -1) {
            fileName = storageDir + File.separator + filterObjectName + ".xlsx";
            ReportExporter.getInstance().exportAsExcelForXlsx(printList, fileName, formatPatternMap);
        } else if (exportType.toLowerCase().indexOf("xls") != -1) {
            System.out.println("inside xls report");
            fileName = storageDir + File.separator + filterObjectName + ".xls";
            ReportExporter.getInstance().exportAsExcel(printList, fileName);
        } else if (exportType.toLowerCase().indexOf("csv") != -1) {
            fileName = storageDir + File.separator + filterObjectName + ".csv";
            ReportExporter.getInstance().exportAsCsv(printList, fileName, loginId);
        } else {
            System.out.println("Invalid Report Type");
        }
        return fileName;
    }

    public static ArrayList exportAllConfig(ArrayList exportViewsList, RVReqParams reqParams, ArrayList outputFilter, String exportType, DataObject rvcDataObject, String storageDir, AdventNetResourceBundle rb, boolean isForScheduler, Map exportResult) throws Exception {
        ArrayList<JSONObject> reqOutputFiltersList = null;
        ArrayList<String> toBeZippedFiles = new ArrayList<String>();
        ArrayList<JasperPrint> printList = null;
        for (int opFilterIndex = 0; opFilterIndex < outputFilter.size(); ++opFilterIndex) {
            Hashtable filterDetails = (Hashtable)outputFilter.get(opFilterIndex);
            String filterObjectName = (String)filterDetails.get("objectName");
            reqOutputFiltersList = new ArrayList<JSONObject>();
            if (filterDetails.get("inputId") != null) {
                long groupId = (Long)filterDetails.get("inputId");
                JSONObject json = new JSONObject().put(String.valueOf(groupId), (Object)filterObjectName);
                reqOutputFiltersList.add(json);
            }
            printList = new ArrayList<JasperPrint>();
            for (int viewIndex = 0; viewIndex < exportViewsList.size(); ++viewIndex) {
                Hashtable viewConfig = (Hashtable)exportViewsList.get(viewIndex);
                String rvFilterHeading = (String)viewConfig.get("exportPageHeader");
                if (rvFilterHeading == null) {
                    rvFilterHeading = "admp.reports.common.export_page_heading_in";
                    JSONObject obj = CVCDataUtil.getCheckBoxData((Long)reqParams.getCvcDataId());
                    if (obj.has("IsExcludeNestedGroups")) {
                        boolean isExcludeNestedGroups = (Boolean)obj.get("IsExcludeNestedGroups");
                        rvFilterHeading = isExcludeNestedGroups ? "admp.reports.common.members_of_group_with_exclude_nested_groups" : "admp.reports.common.members_of_group_withOut_exclude_nested_groups";
                    }
                }
                ReportExportUtil.exportView(viewConfig, printList, filterObjectName, exportType, reqParams, rb, reqOutputFiltersList, rvcDataObject, rvFilterHeading, isForScheduler, exportResult);
            }
            if (printList.size() == 0) continue;
            String fileName = ReportExportUtil.exportFile(printList, storageDir, exportType, filterObjectName, reqParams.getLoginId());
            toBeZippedFiles.add(fileName);
        }
        return toBeZippedFiles;
    }

    public static void exportSingleConfig(Integer rvId, RVReqParams reqParams, ArrayList outputFilter, String exportType, HttpServletResponse response, DataObject rvcDO, String storageDir, AdventNetResourceBundle rb, boolean isForScheduler, Locale locale, Map exportResult) throws Exception {
        ArrayList<JasperPrint> printList = new ArrayList<JasperPrint>();
        Hashtable viewConfig = RVHandler.getViewsDetailsForExport((DataObject)rvcDO, (Integer)rvId, (AdventNetResourceBundle)rb);
        String viewName = (String)viewConfig.get("filterName");
        reqParams.setFilterId(((Integer)viewConfig.get("filterId")).intValue());
        reqParams.setRvId(rvId.intValue());
        reqParams.setViewModelId(((Integer)viewConfig.get("viewModelId")).intValue());
        reqParams.setObjectIdList((JSONArray)viewConfig.get("objectIdList"));
        reqParams.setFilterFlagId(((Long)viewConfig.get("filterFlagId")).longValue());
        SelectionTableModel dataModel = (SelectionTableModel)RVHandler.getDataModel((AdventNetResourceBundle)rb, (RVReqParams)reqParams, (DataObject)rvcDO, (boolean)true, (boolean)isForScheduler);
        exportResult.put("exportCount", dataModel.getRowCount());
        String rvFilterHeading = (String)viewConfig.get("exportPageHeader");
        JSONObject mgmtDetailsJsonObject = reqParams.getMgmtDetailsJson();
        if (mgmtDetailsJsonObject != null && mgmtDetailsJsonObject.has("exportHeading")) {
            rvFilterHeading = mgmtDetailsJsonObject.getString("exportHeading");
        }
        if (rvFilterHeading == null) {
            rvFilterHeading = "admp.reports.common.export_page_heading_in";
            JSONObject obj = CVCDataUtil.getCheckBoxData((Long)reqParams.getCvcDataId());
            if (obj.has("IsExcludeNestedGroups")) {
                boolean isExcludeNestedGroups = (Boolean)obj.get("IsExcludeNestedGroups");
                rvFilterHeading = isExcludeNestedGroups ? "admp.reports.common.members_of_group_with_exclude_nested_groups" : "admp.reports.common.members_of_group_withOut_exclude_nested_groups";
            }
        }
        String heading = MessageFormat.format(rb.getString(rvFilterHeading), viewName);
        String jrDesignName = viewName + "_" + System.currentTimeMillis();
        System.out.println("jrDesignName::" + jrDesignName);
        JasperPrint objectJRPrint = JasperDesignUtil.createJRPrintForView(dataModel, heading, rb, exportType, jrDesignName, reqParams.getLoginId(), locale);
        printList.add(objectJRPrint);
        HashMap formatPatternMap = DateTimeUtil.getFormatPatternsMap((Long)reqParams.getLoginId());
        String fileName = "";
        viewName = CommonUtil.replaceFolderSplChars((String)viewName);
        viewName = viewName.replace(' ', '_');
        if (exportType.toLowerCase().indexOf("html") != -1) {
            fileName = storageDir + File.separator + viewName + ".html";
            ReportExporter.getInstance().exportAsHtml(printList, fileName, (Map)null);
        } else if (exportType.toLowerCase().indexOf("xls") != -1) {
            fileName = storageDir + File.separator + viewName + ".xls";
            ReportExporter.getInstance().exportAsExcel(printList, fileName);
            response.setContentType("application/xls");
            response.setHeader("content-disposition", "inline;filename=" + viewName + ".xls");
        } else if (exportType.toLowerCase().indexOf("csv") != -1) {
            fileName = storageDir + File.separator + viewName + ".csv";
            ReportExporter.getInstance().exportAsCsv(printList, fileName, reqParams.getLoginId());
            response.setContentType("application/msexcel-comma");
            response.setHeader("content-disposition", "attachment;filename=" + viewName + ".csv");
        } else {
            System.out.println("Invalid Report Type");
            return;
        }
        byte[] buf = new byte[1024];
        try {
            String password = PasswordUtil.getExportFilePassword((Long)reqParams.getLoginId());
            if (password != null && !password.equals("")) {
                ArrayList<String> fileList = new ArrayList<String>();
                fileList.add(fileName);
                ZipUtility.makeZip(storageDir, password, fileList, response);
            } else {
                File file = new File(fileName);
                long length = file.length();
                BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
                ServletOutputStream out = response.getOutputStream();
                response.setContentLength((int)length);
                while (in != null && (length = (long)in.read(buf)) != -1L) {
                    out.write(buf, 0, (int)length);
                }
                in.close();
                out.close();
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    public static void exportAllConfig(ArrayList tabList, Hashtable reqParams, JSONObject searchProp, HashMap paramMap, HttpServletRequest request, HttpServletResponse response, String storageDir, String exportType, AdventNetResourceBundle rb, boolean isForScheduler, Map exportResult) throws Exception {
        ArrayList toBeZippedFiles = null;
        toBeZippedFiles = ReportExportUtil.exportAllConfig(tabList, reqParams, searchProp, paramMap, request, exportType, storageDir, rb, isForScheduler, exportResult);
        DataObject reportDO = ReportHandler.getReportDetails((Integer)((Integer)reqParams.get("reportId")));
        Row row = reportDO.getFirstRow("ADSMReports");
        String resultFileName = rb.getString((String)row.get("REPORT_NAME"));
        ZipUtility.zippedAndDeleteFiles(storageDir, toBeZippedFiles, response, resultFileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList exportAllConfig(ArrayList tabList, Hashtable reqParams, JSONObject searchProp, HashMap paramMap, HttpServletRequest request, String exportType, String storageDir, AdventNetResourceBundle rb, boolean isForScheduler, Map exportResult) throws Exception {
        Long loginId = null;
        Locale locale = I18NUtil.getDefaultLocale((HttpServletRequest)request);
        ArrayList<String> toBeZippedFiles = new ArrayList<String>();
        ArrayList<JasperPrint> printList = null;
        printList = new ArrayList<JasperPrint>();
        ArrayList summaryDetails = new ArrayList();
        JRArrayList tempJRReportList = new JRArrayList();
        for (int viewIndex = 0; viewIndex < tabList.size(); ++viewIndex) {
            Hashtable viewConfig = (Hashtable)tabList.get(viewIndex);
            ReportExportUtil.exportView(viewConfig, printList, summaryDetails, exportType, reqParams, rb, searchProp, isForScheduler, exportResult);
        }
        try {
            HttpSession session = request.getSession();
            loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            if (exportType.toLowerCase().indexOf("csv") == -1) {
                String basepath = request.getSession().getServletContext().getRealPath("/");
                String reportFilePath = basepath + "jasperreports" + File.separator + "jrxml" + File.separator + (String)reqParams.get("reportFileName");
                String reportName = (String)reqParams.get("REPORT_NAME");
                String productHome = System.getProperty("product.home");
                if (productHome == null) {
                    productHome = System.getProperty("server.home");
                }
                String tempJRReportFileName = productHome + File.separator + "temp" + File.separator + "jaspertemp" + File.separator + "SummaryReport_" + System.currentTimeMillis() + ".jrprint";
                File file = new File(productHome + File.separator + "temp" + File.separator + "jaspertemp");
                file.mkdirs();
                HashMap<String, String> inputParams = new HashMap<String, String>();
                inputParams.put("title", (String)reqParams.get("REPORT_NAME"));
                inputParams.put("desc", (String)paramMap.get("DESCRIPTION"));
                inputParams.put("Description", rb.getString("admp.reports_export.pageheader.description"));
                inputParams.put("Generated at", rb.getString("admp.reports_export.pageheader.generated_at"));
                inputParams.put("date", (String)paramMap.get("CREATION_TIME"));
                inputParams.put("Page", rb.getString("admp.reports_export.pagefooter.page"));
                JasperPrint jPrint = ReportExportInputUtil.insertSummaryReport(summaryDetails, reportFilePath, basepath, tempJRReportFileName, null, inputParams, exportType, loginId, rb, locale, false);
                printList.add(0, jPrint);
                tempJRReportList.add(tempJRReportFileName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            tempJRReportList.deleteJRFiles();
        }
        String fileName = ReportExportUtil.exportFile(printList, storageDir, exportType, "ADMPReport", (Long)reqParams.get("loginId"));
        toBeZippedFiles.add(fileName);
        return toBeZippedFiles;
    }

    public static void exportView(Hashtable tabProp, ArrayList<JasperPrint> printList, ArrayList summaryDetails, String exportType, Hashtable reqParams, AdventNetResourceBundle rb, JSONObject searchProp, boolean isForScheduler, Map exportResult) throws Exception {
        String viewName = (String)tabProp.get("TAB_NAME");
        Integer tabId = (Integer)tabProp.get("TAB_ID");
        reqParams.put("objectId", tabId);
        SelectionTableModel dataModel = (SelectionTableModel)CustomReportResultUtil.getDataModel(reqParams, (JSONObject)searchProp.get(Integer.toString(tabId)), rb);
        int exportCount = exportResult.get("exportCount") != null ? (Integer)exportResult.get("exportCount") : 0;
        int rowCount = dataModel.getRowCount();
        exportResult.put("exportCount", exportCount + rowCount);
        if (dataModel.getRowCount() > 0) {
            JasperPrint objectJRPrint = JasperDesignUtil.createJRPrintForView(dataModel, viewName, rb, exportType, viewName, (Long)reqParams.get("loginId"), (Locale)reqParams.get("locale"));
            if (exportType.toLowerCase().indexOf("xls") != -1 || exportType.toLowerCase().indexOf("csv") != -1 || exportType.toLowerCase().indexOf("html") != -1) {
                printList.add(objectJRPrint);
            }
        }
        Hashtable<String, Object> objectProp = new Hashtable<String, Object>();
        objectProp.put("OBJECT_NAME", viewName);
        objectProp.put("count", dataModel.getRowCount());
        summaryDetails.add(objectProp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportConfig(Hashtable tabProp, Hashtable reqParams, JSONObject searchProp, HashMap paramMap, HttpServletRequest request, HttpServletResponse response, String exportType, String storageDir, AdventNetResourceBundle rb, boolean isForScheduler, Map exportResult) throws Exception {
        JRArrayList tempJRReportList = new JRArrayList();
        Long loginId = null;
        Locale locale = I18NUtil.getDefaultLocale((HttpServletRequest)request);
        try {
            String productHome = System.getProperty("product.home");
            if (productHome == null) {
                productHome = System.getProperty("server.home");
            }
            HttpSession session = request.getSession();
            loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            String viewName = (String)tabProp.get("TAB_NAME");
            Integer tabId = (Integer)tabProp.get("TAB_ID");
            reqParams.put("objectId", tabId);
            SelectionTableModel dataModel = (SelectionTableModel)CustomReportResultUtil.getDataModel(reqParams, (JSONObject)searchProp.get(Integer.toString(tabId)), rb);
            exportResult.put("exportCount", dataModel.getRowCount());
            JasperPrint objectJRPrint = JasperDesignUtil.createJRPrintForView(dataModel, viewName, rb, exportType, viewName, (Long)reqParams.get("loginId"), locale, true);
            boolean showSerialNo = JRFieldDesignUtil.getShowSerialNo();
            Hashtable columnWidths = JasperDesignUtil.calculateWidth(dataModel, exportType, rb, showSerialNo);
            Integer widthValue = (Integer)columnWidths.remove("maxColumnWidth");
            String tempJRReportFileName = productHome + File.separator + "temp" + File.separator + "jaspertemp" + File.separator + "SummaryReport_" + System.currentTimeMillis() + ".jrprint";
            File file = new File(productHome + File.separator + "temp" + File.separator + "jaspertemp");
            file.mkdirs();
            if (exportType.toLowerCase().indexOf("csv") == -1) {
                String basepath = request.getSession().getServletContext().getRealPath("/");
                String reportFilePath = basepath + "jasperreports" + File.separator + "jrxml" + File.separator + (String)reqParams.get("reportFileName");
                String reportName = (String)reqParams.get("REPORT_NAME");
                HashMap<String, String> inputParams = new HashMap<String, String>();
                inputParams.put("title", (String)reqParams.get("REPORT_NAME"));
                inputParams.put("desc", (String)paramMap.get("DESCRIPTION"));
                inputParams.put("Description", rb.getString("admp.reports_export.pageheader.description"));
                inputParams.put("Generated at", rb.getString("admp.reports_export.pageheader.generated_at"));
                inputParams.put("date", (String)paramMap.get("CREATION_TIME"));
                inputParams.put("Page", rb.getString("admp.reports_export.pagefooter.page"));
                ArrayList summaryDetails = new ArrayList();
                Hashtable<String, Object> objectProp = new Hashtable<String, Object>();
                objectProp.put("OBJECT_NAME", viewName);
                objectProp.put("count", dataModel.getRowCount());
                summaryDetails.add(objectProp);
                JasperPrint jPrint = ReportExportInputUtil.insertSummaryReport(summaryDetails, reportFilePath, basepath, tempJRReportFileName, widthValue, inputParams, exportType, loginId, rb, locale, false);
                tempJRReportList.add(tempJRReportFileName);
            }
            String tmpJRReportFilePrefix = productHome + File.separator + "temp" + File.separator + "jaspertemp" + File.separator + "ExportReport_" + new Random().nextInt(1000) + "_";
            int tempJRReportListSize = tempJRReportList.size();
            tempJRReportFileName = tmpJRReportFilePrefix + tempJRReportListSize + ".jrprint";
            JRSaver.saveObject((Object)objectJRPrint, (String)tempJRReportFileName);
            tempJRReportList.add(tempJRReportFileName);
        }
        catch (Exception e) {
            e.printStackTrace();
            tempJRReportList.deleteJRFiles();
            return;
        }
        try {
            ReportExportUtil.exportReport(exportType, request, response, tempJRReportList, "ADMPReport", loginId, locale);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            tempJRReportList.deleteJRFiles();
        }
    }

    public static void exportConfig(ArrayList exportViewsList, RVReqParams reqParams, HttpServletRequest request, HttpServletResponse response, String exportType, DataObject rvcDataObject, String storageDir, AdventNetResourceBundle rb, boolean isForScheduler, Map exportResult) throws Exception {
        HttpSession session = request.getSession();
        Locale locale = I18NUtil.getDefaultLocale((HttpServletRequest)request);
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        Hashtable viewConfig = (Hashtable)exportViewsList.get(0);
        String viewName = rb.getString((String)viewConfig.get("filterName"));
        reqParams.setFilterId(((Integer)viewConfig.get("filterId")).intValue());
        reqParams.setRvId(((Integer)viewConfig.get("rvId")).intValue());
        reqParams.setViewModelId(((Integer)viewConfig.get("viewModelId")).intValue());
        reqParams.setObjectIdList((JSONArray)viewConfig.get("objectIdList"));
        reqParams.setFilterFlagId(((Long)viewConfig.get("filterFlagId")).longValue());
        SelectionTableModel dataModel = (SelectionTableModel)RVHandler.getDataModel((AdventNetResourceBundle)rb, (RVReqParams)reqParams, (DataObject)rvcDataObject, (boolean)true, (boolean)isForScheduler);
        exportResult.put("exportCount", dataModel.getRowCount());
        JasperPrint objectJRPrint = JasperDesignUtil.createJRPrintForView(dataModel, viewName, rb, exportType, viewName, reqParams.getLoginId(), locale, true);
        ReportExportUtil.exportReport(exportType, request, response, objectJRPrint, "ADMPReport", loginId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportConfig(ArrayList exportViewsList, RVReqParams reqParams, HttpServletRequest request, HttpServletResponse response, String exportType, DataObject rvcDataObject, String storageDir, AdventNetResourceBundle rb, boolean isForScheduler, Integer reportId, Map exportResult) throws Exception {
        JRArrayList tempJRReportList = new JRArrayList();
        int tempJRReportListSize = 0;
        try {
            int exportPerRowCount;
            HttpSession session = request.getSession();
            Locale locale = I18NUtil.getDefaultLocale((HttpServletRequest)request);
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            Hashtable viewConfig = (Hashtable)exportViewsList.get(0);
            String viewName = rb.getString((String)viewConfig.get("filterName"));
            reqParams.setFilterId(((Integer)viewConfig.get("filterId")).intValue());
            reqParams.setRvId(((Integer)viewConfig.get("rvId")).intValue());
            reqParams.setViewModelId(((Integer)viewConfig.get("viewModelId")).intValue());
            reqParams.setObjectIdList((JSONArray)viewConfig.get("objectIdList"));
            reqParams.setFilterFlagId(((Long)viewConfig.get("filterFlagId")).longValue());
            String productHome = System.getProperty("product.home");
            if (productHome == null) {
                productHome = System.getProperty("server.home");
            }
            String tmpJRReportFilePrefix = productHome + File.separator + "temp" + File.separator + "jaspertemp" + File.separator + new Random().nextInt(1000) + "_";
            File file = new File(productHome + File.separator + "temp" + File.separator + "jaspertemp");
            file.mkdirs();
            int fromIndex = reqParams.getFromIndex();
            SelectionTableModel dataModel = (SelectionTableModel)RVHandler.getDataModel((AdventNetResourceBundle)rb, (RVReqParams)reqParams, (DataObject)rvcDataObject, (boolean)true, (boolean)isForScheduler);
            Long count = dataModel.getTotalResultCount();
            exportResult.put("exportCount", count);
            Hashtable exportParams = JRFieldDesignUtil.exportSettings();
            int n = exportPerRowCount = exportParams.get("EXPORT_PER_ROW_COUNT") != null ? Integer.parseInt((String)exportParams.get("EXPORT_PER_ROW_COUNT")) : 0;
            int numberOfObjects = exportPerRowCount != 0 && exportPerRowCount != -1 ? exportPerRowCount : (exportType.toLowerCase().indexOf("xls") != -1 ? 20000 : 5000);
            boolean isSingleSheet = false;
            if (exportType.toLowerCase().indexOf("xls") != -1 && exportPerRowCount == -1) {
                isSingleSheet = true;
            }
            reqParams.setRange(numberOfObjects);
            JasperPrint objectJRPrint = null;
            JasperReport jasperReport = JasperDesignUtil.getJasperReportObject(dataModel, viewName, rb, exportType, viewName, reqParams.getLoginId(), locale, true, fromIndex, isSingleSheet);
            HashMap<String, Comparable<Boolean>> inputParams = new HashMap<String, Comparable<Boolean>>();
            boolean showSerialNo = JRFieldDesignUtil.getShowSerialNo();
            JasperReport jasperReport1 = null;
            int AddToPgNumber = 0;
            do {
                JRCustomTableDataSource dataSource = null;
                SelectionTableModel dataModelTemp = (SelectionTableModel)RVHandler.getDataModel((AdventNetResourceBundle)rb, (RVReqParams)reqParams, (DataObject)rvcDataObject, (boolean)true, (boolean)isForScheduler);
                if (fromIndex != 1 && jasperReport1 == null) {
                    jasperReport1 = JasperDesignUtil.getJasperReportObject(dataModel, viewName, rb, exportType, viewName, reqParams.getLoginId(), locale, true, fromIndex, isSingleSheet);
                }
                dataSource = new JRCustomTableDataSource(dataModelTemp, showSerialNo, fromIndex);
                if (exportType.equals("pdf") || exportType.equals("html")) {
                    inputParams.put("IS_IGNORE_PAGINATION", Boolean.FALSE);
                } else {
                    inputParams.put("IS_IGNORE_PAGINATION", Boolean.TRUE);
                }
                inputParams.put("AddToPgNumber", Integer.valueOf(AddToPgNumber));
                objectJRPrint = fromIndex == 1 ? JasperFillManager.fillReport((JasperReport)jasperReport, inputParams, (JRDataSource)dataSource) : JasperFillManager.fillReport((JasperReport)jasperReport1, inputParams, (JRDataSource)dataSource);
                AddToPgNumber += objectJRPrint.getPages().size();
                reqParams.setFromIndex(fromIndex += numberOfObjects);
                tempJRReportListSize = tempJRReportList.size();
                String tempJRReportFileName = tmpJRReportFilePrefix + tempJRReportListSize + ".jrprint";
                if (exportType.toLowerCase().indexOf("xls") != -1 && isSingleSheet) {
                    List pageList = objectJRPrint.getPages();
                    JasperPrint jasperPrintSingle = tempJRReportListSize == 0 ? objectJRPrint : (JasperPrint)tempJRReportList.get(0);
                    if (tempJRReportListSize >= 1) {
                        for (int pageNo = 0; pageNo < pageList.size(); ++pageNo) {
                            jasperPrintSingle.addPage((JRPrintPage)pageList.get(pageNo));
                        }
                    }
                    tempJRReportList.clear();
                    JRSaver.saveObject((Object)jasperPrintSingle, (String)tempJRReportFileName);
                } else {
                    JRSaver.saveObject((Object)objectJRPrint, (String)tempJRReportFileName);
                }
                tempJRReportList.add(tempJRReportFileName);
            } while (count >= (long)fromIndex);
            ReportExportUtil.exportReport(exportType, request, response, tempJRReportList, "ADMPReport", loginId, locale);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            tempJRReportList.deleteJRFiles();
        }
    }

    public static void exportReport(String reportType, HttpServletRequest request, HttpServletResponse response, JasperPrint print, String reportFileName, Long loginId) throws Exception {
        ReportExportUtil.exportReport(reportType, request, response, print, reportFileName, loginId, null);
    }

    public static void exportReport(String reportType, HttpServletRequest request, HttpServletResponse response, JasperPrint print, String reportFileName, Long loginId, AbstractListener listener) throws Exception {
        HashMap formatPatternMap = DateTimeUtil.getFormatPatternsMap((Long)loginId);
        Locale locale = I18NUtil.getDefaultLocale((HttpServletRequest)request);
        String password = PasswordUtil.getExportFilePassword((Long)loginId);
        ReportExporter exporter = new ReportExporter(reportType, password);
        if (reportType.toLowerCase().indexOf("pdf") != -1) {
            response.reset();
            exporter.exportAsPdf(print, reportFileName, response, locale);
        } else if (reportType.toLowerCase().indexOf("jpg") != -1) {
            exporter.exportAsJpeg(print, reportFileName, response);
        } else if (reportType.toLowerCase().indexOf("html") != -1) {
            reportLogger.log(Level.INFO, "The reportFileName in abs exportreport is : " + reportFileName);
            exporter.exportAsHtml(print, reportFileName, response, request.getSession());
        } else if (reportType.toLowerCase().indexOf("xlsx") != -1) {
            exporter.exportAsXlsx(print, reportFileName, response, formatPatternMap);
        } else if (reportType.toLowerCase().indexOf("xls") != -1) {
            exporter.exportAsXls(print, reportFileName, response);
            System.out.println("inside xls report");
        } else if (reportType.toLowerCase().indexOf("csv") != -1) {
            exporter.exportAsCsv(print, reportFileName, response, loginId);
        } else {
            reportLogger.log(Level.INFO, "Invalid Report Type");
        }
        if (listener != null) {
            listener.setExportFileName(exporter.getExportFile());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportReportWithSubReport(Row reportDetails, String reportType, ArrayList attributelist, Map inputParams, HttpServletRequest request, HttpServletResponse response, String reportList, AbstractListener listener, ArrayList trusteesList, ReportReqParams reqParams) {
        String productHome = System.getProperty("product.home");
        if (productHome == null) {
            productHome = System.getProperty("server.home");
        }
        String basepath = productHome + File.separator + "temp" + File.separator + "result_data" + File.separator;
        JRSwapFileVirtualizer virtualizer = null;
        try {
            String basepathForFile = request.getSession().getServletContext().getRealPath("/");
            String jasperDir = basepathForFile + "jasperreports" + File.separator + "jasper" + File.separator;
            JRSwapFile swapFile = new JRSwapFile(jasperDir, 1024, 100);
            virtualizer = new JRSwapFileVirtualizer(50, swapFile, true);
            attributelist = new ArrayList();
            String reportFileName = (String)reportDetails.get("REPORT_FILE_NAME");
            reportFileName = basepathForFile + "jasperreports" + File.separator + "jrxml" + File.separator + reportFileName;
            String reportName = (String)reportDetails.get("REPORT_NAME");
            String reportId = String.valueOf(reportDetails.get("REPORT_ID"));
            String type = request.getParameter("type");
            Locale locale = I18NUtil.getDefaultLocale((HttpServletRequest)request);
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            HttpSession session = request.getSession();
            ReportBean bean = (ReportBean)((Object)session.getAttribute("ReportBean"));
            ArrayList tableNames = new ArrayList();
            Criteria crit = null;
            ArrayList list = new ArrayList();
            int exportCount = 0;
            Hashtable columnWidths = new Hashtable();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            int currentJrPrintNo = 0;
            SubReportJRDataSource dataSource = null;
            JRArrayList printNameList = new JRArrayList();
            JasperDesign jasperDesign = JRXmlLoader.load((String)reportFileName);
            jasperDesign.setName(EscapeUtil.escSplCharsAsHTML((Object)JRFieldDesignUtil.getReportName(reportName, rb)));
            JasperPrint print = new JasperPrint();
            JRFieldDesignUtil.alignBands(reportType, jasperDesign, inputParams);
            JRFieldDesignUtil.setPDFFontForPageHeaderTitleBand(reportType, jasperDesign, locale);
            JRDesignBand headerBand = (JRDesignBand)jasperDesign.getColumnHeader();
            JRDesignBand detailBand = (JRDesignBand)jasperDesign.getDetail();
            JasperReport jasperReport = null;
            Properties sortAttributeProp = null;
            if (reportList.equals("true")) {
                attributelist = listener.getExportAttributesList();
                Integer sortAttributeId = reqParams.getSortAttribId();
                if (sortAttributeId != null && !sortAttributeId.equals(new Integer(-1)) && (sortAttributeProp = ListenerUtil.getAttributeProp(sortAttributeId, attributelist)) == null) {
                    sortAttributeId = ReportAttributesUtil.getDefaultSortingProp((Integer)Integer.parseInt(reportId), (ArrayList)attributelist);
                    sortAttributeProp = ListenerUtil.getAttributeProp(sortAttributeId, attributelist);
                }
            }
            inputParams.put("Description", rb.getString("admp.reports_export.pageheader.description"));
            inputParams.put("Generated at", rb.getString("admp.reports_export.pageheader.generated_at"));
            inputParams.put("Page", rb.getString("admp.reports_export.pagefooter.page"));
            inputParams.put("REPORT_VIRTUALIZER", virtualizer);
            ArrayList subReportsList = listener.getSubreportDetails();
            HashMap formatPatternMap = DateTimeUtil.getFormatPatternsMap((Long)loginId);
            boolean flexWidth = true;
            int pageColumnWidth = 0;
            if (reportList.equals("true")) {
                int i;
                for (i = 0; i < subReportsList.size(); ++i) {
                    Integer widthValue;
                    Properties prop = (Properties)subReportsList.get(i);
                    String subReportId = String.valueOf(prop.get("SUBREPORT_ID"));
                    String name = (String)prop.get("NAME");
                    String subreportFileName = (String)prop.get("FILE_NAME");
                    String heading = rb.getString((String)prop.get("HEADING"));
                    String subReportFile = basepathForFile + "jasperreports" + File.separator + "jrxml" + File.separator + subreportFileName;
                    String jasperFile = basepathForFile + "jasperreports" + File.separator + "jasper" + File.separator + name + ".jasper";
                    JasperDesign subJasperDesign = JRXmlLoader.load((String)subReportFile);
                    int columnWidth = subJasperDesign.getColumnWidth();
                    JRDesignBand hBand = (JRDesignBand)subJasperDesign.getColumnHeader();
                    JRDesignBand dBand = (JRDesignBand)subJasperDesign.getDetail();
                    subJasperDesign.setName(name);
                    ArrayList subAttributeList = listener.getSubReportAttributes(subReportId);
                    listener.updateAttributeList(bean, subAttributeList);
                    ArrayList rowList = ReportResultUtil.getSharesRows(subAttributeList, listener, rb);
                    exportCount += rowList.size();
                    Hashtable exportParams = JRFieldDesignUtil.exportSettings();
                    pageColumnWidth = subJasperDesign.getColumnWidth();
                    String fixedExportWidth = (String)exportParams.get("FIXED_EXPORT_WIDTH");
                    if (fixedExportWidth != null && fixedExportWidth.equalsIgnoreCase("TRUE")) {
                        flexWidth = false;
                        pageColumnWidth = JRFieldDesignUtil.getPageColumnWidth(exportParams, subJasperDesign);
                    }
                    if ((widthValue = (Integer)(columnWidths = JRDesignUtil.calculateWidth(subAttributeList, rowList, null, reportType, request, columnWidths, pageColumnWidth, flexWidth, rb)).remove("maxColumnWidth")) != null) {
                        pageColumnWidth = widthValue + (columnWidths.size() + 1) * 2;
                        subJasperDesign.setColumnWidth(pageColumnWidth);
                        subJasperDesign.setPageWidth(pageColumnWidth + 60);
                    }
                    JRDesignUtil.fillBandSubReport(columnWidths, subJasperDesign, hBand, dBand, subAttributeList, reportType, rb, loginId, locale, subReportFile, heading, flexWidth);
                    prop.put("ATTRIBUTE_LIST", subAttributeList);
                    prop.put("SUBREPORT_DESIGN", subJasperDesign);
                    JasperCompileManager.compileReportToFile((JasperDesign)subJasperDesign, (String)jasperFile);
                }
                if (flexWidth) {
                    jasperDesign.setColumnWidth(pageColumnWidth + 30);
                    jasperDesign.setPageWidth(pageColumnWidth + 125);
                }
                JRDesignUtil.fillBand(columnWidths, jasperDesign, headerBand, detailBand, attributelist, reportType, rb, loginId, locale, subReportsList);
                for (i = 0; i < trusteesList.size(); ++i) {
                    Hashtable inputs = (Hashtable)trusteesList.get(i);
                    Long value = (Long)inputs.get("INPUT_ID");
                    Long genId = (Long)inputs.get("REPORT_GENERATION_ID");
                    String key = value.toString();
                    String INPUT_NAME_KEY = inputs.containsKey("INPUT_NAME") ? "INPUT_NAME" : "INPUT_PROPERTY_VALUE";
                    String inputName = (String)inputs.get(INPUT_NAME_KEY);
                    jasperDesign.setName(inputName);
                    if (reportList.equals("true")) {
                        inputParams.put("title", rb.getString(listener.title) + " : " + inputName);
                    } else {
                        inputParams.put("title", " ");
                    }
                    ArrayList reportAttributelist = new ArrayList();
                    reportAttributelist = ReportAttributeHandler.getInstance().getViewColumn((Integer)bean.get("reportId"), loginId);
                    listener.updateAttributeList(bean, reportAttributelist);
                    crit = ReportResultUtil.getColumnSearchCriteria(reportAttributelist, reqParams, tableNames);
                    ArrayList sharesList = ReportResultUtil.getShares(value, genId, crit, sortAttributeProp, reqParams.isSortOrder());
                    exportCount += sharesList.size();
                    if (sharesList.size() == 0) continue;
                    list = listener.getExportData(sharesList, attributelist, subReportsList);
                    dataSource = new SubReportJRDataSource(list, rb);
                    jasperReport = JasperCompileManager.compileReport((JasperDesign)jasperDesign);
                    JasperFillManager.fillReportToFile((JasperReport)jasperReport, (String)(basepath + "NTFSJrPrint-" + currentJrPrintNo + ".jrprint"), (Map)inputParams, (JRDataSource)dataSource);
                    printNameList.add(basepath + "NTFSJrPrint-" + currentJrPrintNo + ".jrprint");
                    ++currentJrPrintNo;
                    if (dataSource == null) continue;
                    dataSource = null;
                }
            }
            listener.setExportRowCount(exportCount);
            reportFileName = "ADMPReport";
            request.setAttribute("reportFileName", (Object)reportFileName);
            String password = PasswordUtil.getExportFilePassword((Long)loginId);
            ReportExporter exporter = new ReportExporter(reportType, password);
            if (reportType.toLowerCase().indexOf("pdf") != -1) {
                response.reset();
                exporter.exportAsPdfWithHugeData(printNameList, reportFileName, response, locale);
            } else if (reportType.toLowerCase().indexOf("jpg") != -1) {
                exporter.exportAsJpeg(printNameList, reportFileName, response);
            } else if (reportType.toLowerCase().indexOf("html") != -1) {
                reportLogger.log(Level.INFO, "The reportFileName in abs exportreport is : " + reportFileName);
                if (type != null && type.equals("print")) {
                    exporter.exportAsHtmlWithHugeData(printNameList, reportFileName, response, request.getSession(), false);
                } else {
                    exporter.exportAsHtmlWithHugeData(printNameList, reportFileName, response, request.getSession(), true);
                }
            } else if (reportType.toLowerCase().indexOf("xls") != -1) {
                exporter.exportAsXlsWithHugeData(printNameList, reportFileName, response, formatPatternMap, reportType);
            } else if (reportType.toLowerCase().indexOf("csv") != -1) {
                exporter.exportAsCsvWithHugeData(printNameList, reportFileName, response, loginId);
            } else {
                reportLogger.log(Level.INFO, "Invalid Report Type");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (virtualizer != null) {
                virtualizer.cleanup();
            }
        }
    }

    public static void exportReportForHugeData(Row reportDetails, String reportType, ArrayList attributelist, Map inputParams, HttpServletRequest request, HttpServletResponse response, String reportList, AbstractListener listener, ArrayList trusteesList, ReportReqParams reqParams) {
        String productHome = System.getProperty("product.home");
        if (productHome == null) {
            productHome = System.getProperty("server.home");
        }
        String basepath = productHome + File.separator + "temp" + File.separator + "result_data" + File.separator;
        try {
            String reportFileName = (String)reportDetails.get("REPORT_FILE_NAME");
            String basepathForFile = request.getSession().getServletContext().getRealPath("/");
            reportFileName = basepathForFile + "jasperreports" + File.separator + "jrxml" + File.separator + reportFileName;
            String reportName = (String)reportDetails.get("REPORT_NAME");
            Locale locale = I18NUtil.getDefaultLocale((HttpServletRequest)request);
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            HttpSession session = request.getSession();
            ReportBean bean = (ReportBean)((Object)session.getAttribute("ReportBean"));
            Integer attributeId = reqParams.getSortAttribId();
            if (attributeId == null || attributeId.equals(new Integer(-1))) {
                attributeId = ReportAttributesUtil.getDefaultSortingProp((Integer)((Integer)bean.get("reportId")), (ArrayList)attributelist);
            }
            Properties attributeProp = null;
            Hashtable multipleValuesSids = null;
            ArrayList tableNames = new ArrayList();
            Criteria crit = null;
            ArrayList list = new ArrayList();
            Object baseTables = null;
            Hashtable<String, ArrayList> tableLists = new Hashtable<String, ArrayList>();
            Hashtable multiValuesList = new Hashtable();
            Hashtable columnWidths = new Hashtable();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            int rangeStart = 1;
            int noOfObjects = 30000;
            boolean k = false;
            int currentJrPrintNo = 0;
            int totalNoOfRows = 0;
            ReportJRDataSource dataSource = null;
            ArrayList printList = new ArrayList();
            JRArrayList printNameList = new JRArrayList();
            JasperDesign jasperDesign = JRXmlLoader.load((String)reportFileName);
            jasperDesign.setName(JRFieldDesignUtil.getReportName(reportName, rb));
            JasperPrint print = new JasperPrint();
            JRFieldDesignUtil.alignBands(reportType, jasperDesign, inputParams);
            JRFieldDesignUtil.setPDFFontForPageHeaderTitleBand(reportType, jasperDesign, locale);
            JRDesignBand headerBand = (JRDesignBand)jasperDesign.getColumnHeader();
            JRDesignBand detailBand = (JRDesignBand)jasperDesign.getDetail();
            JasperReport jasperReport = null;
            if (reportList.equals("true") && listener.getResultTableName().equalsIgnoreCase("ADSMACLsReportResult")) {
                attributelist = ReportAttributeHandler.getInstance().getExportColumns(attributelist, (Integer)bean.get("reportId"));
            }
            inputParams.put("Description", rb.getString("admp.reports_export.pageheader.description"));
            inputParams.put("Generated at", rb.getString("admp.reports_export.pageheader.generated_at"));
            inputParams.put("Page", rb.getString("admp.reports_export.pagefooter.page"));
            HashMap formatPatternMap = DateTimeUtil.getFormatPatternsMap((Long)loginId);
            if (reportList.equals("true")) {
                int AddToPgNumber;
                String tempJRReportFileName;
                if (listener.getResultTableName().equalsIgnoreCase("ADSMACLsReportResult")) {
                    tempJRReportFileName = null;
                    AddToPgNumber = 0;
                    if (reportType.toLowerCase().indexOf("csv") == -1) {
                        tempJRReportFileName = basepath + "SummaryReport_" + System.currentTimeMillis() + ".jrprint";
                        String productBasePath = productHome + File.separator + "bin" + File.separator + ".." + File.separator + "webapps" + File.separator + "adsm" + File.separator;
                        inputParams.put("title", rb.getString(listener.title));
                        crit = ReportResultUtil.getColumnSearchCriteria(attributelist, reqParams, tableNames);
                        JasperPrint jPrint = ReportExportInputUtil.insertSummaryReport(reportFileName, productBasePath, tempJRReportFileName, null, 535, inputParams, listener, reportType, loginId, reqParams, null, null, crit, tableNames, rb, locale, false);
                        AddToPgNumber = jPrint.getPages().size();
                        JRSaver.saveObject((Object)jPrint, (String)tempJRReportFileName);
                        printNameList.add(tempJRReportFileName);
                    }
                    tableNames = new ArrayList();
                    for (int i = 0; i < trusteesList.size(); ++i) {
                        Integer widthValue;
                        rangeStart = 1;
                        noOfObjects = 30000;
                        Hashtable inputs = (Hashtable)trusteesList.get(i);
                        Long value = (Long)inputs.get("INPUT_ID");
                        String key = value.toString();
                        String INPUT_NAME_KEY = inputs.containsKey("INPUT_NAME") ? "INPUT_NAME" : "INPUT_PROPERTY_VALUE";
                        String inputName = (String)inputs.get(INPUT_NAME_KEY);
                        if (reportList.equals("true")) {
                            inputParams.put("title", rb.getString(listener.title) + " : " + inputName);
                        } else {
                            inputParams.put("title", " ");
                        }
                        attributelist = ReportAttributeHandler.getInstance().getExportColumns(attributelist, (Integer)bean.get("reportId"));
                        listener.updateAttributeList(bean, attributelist);
                        attributeProp = ListenerUtil.getAttributeProp(attributeId, attributelist);
                        crit = ReportResultUtil.getColumnSearchCriteria(attributelist, reqParams, tableNames);
                        crit = listener.getReportFilterCriteria(crit, reqParams, tableNames);
                        crit = listener.getReportResultFilterCriteria(request, bean, crit, key);
                        multipleValuesSids = new Hashtable();
                        list = listener.getACERows(attributelist, attributeProp, new Boolean(reqParams.isSortOrder()), rangeStart, noOfObjects, multipleValuesSids, crit);
                        Hashtable exportParams = JRFieldDesignUtil.exportSettings();
                        int pageColumnWidth = jasperDesign.getColumnWidth();
                        boolean flexWidth = true;
                        String fixedExportWidth = (String)exportParams.get("FIXED_EXPORT_WIDTH");
                        if (fixedExportWidth != null && fixedExportWidth.equalsIgnoreCase("TRUE")) {
                            flexWidth = false;
                            pageColumnWidth = JRFieldDesignUtil.getPageColumnWidth(exportParams, jasperDesign);
                        }
                        if ((widthValue = (Integer)(columnWidths = JRDesignUtil.calculateWidth(attributelist, list, multipleValuesSids, reportType, request, columnWidths, pageColumnWidth, flexWidth, JRFieldDesignUtil.getShowSerialNo(), rb)).remove("maxColumnWidth")) != null) {
                            pageColumnWidth = widthValue + (columnWidths.size() + 1) * 2;
                            jasperDesign.setColumnWidth(pageColumnWidth);
                            jasperDesign.setPageWidth(pageColumnWidth + 60);
                        }
                        if (i == 0) {
                            JRDesignUtil.fillBand(columnWidths, jasperDesign, headerBand, detailBand, attributelist, reportType, null, 0, rb, loginId, JRFieldDesignUtil.getShowSerialNo(), locale);
                        }
                        jasperReport = JasperCompileManager.compileReport((JasperDesign)jasperDesign);
                        while (!list.isEmpty()) {
                            totalNoOfRows += list.size();
                            tableLists.put(inputName, list);
                            if (multipleValuesSids == null) {
                                multipleValuesSids = new Hashtable();
                            }
                            dataSource = new ReportJRDataSource(list, multipleValuesSids, JRFieldDesignUtil.getShowSerialNo(), rangeStart, reportType);
                            String tempPrintName = basepath + "NTFSJrPrint-" + currentJrPrintNo + ".jrprint";
                            inputParams.put("AddToPgNumber", AddToPgNumber);
                            print = JasperFillManager.fillReport((JasperReport)jasperReport, (Map)inputParams, (JRDataSource)dataSource);
                            JRSaver.saveObject((Object)print, (String)tempPrintName);
                            AddToPgNumber += print.getPages().size();
                            printNameList.add(tempPrintName);
                            ++currentJrPrintNo;
                            if (dataSource != null) {
                                dataSource = null;
                            }
                            multipleValuesSids = new Hashtable();
                            list = listener.getACERows(attributelist, attributeProp, new Boolean(reqParams.isSortOrder()), rangeStart += noOfObjects, noOfObjects, multipleValuesSids, crit);
                            columnWidths = JRDesignUtil.calculateWidth(attributelist, list, multipleValuesSids, reportType, request, columnWidths, pageColumnWidth, flexWidth, JRFieldDesignUtil.getShowSerialNo(), rb);
                        }
                    }
                } else {
                    tempJRReportFileName = null;
                    AddToPgNumber = 0;
                    if (reportType.toLowerCase().indexOf("csv") == -1) {
                        tempJRReportFileName = basepath + "SummaryReport_" + System.currentTimeMillis() + ".jrprint";
                        String productBasePath = productHome + File.separator + "bin" + File.separator + ".." + File.separator + "webapps" + File.separator + "adsm" + File.separator;
                        inputParams.put("title", rb.getString(listener.title));
                        Criteria columnSearchCriteria = ReportResultUtil.getColumnSearchCriteria(attributelist, reqParams, tableNames);
                        JasperPrint jPrint = ReportExportInputUtil.insertSummaryReport(reportFileName, productBasePath, tempJRReportFileName, null, 535, inputParams, listener, reportType, loginId, reqParams, null, null, columnSearchCriteria, tableNames, rb, locale, false);
                        AddToPgNumber = jPrint.getPages().size();
                        JRSaver.saveObject((Object)jPrint, (String)tempJRReportFileName);
                        printNameList.add(tempJRReportFileName);
                    }
                    tableNames = new ArrayList();
                    for (int i = 0; i < trusteesList.size(); ++i) {
                        rangeStart = 1;
                        Hashtable inputs = (Hashtable)trusteesList.get(i);
                        Long value = (Long)inputs.get("INPUT_ID");
                        String key = value.toString();
                        String INPUT_NAME_KEY = inputs.containsKey("INPUT_NAME") ? "INPUT_NAME" : "INPUT_PROPERTY_VALUE";
                        String inputName = (String)inputs.get(INPUT_NAME_KEY);
                        jasperDesign.setName(inputName);
                        if (reportList.equals("true")) {
                            inputParams.put("title", rb.getString(listener.title) + " : " + inputName);
                        } else {
                            inputParams.put("title", " ");
                        }
                        multipleValuesSids = new Hashtable();
                        attributeProp = ListenerUtil.getAttributeProp(attributeId, attributelist);
                        Criteria columnSearchCriteria = ReportResultUtil.getColumnSearchCriteria(attributelist, reqParams, tableNames);
                        Criteria resultTableCriteria = listener.getReportResultFilterCriteria(request, bean, crit, key);
                        list = listener.getRows(attributelist, attributeProp, new Boolean(reqParams.isSortOrder()), rangeStart, noOfObjects, multipleValuesSids, resultTableCriteria, columnSearchCriteria, new ArrayList());
                        ReportHandler.getMultipleValues((ArrayList)attributelist, multipleValuesSids, (String)listener.tableKey);
                        ReportResultUtil.getCustomizedMultipleValues(multipleValuesSids);
                        try {
                            Integer widthValue;
                            Hashtable exportParams = JRFieldDesignUtil.exportSettings();
                            int pageColumnWidth = jasperDesign.getColumnWidth();
                            boolean flexWidth = true;
                            String fixedExportWidth = (String)exportParams.get("FIXED_EXPORT_WIDTH");
                            if (fixedExportWidth != null && fixedExportWidth.equalsIgnoreCase("TRUE")) {
                                flexWidth = false;
                                pageColumnWidth = JRFieldDesignUtil.getPageColumnWidth(exportParams, jasperDesign);
                            }
                            if ((widthValue = (Integer)(columnWidths = JRDesignUtil.calculateWidth(attributelist, list, multipleValuesSids, reportType, request, columnWidths, pageColumnWidth, flexWidth, JRFieldDesignUtil.getShowSerialNo(), rb)).remove("maxColumnWidth")) != null) {
                                pageColumnWidth = widthValue + (columnWidths.size() + 1) * 2;
                                jasperDesign.setColumnWidth(pageColumnWidth);
                                jasperDesign.setPageWidth(pageColumnWidth + 60);
                            }
                            if (i == 0) {
                                JRDesignUtil.fillBand(columnWidths, jasperDesign, headerBand, detailBand, attributelist, reportType, null, 0, rb, loginId, JRFieldDesignUtil.getShowSerialNo(), locale);
                            }
                            jasperReport = JasperCompileManager.compileReport((JasperDesign)jasperDesign);
                            while (!list.isEmpty()) {
                                totalNoOfRows += list.size();
                                dataSource = new ReportJRDataSource(list, multipleValuesSids, JRFieldDesignUtil.getShowSerialNo(), rangeStart, reportType);
                                String tempPrintName = basepath + "NTFSJrPrint-" + currentJrPrintNo + ".jrprint";
                                inputParams.put("AddToPgNumber", AddToPgNumber);
                                print = JasperFillManager.fillReport((JasperReport)jasperReport, (Map)inputParams, (JRDataSource)dataSource);
                                JRSaver.saveObject((Object)print, (String)tempPrintName);
                                AddToPgNumber += print.getPages().size();
                                printNameList.add(tempPrintName);
                                ++currentJrPrintNo;
                                if (dataSource != null) {
                                    dataSource = null;
                                }
                                multipleValuesSids = null;
                                list = listener.getRows(attributelist, attributeProp, new Boolean(reqParams.isSortOrder()), rangeStart += noOfObjects, noOfObjects, multipleValuesSids, resultTableCriteria, columnSearchCriteria, new ArrayList());
                                columnWidths = JRDesignUtil.calculateWidth(attributelist, list, multipleValuesSids, reportType, request, columnWidths, pageColumnWidth, flexWidth, JRFieldDesignUtil.getShowSerialNo(), rb);
                            }
                            continue;
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            System.out.println("Input Params After Filling " + inputParams);
                            return;
                        }
                    }
                }
            } else {
                crit = ReportResultUtil.getSIDCriteria(bean, listener.mgmtResultTableName);
                list = ReportResultUtil.getModifyRows(listener.mgmtGenerationId, listener.baseTableName, listener.mgmtResultTableName, attributelist, null, new Boolean(reqParams.isSortOrder()), -1, -1, multipleValuesSids, crit);
                totalNoOfRows += list.size();
                columnWidths = JRDesignUtil.calculateWidth(attributelist, list, multipleValuesSids, reportType, request, rb);
                dataSource = new ReportJRDataSource(list, multipleValuesSids, reportType);
                JasperFillManager.fillReportToFile(jasperReport, (String)(basepath + "NTFSJrPrint-" + currentJrPrintNo + ".jrprint"), (Map)inputParams, (JRDataSource)dataSource);
                printNameList.add(basepath + "NTFSJrPrint-" + currentJrPrintNo + ".jrprint");
                ++currentJrPrintNo;
            }
            listener.setExportRowCount(totalNoOfRows);
            reportFileName = "ADMPReport";
            request.setAttribute("reportFileName", (Object)reportFileName);
            String password = PasswordUtil.getExportFilePassword((Long)loginId);
            ReportExporter exporter = new ReportExporter(reportType, password);
            if (reportType.toLowerCase().indexOf("pdf") != -1) {
                response.reset();
                exporter.exportAsPdfWithHugeData(printNameList, reportFileName, response, locale);
            } else if (reportType.toLowerCase().indexOf("jpg") != -1) {
                exporter.exportAsJpeg(printNameList, reportFileName, response);
            } else if (reportType.toLowerCase().indexOf("html") != -1) {
                reportLogger.log(Level.INFO, "The reportFileName in abs exportreport is : " + reportFileName);
                if (totalNoOfRows > 30000) {
                    exporter.exportAsHtmlWithHugeData(printNameList, reportFileName, response, request.getSession(), true);
                } else {
                    exporter.exportAsHtmlWithHugeData(printNameList, reportFileName, response, request.getSession(), false);
                }
            } else if (reportType.toLowerCase().indexOf("xls") != -1) {
                exporter.exportAsXlsWithHugeData(printNameList, reportFileName, response, formatPatternMap, reportType);
            } else if (reportType.toLowerCase().indexOf("csv") != -1) {
                exporter.exportAsCsvWithHugeData(printNameList, reportFileName, response, loginId);
            } else {
                reportLogger.log(Level.INFO, "Invalid Report Type");
            }
            printNameList.deleteJRFiles();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportDelayedTask(Hashtable viewConfig, RVReqParams reqParams, String exportType, DataObject rvcDataObject, AdventNetResourceBundle rb, Boolean isExport, HttpServletRequest request, HttpServletResponse response, Long loginId) {
        JRArrayList tempJRReportList = new JRArrayList();
        Locale locale = I18NUtil.getDefaultLocale((HttpServletRequest)request);
        try {
            String viewName = (String)viewConfig.get("filterName");
            String header = rb.getString((String)viewConfig.get("exportPageHeader"));
            header = header + " : " + viewName;
            String productHome = System.getProperty("product.home");
            if (productHome == null) {
                productHome = System.getProperty("server.home");
            }
            String tmpJRReportFilePrefix = productHome + File.separator + "temp" + File.separator + "jaspertemp" + File.separator + new Random().nextInt(1000) + "_";
            File file = new File(productHome + File.separator + "temp" + File.separator + "jaspertemp");
            file.mkdirs();
            SelectionTableModel dataModel = (SelectionTableModel)RVHandler.getDataModel((AdventNetResourceBundle)rb, (RVReqParams)reqParams, (DataObject)rvcDataObject, (boolean)true, (boolean)isExport);
            Long count = dataModel.getTotalResultCount();
            int fromIndex = reqParams.getFromIndex();
            int tempFileSize = 0;
            Hashtable columnWidths = JasperDesignUtil.calculateWidth(dataModel, exportType, rb, true);
            JasperReport jasperReport = JasperDesignUtil.getJasperReportObject(dataModel, header, rb, exportType, viewName, reqParams.getLoginId(), locale, true, fromIndex, false);
            JRCustomTableDataSource dataSource = new JRCustomTableDataSource(dataModel, true, fromIndex);
            HashMap<String, Object> inputParams = new HashMap<String, Object>();
            int AddToPgNumber = 0;
            if (exportType.equals("pdf") || exportType.equals("html")) {
                inputParams.put("IS_IGNORE_PAGINATION", Boolean.FALSE);
            } else {
                inputParams.put("IS_IGNORE_PAGINATION", Boolean.TRUE);
            }
            inputParams.put("Description", rb.getString("admp.reports_export.pageheader.description"));
            inputParams.put("Generated at", rb.getString("admp.reports_export.pageheader.generated_at"));
            inputParams.put("AddToPgNumber", AddToPgNumber);
            JasperPrint objectJRPrint = JasperFillManager.fillReport((JasperReport)jasperReport, inputParams, (JRDataSource)dataSource);
            String tempJRReportFileName = tmpJRReportFilePrefix + tempFileSize++ + ".jrprint";
            JRSaver.saveObject((Object)objectJRPrint, (String)tempJRReportFileName);
            tempJRReportList.add(tempJRReportFileName);
            ReportExportUtil.exportReport(exportType, request, response, tempJRReportList, "ADMPReport", loginId, locale);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            tempJRReportList.deleteJRFiles();
        }
    }

    public static void exportReporter(String format, ArrayList printList, String reportFileName, HttpServletResponse response, HttpServletRequest request, Locale locale, String[] sheetNames, Long loginId) {
        try {
            String password = PasswordUtil.getExportFilePassword((Long)loginId);
            ReportExporter exporter = new ReportExporter(format.toLowerCase(), password);
            if (format.toLowerCase().indexOf("pdf") != -1) {
                exporter.exportAsPdf(printList, reportFileName, response, locale);
            } else if (format.toLowerCase().indexOf("xlsx") != -1) {
                if (sheetNames != null) {
                    exporter.exportAsXlsxSheets(printList, reportFileName, response, sheetNames);
                } else {
                    exporter.exportAsXlsx(printList, reportFileName, response);
                }
            } else if (format.toLowerCase().indexOf("html") != -1) {
                String type = request.getParameter("type");
                if (type != null && type.equalsIgnoreCase("print")) {
                    exporter.exportAsHtml(printList, reportFileName, response, request.getSession());
                } else {
                    exporter.exportAsHtmlWithHugeData(printList, reportFileName, response, request.getSession(), true);
                }
            } else if (format.toLowerCase().indexOf("xls") != -1) {
                exporter.exportAsXls(printList, reportFileName, response);
            } else if (format.toLowerCase().indexOf("csv") != -1) {
                exporter.exportAsCsv(printList, reportFileName, response, (Long)request.getSession().getAttribute("ADMP_SESSION_LOGIN_ID"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setIamAppsDelegationDetails(RVReqParams reqParams, ADMPAuthObject authObj, String customParams, int iamAppId) {
        String waadTenantId = "";
        ArrayList delegatedO365Domains = new ArrayList();
        boolean applyOURestriction = false;
        try {
            JSONObject custParams = new JSONObject(customParams);
            if (custParams.has("waadAccountId")) {
                waadTenantId = custParams.getString("waadAccountId");
            }
        }
        catch (JSONException ex) {
            reportLogger.log(Level.INFO, "json exception occurred while setting authorized domains in reqParams");
        }
        if (waadTenantId.length() > 0) {
            int[] iamAppIds = new int[]{iamAppId};
            delegatedO365Domains = authObj.getDelegatedIamAppDomains(waadTenantId, iamAppIds);
            if (iamAppId == 3) {
                ArrayList objectIdList = CVCUtil.getObjectIdList((Long)reqParams.getCvcDataId());
                applyOURestriction = objectIdList.size() > 0 && (Integer)objectIdList.get(0) == 7 ? authObj.getApplyOURestriction(waadTenantId, "group").booleanValue() : authObj.getApplyOURestriction(waadTenantId, "user").booleanValue();
            }
        }
        reqParams.setApplyOURestriction(Boolean.valueOf(applyOURestriction));
        if (applyOURestriction) {
            reqParams.setAuthOUList(O365DelegationUtil.getAuthorizedOUList((ADMPAuthObject)authObj, (String)waadTenantId));
        }
        reqParams.setDelegatedO365Domains(delegatedO365Domains);
    }

    public static void exportReport(String reportType, HttpServletRequest request, HttpServletResponse response, JRArrayList tempJRReportList, String reportFileName, Long loginId, Locale locale) throws Exception {
        ReportExportUtil.exportReport(reportType, request, response, tempJRReportList, reportFileName, loginId, locale, null);
    }

    public static void exportReport(String reportType, HttpServletRequest request, HttpServletResponse response, JRArrayList tempJRReportList, String reportFileName, Long loginId, Locale locale, AbstractListener listener) throws Exception {
        String password = PasswordUtil.getExportFilePassword((Long)loginId);
        ReportExporter exporter = new ReportExporter(reportType, password);
        if (reportType.toLowerCase().indexOf("pdf") != -1) {
            response.reset();
            exporter.exportAsPdf((ArrayList)tempJRReportList, reportFileName, response, locale);
        } else if (reportType.toLowerCase().indexOf("jpg") != -1) {
            exporter.exportAsJpeg(tempJRReportList, reportFileName, response);
        } else if (reportType.toLowerCase().indexOf("html") != -1) {
            reportLogger.log(Level.INFO, "The reportFileName in abs exportreport is : " + reportFileName);
            exporter.exportAsHtml(tempJRReportList, reportFileName, response, request.getSession());
        } else if (reportType.toLowerCase().indexOf("xlsx") != -1) {
            HashMap formatPatternMap = DateTimeUtil.getFormatPatternsMap((Long)loginId);
            exporter.exportAsXlsx(tempJRReportList, reportFileName, response, formatPatternMap);
        } else if (reportType.toLowerCase().indexOf("xls") != -1) {
            exporter.exportAsXls(tempJRReportList, reportFileName, response);
            System.out.println("inside xls report");
        } else if (reportType.toLowerCase().indexOf("csv") != -1) {
            exporter.exportAsCsv(tempJRReportList, reportFileName, response, loginId);
        } else {
            reportLogger.log(Level.INFO, "Invalid Report Type");
        }
        if (listener != null) {
            listener.setExportFileName(exporter.getExportFile());
        }
    }

    public static void exportReport(String reportType, JRArrayList tempJRReportList, String reportFileName, Long loginId, Locale locale, AbstractListener listener, Long schedule_id, String dir, boolean isInline) throws Exception {
        String password = PasswordUtil.getExportFilePassword((Long)loginId);
        ReportExporter exporter = new ReportExporter(reportType, password);
        if (reportType.toLowerCase().indexOf("pdf") != -1) {
            exporter.exportAsPdf(tempJRReportList, reportFileName, schedule_id, dir, loginId, locale);
        } else if (reportType.toLowerCase().indexOf("jpg") == -1) {
            if (reportType.toLowerCase().indexOf("html") != -1) {
                if (isInline) {
                    exporter.exportAsInlineHTML(tempJRReportList, reportFileName, schedule_id, dir);
                } else {
                    exporter.exportAsHTML(tempJRReportList, reportFileName, schedule_id, dir);
                }
            } else if (reportType.toLowerCase().indexOf("xlsx") != -1) {
                HashMap formatPatternMap = DateTimeUtil.getFormatPatternsMap((Long)DelegationUtil.ADMIN_LOGIN_ID);
                exporter.exportAsXLSX(tempJRReportList, reportFileName, schedule_id, dir, formatPatternMap);
            } else if (reportType.toLowerCase().indexOf("xls") != -1) {
                exporter.exportAsXls(tempJRReportList, reportFileName, schedule_id, dir);
            } else if (reportType.toLowerCase().indexOf("csv") != -1) {
                exporter.exportAsCSV(tempJRReportList, reportFileName, schedule_id, dir, loginId);
            } else {
                reportLogger.log(Level.INFO, "Invalid Report Type");
            }
        }
        if (listener != null) {
            listener.setExportFileName(exporter.getExportFile());
        }
    }
}

