/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.reports;

import com.adventnet.sym.adsm.common.server.DBQueue;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.webclient.reports.AbstractListener;
import com.adventnet.sym.adsm.common.webclient.reports.ListenerUtil;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ReportThread
extends Thread {
    private static Logger reportLogger = Logger.getLogger("ReportLogger");
    private ArrayList containerList = null;
    private ArrayList attributeList = null;
    private AbstractListener listener = null;
    private Hashtable dnDomainNameMap = null;
    private Hashtable excludeChildOUHash = null;
    private Long loginId = null;
    private AdventNetResourceBundle rb = null;

    public ReportThread(AdventNetResourceBundle rb, Long loginId, ArrayList list, ArrayList attributeList, AbstractListener li, Hashtable map, Hashtable excludeChildOUHash) {
        this.loginId = loginId;
        this.containerList = list;
        this.attributeList = attributeList;
        this.listener = li;
        this.dnDomainNameMap = map;
        this.excludeChildOUHash = excludeChildOUHash;
        this.rb = rb;
    }

    @Override
    public void run() {
        this.listener.initializeActionVariables();
        Hashtable tableProps = ListenerUtil.getQueueProps(this.listener);
        for (int i = 0; i < this.containerList.size(); ++i) {
            try {
                String dn = (String)this.containerList.get(i);
                String domainName = (String)this.dnDomainNameMap.get(dn);
                if (domainName != null) {
                    Boolean isExcludeChildOU = Boolean.FALSE;
                    if (this.excludeChildOUHash != null && this.excludeChildOUHash.containsKey(dn)) {
                        isExcludeChildOU = (Boolean)this.excludeChildOUHash.get(dn);
                    }
                    this.listener.setDomainName(domainName);
                    this.listener.setIsExcludeChildOU(isExcludeChildOU);
                    DBQueue.getInstance().registerForUpdation(this.listener.baseTableName, this.listener.getGenerationId(), tableProps);
                    reportLogger.log(Level.INFO, "Getting the Empty Groups from the domain " + domainName);
                    this.listener.doAction(domainName, this.loginId, dn, this.attributeList, this.listener);
                    this.listener.updateQueue();
                    continue;
                }
                System.out.println("Error - Selected OU has been moved in Ad manually" + dn);
                continue;
            }
            catch (LocalizedException e) {
                e.printStackTrace();
                this.listener.setErrorMessage(e.getMessage(this.rb));
                this.listener.setErrorMessageKeys(e.getErrorMsgString());
                System.out.println("LocalizedException: - " + this.listener.errorMessage);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.listener.setErrorMessage(e.getMessage());
            }
        }
        reportLogger.log(Level.INFO, "Completed the Reports Count : " + this.listener.totalCount);
        this.listener.completedAction();
    }
}

