/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.reports;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.automation.ReportFilterConfig;
import com.adventnet.sym.adsm.common.server.customview.ColumnConfiguration;
import com.adventnet.sym.adsm.common.server.delegation.DelegationUtil;
import com.adventnet.sym.adsm.common.server.delegation.TechnicianHandler;
import com.adventnet.sym.adsm.common.server.helpdesk.ADMPAuthObject;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.mail.SendMailAPI;
import com.adventnet.sym.adsm.common.server.popup.datamodel.PopupTableDataModel;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DomainUtil;
import com.adventnet.sym.adsm.common.server.util.I18NUtil;
import com.adventnet.sym.adsm.common.server.util.LicenseMgr;
import com.adventnet.sym.adsm.common.server.util.SchedulerHandler;
import com.adventnet.sym.adsm.common.server.util.SchedulerLicenseUtil;
import com.adventnet.sym.adsm.common.server.util.SchedulerUtil;
import com.adventnet.sym.adsm.common.server.wengine.SchedulerRunNowObject;
import com.adventnet.sym.adsm.common.webclient.reports.SchedulerBean;
import com.adventnet.sym.adsm.common.webclient.util.ClientAuthorizationUtil;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import com.adventnet.sym.adsm.common.webclient.util.SchedulerInputsUtil;
import com.adventnet.sym.adsm.common.webclient.workflow.SchedulerExecution;
import com.adventnet.sym.adsm.common.webclient.workflow.SchedulerOperationHandler;
import java.io.File;
import java.io.PrintWriter;
import java.net.URI;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;
import org.apache.struts.validator.DynaValidatorForm;
import org.json.JSONArray;
import org.json.JSONObject;

public class SchedulerAction
extends DispatchAction {
    private static Logger out = Logger.getLogger(SchedulerAction.class.getName());
    private static int[] UserReports = new int[]{1, 2, 3, 5, 15};
    private static int[] SystemReports = new int[]{201, 202, 203, 204, 210};
    private static int[] OtherReports = new int[]{101, 109, 701, 503};

    public ActionForward schedulerCreation(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (ClientAuthorizationUtil.isAuthorized(request, 31512L).booleanValue()) {
            Locale locale = request.getLocale();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            String forwardPage = "schedulerCreation";
            Long taskId = SchedulerUtil.getTaskID((String)"ScheduleSelectedReports");
            String isLicensed = LicenseMgr.getInstance().getLicenseProperty("Scheduler", "Scheduler");
            String runNow = request.getParameter("Run_Now");
            try {
                String sch_id;
                SchedulerBean bean = (SchedulerBean)form;
                String operation = request.getParameter("operation");
                String init = request.getParameter("init");
                if (init != null && init.equalsIgnoreCase("true")) {
                    bean.set("action", null);
                    forwardPage = "schedulerCreation";
                }
                String action = (String)bean.get("action");
                if (operation == null) {
                    bean.initialize(mapping);
                    bean.init(loginId, request);
                }
                Long schedule_id = 0L;
                JSONObject time = new JSONObject();
                JSONArray timeArray = new JSONArray();
                int day = 0;
                int date = 0;
                int hours = 0;
                int minutes = 0;
                Hashtable<String, Object> customProp = new Hashtable<String, Object>();
                String scheduleType = (String)bean.get("repSchedule");
                String attachment_type = (String)bean.get("enableAttach");
                attachment_type = attachment_type != null && attachment_type.equalsIgnoreCase("link") ? "LINK" : (attachment_type != null && attachment_type.equalsIgnoreCase("inlinehtml") ? "inlinehtml" : (String)bean.get("mailType"));
                bean.set("mailType", attachment_type);
                if (scheduleType.equalsIgnoreCase("daily")) {
                    hours = (Integer)bean.get("dailysel1");
                    minutes = (Integer)bean.get("dailysel2");
                    timeArray.put(hours);
                    timeArray.put(minutes);
                    time.put("client.reports.SchedulerAction.daily", (Object)timeArray);
                } else if (scheduleType.equalsIgnoreCase("weekly")) {
                    String[] weekDays = new String[]{"", "admp.common.days.sunday", "admp.common.days.monday", "admp.common.days.tuesday", "admp.common.days.wednesday", "admp.common.days.thursday", "admp.common.days.friday", "admp.common.days.saturday"};
                    day = (Integer)bean.get("weeklysel1");
                    hours = (Integer)bean.get("dailysel1");
                    minutes = (Integer)bean.get("dailysel2");
                    timeArray.put((Object)weekDays[day]);
                    timeArray.put(hours);
                    timeArray.put(minutes);
                    time.put("client.reports.SchedulerAction.weekly_on", (Object)timeArray);
                } else if (scheduleType.equalsIgnoreCase("monthly")) {
                    date = (Integer)bean.get("monthsel1");
                    hours = (Integer)bean.get("dailysel1");
                    minutes = (Integer)bean.get("dailysel2");
                    timeArray.put(date);
                    timeArray.put(hours);
                    timeArray.put(minutes);
                    time.put("client.reports.SchedulerAction.monthly_on", (Object)timeArray);
                } else if (scheduleType.equalsIgnoreCase("hourly")) {
                    hours = (Integer)bean.get("dailysel1");
                    timeArray.put(hours);
                    time.put("client.reports.SchedulerAction.for_each", (Object)timeArray);
                } else if (scheduleType.equalsIgnoreCase("Custom")) {
                    hours = (Integer)bean.get("dailysel1");
                    minutes = (Integer)bean.get("dailysel2");
                    String startingDate = (String)bean.get("startDate");
                    String freqType = (String)bean.get("frequency");
                    String repType = (String)bean.get("repeatType");
                    if (freqType.equals("repnone")) {
                        repType = freqType;
                    }
                    int repInterval = (Integer)bean.get("repeatInterval");
                    String monthdaydate = (String)bean.get("monthdaydate");
                    if (monthdaydate.equalsIgnoreCase("date")) {
                        customProp.put("dayofmonth", bean.get("monthsel2"));
                    } else {
                        customProp.put("weekofmonth", bean.get("weekofmonth"));
                        customProp.put("dayofweek", bean.get("weeklysel2"));
                    }
                    customProp.put("monthdaydate", monthdaydate);
                    customProp.put("repType", repType);
                    customProp.put("skipFrequency", repInterval);
                    customProp.put("selectedDays", bean.get("selectedDayValues"));
                    customProp.put("selectedMonths", bean.get("selectedMonthValues"));
                    customProp.put("startingDate", startingDate);
                    time = SchedulerInputsUtil.getTimeString(repType, repInterval, startingDate, hours, minutes, (String)bean.get("selectedDayValues"), monthdaydate, (Integer)bean.get("monthsel2"), (Integer)bean.get("weekofmonth"), (Integer)bean.get("weeklysel2"), (String)bean.get("selectedMonthValues"), rb);
                }
                bean.set("time", time.toString());
                String schedulerName = (String)bean.get("SCHEDULER_NAME");
                if (action != null) {
                    if (action.equalsIgnoreCase("Create")) {
                        if (isLicensed.equalsIgnoreCase("true") && operation != null && runNow != null) {
                            if (!SchedulerInputsUtil.checkForDuplicateScheduler(schedulerName)) {
                                try {
                                    SchedulerLicenseUtil.checkSchedulerRestriction((String)"Scheduler", (AdventNetResourceBundle)rb);
                                    String statMessage = rb.getString("client.reports.SchedulerAction.successfully_created_the_scheduler");
                                    schedule_id = SchedulerHandler.createScheduler((String)schedulerName, (String)scheduleType, (int)hours, (int)minutes, (int)day, (int)date, (String)"ScheduleSelectedReports", customProp);
                                    bean.set("scheduleId", schedule_id.toString());
                                    SchedulerInputsUtil.addSchedulerDetails(bean, request, loginId, false);
                                    System.out.println("Successfully created the scheduler with id : " + schedule_id);
                                    bean.init(loginId, request);
                                    if (runNow.equals("true")) {
                                        Long taskInstanceId = SchedulerUtil.getTaskInstanceId((Long)schedule_id);
                                        if (taskInstanceId != null) {
                                            SchedulerExecution task = new SchedulerExecution(taskInstanceId, taskId, I18NUtil.getDefaultLocale((HttpServletRequest)request));
                                            task.start();
                                        }
                                        statMessage = rb.getString("admp.reports.sche_reports.statmsg.new_scheduler_created_successfully_execution_started");
                                    }
                                    request.setAttribute("Status", (Object)statMessage);
                                }
                                catch (Exception e) {
                                    out.log(Level.INFO, "Exception occurs while adding new scheduler" + e.getMessage());
                                    request.setAttribute("Status", (Object)rb.getString(e.getMessage()));
                                }
                            } else {
                                request.setAttribute("Status", (Object)rb.getString("admp.reports.sched_reports.sch_create.info.scheduler_already_exist"));
                            }
                        }
                        forwardPage = "CreateScheduler";
                    } else if (action.equalsIgnoreCase("Edit")) {
                        sch_id = request.getParameter("schedule_id");
                        if (sch_id != null) {
                            bean.set("scheduleId", sch_id);
                        }
                        sch_id = (String)bean.get("scheduleId");
                        Hashtable<String, ArrayList> domainOUList = (Hashtable<String, ArrayList>)bean.get("domainOUList");
                        Hashtable excludedOUList = (Hashtable)bean.get("excludedOUList");
                        Hashtable domainVsExcludeChildOU = (Hashtable)bean.get("domainVsExcludeChildOU");
                        Hashtable selectedOUList = new Hashtable();
                        String[] domains = (String[])bean.get("domainNames");
                        if (operation == null) {
                            boolean custom = SchedulerUtil.isCustomScheduler((Long)Long.parseLong(sch_id), (String)"ADSMScheduler");
                            String scheduleTypes = SchedulerUtil.getScheduleType((Long)Long.parseLong(sch_id));
                            bean.init(loginId, request);
                            SchedulerInputsUtil.setValues(scheduleTypes, Long.parseLong(sch_id), custom, bean);
                            bean.set("scheduleId", sch_id);
                            bean.set("domains", SchedulerInputsUtil.getDomainName(Long.parseLong(sch_id)));
                            domainOUList = new Hashtable<String, ArrayList>();
                            String[] selectDomains = (String[])bean.get("domains");
                            for (int i = 0; i < selectDomains.length; ++i) {
                                domainOUList.put(DomainUtil.getDefaultNamingContext((String)selectDomains[i]), SchedulerUtil.getSchedulerContainers((Long)Long.parseLong(sch_id), (String)selectDomains[i]));
                                excludedOUList.put(selectDomains[i], SchedulerUtil.getSchedulerExcludedContainers((Long)Long.parseLong(sch_id), (String)selectDomains[i]));
                                domainVsExcludeChildOU.put(selectDomains[i], SchedulerUtil.getSchedulerExcludeChildContainers((Long)Long.parseLong(sch_id), (String)selectDomains[i]));
                            }
                            bean.set("domainOUList", domainOUList);
                            bean.set("excludedOUList", excludedOUList);
                            bean.set("domainVsExcludeChildOU", domainVsExcludeChildOU);
                            if (sch_id != null) {
                                ArrayList SchedulerDetails = SchedulerUtil.getSchedulerDetails((Long)Long.parseLong(sch_id));
                                Hashtable mailSettings = SchedulerUtil.getMailSendingSettings((Long)Long.parseLong(sch_id), (String)"ADSMScheduler");
                                bean.set("mailSettings", mailSettings);
                                bean.set("SchedulerDetails", SchedulerDetails);
                                bean.set("formats", SchedulerUtil.getReportType((Long)Long.parseLong(sch_id)));
                            }
                            forwardPage = "CreateScheduler";
                        } else if (operation.equalsIgnoreCase(rb.getString("admp.reports.schedule_reports.scheduler_creation.update"))) {
                            boolean Status = SchedulerHandler.updateScheduler((Long)Long.valueOf(sch_id), (String)schedulerName, (String)scheduleType, (int)hours, (int)minutes, (int)day, (int)date, customProp);
                            if (Status) {
                                SchedulerInputsUtil.addSchedulerDetails(bean, request, loginId, true);
                                request.setAttribute("Status", (Object)rb.getString("client.reports.SchedulerAction.successfully_updated_the_scheduler"));
                                System.out.println("Successfully updated the scheduler with id : " + sch_id);
                            }
                            forwardPage = "schedulerCreation";
                        }
                    } else if (action.equalsIgnoreCase("Disable")) {
                        SchedulerHandler.enableDisableScheduler((Long)Long.valueOf(request.getParameter("schedule_id")), (Long)taskId, (int)4);
                    } else if (action.equalsIgnoreCase("Enable")) {
                        Long scheduleId = Long.valueOf(request.getParameter("schedule_id"));
                        boolean isLicensedExceeded = SchedulerLicenseUtil.isSchedulerModuleLicensed((AdventNetResourceBundle)rb);
                        boolean isDefaultSchedule = SchedulerUtil.isDefaultScheduler((Long)scheduleId);
                        if (isDefaultSchedule || isLicensedExceeded) {
                            SchedulerHandler.enableDisableScheduler((Long)scheduleId, (Long)taskId, (int)3);
                        } else {
                            out.log(Level.INFO, "As License Rescrition cant able to enable the scheduler reports. " + isLicensedExceeded);
                            request.setAttribute("Status", (Object)rb.getString("admp.reports.sche_reports.statmsg.error_in_enabling_scheduler_pls_purchase_additional_tech_pack"));
                        }
                    } else if (action.equalsIgnoreCase("Delete")) {
                        SchedulerHandler.deleteScheduler((Long)Long.valueOf(request.getParameter("schedule_id")), null);
                    }
                }
                if (operation != null && operation.equalsIgnoreCase("setOUs")) {
                    sch_id = request.getParameter("schedule_id");
                    if (sch_id != null) {
                        bean.set("scheduleId", sch_id);
                    }
                    sch_id = (String)bean.get("scheduleId");
                    forwardPage = SchedulerInputsUtil.setOUSForScheduler(bean, sch_id);
                    request.setAttribute("isReload", (Object)true);
                }
                if (isLicensed.equalsIgnoreCase("false")) {
                    request.setAttribute("Status", (Object)rb.getString("admp.reports.sche_reports.common.license_error"));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return mapping.findForward(forwardPage);
        }
        return null;
    }

    public ActionForward schedulerAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String action = request.getParameter("action");
        Long scheduleId = Long.valueOf(request.getParameter("schedule_id"));
        String messageType = "Success";
        String statusMessage = "Success";
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        Long taskId = 1L;
        taskId = SchedulerUtil.getTaskIDFromSchedulerID((Long)scheduleId);
        try {
            if (SchedulerUtil.isActionsAllowedForScheduler((Long)scheduleId, (Long)loginId, (String)action).booleanValue() && !action.equalsIgnoreCase("Copy")) {
                if (action.equalsIgnoreCase("Disable")) {
                    SchedulerHandler.enableDisableScheduler((Long)scheduleId, (Long)taskId, (int)4);
                } else if (action.equalsIgnoreCase("Enable")) {
                    boolean isLicensedExceeded = SchedulerLicenseUtil.isSchedulerModuleLicensed((AdventNetResourceBundle)rb);
                    boolean isDefaultSchedule = SchedulerUtil.isDefaultScheduler((Long)scheduleId);
                    System.out.println("Defaut " + isDefaultSchedule + " islicens " + isLicensedExceeded);
                    if (isDefaultSchedule || isLicensedExceeded) {
                        SchedulerHandler.enableDisableScheduler((Long)scheduleId, (Long)taskId, (int)3);
                    } else {
                        out.log(Level.INFO, "As License Rescrition cant able to enable the scheduler reports. " + isLicensedExceeded);
                        messageType = "Error";
                        statusMessage = rb.getString("admp.reports.sche_reports.statmsg.error_in_enabling_scheduler_pls_purchase_additional_tech_pack");
                    }
                } else if (action.equalsIgnoreCase("Delete")) {
                    SchedulerHandler.deleteScheduler((Long)scheduleId, null);
                    SchedulerRunNowObject runNowObj = SchedulerRunNowObject.getInstanceForAutomation();
                    runNowObj.setCompletedStatusForDeletedSchedule(scheduleId);
                }
            } else if (action.equalsIgnoreCase("Copy")) {
                if (!SchedulerInputsUtil.checkForDuplicateScheduler(request.getParameter("scheduleName"))) {
                    SchedulerHandler.copyScheduler((Long)scheduleId, (String)request.getParameter("scheduleName"), (Long)loginId);
                } else {
                    messageType = "Error";
                    statusMessage = rb.getString("admp.reports.sched_reports.sch_create.info.scheduler_already_exist");
                }
            } else {
                messageType = "Error";
                statusMessage = rb.getString("admp.reports.sche_report.action.access_denied.donot_have_access_to_do_this_opertaion");
            }
        }
        catch (Exception e) {
            messageType = "Error";
            statusMessage = e.getLocalizedMessage();
            e.printStackTrace();
        }
        ClientUtil.setStatusXMLElement(response, messageType, statusMessage);
        return null;
    }

    public ActionForward scheduledReports(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String forwardPage = "scheduledReportDetails";
        ArrayList scheduledReportDetails = new ArrayList();
        HttpSession session = request.getSession();
        try {
            SchedulerBean bean = (SchedulerBean)form;
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            bean.init(loginId, request);
            scheduledReportDetails = SchedulerInputsUtil.getScheduledReportDetails(loginId, null);
            request.setAttribute("scheduledReportDetails", (Object)scheduledReportDetails);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward(forwardPage);
    }

    public ActionForward sendTestMail(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            Locale locale = request.getLocale();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            String mailId = request.getParameter("mailids");
            ArrayList<String> v = new ArrayList<String>();
            StringTokenizer token = new StringTokenizer(mailId, ",");
            while (token.hasMoreElements()) {
                String s = (String)token.nextElement();
                v.add(s);
            }
            String acKnowledge = SendMailAPI.sendAttachedMail(v, null, null, null, (AdventNetResourceBundle)rb, null, null, null, (Long)0L);
            if (acKnowledge.equalsIgnoreCase("admp.reports.schedule_report.statmsg.sending_failed")) {
                acKnowledge = "admp.reports.schedule_report.alert.sending_failed";
            }
            SchedulerInputsUtil.getMsgXMLElement(response, rb.getString(acKnowledge));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward getReportInputDiv(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ReportFilterConfig reportFilterConfig = null;
        try {
            reportFilterConfig = new ReportFilterConfig(request.getParameter("reportObjJSONTxt"));
            reportFilterConfig.init();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        request.setAttribute("ReportFilterConfig", (Object)reportFilterConfig);
        return mapping.findForward("ReportInputDiv");
    }

    public ActionForward getReportFilterDiv(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ReportFilterConfig reportFilterConfig = null;
        try {
            reportFilterConfig = new ReportFilterConfig(request.getParameter("reportObjJSONTxt"));
            reportFilterConfig.init();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        request.setAttribute("ReportFilterConfig", (Object)reportFilterConfig);
        return mapping.findForward("ReportFilterDiv");
    }

    public ActionForward getReportObj(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            Locale locale = request.getLocale();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            PrintWriter writer = response.getWriter();
            Integer reportId = Integer.valueOf(request.getParameter("reportID"));
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            JSONObject report = new JSONObject();
            ReportFilterConfig rfConfig = new ReportFilterConfig();
            rfConfig.setRb(rb);
            Long scheduleId = null;
            rfConfig.init(reportId, scheduleId, loginId);
            report = rfConfig.serializeToJsonObject();
            writer.print(report.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward getSelectedReportsDetail(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            Locale locale = request.getLocale();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            Long scheduleID = Long.valueOf(request.getParameter("schedulerID"));
            PrintWriter writer = response.getWriter();
            JSONObject selectedReports = new JSONObject();
            if (SchedulerUtil.isActionsAllowedForScheduler((Long)scheduleID, (Long)loginId).booleanValue()) {
                JSONArray selectedReportsDetail = SchedulerUtil.getSelectedReportsDetail((Long)scheduleID, (AdventNetResourceBundle)rb, (Long)loginId);
                selectedReports.put("selectedReports", (Object)selectedReportsDetail);
                writer.print(ClientUtil.htmlEscape(selectedReports.toString()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward getSelectedOUs(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            JSONObject selectedOUs = new JSONObject();
            HttpSession session = request.getSession();
            String domainDN = request.getParameter("domainName");
            String domainName = DomainUtil.getDomainName((String)domainDN);
            DynaValidatorForm bean = (DynaValidatorForm)session.getAttribute("SchedulerBean");
            ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
            Hashtable domainVsactions = authObject.getDomainActionMap();
            ArrayList authDomainList = HDTDomainHandler.getDomainListForUser((Long)((Long)session.getAttribute("ADMP_SESSION_LOGIN_ID")), (Hashtable)domainVsactions, (Long)DelegationUtil.REPORT_TAB_ACTION_ID);
            ArrayList authOUList = new ArrayList();
            for (int i = 0; i < authDomainList.size(); ++i) {
                Properties domainProp = (Properties)authDomainList.get(i);
                if (!domainProp.getProperty("DEFAULT_NAMING_CONTEXT").equalsIgnoreCase(domainDN)) continue;
                authOUList = (ArrayList)domainProp.get("ouList");
                break;
            }
            Hashtable domainOUList = (Hashtable)bean.get("domainOUList");
            ArrayList selectedOUList = (ArrayList)domainOUList.get(domainDN);
            JSONArray selectedOUsArray = new JSONArray();
            for (int j = 0; j < selectedOUList.size(); ++j) {
                JSONObject selectedOU = new JSONObject();
                String OUDistinguishedName = (String)selectedOUList.get(j);
                String OUDisplayName = ClientUtil.getOUName(domainName, authOUList, OUDistinguishedName);
                selectedOU.put("OUDistinguishedName", (Object)OUDistinguishedName);
                selectedOU.put("OUDisplayName", (Object)OUDisplayName);
                selectedOUsArray.put((Object)selectedOU);
            }
            selectedOUs.put(domainDN, (Object)selectedOUsArray);
            PrintWriter writer = response.getWriter();
            writer.print(selectedOUs.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward reportInputs(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("ReportInputs");
    }

    public ActionForward isDuplicateScheduler(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            PrintWriter writer = response.getWriter();
            JSONObject duplicateStatus = new JSONObject();
            String schedulerID = request.getParameter("schedulerID");
            String schedulerName = request.getParameter("schedulerName");
            String schedulerAction = request.getParameter("schedulerAction");
            if (schedulerAction.equalsIgnoreCase("Create")) {
                duplicateStatus.put("isDuplicate", SchedulerInputsUtil.checkForDuplicateScheduler(schedulerName));
            } else {
                String prevSchName = SchedulerUtil.getSchedulerName((long)Long.valueOf(schedulerID));
                if (!schedulerName.equalsIgnoreCase(prevSchName)) {
                    duplicateStatus.put("isDuplicate", SchedulerInputsUtil.checkForDuplicateScheduler(schedulerName));
                } else {
                    duplicateStatus.put("isDuplicate", false);
                }
            }
            writer.print(duplicateStatus.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward updateHomeReports(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        String message = rb.getString("client.reports.SchedulerAction.update_dashboard_is_being_processed_refresh_the_page_after_sometime");
        try {
            int i;
            int k = 0;
            int[] selectedUpdates = new int[20];
            if (request.getParameter("reportID") != null) {
                selectedUpdates[0] = Integer.parseInt(request.getParameter("reportID"));
            }
            if (request.getParameter("userReports") != null) {
                for (i = 0; i < UserReports.length; ++i) {
                    selectedUpdates[i] = new Integer(UserReports[i]);
                }
                k = UserReports.length;
            }
            if (request.getParameter("systemReports") != null) {
                for (i = 0; i < SystemReports.length; ++i) {
                    selectedUpdates[k] = new Integer(SystemReports[i]);
                    ++k;
                }
            }
            if (request.getParameter("otherReports") != null) {
                for (i = 0; i < OtherReports.length; ++i) {
                    selectedUpdates[k] = new Integer(OtherReports[i]);
                    ++k;
                }
            }
            String domainName = request.getParameter("domainName");
            Long loginId = Long.parseLong(request.getParameter("loginId"));
            DomainHandler.updatehomePage((String)domainName, (Long)loginId, (int[])selectedUpdates);
        }
        catch (Exception e) {
            message = e.getMessage();
        }
        SchedulerInputsUtil.getMsgXMLElement(response, message);
        return null;
    }

    public static void refreshGraph(String domainName, Long loginId, String graphName) {
        try {
            int i;
            ArrayList<Integer> reportIds = new ArrayList<Integer>();
            if (graphName.equalsIgnoreCase("USER_REPORTS")) {
                for (i = 0; i < UserReports.length; ++i) {
                    reportIds.add(new Integer(UserReports[i]));
                }
            } else if (graphName.equalsIgnoreCase("SYSTEM_REPORTS")) {
                for (i = 0; i < SystemReports.length; ++i) {
                    reportIds.add(new Integer(SystemReports[i]));
                }
            } else if (graphName.equalsIgnoreCase("OTHER_REPORTS")) {
                for (i = 0; i < OtherReports.length; ++i) {
                    reportIds.add(new Integer(OtherReports[i]));
                }
            }
            int[] selectedReportIds = new int[reportIds.size()];
            for (int i2 = 0; i2 < reportIds.size(); ++i2) {
                selectedReportIds[i2] = (Integer)reportIds.get(i2);
            }
            DomainHandler.updatehomePage((String)domainName, (Long)loginId, (int[])selectedReportIds);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ActionForward runNowScheduler(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String messageType = "";
        String statusMessage = "";
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            Long schedule_id = 0L;
            String schedule_idStr = request.getParameter("schedule_id");
            schedule_id = new Long(schedule_idStr);
            SchedulerRunNowObject runNowObj = SchedulerRunNowObject.getInstance();
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            Long processingScheduleId = runNowObj.getProcessingScheduler(loginId);
            ArrayList scheduleIdList = SchedulerUtil.getSharedScheduleList((Long)loginId);
            Long taskId = SchedulerUtil.getTaskID((String)"ScheduleSelectedReports");
            if (!SchedulerUtil.isActionsAllowedForScheduler((Long)schedule_id, (Long)loginId).booleanValue() && !scheduleIdList.contains(schedule_id)) {
                messageType = "Error";
                statusMessage = rb.getString("admp.automation.run_now.error.scheduler_unauthorized");
            } else if (runNowObj.isSameSchedulerProcessing(loginId, schedule_id)) {
                messageType = "Error";
                statusMessage = rb.getString("admp.reports.schedule_reports.scheduler_list.scheduler_already_in_progress");
            } else if (runNowObj.isSchedulerProcessing(loginId)) {
                messageType = "Error";
                statusMessage = rb.getString("admp.reports.schedule_reports.scheduler_list.more_than_one_scheduler");
            } else {
                runNowObj.updateScheduleStatus(loginId, schedule_id, "PROCESSING", "", "");
                Long taskInstanceId = SchedulerUtil.getTaskInstanceId((Long)schedule_id);
                if (taskInstanceId != null) {
                    SchedulerOperationHandler.getInstance();
                    String stat = SchedulerOperationHandler.execute(taskInstanceId, taskId, loginId, I18NUtil.getDefaultLocale((HttpServletRequest)request));
                    if (stat.equals("LIMIT_REACHED")) {
                        messageType = "Error";
                        statusMessage = rb.getString("admp.reports.schedule_reports.scheduler_list.run_now_option_limit_reached");
                    } else {
                        messageType = "Success";
                        statusMessage = rb.getString("admp.reports.schedule_reports.scheduler_list.scheduler_started_run_mail_will_sent_shortly");
                    }
                }
            }
        }
        catch (Exception e) {
            messageType = "Error";
            statusMessage = e.getMessage();
            e.printStackTrace();
        }
        JSONObject jsonObj = new JSONObject();
        jsonObj.put("messageType", (Object)messageType);
        jsonObj.put("statusMessage", (Object)statusMessage);
        PrintWriter writer = response.getWriter();
        writer.print(jsonObj.toString());
        return null;
    }

    public ActionForward runNowSchedulerStatus(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String messageType = "";
        String statusMessage = "";
        String reportDir = "";
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            SchedulerRunNowObject runNowObj = SchedulerRunNowObject.getInstance();
            String schedule_idStr = request.getParameter("schedule_id");
            Long schedule_id = new Long(schedule_idStr);
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            String scheduleStatus = runNowObj.getSchedulerStatus(loginId, schedule_id);
            if (!scheduleStatus.equals("PROCESSING")) {
                messageType = "COMPLETED";
                reportDir = runNowObj.getSchedulerStoragePath(loginId, schedule_id);
                if (!reportDir.equals("")) {
                    String[] pathArray = reportDir.split("audit-data");
                    String schedulerZipFileName = "admp-reports.zip";
                    if (pathArray.length > 1 && !reportDir.contains("  ")) {
                        reportDir = "audit-data" + pathArray[pathArray.length - 1] + File.separator + schedulerZipFileName;
                        reportDir = reportDir.replace("\\", "/");
                        URI uri = new URI(null, null, reportDir, null, null);
                        reportDir = uri.toString();
                    } else {
                        reportDir = "file:///" + pathArray[pathArray.length - 1] + File.separator + schedulerZipFileName;
                    }
                    statusMessage = rb.getString("admp.reports.sche_reports.common.text.success");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JSONObject jsonObj = new JSONObject();
        jsonObj.put("messageType", (Object)messageType);
        jsonObj.put("statusMessage", (Object)statusMessage);
        jsonObj.put("href", (Object)reportDir);
        PrintWriter writer = response.getWriter();
        writer.print(jsonObj.toString());
        return null;
    }

    public ActionForward validCustomOnceSchedule(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            String date = request.getParameter("date");
            String hour = request.getParameter("hour");
            String minute = request.getParameter("minute");
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm", Locale.US);
            Date selected = format.parse(date + " " + hour + ":" + minute);
            Date current = new Date();
            boolean isValid = current.after(selected);
            JSONObject jsonObj = new JSONObject();
            jsonObj.put("result", !isValid);
            response.setContentType("application/json");
            PrintWriter writer = response.getWriter();
            writer.print(jsonObj.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward openShareScheduler(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        Long scheduleId = Long.parseLong(request.getParameter("SCHEDULE_ID"));
        if (SchedulerUtil.isActionsAllowedForScheduler((Long)scheduleId, (Long)loginId).booleanValue()) {
            Hashtable sharedTechnicianList = SchedulerUtil.getSharedScheduleTechniciansWithName((Long)scheduleId);
            request.setAttribute("sharedTechnicianList", (Object)sharedTechnicianList);
            return mapping.findForward("shareScheduler");
        }
        return new ActionForward("/403Error.do");
    }

    public ActionForward showResult(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        String params = request.getParameter("params");
        JSONObject json = new JSONObject(params);
        String searchPattern = json.getString("searchPattern");
        Long schedulerOwner = Long.parseLong(json.getString("schedulerOwner"));
        String tableName = "AaaLogin";
        HashMap<String, String> uniqueColumnMap = new HashMap<String, String>();
        uniqueColumnMap.put("COLUMN_NAME", "LOGIN_ID");
        uniqueColumnMap.put("TABLE_NAME", tableName);
        HashMap<String, String> uniqueDisplayColumnMap = new HashMap<String, String>();
        uniqueDisplayColumnMap.put("COLUMN_NAME", "NAME");
        uniqueDisplayColumnMap.put("TABLE_NAME", tableName);
        PopupTableDataModel popupTableModel = new PopupTableDataModel();
        popupTableModel.setUniqueColumnMap(uniqueColumnMap);
        popupTableModel.setUniqueDisplayColumnMap(uniqueDisplayColumnMap);
        Long administratorRoleId = TechnicianHandler.getRoleId((String)"Administrator");
        Table aaaAuthorizedRoleTable = Table.getTable((String)"AaaAuthorizedRole");
        Table aaaAccountTable = Table.getTable((String)"AaaAccount");
        Table aaaLoginTable = Table.getTable((String)"AaaLogin");
        Table aaaUserTable = Table.getTable((String)"AaaUser");
        SelectQueryImpl query = new SelectQueryImpl(aaaLoginTable);
        query.addSelectColumn(Column.getColumn(null, (String)"*"));
        Join join = new Join(aaaLoginTable, aaaAccountTable, new String[]{"LOGIN_ID"}, new String[]{"LOGIN_ID"}, 2);
        query.addJoin(join);
        join = new Join(aaaLoginTable, aaaUserTable, new String[]{"USER_ID"}, new String[]{"USER_ID"}, 2);
        query.addJoin(join);
        join = new Join(aaaAccountTable, aaaAuthorizedRoleTable, new String[]{"ACCOUNT_ID"}, new String[]{"ACCOUNT_ID"}, 1);
        query.addJoin(join);
        Criteria criteria = new Criteria(Column.getColumn((String)"AaaAuthorizedRole", (String)"ROLE_ID"), (Object)administratorRoleId, 0);
        criteria = criteria.and(new Criteria(Column.getColumn((String)"AaaLogin", (String)"LOGIN_ID"), (Object)new Long[]{CommonUtil.ADMIN_LOGIN_ID, schedulerOwner}, 9));
        if (!searchPattern.equals("")) {
            searchPattern = "*" + searchPattern + "*";
            Criteria searchCrit = new Criteria(new Column("AaaLogin", "NAME"), (Object)searchPattern, 2, false);
            searchCrit = searchCrit.or(new Criteria(new Column("AaaUser", "FULL_NAME"), (Object)searchPattern, 2, false));
            searchCrit = searchCrit.or(new Criteria(new Column("AaaUser", "FIRST_NAME"), (Object)searchPattern, 2, false));
            searchCrit = searchCrit.or(new Criteria(new Column("AaaUser", "LAST_NAME"), (Object)searchPattern, 2, false));
            searchCrit = searchCrit.or(new Criteria(new Column("AaaUser", "DISPLAY_NAME"), (Object)searchPattern, 2, false));
            searchCrit = searchCrit.or(new Criteria(new Column("AaaUser", "EMAIL_ADDRESS"), (Object)searchPattern, 2, false));
            criteria = criteria.and(searchCrit);
        }
        query.setCriteria(criteria);
        DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
        ArrayList columnList = ColumnConfiguration.getViewColumnList((long)ColumnConfiguration.getCVId((String)"HelpDeskTechnicianSel", (long)CommonUtil.ADMIN_LOGIN_ID));
        ArrayList<HashMap> columns = new ArrayList<HashMap>();
        for (int index = 0; index < columnList.size(); ++index) {
            HashMap mapDetails = (HashMap)columnList.get(index);
            String table = (String)mapDetails.get("TABLE_NAME");
            String column = (String)mapDetails.get("COLUMN_NAME");
            if (!table.equalsIgnoreCase(tableName) || column.equalsIgnoreCase((String)uniqueDisplayColumnMap.get("COLUMN_NAME")) || column.equalsIgnoreCase((String)uniqueColumnMap.get("COLUMN_NAME"))) continue;
            columns.add((HashMap)columnList.get(index));
        }
        popupTableModel.setColumnList(columns);
        popupTableModel.setTableDataWithDO(dataObj, tableName);
        request.setAttribute("DropDownResultDataModel", (Object)popupTableModel);
        request.setAttribute("isShareScheduler", (Object)true);
        return mapping.findForward("showListInDropDown");
    }

    public ActionForward shareScheduler(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        String statusMessage = "";
        Boolean isSuccess = true;
        String params = request.getParameter("params");
        JSONObject json = new JSONObject(params);
        Long scheduleId = new Long(json.getInt("scheduleId"));
        Boolean shareWithAll = (Boolean)json.get("shareWithAll");
        try {
            if (shareWithAll.booleanValue()) {
                SchedulerHandler.shareSchedulerWithAllTechnicians((Long)scheduleId, (Long)loginId);
                statusMessage = rb.getString("admp.reports.sche_report.share_scheduler.successfully_shared_with_all_technicians");
            } else {
                JSONObject technicianJson = (JSONObject)json.get("technicianList");
                ArrayList<Long> technicianList = new ArrayList<Long>();
                Iterator keys = technicianJson.keys();
                while (keys.hasNext()) {
                    technicianList.add(Long.parseLong((String)keys.next()));
                }
                SchedulerHandler.shareScheduler((Long)scheduleId, technicianList, (Long)loginId);
                statusMessage = technicianList.size() > 0 ? MessageFormat.format(rb.getString("admp.reports.sche_report.share_scheduler.statmsg.successfully_shared_with_technicians"), technicianList.size()) : rb.getString("admp.reports.sche_report.share_scheduler.statmsg.successfully_removed_all_technicians");
            }
        }
        catch (Exception e) {
            statusMessage = rb.getString("admp.reports.sche_report.share_scheduler.error_occured.error_while_sharing");
            isSuccess = false;
            e.printStackTrace();
        }
        JSONObject jsonObj = new JSONObject();
        jsonObj.put("statusMessage", (Object)statusMessage);
        jsonObj.put("isSuccess", (Object)isSuccess);
        response.setContentType("application/json");
        PrintWriter writer = response.getWriter();
        writer.print(jsonObj.toString());
        return null;
    }
}

