/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.reports;

import com.adventnet.sym.adsm.common.server.delegation.DelegationUtil;
import com.adventnet.sym.adsm.common.server.helpdesk.ADMPAuthObject;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.OSUtil;
import com.adventnet.sym.adsm.common.server.util.SchedulerUtil;
import com.adventnet.sym.adsm.common.webclient.util.ClientAuthorizationUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.struts.validator.DynaValidatorForm;

public class SchedulerBean
extends DynaValidatorForm {
    AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();

    public void init(Long loginId, HttpServletRequest request) {
        Locale locale = request.getLocale();
        this.rb = ResourceBundleMgr.getInstance().getBundle(locale);
        try {
            HttpSession session = request.getSession();
            ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
            Hashtable domainVsactions = authObject.getDomainActionMap();
            Long actionId = DelegationUtil.REPORT_TAB_ACTION_ID;
            ArrayList domainList = HDTDomainHandler.getDomainListForUser((Long)loginId, (Hashtable)domainVsactions, (Long)actionId);
            String[] defaultNamingList = new String[domainList.size()];
            String[] domainNames = new String[domainList.size()];
            int j = 0;
            for (int i = 0; i < domainList.size(); ++i) {
                Properties domainProp = (Properties)domainList.get(i);
                ArrayList ouList = (ArrayList)domainProp.get("ouList");
                String domainName = domainProp.getProperty("DOMAIN_NAME");
                String defaultDomain = domainProp.getProperty("IS_DEFAULT_DOMAIN");
                String defaultNamingContext = domainProp.getProperty("DEFAULT_NAMING_CONTEXT");
                if (!ClientAuthorizationUtil.isAuthorized(request, domainName, (Long)3000L).booleanValue()) continue;
                defaultNamingList[j] = defaultNamingContext;
                domainNames[j] = domainName;
                ++j;
            }
            this.set("OVERWRITE_FILES", false);
            this.set("inputValues", new ArrayList());
            this.set("defaultNamingList", defaultNamingList);
            this.set("domainNames", domainNames);
            this.set("domains", null);
            this.set("domainOUList", new Hashtable());
            this.set("domainList", domainList);
            this.set("scheduleId", "null");
            this.set("SchedulerDetails", new ArrayList());
            ArrayList<String> list = new ArrayList<String>(Arrays.asList("PDF", "HTML", "XLSX", "CSV", "CSVDE", "XLS"));
            ArrayList<String> list1 = new ArrayList<String>(Arrays.asList(this.rb.getString("admp.common.export_type.pdf"), this.rb.getString("admp.common.export_type.html"), this.rb.getString("admp.common.export_type.xlsx"), this.rb.getString("admp.common.export_type.csv"), this.rb.getString("admp.common.export_type.csvde"), this.rb.getString("admp.common.export_type.xls")));
            if (!CommonUtil.isIncludeXLSExportOption()) {
                list.remove("XLS");
                list1.remove(this.rb.getString("admp.common.export_type.xls"));
            }
            String[] formatNames = new String[list.size()];
            formatNames = list.toArray(formatNames);
            String[] displayFormats = new String[list1.size()];
            displayFormats = list1.toArray(displayFormats);
            String[] hours = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23"};
            Integer[] hourValues = new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23};
            String[] minutes = new String[]{"0", "5", "10", "15", "20", "25", "30", "35", "40", "45", "50", "55"};
            Integer[] minuteValues = new Integer[]{0, 5, 10, 15, 20, 25, 30, 35, 40, 45, 50, 55};
            Integer[] days = new Integer[]{1, 2, 3, 4, 5, 6, 7};
            String[] dayValues = new String[]{this.rb.getString("reports.logonhours.sunday"), this.rb.getString("reports.logonhours.monday"), this.rb.getString("reports.logonhours.tuesday"), this.rb.getString("reports.logonhours.wednesday"), this.rb.getString("reports.logonhours.thursday"), this.rb.getString("reports.logonhours.friday"), this.rb.getString("reports.logonhours.saturday")};
            String[] date = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30"};
            Integer[] dateValues = new Integer[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30};
            this.set("hours", hours);
            this.set("hourValues", hourValues);
            this.set("minutes", minutes);
            this.set("minuteValues", minuteValues);
            this.set("days", days);
            this.set("dayValues", dayValues);
            this.set("date", date);
            this.set("dateValues", dateValues);
            Hashtable osTable = OSUtil.getOSList();
            ArrayList operatingSystemListValues = (ArrayList)osTable.get("OS_NAME");
            ArrayList operatingSystemList = (ArrayList)osTable.get("OS_DISPLAY_NAME");
            this.set("operatingSystemList", operatingSystemList);
            this.set("operatingSystemListValues", operatingSystemListValues);
            this.set("formatNames", formatNames);
            this.set("mailSettings", new Hashtable());
            this.set("formatNames", formatNames);
            this.set("displayFormats", displayFormats);
            String[] repeatValues = new String[]{this.rb.getString("admp.reports.sched_reports.sch_create.input_text.days"), this.rb.getString("admp.reports.sched_reports.sch_create.input_text.weeks"), this.rb.getString("admp.reports.sched_reports.sch_create.input_text.months"), this.rb.getString("admp.reports.sched_reports.sch_create.input_text.years"), this.rb.getString("admp.reports.sched_reports.sch_create.input_text.minutes")};
            String[] repeats = new String[]{"repdays", "repweeks", "repmonths", "repyears", "repminutes"};
            String[] frequencyType = new String[]{"repnone", "repeat"};
            String[] frequencyValues = new String[]{this.rb.getString("admp.reports.sched_reports.sch_create.input_text.run_once"), this.rb.getString("admp.reports.sched_reports.sch_create.input_text.repeat")};
            String[] weekValues = new String[]{this.rb.getString("admp.reports.sched_reports.sch_create.input_text.first_week"), this.rb.getString("admp.reports.sched_reports.sch_create.input_text.second_week"), this.rb.getString("admp.reports.sched_reports.sch_create.input_text.third_week"), this.rb.getString("admp.reports.sched_reports.sch_create.input_text.fourth_week"), this.rb.getString("admp.reports.sched_reports.sch_create.input_text.last_week")};
            Integer[] weeks = new Integer[]{1, 2, 3, 4, 5};
            this.set("weeks", weeks);
            this.set("weekValues", weekValues);
            this.set("repeats", repeats);
            this.set("repeatValues", repeatValues);
            this.set("frequencyType", frequencyType);
            this.set("frequencyValues", frequencyValues);
            this.set("repSchedule", "hourly");
            this.set("frequency", "repnone");
            this.set("repeatType", "repdays");
            this.set("selectedMonthValues", "");
            this.set("selectedDayValues", "");
            this.set("startDate", "");
            Calendar cal = Calendar.getInstance();
            int currentHour = cal.get(11);
            int currentMinute = cal.get(12);
            if (currentMinute >= 55) {
                currentMinute = 0;
                ++currentHour;
            } else {
                currentMinute = currentMinute - currentMinute % 5 + 5;
            }
            this.set("dailysel1", currentHour);
            this.set("dailysel2", currentMinute);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setValues(String scheduleType, Long schedule_id, boolean custom) {
        ArrayList timeDetails = SchedulerUtil.getScheduleTimeDetails((String)scheduleType, (Long)schedule_id);
        Hashtable hash = (Hashtable)timeDetails.get(0);
        if (scheduleType.equalsIgnoreCase("hourly")) {
            String UNIT_OF_TIME = (String)hash.get("UNIT_OF_TIME");
            Long TIME_PERIOD = (Long)hash.get("TIME_PERIOD");
            if (custom) {
                this.set("repeatInterval", TIME_PERIOD.intValue());
                this.set("startDate", (String)hash.get("startDate"));
                this.set("dailysel1", (Integer)hash.get("hours"));
                this.set("dailysel2", (Integer)hash.get("minutes"));
                this.set("repeatType", "repminutes");
                this.set("frequency", "repeat");
                this.set("repSchedule", "custom");
            } else {
                this.set("dailysel1", TIME_PERIOD.intValue());
                this.set("repSchedule", "hourly");
            }
        } else {
            Integer startDate = (Integer)hash.get("DATE_OF_MONTH");
            Integer startMonth = (Integer)hash.get("MONTH_OF_YEAR");
            Integer startYear = (Integer)hash.get("YEAR_OF_DECADE");
            Integer skipFrequency = (Integer)hash.get("SKIP_FREQUENCY");
            String executionTime = (String)hash.get("EXECUTION_TIME");
            String hrs = executionTime.substring(0, executionTime.indexOf(58));
            String mns = executionTime.substring(executionTime.indexOf(58) + 1, executionTime.lastIndexOf(58));
            Integer hours = Integer.parseInt(hrs);
            Integer minutes = Integer.parseInt(mns);
            this.set("dailysel1", hours);
            this.set("dailysel2", minutes);
            if (scheduleType.equalsIgnoreCase("Daily")) {
                if (custom) {
                    this.set("repeatType", "repdays");
                    this.set("frequency", "repeat");
                } else {
                    this.set("repSchedule", "daily");
                }
            } else if (scheduleType.equalsIgnoreCase("Weekly")) {
                if (custom) {
                    int[] daysOfWeek = (int[])hash.get("DAYS_OF_WEEK");
                    Object[] seldayval = new Integer[daysOfWeek.length];
                    for (int i = 0; i < daysOfWeek.length; ++i) {
                        seldayval[i] = daysOfWeek[i];
                    }
                    String selDayVal = Arrays.toString(seldayval);
                    selDayVal = selDayVal.replaceAll(", ", ",").replace("[", "").replace("]", "");
                    this.set("selectedDayValues", selDayVal);
                    this.set("repeatType", "repweeks");
                    this.set("frequency", "repeat");
                } else {
                    Integer[] days = new Integer[]{1, 2, 3, 4, 5, 6, 7};
                    Integer DAY_OF_WEEK = (Integer)hash.get("DAY_OF_WEEK");
                    this.set("weeklysel1", days[DAY_OF_WEEK - 1]);
                    this.set("repSchedule", "weekly");
                }
            } else if (scheduleType.equalsIgnoreCase("Monthly")) {
                Integer DATE_OF_MONTH = (Integer)hash.get("DATE_OF_MONTH");
                if (custom) {
                    startDate = 1;
                    if (DATE_OF_MONTH != -1) {
                        this.set("monthsel2", DATE_OF_MONTH);
                        this.set("monthdaydate", "date");
                    } else {
                        int[] daysOfWeek = (int[])hash.get("DAYS_OF_WEEK");
                        Long weekOfMonth = (Long)hash.get("WEEK_OF_MONTH");
                        this.set("weekofmonth", weekOfMonth.intValue());
                        this.set("weeklysel2", daysOfWeek[0]);
                        this.set("monthdaydate", "day");
                    }
                    this.set("repeatType", "repmonths");
                    this.set("frequency", "repeat");
                } else {
                    this.set("monthsel1", DATE_OF_MONTH);
                    this.set("repSchedule", "monthly");
                }
            } else if (scheduleType.equalsIgnoreCase("Yearly")) {
                startMonth = 1;
                startDate = 1;
                int[] months = (int[])hash.get("MONTHS");
                Object[] selmonthval = new Integer[months.length];
                for (int i = 0; i < months.length; ++i) {
                    selmonthval[i] = months[i] + 1;
                }
                String selMonthVal = Arrays.toString(selmonthval);
                selMonthVal = selMonthVal.replaceAll(", ", ",").replace("[", "").replace("]", "");
                this.set("selectedMonthValues", selMonthVal);
                this.set("repeatType", "repyears");
                this.set("frequency", "repeat");
                Integer DATE_OF_MONTH = (Integer)hash.get("DATE_OF_MONTH");
                if (DATE_OF_MONTH != -1) {
                    this.set("monthsel2", DATE_OF_MONTH);
                    this.set("monthdaydate", "date");
                } else {
                    int[] daysOfWeek = (int[])hash.get("DAYS_OF_WEEK");
                    Long weekOfMonth = (Long)hash.get("WEEK_OF_MONTH");
                    this.set("weekofmonth", weekOfMonth.intValue());
                    this.set("weeklysel2", daysOfWeek[0]);
                    this.set("monthdaydate", "day");
                }
            } else if (scheduleType.equalsIgnoreCase("None")) {
                this.set("frequency", "repnone");
            }
            if (custom) {
                String dateStr = startYear.toString() + "-" + startMonth.toString() + "-" + startDate.toString();
                this.set("repeatInterval", skipFrequency + 1);
                this.set("startDate", dateStr);
                this.set("repSchedule", "custom");
            }
        }
    }
}

