/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.reports;

import com.adventnet.db.persistence.metadata.ColumnDefinition;
import com.adventnet.db.persistence.metadata.PrimaryKeyDefinition;
import com.adventnet.db.persistence.metadata.TableDefinition;
import com.adventnet.db.persistence.metadata.UniqueValueGeneration;
import com.adventnet.db.persistence.metadata.util.MetaDataUtil;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.AdmpInput;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.automation.ReportFilterConfig;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.reports.ComputerHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportAttributeHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportReqParams;
import com.adventnet.sym.adsm.common.server.util.DBUtil;
import com.adventnet.sym.adsm.common.server.util.DynamicTableUtil;
import com.adventnet.sym.adsm.common.server.util.SidTableUtil;
import com.adventnet.sym.adsm.common.webclient.reports.AbstractListener;
import com.adventnet.sym.adsm.common.webclient.reports.AbstractNTFSReportsListener;
import com.adventnet.sym.adsm.common.webclient.reports.DBWriterUtil;
import com.adventnet.sym.adsm.common.webclient.reports.ListenerUtil;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.reports.ReportExportUtil;
import com.adventnet.sym.adsm.common.webclient.reports.SIDCacheManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.sf.cache4j.CacheFactory;
import org.apache.struts.validator.DynaValidatorForm;

public class SharesListener
extends AbstractNTFSReportsListener {
    protected static Hashtable genIdTableKeyMap = new Hashtable();
    protected static SIDCacheManager cacheMgr;
    protected ArrayList permissionsPropList = new ArrayList();
    AbstractNTFSReportsListener.UpdateAction updateAction;

    @Override
    public Long getCategoryId() {
        Long categoryId = new Long(-1L);
        return categoryId;
    }

    @Override
    public boolean isResultViewOutputFilterAvailable() {
        return true;
    }

    @Override
    public boolean isPermissionColumnIncluded() {
        return true;
    }

    @Override
    public String getOutputFilterLabelText() {
        return "admp.reports.server_report.text.showing_servers_of";
    }

    @Override
    protected void checkAttributeList(ArrayList attributeList) {
    }

    @Override
    protected void doAction(String domainName, Long loginId, String dn, ArrayList attributeList, NativeListener listener) throws Exception {
    }

    protected void doAction(String domainName, String directoryPath, String userDn, Long loginId, ArrayList attributeList, NativeListener listener) throws Exception {
    }

    @Override
    public Criteria getReportResultFilterCriteria(HttpServletRequest request, DynaValidatorForm bean, Criteria crit, String inputId) {
        try {
            String columnName = "INPUT_ID";
            ArrayList inputObjects = (ArrayList)bean.get("inputObjects");
            crit = !inputObjects.contains(inputId) && inputObjects.size() != 0 ? (crit == null ? new Criteria(new Column(this.resultTableName, columnName), (Object)0L, 0) : crit.and(new Criteria(new Column(this.resultTableName, columnName), (Object)0L, 0))) : (crit == null ? new Criteria(new Column(this.resultTableName, columnName), (Object)inputId, 0) : crit.and(new Criteria(new Column(this.resultTableName, columnName), (Object)inputId, 0)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return crit;
    }

    public SharesListener() {
        this.tableKey = "SHARE_ID";
        this.tempTableKey = "LOCATION";
        this.attrKey = "Location";
        this.attrKey2 = "Location";
    }

    @Override
    public void init(Row r) {
        this.baseTableName = (String)r.get("BASE_TABLE_NAME");
        this.resultTableName = (String)r.get("RESULT_TABLE_NAME");
        this.reportId = (Integer)r.get("REPORT_ID");
        this.onClickText = (String)r.get("ONCLICK_TEXT");
        if (this.rb == null) {
            this.rb = ResourceBundleMgr.getInstance().getBundle();
        }
        this.title = (String)r.get("REPORT_NAME");
    }

    @Override
    public void init(HttpServletRequest request, Row r) {
        HttpSession session = request.getSession();
        Locale locale = request.getLocale();
        this.rb = ResourceBundleMgr.getInstance().getBundle(locale);
        this.baseTableName = (String)r.get("BASE_TABLE_NAME");
        this.resultTableName = (String)r.get("RESULT_TABLE_NAME");
        this.reportId = (Integer)r.get("REPORT_ID");
        this.onClickText = (String)r.get("ONCLICK_TEXT");
        this.title = (String)r.get("REPORT_NAME");
        this.setGenerationId(request);
    }

    @Override
    public Hashtable getQueueProps() {
        Hashtable<String, Object> tableProps = new Hashtable<String, Object>();
        tableProps.put("baseTableName", this.baseTableName);
        tableProps.put("resultTableName", this.resultTableName);
        tableProps.put("generationId", this.generationId);
        tableProps.put("resultHandling", "updateMultiValues");
        tableProps.put("tableKey", "LOCATION");
        return tableProps;
    }

    @Override
    public void fillInputDetails(String inputTable, HttpServletRequest request, ReportBean bean, String key) {
        ArrayList trusteesList = (ArrayList)bean.get("trusteesList");
        HashMap inputParams = (HashMap)bean.get("reportInputParams");
        Hashtable dnDomainNameMap = (Hashtable)bean.get("dnDomainNameMap");
        String[] domainList = (String[])bean.get("domains");
        ArrayList valuesList = new ArrayList();
        for (int i = 0; i < trusteesList.size(); ++i) {
            Hashtable<String, Object> inputs = new Hashtable<String, Object>();
            String inputName = ComputerHandler.getDN((String)((String)trusteesList.get(i)), (String)((String)dnDomainNameMap.get(domainList[0])));
            inputs.put("INPUT_NAME", inputName);
            String dn = ComputerHandler.getDistinguishedName((String)((String)trusteesList.get(i)), (String)((String)dnDomainNameMap.get(domainList[0])));
            inputs.put("DISTINGUISHED_NAME", dn);
            inputs.put("INPUT_OBJECT_ID", (String)trusteesList.get(i));
            inputs.put("REPORT_GENERATION_ID", this.generationId);
            ListenerUtil.fillValues(inputTable, this.reportId, inputs, this.generationId);
            valuesList.add(inputs);
        }
        inputParams.put(key, valuesList);
    }

    public void dropAndCreateTable() {
        String generatedTableName = "ADSMSharePermissionDetails_" + this.generationId;
        try {
            TableDefinition tableDef = MetaDataUtil.getTableDefinitionByName((String)generatedTableName);
            if (tableDef == null) {
                tableDef = new TableDefinition();
                tableDef.setTableName(generatedTableName);
                ColumnDefinition coldef = new ColumnDefinition();
                coldef.setColumnName("SHARE_ID");
                coldef.setDescription("Share id");
                coldef.setDataType("BIGINT");
                coldef.setNullable(false);
                tableDef.addColumnDefinition(coldef);
                coldef = new ColumnDefinition();
                coldef.setColumnName("ACE_TYPE");
                coldef.setDescription("Type of the ACE in String Format. ie (Allow/Deny)");
                coldef.setDataType("CHAR");
                coldef.setMaxLength(100);
                coldef.setNullable(false);
                coldef.setUnique(false);
                tableDef.addColumnDefinition(coldef);
                coldef = new ColumnDefinition();
                coldef.setColumnName("SECURITY_PRINCIPAL");
                coldef.setDescription("Security Principal");
                coldef.setDataType("CHAR");
                coldef.setMaxLength(1000);
                coldef.setNullable(false);
                coldef.setUnique(false);
                tableDef.addColumnDefinition(coldef);
                coldef = new ColumnDefinition();
                coldef.setColumnName("PERMISSIONS");
                coldef.setDescription("Permission of the ACE in String Format");
                coldef.setDataType("CHAR");
                coldef.setMaxLength(1000);
                coldef.setNullable(false);
                coldef.setUnique(false);
                tableDef.addColumnDefinition(coldef);
                coldef = new ColumnDefinition();
                coldef.setColumnName("APPLIES_TO");
                coldef.setDescription("Applies-To of the ACE in String Format");
                coldef.setDataType("CHAR");
                coldef.setMaxLength(100);
                coldef.setNullable(false);
                coldef.setUnique(false);
                tableDef.addColumnDefinition(coldef);
                coldef = new ColumnDefinition();
                coldef.setColumnName("INHERITED_ACE");
                coldef.setDescription("Is this an inherited ace");
                coldef.setDataType("CHAR");
                coldef.setMaxLength(100);
                coldef.setNullable(false);
                coldef.setUnique(false);
                tableDef.addColumnDefinition(coldef);
                coldef = new ColumnDefinition();
                coldef.setColumnName("PERMISSION_TYPE");
                coldef.setDescription("Type of permission NTFS/Share");
                coldef.setDataType("CHAR");
                coldef.setMaxLength(10);
                coldef.setNullable(false);
                coldef.setUnique(false);
                tableDef.addColumnDefinition(coldef);
                coldef = new ColumnDefinition();
                coldef.setColumnName("TRUSTEE_SID");
                coldef.setDescription("SID String");
                coldef.setDataType("CHAR");
                coldef.setMaxLength(250);
                coldef.setNullable(false);
                tableDef.addColumnDefinition(coldef);
                coldef = new ColumnDefinition();
                coldef.setColumnName("PERMISSION_ID");
                coldef.setDescription("Identifier for each Permission");
                coldef.setDataType("BIGINT");
                coldef.setNullable(false);
                UniqueValueGeneration generator = new UniqueValueGeneration();
                generator.setGeneratorName(generatedTableName + ".PERMISSION_ID");
                coldef.setUniqueValueGeneration(generator);
                tableDef.addColumnDefinition(coldef);
                PrimaryKeyDefinition pkDef = new PrimaryKeyDefinition();
                pkDef.setName(generatedTableName + "_PK");
                pkDef.addColumnName("PERMISSION_ID");
                pkDef.setTableName(generatedTableName);
                tableDef.setPrimaryKey(pkDef);
                DynamicTableUtil.createDynamicTable((TableDefinition)tableDef);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            String message = e.getMessage();
            System.out.println("Exception message :  " + message);
        }
    }

    @Override
    public ArrayList getDBCustomizedValues(String columnName, String ldapName, Properties prop) {
        ArrayList<Object> ret = super.getDBCustomizedValues(columnName, ldapName, prop);
        ArrayList values = (ArrayList)prop.get(ldapName);
        if (columnName.equalsIgnoreCase("MAX_USER_COUNT")) {
            ret = new ArrayList<Object>();
            ret.add(new Long((String)values.get(0)));
        }
        if (columnName.equalsIgnoreCase("CURRENT_USER_COUNT")) {
            ret = new ArrayList();
            ret.add(new Long((String)values.get(0)));
        }
        if (columnName.equalsIgnoreCase("LOCAL_PATH")) {
            ret = new ArrayList();
            if (values == null || values.size() == 0) {
                ret.add("-");
            } else {
                ret.add((String)values.get(0));
            }
        }
        if (ldapName.equalsIgnoreCase("permission")) {
            ret = new ArrayList();
            for (int i = 0; i < values.size(); ++i) {
                ArrayList val;
                Properties p = (Properties)values.get(i);
                if (columnName.equalsIgnoreCase("ACE_TYPE")) {
                    val = (ArrayList)p.get("aceType");
                    ret.add(this.rb.getString((String)val.get(0)));
                    continue;
                }
                if (columnName.equalsIgnoreCase("APPLIES_TO")) {
                    val = (ArrayList)p.get("appliesTo");
                    ret.add(this.rb.getString((String)val.get(0)));
                    continue;
                }
                if (columnName.equalsIgnoreCase("SECURITY_PRINCIPAL")) {
                    val = (ArrayList)p.get("trustee");
                    ret.add((String)val.get(0));
                    continue;
                }
                if (columnName.equalsIgnoreCase("INHERITED_ACE")) {
                    val = (ArrayList)p.get("inheritedAce");
                    ret.add(this.rb.getString((String)val.get(0)));
                    continue;
                }
                if (columnName.equalsIgnoreCase("PERMISSION_TYPE")) {
                    val = (ArrayList)p.get("permissionType");
                    ret.add(this.rb.getString((String)val.get(0)));
                    continue;
                }
                if (columnName.equalsIgnoreCase("TRUSTEE_SID")) {
                    val = (ArrayList)p.get("sid");
                    ret.add((String)val.get(0));
                    continue;
                }
                if (!columnName.equalsIgnoreCase("PERMISSIONS")) continue;
                val = (ArrayList)p.get("permissionStr");
                Object object = val.get(0);
                if (object instanceof List) {
                    ArrayList permList = (ArrayList)object;
                    StringBuffer permissionsBuffer = new StringBuffer();
                    for (int j = 0; j < permList.size(); ++j) {
                        if (j == 0) {
                            permissionsBuffer.append(this.rb.getString((String)permList.get(j)));
                            continue;
                        }
                        permissionsBuffer.append(", ");
                        permissionsBuffer.append(this.rb.getString((String)permList.get(j)));
                    }
                    if (permissionsBuffer.toString().equals("")) {
                        ret.add(" ");
                        continue;
                    }
                    ret.add(permissionsBuffer.toString());
                    continue;
                }
                if (!(object instanceof String)) continue;
                String permString = (String)object;
                String[] permList = permString.split(",");
                StringBuffer permissionsBuffer = new StringBuffer();
                for (int j = 0; j < permList.length; ++j) {
                    if (j == 0) {
                        permissionsBuffer.append(this.rb.getString(permList[j]));
                        continue;
                    }
                    permissionsBuffer.append(", ");
                    permissionsBuffer.append(this.rb.getString(permList[j]));
                }
                if (permissionsBuffer.toString().equals("")) {
                    ret.add(" ");
                    continue;
                }
                ret.add(permissionsBuffer.toString());
            }
        }
        return ret;
    }

    @Override
    public void addRow(Properties prop, String guid, Hashtable tableRowMap, Hashtable relationalTableRowMap, Properties uiValues, Hashtable stringRowMap) {
        try {
            Object values = null;
            ArrayList tableNames = ReportAttributeHandler.getInstance().getTableNames(this.reportId);
            int baseTableIndex = tableNames.indexOf(this.baseTableName);
            if (baseTableIndex > 0) {
                tableNames.remove(baseTableIndex);
                tableNames.add(0, this.baseTableName);
            }
            ArrayList writerTableList = ReportAttributeHandler.getInstance().getWriterTables();
            for (int i = 0; i < tableNames.size(); ++i) {
                String tableName = (String)tableNames.get(i);
                ArrayList attributeList = ReportAttributeHandler.getInstance().getAttributes(tableName, this.reportId);
                if (writerTableList != null && tableName.equalsIgnoreCase("ADSMSharePermissionDetails")) {
                    tableName = tableName + "_" + this.generationId;
                    Hashtable sidVsAclIdMap = (Hashtable)genIdTableKeyMap.get(this.generationId);
                    Hashtable sidVsAcl = (Hashtable)sidVsAclIdMap.get(guid);
                    DBWriterUtil.createStringRows(tableName, attributeList, stringRowMap, prop, uiValues, this, this.tableKey, ((Long)sidVsAcl.get(this.tableKey)).toString());
                    continue;
                }
                this.createRows(tableName, attributeList, tableRowMap, relationalTableRowMap, prop, uiValues, this.tableKey, guid);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void updateAttributeList(ReportBean bean, ArrayList attributeList) {
        String generatedTableName = "ADSMSharePermissionDetails_" + this.generationId;
        for (int i = 0; i < attributeList.size(); ++i) {
            Properties prop = (Properties)attributeList.get(i);
            String tableName = prop.getProperty("TABLE_NAME");
            if (!tableName.equalsIgnoreCase("ADSMSharePermissionDetails")) continue;
            prop.put("TABLE_NAME", generatedTableName);
        }
    }

    @Override
    public void createRows(String tableName, ArrayList attributeList, Hashtable tableRowMap, Hashtable relationalTableRowMap, Properties prop, Properties uiValues, String tableKey, String guid) throws Exception {
        ArrayList<Object> rowList = new ArrayList<Object>();
        ArrayList values = null;
        ArrayList<Row> multipleTableRowList = new ArrayList<Row>();
        Integer relationalType = null;
        Row r = null;
        TableDefinition tableDef = MetaDataUtil.getTableDefinitionByName((String)tableName);
        for (int j = 0; j < attributeList.size(); ++j) {
            Properties p = (Properties)attributeList.get(j);
            String ldapName = (String)p.get("ATTRIB_LDAP_NAME");
            String columnName = (String)p.get("ATTRIB_COLUMN_NAME");
            Integer attributeId = (Integer)p.get("ATTRIB_ID");
            relationalType = (Integer)p.get("RELATIONAL_TYPE");
            if (this.toBeExecutedAttributeList != null && !this.toBeExecutedAttributeList.contains(ldapName)) continue;
            values = (ArrayList)prop.get(ldapName);
            values = this.getDBCustomizedValues(columnName, ldapName, prop);
            StringBuffer buf = new StringBuffer();
            if (relationalType.equals(new Integer(1))) {
                buf.append("-");
                if (values != null && !values.isEmpty()) {
                    for (int k = 0; k < values.size(); ++k) {
                        String value = (String)values.get(k);
                        Row r1 = null;
                        if (multipleTableRowList.size() > k) {
                            r1 = (Row)multipleTableRowList.get(k);
                        } else {
                            r1 = new Row(tableName);
                            if (tableRowMap.size() > 0) {
                                this.getUniqueId(this.generationId, r1, guid);
                            }
                            multipleTableRowList.add(k, r1);
                        }
                        r1.set(columnName, (Object)value);
                        r1.set(this.tempTableKey, (Object)guid);
                        buf.append(value);
                        if (k == values.size() - 1) continue;
                        buf.append(",");
                    }
                } else {
                    if (r == null) {
                        r = new Row(tableName);
                    }
                    r.set(columnName, (Object)"-");
                }
            } else if (values != null && !values.isEmpty()) {
                if (r == null) {
                    r = new Row(tableName);
                }
                r.set(columnName, values.get(0));
                buf.append(values.get(0));
            } else {
                if (r == null) {
                    r = new Row(tableName);
                }
                r.set(columnName, (Object)"-");
                buf.append("-");
            }
            if (!this.viewAttributeList.contains(attributeId)) continue;
            uiValues.put(attributeId, buf.toString());
        }
        if (r != null) {
            Hashtable sidVsAclIdMap = (Hashtable)genIdTableKeyMap.get(this.generationId);
            if (sidVsAclIdMap == null) {
                sidVsAclIdMap = new Hashtable();
            }
            if (sidVsAclIdMap.get(guid) == null) {
                Hashtable<String, Object> securityprincipalMap = new Hashtable<String, Object>();
                DBUtil.fillGeneratedValues(r);
                sidVsAclIdMap.put(guid, securityprincipalMap);
                securityprincipalMap.put(tableKey, r.get(tableKey));
                rowList.add(r);
            }
            genIdTableKeyMap.put(this.generationId, sidVsAclIdMap);
        }
        if (multipleTableRowList.size() > 0) {
            rowList.addAll(multipleTableRowList);
        }
        if (relationalType.equals(new Integer(0))) {
            tableRowMap.put(tableName, rowList);
        } else if (rowList.size() > 0) {
            relationalTableRowMap.put(tableName, rowList);
        }
    }

    public void getUniqueId(Long generationId, Row r, String guid) {
        try {
            Hashtable sidVsAclIdMap = (Hashtable)genIdTableKeyMap.get(generationId);
            Hashtable aclIdVsSecurityPrincipal = (Hashtable)sidVsAclIdMap.get(guid);
            r.set(this.tableKey, aclIdVsSecurityPrincipal.remove("LOCATION"));
            DBUtil.fillGeneratedValues((Row)r);
            aclIdVsSecurityPrincipal.put(this.tableKey, r.get(this.tableKey));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getSid(Properties prop) {
        ArrayList values = (ArrayList)prop.get("permission");
        Properties p = (Properties)values.get(0);
        ArrayList sid = (ArrayList)p.get("sid");
        return (String)sid.get(0);
    }

    private String getLookupServer(Properties prop) {
        ArrayList values = (ArrayList)prop.get("Location");
        String pathName = (String)values.get(0);
        String lookupServer = pathName.substring(2, pathName.indexOf("\\", 2));
        return lookupServer;
    }

    private void setProps(Properties prop, Properties sidProp) {
        ArrayList values = (ArrayList)prop.get("permission");
        Properties p = (Properties)values.get(0);
        p.putAll((Map<?, ?>)sidProp);
    }

    @Override
    public synchronized void addRow(Properties prop) {
        String sid = this.getSid(prop);
        String lookupServer = this.getLookupServer(prop);
        Properties props = new Properties();
        try {
            Properties sidProp = cacheMgr.get(this.domainName, this.loginId, sid, lookupServer);
            props.putAll((Map<?, ?>)prop);
            if (sidProp == null) {
                this.permissionsPropList.add(props);
                return;
            }
            this.setProps(prop, sidProp);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.noOfObjects == null || this.reportId == null) {
            this.continueAction = false;
            System.out.println("Number Of Objects exceeded beyond the License Limit");
            return;
        }
        if (!this.noOfObjects.equalsIgnoreCase("unlimited")) {
            try {
                int licensedCount = Integer.parseInt(this.noOfObjects);
                if (this.reportId < 100 && this.totalCount >= licensedCount || this.totalCount >= licensedCount && licensedCount == 100) {
                    this.updateQueue();
                    this.continueAction = false;
                    System.out.println("Number Of Objects exceeded beyond the License Limit");
                    return;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            String guid = this.getGuid(props);
            if (guid == null) {
                return;
            }
            ++this.totalCount;
            if (this.updatedCount < 1) {
                this.viewAttributeList = ReportAttributeHandler.getInstance().getViewAttributesList(this.reportId, this.loginId);
            }
            Hashtable tableRowMap = new Hashtable();
            Hashtable relationalTableRowMap = new Hashtable();
            Properties uiValues = new Properties();
            Hashtable stringRowMap = new Hashtable();
            this.addRow(props, guid, tableRowMap, relationalTableRowMap, uiValues, stringRowMap);
            Hashtable sidVsAclIdMap = (Hashtable)genIdTableKeyMap.get(this.generationId);
            Hashtable sidVsAclId = (Hashtable)sidVsAclIdMap.get(guid);
            String uniqueGuid = ((Long)sidVsAclId.get(this.tableKey)).toString();
            this.queue.add(this.generationId, guid, tableRowMap, relationalTableRowMap, this.baseTableName, stringRowMap);
            if (!this.guidList.contains(uniqueGuid)) {
                this.guidList.add(uniqueGuid);
            }
            StringBuffer b = new StringBuffer();
            b.append("[");
            for (int i = 0; i < this.viewAttributeList.size(); ++i) {
                Integer attributeId = (Integer)this.viewAttributeList.get(i);
                b.append("'");
                String s = (String)uiValues.get(attributeId);
                if (s == null || s.trim().equalsIgnoreCase("")) {
                    b.append("-");
                } else {
                    s = ListenerUtil.getDynamicUpdateValues(attributeId, s);
                    b.append(s);
                }
                b.append("'");
                if (i == this.viewAttributeList.size() - 1) continue;
                b.append(",");
            }
            b.append("]");
            this.updateUI(uiValues, null, guid, b.toString());
            this.queue.checkForNextUpdate(this.generationId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void start(ArrayList attributeList, HttpServletRequest request, ReportBean bean) {
        try {
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            this.checkAttributeList(attributeList);
            this.dropAndCreateTable();
            HashMap reportInputParams = (HashMap)bean.get("reportInputParams");
            String dn = request.getParameter("domains");
            String domainName = null;
            if (dn != null) {
                Hashtable dnDomainNameMap = (Hashtable)bean.get("dnDomainNameMap");
                domainName = (String)dnDomainNameMap.get(dn);
            } else {
                Properties domainProps = HDTDomainHandler.getSelectedDomain((Long)loginId);
                domainName = domainProps.getProperty("DOMAIN_NAME");
            }
            this.domainName = domainName;
            this.loginId = loginId;
            this.getDescription(new Object[]{domainName});
            Action action = new Action(loginId, domainName, reportInputParams, attributeList, this);
            action.start();
            this.updateAction = new AbstractNTFSReportsListener.UpdateAction(this);
            this.updateAction.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public synchronized void addPermissions() {
        for (int i = 0; i < this.permissionsPropList.size(); ++i) {
            this.addRow((Properties)this.permissionsPropList.remove(i));
        }
    }

    private void deRegisterMap(Long generationId) {
        genIdTableKeyMap.remove(generationId);
    }

    private void fillInputValues(String domainName, String inputName, Long genId, String guid) {
        try {
            Hashtable<String, Object> inputs = new Hashtable<String, Object>();
            inputs.put("INPUT_NAME", inputName);
            Properties objProps = SidTableUtil.getSidFromGuid((String)domainName, (String)guid);
            String sid = (String)objProps.get("SID_STRING");
            if (sid == null) {
                sid = "";
            }
            String dn = (String)objProps.get("DN_STRING");
            inputs.put("DISTINGUISHED_NAME", dn);
            inputs.put("INPUT_OBJECT_ID", sid);
            inputs.put("REPORT_GENERATION_ID", this.generationId);
            String[] key = new String[]{"trusteesList"};
            Hashtable inputHashTable = ListenerUtil.getInputTable(this.reportId, key);
            String inputTable = (String)inputHashTable.get("trusteesList");
            ListenerUtil.fillValues(inputTable, this.reportId, inputs, this.generationId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void executeTask(ArrayList containerList, Hashtable dnDomainNameMap, ReportFilterConfig reportFilterConfig) {
        this.executeTask(containerList, dnDomainNameMap, null, null, reportFilterConfig);
    }

    @Override
    public void executeTask(ArrayList containerList, Hashtable dnDomainNameMap, Hashtable excludedOUList, Hashtable domainVsExcludeChildOU, ReportFilterConfig reportFilterConfig) {
        try {
            this.isCompleted = false;
            String serverName = "";
            String serverID = "";
            for (AdmpInput admpInput : reportFilterConfig.getInputList()) {
                if (admpInput.getIsMultiple().booleanValue()) continue;
                if (admpInput.getName().equalsIgnoreCase("serverName")) {
                    serverName = admpInput.getValue();
                    continue;
                }
                if (!admpInput.getName().equalsIgnoreCase("serverID")) continue;
                serverID = admpInput.getValue();
            }
            this.generationId = ReportHandler.addReportGenerationDetails((Integer)this.reportId, (String)this.desc, (Long)this.loginId);
            this.domainName = (String)dnDomainNameMap.get(containerList.get(0));
            if (this.domainName != null) {
                this.getDescription(new Object[]{this.domainName});
                this.fillInputValues(this.domainName, serverName, this.generationId, serverID);
                Hashtable<String, Object> inputs = new Hashtable<String, Object>();
                inputs.put("INPUT_NAME", serverName);
                inputs.put("REPORT_GENERATION_ID", this.generationId);
                Long inputId = ListenerUtil.getInputId(this.reportId, this.generationId, "trusteesList");
                inputs.put("INPUT_ID", inputId);
                ArrayList<Hashtable<String, Object>> serverList = new ArrayList<Hashtable<String, Object>>();
                serverList.add(inputs);
                HashMap<String, ArrayList<Hashtable<String, Object>>> reportInputParams = new HashMap<String, ArrayList<Hashtable<String, Object>>>();
                reportInputParams.put("trusteesList", serverList);
                this.dropAndCreateTable();
                Action action = new Action(1L, this.domainName, reportInputParams, this.getAttributeList(), this);
                action.start();
                this.updateAction = new AbstractNTFSReportsListener.UpdateAction(this);
                this.updateAction.start();
                while (!this.isCompleted) {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                ReportHandler.updateReportGenerationDetails((Long)this.generationId, (int)1, (String)this.desc, (Long)this.loginId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void exportReport(Row reportDetails, String reportType, ArrayList attributelist, Map inputParams, HttpServletRequest request, HttpServletResponse response, String reportList, AbstractListener listener, ArrayList trusteesList, ReportReqParams reqParams) {
        ReportExportUtil.exportReportWithSubReport(reportDetails, reportType, attributelist, inputParams, request, response, reportList, listener, trusteesList, reqParams);
    }

    @Override
    public ArrayList getExportAttributesList() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int[] attr = new int[]{11003, 11004, 11017};
        for (int i = 0; i < attr.length; ++i) {
            list.add(attr[i]);
        }
        ArrayList attrList = ReportAttributeHandler.getInstance().getAttributeProps(list);
        return attrList;
    }

    @Override
    public ArrayList getExportData(ArrayList sharesList, ArrayList attributeList, ArrayList subReportList) {
        ArrayList resultList = new ArrayList();
        for (int k = 0; k < sharesList.size(); ++k) {
            Properties attrProp;
            int i;
            Properties shareProp = (Properties)sharesList.get(k);
            ArrayList<Object> data = new ArrayList<Object>();
            for (i = 0; i < attributeList.size(); ++i) {
                attrProp = (Properties)attributeList.get(i);
                String attribName = (String)attrProp.get("ATTRIB_COLUMN_NAME");
                data.add((String)shareProp.get(attribName));
            }
            for (i = 0; i < subReportList.size(); ++i) {
                attrProp = (Properties)subReportList.get(i);
                ArrayList subAttributeList = (ArrayList)attrProp.get("ATTRIBUTE_LIST");
                String type = (String)attrProp.get("NAME");
                String shareId = (String)shareProp.get("SHARE_ID");
                SelectQuery sq = this.getSelectQuery(subAttributeList, shareId, type);
                Hashtable<String, Object> ht = new Hashtable<String, Object>();
                ht.put("sq", sq);
                ht.put("attr", subAttributeList);
                ht.put("table", "ADSMSharePermissionDetails_" + this.generationId);
                data.add(ht);
            }
            resultList.add(data);
        }
        return resultList;
    }

    @Override
    public SelectQuery getSelectQuery(ArrayList attrList, String shareId, String type) {
        String tableName = "ADSMSharePermissionDetails_" + this.generationId;
        SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)tableName));
        Criteria c = null;
        for (int i = 0; i < attrList.size(); ++i) {
            Properties p = (Properties)attrList.get(i);
            String columnName = (String)p.get("ATTRIB_COLUMN_NAME");
            if (i == 0) {
                SortColumn sc = new SortColumn(tableName, columnName, true);
                sq.addSortColumn(sc);
            }
            sq.addSelectColumn(Column.getColumn((String)tableName, (String)columnName));
        }
        sq.addSelectColumn(Column.getColumn((String)tableName, (String)"PERMISSION_ID"));
        if (shareId != null) {
            c = new Criteria(Column.getColumn((String)tableName, (String)"SHARE_ID"), (Object)shareId, 0);
            if (type != null) {
                c = c.and(new Criteria(Column.getColumn((String)tableName, (String)"PERMISSION_TYPE"), (Object)type, 0));
            }
            c = c.and(new Criteria(Column.getColumn((String)tableName, (String)"PERMISSIONS"), (Object)" ", 1));
            sq.setCriteria(c);
        }
        return sq;
    }

    @Override
    public ArrayList getSubreportDetails() {
        ArrayList<Properties> propList = new ArrayList<Properties>();
        Properties prop = new Properties();
        prop.put("SUBREPORT_ID", "1");
        prop.put("NAME", "NTFS");
        prop.put("FILE_NAME", "SubReportDesign.xml");
        prop.put("HEADING", "admp.subreports.heading.ntfs_permissions");
        propList.add(prop);
        prop = new Properties();
        prop.put("SUBREPORT_ID", "2");
        prop.put("NAME", "SHARE");
        prop.put("FILE_NAME", "SubReportDesign.xml");
        prop.put("HEADING", "admp.subreports.heading.share_permissions");
        propList.add(prop);
        return propList;
    }

    @Override
    public ArrayList getSubReportAttributes(String subReportId) {
        Integer[] attrIds;
        Integer[] subAttrs1 = new Integer[]{11162, 11161, 11163, 11164, 11165};
        Integer[] subAttrs2 = new Integer[]{11162, 11161, 11163, 11164};
        Hashtable<String, Integer[]> attrs = new Hashtable<String, Integer[]>();
        attrs.put("1", subAttrs1);
        attrs.put("2", subAttrs2);
        ArrayList<Properties> attributePropsList = new ArrayList<Properties>();
        for (Integer attrId : attrIds = (Integer[])attrs.get(subReportId)) {
            Properties props = ReportAttributeHandler.getInstance().getAttributeProps(attrId);
            attributePropsList.add(props);
        }
        return attributePropsList;
    }

    static {
        try {
            cacheMgr = (SIDCacheManager)CacheFactory.getInstance().getCache((Object)"sidCache");
            if (!cacheMgr.isInitialized()) {
                cacheMgr.initializeDomainSids();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public class Action
    extends Thread {
        private Map inputParams = null;
        private String domainName = null;
        private ArrayList attributeList = null;
        private NativeListener listener = null;
        private Long loginId = null;

        public Action(Long loginId, String domainName, Map inputParams, ArrayList attributeList, NativeListener li) {
            this.domainName = domainName;
            this.loginId = loginId;
            this.attributeList = attributeList;
            this.listener = li;
            this.inputParams = inputParams;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            SharesListener.this.errorMessage = null;
            if (!SharesListener.this.errorList.isEmpty()) {
                SharesListener.this.errorList = new Hashtable();
            }
            Hashtable tableProps = SharesListener.this.getQueueProps();
            ArrayList inputsList = (ArrayList)this.inputParams.get("trusteesList");
            for (int i = 0; i < inputsList.size(); ++i) {
                Hashtable<String, String> errors;
                if (!SharesListener.this.continueAction) continue;
                Hashtable inputValues = (Hashtable)inputsList.get(i);
                try {
                    SharesListener.this.setDomainName(this.domainName);
                    tableProps.put("inputId", (Long)inputValues.get("INPUT_ID"));
                    SharesListener.this.queue.registerForUpdation(SharesListener.this.baseTableName, SharesListener.this.generationId, tableProps);
                    ADHandler.getAllShares((String)this.domainName, (Long)this.loginId, (NativeListener)this.listener, (String)((String)inputValues.get("INPUT_NAME")));
                    int size = 0;
                    do {
                        try {
                            NativeListener nativeListener = this.listener;
                            synchronized (nativeListener) {
                                size = SharesListener.this.permissionsPropList.size();
                            }
                            Thread.sleep(500L);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } while (size > 0);
                    SharesListener.this.updateQueue();
                    continue;
                }
                catch (LocalizedException e) {
                    e.printStackTrace();
                    SharesListener.this.errorMessage = e.getMessage(SharesListener.this.rb);
                    errors = new Hashtable();
                    errors.put("INPUT_NAME", (String)inputValues.get("INPUT_NAME"));
                    errors.put("ERROR_MESSAGE", SharesListener.this.errorMessage);
                    SharesListener.this.errorList.put(inputValues.get("INPUT_ID").toString(), errors);
                    SharesListener.this.updateErrorStatus(errors);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    SharesListener.this.errorMessage = e.getMessage();
                    errors = new Hashtable<String, String>();
                    errors.put("INPUT_NAME", (String)inputValues.get("INPUT_NAME"));
                    errors.put("ERROR_MESSAGE", SharesListener.this.errorMessage);
                    SharesListener.this.errorList.put(inputValues.get("INPUT_ID").toString(), errors);
                    SharesListener.this.updateErrorStatus(errors);
                }
            }
            SharesListener.this.updateAction.shutDown();
            SharesListener.this.updatedCount = 0;
            SharesListener.this.totalCount = 0;
            SharesListener.this.deRegisterMap(SharesListener.this.generationId);
            SharesListener.this.completedAction();
        }
    }
}

