/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.reports;

import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.webclient.reports.AbstractNTFSReportsListener;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class SingleContainerListener
extends AbstractNTFSReportsListener {
    protected static Logger reportLogger = Logger.getLogger("ReportLogger");

    @Override
    public Long getCategoryId() {
        Long categoryId = new Long(-1L);
        return categoryId;
    }

    @Override
    protected void checkAttributeList(ArrayList attributeList) {
        attributeList.remove("objectSID");
        attributeList.add("objectGUID");
    }

    @Override
    public ArrayList getContainerList(HttpServletRequest request, ReportBean bean) {
        ArrayList<String> list = new ArrayList<String>();
        String[] domains = request.getParameterValues("domains");
        for (int i = 0; domains != null && i < domains.length; ++i) {
            list.add(domains[i]);
        }
        return list;
    }

    @Override
    protected void doAction(String domainName, Long loginId, String distinguishedName, ArrayList attributeList, NativeListener listener) throws Exception {
        System.out.println("this is working");
    }

    @Override
    public void start(ArrayList attributeList, HttpServletRequest request, ReportBean bean) {
        try {
            HttpSession session = request.getSession();
            this.loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            this.checkAttributeList(attributeList);
            HashMap<String, String> inputParams = new HashMap<String, String>();
            String[] domainList = request.getParameterValues("domains");
            inputParams.put("domain", ClientUtil.getString(domainList));
            ArrayList containerList = this.getContainerList(request, bean);
            Hashtable dnDomainNameMap = (Hashtable)bean.get("dnDomainNameMap");
            bean.set("inputParams", inputParams);
            String reportDomains = this.getReportDomains(domainList, dnDomainNameMap);
            this.getDescription(new Object[]{reportDomains});
            Action action = new Action(this.loginId, containerList, attributeList, this, dnDomainNameMap);
            action.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public class Action
    extends Thread {
        private ArrayList containerList = null;
        private ArrayList attributeList = null;
        private NativeListener listener = null;
        private Hashtable dnDomainNameMap = null;
        private Long loginId = null;

        public Action(Long loginId, ArrayList list, ArrayList attributeList, NativeListener li, Hashtable map) {
            this.loginId = loginId;
            this.containerList = list;
            this.attributeList = attributeList;
            this.listener = li;
            this.dnDomainNameMap = map;
        }

        @Override
        public void run() {
            SingleContainerListener.this.errorMessage = null;
            SingleContainerListener.this.guidList = new ArrayList();
            SingleContainerListener.this.updatedCount = 0;
            Hashtable tableProps = SingleContainerListener.this.getQueueProps();
            for (int i = 0; i < this.containerList.size(); ++i) {
                try {
                    String dn = (String)this.containerList.get(i);
                    SingleContainerListener.this.domainName = (String)this.dnDomainNameMap.get(dn);
                    SingleContainerListener.this.queue.registerForUpdation(SingleContainerListener.this.baseTableName, SingleContainerListener.this.generationId, tableProps);
                    reportLogger.log(Level.INFO, "Getting the Empty Groups from the domain " + SingleContainerListener.this.domainName);
                    SingleContainerListener.this.doAction(SingleContainerListener.this.domainName, this.loginId, dn, this.attributeList, this.listener);
                    SingleContainerListener.this.updateQueue();
                    continue;
                }
                catch (LocalizedException e) {
                    e.printStackTrace();
                    SingleContainerListener.this.errorMessage = e.getMessage(SingleContainerListener.this.rb);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    SingleContainerListener.this.errorMessage = e.getMessage();
                }
            }
            reportLogger.log(Level.INFO, "Completed the Reports Count : " + SingleContainerListener.this.totalCount);
            SingleContainerListener.this.updatedCount = 0;
            SingleContainerListener.this.totalCount = 0;
            SingleContainerListener.this.completedAction();
        }
    }
}

