/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.reports;

import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.AdmpInput;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.PolicyHandler;
import com.adventnet.sym.adsm.common.server.automation.ReportFilterConfig;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.queue.QueueHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportHandler;
import com.adventnet.sym.adsm.common.server.resultdata.ResultDataHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.webclient.reports.AbstractListener;
import com.adventnet.sym.adsm.common.webclient.reports.ListenerUtil;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import com.adventnet.sym.adsm.security.server.util.DateTimeUtil;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class SoonToPasswordExpireListener
extends AbstractListener {
    @Override
    protected void checkAttributeList(ArrayList attributeList) {
        if (!attributeList.contains("userAccountControl")) {
            attributeList.add("userAccountControl");
        }
    }

    @Override
    public void doAction(String domainName, Long loginId, String distinguishedName, ArrayList attributeList, NativeListener listener) throws Exception {
    }

    public void doAction(String domainName, Long loginId, String distinguishedName, ArrayList attributeList, NativeListener listener, long maxTime, long time) throws Exception {
        ADHandler.getSoonToPasswordExpireUsers((String)domainName, (Long)loginId, (String)distinguishedName, (ArrayList)attributeList, (NativeListener)listener, (long)maxTime, (long)time);
    }

    @Override
    public void getDescription(Object[] args) {
        this.desc = MessageFormat.format(this.rb.getString("admp.reports.pwd_reports.soon-to-exp_pwd.reportdesc_soon_to_exp_user_pwd_in_recent_days"), args);
    }

    public void doAction(String domainName, Long loginId, String dn, ArrayList attributeList, ArrayList psoList, long domMaxPwdAgeTime, long reportTime, NativeListener listener) throws Exception {
        ADHandler.getSoonToPasswordExpireUsersForW2K8((String)domainName, (Long)loginId, (String)dn, (ArrayList)attributeList, (ArrayList)psoList, (long)domMaxPwdAgeTime, (long)reportTime, (NativeListener)listener);
    }

    public void getDescription(Object[] args, String dataLableText) {
        ArrayList<Object> objectList = new ArrayList<Object>(Arrays.asList(args));
        String daysInterval = "";
        try {
            SimpleDateFormat formatter1 = new SimpleDateFormat("dd-MMM-yyyy", Locale.US);
            SimpleDateFormat formatter2 = new SimpleDateFormat("MM/dd/yyyy", Locale.US);
            String startVal = (String)objectList.get(0);
            String endVal = (String)objectList.get(1);
            if (dataLableText.equalsIgnoreCase("admp.common.matching_criteria.next_N_days")) {
                daysInterval = Integer.toString(DateTimeUtil.daysBetween((Date)formatter1.parse(startVal), (Date)formatter1.parse(endVal)));
            }
            objectList.add(daysInterval);
            Date date = formatter1.parse(startVal);
            Date date1 = formatter1.parse(endVal);
            objectList.set(0, formatter2.format(date));
            objectList.set(1, formatter2.format(date1));
            args = objectList.toArray();
            this.setDescription(args, dataLableText);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setDescription(Object[] args, String dataLableText) {
        this.desc = dataLableText.equalsIgnoreCase("admp.common.matching_criteria.next_N_days") ? MessageFormat.format(this.rb.getString("admp.reports.user_reports.soon_to_expire_password.reportdesc_next_N_days"), args) : (dataLableText.equalsIgnoreCase("admp.common.matching_criteria.today") ? MessageFormat.format(this.rb.getString("admp.reports.user_reports.soon_to_expire_password.reportdesc_for_date"), args) : MessageFormat.format(this.rb.getString("admp.reports.user_reports.soon_to_expire_password.reportdesc_between_dates"), args));
    }

    @Override
    public void start(ArrayList attributeList, HttpServletRequest request, ReportBean bean) {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        try {
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            this.checkAttributeList(attributeList);
            HashMap<String, String> inputParams = new HashMap<String, String>();
            long day = 7L;
            long time = 0L;
            String startDateVal = request.getParameter("startDate");
            String endDateVal = request.getParameter("endDate");
            String dataLableText = request.getParameter("dateLable");
            day = this.getDateInterval(startDateVal, endDateVal, dataLableText);
            if (day == 0L && dataLableText.equalsIgnoreCase("admp.common.matching_criteria.today")) {
                long hoursBetween = 0L;
                Calendar endoftheDay = Calendar.getInstance();
                Date currentTime = endoftheDay.getTime();
                endoftheDay.setTime(currentTime);
                endoftheDay.set(endoftheDay.get(1), endoftheDay.get(2), endoftheDay.get(5), 23, 59, 59);
                endoftheDay.set(14, 0);
                Date endoftheDayTime = new Date(endoftheDay.getTimeInMillis());
                hoursBetween = DateTimeUtil.hoursBetween((Date)currentTime, (Date)endoftheDayTime).intValue();
                time = hoursBetween * 60L * 60L * 1000L;
            } else {
                time = day * 24L * 60L * 60L * 1000L;
            }
            ArrayList containerList = this.getContainerList(request, bean);
            Hashtable dnDomainNameMap = (Hashtable)bean.get("dnDomainNameMap");
            Hashtable domainVsExcludeChildOU = (Hashtable)bean.get("domainVsExcludeChildOU");
            String[] domainList = request.getParameterValues("domains");
            inputParams.put("domain", ClientUtil.getString(domainList));
            bean.set("inputParams", inputParams);
            String reportDomains = this.getReportDomains(domainList, dnDomainNameMap);
            this.getDescription(new Object[]{startDateVal, endDateVal, rb.getString(dataLableText), reportDomains}, dataLableText);
            Hashtable excludedOUList = (Hashtable)bean.get("excludedOUList");
            Hashtable excludeContainerHash = this.constructExcludeContainerHash(containerList, domainVsExcludeChildOU, excludedOUList, dnDomainNameMap);
            Action action = new Action(loginId, containerList, attributeList, time, this, dnDomainNameMap, excludeContainerHash);
            action.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public long getDateInterval(String startDateVal, String endDateVal, String dataLableText) {
        long daysBetween = 0L;
        try {
            SimpleDateFormat formatter1 = new SimpleDateFormat("dd-MMM-yyyy", Locale.US);
            if (dataLableText.equalsIgnoreCase("admp.common.matching_criteria.this_month") || dataLableText.equalsIgnoreCase("admp.common.matching_criteria.this_week")) {
                Calendar today = Calendar.getInstance();
                Date currentDate = today.getTime();
                today.setTime(currentDate);
                today.set(today.get(1), today.get(2), today.get(5), 0, 0, 0);
                today.set(14, 0);
                Date todayDateVal = new Date(today.getTimeInMillis());
                daysBetween = DateTimeUtil.daysBetween((Date)todayDateVal, (Date)formatter1.parse(endDateVal)).intValue();
            } else {
                daysBetween = DateTimeUtil.daysBetween((Date)formatter1.parse(startDateVal), (Date)formatter1.parse(endDateVal)).intValue();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return daysBetween;
    }

    @Override
    public void executeTask(ArrayList containerList, Hashtable dnDomainNameMap, ReportFilterConfig reportFilterConfig) {
        this.executeTask(containerList, dnDomainNameMap, null, null, reportFilterConfig);
    }

    @Override
    public void executeTask(ArrayList containerList, Hashtable dnDomainNameMap, Hashtable excludedOUList, Hashtable domainVsExcludeChildOU, ReportFilterConfig reportFilterConfig) {
        try {
            reportLogger.log(Level.INFO, "Execute Task Started ");
            this.isCompleted = false;
            long value = 604800000L;
            Long reportDays = 0L;
            for (AdmpInput admpInput : reportFilterConfig.getInputList()) {
                if (admpInput.getIsMultiple().booleanValue()) continue;
                ListenerUtil.updateReportDaysForRegenerateReport(reportFilterConfig, admpInput, true);
                reportDays = Long.parseLong(admpInput.getValue());
                value = reportDays * 24L * 60L * 60L * 1000L;
            }
            HashMap dateValues = this.getScheduleDates(value);
            String startDateVal = (String)dateValues.get("startDate");
            String endDateVal = (String)dateValues.get("endDate");
            String schedulerDomains = this.getSchedulerDomains(containerList, dnDomainNameMap);
            this.getDescription(new Object[]{startDateVal, endDateVal, this.rb.getString("admp.common.matching_criteria.next_N_days"), schedulerDomains}, "admp.common.matching_criteria.next_N_days");
            this.generationId = ReportHandler.addReportGenerationDetails((Integer)this.reportId, (String)this.desc, (Long)this.loginId);
            Hashtable excludeContainerHash = this.constructExcludeContainerHash(containerList, domainVsExcludeChildOU, excludedOUList, dnDomainNameMap);
            Action action = new Action(1L, containerList, this.getAttributeList(), value, this, dnDomainNameMap, excludeContainerHash);
            action.start();
            while (!this.isCompleted) {
                try {
                    Thread.sleep(200L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ReportHandler.updateReportGenerationDetails((Long)this.generationId, (int)1, (String)this.desc, (Long)this.loginId);
            reportLogger.log(Level.INFO, "Execute Task Completed");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public HashMap getScheduleDates(long time) {
        HashMap<String, String> datesMap = new HashMap<String, String>();
        SimpleDateFormat formatter1 = new SimpleDateFormat("dd-MMM-yyyy", Locale.US);
        Date days = new Date(System.currentTimeMillis() + time);
        String endDateVal = formatter1.format(days);
        days = new Date(System.currentTimeMillis());
        String startDateVal = formatter1.format(days);
        datesMap.put("startDate", startDateVal);
        datesMap.put("endDate", endDateVal);
        return datesMap;
    }

    @Override
    public void setDashboardInputParams(Long dashboardReportMapping, HttpServletRequest request, ReportBean bean) {
        ListenerUtil.setDashboardInputParams(dashboardReportMapping, request, bean, 2);
    }

    public class Action
    extends Thread {
        private ArrayList containerList = null;
        private ArrayList attributeList = null;
        private NativeListener listener = null;
        private long time = -1L;
        private Hashtable dnDomainNameMap = null;
        private Long loginId = null;
        private Hashtable excludeChildOUHash = null;

        public Action(Long loginId, ArrayList list, ArrayList attributeList, long time, NativeListener li, Hashtable map, Hashtable excludeChildOUHash) {
            this.loginId = loginId;
            this.containerList = list;
            this.attributeList = attributeList;
            this.listener = li;
            this.dnDomainNameMap = map;
            this.time = time;
            this.excludeChildOUHash = excludeChildOUHash;
        }

        @Override
        public void run() {
            SoonToPasswordExpireListener.this.guidList = new ArrayList();
            Hashtable tableProps = SoonToPasswordExpireListener.this.getQueueProps();
            ArrayList objectIds = SoonToPasswordExpireListener.this.getObjIdList();
            SoonToPasswordExpireListener.this.queueRegID = QueueHandler.getInstance().registerForUpdate(objectIds, SoonToPasswordExpireListener.this.getTableColumns());
            SoonToPasswordExpireListener.this.resultRegID = ResultDataHandler.getInstance().getProcessor().registerForUpdate(SoonToPasswordExpireListener.this.resultTableName);
            for (int i = 0; i < this.containerList.size(); ++i) {
                try {
                    String dn = (String)this.containerList.get(i);
                    SoonToPasswordExpireListener.this.domainName = (String)this.dnDomainNameMap.get(dn);
                    Boolean isExcludeChildOU = Boolean.FALSE;
                    if (this.excludeChildOUHash != null && this.excludeChildOUHash.containsKey(dn)) {
                        isExcludeChildOU = (Boolean)this.excludeChildOUHash.get(dn);
                    }
                    this.listener.setIsExcludeChildOU(isExcludeChildOU);
                    Properties policy = PolicyHandler.getPolicies((String)SoonToPasswordExpireListener.this.domainName, (Long)this.loginId);
                    String domMaxPwdAge = policy.getProperty("maxPwdAge");
                    long domMaxPwdAgeTime = Long.parseLong(domMaxPwdAge) * 24L * 60L * 60L * 10000000L;
                    ArrayList psoList = PolicyHandler.getPSObjects((String)SoonToPasswordExpireListener.this.domainName);
                    String domainFuncLevel = CommonUtil.getDomainFunctionalLevel((String)SoonToPasswordExpireListener.this.domainName, (Long)this.loginId);
                    if (domainFuncLevel != null && (domainFuncLevel.equalsIgnoreCase("Windows Server 2008") || domainFuncLevel.equalsIgnoreCase("Windows Server 2008 R2")) && psoList != null && !psoList.isEmpty()) {
                        long reportTime = this.time * 10000L;
                        System.out.println("SoonToPwdExp Listener - reportTime: " + reportTime);
                        SoonToPasswordExpireListener.this.doAction(SoonToPasswordExpireListener.this.domainName, this.loginId, dn, this.attributeList, psoList, domMaxPwdAgeTime, reportTime, this.listener);
                        SoonToPasswordExpireListener.this.updateQueue();
                        continue;
                    }
                    if (domMaxPwdAge != null && !domMaxPwdAge.equals("0")) {
                        long currTime = System.currentTimeMillis();
                        long pwdAge = Long.parseLong(domMaxPwdAge) * 24L * 60L * 60L * 1000L;
                        long l = currTime - pwdAge;
                        long tt = this.time;
                        tt = pwdAge < tt ? currTime : currTime - (pwdAge - tt);
                        SoonToPasswordExpireListener.this.doAction(SoonToPasswordExpireListener.this.domainName, this.loginId, dn, this.attributeList, this.listener, l, tt);
                        SoonToPasswordExpireListener.this.updateQueue();
                        continue;
                    }
                    SoonToPasswordExpireListener.this.errorMessage = SoonToPasswordExpireListener.this.rb.getString("client.reports.SoonToPasswordExpireListener.since_the_domain_password_age_is_not_defined_there_are_no_user_with_soon_to_expire_password");
                    continue;
                }
                catch (LocalizedException excep) {
                    SoonToPasswordExpireListener.this.errorMessage = excep.getMessage(SoonToPasswordExpireListener.this.rb);
                    System.out.println("LocalizedException in SoonToPasswordExpireListener :-" + SoonToPasswordExpireListener.this.errorMessage);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    SoonToPasswordExpireListener.this.errorMessage = e.getMessage();
                }
            }
            SoonToPasswordExpireListener.this.updatedCount = 0;
            SoonToPasswordExpireListener.this.totalCount = 0;
            SoonToPasswordExpireListener.this.completedAction();
        }
    }
}

