/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.reports;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.GroupByClause;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.AdmpInput;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.DomainInfoCache;
import com.adventnet.sym.adsm.common.server.DomainProcess;
import com.adventnet.sym.adsm.common.server.adsync.ADSyncUtil;
import com.adventnet.sym.adsm.common.server.automation.ReportFilterConfig;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.model.ObjectClass;
import com.adventnet.sym.adsm.common.server.objects.DirectoryObjectAPI;
import com.adventnet.sym.adsm.common.server.queue.QueueHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportHandler;
import com.adventnet.sym.adsm.common.server.resultdata.ResultDataHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBUtil;
import com.adventnet.sym.adsm.common.server.util.SchedulerUtil;
import com.adventnet.sym.adsm.common.webclient.reports.RecentlyExpiredListener;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class TopBigGroupsListener
extends RecentlyExpiredListener {
    @Override
    public Long getCategoryId() {
        Long categoryId = new Long(1016L);
        return categoryId;
    }

    public ArrayList doAction(String domainName, Long loginId, String distinguishedName, ArrayList attributeList, int topCount, NativeListener listener) throws Exception {
        return ADHandler.getTopBigGroups((String)domainName, (Long)loginId, (String)distinguishedName, (int)topCount, (ArrayList)attributeList, (NativeListener)listener);
    }

    @Override
    public ArrayList getContainerList(HttpServletRequest request, ReportBean bean) {
        ArrayList<String> list = new ArrayList<String>();
        String[] domains = request.getParameterValues("domains");
        for (int i = 0; domains != null && i < domains.length; ++i) {
            list.add(domains[i]);
        }
        return list;
    }

    @Override
    public void getDescription(Object[] args) {
        this.desc = MessageFormat.format(this.rb.getString("admp.reports.grp_reports.top_grps.reportdesc_top_n_grps_of_the_domains"), args);
    }

    @Override
    public void setSyncEnabled() {
        this.setSyncEnabled(true);
    }

    @Override
    protected void checkAttributeList(ArrayList attributeList) {
    }

    public void doAction(String domainName, String distinguishedName, ArrayList attributeList, NativeListener listener) throws Exception {
    }

    @Override
    public void start(ArrayList attributeList, HttpServletRequest request, ReportBean bean) {
        try {
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            this.checkAttributeList(attributeList);
            this.setSyncEnabled();
            int topCount = -1;
            HashMap<String, String> inputParams = new HashMap<String, String>();
            String topCountStr = null;
            try {
                topCountStr = request.getParameter("topCount");
            }
            catch (Exception e) {
                topCount = -1;
            }
            topCount = Integer.parseInt(topCountStr);
            System.out.println("int topCount is " + topCount);
            ArrayList containerList = this.getContainerList(request, bean);
            Hashtable dnDomainNameMap = (Hashtable)bean.get("dnDomainNameMap");
            inputParams.put("topCount", String.valueOf(topCountStr));
            String[] domainList = request.getParameterValues("domains");
            inputParams.put("domain", ClientUtil.getString(domainList));
            bean.set("inputParams", inputParams);
            ArrayList selectedDomains = new ArrayList();
            Hashtable defaultNamingContextVsDomainName = DomainInfoCache.getInstance().getDefaultNamingContextVsDomainName();
            for (int i = 0; i < domainList.length; ++i) {
                selectedDomains.add(defaultNamingContextVsDomainName.get(domainList[i]));
            }
            String reportDomains = this.getReportDomains(domainList, dnDomainNameMap);
            this.getDescription(new Object[]{topCountStr, reportDomains});
            Action action = new Action(loginId, selectedDomains, containerList, attributeList, topCount, this, dnDomainNameMap, this.isSyncEnabled());
            action.start();
            System.out.println("Bean for topCount : " + inputParams);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Hashtable<String, ArrayList<String>> getTopBigGroups(Hashtable<String, Hashtable> domainVsGuidProp, int topCount) {
        Hashtable<String, ArrayList<String>> bigGroupHash = new Hashtable<String, ArrayList<String>>();
        ArrayList<String> bigGroupList = null;
        Connection connection = null;
        DataSet dataSet = null;
        try {
            domainVsGuidProp = (Hashtable)domainVsGuidProp.clone();
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"ADSMGroupMembers"));
            query.addSelectColumn(Column.getColumn((String)"ADSMGroupMembers", (String)"OBJECT_GUID"));
            Column countColumn = Column.getColumn((String)"ADSMGroupMembers", (String)"GROUP_MEMBER_OBJECTGUID");
            query.addSelectColumn(countColumn.count());
            ArrayList<Column> groupList = new ArrayList<Column>();
            groupList.add(Column.getColumn((String)"ADSMGroupMembers", (String)"OBJECT_GUID"));
            GroupByClause gr = new GroupByClause(groupList);
            query.setGroupByClause(gr);
            query.addSortColumn(new SortColumn(Column.getColumn((String)"ADSMGroupMembers", (String)"GROUP_MEMBER_OBJECTGUID").count(), Boolean.FALSE.booleanValue()));
            RelationalAPI relAPI = RelationalAPI.getInstance();
            connection = relAPI.getConnection();
            dataSet = relAPI.executeQuery((Query)query, connection);
            while (dataSet.next()) {
                String guid = (String)dataSet.getValue("OBJECT_GUID");
                for (String domainName : domainVsGuidProp.keySet()) {
                    Hashtable guidvsProp = (Hashtable)domainVsGuidProp.get(domainName);
                    if (guidvsProp.get(guid) == null) continue;
                    bigGroupList = bigGroupHash.get(domainName);
                    if (bigGroupList == null) {
                        bigGroupList = new ArrayList();
                        bigGroupHash.put(domainName, bigGroupList);
                    }
                    bigGroupList.add(guid);
                    if (bigGroupList.size() != topCount) break;
                    domainVsGuidProp.remove(domainName);
                    break;
                }
                if (domainVsGuidProp.size() != 0) continue;
                break;
            }
            DBUtil.closeDataSetAndConnection((DataSet)dataSet, (Connection)connection);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            DBUtil.closeDataSetAndConnection(dataSet, connection);
        }
        return bigGroupHash;
    }

    @Override
    public void executeTask(ArrayList containerList, Hashtable dnDomainNameMap, ReportFilterConfig reportFilterConfig) {
        this.executeTask(containerList, dnDomainNameMap, null, null, reportFilterConfig);
    }

    @Override
    public void executeTask(ArrayList containerList, Hashtable dnDomainNameMap, Hashtable excludedOUList, Hashtable domainVsExcludeChildOU, ReportFilterConfig reportFilterConfig) {
        try {
            reportLogger.log(Level.INFO, "Execute Task Started ");
            this.isCompleted = false;
            int topCount = 7;
            for (AdmpInput admpInput : reportFilterConfig.getInputList()) {
                if (admpInput.getIsMultiple().booleanValue()) continue;
                topCount = Integer.parseInt(admpInput.getValue());
            }
            String schedulerDomains = this.getSchedulerDomains(containerList, dnDomainNameMap);
            this.getDescription(new Object[]{topCount, schedulerDomains});
            this.setSyncEnabled();
            ArrayList scheduledDomains = SchedulerUtil.getSchedulerDomains((Long)reportFilterConfig.getScheduleId());
            this.generationId = ReportHandler.addReportGenerationDetails((Integer)this.reportId, (String)this.desc, (Long)this.loginId);
            Action action = new Action(1L, scheduledDomains, containerList, this.getAttributeList(), topCount, this, dnDomainNameMap, this.isSyncEnabled());
            action.start();
            while (!this.isCompleted) {
                try {
                    Thread.sleep(200L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ReportHandler.updateReportGenerationDetails((Long)this.generationId, (int)1, (String)this.desc, (Long)this.loginId);
            reportLogger.log(Level.INFO, "Execute Task Completed ");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class Action
    extends Thread {
        private ArrayList containerList = null;
        private ArrayList attributeList = null;
        private NativeListener listener = null;
        private int topCount = -1;
        private Hashtable dnDomainNameMap = null;
        private Long loginId = null;
        private ArrayList domainList = null;
        private boolean isSyncEnabled = false;

        public Action(Long loginId, ArrayList domainList, ArrayList list, ArrayList attributeList, int i, NativeListener li, Hashtable map, boolean isSyncEnabled) {
            this.loginId = loginId;
            this.containerList = list;
            this.attributeList = attributeList;
            this.listener = li;
            this.topCount = i;
            this.dnDomainNameMap = map;
            this.domainList = domainList;
            this.isSyncEnabled = isSyncEnabled;
        }

        @Override
        public void run() {
            TopBigGroupsListener.this.guidList = new ArrayList();
            Hashtable tableProps = TopBigGroupsListener.this.getQueueProps();
            String key = "";
            Hashtable<String, String> domainKey = new Hashtable<String, String>();
            if (this.isSyncEnabled) {
                this.attributeList = ADSyncUtil.getNonSyncAttributes((ArrayList)this.attributeList);
                for (int i = 0; i < this.domainList.size(); ++i) {
                    key = DomainHandler.doReportSync((String)((String)this.domainList.get(i)), (Long)CommonUtil.ADMIN_LOGIN_ID, (String[])new String[]{"user", "group", "computer", "contact", "groupMember", "primaryGroup"});
                    domainKey.put(key, (String)this.domainList.get(i));
                }
            }
            ArrayList objectIds = TopBigGroupsListener.this.getObjIdList();
            TopBigGroupsListener.this.queueRegID = QueueHandler.getInstance().registerForUpdate(objectIds, TopBigGroupsListener.this.getTableColumns());
            TopBigGroupsListener.this.resultRegID = ResultDataHandler.getInstance().getProcessor().registerForUpdate(TopBigGroupsListener.this.resultTableName);
            Hashtable<String, Hashtable> domainVsGuidProp = new Hashtable<String, Hashtable>();
            for (int i = 0; i < this.containerList.size(); ++i) {
                try {
                    String dn = (String)this.containerList.get(i);
                    TopBigGroupsListener.this.domainName = (String)this.dnDomainNameMap.get(dn);
                    Hashtable<String, Properties> guidvsProp = domainVsGuidProp.get(TopBigGroupsListener.this.domainName);
                    if (guidvsProp == null) {
                        guidvsProp = new Hashtable<String, Properties>();
                        domainVsGuidProp.put(TopBigGroupsListener.this.domainName, guidvsProp);
                    }
                    Properties domainDetails = HDTDomainHandler.getConfiguredValues((String)TopBigGroupsListener.this.domainName, (Long)CommonUtil.ADMIN_LOGIN_ID);
                    System.out.println("Getting the Locked Out User Reports for the domain " + TopBigGroupsListener.this.domainName);
                    if (this.attributeList.contains("member")) {
                        this.attributeList.remove("member");
                    }
                    ObjectClass obj = DirectoryObjectAPI.getInstance().getObjectClass("group");
                    String searchString = obj.getLdapCriteia() + "*))";
                    ArrayList list = ADHandler.getObjectsWOListener((Properties)domainDetails, (String)dn, (ArrayList)this.attributeList, (String)searchString);
                    for (int j = 0; j < list.size(); ++j) {
                        Properties p = (Properties)list.get(j);
                        guidvsProp.put(TopBigGroupsListener.this.getGuid(p), p);
                    }
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    TopBigGroupsListener.this.errorMessage = e.getMessage();
                }
            }
            if (!domainKey.isEmpty()) {
                String syncStatus = DomainProcess.getInstance().getProcessStatus(domainKey);
                while (TopBigGroupsListener.this.continueAction && syncStatus.equalsIgnoreCase("false")) {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    syncStatus = DomainProcess.getInstance().getProcessStatus(domainKey);
                }
            }
            Hashtable<String, ArrayList<String>> bigGroupHash = TopBigGroupsListener.getTopBigGroups(domainVsGuidProp, this.topCount);
            Hashtable guidvsProp = null;
            ArrayList<String> bigGroupList = null;
            Iterator<String> i$ = bigGroupHash.keySet().iterator();
            while (i$.hasNext()) {
                String domain;
                TopBigGroupsListener.this.domainName = domain = i$.next();
                guidvsProp = domainVsGuidProp.get(TopBigGroupsListener.this.domainName);
                bigGroupList = bigGroupHash.get(TopBigGroupsListener.this.domainName);
                for (String guid : bigGroupList) {
                    TopBigGroupsListener.this.addRow((Properties)guidvsProp.get(guid));
                }
            }
            TopBigGroupsListener.this.updateQueue();
            TopBigGroupsListener.this.updatedCount = 0;
            TopBigGroupsListener.this.totalCount = 0;
            TopBigGroupsListener.this.completedAction();
        }
    }
}

