/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.reports;

import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.DomainInfoCache;
import com.adventnet.sym.adsm.common.server.cvc.CVCDataUtil;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.model.ObjectClass;
import com.adventnet.sym.adsm.common.server.objects.DirectoryObjectAPI;
import com.adventnet.sym.adsm.common.server.reports.AdvReportsListener;
import com.adventnet.sym.adsm.common.server.reports.StatusUpdater;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.InputsUtil;
import com.adventnet.sym.adsm.common.webclient.reports.InActiveListener;
import com.adventnet.sym.adsm.common.webclient.reports.ReportDomain;
import com.adventnet.sym.adsm.common.webclient.reports.advanced.AdvancedReportsUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import org.json.JSONArray;

public class WAADInactiveUsersListener
extends InActiveListener {
    private AdvReportsListener advReportsListener = null;

    public WAADInactiveUsersListener() {
        this.lastLogonTableName = "ADSMUserGeneralDetails";
        this.multiDC = true;
    }

    @Override
    public void start(AdvReportsListener advReportsListener, ArrayList attributeList, DataObject cvcDO, Long loginId) {
        this.loginId = loginId;
        try {
            Hashtable dnDomainNameMap = (Hashtable)HDTDomainHandler.getDomainsAndOUs((Long)CommonUtil.ADMIN_LOGIN_ID).get("dnDomainNameMap");
            JSONArray selectedDomains = CVCDataUtil.getO365DelegatedLinkedDomainsData((DataObject)cvcDO);
            ArrayList selectedDomainsDnNames = new ArrayList();
            Hashtable domainVsDefaultNamingContext = DomainInfoCache.getInstance().getDomainVsDefaultNamingContext();
            for (int i = 0; i < selectedDomains.length(); ++i) {
                selectedDomainsDnNames.add(domainVsDefaultNamingContext.get(selectedDomains.getString(i)));
            }
            Hashtable reportDomains = AdvancedReportsUtil.getReportDomains(selectedDomainsDnNames);
            String selectedDomain = selectedDomains.getString(0);
            Properties waadDomainProps = DomainInfoCache.getInstance().getO356AccountProperties(selectedDomain);
            String tenantId = (String)waadDomainProps.get("WAAD_TENANT_ID");
            ReportDomain O365Domain = new ReportDomain();
            O365Domain.setDomainDetails(tenantId, loginId, 3);
            reportDomains.put(tenantId, O365Domain);
            this.O365DomainDetails = new Hashtable();
            Hashtable<String, Serializable> O365DomainProps = new Hashtable<String, Serializable>();
            Iterator it = cvcDO.getRows("CVCFolderLevelData");
            Row r = (Row)it.next();
            long inactiveDays = (Long)r.get("FOLDER_LEVEL");
            O365DomainProps.put("INACTIVE_DAYS", Long.valueOf(inactiveDays));
            O365DomainProps.put("WAAD_DOMAIN_PROPS", waadDomainProps);
            this.advReportsListener = advReportsListener;
            advReportsListener.initialize(cvcDO, this.getStatusController());
            ArrayList objectsList = InputsUtil.getObjectsList((DataObject)cvcDO);
            advReportsListener.initializeQueues(objectsList);
            O365DomainProps.put("ADVANCED_REPORTS_LISTENER", (Serializable)advReportsListener);
            this.O365DomainDetails.put(tenantId, O365DomainProps);
            String filterString = this.getFilterString(inactiveDays);
            Hashtable domainVsExcludeChildOU = new Hashtable();
            Hashtable excludedOUList = new Hashtable();
            this.statusController.init(reportDomains);
            this.statusController.setProgressTask(StatusUpdater.TASKCODE.FETCHING_DETAILS_FROM_DCS.getValue());
            InActiveListener.Action action = new InActiveListener.Action(loginId, reportDomains, attributeList, filterString, this, dnDomainNameMap, this.multiDC, excludedOUList, domainVsExcludeChildOU);
            action.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected String getFilterString(long inactiveDays) {
        String filterString = "(&(objectClass=user)(objectCategory=person)(!(sAMAccountType=805306370)))";
        return filterString;
    }

    @Override
    public void doAction(Properties domainDetails, String distinguishedName, String dcName, ArrayList attributeList, NativeListener listener, String filterString) throws Exception {
        ADHandler.getInActiveUsers((Properties)domainDetails, (String)distinguishedName, (String)dcName, (ArrayList)attributeList, (NativeListener)listener, (String)filterString);
    }

    @Override
    protected Hashtable getTableColumns() {
        Hashtable hash = super.getTableColumns();
        Hashtable O365IAUsersTableColumns = this.advReportsListener.getTableColumnHash();
        Enumeration e = O365IAUsersTableColumns.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            hash.put(key, O365IAUsersTableColumns.get(key));
        }
        return hash;
    }

    @Override
    protected ArrayList getObjIdList() {
        ArrayList objIdList = super.getObjIdList();
        ObjectClass objclass = DirectoryObjectAPI.getInstance().getObjectClassFromBaseTableName("O365UserGeneralDetails");
        ArrayList objectIds = new ArrayList();
        objIdList.add(objclass.getId());
        return objIdList;
    }

    @Override
    public String getSearchString(String filterString) {
        return filterString;
    }
}

