/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.reports;

import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.webclient.util.DeleteUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.model.ZipParameters;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;

public class ZipUtility {
    ZipArchiveOutputStream cpZipOutputStream = null;
    String strSource = "";
    String strTarget = "";
    String strSubstring = "";
    static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();

    public static void addtoZip(Long schedule_id, String dir) {
        ZipUtility udZipUtility = new ZipUtility();
        udZipUtility.strSource = dir;
        udZipUtility.strTarget = dir + File.separator + "admp-reports.zip";
        udZipUtility.zip();
    }

    private void zip() {
        try {
            File cpFile = new File(this.strSource);
            if (!cpFile.isFile() && !cpFile.isDirectory()) {
                System.out.println("\nSource file/directory Not Found!");
                return;
            }
            this.strSubstring = cpFile.isDirectory() ? this.strSource : "";
            this.cpZipOutputStream = new ZipArchiveOutputStream((OutputStream)new FileOutputStream(this.strTarget));
            this.cpZipOutputStream.setMethod(8);
            this.cpZipOutputStream.setLevel(9);
            this.zipFiles(cpFile);
            this.cpZipOutputStream.finish();
            this.cpZipOutputStream.close();
            System.out.println("\n Finished creating zip file " + this.strTarget + " from source " + this.strSource);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void zippedAndDeleteFiles(String storageDir, ArrayList zippedFilesList, HttpServletResponse response, String outFile) {
        try {
            response.setContentType("application/x-zip-compressed");
            outFile = outFile.replace(' ', '_');
            response.setHeader("Content-Disposition", "attachement;filename=ADMPReport.zip");
            ZipUtility.zipFiles(storageDir, zippedFilesList, outFile);
            byte[] buf = new byte[1024];
            try {
                File file = new File(outFile);
                long length = file.length();
                BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
                ServletOutputStream out = response.getOutputStream();
                response.setContentLength((int)length);
                while (in != null && (length = (long)in.read(buf)) != -1L) {
                    out.write(buf, 0, (int)length);
                }
                in.close();
                out.close();
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
            DeleteUtil.deleteFile(zippedFilesList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void zipFiles(String storageDir, ArrayList fileList, String outFile) {
        try {
            ZipArchiveOutputStream cpZipOutputStream = new ZipArchiveOutputStream((OutputStream)new FileOutputStream(outFile));
            cpZipOutputStream.setMethod(8);
            cpZipOutputStream.setLevel(9);
            try {
                for (int index = 0; index < fileList.size(); ++index) {
                    String fileName = (String)fileList.get(index);
                    File file = new File(fileName);
                    String zipFileName = file.getName();
                    ZipUtility.addToZipFile(storageDir + File.separator + zipFileName, cpZipOutputStream);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            cpZipOutputStream.finish();
            cpZipOutputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void addToZipFile(String fileName, ZipArchiveOutputStream zos) throws FileNotFoundException, IOException {
        int length;
        File file = new File(fileName);
        FileInputStream fis = new FileInputStream(file);
        ZipArchiveEntry zipEntry = new ZipArchiveEntry(file.getName());
        zos.putArchiveEntry((ArchiveEntry)zipEntry);
        byte[] bytes = new byte[1024];
        while ((length = fis.read(bytes)) >= 0) {
            zos.write(bytes, 0, length);
        }
        zos.closeArchiveEntry();
        fis.close();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void zipFiles(File cpFile) {
        if (cpFile.isDirectory()) {
            File[] fList = cpFile.listFiles();
            for (int i = 0; i < fList.length; ++i) {
                this.zipFiles(fList[i]);
            }
            return;
        } else {
            try {
                String strAbsPath = cpFile.getAbsolutePath();
                String strZipEntryName = "";
                strZipEntryName = !this.strSubstring.equals("") ? strAbsPath.substring(this.strSource.length() + 1, strAbsPath.length()) : cpFile.getName();
                if (strZipEntryName.endsWith("admp-reports.zip")) return;
                byte[] b = new byte[(int)cpFile.length()];
                FileInputStream cpFileInputStream = new FileInputStream(cpFile);
                int i = cpFileInputStream.read(b, 0, (int)cpFile.length());
                ZipArchiveEntry cpZipEntry = new ZipArchiveEntry(strZipEntryName);
                this.cpZipOutputStream.putArchiveEntry((ArchiveEntry)cpZipEntry);
                this.cpZipOutputStream.write(b, 0, (int)cpFile.length());
                this.cpZipOutputStream.closeArchiveEntry();
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void makeZip(String storageDir, String password) throws Exception {
        ZipUtility.makeZip(storageDir, password, null, null);
    }

    public static void makeZip(String storageDir, String password, ArrayList<String> list, HttpServletResponse response) throws Exception {
        ZipUtility.makeZip(storageDir, password, list, response, null);
    }

    public static void makeZip(String storageDir, String password, ArrayList<String> list, HttpServletResponse response, String zipName) throws Exception {
        ArrayList<File> filesList = new ArrayList<File>();
        String resultFile = storageDir + File.separator;
        resultFile = zipName != null && !zipName.equals("") ? resultFile + zipName : resultFile + "admp-reports.zip";
        File resFile = new File(resultFile);
        if (resFile.exists()) {
            resFile.delete();
        }
        ZipFile zipFile = new ZipFile(resultFile);
        ZipParameters zp = new ZipParameters();
        zp.setCompressionMethod(8);
        zp.setCompressionLevel(5);
        if (password != null && !password.equals("")) {
            zp.setEncryptFiles(true);
            zp.setEncryptionMethod(99);
            zp.setAesKeyStrength(3);
            zp.setPassword(password.toCharArray());
        }
        if (list != null) {
            for (String file : list) {
                filesList.add(new File(file));
            }
        } else {
            File dir = new File(storageDir);
            if (dir.isDirectory()) {
                File[] fList = dir.listFiles();
                list = new ArrayList();
                for (int i = 0; i < fList.length; ++i) {
                    filesList.add(fList[i]);
                    String path = fList[i].getCanonicalPath();
                    list.add(path);
                }
            }
        }
        zipFile.addFiles(filesList, zp);
        if (response != null) {
            response.reset();
            response.setContentType("application/zip");
            response.setHeader("content-disposition", "attachment;filename=ADMPReports.zip");
            Files.copy(Paths.get(resultFile, new String[0]), (OutputStream)response.getOutputStream());
            DeleteUtil.deleteFile(list);
        }
    }
}

