/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.reports.advanced;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.AdvancedSchedulerUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.LicenseMgr;
import com.adventnet.sym.adsm.common.server.util.RVUtil;
import com.adventnet.sym.adsm.common.server.util.SchedulerHandler;
import com.adventnet.sym.adsm.common.server.util.SchedulerLicenseUtil;
import com.adventnet.sym.adsm.common.server.util.SchedulerUtil;
import com.adventnet.sym.adsm.common.webclient.reports.advanced.AdvancedReportsUtil;
import com.adventnet.sym.adsm.common.webclient.util.ClientAuthorizationUtil;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import com.adventnet.sym.adsm.common.webclient.util.SchedulerInputsUtil;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;
import org.json.JSONObject;

public class AdvancedSchedulerAction
extends DispatchAction {
    private Logger logger = Logger.getLogger(AdvancedSchedulerAction.class.getName());

    public ActionForward getSchedulerUI(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (ClientAuthorizationUtil.isAuthorized(request, 31513L).booleanValue()) {
            Locale locale = request.getLocale();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            String forwardPage = "advancedScheduler";
            return mapping.findForward(forwardPage);
        }
        return null;
    }

    public ActionForward createOrEditScheduler(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        String forwardPage = "createNewScheduler";
        String action = request.getParameter("action");
        ArrayList reportDetailsList = new ArrayList();
        try {
            if (action.equalsIgnoreCase("edit")) {
                String schedulerIdtr = request.getParameter("schedulerId");
                Long schedulerId = Long.parseLong(schedulerIdtr);
                this.logger.log(Level.INFO, "Going edit the schedule" + schedulerId);
                DataObject dataObject = CommonUtil.getCachedPersistence().get("ADSMAdvancedScheduler", new Criteria(Column.getColumn((String)"ADSMAdvancedScheduler", (String)"SCHEDULE_ID"), (Object)schedulerId, 0));
                Row currentSchedulerRow = dataObject.getRow("ADSMAdvancedScheduler");
                Integer currentSchedulerReportId = (Integer)currentSchedulerRow.get("REPORT_ID");
                Long currentCvcDataId = (Long)currentSchedulerRow.get("CVC_DATA_ID");
                request.setAttribute("reportId", (Object)currentSchedulerReportId);
                request.setAttribute("schedulerId", (Object)schedulerId);
                Criteria crit = new Criteria(Column.getColumn((String)"ADMPReportsCVC", (String)"IS_SCHEDULE_SUPPORT"), (Object)"true", 0);
                DataObject dataObj = CommonUtil.getCachedPersistence().get("ADMPReportsCVC", crit);
                Iterator itr = dataObj.getRows("ADMPReportsCVC");
                Hashtable<String, Object> details = null;
                while (itr.hasNext()) {
                    details = new Hashtable<String, Object>();
                    Row row = (Row)itr.next();
                    Integer reportId = (Integer)row.get("REPORT_ID");
                    if (!ClientAuthorizationUtil.isAuthorized(request, reportId)) continue;
                    Long cvcId = (Long)row.get("CVC_ID");
                    Integer iamAppId = (Integer)row.get("IAM_APP_ID");
                    Long cvcDataId = AdvancedReportsUtil.getCVCDataId(reportId, loginId, session.getId());
                    details.put("iamAppId", iamAppId);
                    details.put("reportName", rb.getString(RVUtil.getReportColumnValue((Integer)reportId, (String)"REPORT_NAME")));
                    details.put("reportId", reportId);
                    details.put("cvcId", cvcId);
                    if (reportId.equals(currentSchedulerReportId)) {
                        details.put("cvcDataUd", currentCvcDataId);
                    } else {
                        details.put("cvcDataUd", cvcDataId);
                    }
                    details.put("actionId", ClientUtil.getActionId(reportId));
                    reportDetailsList.add(details);
                }
            } else {
                this.logger.log(Level.INFO, "Going to create new scheduler");
                Criteria crit = new Criteria(Column.getColumn((String)"ADMPReportsCVC", (String)"IS_SCHEDULE_SUPPORT"), (Object)"true", 0);
                DataObject dataObj = CommonUtil.getCachedPersistence().get("ADMPReportsCVC", crit);
                Iterator itr = dataObj.getRows("ADMPReportsCVC");
                Hashtable<String, Object> details = null;
                while (itr.hasNext()) {
                    details = new Hashtable<String, Object>();
                    Row row = (Row)itr.next();
                    Integer reportId = (Integer)row.get("REPORT_ID");
                    if (!ClientAuthorizationUtil.isAuthorized(request, reportId)) continue;
                    Long cvcId = (Long)row.get("CVC_ID");
                    Integer iamAppId = (Integer)row.get("IAM_APP_ID");
                    Long cvcDataId = AdvancedReportsUtil.getCVCDataId(reportId, loginId, session.getId());
                    details.put("reportName", rb.getString(RVUtil.getReportColumnValue((Integer)reportId, (String)"REPORT_NAME")));
                    details.put("reportId", reportId);
                    details.put("cvcId", cvcId);
                    details.put("cvcDataUd", cvcDataId);
                    details.put("actionId", ClientUtil.getActionId(reportId));
                    details.put("iamAppId", iamAppId);
                    reportDetailsList.add(details);
                }
                if (reportDetailsList.isEmpty()) {
                    this.logger.log(Level.FINE, "reportDetailsList is empty");
                    return null;
                }
            }
            request.setAttribute("reportDetailsList", reportDetailsList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward(forwardPage);
    }

    public ActionForward saveScheduler(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        String statusMessage = rb.getString("client.reports.SchedulerAction.successfully_created_the_scheduler");
        String status = "Success";
        Long scheduleId = 0L;
        boolean duplicate = false;
        boolean isUpdate = false;
        try {
            String isLicensed;
            block15: {
                JSONObject timeFreqDataJsonObject = new JSONObject(request.getParameter("TimeFrequencyData"));
                JSONObject schedulerDataJsonObject = new JSONObject(request.getParameter("schedulerData"));
                String schedulerName = schedulerDataJsonObject.getString("schedulerName");
                String action = request.getParameter("action");
                isLicensed = LicenseMgr.getInstance().getLicenseProperty("Scheduler", "Scheduler");
                System.out.println("Advanced Scheduler Creation " + isLicensed + " action " + action);
                String scheduleType = timeFreqDataJsonObject.getString("scheduleType");
                Hashtable<String, Object> customProp = new Hashtable<String, Object>();
                if (scheduleType.equalsIgnoreCase("Custom")) {
                    customProp.put("startingDate", timeFreqDataJsonObject.getString("startDate"));
                    customProp.put("repType", timeFreqDataJsonObject.getString("repeatType"));
                    customProp.put("skipFrequency", timeFreqDataJsonObject.getInt("repeatInterval"));
                    customProp.put("monthdaydate", timeFreqDataJsonObject.getString("monthdaydate"));
                    customProp.put("selectedDays", timeFreqDataJsonObject.getString("selectedDays"));
                    customProp.put("selectedMonths", timeFreqDataJsonObject.getString("selectedMonths"));
                    customProp.put("dayofmonth", timeFreqDataJsonObject.getInt("monthdatesel"));
                    customProp.put("weekofmonth", timeFreqDataJsonObject.getInt("monthweeksel"));
                    customProp.put("dayofweek", timeFreqDataJsonObject.getInt("monthdaysel"));
                }
                if (action.equalsIgnoreCase("save") && isLicensed.equalsIgnoreCase("true")) {
                    try {
                        SchedulerLicenseUtil.checkSchedulerRestriction((String)"Scheduler", (AdventNetResourceBundle)rb);
                        duplicate = SchedulerInputsUtil.checkForDuplicateScheduler(schedulerName);
                        this.logger.log(Level.FINE, "Duplicate check for schedulename " + schedulerName + " bnool " + duplicate);
                        if (!duplicate) {
                            scheduleId = SchedulerHandler.createScheduler((String)schedulerName, (String)scheduleType, (int)timeFreqDataJsonObject.getInt("hours"), (int)timeFreqDataJsonObject.getInt("minutes"), (int)timeFreqDataJsonObject.getInt("day"), (int)timeFreqDataJsonObject.getInt("date"), (String)"AdvancedScheduleReports", customProp);
                            this.logger.log(Level.FINE, " New scheduler id " + scheduleId);
                            break block15;
                        }
                        statusMessage = rb.getString("admp.reports.scheduled_reports.error_occured_creating_check_scheduler_with_same_name");
                        status = "Error";
                    }
                    catch (Exception e) {
                        this.logger.log(Level.INFO, "Exception occurs while adding new Advanced scheduler" + e.getMessage());
                        status = "Error";
                        statusMessage = rb.getString(e.getMessage());
                    }
                } else if (action.equalsIgnoreCase("update")) {
                    scheduleId = schedulerDataJsonObject.getLong("schedulerId");
                    String currentScheduleName = SchedulerUtil.getSchedulerName((long)scheduleId);
                    duplicate = currentScheduleName.equals(schedulerName) ? false : SchedulerInputsUtil.checkForDuplicateScheduler(schedulerName);
                    this.logger.log(Level.FINE, "Going to update the existing scheduler " + scheduleId + " :L " + duplicate);
                    if (!duplicate) {
                        boolean Status = SchedulerHandler.updateScheduler((Long)scheduleId, (String)schedulerName, (String)scheduleType, (int)timeFreqDataJsonObject.getInt("hours"), (int)timeFreqDataJsonObject.getInt("minutes"), (int)timeFreqDataJsonObject.getInt("day"), (int)timeFreqDataJsonObject.getInt("date"), customProp);
                        isUpdate = true;
                        if (Status) {
                            statusMessage = rb.getString("client.reports.SchedulerAction.successfully_updated_the_scheduler");
                        }
                    } else {
                        statusMessage = rb.getString("admp.reports.scheduled_reports.error_occured_creating_check_scheduler_with_same_name");
                        status = "Error";
                    }
                }
            }
            System.out.println("Status " + status + " statusmessagvb " + statusMessage);
            if (!status.equals("Error") && isLicensed.equalsIgnoreCase("true")) {
                SchedulerInputsUtil.addSchedulerDetails(scheduleId, loginId, request, isUpdate);
            } else {
                this.logger.log(Level.INFO, "Status is false " + status);
            }
            if (isLicensed.equalsIgnoreCase("false")) {
                status = "Error";
                statusMessage = rb.getString("admp.reports.sche_reports.common.license_error");
            }
            ClientUtil.setStatusXMLElement(response, status, statusMessage, new Properties());
        }
        catch (Exception e) {
            e.printStackTrace();
            statusMessage = e.getMessage();
            ClientUtil.setStatusXMLElement(response, "Error", statusMessage, new Properties());
        }
        return null;
    }

    public ActionForward getSchedulerDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            String schedulerIdtr = request.getParameter("schedulerId");
            Long scheduleId = Long.parseLong(schedulerIdtr);
            JSONObject json = AdvancedSchedulerUtil.getJSONForEdit((Long)scheduleId);
            response.setContentType("application/json");
            PrintWriter writer = response.getWriter();
            writer.print(json.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

