/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.reports.advanced;

import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.AdmpInput;
import com.adventnet.sym.adsm.common.server.DomainInfoCache;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.audit.DataImportExportAudit;
import com.adventnet.sym.adsm.common.server.cvc.CVCDataUtil;
import com.adventnet.sym.adsm.common.server.cvc.CVCUtil;
import com.adventnet.sym.adsm.common.server.helpdesk.ADMPAuthObject;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.reports.ReportController;
import com.adventnet.sym.adsm.common.server.reports.ReportHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportsUtil;
import com.adventnet.sym.adsm.common.server.reports.StatusUpdater;
import com.adventnet.sym.adsm.common.server.resultview.ColumnCustomizationHandler;
import com.adventnet.sym.adsm.common.server.resultview.RVCConstants;
import com.adventnet.sym.adsm.common.server.resultview.RVHandler;
import com.adventnet.sym.adsm.common.server.resultview.RVReqParams;
import com.adventnet.sym.adsm.common.server.resultview.ResultViewDataHandler;
import com.adventnet.sym.adsm.common.server.util.HelpdeskUtil;
import com.adventnet.sym.adsm.common.server.util.I18NUtil;
import com.adventnet.sym.adsm.common.server.util.PasswordUtil;
import com.adventnet.sym.adsm.common.server.util.RVColumnUtil;
import com.adventnet.sym.adsm.common.server.util.RVUtil;
import com.adventnet.sym.adsm.common.webclient.export.ReportPdfExporter;
import com.adventnet.sym.adsm.common.webclient.reports.AbstractListener;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.reports.ReportDomain;
import com.adventnet.sym.adsm.common.webclient.reports.ReportExportUtil;
import com.adventnet.sym.adsm.common.webclient.reports.ReportResultInputUtil;
import com.adventnet.sym.adsm.common.webclient.reports.advanced.AdvancedReportsUtil;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import com.adventnet.sym.adsm.common.webclient.util.ReportClientUtil;
import com.adventnet.sym.adsm.common.webclient.util.ajax.AjaxUtil;
import com.adventnet.sym.adsm.security.server.util.DateTimeUtil;
import com.manageengine.ads.fw.privacy.PrivacyHandler;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;
import org.json.JSONArray;
import org.json.JSONObject;

public class ReportRVAction
extends DispatchAction {
    private Logger logger = Logger.getLogger(ReportRVAction.class.getName());

    public ActionForward getDynamicUpdateDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String forwardPage = "";
        JSONObject jsonObject = null;
        try {
            HttpSession session = request.getSession();
            JSONObject reqJSONObject = new JSONObject(request.getParameter("params"));
            Long generationId = reqJSONObject.getInt("generationId");
            StatusUpdater dynamicUpdator = ReportController.getInstance().getStatus(generationId);
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            if (dynamicUpdator == null) {
                jsonObject = new JSONObject();
                jsonObject.put("isCompleted", true);
            } else {
                jsonObject = dynamicUpdator.getJSONObject(reqJSONObject, rb);
            }
            response.setContentType("application/json");
            PrintWriter writer = response.getWriter();
            writer.print(jsonObject.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward getSummaryFilterCount(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        JSONObject jsonObject = null;
        try {
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            jsonObject = new JSONObject(request.getParameter("params"));
            jsonObject.put("loginId", (Object)loginId);
            DataObject cvcDataDO = CVCDataUtil.getCVCDataDO((Long)jsonObject.getLong("cvcDataId"), (ArrayList)CVCDataUtil.getComponentsList((Long)CVCUtil.getCVCId((Integer)jsonObject.getInt("reportId"))));
            DataObject rvcDataObject = ResultViewDataHandler.getRVCDataObject((Integer)jsonObject.getInt("reportId"), (DataObject)cvcDataDO);
            JSONObject json = new JSONObject();
            json.put("filterDetails", (Object)RVHandler.getSummaryDashBoardDetails((JSONObject)jsonObject, (DataObject)rvcDataObject));
            String configData = AjaxUtil.getResponse("filtersCount", json);
            AjaxUtil.writeJsonResponse(response, configData);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward getFullScreenView(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String forwardPage = "";
        try {
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            forwardPage = "fullScreenView";
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward(forwardPage);
    }

    public ActionForward getMultiDCViewUI(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String forwardPage = "";
        try {
            HttpSession session = request.getSession();
            Long cvcDataId = Long.parseLong(request.getParameter("cvcDataId"));
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            Integer reportId = Integer.parseInt(request.getParameter("reportId"));
            Hashtable reportDomainDetails = new Hashtable();
            DataObject cvcDataDO = CVCDataUtil.getCVCDataDO((Long)cvcDataId, (ArrayList)CVCDataUtil.getComponentsList((Long)CVCUtil.getCVCId((Integer)reportId)));
            if (reportId == 53) {
                HashMap<String, Hashtable> inputParams = new HashMap<String, Hashtable>();
                JSONArray selectedDomains = CVCDataUtil.getO365DelegatedLinkedDomainsData((DataObject)cvcDataDO);
                ArrayList selectedDomainsDnNames = new ArrayList();
                Hashtable domainVsDefaultNamingContext = DomainInfoCache.getInstance().getDomainVsDefaultNamingContext();
                for (int i = 0; i < selectedDomains.length(); ++i) {
                    selectedDomainsDnNames.add(domainVsDefaultNamingContext.get(selectedDomains.getString(i)));
                }
                reportDomainDetails = AdvancedReportsUtil.getReportDomains(selectedDomainsDnNames);
                String selectedDomain = selectedDomains.getString(0);
                Properties waadDomainProps = DomainInfoCache.getInstance().getO356AccountProperties(selectedDomain);
                String tenantId = (String)waadDomainProps.get("WAAD_TENANT_ID");
                ReportDomain O365Domain = new ReportDomain();
                O365Domain.setDomainDetails(tenantId, loginId, 3);
                reportDomainDetails.put(tenantId, O365Domain);
                inputParams.put("reportDomains", reportDomainDetails);
                request.setAttribute("inputParams", inputParams);
            } else {
                String cvcDomainName = CVCDataUtil.getCVCSelectedDomain((DataObject)cvcDataDO);
                Properties domainDetails = HDTDomainHandler.getConfiguredValues((String)cvcDomainName, (Long)loginId);
                ArrayList list = (ArrayList)domainDetails.get("DOMAIN_CONTROLLER_LIST");
                reportDomainDetails.put(cvcDomainName, list);
                request.setAttribute("reportDomains", reportDomainDetails);
            }
            forwardPage = "multiDCView";
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward(forwardPage);
    }

    public ActionForward getErrorList(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String forwardPage = "";
        try {
            forwardPage = "errorList";
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward(forwardPage);
    }

    public ActionForward saveColumn(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            String substring = request.getParameter("substring");
            Integer uniqueId = Integer.parseInt(request.getParameter("uniqueId"));
            Integer reportId = Integer.parseInt(request.getParameter("reportId"));
            String[] columnIdsArray = substring.split(",");
            Integer[] visibleColumns = new Integer[columnIdsArray.length];
            for (int i = 0; i < columnIdsArray.length; ++i) {
                visibleColumns[i] = new Integer(columnIdsArray[i]);
            }
            ColumnCustomizationHandler.updateColumnList((Integer[])visibleColumns, (Integer)uniqueId, (Long)loginId);
            ArrayList objectIdList = RVUtil.getObjectIdsList((Integer)uniqueId);
            if (objectIdList.size() == 1) {
                ColumnCustomizationHandler.updateReportsColumnList((Integer[])visibleColumns, (Integer)reportId, (Long)loginId, (Integer)((Integer)objectIdList.get(0)));
            }
            ClientUtil.setStatusXMLElement(response, "Success", "");
        }
        catch (Exception e) {
            e.printStackTrace();
            ClientUtil.setStatusXMLElement(response, "Error", "");
        }
        return null;
    }

    public ActionForward saveTotalColumn(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            String substring = request.getParameter("substring");
            Integer objectID = Integer.parseInt(request.getParameter("objectID"));
            ArrayList<Integer> objectsList = new ArrayList<Integer>();
            objectsList.add(objectID);
            Integer reportId = Integer.parseInt(request.getParameter("reportId"));
            String[] columnIdsArray = substring.split(",");
            ArrayList<Integer> visibleColumns = new ArrayList<Integer>(columnIdsArray.length);
            for (int i = 0; i < columnIdsArray.length; ++i) {
                visibleColumns.add(new Integer(columnIdsArray[i]));
            }
            ArrayList prevTotalList = RVColumnUtil.getAttributeIds((ArrayList)RVColumnUtil.getViewColumnList((String)"ADSMTotalReports", (Long)loginId, (Integer)reportId, objectsList, null));
            ArrayList newAttribs = new ArrayList();
            for (int i = 0; i < visibleColumns.size(); ++i) {
                if (prevTotalList.contains(visibleColumns.get(i))) continue;
                newAttribs.add(visibleColumns.get(i));
            }
            RVColumnUtil.saveTotalColumns((Long)loginId, (Integer)reportId, (Integer)objectID, visibleColumns, (boolean)true);
            RVColumnUtil.checkViewColumns((Long)loginId, (Integer)reportId, (Integer)objectID, newAttribs, (Boolean)true);
            ClientUtil.setStatusXMLElement(response, "Success", "");
        }
        catch (Exception e) {
            e.printStackTrace();
            ClientUtil.setStatusXMLElement(response, "Error", "");
        }
        return null;
    }

    public ActionForward exportReport(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            String storageDir;
            File dir;
            HttpSession session = request.getSession();
            Long cvcDataId = Long.parseLong(request.getParameter("cvcDataId"));
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            Integer reportId = Integer.parseInt(request.getParameter("reportId"));
            Long generationId = Long.parseLong(request.getParameter("generationId"));
            String exportType = request.getParameter("exportType");
            String opFilter = request.getParameter("outputFilter");
            Locale locale = I18NUtil.getDefaultLocale((HttpServletRequest)request);
            String exportView = request.getParameter("exportView");
            String searchText = request.getParameter("searchText");
            String searchCriteriaType = request.getParameter("searchCriteriaType");
            if (searchText == null || searchText.length() == 0) {
                searchText = "{}";
            }
            if (searchCriteriaType == null || searchCriteriaType.length() == 0) {
                searchCriteriaType = "{}";
            }
            JSONObject searchTextJSON = new JSONObject(searchText);
            JSONObject searchCriteriaJSON = new JSONObject(searchCriteriaType);
            String matchCriteria = request.getParameter("matchingCriteria");
            String customParams = request.getParameter("customParams");
            ArrayList exportViewsList = new ArrayList();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            ArrayList cvcOutputFilters = null;
            if (opFilter == null) {
                cvcOutputFilters = CVCUtil.getCVCSelectedInputList((Long)cvcDataId);
            }
            DataObject cvcDataDO = CVCDataUtil.getCVCDataDO((Long)cvcDataId, (ArrayList)CVCDataUtil.getComponentsList((Long)CVCUtil.getCVCId((Integer)reportId)));
            DataObject rvcDataObject = ResultViewDataHandler.getRVCDataObject((Integer)reportId, (DataObject)cvcDataDO);
            boolean exportCurrentView = false;
            if (request.getParameter("exportCurrentView") != null) {
                exportCurrentView = request.getParameter("exportCurrentView").equalsIgnoreCase("true");
            }
            Integer viewId = 0;
            if (request.getParameter("viewId") != null) {
                viewId = Integer.parseInt(request.getParameter("viewId"));
            }
            HashMap<String, String> jrParameterMap = new HashMap<String, String>();
            DataObject reportDO = ReportHandler.getReportDetails((Integer)reportId);
            Row row = reportDO.getFirstRow("ADSMReports");
            jrParameterMap.put("REPORT_NAME", rb.getString((String)row.get("REPORT_NAME")));
            jrParameterMap.put("DESCRIPTION", rb.getString((String)row.get("DESCRIPTION")));
            jrParameterMap.put("DOMAIN_NAME", CVCDataUtil.getCVCSelectedDomain((DataObject)cvcDataDO));
            jrParameterMap.put("DOMAIN_NAME_TEXT", rb.getString("admp.common.attrib_disp_name.dn_domain_name"));
            jrParameterMap.put("DESCRIPTION_TEXT", rb.getString("admp.common.attrib_disp_name.desc"));
            jrParameterMap.put("CREATION_TIME_TEXT", rb.getString("admp.reports.common.reportresult.generated_date_time"));
            if (cvcOutputFilters.isEmpty()) {
                Hashtable<String, String> hash = new Hashtable<String, String>();
                hash.put("objectName", rb.getString((String)row.get("REPORT_NAME")));
                cvcOutputFilters.add(hash);
            }
            Row r = ReportHandler.getGeneratedReportDetails((Long)generationId, (Long)loginId);
            Long time = (Long)r.get("CREATION_TIME");
            jrParameterMap.put("CREATION_TIME", DateTimeUtil.getDateFormat((Long)loginId).format(new Date(time)));
            RVReqParams reqParams = new RVReqParams();
            reqParams.setReportId(reportId.intValue());
            reqParams.setCvcDataId(cvcDataId.longValue());
            reqParams.setGenerationId(generationId.longValue());
            reqParams.setLoginId(loginId);
            reqParams.setRb(rb);
            reqParams.setLocale(locale);
            reqParams.setSearchStringJson(searchTextJSON);
            reqParams.setSearchCriteriaTypeJson(searchCriteriaJSON);
            reqParams.setMatchCriteria(matchCriteria);
            reqParams.setCustomParams(customParams);
            if (request.getParameter("mgmtReportId") != null) {
                JSONObject mgmtDetailsJsonObject = new JSONObject();
                Integer mgmtReportId = Integer.parseInt(request.getParameter("mgmtReportId"));
                DataObject mgmtActionDataObject = ReportHandler.getReportDetails((Integer)mgmtReportId);
                Row mgmtActionRow = mgmtActionDataObject.getFirstRow("ADSMReports");
                mgmtDetailsJsonObject.put("mgmtReportId", (Object)mgmtReportId);
                String exportHeading = MessageFormat.format(rb.getString("admp.reports.mgmt_result.common.export_title_band_text"), rb.getString((String)mgmtActionRow.get("REPORT_NAME")));
                mgmtDetailsJsonObject.put("generationId", (Object)generationId);
                mgmtDetailsJsonObject.put("exportHeading", (Object)exportHeading);
                System.out.println("setting mgmt details::" + mgmtDetailsJsonObject);
                reqParams.setMgmtDetailsJson(mgmtDetailsJsonObject);
            }
            if (!(dir = new File(storageDir = System.getProperty("server.home") + File.separator + "temp" + File.separator + "export" + File.separator + loginId)).exists()) {
                dir.mkdirs();
            }
            response.setHeader("Cache-Control", "public");
            boolean isIntersect = false;
            if (exportView != null && exportView.equals("intersect")) {
                isIntersect = true;
                exportViewsList = RVHandler.getViewsListForExport((DataObject)rvcDataObject, (AdventNetResourceBundle)rb, (boolean)true);
            } else {
                exportViewsList = RVHandler.getViewsListForExport((DataObject)rvcDataObject, (AdventNetResourceBundle)rb);
            }
            HashMap<String, Integer> exportResult = new HashMap<String, Integer>();
            exportResult.put("exportCount", 0);
            String exportFileName = "ADMPReports." + exportType;
            if (isIntersect || exportViewsList.size() > 1 || exportCurrentView || reportId == 47) {
                if (reportId == 47) {
                    ADMPAuthObject authObj = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
                    ReportExportUtil.setIamAppsDelegationDetails(reqParams, authObj, customParams, 3);
                }
                if (exportType.equalsIgnoreCase("pdf")) {
                    ReportPdfExporter pdfExporter = new ReportPdfExporter();
                    pdfExporter.init(jrParameterMap, rvcDataObject, reqParams, rb);
                    pdfExporter.setRvId(viewId);
                    pdfExporter.setExportCurrentViewOnly(exportCurrentView);
                    pdfExporter.setLocale(locale);
                    String password = PasswordUtil.getExportFilePassword((Long)loginId);
                    if (password != null && !password.equals("")) {
                        pdfExporter.setPassword(password);
                    }
                    if (exportView != null && exportView.equals("intersect")) {
                        pdfExporter.exportIntersectReport(response, storageDir, exportViewsList);
                    } else {
                        pdfExporter.exportReport(response, storageDir);
                    }
                    exportResult.put("exportCount", pdfExporter.getExportRowCount());
                } else if (!exportCurrentView) {
                    if (exportView != null && exportView.equals("intersect")) {
                        ReportExportUtil.exportAllConfig(exportViewsList, reqParams, cvcOutputFilters, response, storageDir, exportType, rvcDataObject, rb, false, true, exportResult);
                    } else {
                        ReportExportUtil.exportAllConfig(exportViewsList, reqParams, cvcOutputFilters, response, storageDir, exportType, rvcDataObject, rb, false, false, exportResult);
                    }
                } else {
                    ReportExportUtil.exportSingleConfig(viewId, reqParams, cvcOutputFilters, exportType, response, rvcDataObject, storageDir, rb, false, locale, exportResult);
                    this.logger.log(Level.INFO, "Going to export the single view of pdf content without bookmarks");
                }
            } else {
                Integer iamAppId = RVColumnUtil.getIamAppIdForReportId((Integer)reportId);
                if (iamAppId != null && (iamAppId == 3 || iamAppId == 2)) {
                    ADMPAuthObject authObj = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
                    ReportExportUtil.setIamAppsDelegationDetails(reqParams, authObj, customParams, iamAppId);
                }
                if (iamAppId != null && iamAppId == 3) {
                    ReportExportUtil.exportConfig(exportViewsList, reqParams, request, response, exportType, rvcDataObject, storageDir, rb, false, reportId, exportResult);
                } else {
                    ReportExportUtil.exportConfig(exportViewsList, reqParams, request, response, exportType, rvcDataObject, storageDir, rb, false, exportResult);
                }
            }
            if (PrivacyHandler.getInstance().isExportAuditEnabled().booleanValue()) {
                DataImportExportAudit.auditDataFlow((Long)System.currentTimeMillis(), (Long)loginId, (String)HelpdeskUtil.getLoginUserName((Long)loginId), (String)request.getRemoteAddr(), (String)"admp.deleg.hdt_deleg.cre_role.action_name.ad_reports", (String)((String)row.get("REPORT_NAME")), (Integer)reportId, (String)"-", (Boolean)Boolean.FALSE, (String)exportFileName, (String)exportType.toLowerCase(), (String)"-", (Integer)((Integer)exportResult.get("exportCount")));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward getOutputFiltersList(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String forwardPage = "outputFilters";
        try {
            Long cvcDataId = Long.parseLong(request.getParameter("cvcDataId"));
            Integer reportId = Integer.parseInt(request.getParameter("reportId"));
            String rvcIdStr = request.getParameter("rvcId");
            Integer rvcId = rvcIdStr != null ? Integer.parseInt(rvcIdStr) : 0;
            Integer fromIndex = -1;
            if (request.getParameter("fromIndex") != null) {
                fromIndex = Integer.parseInt(request.getParameter("fromIndex"));
            }
            String searchText = null;
            if (request.getParameter("searchText") != null) {
                searchText = request.getParameter("searchText");
                searchText = "*" + searchText + "*";
            }
            Integer totalFiltersCount = 0;
            Boolean isMultipleSelection = true;
            ArrayList outputFiltersList = null;
            if (rvcId.equals(RVCConstants.FSM_PERMISSION_PREVIEW_RVC_ID)) {
                isMultipleSelection = false;
                totalFiltersCount = CVCDataUtil.getCVCSelectedFoldersCount((Long)cvcDataId, (String)searchText);
                outputFiltersList = CVCDataUtil.getCVCSelectedFoldersList((Long)cvcDataId, (Integer)fromIndex, (String)searchText);
                request.setAttribute("isMultipleSelection", (Object)isMultipleSelection);
            } else {
                totalFiltersCount = CVCDataUtil.getCVCSelectedInputsCount((Long)cvcDataId, (String)searchText);
                outputFiltersList = CVCDataUtil.getCVCSelectedInputList((Long)cvcDataId, (Integer)fromIndex, (String)searchText);
            }
            if (fromIndex == -1) {
                request.setAttribute("cvcDataId", (Object)cvcDataId);
                request.setAttribute("reportId", (Object)reportId);
                request.setAttribute("filtersCount", (Object)totalFiltersCount);
                request.setAttribute("filtersList", (Object)outputFiltersList);
                request.setAttribute("scriptConfigId", (Object)ReportsUtil.RESULTVIEW_FROM_RVCFLOW_OUTPUTFILTER_SCRIPTCONFIG_ID);
                this.logger.log(Level.FINE, "Going forward getOutputFiltersList  jsp " + forwardPage);
                return mapping.findForward(forwardPage);
            }
            this.logger.log(Level.FINE, "Going to set the outputFiltersList result in response xml ");
            ByteArrayOutputStream outNode = ClientUtil.seteXMLElement(outputFiltersList, totalFiltersCount, isMultipleSelection);
            response.setContentType("text/xml; charset=UTF-8");
            PrintWriter writer = response.getWriter();
            writer.print(outNode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward getReportRunStatus(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean isResultAvailable = false;
        JSONObject jsonObject = null;
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        String statusErrorMessage = rb.getString("admp.reports.common.stat_msg.no_matching_data_for_input");
        try {
            ArrayList errorList;
            Integer reportId = Integer.parseInt(request.getParameter("reportId"));
            Long generationId = Long.parseLong(request.getParameter("generationId"));
            isResultAvailable = AdvancedReportsUtil.isResultAvailableForGenerationId(generationId, reportId);
            jsonObject = new JSONObject();
            jsonObject.put("isResultAvailable", true);
            Row row = AdvancedReportsUtil.getGenerationProps(generationId);
            Long time = (Long)row.get("CREATION_TIME");
            SimpleDateFormat format = DateTimeUtil.getDateFormat((Long)loginId);
            String genTime = format.format(new Date(time));
            jsonObject.put("generatedTime", (Object)genTime);
            StatusUpdater dynamicUpdator = ReportController.getInstance().getStatus(generationId);
            if (!isResultAvailable) {
                jsonObject.put("isResultAvailable", false);
                if (dynamicUpdator != null) {
                    Hashtable errors = dynamicUpdator.getTaskErrors(rb);
                    ArrayList<Hashtable> errorsList = new ArrayList<Hashtable>();
                    if (errors != null) {
                        Enumeration e = errors.keys();
                        while (e.hasMoreElements()) {
                            String objectName = (String)e.nextElement();
                            LocalizedException ex = (LocalizedException)((Object)errors.get(objectName));
                            ArrayList nativeErrorMsgList = ex.getErrorMsgList();
                            if (!(nativeErrorMsgList != null & !nativeErrorMsgList.isEmpty())) continue;
                            for (int count = 0; count < nativeErrorMsgList.size(); ++count) {
                                errorsList.add((Hashtable)nativeErrorMsgList.get(count));
                            }
                        }
                        statusErrorMessage = this.getSevereErrorMessage(errorsList, rb);
                    }
                    if ((errorList = dynamicUpdator.getErrorList()) != null && errorList.size() > 0) {
                        StringBuilder errMsg = new StringBuilder();
                        for (Hashtable errs : errorList) {
                            errMsg.append((String)errs.get("INPUT_NAME"));
                            errMsg.append(":");
                            errMsg.append(rb.getString((String)errs.get("ERROR_MESSAGE")));
                            errMsg.append(".");
                        }
                        statusErrorMessage = errMsg.toString();
                    }
                    if (statusErrorMessage.equals("")) {
                        this.logger.log(Level.FINE, "Statsupdator native error message was emtpy... so set default error message ");
                        if (reportId == 54) {
                            Long cvcDataModelId = AdvancedReportsUtil.getCVCDataId(reportId, loginId, session.getId());
                            DataObject cvcDataDO = CVCDataUtil.getCVCDataDO((Long)cvcDataModelId, (ArrayList)CVCDataUtil.getComponentsList((Long)CVCUtil.getCVCId((Integer)reportId)));
                            ArrayList msgInputList = ReportsUtil.getEmptyMsgInputList((DataObject)cvcDataDO, (AdventNetResourceBundle)rb, (Integer)reportId);
                            statusErrorMessage = ReportsUtil.getDefaultErrorMessage((Integer)reportId, (AdventNetResourceBundle)rb, (ArrayList)msgInputList);
                        } else {
                            statusErrorMessage = dynamicUpdator.getDefaultStatusMessage(rb);
                        }
                    }
                    this.logger.log(Level.INFO, "Server error occurred while report running for the reportId" + reportId + " is : " + statusErrorMessage);
                }
            }
            if (dynamicUpdator != null) {
                Hashtable<String, String> errorsDetails = new Hashtable<String, String>();
                Hashtable objectVsException = dynamicUpdator.getTaskErrors(rb);
                if (objectVsException != null) {
                    Enumeration objectNames = objectVsException.keys();
                    ArrayList<Hashtable> errorsList = null;
                    while (objectNames.hasMoreElements()) {
                        String objectName = (String)objectNames.nextElement();
                        LocalizedException exception = (LocalizedException)((Object)objectVsException.get(objectName));
                        errorsList = new ArrayList<Hashtable>();
                        ArrayList nativeErrorMsgList = exception.getErrorMsgList();
                        if (nativeErrorMsgList != null & !nativeErrorMsgList.isEmpty()) {
                            for (int count = 0; count < nativeErrorMsgList.size(); ++count) {
                                errorsList.add((Hashtable)nativeErrorMsgList.get(count));
                            }
                        }
                        String errorMessage = this.getSevereErrorMessage(errorsList, rb);
                        errorsDetails.put(objectName, errorMessage);
                    }
                }
                if ((errorList = dynamicUpdator.getErrorList()) != null && errorList.size() > 0) {
                    for (Hashtable errors : errorList) {
                        String objectName = (String)errors.get("INPUT_NAME");
                        String errorMessage = rb.getString((String)errors.get("ERROR_MESSAGE"));
                        errorsDetails.put(objectName, errorMessage);
                    }
                }
                if (errorsDetails.size() > 0) {
                    JSONObject errorJsonObj = new JSONObject(errorsDetails);
                    this.logger.log(Level.INFO, "Native ErrorsList for the generationId " + generationId + " is :: " + errorsDetails);
                    jsonObject.put("errorsList", (Object)errorJsonObj.toString());
                }
                ReportController.getInstance().removeReportListener(generationId);
            }
            jsonObject.put("errorMessage", (Object)statusErrorMessage);
            response.setContentType("application/json");
            PrintWriter writer = response.getWriter();
            writer.print(jsonObject.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward moveFromReportMoreActions(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean isResultAvailable = false;
        JSONObject jsonObject = null;
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            HttpSession session = request.getSession();
            Integer reportId = Integer.parseInt(request.getParameter("oldReportId"));
            Long generationId = Long.parseLong(request.getParameter("oldGenerationId"));
            DataObject reportDO = ReportHandler.getReportDetails((Integer)reportId);
            Row reportRow = reportDO.getFirstRow("ADSMReports");
            String resultTableName = (String)reportRow.get("RESULT_TABLE_NAME");
            String baseTableName = (String)reportRow.get("BASE_TABLE_NAME");
            JSONObject selectedSids = new JSONObject(request.getParameter("selectedSids"));
            Integer mgmtReportID = Integer.parseInt(request.getParameter("reportId"));
            reportDO = ReportHandler.getReportDetails((Integer)mgmtReportID);
            Row mgmtReoprtRow = reportDO.getFirstRow("ADSMReports");
            String mgmtResultTable = (String)mgmtReoprtRow.get("RESULT_TABLE_NAME");
            isResultAvailable = AdvancedReportsUtil.isResultAvailableForGenerationId(resultTableName, generationId, reportId);
            jsonObject = new JSONObject();
            jsonObject.put("isResultAvailable", true);
            if (isResultAvailable) {
                ArrayList selectedSidList = ReportResultInputUtil.getSelectedSids(selectedSids, resultTableName, generationId, baseTableName, null);
                Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
                String description = "Reports to mgmt action by Moreaction from report :" + reportId + " to mgmtAction : ";
                generationId = ReportClientUtil.copyUserResult(selectedSidList, reportId, mgmtResultTable, loginId, description);
            }
            jsonObject.put("generationId", (Object)generationId);
            jsonObject.put("errorMessage", (Object)"Success");
            response.setContentType("application/json");
            PrintWriter writer = response.getWriter();
            writer.print(jsonObject.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward copyUserResult(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        JSONObject jsonObject = null;
        try {
            HttpSession session = request.getSession();
            Integer reportId = Integer.parseInt(request.getParameter("oldReportId"));
            Long generationId = Long.parseLong(request.getParameter("oldGenerationId"));
            DataObject reportDO = ReportHandler.getReportDetails((Integer)reportId);
            Row reportRow = reportDO.getFirstRow("ADSMReports");
            String resultTableName = (String)reportRow.get("RESULT_TABLE_NAME");
            JSONObject selectedSids = new JSONObject(request.getParameter("selectedSids"));
            if (request.getParameter("actionInput") != null) {
                AdmpInput admpInput = new AdmpInput(new JSONObject(request.getParameter("actionInput")));
            }
            Integer mgmtReportId = Integer.parseInt(request.getParameter("mgmtReportId"));
            DataObject obj = ReportHandler.getReportDetails((Integer)mgmtReportId);
            Row r = obj.getFirstRow("ADSMReports");
            String mgmtResultTableName = (String)r.get("RESULT_TABLE_NAME");
            String baseTableName = (String)r.get("BASE_TABLE_NAME");
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            ArrayList selectedSidList = ReportResultInputUtil.getSelectedSids(selectedSids, resultTableName, generationId, baseTableName, null);
            String description = "Reports to On the fly management from report : " + reportId + " to mgmtAction : " + mgmtReportId;
            Long mgmtGenerationId = ReportClientUtil.copyUserResult(selectedSidList, mgmtReportId, mgmtResultTableName, loginId, description);
            jsonObject = new JSONObject();
            jsonObject.put("generationId", (Object)mgmtGenerationId);
            jsonObject.put("errorMessage", (Object)"Success");
            response.setContentType("application/json");
            PrintWriter writer = response.getWriter();
            writer.print(jsonObject.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    private String getSevereErrorMessage(ArrayList<Hashtable> errorMessageList, AdventNetResourceBundle rb) {
        StringBuilder statusMessage = new StringBuilder("");
        ArrayList<String> messageList = new ArrayList<String>();
        boolean counter = false;
        if (errorMessageList != null && !errorMessageList.isEmpty()) {
            for (Hashtable hashtable : errorMessageList) {
                String message = (String)hashtable.get("NATIVE_ERROR_MESSAGE");
                String errorSeverity = (String)hashtable.get("ERROR_SEVERITY");
                if (messageList.contains(message) || !errorSeverity.equals("SEVERE")) continue;
                messageList.add(message);
                if (hashtable.get("ERROR_CODE") == null || hashtable.get("ERROR_CODE").equals("0")) continue;
                String errorCode = (String)hashtable.get("ERROR_CODE");
                statusMessage.append(rb.getString((String)hashtable.get("ERROR_MESSAGE")));
                if (message != null && message.length() != 0) {
                    statusMessage.append(" - ");
                    statusMessage.append(rb.getString(message));
                }
                if (hashtable.get("ERROR_CODE") == null || hashtable.get("ERROR_CODE").toString().length() == 0) continue;
                statusMessage.append(" - ");
                statusMessage.append(rb.getString("admp.common.native.error_text.error_code"));
                statusMessage.append(" : ");
                statusMessage.append((String)hashtable.get("ERROR_CODE"));
            }
        }
        return statusMessage.toString();
    }

    public ActionForward updateDescription(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            ReportBean bean = (ReportBean)((Object)session.getAttribute("ReportBean"));
            AbstractListener listener = bean.getListener();
            Long generationId = listener.getGenerationId();
            String description = request.getParameter("description");
            ReportHandler.updateGeneratedReportDetails((Long)generationId, (String)description, (Long)loginId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

