/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.reports.customreport;

import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.customview.NavigateRangeUtil;
import com.adventnet.sym.adsm.common.server.delegation.DelegationUtil;
import com.adventnet.sym.adsm.common.server.helpdesk.ADMPAuthObject;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.layout.FcJSONUtility;
import com.adventnet.sym.adsm.common.server.reports.ReportController;
import com.adventnet.sym.adsm.common.server.reports.ReportHandler;
import com.adventnet.sym.adsm.common.server.reports.StatusUpdater;
import com.adventnet.sym.adsm.common.server.reports.customreport.CustomReportUtil;
import com.adventnet.sym.adsm.common.webclient.reports.ListenerUtil;
import com.adventnet.sym.adsm.common.webclient.reports.advanced.AdvancedReportsUtil;
import com.adventnet.sym.adsm.common.webclient.reports.customreport.CustomReportListener;
import com.adventnet.sym.adsm.common.webclient.reports.customreport.CustomReportResultUtil;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import com.adventnet.sym.adsm.common.webclient.util.ReportClientUtil;
import com.adventnet.sym.adsm.security.server.util.DateTimeUtil;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.json.JSONArray;
import org.json.JSONObject;

public class CustomReportAction {
    private static volatile CustomReportAction instance = null;
    private static Logger reportLogger = Logger.getLogger(CustomReportAction.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CustomReportAction getInstance() {
        if (instance != null) return instance;
        Class<CustomReportAction> clazz = CustomReportAction.class;
        synchronized (CustomReportAction.class) {
            if (instance != null) return instance;
            instance = new CustomReportAction();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private CustomReportAction() {
    }

    public void getReportInputs(HttpServletRequest request, HttpServletResponse response) {
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
            String reportIdStr = request.getParameter("reportId");
            Integer reportId = Integer.parseInt(reportIdStr);
            JSONObject reportDetails = new JSONObject();
            Row row = ReportHandler.getReportDetailsRow((Integer)reportId);
            reportDetails.put("reportName", (Object)rb.getString((String)row.get("REPORT_NAME")));
            reportDetails.put("description", (Object)rb.getString((String)row.get("DESCRIPTION")));
            Hashtable domainVsactions = authObject.getDomainActionMap();
            ArrayList domainNameList = HDTDomainHandler.getDomainListForUser((Long)loginId, (Hashtable)domainVsactions, (Long)((Long)row.get("ACTION_ID")));
            Long generationId = ReportHandler.getRecentlyGeneratedReports((Integer)reportId, (Long)loginId);
            System.out.println("generationId" + generationId);
            if (generationId != null && generationId != 0L) {
                Row r = ReportHandler.getGeneratedReportDetails((Long)generationId, (Long)loginId);
                reportDetails.put("generationId", (Object)generationId);
                reportDetails.put("exportDescription", (Object)((String)r.get("DESCRIPTION")));
                ArrayList domainList = CustomReportUtil.getDomainList((Integer)reportId, (ArrayList)domainNameList);
                HashMap domainDetails = ListenerUtil.getDomainDetails(generationId, reportId, request);
                domainDetails.put("domains", domainList);
                reportDetails.put("domainList", (Object)FcJSONUtility.mapToJSONObject((Map)domainDetails));
            } else {
                Hashtable domainDetails = CustomReportUtil.getDomainDetails((Integer)reportId, (ArrayList)domainNameList);
                reportDetails.put("domainList", (Object)FcJSONUtility.mapToJSONObject((Map)domainDetails));
            }
            JSONObject auditEntries = CustomReportUtil.getAuditEntries((Integer)reportId, (Long)loginId, (AdventNetResourceBundle)rb);
            reportDetails.put("auditEntries", (Object)auditEntries);
            Long createdBy = (Long)auditEntries.get("CREATED_LOGIN_ID");
            if (loginId.equals(1L) || loginId.equals(createdBy)) {
                reportDetails.put("isEditReportAction", true);
            } else {
                reportDetails.put("isEditReportAction", false);
            }
            boolean isMultidc = CustomReportUtil.isMultiDCAttribsInFilters((Integer)reportId);
            reportDetails.put("isMultidc", isMultidc);
            response.setContentType("application/json");
            PrintWriter out = response.getWriter();
            out.println(reportDetails.toString());
            out.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void generateReport(HttpServletRequest request, HttpServletResponse response) {
        try {
            JSONObject jsonObject = new JSONObject();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            String reportIdStr = request.getParameter("reportId");
            Integer reportId = Integer.parseInt(reportIdStr);
            String dynamicHandlerClassName = "com.adventnet.sym.adsm.common.webclient.statusupdater.CustomReportStatusUpdater";
            StatusUpdater statusUpdater = (StatusUpdater)Class.forName(dynamicHandlerClassName.trim()).newInstance();
            Long generationId = ReportController.getInstance().generateCustomReport(reportId, request, statusUpdater);
            jsonObject.put("generationId", (Object)generationId);
            jsonObject.put("isReportRunning", true);
            response.setContentType("application/json");
            PrintWriter out = response.getWriter();
            out.println(jsonObject.toString());
            out.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void getReportResultLayout(HttpServletRequest request, HttpServletResponse response) {
        try {
            JSONObject jsonObject = new JSONObject();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            Integer reportId = Integer.parseInt(request.getParameter("reportId"));
            JSONArray tabList = FcJSONUtility.listToJSONArray((List)CustomReportResultUtil.getTabList(reportId, rb));
            JSONObject columnList = CustomReportResultUtil.getViewColumns(loginId, reportId, rb);
            jsonObject.put("tabs", (Object)tabList);
            jsonObject.put("columns", (Object)columnList);
            jsonObject.put("sortAttributeId", (Object)"-1");
            jsonObject.put("sortingOrder", true);
            JSONObject pageNavigateData = ReportClientUtil.getDefaultNavigationConfig(loginId);
            JSONObject pageNavigation = new JSONObject();
            for (int i = 0; i < tabList.length(); ++i) {
                JSONObject tab = (JSONObject)tabList.get(i);
                Integer tabId = (Integer)tab.get("TAB_ID");
                pageNavigation.put(tabId.toString(), (Object)pageNavigateData);
            }
            jsonObject.put("pageNavigation", (Object)pageNavigation);
            boolean isAddCustomAttributeLinkAuthorized = false;
            if (ClientUtil.checkAuthorization(request, DelegationUtil.ADMINTAB.LDAP_ATTRIBUTES.getValue())) {
                isAddCustomAttributeLinkAuthorized = true;
            }
            jsonObject.put("isAddCustomAttributeLinkAuthorized", isAddCustomAttributeLinkAuthorized);
            jsonObject.put("reportActions", (Object)new JSONArray());
            jsonObject.put("menus", (Object)new JSONArray());
            response.setContentType("application/json");
            PrintWriter out = response.getWriter();
            out.println(jsonObject.toString());
            out.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void getDynamicUpdateDetails(HttpServletRequest request, HttpServletResponse response) {
        try {
            JSONObject jsonObject = new JSONObject();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            Integer reportId = Integer.parseInt(request.getParameter("reportId"));
            Long generationId = Long.parseLong(request.getParameter("generationId"));
            Integer viewType = 1;
            if (request.getParameter("viewType") != null) {
                viewType = Integer.parseInt(request.getParameter("viewType"));
            }
            JSONObject reqJsonObject = new JSONObject();
            if (viewType == 1) {
                Integer tabId = Integer.parseInt(request.getParameter("tabId"));
                reqJsonObject.put("columns", (Object)new JSONArray(request.getParameter("columns")));
                reqJsonObject.put("tabId", (Object)tabId);
            }
            reqJsonObject.put("viewType", (Object)viewType);
            StatusUpdater dynamicUpdator = ReportController.getInstance().getStatus(generationId);
            if (dynamicUpdator == null) {
                jsonObject = new JSONObject();
                jsonObject.put("isCompleted", true);
            } else {
                jsonObject = dynamicUpdator.getJSONObject(reqJsonObject, rb);
            }
            response.setContentType("application/json");
            PrintWriter out = response.getWriter();
            out.println(jsonObject.toString());
            out.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void getReportRunStatus(HttpServletRequest request, HttpServletResponse response) {
        try {
            JSONObject jsonObject = new JSONObject();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            Integer reportId = Integer.parseInt(request.getParameter("reportId"));
            Long generationId = Long.parseLong(request.getParameter("generationId"));
            jsonObject.put("isResultAvailable", true);
            boolean isResultAvailable = AdvancedReportsUtil.isResultAvailableForGenerationId(generationId, reportId);
            if (!isResultAvailable) {
                jsonObject.put("isResultAvailable", false);
                String statusErrorMessage = rb.getString("admp.reports.common.stat_msg.no_matching_data_for_input");
                CustomReportListener listener = (CustomReportListener)ReportController.getInstance().getListener(generationId);
                if (listener != null && listener.errorMessage != null && !listener.errorMessage.isEmpty()) {
                    statusErrorMessage = listener.errorMessage;
                }
                jsonObject.put("errorMessage", (Object)statusErrorMessage);
            }
            Row r = ReportHandler.getGeneratedReportDetails((Long)generationId, (Long)loginId);
            Long time = (Long)r.get("CREATION_TIME");
            String genTime = DateTimeUtil.getDateFormat((Long)loginId).format(new Date(time));
            jsonObject.put("genTime", (Object)genTime);
            jsonObject.put("exportDescription", (Object)((String)r.get("DESCRIPTION")));
            response.setContentType("application/json");
            PrintWriter out = response.getWriter();
            out.println(jsonObject.toString());
            out.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void getReportResultRows(HttpServletRequest request, HttpServletResponse response) {
        try {
            JSONObject jsonObject = new JSONObject();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            Integer reportId = Integer.parseInt(request.getParameter("reportId"));
            Long generationId = Long.parseLong(request.getParameter("generationId"));
            JSONObject reqParams = new JSONObject(request.getParameter("params"));
            JSONArray columns = CustomReportResultUtil.getViewColumns(CustomReportResultUtil.getViewColumnIds(loginId, reportId, (Integer)reqParams.get("tabId")), rb);
            reqParams.put("columns", (Object)columns);
            JSONObject pageNavigateData = reqParams.getJSONObject("pageNavigateData");
            boolean isNavigate = (Boolean)pageNavigateData.get("isNavigate");
            if (isNavigate) {
                NavigateRangeUtil.setDefaultRange((String)"ReportResult", (int)pageNavigateData.getInt("range"), (Long)loginId);
            }
            jsonObject = CustomReportResultUtil.getReportResultRows(loginId, reportId, generationId, reqParams);
            jsonObject.put("columns", (Object)columns);
            response.setContentType("application/json");
            PrintWriter out = response.getWriter();
            out.println(jsonObject.toString());
            out.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stopReport(HttpServletRequest request, HttpServletResponse response) {
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            Integer reportId = Integer.parseInt(request.getParameter("reportId"));
            Long generationId = Long.parseLong(request.getParameter("generationId"));
            StatusUpdater dynamicUpdator = ReportController.getInstance().getStatus(generationId);
            dynamicUpdator.setProgressTask(StatusUpdater.TASKCODE.PROCESS_INTERRUPTED.getValue());
            ReportController.getInstance().stopReport(generationId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void saveExportSettings(HttpServletRequest request, HttpServletResponse response) {
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            if (loginId == null) {
                loginId = 1L;
            }
            Integer reportId = Integer.parseInt(request.getParameter("reportId"));
            Long generationId = Long.parseLong(request.getParameter("generationId"));
            String desc = request.getParameter("exportDescription");
            ReportHandler.updateGeneratedReportDetails((Long)generationId, (String)desc, (Long)loginId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

