/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.resultview;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.automation.AutomationUtil;
import com.adventnet.sym.adsm.common.server.automation.constants.AutomationConstants;
import com.adventnet.sym.adsm.common.server.customview.ColumnConfiguration;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.resultview.DataSource;
import com.adventnet.sym.adsm.common.server.resultview.RVCConstants;
import com.adventnet.sym.adsm.common.server.resultview.RVReqParams;
import com.adventnet.sym.adsm.common.server.resultview.TableDataSource;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBUtil;
import com.adventnet.sym.adsm.common.server.util.RVUtil;
import com.adventnet.sym.adsm.common.server.util.SchedulerUtil;
import com.adventnet.sym.adsm.common.server.wengine.SchedulerRunNowObject;
import com.adventnet.sym.adsm.common.webclient.transformers.Transformers;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import com.adventnet.sym.adsm.security.server.util.DateTimeUtil;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AutomatedTaskView
implements DataSource,
TableDataSource {
    private List tableData = new ArrayList();
    private ArrayList totalColumnList = new ArrayList();
    private Long totalResultCount = 0L;
    private Hashtable multipleValueSids = new Hashtable();
    private Hashtable details = new Hashtable();
    private HashMap uniqueColumnIdentityMap = new HashMap();
    private int uniqueId;

    public Hashtable getMultipleValueSids() {
        return this.multipleValueSids;
    }

    public ArrayList getColumnList() {
        return this.totalColumnList;
    }

    public Hashtable getDetails() {
        return this.details;
    }

    public Hashtable getMulitpleValuesSids() {
        return this.multipleValueSids;
    }

    public List getTableData() {
        return this.tableData;
    }

    public Long getTotalResultCount() {
        return this.totalResultCount;
    }

    public HashMap getUniqueColIdentityMap() {
        this.uniqueColumnIdentityMap.put("COLUMN_ID", "COLUMN_ID");
        this.uniqueColumnIdentityMap.put("COLUMN_NAME", "DISPLAY_NAME");
        return this.uniqueColumnIdentityMap;
    }

    public int getUniqueId() {
        return this.uniqueId;
    }

    public void setTotalColumnList(ArrayList columnList) {
        this.totalColumnList = columnList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initDataSource(AdventNetResourceBundle rb, RVReqParams reqParams, DataObject dataObject, boolean isForExport, boolean isForScheduler) {
        DataSet dataSet = null;
        Connection connection = null;
        try {
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            Long loginId = reqParams.getLoginId();
            ArrayList headerColumnList = new ArrayList();
            Long cvId = ColumnConfiguration.getCVId((String)RVUtil.getCustomViewModuleName((int)reqParams.getRvId()), (long)loginId);
            if (cvId == null) {
                cvId = ColumnConfiguration.getDefaultCvId((String)RVUtil.getCustomViewModuleName((int)reqParams.getRvId()));
            }
            logger.log(Level.FINE, "CV ID for the rvid " + reqParams.getRvId() + " is " + cvId);
            this.setDetails(dataObject, reqParams);
            headerColumnList = ColumnConfiguration.getHeaderColumnList((Long)cvId);
            this.setTotalColumnList(headerColumnList);
            this.setUniqueId(reqParams.getFilterId());
            String baseTableName = "ADSMAutomation";
            Criteria criteria = null;
            ArrayList outputFilters = reqParams.getOutputFilters();
            for (int index = 0; index < outputFilters.size(); ++index) {
                JSONObject json = (JSONObject)outputFilters.get(index);
                if (json.has("Domains")) {
                    criteria = new Criteria(Column.getColumn((String)baseTableName, (String)"DOMAIN_NAME"), (Object)json.getString("Domains"), 0);
                }
                if (json.has("ObjectCategory")) {
                    criteria = new Criteria(Column.getColumn((String)baseTableName, (String)"OBJECT_TYPE"), (Object)json.getString("ObjectCategory"), 0);
                }
                if (!json.has("Share")) continue;
                if (json.getString("Share").equalsIgnoreCase("Created By me")) {
                    criteria = new Criteria(Column.getColumn((String)baseTableName, (String)"CREATED_BY"), (Object)loginId, 0);
                    continue;
                }
                if (json.getString("Share").equalsIgnoreCase("Shared By me")) {
                    ArrayList sharedByMeSheduleList = SchedulerUtil.getSharedByMeScheduleList((Long)loginId);
                    Long[] sharedByMeSheduleArray = new Long[sharedByMeSheduleList.size()];
                    sharedByMeSheduleArray = sharedByMeSheduleList.toArray(sharedByMeSheduleArray);
                    criteria = new Criteria(Column.getColumn((String)"ADSMAutomation", (String)"SCHEDULE_ID"), (Object)sharedByMeSheduleArray, 8);
                    continue;
                }
                if (!json.getString("Share").equalsIgnoreCase("Shared For me")) continue;
                ArrayList sharedForMeSheduleList = SchedulerUtil.getSharedScheduleList((Long)loginId);
                Long[] sharedForMeSheduleArray = new Long[sharedForMeSheduleList.size()];
                sharedForMeSheduleArray = sharedForMeSheduleList.toArray(sharedForMeSheduleArray);
                criteria = new Criteria(Column.getColumn((String)"ADSMAutomation", (String)"SCHEDULE_ID"), (Object)sharedForMeSheduleArray, 8);
            }
            Criteria loginIdCriteria = null;
            if (loginId.compareTo(CommonUtil.ADMIN_LOGIN_ID) == 0) {
                loginIdCriteria = new Criteria(Column.getColumn((String)"ADSMAutomation", (String)"CREATED_BY"), null, 1);
            } else {
                loginIdCriteria = new Criteria(Column.getColumn((String)"ADSMAutomation", (String)"CREATED_BY"), (Object)loginId, 0);
                ArrayList sharedSheduleList = SchedulerUtil.getSharedScheduleList((Long)loginId);
                Long[] sharedSheduleArray = new Long[sharedSheduleList.size()];
                sharedSheduleArray = sharedSheduleList.toArray(sharedSheduleArray);
                loginIdCriteria = loginIdCriteria.or(new Criteria(Column.getColumn((String)"ADSMAutomation", (String)"SCHEDULE_ID"), (Object)sharedSheduleArray, 8));
            }
            criteria = criteria != null ? criteria.and(loginIdCriteria) : loginIdCriteria;
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)baseTableName));
            query.addSelectColumn(Column.getColumn(null, (String)"*"));
            query.addJoin(new Join(Table.getTable((String)"ADSMAutomation"), Table.getTable((String)"ADSMAutomationRequestActions"), new String[]{"AUTOMATION_ID"}, new String[]{"AUTOMATION_ID"}, 1));
            query.addJoin(new Join(Table.getTable((String)"ADSMAutomationRequestActions"), Table.getTable((String)"ADSMWorkFlowActions"), new String[]{"REQUEST_ACTION"}, new String[]{"WF_ACTION_ID"}, 1));
            query.addJoin(new Join(Table.getTable((String)"ADSMAutomation"), Table.getTable((String)"ADSMAutomationPolicyMapping"), new String[]{"AUTOMATION_ID"}, new String[]{"AUTOMATION_ID"}, 1));
            query.addJoin(new Join(Table.getTable((String)"ADSMAutomationPolicyMapping"), Table.getTable((String)"ADSMAutomationPolicy"), new String[]{"AUTO_POLICY_ID"}, new String[]{"AUTO_POLICY_ID"}, 1));
            query.addJoin(new Join(Table.getTable((String)"ADSMAutomation"), Table.getTable((String)"ADSMScheduleReportsMapping"), new String[]{"SCHEDULE_ID"}, new String[]{"SCHEDULE_ID"}, 1));
            query.addJoin(new Join(Table.getTable((String)"ADSMScheduleReportsMapping"), Table.getTable((String)"ADSMReports"), new String[]{"REPORT_ID"}, new String[]{"REPORT_ID"}, 1));
            query.addJoin(new Join(Table.getTable((String)"ADSMAutomation"), Table.getTable((String)"Scheduled_Task"), new String[]{"SCHEDULE_ID"}, new String[]{"SCHEDULE_ID"}, 1));
            query.addJoin(new Join(Table.getTable((String)"ADSMAutomation"), Table.getTable((String)"AutoIntegAdvancCriteria"), new String[]{"SCHEDULE_ID"}, new String[]{"SCHEDULE_ID"}, 1));
            query.addJoin(new Join(Table.getTable((String)"ADSMAutomation"), Table.getTable((String)"TPIntegrationScheduleMapping"), new String[]{"SCHEDULE_ID"}, new String[]{"SCHEDULE_ID"}, 1));
            query.addJoin(new Join(Table.getTable((String)"TPIntegrationScheduleMapping"), Table.getTable((String)"DBInputConfig"), new String[]{"CONFIG_ID"}, new String[]{"CONFIG_ID"}, 1));
            query.setCriteria(criteria);
            if (reqParams.getSortAttribId() != 0) {
                String sortColumnName = ColumnConfiguration.getColumnName((Integer)reqParams.getSortAttribId());
                query.addSortColumn(new SortColumn(baseTableName, sortColumnName, reqParams.isSortOrder()));
            } else {
                query.addSortColumn(new SortColumn(baseTableName, "MODIFIED_TIME", false));
            }
            Hashtable schedulerIdVsOwnersMap = SchedulerUtil.getSchedulerOwners((String)baseTableName, (String)"CREATED_BY", (Criteria)criteria);
            dataSet = relationalAPI.executeQuery((Query)query, connection);
            HashMap<Integer, Object> rowData = null;
            Hashtable subCategoryMappingDetails = AutomationUtil.getAutomationCategoryVsSubCategory();
            ArrayList<Long> automationIdList = new ArrayList<Long>();
            ArrayList tableRowsList = new ArrayList();
            while (dataSet.next()) {
                rowData = new HashMap<Integer, Object>();
                HashMap<String, Object> inputValues = null;
                Long automationId = (Long)dataSet.getValue("AUTOMATION_ID");
                if (automationIdList.contains(automationId)) continue;
                automationIdList.add(automationId);
                for (int index = 0; index < headerColumnList.size(); ++index) {
                    Integer Status_int;
                    Long schedulerId;
                    inputValues = new HashMap<String, Object>();
                    HashMap details = (HashMap)headerColumnList.get(index);
                    Integer columnId = (Integer)details.get("COLUMN_ID");
                    String columnName = (String)details.get("COLUMN_NAME");
                    String transformerClassName = (String)details.get("TRANSFORMER_CLASS");
                    Long requestAction = (Long)dataSet.getValue("REQUEST_ACTION");
                    Boolean isPolicyAction = (Boolean)dataSet.getValue("IS_POLICYBASED_AUTOMATION");
                    if (isPolicyAction.booleanValue()) {
                        requestAction = (Long)dataSet.getValue("AUTO_POLICY_ID");
                    }
                    if (columnName.equalsIgnoreCase("ACTION")) {
                        schedulerId = (Long)dataSet.getValue("SCHEDULE_ID");
                        inputValues.put("SchedulerName", dataSet.getValue("AUTOMATION_NAME"));
                        Status_int = (Integer)dataSet.getValue("ADMIN_STATUS");
                        Long createdBy = (Long)dataSet.getValue("CREATED_BY");
                        String modifyScheduler = "false";
                        if (loginId.equals(CommonUtil.ADMIN_LOGIN_ID) || loginId.equals(createdBy)) {
                            modifyScheduler = "true";
                        }
                        inputValues.put("schedulerOwner", createdBy);
                        inputValues.put("modifyScheduler", modifyScheduler);
                        String Status = "DEACTIVATED";
                        if (Status_int == 3) {
                            Status = "ACTIVE";
                        }
                        inputValues.put("Status", Status);
                        inputValues.put("cvId", cvId);
                        inputValues.put("automationId", automationId);
                        inputValues.put("rvId", reqParams.getRvId());
                        inputValues.put("CREATED_BY", createdBy);
                        Transformers uiTransformer = (Transformers)Class.forName(transformerClassName.trim()).newInstance();
                        Object columnValue = uiTransformer.renderCell(rb, columnName, schedulerId, details, inputValues, false);
                        int rvId = reqParams.getRvId();
                        if (rvId == 101) {
                            HashMap<String, Object> map = new HashMap<String, Object>();
                            map.put("value", columnValue.toString());
                            map.put("automationId", automationId);
                            map.put("schedulerId", schedulerId);
                            map.put("rvId", rvId);
                            map.put("schedulerName", dataSet.getValue("AUTOMATION_NAME"));
                            rowData.put(columnId, map);
                            continue;
                        }
                        rowData.put(columnId, columnValue.toString());
                        continue;
                    }
                    if (columnName.equalsIgnoreCase("DESCRIPTION")) {
                        rowData.put(columnId, ClientUtil.htmlEscape(rb.getString((String)dataSet.getValue(columnName))));
                        continue;
                    }
                    if (columnName.equalsIgnoreCase("REQUEST_ACTION")) {
                        if (!isPolicyAction.booleanValue() && dataSet.getValue("WF_ACTION_NAME") != null) {
                            rowData.put(columnId, rb.getString((String)dataSet.getValue("WF_ACTION_NAME")));
                            continue;
                        }
                        rowData.put(columnId, MessageFormat.format(rb.getString("admp.auto.automation.view_auto.text.policy_name"), ClientUtil.htmlEscape(rb.getString((String)dataSet.getValue("AUTO_POLICY_NAME")))));
                        continue;
                    }
                    if (columnName.equalsIgnoreCase("OBJECT_TYPE")) {
                        Hashtable mappingDetails = (Hashtable)subCategoryMappingDetails.get(dataSet.getValue("OBJECT_TYPE"));
                        String columnValue = ClientUtil.getObjectImage((Integer)mappingDetails.get("CATEGORY")) + rb.getString((String)mappingDetails.get("SUB_CATEGORY_NAME"));
                        rowData.put(columnId, columnValue);
                        continue;
                    }
                    if (columnName.equalsIgnoreCase("MODIFIED_TIME")) {
                        if (dataSet.getValue("MODIFIED_TIME") != null) {
                            String columnValue = DateTimeUtil.formatDate((Long)((Long)dataSet.getValue("MODIFIED_TIME")), (Long)loginId);
                            rowData.put(columnId, columnValue);
                            continue;
                        }
                        rowData.put(columnId, "-");
                        continue;
                    }
                    if (columnName.equalsIgnoreCase("CRITERIA")) {
                        String reportName = "";
                        String secondConfig = "";
                        String resultValue = "";
                        if (dataSet.getValue("CSV_LOCATION") != null && !((String)dataSet.getValue("CSV_LOCATION")).equals("")) {
                            secondConfig = (String)dataSet.getValue("CSV_LOCATION");
                        }
                        if (dataSet.getValue("CONFIG_ID") != null) {
                            int configId = (Integer)dataSet.getValue("CONFIG_ID");
                            String dataSource = (String)dataSet.getValue("DATASOURCE_TYPE");
                            dataSource = dataSource.equalsIgnoreCase("workday") ? "WorkdayInputConfig" : (dataSource.equalsIgnoreCase("zPeople") ? "ZPeopleInputConfig" : "DBInputConfig");
                            Criteria crit = new Criteria(Column.getColumn((String)dataSource, (String)"CONFIG_ID"), (Object)configId, 0);
                            DataObject obj = CommonUtil.getPersistence((boolean[])new boolean[0]).get(dataSource, crit);
                            secondConfig = (String)obj.getFirstRow(dataSource).get("CONFIG_NAME");
                        } else if (dataSet.getValue("CONFIG_NAME") != null && !((String)dataSet.getValue("CONFIG_NAME")).equals("")) {
                            secondConfig = (String)dataSet.getValue("CONFIG_NAME");
                        }
                        if (dataSet.getValue("REPORT_NAME") != null) {
                            reportName = rb.getString((String)dataSet.getValue("REPORT_NAME"));
                        }
                        resultValue = reportName.isEmpty() ? secondConfig : (secondConfig.isEmpty() ? reportName : MessageFormat.format(rb.getString("admp.auto.automation.text.automation_criteria_value"), reportName, secondConfig));
                        rowData.put(columnId, resultValue);
                        continue;
                    }
                    if (columnName.equalsIgnoreCase("AUTOMATIC_EXECUTION_ENABLED")) {
                        if (((Boolean)dataSet.getValue(columnName)).booleanValue()) {
                            rowData.put(columnId, rb.getString("admp.auto.automation.text.complete_automation"));
                            continue;
                        }
                        rowData.put(columnId, rb.getString("admp.auto.automation.text.workflow_controlled_automation"));
                        continue;
                    }
                    if (columnName.equalsIgnoreCase("TIME_SUMMARY")) {
                        if (dataSet.getValue(columnName) != null) {
                            String time = (String)dataSet.getValue(columnName);
                            try {
                                JSONObject timeObj = new JSONObject(time);
                                Iterator keys = timeObj.keys();
                                while (keys.hasNext()) {
                                    String key = (String)keys.next();
                                    JSONArray array = (JSONArray)timeObj.get(key);
                                    Object[] value = new Object[array.length()];
                                    for (int i = 0; i < array.length(); ++i) {
                                        Object object = array.get(i);
                                        String str = new String();
                                        if (object instanceof JSONObject) {
                                            JSONObject jsonObj = new JSONObject(array.get(i).toString());
                                            Iterator jsonObjKeys = jsonObj.keys();
                                            while (jsonObjKeys.hasNext()) {
                                                String jsonObjKey = (String)jsonObjKeys.next();
                                                str = str + rb.getString(jsonObjKey);
                                                str = str + " " + rb.getString(jsonObj.get(jsonObjKey).toString());
                                            }
                                        } else if (object instanceof JSONArray) {
                                            JSONArray jsonArray = new JSONArray(array.get(i).toString());
                                            Object[] strArray = new String[jsonArray.length()];
                                            for (int j = 0; j < jsonArray.length(); ++j) {
                                                strArray[j] = rb.getString(jsonArray.get(j).toString());
                                            }
                                            str = Arrays.toString(strArray);
                                        } else {
                                            str = rb.getString(array.get(i).toString());
                                        }
                                        value[i] = str;
                                    }
                                    time = MessageFormat.format(rb.getString(key), value);
                                }
                            }
                            catch (JSONException e) {
                                e.printStackTrace();
                            }
                            rowData.put(columnId, time);
                            continue;
                        }
                        rowData.put(columnId, "-");
                        continue;
                    }
                    if (columnName.equalsIgnoreCase("RUN_NOW")) {
                        schedulerId = (Long)dataSet.getValue("SCHEDULE_ID");
                        inputValues.put("SchedulerName", dataSet.getValue("AUTOMATION_NAME"));
                        Status_int = (Integer)dataSet.getValue("ADMIN_STATUS");
                        String Status = "DEACTIVATED";
                        Long createdBy = (Long)dataSet.getValue("CREATED_BY");
                        SchedulerRunNowObject runNowObj = SchedulerRunNowObject.getInstance();
                        String runNowStatus = runNowObj.getSchedulerStatus(loginId, schedulerId);
                        if (Status_int == 3) {
                            Status = "ACTIVE";
                        }
                        inputValues.put("Status", Status);
                        inputValues.put("schedulerId", schedulerId);
                        inputValues.put("runNowStatus", runNowStatus);
                        inputValues.put("cvId", cvId);
                        inputValues.put("automationId", automationId);
                        inputValues.put("rvId", reqParams.getRvId());
                        inputValues.put("CREATED_BY", createdBy);
                        Transformers uiTransformer = (Transformers)Class.forName(transformerClassName.trim()).newInstance();
                        Object columnValue = uiTransformer.renderCell(rb, columnName, schedulerId, details, inputValues, false);
                        rowData.put(columnId, columnValue.toString());
                        continue;
                    }
                    if (columnName.equalsIgnoreCase("CREATED_BY")) {
                        schedulerId = (Long)dataSet.getValue("SCHEDULE_ID");
                        rowData.put(columnId, schedulerIdVsOwnersMap.get(schedulerId));
                        continue;
                    }
                    if (columnName.equalsIgnoreCase("AUTOMATION_NAME")) {
                        schedulerId = (Long)dataSet.getValue("SCHEDULE_ID");
                        Long createdBy = (Long)dataSet.getValue("CREATED_BY");
                        String modifyScheduler = "false";
                        String style = "cursor:not-allowed";
                        if (loginId.equals(CommonUtil.ADMIN_LOGIN_ID) || loginId.equals(createdBy)) {
                            modifyScheduler = "true";
                            style = "cursor:pointer";
                        }
                        String name = (String)dataSet.getValue(columnName);
                        String schedulerName = ClientUtil.htmlEscape(ClientUtil.scriptEscape(rb.getString(name)));
                        StringBuilder sb = new StringBuilder();
                        if (name.equalsIgnoreCase("admp.reports.sched_reports.sch_view.scheduler_name.ad_update_scheduler") || name.equalsIgnoreCase("admp.reports.sched_reports.sch_view.scheduler_name.daily_report_scheduler") || name.equalsIgnoreCase("admp.reports.sched_reports.sch_view.scheduler_name.significant_reports")) {
                            sb.append("<table width=\"100%\" height=\"25px\"><tr>");
                            sb.append("<td width=\"90%\"><div class=\"blacktxt\">" + ClientUtil.htmlEscape(name) + "</div></td>");
                            sb.append("<td></td></tr></table>");
                        } else {
                            sb.append("<table  width=\"100%\" height=\"25px\"><tr>");
                            sb.append("<td width=\"90%\"><div class=\"blacktxt\">" + ClientUtil.htmlEscape(name) + "</div></td>");
                            sb.append("</tr></table>");
                        }
                        rowData.put(columnId, sb.toString());
                        continue;
                    }
                    if (dataSet.getValue(columnName) != null) {
                        rowData.put(columnId, (String)dataSet.getValue(columnName));
                        continue;
                    }
                    rowData.put(columnId, "-");
                }
                tableRowsList.add(rowData);
            }
            this.tableData = tableRowsList.size() >= reqParams.getToIndex() ? tableRowsList.subList(reqParams.getFromIndex() - 1, reqParams.getToIndex()) : tableRowsList;
            query = new SelectQueryImpl(Table.getTable((String)baseTableName));
            query.addSelectColumn(Column.getColumn((String)baseTableName, (String)"AUTOMATION_ID").count());
            query.setCriteria(criteria);
            this.setTotalResultCount((long)DBUtil.getCount((SelectQuery)query));
            DBUtil.closeDataSetAndConnection((DataSet)dataSet, (Connection)connection);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            DBUtil.closeDataSetAndConnection(dataSet, (Connection)connection);
        }
    }

    public void setTotalResultCount(Long totalResultCount) {
        this.totalResultCount = totalResultCount;
    }

    private void setDetails(DataObject dataObject, RVReqParams reqParams) throws Exception {
        Row viewConfigToMenuRow = dataObject.getRow(RVCConstants.RVTOMENUMAPPING_TABLE, new Criteria(Column.getColumn((String)RVCConstants.RVTOMENUMAPPING_TABLE, (String)RVCConstants.FILTER_ID), (Object)reqParams.getFilterId(), 0));
        DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get(RVCConstants.RVMENUDETAILS_TABLE, new Criteria(Column.getColumn((String)RVCConstants.RVMENUDETAILS_TABLE, (String)RVCConstants.RV_MENU_ID), (Object)((Integer)viewConfigToMenuRow.get(RVCConstants.RV_MENU_ID)), 0));
        if (dataObj != null) {
            Row viewToObjectTypeMapping = dataObj.getRow(RVCConstants.RVMENUDETAILS_TABLE);
            this.details.put("SHOW_IMAGE", (Boolean)viewToObjectTypeMapping.get("SHOW_OBJECT_IMAGE"));
            this.details.put("SHOW_SEARCH", (Boolean)viewToObjectTypeMapping.get("SHOW_SEARCH"));
            this.details.put("SELECTABLE", Integer.valueOf((Integer)viewToObjectTypeMapping.get("IS_SELECTABLE")));
            this.details.put("IS_ACTION_COLUMN", true);
            this.details.put("COLUMN_CUSTOM_ENABLE", (Boolean)viewToObjectTypeMapping.get("COLUMN_CUSTOM_ENABLE"));
            this.details.put("POPUP_TYPE_ID", AutomationConstants.MGMT_AUTOMATION_POPUP_TYPE_ID);
        }
        this.details.put("RELATIONALTYPE", false);
    }

    public void setUniqueId(int uniqueId) {
        this.uniqueId = uniqueId;
    }
}

