/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.resultview;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.O365MgmtHandler;
import com.adventnet.sym.adsm.common.server.customview.ColumnConfiguration;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.resultview.DataSource;
import com.adventnet.sym.adsm.common.server.resultview.RVCConstants;
import com.adventnet.sym.adsm.common.server.resultview.RVReqParams;
import com.adventnet.sym.adsm.common.server.resultview.TableDataSource;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBUtil;
import com.adventnet.sym.adsm.common.server.util.RVUtil;
import com.adventnet.sym.adsm.common.server.wengine.SchedulerRunNowObject;
import com.adventnet.sym.adsm.common.webclient.transformers.Transformers;
import com.adventnet.sym.adsm.security.server.util.DateTimeUtil;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import org.json.JSONObject;

public class DelayedTaskView
implements DataSource,
TableDataSource {
    private List tableData = new ArrayList();
    private ArrayList totalColumnList = new ArrayList();
    private Long totalResultCount = 0L;
    private Hashtable multipleValueSids = new Hashtable();
    private Hashtable details = new Hashtable();
    private HashMap uniqueColumnIdentityMap = new HashMap();
    private int uniqueId;
    private static final Integer OBJECT_PROPERTIES_COLUMN_ID = 1009;
    private static final Integer RESULT_MESSAGE_COLUMN_ID = 1012;

    public Hashtable getMultipleValueSids() {
        return this.multipleValueSids;
    }

    public ArrayList getColumnList() {
        return this.totalColumnList;
    }

    public Hashtable getDetails() {
        return this.details;
    }

    public Hashtable getMulitpleValuesSids() {
        return this.multipleValueSids;
    }

    public List getTableData() {
        return this.tableData;
    }

    public Long getTotalResultCount() {
        return this.totalResultCount;
    }

    public HashMap getUniqueColIdentityMap() {
        this.uniqueColumnIdentityMap.put("COLUMN_ID", "COLUMN_ID");
        this.uniqueColumnIdentityMap.put("COLUMN_NAME", "DISPLAY_NAME");
        return this.uniqueColumnIdentityMap;
    }

    public int getUniqueId() {
        return this.uniqueId;
    }

    public void setTotalColumnList(ArrayList columnList) {
        this.totalColumnList = columnList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initDataSource(AdventNetResourceBundle rb, RVReqParams reqParams, DataObject dataObject, boolean isForExport, boolean isForScheduler) {
        DataSet dataSet = null;
        Connection connection = null;
        try {
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            Long loginId = reqParams.getLoginId();
            ArrayList headerColumnList = new ArrayList();
            Long cvId = ColumnConfiguration.getCVId((String)RVUtil.getCustomViewModuleName((int)reqParams.getRvId()), (long)loginId);
            if (cvId == null) {
                cvId = ColumnConfiguration.getDefaultCvId((String)RVUtil.getCustomViewModuleName((int)reqParams.getRvId()));
            }
            logger.log(Level.FINE, "CV ID for the rvid " + reqParams.getRvId() + " is " + cvId);
            this.setDetails(dataObject, reqParams);
            headerColumnList = ColumnConfiguration.getHeaderColumnList((Long)cvId);
            this.setUniqueId(reqParams.getFilterId());
            String baseTableName = "DelayedTasks";
            Criteria criteria = null;
            Criteria loginIdCriteria = null;
            loginIdCriteria = loginId.compareTo(CommonUtil.ADMIN_LOGIN_ID) == 0 ? new Criteria(Column.getColumn((String)baseTableName, (String)"LOGIN_ID"), null, 1) : new Criteria(Column.getColumn((String)baseTableName, (String)"LOGIN_ID"), (Object)loginId, 0);
            criteria = criteria != null ? criteria.and(loginIdCriteria) : loginIdCriteria;
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)baseTableName));
            query.addSelectColumn(Column.getColumn(null, (String)"*"));
            query.addJoin(new Join(Table.getTable((String)baseTableName), Table.getTable((String)"DelayedTaskType"), new String[]{"TASK_TYPE_ID"}, new String[]{"TASK_TYPE_ID"}, 1));
            query.addJoin(new Join(Table.getTable((String)baseTableName), Table.getTable((String)"DelayedTaskStatusDetails"), new String[]{"DELAYED_TASK_ID"}, new String[]{"DELAYED_TASK_ID"}, 2));
            Criteria statusCriteria = null;
            if (this.uniqueId == 246) {
                statusCriteria = new Criteria(Column.getColumn((String)"DelayedTaskStatusDetails", (String)"STATUS"), (Object)4, 0);
                statusCriteria = statusCriteria.or(new Criteria(Column.getColumn((String)"DelayedTaskStatusDetails", (String)"STATUS"), (Object)2, 0));
            } else if (this.uniqueId == 247) {
                statusCriteria = new Criteria(Column.getColumn((String)"DelayedTaskStatusDetails", (String)"STATUS"), (Object)0, 0);
                statusCriteria = statusCriteria.or(new Criteria(Column.getColumn((String)"DelayedTaskStatusDetails", (String)"STATUS"), (Object)3, 0));
            }
            if (statusCriteria != null) {
                criteria = criteria.and(statusCriteria);
            }
            JSONObject searchJsonObj = reqParams.getSearchStringJson();
            String matchingCriteria = reqParams.getMatchCriteria();
            Criteria searchCrit = null;
            if (searchJsonObj != null) {
                Iterator keys = searchJsonObj.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    String value = searchJsonObj.getString(key);
                    String tableName = baseTableName;
                    if (key.equalsIgnoreCase("TASK_NAME")) {
                        tableName = "DelayedTaskType";
                    } else if (key.equalsIgnoreCase("STATUS_DISPLAY") || key.equalsIgnoreCase("RESULT_MESSAGE")) {
                        tableName = "DelayedTaskStatusDetails";
                    }
                    Criteria crit = new Criteria(Column.getColumn((String)tableName, (String)key), (Object)value, 12);
                    if (searchCrit == null) {
                        searchCrit = crit;
                        continue;
                    }
                    if (matchingCriteria.equalsIgnoreCase("OR")) {
                        searchCrit = searchCrit.or(crit);
                        continue;
                    }
                    if (!matchingCriteria.equalsIgnoreCase("AND")) continue;
                    searchCrit = searchCrit.and(crit);
                }
            }
            if (searchCrit != null) {
                criteria = criteria.and(searchCrit);
            }
            query.setCriteria(criteria);
            if (reqParams.getSortAttribId() != 0) {
                for (int index = 0; index < headerColumnList.size(); ++index) {
                    HashMap details = (HashMap)headerColumnList.get(index);
                    Integer columnId = (Integer)details.get("COLUMN_ID");
                    if (!columnId.equals(reqParams.getSortAttribId())) continue;
                    String sortTableName = (String)details.get("TABLE_NAME");
                    String sortColumnName = (String)details.get("COLUMN_NAME");
                    query.addSortColumn(new SortColumn(sortTableName, sortColumnName, reqParams.isSortOrder()));
                    break;
                }
            } else {
                query.addSortColumn(new SortColumn(baseTableName, "CREATION_TIME", false));
            }
            dataSet = relationalAPI.executeQuery((Query)query, connection);
            HashMap<Object, String> rowData = null;
            ArrayList<Long> taskIdList = new ArrayList<Long>();
            ArrayList tableRowsList = new ArrayList();
            while (dataSet.next()) {
                rowData = new HashMap<Object, String>();
                HashMap<String, Object> inputValues = null;
                Long taskId = (Long)dataSet.getValue("DELAYED_TASK_ID");
                rowData.put("DELAYED_TASK_ID", taskId.toString());
                if (taskIdList.contains(taskId)) continue;
                taskIdList.add(taskId);
                for (int index = 0; index < headerColumnList.size(); ++index) {
                    Object columnValue;
                    Transformers uiTransformer;
                    inputValues = new HashMap<String, Object>();
                    HashMap details = (HashMap)headerColumnList.get(index);
                    Integer columnId = (Integer)details.get("COLUMN_ID");
                    String columnName = (String)details.get("COLUMN_NAME");
                    String transformerClassName = (String)details.get("TRANSFORMER_CLASS");
                    if (columnName.equalsIgnoreCase("ACTION")) {
                        if (isForExport) {
                            headerColumnList.remove(index--);
                            continue;
                        }
                        details.put("IS_SORT", false);
                        Long schedulerId = (Long)dataSet.getValue("SCHEDULE_ID");
                        SchedulerRunNowObject runNowObj = SchedulerRunNowObject.getInstanceForDelayedTask();
                        String runNowStatus = runNowObj.getSchedulerStatus(loginId, schedulerId);
                        inputValues.put("schedulerId", schedulerId);
                        inputValues.put("runNowStatus", runNowStatus);
                        inputValues.put("cvId", cvId);
                        uiTransformer = (Transformers)Class.forName(transformerClassName.trim()).newInstance();
                        columnValue = uiTransformer.renderCell(rb, columnName, schedulerId, details, inputValues, isForExport);
                        rowData.put(columnId, rb.getString(columnValue.toString()));
                        continue;
                    }
                    if (columnName.equalsIgnoreCase("CREATION_TIME") || columnName.equalsIgnoreCase("NEXT_EXECUTION_TIME") || columnName.equalsIgnoreCase("EXECUTED_ON")) {
                        details.put("IS_SORT", false);
                        if (dataSet.getValue(columnName) != null) {
                            String columnValue2 = DateTimeUtil.formatDate((Long)((Long)dataSet.getValue(columnName)), (Long)loginId);
                            rowData.put(columnId, columnValue2);
                            continue;
                        }
                        rowData.put(columnId, "-");
                        continue;
                    }
                    if (columnName.equalsIgnoreCase("OBJECT_PROPERTIES")) {
                        details.put("IS_SORT", false);
                        this.multipleValueSids.put(taskId.toString(), new Hashtable());
                        continue;
                    }
                    if (columnName.equalsIgnoreCase("STATUS_DISPLAY")) {
                        details.put("IS_SORT", true);
                        Integer status = (Integer)dataSet.getValue("STATUS");
                        String dispStatus = (String)dataSet.getValue("STATUS_DISPLAY");
                        inputValues.put("Status", dispStatus);
                        inputValues.put("intStatus", status);
                        Long schedulerId = (Long)dataSet.getValue("SCHEDULE_ID");
                        inputValues.put("schedulerId", schedulerId);
                        inputValues.put("isForExport", isForExport);
                        inputValues.put("cvId", cvId);
                        uiTransformer = (Transformers)Class.forName(transformerClassName.trim()).newInstance();
                        columnValue = uiTransformer.renderCell(rb, columnName, schedulerId, details, inputValues, isForExport);
                        rowData.put(columnId, columnValue.toString());
                        continue;
                    }
                    details.put("IS_SORT", true);
                    if (dataSet.getValue(columnName) != null) {
                        Object colValue = dataSet.getValue(columnName);
                        if (!isForExport && columnId == RESULT_MESSAGE_COLUMN_ID && ((String)colValue).toLowerCase().indexOf("successfully_modified") == -1) {
                            rowData.put(columnId, rb.getString((String)colValue) + "<br><a class=\"greenlinktxt\" href=\"/help/misc/troubleshooting_tips.html#Office_365_Management\" target=\"_help\">" + rb.getString("admp.common.text.learn_more") + "</a>");
                            continue;
                        }
                        rowData.put(columnId, rb.getString(colValue.toString()));
                        continue;
                    }
                    rowData.put(columnId, "-");
                }
                tableRowsList.add(rowData);
            }
            this.setTotalColumnList(headerColumnList);
            this.tableData = tableRowsList.size() >= reqParams.getToIndex() && !isForExport ? tableRowsList.subList(reqParams.getFromIndex() - 1, reqParams.getToIndex()) : tableRowsList;
            query = new SelectQueryImpl(Table.getTable((String)baseTableName));
            query.addSelectColumn(Column.getColumn((String)baseTableName, (String)"DELAYED_TASK_ID").count());
            query.addJoin(new Join(Table.getTable((String)baseTableName), Table.getTable((String)"DelayedTaskType"), new String[]{"TASK_TYPE_ID"}, new String[]{"TASK_TYPE_ID"}, 1));
            query.addJoin(new Join(Table.getTable((String)baseTableName), Table.getTable((String)"DelayedTaskStatusDetails"), new String[]{"DELAYED_TASK_ID"}, new String[]{"DELAYED_TASK_ID"}, 2));
            query.setCriteria(criteria);
            this.setTotalResultCount((long)DBUtil.getCount((SelectQuery)query));
            this.getObjectProperties(rb, this.totalColumnList, "DELAYED_TASK_ID", isForExport, isForScheduler);
            DBUtil.closeDataSetAndConnection((DataSet)dataSet, (Connection)connection);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            DBUtil.closeDataSetAndConnection(dataSet, (Connection)connection);
        }
    }

    private void getObjectProperties(AdventNetResourceBundle rb, ArrayList totalColumnList, String tableKey, boolean isExport, boolean isForScheduler) {
        try {
            if (isExport) {
                ArrayList<String> attribName = new ArrayList<String>();
                SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)"DelayedTaskInputDetails"));
                sq.addSelectColumn(Column.getColumn(null, (String)"*"));
                int j = 0;
                Object[] guids = new Object[this.multipleValueSids.size()];
                Enumeration e = this.multipleValueSids.keys();
                while (e.hasMoreElements()) {
                    guids[j] = e.nextElement();
                    ++j;
                }
                Criteria crit = new Criteria(Column.getColumn((String)"DelayedTaskInputDetails", (String)tableKey), (Object)guids, 8);
                sq.setCriteria(crit);
                DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)sq);
                for (int i = 0; i < guids.length; ++i) {
                    StringBuilder objectProps = new StringBuilder();
                    Iterator singleInputIterator = dataObj.getRows("DelayedTaskInputDetails", new Criteria(Column.getColumn((String)"DelayedTaskInputDetails", (String)"DELAYED_TASK_ID"), guids[i], 0));
                    while (singleInputIterator.hasNext()) {
                        Row inputRow = (Row)singleInputIterator.next();
                        String curAttrib = (String)inputRow.get("ATTRIB_NAME");
                        if (!attribName.contains(curAttrib)) {
                            attribName.add(curAttrib);
                        }
                        ArrayList val = new ArrayList();
                        Boolean isMulti = (Boolean)inputRow.get("IS_MULTIPLE_VALUE");
                        if (!isMulti.booleanValue()) {
                            val.add((String)inputRow.get("VALUE"));
                            objectProps.append(curAttrib + " : " + val + "; ");
                            continue;
                        }
                        Long taskInputId = (Long)inputRow.get("TASK_INPUT_ID");
                        SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"DelayedTaskMultiInputDetails"));
                        query.addSelectColumn(Column.getColumn(null, (String)"*"));
                        DataObject dObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
                        Iterator multiInputIterator = dObj.getRows("DelayedTaskMultiInputDetails", new Criteria(Column.getColumn((String)"DelayedTaskMultiInputDetails", (String)"TASK_INPUT_ID"), (Object)taskInputId, 0));
                        ArrayList<String> ids = new ArrayList<String>();
                        while (multiInputIterator.hasNext()) {
                            Row multiRow = (Row)multiInputIterator.next();
                            ids.add((String)multiRow.get("VALUE"));
                            val = O365MgmtHandler.getDisplayNameForAudit(ids);
                        }
                        objectProps.append(curAttrib + " : " + val + "; ");
                    }
                    Hashtable attributeIds = (Hashtable)this.multipleValueSids.get(guids[i]);
                    StringBuilder values = (StringBuilder)attributeIds.get(OBJECT_PROPERTIES_COLUMN_ID);
                    if (values == null) {
                        values = new StringBuilder();
                        attributeIds.put(OBJECT_PROPERTIES_COLUMN_ID, values);
                    }
                    values.append((CharSequence)objectProps);
                }
            }
            HashMap<String, String> inputValues = null;
            Enumeration e = this.multipleValueSids.keys();
            while (e.hasMoreElements()) {
                inputValues = new HashMap<String, String>();
                String taskId = (String)e.nextElement();
                inputValues.put("DELAYED_TASK_ID", taskId);
                Hashtable attributeIds = (Hashtable)this.multipleValueSids.get(taskId);
                if (attributeIds == null) continue;
                for (int index = 0; index < totalColumnList.size(); ++index) {
                    HashMap attributeProperties = (HashMap)totalColumnList.get(index);
                    String columnName = (String)attributeProperties.get("COLUMN_NAME");
                    Integer attributeId = (Integer)attributeProperties.get("COLUMN_ID");
                    String transformerClassName = (String)attributeProperties.get("TRANSFORMER_CLASS");
                    if (!columnName.equalsIgnoreCase("OBJECT_PROPERTIES")) continue;
                    StringBuilder mulitpleValueList = (StringBuilder)attributeIds.get(attributeId);
                    Transformers uiTransformer = (Transformers)Class.forName(transformerClassName.trim()).newInstance();
                    Object columnValue = uiTransformer.renderCell(rb, columnName, mulitpleValueList, attributeProperties, inputValues, isExport);
                    attributeIds.put(attributeId, columnValue.toString());
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setTotalResultCount(Long totalResultCount) {
        this.totalResultCount = totalResultCount;
    }

    private void setDetails(DataObject dataObject, RVReqParams reqParams) throws Exception {
        Row viewConfigToMenuRow = dataObject.getRow(RVCConstants.RVTOMENUMAPPING_TABLE, new Criteria(Column.getColumn((String)RVCConstants.RVTOMENUMAPPING_TABLE, (String)RVCConstants.FILTER_ID), (Object)reqParams.getFilterId(), 0));
        DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get(RVCConstants.RVMENUDETAILS_TABLE, new Criteria(Column.getColumn((String)RVCConstants.RVMENUDETAILS_TABLE, (String)RVCConstants.RV_MENU_ID), (Object)((Integer)viewConfigToMenuRow.get(RVCConstants.RV_MENU_ID)), 0));
        if (dataObj != null) {
            Row viewToObjectTypeMapping = dataObj.getRow(RVCConstants.RVMENUDETAILS_TABLE);
            this.details.put("SHOW_IMAGE", (Boolean)viewToObjectTypeMapping.get("SHOW_OBJECT_IMAGE"));
            this.details.put("SHOW_SEARCH", (Boolean)viewToObjectTypeMapping.get("SHOW_SEARCH"));
            this.details.put("SELECTABLE", Integer.valueOf((Integer)viewToObjectTypeMapping.get("IS_SELECTABLE")));
            this.details.put("IS_ACTION_COLUMN", true);
            this.details.put("JOIN_TABLE_KEY", "DELAYED_TASK_ID");
            this.details.put("COLUMN_CUSTOM_ENABLE", (Boolean)viewToObjectTypeMapping.get("COLUMN_CUSTOM_ENABLE"));
            this.details.put("UNIQUE_COLUMN_NAME", "DELAYED_TASK_ID");
        }
        this.details.put("RELATIONALTYPE", false);
    }

    public void setUniqueId(int uniqueId) {
        this.uniqueId = uniqueId;
    }
}

