/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.resultview;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.Range;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.customview.ColumnConfiguration;
import com.adventnet.sym.adsm.common.server.delegation.DelegationUtil;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.resultview.DataSource;
import com.adventnet.sym.adsm.common.server.resultview.RVReqParams;
import com.adventnet.sym.adsm.common.server.resultview.TableDataSource;
import com.adventnet.sym.adsm.common.server.util.DBUtil;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;

public class FileServerList
implements DataSource,
TableDataSource {
    private List tableData = new ArrayList();
    private ArrayList totalColumnList = new ArrayList();
    private Long totalResultCount = 0L;
    private Hashtable multipleValueSids = new Hashtable();
    private Hashtable details = new Hashtable();
    private HashMap uniqueColumnIdentityMap = new HashMap();
    private int uniqueId;

    public List getTableData() {
        return this.tableData;
    }

    public Long getTotalResultCount() {
        return this.totalResultCount;
    }

    public Hashtable getMulitpleValuesSids() {
        return this.multipleValueSids;
    }

    public ArrayList getColumnList() {
        return this.totalColumnList;
    }

    public int getUniqueId() {
        return this.uniqueId;
    }

    public HashMap getUniqueColIdentityMap() {
        this.uniqueColumnIdentityMap.put("COLUMN_ID", "COLUMN_ID");
        this.uniqueColumnIdentityMap.put("COLUMN_NAME", "DISPLAY_NAME");
        return this.uniqueColumnIdentityMap;
    }

    public Hashtable getDetails() {
        return this.details;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initDataSource(AdventNetResourceBundle rb, RVReqParams reqParams, DataObject dataObject, boolean isForExport, boolean isForScheduler) {
        DataSet dataSet = null;
        Connection connection = null;
        try {
            this.setUniqueId(reqParams.getFilterId());
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            ArrayList headerColumnList = new ArrayList();
            Long cvId = ColumnConfiguration.getCVId((String)"FileServerList", (long)DelegationUtil.ADMIN_LOGIN_ID);
            this.setDetails(dataObject, reqParams);
            headerColumnList = ColumnConfiguration.getHeaderColumnList((Long)cvId);
            this.setTotalColumnList(headerColumnList);
            String baseTableName = "ADSMFileServers";
            String joinTableName = "ADSMComputerGeneralDetails";
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)baseTableName));
            Join join = new Join(baseTableName, joinTableName, new String[]{"OBJECT_GUID"}, new String[]{"OBJECT_GUID"}, 2);
            query.addJoin(join);
            ArrayList<Column> selectColumnList = new ArrayList<Column>();
            for (int colList = 0; colList < headerColumnList.size(); ++colList) {
                HashMap colDetails = (HashMap)headerColumnList.get(colList);
                selectColumnList.add(Column.getColumn((String)"ADSMFileServers", (String)((String)colDetails.get("COLUMN_NAME"))));
            }
            selectColumnList.add(Column.getColumn((String)"ADSMFileServers", (String)"OBJECT_GUID"));
            query.addSelectColumns(selectColumnList);
            query.addSortColumn(new SortColumn(baseTableName, "NAME", true));
            Criteria c = new Criteria(Column.getColumn((String)joinTableName, (String)"IS_DELETED"), (Object)1, 0);
            query.setCriteria(c);
            Long loginId = reqParams.getLoginId();
            Range range = new Range(reqParams.getFromIndex(), reqParams.getToIndex());
            query.setRange(range);
            dataSet = relationalAPI.executeQuery((Query)query, connection);
            HashMap<Object, Object> rowData = null;
            while (dataSet.next()) {
                rowData = new HashMap<Object, Object>();
                HashMap inputValues = null;
                if (dataSet.getValue("OBJECT_GUID") != null) {
                    rowData.put("OBJECT_GUID", dataSet.getValue("OBJECT_GUID"));
                }
                for (int index = 0; index < headerColumnList.size(); ++index) {
                    inputValues = new HashMap();
                    HashMap details = (HashMap)headerColumnList.get(index);
                    Integer columnId = (Integer)details.get("COLUMN_ID");
                    String columnName = (String)details.get("COLUMN_NAME");
                    rowData.put(columnId, (String)dataSet.getValue(columnName));
                }
                rowData.put("ONCLICK_ACTION_SCRIPT", "RVTableView.onRowSelect(this)");
                this.tableData.add(rowData);
            }
            query = new SelectQueryImpl(Table.getTable((String)baseTableName));
            join = new Join(baseTableName, joinTableName, new String[]{"OBJECT_GUID"}, new String[]{"OBJECT_GUID"}, 2);
            query.addJoin(join);
            query.addSelectColumn(Column.getColumn((String)"ADSMFileServers", (String)"OBJECT_GUID").count());
            query.setCriteria(c);
            this.setTotalResultCount((long)DBUtil.getCount((SelectQuery)query));
            DBUtil.closeDataSetAndConnection((DataSet)dataSet, (Connection)connection);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            DBUtil.closeDataSetAndConnection(dataSet, connection);
        }
    }

    public void setTotalResultCount(Long totalResultCount) {
        this.totalResultCount = totalResultCount;
    }

    public void setTotalColumnList(ArrayList columnList) {
        this.totalColumnList = columnList;
    }

    public void setUniqueId(int uniqueId) {
        this.uniqueId = uniqueId;
    }

    private void setDetails(DataObject dataObject, RVReqParams reqParams) throws Exception {
        this.details.put("uniqueId", reqParams.getFilterId());
        this.details.put("SHOW_IMAGE", false);
        this.details.put("SHOW_SEARCH", false);
        this.details.put("SELECTABLE", 2);
        this.details.put("IS_ACTION_COLUMN", false);
        this.details.put("COLUMN_CUSTOM_ENABLE", false);
        this.details.put("RELATIONALTYPE", false);
        this.details.put("UNIQUE_COLUMN_NAME", "OBJECT_GUID");
    }

    private static Criteria getCriteria(ArrayList ouList) {
        Criteria ouCrit = null;
        try {
            for (int i = 0; i < ouList.size(); ++i) {
                String ouDN = (String)ouList.get(i);
                Criteria crite = new Criteria(Column.getColumn((String)"ADSMComputerGeneralDetails", (String)"DISTINGUISHED_NAME"), (Object)ouDN, 11);
                ouCrit = ouCrit == null ? crite : ouCrit.or(crite);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ouCrit;
    }
}

