/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.resultview;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Range;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.persistence.WritableDataObject;
import com.adventnet.sym.adsm.common.server.customview.ColumnConfiguration;
import com.adventnet.sym.adsm.common.server.cvc.CVCDataUtil;
import com.adventnet.sym.adsm.common.server.cvc.CVCUtil;
import com.adventnet.sym.adsm.common.server.delegation.DelegationUtil;
import com.adventnet.sym.adsm.common.server.fileserver.FileServerMgmtHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.resultview.DataSource;
import com.adventnet.sym.adsm.common.server.resultview.RVReqParams;
import com.adventnet.sym.adsm.common.server.resultview.TableDataSource;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBUtil;
import com.adventnet.sym.adsm.common.server.util.FileServerMgmtUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.json.JSONObject;

public class PremissionPreview
implements DataSource,
TableDataSource {
    private List tableData = new ArrayList();
    private ArrayList totalColumnList = new ArrayList();
    private Long totalResultCount = 0L;
    private Hashtable multipleValueSids = new Hashtable();
    private Hashtable details = new Hashtable();
    private HashMap uniqueColumnIdentityMap = new HashMap();
    private int uniqueId;

    public List getTableData() {
        return this.tableData;
    }

    public Long getTotalResultCount() {
        return this.totalResultCount;
    }

    public ArrayList getColumnList() {
        return this.totalColumnList;
    }

    public Hashtable getMulitpleValuesSids() {
        return this.multipleValueSids;
    }

    public Hashtable getDetails() {
        return this.details;
    }

    public HashMap getUniqueColIdentityMap() {
        this.uniqueColumnIdentityMap.put("COLUMN_ID", "COLUMN_ID");
        this.uniqueColumnIdentityMap.put("COLUMN_NAME", "ACCOUNT_NAME");
        return this.uniqueColumnIdentityMap;
    }

    public int getUniqueId() {
        return this.uniqueId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initDataSource(AdventNetResourceBundle rb, RVReqParams reqParams, DataObject dataObject, boolean isForExport, boolean isForScheduler) {
        try {
            Object iter;
            this.setUniqueId(reqParams.getFilterId());
            ArrayList headerColumnList = new ArrayList();
            Long cvId = ColumnConfiguration.getCVId((String)"FolderPermPreview", (long)DelegationUtil.ADMIN_LOGIN_ID);
            this.setDetails(dataObject, reqParams);
            headerColumnList = ColumnConfiguration.getHeaderColumnList((Long)cvId);
            this.setTotalColumnList(headerColumnList);
            String baseTableName = "ADSMPremissionPreviewResult";
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)baseTableName));
            ArrayList<Column> selectColumnList = new ArrayList<Column>();
            for (int colList = 0; colList < headerColumnList.size(); ++colList) {
                HashMap colDetails = (HashMap)headerColumnList.get(colList);
                selectColumnList.add(Column.getColumn((String)baseTableName, (String)((String)colDetails.get("COLUMN_NAME"))));
            }
            selectColumnList.add(Column.getColumn((String)baseTableName, (String)"UNIQUE_ID"));
            selectColumnList.add(Column.getColumn((String)baseTableName, (String)"PERMISSION_TYPE"));
            query.addSelectColumns(selectColumnList);
            query.addSortColumn(new SortColumn(baseTableName, "PERMISSION_TYPE", true));
            query.addSortColumn(new SortColumn(baseTableName, "ACE_TYPE", true));
            query.addSortColumn(new SortColumn(baseTableName, "ACCOUNT_NAME", true));
            Criteria criteria = null;
            ArrayList outputFilters = reqParams.getOutputFilters();
            Long folderInputId = null;
            for (int index = 0; index < outputFilters.size(); ++index) {
                JSONObject json = (JSONObject)outputFilters.get(index);
                iter = json.keys();
                if (!iter.hasNext()) continue;
                String inputIdStr = (String)iter.next();
                criteria = new Criteria(Column.getColumn((String)baseTableName, (String)"FOLDER_INPUT_ID"), (Object)new Long(inputIdStr), 0);
                if (reqParams.getIsBasicView().booleanValue()) {
                    criteria = criteria.and(new Criteria(Column.getColumn((String)baseTableName, (String)"PERMISSION_TYPE"), (Object)3L, 1));
                }
                folderInputId = new Long(inputIdStr);
            }
            query.setCriteria(criteria);
            Range range = new Range(reqParams.getFromIndex(), reqParams.getToIndex());
            query.setRange(range);
            DataObject dObj = null;
            iter = FileServerMgmtHandler.getFsmPreviewSyncObj();
            synchronized (iter) {
                dObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
            }
            if (!dObj.isEmpty()) {
                this.fillTableDataValues(dObj, baseTableName, headerColumnList, reqParams.getIsBasicView());
            } else if (folderInputId != null) {
                Long cvcId = CVCUtil.getCVCId((Integer)reqParams.getReportId());
                DataObject dataObj = CVCUtil.getCVConfiguration((Long)cvcId);
                Row permissionConfig = dataObj.getFirstRow("CVCPermissionConfig");
                String permObjectType = (String)permissionConfig.get("PERM_OBJECT_TYPE");
                ArrayList components = CVCDataUtil.getComponentsList((Long)cvcId);
                DataObject cvcDO = CVCDataUtil.getCVCDataDO((Long)reqParams.getCvcDataId(), (ArrayList)components);
                Criteria folderCriteria = new Criteria(Column.getColumn((String)"CVCFolderSelectionData", (String)"INPUT_ID"), (Object)folderInputId, 0);
                Row folderRow = cvcDO.getRow("CVCFolderSelectionData", folderCriteria);
                String folderPath = (String)folderRow.get("FOLDER_PATH");
                Hashtable folderPermissions = FileServerMgmtUtil.getUserBasedFolderPermissions(null, (String)folderPath, (Long)reqParams.getLoginId(), (AdventNetResourceBundle)rb, (boolean)true, (String)permObjectType);
                JSONObject cvcData = CVCDataUtil.getCVCData((Long)reqParams.getCvcDataId(), (int)reqParams.getReportId(), (Long)cvcId);
                Hashtable selectedPermissions = FileServerMgmtUtil.getPermissionComponentData((JSONObject)cvcData, (String)permObjectType, (AdventNetResourceBundle)rb);
                JSONObject checkBoxComponents = (JSONObject)cvcData.get("CHECK_BOX_COMPONENT");
                Iterator ite = checkBoxComponents.keys();
                Boolean removeExisting = false;
                Boolean isInherited = false;
                while (ite.hasNext()) {
                    String fieldName = (String)ite.next();
                    if (fieldName.equalsIgnoreCase("IsInherited")) {
                        isInherited = (Boolean)checkBoxComponents.get(fieldName);
                        continue;
                    }
                    if (!fieldName.equalsIgnoreCase("RemoveExisting")) continue;
                    removeExisting = (Boolean)checkBoxComponents.get(fieldName);
                }
                WritableDataObject dO = new WritableDataObject();
                HashMap previewPermissions = FileServerMgmtUtil.getCombinedPermissions((Hashtable)folderPermissions, (Hashtable)selectedPermissions, (Boolean)isInherited, (Boolean)removeExisting, (String)permObjectType, (AdventNetResourceBundle)rb);
                for (Integer permissionType : previewPermissions.keySet()) {
                    for (Long aceType : ((HashMap)previewPermissions.get(permissionType)).keySet()) {
                        for (Long inheritType : ((HashMap)((HashMap)previewPermissions.get(permissionType)).get(aceType)).keySet()) {
                            for (Properties props : (ArrayList)((HashMap)((HashMap)previewPermissions.get(permissionType)).get(aceType)).get(inheritType)) {
                                ArrayList permissions = (ArrayList)props.get("permission");
                                Row r = new Row(baseTableName);
                                r.set("ACCOUNT_NAME", props.get("trustee"));
                                r.set("APPLIES_TO", props.get("appliesTo"));
                                r.set("ACE_TYPE", props.get("aceType"));
                                if (props.get("isInherited") != null && !((String)props.get("isInherited")).equals("")) {
                                    r.set("IS_INHERITED", props.get("isInherited"));
                                }
                                r.set("PERMISSION_TYPE", (Object)new Long(((Integer)props.get("permissionType")).intValue()));
                                r.set("FOLDER_INPUT_ID", (Object)folderInputId);
                                String permission = "";
                                for (Properties permProps : permissions) {
                                    if (permission.equals("")) {
                                        permission = permission + permProps.get("ACCESS_MASK_STRING");
                                        continue;
                                    }
                                    permission = permission + ", " + permProps.get("ACCESS_MASK_STRING");
                                }
                                r.set("PERMISSION", (Object)permission);
                                dO.addRow(r);
                            }
                        }
                    }
                }
                Object object = FileServerMgmtHandler.getFsmPreviewSyncObj();
                synchronized (object) {
                    CommonUtil.getPersistence((boolean[])new boolean[0]).add((DataObject)dO);
                    dObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
                }
                this.fillTableDataValues(dObj, baseTableName, headerColumnList, reqParams.getIsBasicView());
            }
            query = new SelectQueryImpl(Table.getTable((String)baseTableName));
            query.addSelectColumn(Column.getColumn((String)baseTableName, (String)"UNIQUE_ID").count());
            query.setCriteria(criteria);
            this.setTotalResultCount((long)DBUtil.getCount((SelectQuery)query));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void fillTableDataValues(DataObject dObj, String baseTableName, ArrayList headerColumnList, Boolean isBasicView) {
        try {
            Iterator it = dObj.getRows(baseTableName);
            HashMap<Object, Object> rowData = null;
            while (it.hasNext()) {
                rowData = new HashMap<Object, Object>();
                Row r = (Row)it.next();
                HashMap inputValues = null;
                if (r.get("UNIQUE_ID") != null) {
                    rowData.put("UNIQUE_ID", r.get("UNIQUE_ID"));
                }
                for (int index = 0; index < headerColumnList.size(); ++index) {
                    inputValues = new HashMap();
                    HashMap details = (HashMap)headerColumnList.get(index);
                    Integer columnId = (Integer)details.get("COLUMN_ID");
                    String columnName = (String)details.get("COLUMN_NAME");
                    rowData.put(columnId, (String)r.get(columnName));
                }
                Long permissionType = (Long)r.get("PERMISSION_TYPE");
                rowData.put("ROW_ICON", this.getRowIconClass(permissionType.intValue(), isBasicView));
                this.tableData.add(rowData);
            }
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
    }

    private String getRowIconClass(Integer permissionType, Boolean isBasicView) {
        switch (permissionType) {
            case 1: {
                return isBasicView != false ? "comm-icon mod-prmin-icon" : "comm-icon new-prmin-icon";
            }
            case 2: {
                return "comm-icon mod-prmin-icon";
            }
            case 3: {
                return "comm-icon removed-prmin-icon";
            }
        }
        return "comm-icon ext-prmin-icon";
    }

    public void setTotalResultCount(Long totalResultCount) {
        this.totalResultCount = totalResultCount;
    }

    public void setTotalColumnList(ArrayList columnList) {
        this.totalColumnList = columnList;
    }

    public void setUniqueId(int uniqueId) {
        this.uniqueId = uniqueId;
    }

    private void setDetails(DataObject dataObject, RVReqParams reqParams) throws Exception {
        this.details.put("uniqueId", reqParams.getFilterId());
        this.details.put("SHOW_IMAGE", false);
        this.details.put("SHOW_SEARCH", false);
        this.details.put("SELECTABLE", 0);
        this.details.put("IS_ACTION_COLUMN", false);
        this.details.put("COLUMN_CUSTOM_ENABLE", false);
        this.details.put("RELATIONALTYPE", false);
        this.details.put("UNIQUE_COLUMN_NAME", "OBJECT_GUID");
    }
}

