/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.resultview;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.O365InfoCache;
import com.adventnet.sym.adsm.common.server.cvc.CVCDataUtil;
import com.adventnet.sym.adsm.common.server.cvc.CVCUtil;
import com.adventnet.sym.adsm.common.server.delegation.O365DelegationUtil;
import com.adventnet.sym.adsm.common.server.fileserver.FileServerTaskMgmtUtil;
import com.adventnet.sym.adsm.common.server.helpdesk.ADMPAuthObject;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.reports.ReportHandler;
import com.adventnet.sym.adsm.common.server.resultview.IDataModel;
import com.adventnet.sym.adsm.common.server.resultview.RVCConstants;
import com.adventnet.sym.adsm.common.server.resultview.RVHandler;
import com.adventnet.sym.adsm.common.server.resultview.RVReqParams;
import com.adventnet.sym.adsm.common.server.resultview.ResultViewDataHandler;
import com.adventnet.sym.adsm.common.server.resultview.SelectionTableModel;
import com.adventnet.sym.adsm.common.server.usermanagement.AddUserHandler;
import com.adventnet.sym.adsm.common.server.util.InputsUtil;
import com.adventnet.sym.adsm.common.server.util.RVUtil;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import com.adventnet.sym.adsm.common.webclient.reports.advanced.AdvancedReportsUtil;
import com.adventnet.sym.adsm.common.webclient.resultview.RVClientUtil;
import com.adventnet.sym.adsm.security.server.util.DateTimeUtil;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;
import org.apache.struts.actions.DispatchAction;
import org.apache.struts.upload.FormFile;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class RVCAction
extends DispatchAction {
    private Logger logger = Logger.getLogger(RVCAction.class.getName());
    public static final Integer[] htmlEscapeListIds = new Integer[]{300, 303, 196, 703, 101, 102, 551};

    public ActionForward getResultViewListUI(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String forwardPage = "";
        Long time = 0L;
        try {
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            DataObject rvcDataObject = null;
            Integer rvcDataId = 0;
            Integer reportId = Integer.parseInt(request.getParameter("reportId"));
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            if (!reportId.equals(0)) {
                Long cvcDataModelId = Long.parseLong(request.getParameter("cvcDataId"));
                DataObject cvcDataDO = CVCDataUtil.getCVCDataDO((Long)cvcDataModelId, (ArrayList)CVCDataUtil.getComponentsList((Long)CVCUtil.getCVCId((Integer)reportId)));
                String rvcDataIdStr = request.getParameter("rvcId");
                if (rvcDataIdStr != null && (rvcDataId = Integer.valueOf(Integer.parseInt(rvcDataIdStr))).equals(RVCConstants.FSM_PERMISSION_PREVIEW_RVC_ID)) {
                    Criteria criteria = new Criteria(Column.getColumn((String)"ADSMRVCDataConfiguration", (String)"RVC_ID"), (Object)rvcDataId, 0);
                    this.logger.log(Level.FINE, "Other than reportmodule fult multiview " + criteria);
                    rvcDataObject = ResultViewDataHandler.getRVCDataObject((Criteria)criteria);
                    ArrayList outputFiltersList = CVCDataUtil.getFolderSelectionOutputFilters((DataObject)cvcDataDO);
                    request.setAttribute("opFilter", ((Properties)outputFiltersList.get(0)).get("OBJECT_NAME"));
                } else {
                    rvcDataObject = ResultViewDataHandler.getRVCDataObject((Integer)reportId, (DataObject)cvcDataDO);
                    Row reportToViewMappingrow = rvcDataObject.getRow("ADSMReportToRVCDataMapping");
                    rvcDataId = (Integer)reportToViewMappingrow.get("RVC_ID");
                    if (rvcDataId.equals(RVCConstants.FILE_SERVER_MGMT_RVC_ID)) {
                        HashMap genDetails = FileServerTaskMgmtUtil.getGenerationProps((AdventNetResourceBundle)rb, (Long)cvcDataModelId);
                        request.setAttribute("statusMessage", genDetails.get("statusMessage"));
                        request.setAttribute("status", genDetails.get("status"));
                    } else {
                        Row row = AdvancedReportsUtil.getGenerationProps(loginId, cvcDataModelId);
                        time = (Long)row.get("CREATION_TIME");
                        SimpleDateFormat format = DateTimeUtil.getDateFormat((Long)loginId);
                        String genTime = format.format(new Date(time));
                        ArrayList outputFiltersList = CVCDataUtil.getOutputFilters((DataObject)cvcDataDO);
                        request.setAttribute("generatedTime", (Object)genTime);
                        request.setAttribute("opFilter", (Object)StrUtil.getStringFromListProps((ArrayList)outputFiltersList, (String)"OBJECT_NAME", (int)RVCConstants.RVC_OP_FILTERS_LIST_TRIM_SIZE));
                    }
                }
            } else {
                rvcDataId = Integer.parseInt(request.getParameter("rvcId"));
                Criteria criteria = new Criteria(Column.getColumn((String)"ADSMRVCDataConfiguration", (String)"RVC_ID"), (Object)rvcDataId, 0);
                this.logger.log(Level.FINE, "Other than reportmodule fult multiview " + criteria);
                rvcDataObject = ResultViewDataHandler.getRVCDataObject((Criteria)criteria);
                if (rvcDataId.equals(RVCConstants.FC_BUC_RVC_ID)) {
                    request.setAttribute("statusMessage", (Object)rb.getString("admp.mgmt.user_mgmt.cre_bulk_user.text_creating_users_pls_wait"));
                } else if (rvcDataId.equals(RVCConstants.FC_BOC_RVC_ID)) {
                    request.setAttribute("statusMessage", (Object)rb.getString("admp.mgmt.user_mgmt.cre_bulk_ou.text_creating_ous_pls_wait"));
                } else if (rvcDataId.equals(RVCConstants.FC_BCC_RVC_ID)) {
                    request.setAttribute("statusMessage", (Object)rb.getString("admp.management.contact_management.contact_result.creating_contacts_please_wait"));
                }
            }
            Row rvcDataConfigrow = rvcDataObject.getRow("ADSMRVCDataConfiguration");
            forwardPage = (String)rvcDataConfigrow.get("TILE_NAME");
            request.setAttribute("viewDataModel", (Object)rvcDataObject);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward(forwardPage);
    }

    public ActionForward getRVHeaderUI(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String forwardPage = "";
        try {
            HttpSession session = request.getSession();
            Integer filterId = Integer.parseInt(request.getParameter("filterId"));
            DataObject rvcDataObject = null;
            String rvcDataIdStr = request.getParameter("rvcId");
            String customParams = request.getParameter("customParams");
            int onTheFlyMgmtReportId = 0;
            if (customParams != null && customParams.length() > 0) {
                JSONObject custParams = new JSONObject(customParams);
                if (custParams.has("onTheFlyMgmtDetails")) {
                    JSONObject onTheFlyMgmtDetails = (JSONObject)custParams.get("onTheFlyMgmtDetails");
                    onTheFlyMgmtReportId = Integer.parseInt(onTheFlyMgmtDetails.getString("onTheFlyMgmtReportId"));
                } else if (custParams.has("onTheFlyMgmtReportId")) {
                    onTheFlyMgmtReportId = Integer.parseInt(custParams.getString("onTheFlyMgmtReportId"));
                }
            }
            Integer reportId = Integer.parseInt(request.getParameter("reportId"));
            Integer rvcId = 0;
            if (!(reportId.equals(0) || rvcDataIdStr != null && (rvcId = Integer.valueOf(Integer.parseInt(rvcDataIdStr))).equals(RVCConstants.FSM_PERMISSION_PREVIEW_RVC_ID))) {
                Long cvcDataModelId = Long.parseLong(request.getParameter("cvcDataId"));
                DataObject cvcDataDO = CVCDataUtil.getCVCDataDO((Long)cvcDataModelId, (ArrayList)CVCDataUtil.getComponentsList((Long)CVCUtil.getCVCId((Integer)reportId)));
                rvcDataObject = ResultViewDataHandler.getRVCDataObject((Integer)reportId, (DataObject)cvcDataDO);
                ArrayList domainsList = InputsUtil.getDomainList((DataObject)cvcDataDO);
                if (!domainsList.isEmpty()) {
                    request.setAttribute("cvcDomains", (Object)domainsList);
                } else {
                    JSONArray waadDomainsList = CVCDataUtil.getWaadAccountSelectionData((DataObject)cvcDataDO, (int)3);
                    if (waadDomainsList.length() > 0) {
                        ADMPAuthObject authObj = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
                        ArrayList hdtdomains = authObj.getDomainList();
                        ArrayList<Object> configuredHDTDomains = new ArrayList<Object>();
                        for (Properties prop : hdtdomains) {
                            configuredHDTDomains.add(prop.get("DEFAULT_NAMING_CONTEXT"));
                        }
                        request.setAttribute("cvcDomains", configuredHDTDomains);
                    }
                }
            } else {
                this.logger.log(Level.FINE, "Other than report header ui " + request.getParameter("rvcId"));
                rvcId = Integer.parseInt(request.getParameter("rvcId"));
                Criteria criteria = new Criteria(Column.getColumn((String)"ADSMRVCDataConfiguration", (String)"RVC_ID"), (Object)rvcId, 0);
                rvcDataObject = ResultViewDataHandler.getRVCDataObject((Criteria)criteria);
            }
            request.setAttribute("viewDataModel", (Object)rvcDataObject);
            Row reportToViewMappingrow = rvcDataObject.getRow("ADSMSummaryFilter", new Criteria(Column.getColumn((String)"ADSMSummaryFilter", (String)"FILTER_ID"), (Object)filterId, 0));
            forwardPage = (String)reportToViewMappingrow.get("HEADER_TILE_NAME");
            request.setAttribute("filterId", (Object)filterId);
            request.setAttribute("onTheFlyMgmtReportId", (Object)onTheFlyMgmtReportId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward(forwardPage);
    }

    public ActionForward getResultViewUI(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String forwardPage = "";
        JSONObject jsonObject = null;
        try {
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            ADMPAuthObject authObj = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
            jsonObject = new JSONObject(request.getParameter("params"));
            DataObject rvcDataObject = null;
            RVReqParams reqParams = new RVReqParams(jsonObject);
            JSONObject tempJson = null;
            String waadTenantId = "";
            ArrayList delegatedO365Domains = new ArrayList();
            boolean applyOURestriction = false;
            try {
                tempJson = new JSONObject(reqParams.getCustomParams());
                if (tempJson.has("waadAccountId")) {
                    waadTenantId = (String)tempJson.get("waadAccountId");
                    int[] iamAppIds = new int[]{3, 2};
                    Hashtable iamAppAccountDetails = authObj.getAuthorizedIamAppAccountDetails(waadTenantId, iamAppIds);
                    delegatedO365Domains = authObj.getDelegatedIamAppDomains(waadTenantId, iamAppIds);
                    int iamAppId = (Integer)iamAppAccountDetails.get("iamAppId");
                    if (iamAppId == 3) {
                        ArrayList objectIdList = CVCUtil.getObjectIdList((Long)reqParams.getCvcDataId());
                        applyOURestriction = objectIdList.size() > 0 && (Integer)objectIdList.get(0) == 7 ? authObj.getApplyOURestriction(waadTenantId, "group").booleanValue() : authObj.getApplyOURestriction(waadTenantId, "user").booleanValue();
                    }
                }
            }
            catch (JSONException ex) {
                this.logger.log(Level.FINE, "json exception occured getresultviewui");
            }
            if (reqParams.getRvcId() == RVCConstants.O365_CRT_USER_RVC_ID.intValue() || reqParams.getRvcId() == RVCConstants.O365_LIC_MGMT_RVC_ID.intValue() || reqParams.getRvcId() == RVCConstants.O365_REMOTE_USER_RVC_ID.intValue() || reqParams.getRvcId() == RVCConstants.O365_LIC_MGMT_RVC_ID.intValue() || reqParams.getRvcId() == RVCConstants.O365_LIT_HOLD_RVC_ID.intValue() || reqParams.getRvcId() == RVCConstants.O365_PROXY_ADDRESSES_RVC_ID.intValue() || reqParams.getRvcId() == RVCConstants.O365_IN_PLACE_ARCHIVE_RVC_ID.intValue() || applyOURestriction) {
                JSONArray authArray;
                if (tempJson.has("adDomain")) {
                    ArrayList authOUList = (ArrayList)authObj.getDomainOUsMap().get(tempJson.getString("adDomain"));
                    authArray = new JSONArray((Collection)authOUList);
                    jsonObject.put("authOUList", (Object)authArray);
                    reqParams = new RVReqParams(jsonObject);
                } else if (tempJson.has("domainList") || applyOURestriction) {
                    JSONArray domainList = new JSONArray();
                    if (tempJson.has("domainList")) {
                        domainList = tempJson.getJSONArray("domainList");
                    } else {
                        domainList = O365DelegationUtil.getLinkedADDomains((ADMPAuthObject)authObj, (String)waadTenantId);
                        jsonObject.put("applyOURestriction", true);
                    }
                    authArray = new JSONArray((Collection)O365DelegationUtil.getAuthorizedOUList((ADMPAuthObject)authObj, (JSONArray)domainList));
                    jsonObject.put("authOUList", (Object)authArray);
                    reqParams = new RVReqParams(jsonObject);
                }
            }
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(loginId);
            String custParams = reqParams.getCustomParams();
            if (custParams.length() > 0) {
                try {
                    JSONObject customParams = new JSONObject(custParams);
                    if (customParams.has("onTheFlyMgmtDetails")) {
                        JSONObject onTheFlyMgmtDetails = (JSONObject)customParams.get("onTheFlyMgmtDetails");
                        if (onTheFlyMgmtDetails.has("licFilterDetails")) {
                            JSONObject licFilterDetails = (JSONObject)onTheFlyMgmtDetails.get("licFilterDetails");
                            Iterator it = licFilterDetails.keys();
                            while (it.hasNext()) {
                                String key = (String)it.next();
                                customParams.put(key, licFilterDetails.get(key));
                            }
                            onTheFlyMgmtDetails.remove("licFilterDetails");
                            reqParams.setCustomParams(customParams.toString());
                        }
                        reqParams.setOnTheFlyMgmtDetails(onTheFlyMgmtDetails);
                        request.setAttribute("onTheFlyMgmt", (Object)"true");
                    }
                }
                catch (JSONException ex) {
                    // empty catch block
                }
            }
            reqParams.setLoginId(loginId);
            reqParams.setRb(rb);
            reqParams.setDelegatedO365Domains(delegatedO365Domains);
            if (reqParams.getReportId() != 0 && !Integer.valueOf(reqParams.getRvcId()).equals(RVCConstants.FSM_PERMISSION_PREVIEW_RVC_ID)) {
                this.logger.log(Level.FINE, "getResultViewUI getReportId " + reqParams.getReportId());
                Integer reportId = reqParams.getReportId();
                Long dataModelId = reqParams.getCvcDataId();
                DataObject cvcDataDO = CVCDataUtil.getCVCDataDO((Long)dataModelId, (ArrayList)CVCDataUtil.getComponentsList((Long)CVCUtil.getCVCId((Integer)reportId)));
                rvcDataObject = ResultViewDataHandler.getRVCDataObject((Integer)reportId, (DataObject)cvcDataDO);
            } else {
                this.logger.log(Level.FINE, "Getting resultvierw other than report moduel" + reqParams.getRvcId());
                Criteria criteria = new Criteria(Column.getColumn((String)"ADSMRVCDataConfiguration", (String)"RVC_ID"), (Object)reqParams.getRvcId(), 0);
                rvcDataObject = ResultViewDataHandler.getRVCDataObject((Criteria)criteria);
            }
            forwardPage = RVUtil.getViewModelTileName((Integer)reqParams.getViewModelId());
            if (!reqParams.getIsNavigate()) {
                ResultViewDataHandler.setRangeForModule((DataObject)rvcDataObject, (Integer)reqParams.getFilterId(), (Integer)reqParams.getRange(), (Long)loginId);
            }
            boolean isForExport = false;
            IDataModel iDataModel = RVHandler.getDataModel((AdventNetResourceBundle)rb, (RVReqParams)reqParams, (DataObject)rvcDataObject, (boolean)isForExport, (boolean)false);
            request.setAttribute("htmlEscapeListIds", (Object)htmlEscapeListIds);
            request.setAttribute("IDataModel", (Object)iDataModel);
            ArrayList o365LicenseList = RVCAction.getO365Licenses(reqParams, iDataModel, authObj);
            if (o365LicenseList != null) {
                request.setAttribute("o365LicenseList", (Object)o365LicenseList);
                if (reqParams.getReportId() == 0) {
                    request.setAttribute("o365LicenseFor", (Object)new String("Mgmt"));
                } else {
                    request.setAttribute("o365LicenseFor", (Object)new String("Report"));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.logger.log(Level.FINE, "Going forward the page for the viewModel " + forwardPage);
        return mapping.findForward(forwardPage);
    }

    public ActionForward getJSONDataForReportRVC(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            HttpSession session = request.getSession();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            int reportId = Integer.valueOf(request.getParameter("reportId"));
            Long dataModelId = AdvancedReportsUtil.getCVCDataId(reportId, loginId, session.getId());
            DataObject cvcDataDO = CVCDataUtil.getCVCDataDO((Long)dataModelId, (ArrayList)CVCDataUtil.getComponentsList((Long)CVCUtil.getCVCId((Integer)reportId)));
            DataObject rvcDataObject = ResultViewDataHandler.getRVCDataObject((Integer)reportId, (DataObject)cvcDataDO);
            Row reportToViewMappingrow = rvcDataObject.getRow("ADSMReportToRVCDataMapping");
            Integer rvcDataId = (Integer)reportToViewMappingrow.get("RVC_ID");
            JSONObject rvcJsonObject = ResultViewDataHandler.getRVCConfigJson((Integer)reportId, (Integer)rvcDataId, (Long)dataModelId, (DataObject)rvcDataObject, (AdventNetResourceBundle)rb, (Long)loginId);
            Row row = AdvancedReportsUtil.getGenerationProps(loginId, dataModelId);
            DataObject obj = ReportHandler.getReportDetails((Integer)reportId);
            Row reportDetails = obj.getFirstRow("ADSMReports");
            String reportName = rb.getString((String)reportDetails.get("REPORT_NAME"));
            Long generationId = (Long)row.get("REPORT_GENERATION_ID");
            rvcJsonObject.put("generationId", (Object)generationId);
            rvcJsonObject.put("reportName", (Object)reportName);
            response.setContentType("application/json");
            PrintWriter writer = response.getWriter();
            writer.print(rvcJsonObject.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward getJSONDataForModuleRVC(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            String cvcDataModelIdStr;
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            String rvcIdStr = request.getParameter("rvcID");
            Integer rvcId = Integer.parseInt(rvcIdStr);
            Integer reportId = 0;
            String reportIdStr = request.getParameter("reportId");
            if (reportIdStr != null) {
                reportId = Integer.valueOf(reportIdStr);
            }
            Long cvcDataModelId = (cvcDataModelIdStr = request.getParameter("cvcDataModelId")) != null ? new Long(cvcDataModelIdStr) : 0L;
            Criteria criteria = new Criteria(Column.getColumn((String)"ADSMRVCDataConfiguration", (String)"RVC_ID"), (Object)rvcId, 0);
            DataObject rvcDataObject = ResultViewDataHandler.getRVCDataObject((Criteria)criteria);
            String customParams = request.getParameter("customParams");
            JSONObject rvcJsonObject = ResultViewDataHandler.getRVCConfigJson((Integer)reportId, (Integer)rvcId, (Long)cvcDataModelId, (DataObject)rvcDataObject, (String)customParams, (AdventNetResourceBundle)rb, (Long)loginId);
            response.setContentType("application/json");
            PrintWriter writer = response.getWriter();
            writer.print(rvcJsonObject.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward csvImport(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            String sessionID = request.getSession().getId();
            Long loginId = (Long)request.getSession().getAttribute("ADMP_SESSION_LOGIN_ID");
            Integer filterId = Integer.parseInt(request.getParameter("filterId"));
            String containerName = request.getParameter("containerName");
            String domainName = request.getParameter("domainName");
            Long userCreationID = AddUserHandler.getInstance().addNewUserList(sessionID, domainName, containerName, null, loginId);
            DynaActionForm dynForm = (DynaActionForm)form;
            FormFile formFile = (FormFile)dynForm.get("csvFile");
            JSONObject json = RVClientUtil.csvImport(formFile, userCreationID, filterId, rb);
            json.put("userCreationID", (Object)userCreationID);
            response.setContentType("text/html");
            PrintWriter writer = response.getWriter();
            writer.print(json.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static ArrayList getO365Licenses(RVReqParams reqParams, IDataModel iDataModel, ADMPAuthObject authObj) {
        ArrayList<String> o365LicenseList = null;
        try {
            if (reqParams != null && reqParams.getCustomParams() != null && RVCAction.isLicenseColumnPersent(reqParams, iDataModel) && new JSONObject(reqParams.getCustomParams()).has("waadAccountId")) {
                o365LicenseList = new ArrayList<String>();
                JSONObject customParams = new JSONObject(reqParams.getCustomParams());
                if (customParams.has("waadAccountId")) {
                    String waadAccountId = customParams.getString("waadAccountId");
                    Hashtable iamAppAccountDetails = authObj.getAuthorizedIamAppAccountDetails(waadAccountId, 3);
                    Hashtable authorizedLicenseCountDetails = (Hashtable)iamAppAccountDetails.get("SelectedLicenseServiceCountHash");
                    Properties props = O365InfoCache.getInstance().getO365TenantIdvsLicenseServiceDetails(waadAccountId);
                    JSONArray skuDetails = (JSONArray)props.get("SKU_DETAILS");
                    if (skuDetails != null) {
                        for (int i = 0; i < skuDetails.length(); ++i) {
                            JSONObject skuDetail = skuDetails.getJSONObject(i);
                            String skuId = skuDetail.getString("ACCOUNT_SKU_ID");
                            if (((Boolean)((Hashtable)authorizedLicenseCountDetails.get(skuId)).get("NoServicesSelected")).booleanValue()) continue;
                            o365LicenseList.add(skuId);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return o365LicenseList;
    }

    public static boolean isLicenseColumnPersent(RVReqParams reqParams, IDataModel iDataModel) {
        Integer licenseColumnValue = null;
        if (reqParams != null) {
            licenseColumnValue = reqParams.getReportId() == 0 ? Integer.valueOf(704) : Integer.valueOf(17018);
            SelectionTableModel tm = (SelectionTableModel)iDataModel;
            HashMap uniqueColIdMap = tm.getUniqueColIdentityMap();
            for (int i = 0; i < tm.getHeaderColumnCount(); ++i) {
                HashMap columnMap = tm.getColumnMap(i);
                Integer attributeId = (Integer)RVUtil.getColumnValue((HashMap)columnMap, uniqueColIdMap.get("COLUMN_ID"));
                if (!attributeId.equals(licenseColumnValue)) continue;
                return true;
            }
        }
        return false;
    }
}

