/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.resultview;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.Range;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.customview.ColumnConfiguration;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.resultview.DataSource;
import com.adventnet.sym.adsm.common.server.resultview.RVCConstants;
import com.adventnet.sym.adsm.common.server.resultview.RVReqParams;
import com.adventnet.sym.adsm.common.server.resultview.TableDataSource;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBUtil;
import com.adventnet.sym.adsm.common.server.util.RVUtil;
import com.adventnet.sym.adsm.common.server.util.SchedulerUtil;
import com.adventnet.sym.adsm.common.webclient.util.SchedulerInputsUtil;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;

public class ScheduledReportHistory
implements DataSource,
TableDataSource {
    private List tableData = new ArrayList();
    private ArrayList totalColumnList = new ArrayList();
    private Long totalResultCount = 0L;
    private HashMap uniqueColumnIdentityMap;
    private int uniqueId;
    private Hashtable details = new Hashtable();

    public ScheduledReportHistory() {
        this.uniqueColumnIdentityMap = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initDataSource(AdventNetResourceBundle rb, RVReqParams reqParams, DataObject dataObject, boolean isForExport, boolean isForScheduler) {
        DataSet dataSet = null;
        Connection connection = null;
        try {
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            Long loginId = reqParams.getLoginId();
            ArrayList headerColumnList = new ArrayList();
            Column column = new Column("Schedule_Audit", "SCHEDULE_ID");
            Long cvId = RVUtil.getCustomViewId((int)reqParams.getRvId());
            logger.log(Level.FINE, "CV ID for the rvid schedulerList" + reqParams.getRvId() + " is " + cvId);
            headerColumnList = ColumnConfiguration.getHeaderColumnList((Long)cvId);
            String cvBaseTableName = "ADSMScheduler";
            if (cvId == RVCConstants.RVC_VIEW_ADV_SCHEDULE_HISTORY_CV_ID) {
                cvBaseTableName = "ADSMAdvancedScheduler";
            }
            ArrayList schedulerList = SchedulerInputsUtil.getSchedulers(loginId, cvBaseTableName);
            Long[] scheduleID = new Long[schedulerList.size()];
            for (int i = 0; i < schedulerList.size(); ++i) {
                Hashtable schedulerDetails = (Hashtable)schedulerList.get(i);
                scheduleID[i] = (Long)schedulerDetails.get("SCHEDULE_ID");
            }
            this.setDetails(dataObject, reqParams);
            this.setTotalColumnList(headerColumnList);
            this.setUniqueId(reqParams.getFilterId());
            ArrayList totalColumnList = ColumnConfiguration.getTotalColumnList((long)cvId);
            String baseTableName = "Schedule_Audit";
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)baseTableName));
            for (int index = 0; index < totalColumnList.size(); ++index) {
                HashMap details = (HashMap)totalColumnList.get(index);
                String columnName = (String)details.get("COLUMN_NAME");
                String tableName = (String)details.get("TABLE_NAME");
                query.addSelectColumn(Column.getColumn((String)tableName, (String)columnName));
            }
            Criteria criteria = new Criteria(column, (Object)scheduleID, 8);
            query.setCriteria(criteria);
            query.addSortColumn(new SortColumn("Schedule_Audit", "SCHEDULE_START_TIME", false));
            Range range = new Range(reqParams.getFromIndex(), reqParams.getRange());
            query.setRange(range);
            dataSet = relationalAPI.executeQuery((Query)query, connection);
            HashMap<Integer, Object> rowData = null;
            ArrayList domainNames = new ArrayList();
            String desc = "";
            while (dataSet.next()) {
                rowData = new HashMap<Integer, Object>();
                HashMap inputValues = null;
                for (int index = 0; index < headerColumnList.size(); ++index) {
                    Hashtable SchedulerDetails;
                    inputValues = new HashMap();
                    HashMap details = (HashMap)headerColumnList.get(index);
                    Integer columnId = (Integer)details.get("COLUMN_ID");
                    String columnName = (String)details.get("COLUMN_NAME");
                    Hashtable folderMessage = SchedulerUtil.getGeneratedReportDetailsFolder((Long)((Long)dataSet.getValue("AUDIT_ID")));
                    if (columnName.equalsIgnoreCase("DOMAIN_NAME")) {
                        for (int i = 0; i < schedulerList.size(); ++i) {
                            SchedulerDetails = (Hashtable)schedulerList.get(i);
                            if (!SchedulerDetails.get("SCHEDULE_ID").equals(dataSet.getValue("SCHEDULE_ID"))) continue;
                            domainNames = (ArrayList)SchedulerDetails.get("DOMAIN_NAME");
                        }
                        if (domainNames.size() == 0) {
                            domainNames.add(rb.getString("admp.reports.schedule_reports.scheduler.all_domains"));
                        }
                        rowData.put(columnId, domainNames);
                        continue;
                    }
                    if (columnName.equalsIgnoreCase("DESCRIPTION")) {
                        for (int i = 0; i < schedulerList.size(); ++i) {
                            SchedulerDetails = (Hashtable)schedulerList.get(i);
                            if (!SchedulerDetails.get("SCHEDULE_ID").equals(dataSet.getValue("SCHEDULE_ID"))) continue;
                            desc = rb.getString((String)SchedulerDetails.get("DESCRIPTION"));
                        }
                        rowData.put(columnId, desc);
                        continue;
                    }
                    if (columnName.equalsIgnoreCase("REPORT_DETAILS")) {
                        if (!folderMessage.isEmpty()) {
                            rowData.put(columnId, folderMessage.get("folderPath"));
                            continue;
                        }
                        rowData.put(columnId, "");
                        continue;
                    }
                    if (columnName.equalsIgnoreCase("MESSAGES")) {
                        if (!folderMessage.isEmpty()) {
                            rowData.put(columnId, rb.getString((String)folderMessage.get("message")));
                            continue;
                        }
                        String schName = (String)dataSet.getValue("SCHEDULE_NAME");
                        if (schName.equalsIgnoreCase("admp.reports.sched_reports.sch_view.scheduler_name.significant_reports") || schName.equalsIgnoreCase("admp.reports.sched_reports.sch_view.scheduler_name.daily_report_scheduler") || schName.equalsIgnoreCase("admp.reports.sched_reports.sch_view.scheduler_name.ad_update_scheduler")) {
                            rowData.put(columnId, rb.getString("admp.reports.schedule_reports.schedule_history.info.default_scheduler_wont_mailed"));
                            continue;
                        }
                        rowData.put(columnId, "");
                        continue;
                    }
                    if (columnName.equalsIgnoreCase("TASK_EXECUTION_STATUS")) {
                        String status = rb.getString("admp.reports.sche_reports.common.text.failure");
                        if (((String)dataSet.getValue("TASK_EXECUTION_STATUS")).equalsIgnoreCase("success")) {
                            status = rb.getString("admp.reports.sche_reports.common.text.success");
                        } else if (((String)dataSet.getValue("TASK_EXECUTION_STATUS")).equalsIgnoreCase("processing")) {
                            status = rb.getString("admp.reports.sche_reports.common.text.processing");
                        }
                        rowData.put(columnId, status);
                        continue;
                    }
                    if (columnName.equalsIgnoreCase("SCHEDULE_NAME")) {
                        rowData.put(columnId, rb.getString((String)dataSet.getValue(columnName)));
                        continue;
                    }
                    rowData.put(columnId, dataSet.getValue(columnName));
                }
                this.tableData.add(rowData);
            }
            query = new SelectQueryImpl(Table.getTable((String)baseTableName));
            query.addSelectColumn(Column.getColumn((String)baseTableName, (String)"SCHEDULE_ID").count());
            query.setCriteria(criteria);
            this.setTotalResultCount((long)DBUtil.getCount((SelectQuery)query));
            DBUtil.closeDataSetAndConnection((DataSet)dataSet, (Connection)connection);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            DBUtil.closeDataSetAndConnection(dataSet, (Connection)connection);
        }
    }

    public void setTotalResultCount(Long totalResultCount) {
        this.totalResultCount = totalResultCount;
    }

    public void setTotalColumnList(ArrayList totalColumnList) {
        this.totalColumnList = totalColumnList;
    }

    public void setUniqueId(int uniqueId) {
        this.uniqueId = uniqueId;
    }

    public List getTableData() {
        return this.tableData;
    }

    public Long getTotalResultCount() {
        return this.totalResultCount;
    }

    public ArrayList getColumnList() {
        return this.totalColumnList;
    }

    public Hashtable getMulitpleValuesSids() {
        return new Hashtable();
    }

    private void setDetails(DataObject dataObject, RVReqParams reqParams) throws Exception {
        Row viewConfigToMenuRow = dataObject.getRow(RVCConstants.RVTOMENUMAPPING_TABLE, new Criteria(Column.getColumn((String)RVCConstants.RVTOMENUMAPPING_TABLE, (String)RVCConstants.FILTER_ID), (Object)reqParams.getFilterId(), 0));
        DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get(RVCConstants.RVMENUDETAILS_TABLE, new Criteria(Column.getColumn((String)RVCConstants.RVMENUDETAILS_TABLE, (String)RVCConstants.RV_MENU_ID), (Object)((Integer)viewConfigToMenuRow.get(RVCConstants.RV_MENU_ID)), 0));
        if (dataObj != null) {
            Row viewToObjectTypeMapping = dataObj.getRow(RVCConstants.RVMENUDETAILS_TABLE);
            this.details.put("SHOW_IMAGE", (Boolean)viewToObjectTypeMapping.get("SHOW_OBJECT_IMAGE"));
            this.details.put("SHOW_SEARCH", (Boolean)viewToObjectTypeMapping.get("SHOW_SEARCH"));
            this.details.put("SELECTABLE", Integer.valueOf((Integer)viewToObjectTypeMapping.get("IS_SELECTABLE")));
            this.details.put("IS_ACTION_COLUMN", true);
            this.details.put("COLUMN_CUSTOM_ENABLE", (Boolean)viewToObjectTypeMapping.get("COLUMN_CUSTOM_ENABLE"));
        }
        this.details.put("RELATIONALTYPE", false);
    }

    public Hashtable getDetails() {
        return this.details;
    }

    public HashMap getUniqueColIdentityMap() {
        this.uniqueColumnIdentityMap.put("COLUMN_ID", "COLUMN_ID");
        this.uniqueColumnIdentityMap.put("COLUMN_NAME", "COLUMN_NAME");
        return this.uniqueColumnIdentityMap;
    }

    public int getUniqueId() {
        return this.uniqueId;
    }
}

