/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.resultview;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.db.persistence.metadata.ColumnDefinition;
import com.adventnet.db.persistence.metadata.TableDefinition;
import com.adventnet.db.persistence.metadata.util.MetaDataUtil;
import com.adventnet.db.util.SelectQueryStringUtil;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.O365MgmtHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutConstants;
import com.adventnet.sym.adsm.common.server.model.ObjectClass;
import com.adventnet.sym.adsm.common.server.objects.DirectoryObjectAPI;
import com.adventnet.sym.adsm.common.server.reports.ReportAttributeHandler;
import com.adventnet.sym.adsm.common.server.resultview.DataSource;
import com.adventnet.sym.adsm.common.server.resultview.IDataModel;
import com.adventnet.sym.adsm.common.server.resultview.RVCConstants;
import com.adventnet.sym.adsm.common.server.resultview.RVReqParams;
import com.adventnet.sym.adsm.common.server.resultview.TableDataSource;
import com.adventnet.sym.adsm.common.server.resultview.TableViewQueryHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBUtil;
import com.adventnet.sym.adsm.common.server.util.RVColumnUtil;
import com.adventnet.sym.adsm.common.server.util.RVUtil;
import com.adventnet.sym.adsm.common.server.util.ReportAttributesUtil;
import com.adventnet.sym.adsm.common.webclient.transformers.Transformers;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;

public class WAADGroupsDataSource
implements DataSource,
TableDataSource {
    private List tableData;
    private ArrayList totalColumnList;
    private Long totalResultCount = 0L;
    private Hashtable multipleValueSids;
    private Hashtable details;
    private HashMap uniqueColumnIdentityMap;
    private RVReqParams reqParams;
    private DataObject dataObject;
    private String resultTableName;
    private String selectQueryKey;
    private String countQueryKey;
    private String tableJoinKey;
    private boolean isUnionQuery;
    private boolean isForExport = false;
    private boolean isForScheduler = false;
    private AdventNetResourceBundle rb;
    private Properties splCaseJoinDetails;
    private ArrayList allColumnList = new ArrayList();
    private ArrayList<String> distinctColumnAliasList = new ArrayList();
    private ArrayList<String> adTableNames = new ArrayList();
    private String splCaseJoinTableName = null;
    private ArrayList<String> delegatedLinkedDomainNames = new ArrayList();

    public WAADGroupsDataSource() {
        this.multipleValueSids = new Hashtable();
        this.totalColumnList = new ArrayList();
        this.tableData = new ArrayList();
        this.details = new Hashtable();
        this.uniqueColumnIdentityMap = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initDataSource(AdventNetResourceBundle rb, RVReqParams reqParams, DataObject dataObject, boolean isForExport, boolean isForScheduler) {
        IDataModel dataModel = null;
        try {
            int viewModelId = reqParams.getViewModelId();
            this.resultTableName = "O365GroupReportResult";
            this.initProperties(rb, reqParams, dataObject, isForExport, isForScheduler);
            String className = RVUtil.getClassNameForViewModelId((Integer)viewModelId);
            dataModel = (IDataModel)Class.forName(className.trim()).newInstance();
            HashMap selectQueryTemplateMap = this.getSelectQueryTemplate();
            HashMap countQueryTemplateMap = this.getCountQueryTemplate();
            String tableJoinKey = (String)this.details.get("JOIN_TABLE_KEY");
            DataSet dataSet = null;
            Connection connection = null;
            boolean relationalTypePresent = false;
            boolean flag = isForExport || isForScheduler;
            try {
                RelationalAPI relationalAPI = RelationalAPI.getInstance();
                connection = relationalAPI.getConnection();
                dataSet = relationalAPI.executeQueryWithKey(this.selectQueryKey, (Map)selectQueryTemplateMap, connection);
                HashMap<Object, Object> rowData = null;
                while (dataSet.next()) {
                    rowData = new HashMap<Object, Object>();
                    Object guid = null;
                    if (dataSet.getValue("OBJECT_ID") != null) {
                        rowData.put("OBJECT_ID", dataSet.getValue("OBJECT_ID"));
                        guid = dataSet.getValue("OBJECT_ID");
                    }
                    for (int index = 0; index < this.totalColumnList.size(); ++index) {
                        HashMap attributeProperties = (HashMap)this.totalColumnList.get(index);
                        String columnName = (String)attributeProperties.get("ATTRIB_COLUMN_NAME");
                        Integer attributeId = (Integer)attributeProperties.get("ATTRIB_ID");
                        Integer relationalType = (Integer)attributeProperties.get("RELATIONAL_TYPE");
                        String transformerClassName = (String)attributeProperties.get("TRANSFORMER_CLASS");
                        if (relationalType.equals(new Integer(1))) {
                            relationalTypePresent = true;
                            continue;
                        }
                        if (dataSet.getValue(columnName) != null) {
                            Object obj = dataSet.getValue(columnName);
                            HashMap<String, Long> inputMap = new HashMap<String, Long>();
                            inputMap.put("LOGIN_ID", reqParams.getLoginId());
                            Transformers uiTransformer = (Transformers)Class.forName(transformerClassName.trim()).newInstance();
                            rowData.put(attributeId, uiTransformer.renderCell(rb, columnName, dataSet.getValue(columnName), attributeProperties, inputMap, flag));
                            continue;
                        }
                        rowData.put(attributeId, "-");
                    }
                    if (relationalTypePresent) {
                        this.multipleValueSids.put(guid, new Hashtable());
                    }
                    if (this.details.get("HELP_TEXT") != null) {
                        rowData.put("HELP_TEXT", this.details.get("HELP_TEXT"));
                    }
                    RVUtil.fillOnClickText((String)((String)this.details.get("ONCLICK_SCRIPT")), rowData);
                    this.tableData.add(rowData);
                }
                this.setCount(this.countQueryKey, countQueryTemplateMap);
                DBUtil.closeDataSetAndConnection((DataSet)dataSet, (Connection)connection);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                DBUtil.closeDataSetAndConnection(dataSet, (Connection)connection);
            }
            this.getMultipleValues(rb, this.totalColumnList, this.multipleValueSids, tableJoinKey, isForExport);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void getMultipleValues(AdventNetResourceBundle rb, ArrayList attributeList, Hashtable multipleValuesSids, String tableKey, boolean isExport) {
        try {
            ArrayList<String> checkList = new ArrayList<String>();
            logger.log(Level.FINE, "Get Mulitple value sids " + multipleValuesSids.size());
            for (int i = 0; i < attributeList.size(); ++i) {
                String tableName;
                HashMap attributeProp = (HashMap)attributeList.get(i);
                Integer relationalType = (Integer)attributeProp.get("RELATIONAL_TYPE");
                if (relationalType.equals(new Integer(0)) || checkList.contains(tableName = (String)attributeProp.get("TABLE_NAME"))) continue;
                SelectQueryImpl sq = new SelectQueryImpl(new Table(tableName));
                Object[] guids = new Object[multipleValuesSids.size()];
                int j = 0;
                Enumeration e = multipleValuesSids.keys();
                while (e.hasMoreElements()) {
                    guids[j] = e.nextElement();
                    ++j;
                }
                Criteria crit = null;
                crit = new Criteria(Column.getColumn((String)tableName, (String)tableKey), (Object)guids, 8);
                sq.setCriteria(crit);
                sq.addSelectColumn(new Column(tableName, "*"));
                DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)sq);
                if (!dataObj.isEmpty()) {
                    Iterator it = dataObj.getRows(tableName);
                    while (it.hasNext()) {
                        Row r = (Row)it.next();
                        Object s = r.get(tableKey);
                        ArrayList tableValues = TableViewQueryHandler.getTableAttributes((ArrayList)attributeList, (String)tableName);
                        Hashtable attributeIds = (Hashtable)multipleValuesSids.get(s);
                        for (int k = 0; k < tableValues.size(); ++k) {
                            Properties props = (Properties)tableValues.get(k);
                            ArrayList<Object> values = (ArrayList<Object>)attributeIds.get((Integer)props.get("ATTRIB_ID"));
                            if (values == null) {
                                values = new ArrayList<Object>();
                                attributeIds.put((Integer)props.get("ATTRIB_ID"), values);
                            }
                            values.add(r.get((String)props.get("COLUMN_NAME")));
                        }
                    }
                }
                checkList.add(tableName);
            }
            HashMap inputValues = null;
            boolean flag = this.isForExport || this.isForScheduler;
            Enumeration e = multipleValuesSids.keys();
            while (e.hasMoreElements()) {
                inputValues = new HashMap();
                Object objectId = e.nextElement();
                inputValues.put("OBJECT_ID", objectId);
                Hashtable attributeIds = (Hashtable)this.multipleValueSids.get(objectId);
                if (attributeIds == null) continue;
                for (int index = 0; index < attributeList.size(); ++index) {
                    HashMap attributeProperties = (HashMap)attributeList.get(index);
                    String columnName = (String)attributeProperties.get("ATTRIB_COLUMN_NAME");
                    Integer attributeId = (Integer)attributeProperties.get("ATTRIB_ID");
                    Integer relationalType = (Integer)attributeProperties.get("RELATIONAL_TYPE");
                    String transformerClassName = (String)attributeProperties.get("TRANSFORMER_CLASS");
                    if (!relationalType.equals(new Integer(1))) continue;
                    ArrayList mulitpleValueList = (ArrayList)attributeIds.get(attributeId);
                    Transformers uiTransformer = (Transformers)Class.forName(transformerClassName.trim()).newInstance();
                    Object columnValue = uiTransformer.renderCell(rb, columnName, mulitpleValueList, attributeProperties, inputValues, flag);
                    attributeIds.put(attributeId, columnValue.toString());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        logger.log(Level.FINE, "Final Mulitple sids .. " + this.multipleValueSids.size());
    }

    private void initProperties(AdventNetResourceBundle resourceBundle, RVReqParams reqParams, DataObject dataObject, boolean isForExport, boolean isForScheduler) throws Exception {
        this.reqParams = reqParams;
        this.dataObject = dataObject;
        this.isForExport = isForExport;
        this.isForScheduler = isForScheduler;
        this.rb = resourceBundle;
        reqParams.setRb(this.rb);
        this.initBasicProperties();
    }

    private void initBasicProperties() throws Exception {
        Properties joinDetails = new Properties();
        joinDetails.put("childTableJoinKey", "OBJECT_GUID");
        joinDetails.put("baseTableJoinKey", "ON_PREMISES_SID");
        joinDetails.put("joinType", (Object)1);
        String joinTableName = "ADSMGroupGeneralDetails";
        SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"WAADADMapping"));
        query.addSelectColumn(Column.getColumn((String)"WAADADMapping", (String)"*"));
        query.addSelectColumn(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_ID"));
        query.addSelectColumn(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_LDAP_NAME"));
        query.addSelectColumn(Column.getColumn((String)"ADSMAttributeDetails", (String)"TABLE_NAME"));
        query.addSelectColumn(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_COLUMN_NAME"));
        query.addJoin(new Join("WAADADMapping", "CVCO365AccountSelectData", new String[]{"WAAD_DOMAIN_ID"}, new String[]{"O365_ACCOUNT_ID"}, 2));
        query.addJoin(new Join("WAADADMapping", "ADSMAttributeDetails", new String[]{"ATTRIB_ID"}, new String[]{"ATTRIB_ID"}, 2));
        Criteria crit = new Criteria(Column.getColumn((String)"CVCO365AccountSelectData", (String)"CVC_DATA_ID"), (Object)this.reqParams.getCvcDataId(), 0);
        crit = crit.and(new Criteria(Column.getColumn((String)"WAADADMapping", (String)"AD_OBJECT_CLASS_NAME"), (Object)"group", 0));
        query.setCriteria(crit);
        DataObject joinDataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
        if (!joinDataObj.isEmpty()) {
            Row r = joinDataObj.getFirstRow("ADSMAttributeDetails");
            String joinColumnName = (String)r.get("ATTRIB_COLUMN_NAME");
            TableDefinition tableDef = MetaDataUtil.getTableDefinitionByName((String)((String)r.get("TABLE_NAME")));
            ColumnDefinition colDef = tableDef.getColumnDefinitionByName(joinColumnName);
            if (colDef.getDataType().equalsIgnoreCase("char")) {
                joinTableName = (String)r.get("TABLE_NAME");
                joinDetails.put("childTableJoinKey", r.get("ATTRIB_COLUMN_NAME"));
            }
        }
        Criteria criter = new Criteria(Column.getColumn((String)"CVCO365AccountSelectData", (String)"CVC_DATA_ID"), (Object)this.reqParams.getCvcDataId(), 0);
        SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)"CVCO365AccountSelectData"));
        sq.addSelectColumn(new Column("CVCO365AccountSelectData", "*"));
        sq.setCriteria(criter);
        DataObject datObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)sq);
        this.delegatedLinkedDomainNames = O365MgmtHandler.getDelegatedLinkedDomainNames((Long)((Long)datObject.getFirstRow("CVCO365AccountSelectData").get("O365_ACCOUNT_ID")), (int)FcLayoutConstants.OFFICE_365_APPID, (Long)this.reqParams.getLoginId());
        this.splCaseJoinDetails = new Properties();
        this.splCaseJoinDetails.put(joinTableName, joinDetails);
        this.splCaseJoinTableName = joinTableName;
        ObjectClass userObjClass = DirectoryObjectAPI.getInstance().getObjectClass("group");
        this.adTableNames.addAll(userObjClass.getChildTables());
        this.adTableNames.addAll(userObjClass.getMultiValueTables());
        DataObject sqldataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get(RVCConstants.RVTOQUERYMAPPING_TABLE, new Criteria(Column.getColumn((String)RVCConstants.RVTOQUERYMAPPING_TABLE, (String)RVCConstants.FILTER_ID), (Object)this.reqParams.getFilterId(), 0));
        Row queryIdRow = sqldataObject.getRow(RVCConstants.RVTOQUERYMAPPING_TABLE);
        this.tableJoinKey = (String)queryIdRow.get("TABLE_KEY");
        this.isUnionQuery = (Boolean)queryIdRow.get(RVCConstants.IS_UNION);
        Long[] queryIdArray = new Long[]{(Long)queryIdRow.get("SELECT_QUERY_ID"), (Long)queryIdRow.get("COUNT_QUERY_ID")};
        sqldataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get(RVCConstants.SELECTSQLSTRING_TABLE, new Criteria(Column.getColumn((String)RVCConstants.SELECTSQLSTRING_TABLE, (String)RVCConstants.QUERY_ID), (Object)queryIdArray, 8));
        queryIdRow = sqldataObject.getRow(RVCConstants.SELECTSQLSTRING_TABLE, new Criteria(Column.getColumn((String)RVCConstants.SELECTSQLSTRING_TABLE, (String)RVCConstants.QUERY_ID), (Object)queryIdArray[0], 0));
        this.selectQueryKey = (String)queryIdRow.get(RVCConstants.QUERY_KEY);
        queryIdRow = sqldataObject.getRow("SelectSQLString", new Criteria(Column.getColumn((String)RVCConstants.SELECTSQLSTRING_TABLE, (String)RVCConstants.QUERY_ID), (Object)queryIdArray[1], 0));
        this.countQueryKey = (String)queryIdRow.get(RVCConstants.QUERY_KEY);
        Row viewConfigToMenuRow = this.dataObject.getRow(RVCConstants.RVTOMENUMAPPING_TABLE, new Criteria(Column.getColumn((String)RVCConstants.RVTOMENUMAPPING_TABLE, (String)RVCConstants.FILTER_ID), (Object)this.reqParams.getFilterId(), 0));
        DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get(RVCConstants.RVMENUDETAILS_TABLE, new Criteria(Column.getColumn((String)RVCConstants.RVMENUDETAILS_TABLE, (String)RVCConstants.RV_MENU_ID), (Object)((Integer)viewConfigToMenuRow.get(RVCConstants.RV_MENU_ID)), 0));
        if (dataObj != null) {
            Row viewToObjectTypeMapping = dataObj.getRow(RVCConstants.RVMENUDETAILS_TABLE);
            this.details.put("SHOW_IMAGE", (Boolean)viewToObjectTypeMapping.get("SHOW_OBJECT_IMAGE"));
            this.details.put("SHOW_SEARCH", (Boolean)viewToObjectTypeMapping.get("SHOW_SEARCH"));
            this.details.put("SELECTABLE", Integer.valueOf((Integer)viewToObjectTypeMapping.get("IS_SELECTABLE")));
            this.details.put("UNIQUE_COLUMN_NAME", (String)viewToObjectTypeMapping.get("UNIQUE_COLUMN_NAME"));
            this.details.put("ONCLICK_SCRIPT", (String)viewToObjectTypeMapping.get("ONCLICK_SCRIPT"));
            this.details.put("COLUMN_CUSTOM_ENABLE", (Boolean)viewToObjectTypeMapping.get("COLUMN_CUSTOM_ENABLE"));
        }
        this.details.put("uniqueId", this.reqParams.getFilterId());
        this.details.put("IS_ACTION_COLUMN", false);
        this.details.put("JOIN_TABLE_KEY", this.tableJoinKey);
        this.details.put("SELECT_QUERY_KEY", this.selectQueryKey);
        this.details.put("COUNT_QUERY_KEY", this.countQueryKey);
        this.details.put("RESULT_TABLE_NAME", this.resultTableName);
    }

    private HashMap getSelectQueryTemplate() {
        HashMap queryTemplate = null;
        try {
            String columnName;
            Long cvcId = this.reqParams.getCvcDataId();
            queryTemplate = new HashMap();
            this.totalColumnList = RVColumnUtil.getViewColumnList((Long)this.reqParams.getLoginId(), (int)this.reqParams.getReportId());
            for (int index = 0; index < this.totalColumnList.size(); ++index) {
                HashMap attributeProperties = (HashMap)this.totalColumnList.get(index);
                Integer relationalType = (Integer)attributeProperties.get("RELATIONAL_TYPE");
                if (relationalType.equals(new Integer(1))) continue;
                columnName = (String)attributeProperties.get("ATTRIB_COLUMN_NAME");
                this.distinctColumnAliasList.add(columnName);
                this.allColumnList.add(attributeProperties);
            }
            ArrayList queryMandatoryAttribList = ReportAttributesUtil.getReportMandatoryAttributes((int)this.reqParams.getObjectIdList().getInt(0));
            for (int i = 0; i < queryMandatoryAttribList.size(); ++i) {
                HashMap attributeProperties = (HashMap)queryMandatoryAttribList.get(i);
                columnName = (String)attributeProperties.get("ATTRIB_COLUMN_NAME");
                if (this.distinctColumnAliasList.contains(columnName)) continue;
                this.distinctColumnAliasList.add(columnName);
                this.allColumnList.add(attributeProperties);
            }
            if (this.reqParams.getApplyOURestriction().booleanValue()) {
                Properties attribProps = ReportAttributeHandler.getInstance().getAttributeProps(Integer.valueOf(2004));
                HashMap attribMap = new HashMap();
                Enumeration e = ((Hashtable)attribProps).keys();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    attribMap.put(key, ((Hashtable)attribProps).get(key));
                }
                String columnName2 = (String)((Hashtable)attribProps).get("ATTRIB_COLUMN_NAME");
                this.allColumnList.add(attribMap);
                this.totalColumnList.add(attribMap);
                if (!this.distinctColumnAliasList.contains(columnName2)) {
                    this.distinctColumnAliasList.add(columnName2);
                }
            }
            if (!this.isUnionQuery) {
                queryTemplate = TableViewQueryHandler.getO365UnionQueryTemplate((ArrayList)this.allColumnList, this.distinctColumnAliasList, (RVReqParams)this.reqParams, (String)this.selectQueryKey, (String)this.resultTableName, (String)this.tableJoinKey, (Properties)this.splCaseJoinDetails, (String)"O365GroupGeneralDetails", (boolean)this.isForScheduler, this.adTableNames, (String)this.splCaseJoinTableName, this.delegatedLinkedDomainNames);
                logger.log(Level.FINE, "Select Query For Plain view(without Union)" + SelectQueryStringUtil.replaceAllTemplatesForKey((String)this.selectQueryKey, (Map)queryTemplate));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return queryTemplate;
    }

    private HashMap getCountQueryTemplate() {
        HashMap countQueryTemplate = null;
        try {
            countQueryTemplate = new HashMap();
            if (!this.isUnionQuery) {
                countQueryTemplate = TableViewQueryHandler.getO365UnionCountQuery((ArrayList)this.totalColumnList, (String)this.resultTableName, (String)"O365GroupGeneralDetails", (String)this.tableJoinKey, (RVReqParams)this.reqParams, this.distinctColumnAliasList, (Properties)this.splCaseJoinDetails, this.adTableNames, this.delegatedLinkedDomainNames);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return countQueryTemplate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCount(String queryKey, HashMap countQueryMap) {
        DataSet dataSet = null;
        Connection connection = null;
        try {
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            dataSet = relationalAPI.executeQueryWithKey(queryKey, (Map)countQueryMap, connection);
            while (dataSet.next()) {
                Object val = dataSet.getValue(1);
                this.setTotalResultCount(Long.valueOf(val.toString()));
            }
            DBUtil.closeDataSetAndConnection((DataSet)dataSet, (Connection)connection);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            DBUtil.closeDataSetAndConnection(dataSet, (Connection)connection);
        }
        logger.log(Level.FINE, "Total result count is " + this.getTotalResultCount() + " For the input unique id " + this.getUniqueId());
    }

    public void setTotalResultCount(Long totalResultCount) {
        this.totalResultCount = totalResultCount;
    }

    public ArrayList getColumnList() {
        return this.totalColumnList;
    }

    public Hashtable getDetails() {
        return this.details;
    }

    public Hashtable getMulitpleValuesSids() {
        return this.multipleValueSids;
    }

    public List getTableData() {
        return this.tableData;
    }

    public Long getTotalResultCount() {
        return this.totalResultCount;
    }

    public HashMap getUniqueColIdentityMap() {
        this.uniqueColumnIdentityMap.put("COLUMN_ID", "ATTRIB_ID");
        this.uniqueColumnIdentityMap.put("COLUMN_NAME", "ATTIB_DISP_NAME");
        return this.uniqueColumnIdentityMap;
    }

    public int getUniqueId() {
        return this.reqParams.getFilterId();
    }
}

