/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.resultview;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.Range;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.customview.ColumnConfiguration;
import com.adventnet.sym.adsm.common.server.delegation.DelegationUtil;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.resultview.DataSource;
import com.adventnet.sym.adsm.common.server.resultview.RVCConstants;
import com.adventnet.sym.adsm.common.server.resultview.RVHandler;
import com.adventnet.sym.adsm.common.server.resultview.RVReqParams;
import com.adventnet.sym.adsm.common.server.resultview.TableDataSource;
import com.adventnet.sym.adsm.common.server.usermanagement.AddUserHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBUtil;
import com.adventnet.sym.adsm.common.server.util.ReportAttributesUtil;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import com.adventnet.sym.adsm.common.webclient.transformers.Transformers;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.json.JSONArray;
import org.json.JSONObject;

public class WAADUserStatusDataSource
implements DataSource,
TableDataSource {
    private List tableData = new ArrayList();
    private ArrayList totalColumnList = new ArrayList();
    private Long totalResultCount = 0L;
    private Hashtable multipleValueSids = new Hashtable();
    private Hashtable details = new Hashtable();
    private HashMap uniqueColumnIdentityMap = new HashMap();
    private int uniqueId;
    public static final Integer O365_MAILDELE_USER_RV_ID = 231;
    public static final Integer O365_HIDE_USER_RV_ID = 233;
    public static final Integer O365_EMAIL_STR_USER_RV_ID = 235;

    public List getTableData() {
        return this.tableData;
    }

    public Long getTotalResultCount() {
        return this.totalResultCount;
    }

    public Hashtable getMulitpleValuesSids() {
        return this.multipleValueSids;
    }

    public ArrayList getColumnList() {
        return this.totalColumnList;
    }

    public int getUniqueId() {
        return this.uniqueId;
    }

    public HashMap getUniqueColIdentityMap() {
        this.uniqueColumnIdentityMap.put("COLUMN_ID", "COLUMN_ID");
        this.uniqueColumnIdentityMap.put("COLUMN_NAME", "DISPLAY_NAME");
        return this.uniqueColumnIdentityMap;
    }

    public Hashtable getDetails() {
        return this.details;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initDataSource(AdventNetResourceBundle rb, RVReqParams reqParams, DataObject dataObject, boolean isForExport, boolean isForScheduler) {
        DataSet dataSet = null;
        Connection connection = null;
        try {
            JSONObject customParams = new JSONObject(reqParams.getCustomParams());
            boolean isCsvMgmt = customParams.getBoolean("isCsvMgmt");
            if (isCsvMgmt) {
                this.initDataSourceForCSVView(rb, reqParams, dataObject);
                return;
            }
            JSONArray selectedUsersJson = customParams.getJSONArray("selectedUsersList");
            long generationId = reqParams.getGenerationId();
            String[] selectedUsersArr = new String[selectedUsersJson.length()];
            for (int ind1 = 0; ind1 < selectedUsersJson.length(); ++ind1) {
                selectedUsersArr[ind1] = selectedUsersJson.getString(ind1);
            }
            this.setUniqueId(reqParams.getFilterId());
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            ArrayList headerColumnList = new ArrayList();
            String moduleName = RVHandler.getCustomViewModuleName((int)reqParams.getFilterId());
            Long cvId = ColumnConfiguration.getCVId((String)moduleName, (long)DelegationUtil.ADMIN_LOGIN_ID);
            this.setDetails(dataObject, reqParams);
            headerColumnList = ColumnConfiguration.getHeaderColumnList((Long)cvId);
            boolean isOnTheFlyMgmt = customParams.has("onTheFlyMgmtReportId");
            if (isOnTheFlyMgmt && this.getUniqueId() == RVCConstants.O365_LIC_MGMT_RESULT_RVC_ID.intValue()) {
                for (int i = 0; i < headerColumnList.size(); ++i) {
                    HashMap columnDetailMap = (HashMap)headerColumnList.get(i);
                    if (!((String)columnDetailMap.get("COLUMN_NAME")).equalsIgnoreCase("LICENSES") && !((String)columnDetailMap.get("COLUMN_NAME")).equalsIgnoreCase("SERVICES")) continue;
                    headerColumnList.remove(i);
                    --i;
                }
            }
            this.setTotalColumnList(headerColumnList);
            String baseTableName = "O365UserGeneralDetails";
            String joinTableName = "ADSMModifyUserResult";
            String exchOnlineJoinTableName = "O365UserExchangeDetails";
            boolean relationalTypePresent = false;
            boolean exchOnlineAttribsPresent = false;
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)baseTableName));
            ArrayList<Column> selectColumnList = new ArrayList<Column>();
            for (HashMap columnDetailMap : this.totalColumnList) {
                Integer relationalType = (Integer)columnDetailMap.get("RELATIONAL_TYPE");
                String tableName = (String)columnDetailMap.get("TABLE_NAME");
                String columnName = (String)columnDetailMap.get("COLUMN_NAME");
                if (tableName.equalsIgnoreCase(exchOnlineJoinTableName)) {
                    exchOnlineAttribsPresent = true;
                }
                if (relationalType.equals(1)) {
                    relationalTypePresent = true;
                    continue;
                }
                selectColumnList.add(Column.getColumn((String)tableName, (String)columnName));
            }
            Join join = new Join(baseTableName, joinTableName, new String[]{"OBJECT_ID"}, new String[]{"OBJECT_GUID"}, 2);
            query.addJoin(join);
            if (exchOnlineAttribsPresent) {
                if (isOnTheFlyMgmt) {
                    query.addJoin(new Join(baseTableName, exchOnlineJoinTableName, new String[]{"OBJECT_ID"}, new String[]{"OBJECT_ID"}, 1));
                } else {
                    query.addJoin(new Join(baseTableName, exchOnlineJoinTableName, new String[]{"OBJECT_ID"}, new String[]{"OBJECT_ID"}, 2));
                }
                selectColumnList.add(Column.getColumn((String)baseTableName, (String)"OBJECT_ID"));
                query.addSelectColumns(selectColumnList);
            } else {
                query.addSelectColumn(Column.getColumn(null, (String)"*"));
            }
            Integer sortColumnId = reqParams.getSortAttribId();
            String sortColumnName = "USER_PRINCIPAL_NAME";
            String sortTableName = "O365UserGeneralDetails";
            if (this.getUniqueId() == O365_HIDE_USER_RV_ID.intValue() || this.getUniqueId() == O365_EMAIL_STR_USER_RV_ID.intValue()) {
                sortTableName = "O365UserExchangeDetails";
            }
            for (HashMap columnDetailMap : this.totalColumnList) {
                String columnName = (String)columnDetailMap.get("COLUMN_NAME");
                if (!((Integer)columnDetailMap.get("COLUMN_ID")).equals(sortColumnId)) continue;
                sortColumnName = columnName;
                sortTableName = (String)columnDetailMap.get("TABLE_NAME");
            }
            if (cvId == 213L) {
                query.addSortColumn(new SortColumn("O365UserExchangeDetails", "MAIL_ALIAS", reqParams.isSortOrder()));
            } else {
                query.addSortColumn(new SortColumn(sortTableName, sortColumnName, reqParams.isSortOrder()));
            }
            Criteria criteria = new Criteria(Column.getColumn((String)baseTableName, (String)"OBJECT_ID"), (Object)selectedUsersArr, 8);
            criteria = criteria.and(new Criteria(Column.getColumn((String)joinTableName, (String)"REPORT_GENERATION_ID"), (Object)generationId, 0));
            query.setCriteria(criteria);
            Range range = new Range(reqParams.getFromIndex(), reqParams.getToIndex());
            query.setRange(range);
            dataSet = relationalAPI.executeQuery((Query)query, connection);
            HashMap<Object, Object> rowData = null;
            long countVal = 0L;
            while (dataSet.next()) {
                rowData = new HashMap<Object, Object>();
                HashMap inputValues = null;
                if (dataSet.getValue("OBJECT_ID") != null) {
                    rowData.put("OBJECT_ID", dataSet.getValue("OBJECT_ID"));
                    if (relationalTypePresent) {
                        this.multipleValueSids.put(dataSet.getValue("OBJECT_ID"), new Hashtable());
                    }
                }
                for (int index = 0; index < headerColumnList.size(); ++index) {
                    inputValues = new HashMap();
                    HashMap details = (HashMap)headerColumnList.get(index);
                    Integer relationalType = (Integer)details.get("RELATIONAL_TYPE");
                    if (relationalType.equals(1)) continue;
                    Integer columnId = (Integer)details.get("COLUMN_ID");
                    String columnName = (String)details.get("COLUMN_NAME");
                    String transformerClassName = (String)details.get("TRANSFORMER_CLASS");
                    if (transformerClassName != null && transformerClassName.length() > 0) {
                        Transformers uiTransformer = (Transformers)Class.forName(transformerClassName.trim()).newInstance();
                        HashMap<String, Integer> colDetails = new HashMap<String, Integer>();
                        colDetails.put("TRIM_SIZE", 2);
                        Object columnValue = uiTransformer.renderCell(rb, columnName, dataSet.getValue(columnName), colDetails, inputValues, false);
                        rowData.put(columnId, columnValue);
                        continue;
                    }
                    Object colValue = dataSet.getValue(columnName);
                    if (colValue == null) continue;
                    if (columnId == 702 && ((String)colValue).toLowerCase().indexOf("successfully_modified") == -1) {
                        rowData.put(columnId, rb.getString((String)colValue) + "<br><a class=\"greenlinktxt\" href=\"/help/misc/troubleshooting_tips.html#Office_365_Management\" target=\"_help\">" + rb.getString("admp.common.text.learn_more") + "</a>");
                        continue;
                    }
                    rowData.put(columnId, rb.getString((String)colValue));
                }
                this.tableData.add(rowData);
                ++countVal;
            }
            query = new SelectQueryImpl(Table.getTable((String)baseTableName));
            query.addSelectColumn(Column.getColumn(null, (String)"*").count());
            join = new Join(baseTableName, joinTableName, new String[]{"OBJECT_ID"}, new String[]{"OBJECT_GUID"}, 2);
            query.addJoin(join);
            query.setCriteria(criteria);
            this.setTotalResultCount((long)DBUtil.getCount((SelectQuery)query));
            this.getMultipleValues(rb, this.totalColumnList, "OBJECT_ID", isForExport, isForScheduler);
            DBUtil.closeDataSetAndConnection((DataSet)dataSet, (Connection)connection);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            DBUtil.closeDataSetAndConnection(dataSet, connection);
        }
    }

    private void getMultipleValues(AdventNetResourceBundle rb, ArrayList totalColumnList, String tableKey, boolean isExport, boolean isForScheduler) {
        try {
            ArrayList<String> checkList = new ArrayList<String>();
            for (int i = 0; i < totalColumnList.size(); ++i) {
                String tableName;
                HashMap columnDetailMap = (HashMap)totalColumnList.get(i);
                Integer relationalType = (Integer)columnDetailMap.get("RELATIONAL_TYPE");
                if (relationalType.equals(0) || checkList.contains(tableName = (String)columnDetailMap.get("TABLE_NAME"))) continue;
                SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)tableName));
                Object[] guids = new Object[this.multipleValueSids.size()];
                int j = 0;
                Enumeration e = this.multipleValueSids.keys();
                while (e.hasMoreElements()) {
                    guids[j] = e.nextElement();
                    ++j;
                }
                Criteria crit = null;
                crit = new Criteria(Column.getColumn((String)tableName, (String)tableKey), (Object)guids, 8);
                sq.setCriteria(crit);
                sq.addSelectColumn(new Column(tableName, "*"));
                DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)sq);
                if (!dataObj.isEmpty()) {
                    Iterator it = dataObj.getRows(tableName);
                    while (it.hasNext()) {
                        Row r = (Row)it.next();
                        Object s = r.get(tableKey);
                        ArrayList tableValues = ColumnConfiguration.getColumnListProperties((ArrayList)totalColumnList, (String)tableName);
                        Hashtable attributeIds = (Hashtable)this.multipleValueSids.get(s);
                        for (int k = 0; k < tableValues.size(); ++k) {
                            Properties props = (Properties)tableValues.get(k);
                            ArrayList<Object> values = (ArrayList<Object>)attributeIds.get((Integer)props.get("COLUMN_ID"));
                            if (values == null) {
                                values = new ArrayList<Object>();
                                attributeIds.put((Integer)props.get("COLUMN_ID"), values);
                            }
                            values.add(r.get((String)props.get("COLUMN_NAME")));
                        }
                    }
                }
                checkList.add(tableName);
            }
            HashMap inputValues = null;
            boolean flag = isExport || isForScheduler;
            Enumeration e = this.multipleValueSids.keys();
            while (e.hasMoreElements()) {
                inputValues = new HashMap();
                Object objectId = e.nextElement();
                inputValues.put("OBJECT_ID", objectId);
                Hashtable attributeIds = (Hashtable)this.multipleValueSids.get(objectId);
                if (attributeIds == null) continue;
                for (int index = 0; index < totalColumnList.size(); ++index) {
                    HashMap attributeProperties = (HashMap)totalColumnList.get(index);
                    String columnName = (String)attributeProperties.get("COLUMN_NAME");
                    Integer attributeId = (Integer)attributeProperties.get("COLUMN_ID");
                    Integer relationalType = (Integer)attributeProperties.get("RELATIONAL_TYPE");
                    String transformerClassName = (String)attributeProperties.get("TRANSFORMER_CLASS");
                    if (!relationalType.equals(1)) continue;
                    ArrayList mulitpleValueList = (ArrayList)attributeIds.get(attributeId);
                    Transformers uiTransformer = (Transformers)Class.forName(transformerClassName.trim()).newInstance();
                    Object columnValue = uiTransformer.renderCell(rb, columnName, mulitpleValueList, attributeProperties, inputValues, flag);
                    attributeIds.put(attributeId, columnValue.toString());
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initDataSourceForCSVView(AdventNetResourceBundle rb, RVReqParams reqParams, DataObject dataObject) {
        DataSet dataSet = null;
        Connection connection = null;
        try {
            this.setUniqueId(reqParams.getFilterId());
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            JSONObject customParams = new JSONObject(reqParams.getCustomParams());
            Long userCreationID = customParams.getLong("userCreationID");
            JSONArray headerJsonArray = customParams.getJSONArray("headerJsonArray");
            this.details.put("headerJsonArray", headerJsonArray);
            JSONArray selectedUsersList = customParams.getJSONArray("userIndexes");
            String[] userIndexes = StrUtil.getStringArray((JSONArray)selectedUsersList);
            Criteria userIndexesCrit = new Criteria(Column.getColumn((String)"ADSMAUNamingAttributes", (String)"USER_INDEX"), (Object)userIndexes, 8);
            ArrayList<Column> selectColumnList = new ArrayList<Column>();
            ArrayList<String> columns = new ArrayList<String>();
            columns.add("USER_INDEX");
            selectColumnList.add(Column.getColumn((String)"ADSMAUNamingAttributes", (String)"USER_INDEX"));
            for (int i = 0; i < headerJsonArray.length(); ++i) {
                ArrayList l;
                String currentHeader = headerJsonArray.getString(i);
                Hashtable attributesdetails = null;
                if (currentHeader.equalsIgnoreCase("UserPrincipalName")) {
                    l = ReportAttributesUtil.getAttributeProps((String[])new String[]{"17004"}, (String)"ATTRIB_ID", null);
                    attributesdetails = (Hashtable)l.get(0);
                } else if (currentHeader.equalsIgnoreCase("ObjectId")) {
                    l = ReportAttributesUtil.getAttributeProps((String[])new String[]{"17001"}, (String)"ATTRIB_ID", null);
                    attributesdetails = (Hashtable)l.get(0);
                } else if (currentHeader.equalsIgnoreCase("EmailAddress")) {
                    l = ReportAttributesUtil.getAttributeProps((String[])new String[]{"17031"}, (String)"ATTRIB_ID", null);
                    attributesdetails = (Hashtable)l.get(0);
                } else {
                    attributesdetails = AddUserHandler.getInstance().getAttributeDetails("ATTRIB_LDAP_NAME", (Object)currentHeader);
                }
                columns.add((String)attributesdetails.get("ATTRIB_COLUMN_NAME"));
                selectColumnList.add(Column.getColumn((String)"ADSMAUNamingAttributes", (String)((String)attributesdetails.get("ATTRIB_COLUMN_NAME"))));
            }
            columns.add("CREATION_MESSAGE");
            selectColumnList.add(Column.getColumn((String)"ADSMAUNamingAttributes", (String)"CREATION_MESSAGE"));
            this.details.put("columnList", columns);
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"ADSMAUNamingAttributes"));
            query.addSelectColumns(selectColumnList);
            Criteria userCreationCrit = new Criteria(Column.getColumn((String)"ADSMAUNamingAttributes", (String)"USER_CREATION_ID"), (Object)userCreationID, 0);
            Criteria msgCrit = new Criteria(Column.getColumn((String)"ADSMAUNamingAttributes", (String)"CREATION_MESSAGE"), null, 1);
            msgCrit.and(new Criteria(Column.getColumn((String)"ADSMAUNamingAttributes", (String)"CREATION_MESSAGE"), (Object)"", 1));
            Criteria crit = userCreationCrit.and(userIndexesCrit);
            crit = crit.and(msgCrit);
            query.setCriteria(crit);
            Range range = new Range(reqParams.getFromIndex(), reqParams.getToIndex() - reqParams.getFromIndex() + 1);
            query.setRange(range);
            query.addSortColumn(new SortColumn("ADSMAUNamingAttributes", "USER_INDEX", true));
            ArrayList tableData = new ArrayList();
            dataSet = relationalAPI.executeQuery((Query)query, connection);
            HashMap<String, Object> rowData = null;
            while (dataSet.next()) {
                rowData = new HashMap<String, Object>();
                for (int index = 0; index < columns.size(); ++index) {
                    String columnName = (String)columns.get(index);
                    rowData.put(columnName, dataSet.getValue(columnName));
                }
                tableData.add(rowData);
            }
            query = new SelectQueryImpl(Table.getTable((String)"ADSMAUNamingAttributes"));
            query.addSelectColumn(Column.getColumn(null, (String)"*").count());
            query.setCriteria(crit);
            this.setTotalResultCount((long)DBUtil.getCount((SelectQuery)query));
            this.details.put("isResultPage", true);
            this.details.put("uniqueId", reqParams.getFilterId());
            this.details.put("tableData", tableData);
            this.details.put("SHOW_IMAGE", false);
            this.details.put("SHOW_SEARCH", false);
            this.details.put("SELECTED_OBJECTS_VIEW", 2);
            DBUtil.closeDataSetAndConnection((DataSet)dataSet, (Connection)connection);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            DBUtil.closeDataSetAndConnection(dataSet, connection);
        }
    }

    public void setTotalResultCount(Long totalResultCount) {
        this.totalResultCount = totalResultCount;
    }

    public void setTotalColumnList(ArrayList columnList) {
        this.totalColumnList = columnList;
    }

    public void setUniqueId(int uniqueId) {
        this.uniqueId = uniqueId;
    }

    private void setDetails(DataObject dataObject, RVReqParams reqParams) throws Exception {
        this.details.put("uniqueId", reqParams.getFilterId());
        this.details.put("JOIN_TABLE_KEY", "OBJECT_ID");
        this.details.put("SHOW_IMAGE", false);
        this.details.put("SHOW_SEARCH", false);
        this.details.put("SELECTABLE", 0);
        this.details.put("IS_ACTION_COLUMN", false);
        this.details.put("COLUMN_CUSTOM_ENABLE", false);
        this.details.put("RELATIONALTYPE", false);
        this.details.put("UNIQUE_COLUMN_NAME", "OBJECT_ID");
    }
}

