/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.statusupdater;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.reports.StatusUpdater;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import com.adventnet.sym.adsm.security.server.util.DateTimeUtil;
import java.io.Serializable;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import org.json.JSONArray;
import org.json.JSONObject;

public class AdvGroupStatusUpdater
implements StatusUpdater {
    private Hashtable rvIdVsFilterId = new Hashtable();
    private Hashtable objectIdVsAttributeId;
    private Hashtable filterIdVsObjectId = new Hashtable();
    private Hashtable filterIdVsFilterCriteriaId;
    protected Hashtable objectIdVsObjectClass;
    private Hashtable filterIdVsCount;
    private Hashtable objectClassVsRowDetails;
    private boolean isCompleted = true;
    private ArrayList guidList = null;
    private ArrayList filterRuleFilterIdList = null;
    private Hashtable multiDCDetails = null;
    private Hashtable taskStatus = null;
    protected int currentTaskCode;
    private String currentObjectName = null;

    public AdvGroupStatusUpdater() {
        this.objectIdVsAttributeId = new Hashtable();
        this.filterIdVsFilterCriteriaId = new Hashtable();
        this.objectIdVsObjectClass = new Hashtable();
        this.filterIdVsCount = new Hashtable();
        this.objectClassVsRowDetails = new Hashtable();
        this.guidList = new ArrayList();
        this.filterRuleFilterIdList = new ArrayList();
        this.multiDCDetails = new Hashtable();
        this.taskStatus = new Hashtable();
    }

    public void init(DataObject rvcDataObject, Long cvcDataId) {
        this.init(rvcDataObject);
    }

    public void init(DataObject rvcDataObject) {
        try {
            Iterator itr = rvcDataObject.getRows("ADSMRVConfiguration");
            while (itr.hasNext()) {
                Row row = (Row)itr.next();
                Integer rvId = (Integer)row.get("RV_ID");
                Integer viewType = (Integer)row.get("VIEW_TYPE");
                Hashtable<String, Serializable> filterDetails = new Hashtable<String, Serializable>();
                filterDetails.put("viewType", viewType);
                Iterator itr1 = rvcDataObject.getRows("ADSMRVSubTabConfiguration", new Criteria(Column.getColumn((String)"ADSMRVSubTabConfiguration", (String)"RV_ID"), (Object)rvId, 0));
                ArrayList<Integer> filterIdList = new ArrayList<Integer>();
                while (itr1.hasNext()) {
                    Row subTabrow = (Row)itr1.next();
                    Integer tabId = (Integer)subTabrow.get("RV_TAB_ID");
                    Iterator innerItr = rvcDataObject.getRows("ADSMSummaryFilter", new Criteria(Column.getColumn((String)"ADSMSummaryFilter", (String)"RV_TAB_ID"), (Object)tabId, 0));
                    while (innerItr.hasNext()) {
                        Row filtersRow = (Row)innerItr.next();
                        Integer filterId = (Integer)filtersRow.get("FILTER_ID");
                        Long filterCriteriaId = (Long)filtersRow.get("FILTER_CRITERIA_ID");
                        if (viewType.equals(2)) {
                            this.filterRuleFilterIdList.add(filterCriteriaId.toString());
                        }
                        Iterator innerItr2 = rvcDataObject.getRows("ADSMRVToObjectTypeMapping", new Criteria(Column.getColumn((String)"ADSMRVToObjectTypeMapping", (String)"FILTER_ID"), (Object)filterId, 0));
                        ArrayList<Integer> objectIdList = new ArrayList<Integer>();
                        while (innerItr2.hasNext()) {
                            Row objectIdMappingRow = (Row)innerItr2.next();
                            Integer objectId = (Integer)objectIdMappingRow.get("OBJECT_ID");
                            if (objectIdList.contains(objectId)) continue;
                            objectIdList.add(objectId);
                        }
                        this.filterIdVsObjectId.put(filterId, objectIdList);
                        this.filterIdVsFilterCriteriaId.put(filterId, filterCriteriaId);
                        filterIdList.add(filterId);
                    }
                }
                if (viewType.equals(2)) {
                    filterDetails.put("filterId", filterIdList);
                }
                this.rvIdVsFilterId.put(rvId, filterDetails);
            }
            this.objectIdVsObjectClass.put(1, "user");
            this.objectIdVsObjectClass.put(2, "group");
            this.objectIdVsObjectClass.put(3, "computer");
            this.objectIdVsObjectClass.put(4, "contact");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void init(Hashtable reportDomains) {
    }

    public void updateStatus(Properties prop, String objClass, String guid) {
        if (!this.guidList.contains(guid)) {
            ArrayList<Properties> rowList;
            Long objCount = (Long)this.filterIdVsCount.get(objClass);
            if (objCount == null) {
                objCount = 0L;
            }
            objCount = objCount + 1L;
            this.filterIdVsCount.put(objClass, objCount);
            ArrayList critValues = (ArrayList)prop.get("CRITERIAS");
            if (critValues != null) {
                for (int i = 0; i < critValues.size(); ++i) {
                    String criteriaId = (String)critValues.get(i);
                    Long critCount = (Long)this.filterIdVsCount.get(criteriaId);
                    if (critCount == null) {
                        critCount = 0L;
                    }
                    critCount = critCount + 1L;
                    this.filterIdVsCount.put(criteriaId, critCount);
                }
            }
            if ((rowList = (ArrayList<Properties>)this.objectClassVsRowDetails.get(objClass)) == null) {
                rowList = new ArrayList<Properties>();
            }
            if (rowList.size() < 25) {
                rowList.add(prop);
                this.objectClassVsRowDetails.put(objClass, rowList);
            }
            this.guidList.add(guid);
        }
    }

    public void setIsCompleted(boolean flag) {
        this.isCompleted = flag;
    }

    public void setProgressTask(int taskCode) {
        this.currentTaskCode = taskCode;
    }

    public void setTaskObject(Object obj) {
        this.currentObjectName = (String)obj;
    }

    public void setTaskError(Object error) {
        Hashtable<String, Object> objects = (Hashtable<String, Object>)this.taskStatus.get(this.currentTaskCode);
        if (objects == null) {
            objects = new Hashtable<String, Object>();
            this.taskStatus.put(this.currentTaskCode, objects);
        }
        objects.put(this.currentObjectName, error);
    }

    public Hashtable getTaskErrors(AdventNetResourceBundle rb) {
        Enumeration keys = this.taskStatus.keys();
        Hashtable objectsVsError = new Hashtable();
        while (keys.hasMoreElements()) {
            Integer taskCode = (Integer)keys.nextElement();
            Hashtable objectNameVsErros = (Hashtable)this.taskStatus.get(taskCode);
            objectsVsError.putAll(objectNameVsErros);
        }
        return objectsVsError;
    }

    public JSONObject getJSONObject(JSONObject jsonObject, AdventNetResourceBundle rb) {
        JSONObject statusJson = this.getCommonJSONObject(rb);
        JSONArray filterDetails = new JSONArray();
        try {
            Integer rvId = jsonObject.getInt("rvId");
            Hashtable rvDetails = (Hashtable)this.rvIdVsFilterId.get(rvId);
            int viewType = (Integer)rvDetails.get("viewType");
            if (viewType == 1) {
                JSONObject json = null;
                JSONArray rvFilterIdArray = (JSONArray)jsonObject.get("rvFilterIdList");
                JSONArray filterIdAttributeList = (JSONArray)jsonObject.get("filterIdAttributeList");
                try {
                    for (int index = 0; index < rvFilterIdArray.length(); ++index) {
                        json = new JSONObject();
                        int filterId = (Integer)rvFilterIdArray.get(index);
                        json.put("filterId", filterId);
                        json.put("count", this.getTabFilterCount(filterId));
                        JSONArray attributeList = (JSONArray)filterIdAttributeList.get(index);
                        json.put("rowData", (Object)this.getRowDetails(filterIdAttributeList.getJSONArray(index), filterId));
                        filterDetails.put((Object)json);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            } else if (viewType == 2) {
                ArrayList filterIdsList = (ArrayList)rvDetails.get("filterId");
                JSONObject json = null;
                try {
                    for (int index = 0; index < filterIdsList.size(); ++index) {
                        json = new JSONObject();
                        int filterId = (Integer)filterIdsList.get(index);
                        json.put("filterId", filterId);
                        json.put("count", this.getCount(filterId));
                        filterDetails.put((Object)json);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            statusJson.put("filterDetails", (Object)filterDetails);
        }
        catch (Exception ex) {
            // empty catch block
        }
        return statusJson;
    }

    private long getTabFilterCount(int filterId) {
        ArrayList objectIdMappingList = (ArrayList)this.filterIdVsObjectId.get(filterId);
        long count = 0L;
        try {
            for (int index = 0; index < objectIdMappingList.size(); ++index) {
                String objectClass = (String)this.objectIdVsObjectClass.get(objectIdMappingList.get(index));
                if (this.filterIdVsCount.get(objectClass) == null) continue;
                count += ((Long)this.filterIdVsCount.get(objectClass)).longValue();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return count;
    }

    private long getCount(int filterId) {
        Long filterCriteriaId = (Long)this.filterIdVsFilterCriteriaId.get(filterId);
        long count = 0L;
        if (this.filterIdVsCount.get(filterCriteriaId.toString()) != null) {
            count = (Long)this.filterIdVsCount.get(filterCriteriaId.toString());
        }
        return count;
    }

    private JSONArray getRowDetails(JSONArray filterIdAttributeList, int filterId) {
        JSONArray rowDetails = new JSONArray();
        Object json = null;
        JSONArray row = null;
        ArrayList objectIdMappingList = (ArrayList)this.filterIdVsObjectId.get(filterId);
        try {
            String objectClass = (String)this.objectIdVsObjectClass.get(objectIdMappingList.get(0));
            ArrayList rowDataList = (ArrayList)this.objectClassVsRowDetails.get(objectClass);
            for (int index = 0; rowDataList != null && index < rowDataList.size(); ++index) {
                row = new JSONArray();
                Properties prop = (Properties)rowDataList.get(index);
                for (int innerIndex = 0; innerIndex < filterIdAttributeList.length(); ++innerIndex) {
                    Integer attribId = (Integer)filterIdAttributeList.get(innerIndex);
                    if (prop.containsKey(attribId)) {
                        ArrayList value = (ArrayList)prop.get(attribId);
                        row.put((Object)ClientUtil.htmlEscape(ClientUtil.scriptEscape(value.get(0).toString())));
                        continue;
                    }
                    row.put((Object)"-");
                }
                rowDetails.put((Object)row);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return rowDetails;
    }

    private JSONObject getCommonJSONObject(AdventNetResourceBundle rb) {
        JSONObject jsonObject = new JSONObject();
        Long date = new Long(System.currentTimeMillis());
        Long loginId = 1L;
        SimpleDateFormat format = DateTimeUtil.getDateFormat((Long)loginId);
        String genTime = format.format(new Date(date));
        try {
            jsonObject.put("errorCount", this.getTaskErrors(rb).size());
            jsonObject.put("isCompleted", this.isCompleted);
            jsonObject.put("count", this.guidList.size());
            if (this.isCompleted) {
                jsonObject.put("generatedTime", (Object)genTime);
            } else {
                jsonObject.put("statusMessage", (Object)this.getCurrentStatusMessage(rb));
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return jsonObject;
    }

    protected String getCurrentStatusMessage(AdventNetResourceBundle rb) {
        String message = rb.getString("admp.reports.adv_group_members.status.fetching_objects");
        if (this.currentTaskCode == StatusUpdater.TASKCODE.FETCHING_GROUP_MEMBERS.getValue()) {
            message = this.currentObjectName != null ? MessageFormat.format(rb.getString("admp.reports.adv_group_members.status.fetching_members_of"), this.currentObjectName) : rb.getString("admp.reports.adv_group_members.status.fetching_members");
        } else if (this.currentTaskCode == StatusUpdater.TASKCODE.FETCHING_DL_MEMBERS.getValue()) {
            message = this.currentObjectName != null ? MessageFormat.format(rb.getString("admp.reports.adv_group_members.status.fetching_dl_members_of"), this.currentObjectName) : rb.getString("admp.reports.adv_group_members.status.fetching_dl_members");
        } else if (this.currentTaskCode == StatusUpdater.TASKCODE.FETCHING_MEMBERS_FROM_ALL_DCS.getValue()) {
            message = rb.getString("admp.reports.adv_group_members.status.fetching_dc_members");
        } else if (this.currentTaskCode == StatusUpdater.TASKCODE.PROCESS_INTERRUPTED.getValue()) {
            message = rb.getString("admp.reports.common.stat_msg.process_interrupted_loading_fetched_data");
        } else if (this.currentTaskCode == 6) {
            message = rb.getString("reports.final_report_page.generating_reports");
        }
        return message;
    }

    public ArrayList getFilterRulesFilterIdList() {
        return this.filterRuleFilterIdList;
    }

    public boolean isCompleted() {
        return this.isCompleted;
    }

    private JSONArray getMultiDCCountDetails() {
        JSONObject jsonObject = null;
        JSONArray jsonArray = new JSONArray();
        Enumeration keys = this.multiDCDetails.keys();
        try {
            while (keys.hasMoreElements()) {
                jsonObject = new JSONObject();
                Object dcName = keys.nextElement();
                Hashtable map = (Hashtable)this.multiDCDetails.get(dcName);
                jsonObject.put("dcName", dcName);
                jsonObject.put("count", map.get("count"));
                jsonObject.put("image", map.get("image"));
                jsonArray.put((Object)jsonObject);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return jsonArray;
    }

    public ArrayList getCriterias() {
        return this.filterRuleFilterIdList;
    }

    public String getDefaultStatusMessage(AdventNetResourceBundle rb) {
        return rb.getString("admp.report.adv_grp_members.stat_msg.selected_groups_empty");
    }

    public int getCurrentTaskCode() {
        return this.currentTaskCode;
    }

    public void updateStatus(JSONArray jsonArray, String domainName) {
    }

    public void updateErrorStatus(Hashtable errors) {
    }

    public ArrayList<Hashtable> getErrorList() {
        return null;
    }

    public JSONObject getMultiDCDetails() {
        return null;
    }

    public void setProperties(String baseTableName, boolean isSyncEnabled, boolean isRowsUpdatedBySync) {
    }

    public void setIsRowUpdatedBySync(boolean isRowsUpdatedBySync) {
    }
}

